#ifndef _ROUTE_H
#define _ROUTE_H

#include "kerbind.h"
#include "if.h"

#define RT_HASH_SIZE		256
#define RT_TTL			100

#define route_deref(_r) { if ((_r) && --(_r)->refcnt <= 0) kfree (_r); }

struct route {
	unsigned long	net;
	unsigned long	mask;
	unsigned long	gway;
	unsigned long	metric;
	struct netif	*nif;
	short		ttl;
	struct route	*next;
	short		flags;
	long		usecnt;
	short		refcnt;
};

#define RTF_UP		0x0001
#define RTF_GATEWAY	0x0002
#define RTF_HOST	0x0004
#define RTF_REJECT	0x0008
#define RTF_STATIC	0x0010
#define RTF_DYNAMIC	0x0020
#define RTF_MODIFIED	0x0040
#define RTF_MASK	0x0080
#define RTF_LOCAL	0x0100

/* This BSD struct is used only for ioctl()'s */
struct rtentry {
	unsigned long	rt_hash;	/* hash key */
	struct sockaddr	rt_dst;		/* key */
	struct sockaddr	rt_gateway;	/* value */
	short		rt_flags;	/* up/down?, host/net */
	unsigned long	rt_metric;	/* distance metric */
	short		rt_refcnt;	/* # held references */
	unsigned long	rt_use;		/* raw # packets forwarded */
	struct netif	*rt_ifp;	/* interface to use */
};

#ifndef NOEXTERNS
extern void		route_init	(void);
extern void		route_flush	(struct netif *);
extern struct route	*route_get	(unsigned long);
extern long		route_del	(unsigned long, unsigned long);

extern long		route_add	(struct netif *, unsigned long,
					unsigned long, unsigned long, short,
					short, long);

extern struct route	*route_alloc	(struct netif *, unsigned long,
					unsigned long, unsigned long, short,
					short, long);

extern long		route_ioctl	(short, long);
#endif

#endif /* _ROUTE_H */
