#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>

int
main (argc, argv)
	int argc;
	char *argv[];
{
	struct sockaddr_in sin;
	int fd, nfd, r;
	static char buf[1000];
	long bytes, lap;

	fd = socket (PF_INET, SOCK_STREAM, 0);
	if (fd < 0) {
		perror ("socket");
		return 1;
	}
	sin.sin_family = AF_INET;
	sin.sin_port = htons (5555);
	sin.sin_addr.s_addr = INADDR_ANY;
	if (bind (fd, (struct sockaddr *)&sin, sizeof (sin)) < 0) {
		perror ("bind");
		return 1;
	}
	if (listen (fd, 10) < 0) {
		perror ("listen");
		return 1;
	}
	nfd = accept (fd, 0, 0);
	if (nfd < 0) {
		perror ("accept");
		return 1;
	}

	bytes = 0;
	lap = time (0);
	do {
		r = read (nfd, buf, sizeof (buf));
		if (r < 0) {
			perror ("read");
			return 1;
		}
		bytes += r;
	} while (r > 0);

	printf ("%ld bytes per second\n", bytes / (time(0) - lap));
	
	if (close (nfd) < 0) {
		perror ("close(nfd)");
		return 1;
	}
	if (close (fd) < 0) {
		perror ("close(fd)");
		return 1;
	}
	return 0;
}
