ARCH = m68k
#DEBUG = true
GCC_DEFAULT = elf

LDSO_ADDR = 62f00000
LDSO_ENTRY = "(0x$(LDSO_ADDR)+32)"

CFLAGS	= -Wall -DVERSION=\"$(VERSION)\"
ifeq ($(DEBUG),true)
STRIP 	= 
CFLAGS  += -DDEBUG -O2 #-DTIMER
else
STRIP 	= -s
CFLAGS  += -O4 #-fomit-frame-pointer
endif
DEBUG_CFLAGS  = $(CFLAGS) -DDEBUG_LIB -g

ifeq ($(GCC_DEFAULT),elf)
AOUTCC = gcc -b $(ARCH)-linuxaout
AOUTAS = /usr/$(ARCH)-linuxaout/bin/as
AOUTLD = ld -m $(ARCH)linux
ELFCC = gcc
ELFAS = as
ELFLD = ld
else
AOUTCC = gcc
AOUTAS = as
AOUTLD = ld
ELFCC = gcc -b $(ARCH)-linuxelf
ELFAS = /usr/$(ARCH)-linuxelf/bin/as
ifeq ($(ARCH),i386)
ELFLD = ld -m elf_i386
endif
ifeq ($(ARCH),m68k)
ELFLD = ld -m m68kelf
endif
endif

ifndef RANLIB
RANLIB = ranlib
endif

