ARCH = m68k
#DEBUG = true
GCC_DEFAULT = elf
AOUT_SUPPORT = true
ELF_SUPPORT = true

LDSO_ADDR = 62f00000
LDSO_ENTRY = "(0x$(LDSO_ADDR)+32)"

CFLAGS	= -Wall -DVERSION=\"$(VERSION)\"
ifeq ($(DEBUG),true)
STRIP 	= 
CFLAGS  += -DDEBUG -O2 #-DTIMER
else
STRIP 	= -s
CFLAGS  += -O4 #-fomit-frame-pointer
endif
DEBUG_CFLAGS  = $(CFLAGS) -DDEBUG_LIB -g

CC = gcc
ifeq ($(GCC_DEFAULT),elf)
ifeq ($(ARCH),i386)
#AOUTCC = gcc -b i486-linuxaout
AOUTCC = /usr/i486-linuxaout/bin/gcc
AOUTAS = /usr/i486-linuxaout/bin/as
AOUTLD = /usr/i486-linuxaout/bin/ld -m i386linux
endif
ifeq ($(ARCH),m68k)
AOUTCC = /usr/m68k-linuxaout/bin/gcc
AOUTAS = /usr/m68k-linuxaout/bin/as
AOUTLD = /usr/m68k-linuxaout/bin/ld -m m68klinux
endif
ELFCC = gcc
ELFAS = as
ELFLD = ld
else
AOUTCC = gcc
AOUTAS = as
AOUTLD = ld
ELFCC = gcc-elf
ELFAS = as-elf
ELFLD = ld-elf
endif

ifndef RANLIB
RANLIB = ranlib
endif

