OKAMI NEWSREADER MANUAL PAGES

NAME
	SMF: single message file database

DESCRIPTION
	SMF (single message file = a single file for every message) is
	one of the two message databases offered by the O system. The
	SMF database is very simple, leaving most data access and
	administration trouble to the operating system, however it is
	quite slow (on a TOS filesystem at least) and wastes some disk
	space (since even a 1 byte message occupies a full cluster,
	i.e. 1 KB on the standard TOS filesystem).

	Every SMF database contains the messages for one newsgroup. It
	resides in a directory, the name of which is constructed from
	the newsgroup name and the base news directory. Example: if
	the base news directory is h:/news and the newsgroup is
	alt.fan.mike-oldfield, the newsgroup directory will be
	h:/news/alt/fan/mike-oldfield (with the last component probably
	being truncated to 8 characters by the operating system, but
	that is not a problem since it is only necessary to construct
	the directory from the newsgroup, never vice-versa).
	In the news directory, every message resides in a single file.
	The name of the file must be a decimal number (no extender
	allowed). This number is called the "file number".

	This is what the UUCP poll software creates from the news packets
	it received from the host.

	To access the files, the SMF database uses an index file containing
	information about every message in the database, like author,
	subject, message flags, and file number. The index file's name
	is "o.idx" in the newsgroup directory.

	The index file is created by the oimport program.

	At runtime, the index file is loaded into memory when a newsgroup
	is opened. When access to the file is required, the message file's
	name is constructed from the newsgroup directory name and the file
	number from the index entry. The file is then accessed via the
	standard file I/O operations.

	Message files may be compressed with the "compress" program.
	Compressed files are identified by their extender ".Z". Before
	being accessed, these files are de-compressed with the compress
	program named in o.inf. oimport allows for automatic compression
	of files that exceed a given size.

EXAMPLE
	Base news directory: h:/news
	Newsgroup name: comp.sys.zx81

	The following files make up the SMF database.

		h:/news/comp/sys/zx81/1			message file
		h:/news/comp/sys/zx81/2			message file
		h:/news/comp/sys/zx81/3			message file
		h:/news/comp/sys/zx81/4			message file
		h:/news/comp/sys/zx81/5.Z		message file, compressed
		(etc.)
		h:/news/comp/sys/zx81/o.idx		index file

SEE ALSO
	- The manual page for oimport.
	- The manual page for O data structures.

DATE
	Nov 14 1993

AUTHOR
	Wolfram Rsler <wr@bara.oche.de>
