OKAMI NEWSREADER MANUAL PAGES

NAME
	oimport: Internet mail/news import program

SYNOPSIS
	oimport.ttp { options } { newsgroup }

DESCRIPTION
	oimport imports all named `newsgroup's. If no newsgroups are
	named, imports all newsgroups from the `news.def' file.
	For every newsgroup, oimport seeks the appropriate news directory
	for files with numeric names (e.g. if the base news directory
	is h:/news and the newsgroup is alt.okami, oimport looks for
	files named h:/news/alt/okami/1, h:/news/alt/okami/123 etc.)
	If files are found, oimport reads them in, scans their header
	(which is ended by the first blank line of the file and must
	conform to the standard RFC1036 Internet mail/news header),
	creates an appropriate entry in the newsgroup's index file (.idx),
	inserts the message into the newsgroup's thread index file
	(.tix) and, if desired, moves the message into the DBF database
	(.dbf and .dbi). If the file is already in the index file, it
	is ignored (i.e. not re-imported and not moved anywhere).

	Also, oimport will look for mailbox files of all users in the
	user list file (passwd). If mailbox files are found (conforming
	either to Hermes >=1.10 or Hermes <1.10 standard, as defined in
	o.inf), the mailbox is read in and the messages are moved into
	the pseudo newsgroup directory Mail.user (where `user' is the
	user name). If the base news directory is h:/news, the Mail
	newsgroup directory for user abc is h:/news/_o_mail/abc.
	This newsgroup is then imported as described above.

OPTIONS
	-b
		New newsgroups are imported as SMF databases, i.e. no
		DBF database is created. Use this only if you have a
		large, fast disk or want to use other programs, e.g.
		GUS or nn, on your news.
	-I
		Delete files immediately after import.
		Normally, oimport first imports all message files into the
		DBF database, then deletes all the files after finishing the
		import. With -I, files are deleted immediately after being
		imported into the DBF. This will save disk space but may
		result in loss of data if oimport is terminated before having
		closed the DBF database. Use this only if you are short on
		disk space.
		-I is without effect on SMF databases.
	-l grp
		Lists the contents of the index file of newsgroup `grp'.
		Does not import anything. No log output will be created.
	-t grp
		Lists the contents of the thread index file of newsgroup
		`grp'. Does not import anything. No log output will be
		created.
	-1 grp
		Lists the contents of the thread index file of newsgroup
		`grp', formatted as a reference tree. Does not import anything.
		No log output will be created.
	-s mode
		Index file entries are sorted as indicated by `mode':
			s	by subject (this is the default)
			d	by message input date
			n	by file number
	-S
		Sorts the index file only. Does not import anything.
	-D
		Recursively searches the news file tree for index files and
		recreates the onews.file from them. No import takes place.
	-K
		Unlocks the given newsgroups. No import takes place.
	-c bytes
		All message files that are greater than `bytes' bytes are
		compressed with the "compress" program named in o.inf.
		Since the DBF database does not support compression, this
		option has an effect only on SMF database newsgroups.
	-f mode
		Defines the message flags that are to be set for newly
		imported messages.
		`mode' may consist of one or more of the following:
			r	read
			k	killed
			p	protected
			l	locked
		If `mode' begins with a plus sign then the flags in `mode'
		will be or-ed with existing flags (for -O only).
		Example: -fr will set all newly imported messages to
		"read".
		The default is to clear all flags (and set the "new" flag
		only).
	-O
		Sets message flags only, according to the flags defined with
		-f.  No import takes place.
	-T
		No threads are created.
	-M
		No mail newsgroups are imported.
	-d
		Uses the files' date-time-stamp to set the messages' import
		date. The default is to use the currend date and time.
	-C
		No dupe check is performed. Messages are not imported into
		the dupe list.
	-n
		Deletes and rebuilds the index files.
		WARNING: this works for SMF databases only. DO NOT USE this
		with DBF database newsgroups.
	-U grp
		Does not import newsgroup `grp'.
	-h
		waits for key press after program termination
	-L n
		sets log level to n (-1 means no logging)
	-v
		prints version number only
	-F file
		uses `file' as o.inf configuration file
	-?
		Prints usage summary only.

ENVIRONMENT
	O_INF
		name of default o.inf file

FILES
	- read only
	  o.inf
	  news.def
	  passwd
	- created/updated
	  *.idx
	  *.tix
	  *.dbf
	  *.dbi
	  onews.def

BUGS
	Re-importing a DBF newsgroup is not yet possible.

DATE
	Nov 14 1993

AUTHOR
	Wolfram Rsler <wr@bara.oche.de>
