OKAMI NEWSREADER MANUAL PAGES

NAME
	Data structures

DESCRIPTION
	The following documentation describes some of O's basic disk-
	based data structures. These are for information, documentation
	and reference only; all of these may change, and if you want
	to write serious software dealing with them, get the O source
	codes. Note, also, that software might change faster than the
	documentation.
	The following data sizes are used:
		int	signed 2 Bytes
		long	signed 4 Bytes
		time_t	unsigned 4 Bytes


	==== Newsgroup index file (.idx) ====

	The index file consists of a header, followed by a variable number
	of entries:
		HEADER
		ENTRY 1
		ENTRY 2
		ENTRY 3
		...
	The header has type DbIdxHeaderTyp and the entries have type DbIdxTyp.

	typedef struct			/* index file header */
	{
	  long Magic;			/* magic number: 'ONR!' */
	  int CompInd;			/* compatibility index */
	  int Network;			/* network identification */
	  char GrpName[12];		/* newsgroup name */
	  int DbType;			/* database type (smf or dbf) */
	  int reserved;			/* reserved for future use */
	  long reserved_too;		/* reserved for future use */
	} DbIdxHeaderTyp;

	typedef struct			/* index file entry */
	{
	  unsigned long MsgPtr;		/* message file number */
	  time_t edate;			/* input date of message */
	  time_t idate;			/* import date of message */
	  struct IdxFlagTyp		/* message flags: */
	  {
	    unsigned read:1;		/* msg was read */
	    unsigned killed:1;		/* msg is going to be deleted */
	    unsigned protect:1;		/* msg will not be deleted/exported */
	    unsigned locked:1;		/* don't affect at global change */
	    unsigned new:1;		/* msg came in at last import */
	    unsigned answered:1;	/* msg was replied-to/f.upped-to */
    	    unsigned xposted:1;		/* msg is crosspost */
    	    unsigned unused:7;		/* reserved for future use */
	    unsigned adef1:1,adef2:1;	/* defined by application */
	  } Flags;
	  char From[22];		/* real name of author */
	  char Subject[70];		/* subject */
	  long tid;			/* thread index id */
	} DbIdxTyp;


	==== Thread index file (.tix) ====

	The thread index file contains all information about threads in
	the newsgroup. It has no header and consists of entries of type
	ThreadTyp.

	typedef struct
	{
	  long id;			/* identification number of entry */
	  long MsgPtr;			/* message file number */
	  char MId[80];			/* Message-ID of message */
	  long o,u,r,l;			/* Thread: id up, down, right, left */
	} ThreadTyp;


	==== Dupe list file (odupe) ====

	The dupe list file contains information about every message in the
	system to help avoid importing messages that have already been
	imported. It consists of entries of type struct dupe.

	struct dupe
	{
	  time_t Dat;		/* creation date of dupe entry */
	  unsigned int size;	/* length of message file */
	  unsigned long midCRC;	/* 32-bit CRC of message ID */
	};


	==== Crosspost data base (oxposts) ====

	The file `oxposts' contains information that enables the newsreader
	to update message flags in crossposted messages; whenever the user
	opens a newsgroup, the newsreader will scan this file and update the
	message flags of that group.
	oxposts is a simple textfile (lines are CRLF-terminated).

	The first line contains a "magic" header (currently "XPost030494").

	The remainder of the file consists of 4-line-entries of the 
	following form:
		<setflags>	e.g. rpk
		<mask>		e.g. rl
		<Message-ID>	e.g. <blahfasel@server.rrzn.uni-hannover.de>
		<Newsgroup>	e.g. comp.sys.atari.st

	When a group's flags are fixed up, only those flags mentioned in
	<mask> are changed: those mentioned in <setflags> are set, the
	others are cleared; this means that <setflags> may be empty, but
	<mask> shouldn't be!
	(In the example above, the r flag would be set and the l flag would
	be cleared; the others are unchanged.)

HISTORY
	14-11-93 wr	created
	20-05-94 wr	updated index type, changed odupe format
	30-05-94 mk	added xpost chapter

DATE
	May 20 1994

AUTHOR
	Wolfram Rsler <wr@bara.oche.de>
