OKAMI NEWSREADER MANUAL PAGES

NAME
	cutlog: cut down log files

SYNOPSIS
	cutlog.ttp { Options } pattern ...

DESCRIPTION
	Deletes all but the last 500 lines from all files that match
	one of the wildcard patterns `pattern'.
	Optionally, deletes lines that are older than a given number
	of days. For that to work, the lines must begin with the date
	in the format "dd Mon yy", where dd is the day number, Mon is
	the first three letters of the month name, and yy is the year.
	Example lines:

		13 Nov 93 18:59:10	Startet "programname"
		13 Nov 93 19:03:23	Terminated, exit code 0

	This is the format created by the O programs.

OPTIONS
	-d dir
		Changes the work directory to `dir'. Wildcard patterns then
		refer to files in that directory.
	-l nlines
		Deletes all but the last `nlines' lines from the files.
		If `nlines' is -1, does not set a limit on the number of
		lines.
		The default `nlines' is 500.
	-a ndays
		Deletes all lines that are older than `ndays' days. Lines
		must begin with the date in the format described above.
		If `ndays' is -1, does not look at the lines' age.
		The default `ndays' is -1.
	-s nbytes
		Ignores all files that are less than `nbytes' bytes long.
		The default is not to ignore any files.
	-q
		Produces no output. The default is to print the name of
		every file as it is processed.
	-W
		Prints a message and waits one second before beginning
		expiration. If within that time the ESC key was pressed,
		terminates without further action.
	-v
		prints version number only. Since cutlog is a general
		utility and in no way affiliated with the O system, it
		has an own version number independent from that of the
		other O programs.
	-?
		Prints usage summary only.

EXAMPLE
	cutlog -l -1 -a 10 -s 5000 -d h:/log *

		This processes all files in the directory h:/log that are
		greater than 5000 bytes, deleting all lines that are older
		than 10 days. There is no limitation on the number of lines
		left in the file.

DATE
	Nov 14 1993

AUTHOR
	Wolfram Rsler <wr@bara.oche.de>
