@echo off
::
:: This is a good template for using FFG with program that accepts a file
:: list for input.  Archiving programs such as PKZIP and LHA also accept
:: such lists.
::
:: Explanation of FFG paramters used below:
::
::  /fp    - use packed path output format e.g. C:\dir\file.nam
::  /qfm   - quiet: suppress all output but spinning meter and found files
::  /p0    - ensure no pauses for each screen page (may be set in envirnment)
::  > LHA.LST - puts all output in a file LHA.LST which pE will use.
::
if %2.==. goto USAGE
  echo Searching for files to archive...
  ffg /fp /qfm /p0 > C:\LHA.LST %2 %3 %4 %5 %6 %7 %8 %9
  if errorlevel 101 if not errorlevel 102 goto INT_FOUND
  if errorlevel 100 if not errorlevel 101 goto INT_NONE
  if errorlevel 1   if not errorlevel 2   goto FOUND
  :: 1 = 1 or more found
  :: 0 = none found
  :: 10x = same as above but with search interrupted by user
  goto NONE_FOUND
:INT_NONE
  echo.
  echo WARNING!: Search interrupted by user, more files may exist.
  pause
:NONE_FOUND
  echo.
  echo No files found.
  goto END
:INT_FOUND
  echo.
  echo WARNING!: Search interrupted by user, more files may exist.
  pause
:FOUND
  echo Preparing to archive files...
  :: LHA now uses LHA.LST file created by FFG to load files into editor:
  lha u /p /a /x %1 @c:\lha.lst
  goto END
:USAGE
  echo.
  echo %0:
  echo.
  echo Search for and then archive a file or group of files using FFG as the
  echo search engine and LHA as the archiver.
  echo.
  echo USAGE: %0 ArchiveName FFGFileSpec [FFG Options]
  echo.
  echo   Commas cannot be used in FFGFileSpec use '/' instead as in example.
  echo.
  echo Example: %0 cde:*.[txt/doc] /$"some text to find" /d94 /s0-100k
  echo.
:END
  if exist c:\LHA.LST del c:\LHA.LST
