@echo off
::
:: Makes archive backups of your system configuration files for each drive.
::
:: For each disk drive on your system (actually only for drive letters that
:: appear in the list below in the 'for' statement), batch file makes an
:: archive file of all config files on that drive.
::
:: - It requires the free LHA archiving utility.
:: - The file CFGFILTR.FFG must exist in the current directory.
::   CFGFILTR.FFG has all the FFG options to search for config files.
:: - It makes directory C:\CONFIG to hold the config file archives
::
:: - PKZIP would also work except it has problems handling large list files and
::   results in out-of-memory errors if the list file is bigger than a few K.
::
if "%1"=="DO_DRIVE" goto DO_DRIVE
  if not exist c:\config\nul md c:\config
  :: Get CFGFILTR.FFG in the right place:
  if not exist CFGFILTR.FFG goto END
  if     exist c:\config\nul copy CFGFILTR.FFG c:\config
  ::
  :: Put your drive letters in the following list in parenthesis:
  ::
  for %%f in (c d e f) do if exist %%f:\nul call %0 DO_DRIVE %%f
  goto END
::-----------------------------------------------------------------------------
:DO_DRIVE
::
:: This section does the individual drive stuff, where %2 is the drive letter:
::
  if "%2"=="" goto END
    %2:
    echo Searching for configuration files on drive %2: to put in list "cfglst.%2"
    ffg < c:\config\cfgfiltr.ffg > c:\config\cfglst.%2
    ::
    :: Here we use LHA to do the archiving:
    ::
    echo Archiving configuration files listed in "cfglst.%2" for drive %2:
    lha u /p /a /x c:\config\cfgdrv_%2 @c:\config\cfglst.%2
::
:: Could have used PKZIP if it didn't run out of memory with large ZIP lists:
::
::    if not "%3"=="ZIP" if not "%3"=="zip" goto NO_ZIP
::      echo Archiving configuration files listed in "cfglst.%2" for drive %2:
::      pkzip -P c:\config\cfgdrv_%2 @c:\config\cfglst.%2
:END
