// vcview.cpp : implementation of the CVcView class
//

#include "stdafx.h"
#include "vc.h"

#include "vcdoc.h"
#include "vcview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVcView

IMPLEMENT_DYNCREATE(CVcView, CFormView)

BEGIN_MESSAGE_MAP(CVcView, CFormView)
	//{{AFX_MSG_MAP(CVcView)
	ON_VBXEVENT(VBN_TURN, IDC_KNOB2, OnTurnKnobLeft)
	ON_VBXEVENT(VBN_TURN, IDC_KNOB3, OnTurnKnobRight)
	ON_VBXEVENT(VBN_TURN, IDC_KNOB4, OnTurnKnobFront)
	ON_VBXEVENT(VBN_TURN, IDC_KNOB5, OnTurnKnobRear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcView construction/destruction

CVcView::CVcView()
	: CFormView(CVcView::IDD)
{
	//{{AFX_DATA_INIT(CVcView)
	m_knobrear = NULL;
	m_knobfront = NULL;
	m_knobright = NULL;
	m_knobleft = NULL;
	m_knob1 = NULL;
	//}}AFX_DATA_INIT
	// TODO: add construction code here
}

CVcView::~CVcView()
{
}

void CVcView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVcView)
	DDX_VBControl(pDX, IDC_KNOB5, m_knobrear);
	DDX_VBControl(pDX, IDC_KNOB4, m_knobfront);
	DDX_VBControl(pDX, IDC_KNOB3, m_knobright);
	DDX_VBControl(pDX, IDC_KNOB2, m_knobleft);
	DDX_VBControl(pDX, IDC_KNOB1, m_knob1);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CVcView diagnostics

#ifdef _DEBUG
void CVcView::AssertValid() const
{
	CFormView::AssertValid();
}

void CVcView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CVcDoc* CVcView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVcDoc)));
	return (CVcDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVcView message handlers

void CVcView::OnTurnKnobLeft(UINT, int, CWnd*, LPVOID)
{
float value,maxvalue;

	value=m_knobleft->GetFloatProperty("KnobValue");
	maxvalue=m_knobright->GetFloatProperty("ScaleMaxValue");
	m_knobright->SetFloatProperty("KnobValue",maxvalue-value);  
	  
}

void CVcView::OnTurnKnobRight(UINT, int, CWnd*, LPVOID)
{
float value,maxvalue;

	value=m_knobright->GetFloatProperty("KnobValue");
	maxvalue=m_knobleft->GetFloatProperty("ScaleMaxValue");
	m_knobleft->SetFloatProperty("KnobValue",maxvalue-value);  
	
}

void CVcView::OnTurnKnobFront(UINT, int, CWnd*, LPVOID)
{
float value,maxvalue;

	value=m_knobfront->GetFloatProperty("KnobValue");
	maxvalue=m_knobrear->GetFloatProperty("ScaleMaxValue");
	m_knobrear->SetFloatProperty("KnobValue",maxvalue-value);  
	
}

void CVcView::OnTurnKnobRear(UINT, int, CWnd*, LPVOID)
{
float value,maxvalue;

	value=m_knobrear->GetFloatProperty("KnobValue");
	maxvalue=m_knobfront->GetFloatProperty("ScaleMaxValue");
	m_knobfront->SetFloatProperty("KnobValue",maxvalue-value);  
	
}
