.f3                              - # -              Appendix G - Trouble Shooting
.rm70
.tc
.tc G. TROUBLE SHOOTING ...................................#
APPENDIX G   TROUBLE SHOOTING

Sometimes things do not happen quite the way you imagined they would.
This section covers commonly asked questions, as well as a list of
error messages and what they mean.{.}
{.}
.tc    Questions ..........................................#
Questions

.RRL W     !       !       !       !       !       !       !       !    R
Q I can't seem to change the line spacing even though I select a new
  line height{.}
  {.}
A To print using a different line spacing, say double line spacing or
  perhaps 8 lines per inch instead of 6 lines per inch. This can be
  done from the Margins sub menu of the Options menu (F10 O M S), from
  the print menu itself, or by embedding .LH dot commands in your
  text.{.}
  {.}
  They all alter the line spacing on the printer by the same
  technique- they change the actual height of the line that the
  printer uses. Different printers use different units to measure the
  line height. The old standard was 1/48th inches so that 6 lines per
  inch was 8 units, while 8 lines per inch was 6 units, and double
  line spacing was 16 units. Modern printers use 1/60 inches, 1/72
  inches, and sometimes 1/180 inches or even 1/360 inches.{.}
{.}
  If you use the .LH dot command, then you must insert the correct
  number of units, as well as tell Word Fugue their magnitude.{.}
  {.}
  For Example:{.}
                  .LH 12/72       6 (6 lines per inch in 72nd inch){.}
                  .LH 9/72        8 lines per inch{.}
                  .LH 20/60       3 lines per inch (double spacing){.}
  {.}
  The first number is the number of units, the second is their
  magnitude.{.}
  {.}
  For this to work you must also have the correct sequence set up in
  the PDF you are using. If you go to the print menu (^KP) and then
  Edit the printer sequences, look at the one that says "Line Height".
  (Chapter 16 tells you how to edit a Printer Definition File). The
  sequence will include either a # character or a $ character. Word
  Fugue will replace this character by the number of units in the line
  height command.{.}
  {.}
  In the Epson LQ2500, one of the line height sequences is <ESC>An
  where n is the desired height in 1/60 inch. It requires that n be a
  binary number, so you would enter the sequence <ESC> A # into your
  "Line Height" sequence (without the intervening spaces). The #
  indicates to Word Fugue that it should replace it with a binary
  number for line height.{.}
{.}
  If you have a Laserjet emulation, the sequence is something like
  <ESC>&l$C where $ indicates that the height is a character
  representation of the number.{.}
{.}
  If the sequence includes a '#', it will be replaced by the decimal
  equivalent of the number following the .LH command. Thus .LH 20/60
  with a sequence of <ESC>A# would send <ESC>A<Ctrl T> to the printer.
  <Ctrl T> is the printable equivalent of decimal 020. If the number
  is bigger than one character, the low byte comes first thus
  <ESC>Amn where the number = m + 256*n. This is the format that most
  printers expect.

  If the sequence includes a '$' sign, it will be replaced by the
  character representation of the number itself. Thus .LH 20/60 with a
  sequence of <ESC>&l$C would send <ESC>&l20C to the printer.{.}
  {.}
  If you use either the Margins submenu or the Print menu, then Word
  Fugue will send the appropriate sequence to the printer as described
  above. BUT the program will have to calculate the correct decimal
  value to send, and this depends upon the units. The default value is
  1/48th inch unless specified otherwise. If this is not the correct
  unit for your printer, then you must specify the correct value for
  it in your PDF.{.}
  {.}
  All PDFs will have a value stored, and if you activate the Print
  Menu, you will see the initial setting and units displayed:{.}
     Initial line size  Normal = 6 lines per inch  (.LH 8/48){.}
  If this is the incorrect value, then you will need to change it. The
  appropriate slot is the one immediately underneath the Line Height
  slot - it should be marked LH unit 1/n inch, but if you are using a
  PDF from a previous version, it may be marked Reserved{.}
  {.}
  When you edit this slot, change the value displayed to the one you
  want - for 1/60 th inch you would enter 60{.}
  {.}
  If you edit your PDF and make changes, do not forget to save them,
  or they will be lost when you exit the program.{.}
  {.}
  If you do not want to change the PDF yourself, then please contact
  Fugue Software. You should be prepared to furnish us with a copy of
  the relevant parts of your printer manual so that we can configure a
  PDF for you. {.}
{.}
{.}
Q Can I mix Landscape and Portrait mode in the same document?{.}
{.}
A Yes, as long as your printer is capable of both Portrait and
  Landscape printing. You need to do the following things:{.}
  {.}
.RRL !  W  !       !       !       !       !       !       !       !    R
  1. The first line of the page that is to start Landscape printing
     you should insert a Page Length dot command (.PL n) with the
     appropriate value of n for the landscape pages.If you do not do
     this then Word Fugue will still paginate the document as for
     portrait mode{.}
     {.}
     For Example:{.}
         US Letter size paper is 66 lines long in portrait mode, but
         only 48 lines long in Landscape mode. If you were using this
         paper, you would insert .PL 48 as the first line of the page.{.}
         {.}
  2. Check you PDF to see whether a sequence for swapping to and from
     landscape mode has been defined. If not, then you should select
     one of the spare sequences, and edit them so that the ON sequence
     selects Landscape mode, and the OFF sequence selects Portrait
     mode.{.}
{.}
  3. Insert the code for the sequence into the start of the next line.
     If you are using Headers, you will need to include it as the
     first character in the header line. This means that you will need
     to define a separate header for the Landscape pages.{.}
     {.}
     At this point you should be able to print some pages in Landscape
     mode{.}
     {.}
  4. On the first page that you want to print in portrait mode after
     the landscape pages you need to reverse the procedure you used to
     set up landscape mode:{.}
     {.}
      First line should change the page length back to 66 lines (or
       whatever you are using) with the .PL command. {.}
      Insert the same control code that you inserted to start
       landscape printing. The second occurrence will turn it OFF{.}
    {.}
.RRL W     !       !       !       !       !       !       !       !    R

Q My line drawing characters (or European characters) appear on the
  screen, but they print as italic characters.{.}
  {.}
A If you have a laser printer, you should check that you have selected
  the correct font for printing. Most laser printers will allow you to
  print out all the available fonts. You will need to select the
  appropriate font for these characters to work. If necessary, you can
  insert a print control code for the correct font before the
  characters you want to print, and then switch back to the original
  font when you have printed these characters. If your whole document
  includes European characters, you should select the correct font
  before you start. You may even need to read your printer manual so
  that you can set up copies of the font in italic and bold.{.}
  {.}
  If you have a dot matrix or similar, not only should you check that
  the printer is capable of printing these characters - you may need
  to change some switch settings so that they will print. Most dot
  matrixes have a mechanism whereby you can print italic characters or
  graphic & European characters, but not both without some software
  switching. It is an unfortunate fact that if you select any 3
  supposedly identical printers that one will be different from the
  other two.{.}
  {.}
  The EPLQ2500.PDF for Epson compatible printers includes code during
  the Initialise sequence to set graphics characters (<ESC>t<CtrlA>).
  In order to print italics, it must switch off the graphics
  characters, then set italic characters (<ESC>t<NULL><ESC>4) and
  conversely when italics are deselected, it must turn off italics and
  reselect graphics (<ESC>5<ESC>t<CtrlA>). If your printer is not Epson
  compatible, then you cannot use these sequences, but must use the
  correct ones for your printer.{.}
  {.}
  If your PDF does not include these sequences, then you will need to
  include them.{.}
  {.}
  If you do not want to change the PDF yourself, then please contact
  Fugue Software. You should be prepared to furnish us with a copy of
  the relevant parts of your printer manual so that we can configure a
  PDF for you. {.}
{.}
{.}
Q Sometimes there is a blue box around the screen, and sometimes there
  isn't.{.}
  {.}
A This is actually the same colour as the status line. Many people
  like it - they feel it defines the area of the screen available for
  editing. It is set up for each of the standard screen sizes.
  However, if you switch to X - Use Start up size, the program will
  not set up the border. {.}
  {.}
  You can make it disappear by changing the status line to anything on
  black (eg green on black), saving the setup, and then selecting your
  current display size again. Alternatively, you can set the default
  display size to X (accept screen as is on start up), save the setup,
  and restart. Of course you won't be able to use 28 x 80, since the
  box will reappear when you switch to that mode. You could also try
  changing it to the same colour background as the text (ie anything
  on blue), and it will blend in with the text.   {.}
{.}
{.}
Q I see the Standard macro file has macros to replay a line drawing
  character. However, I want to replay the same character several
  times, and the "replay multiple times" command does not give me what
  I want{.}
  {.}
A If you want to replay a single line drawing character once, you
  would use the entries you were selecting, BUT by pressing ALT 0 not
  ALT - (the 0 next to the - key above the letters, NOT the 0 key in
  the numeric keypad) to select a single replay of the macro, which
  will load the line drawing macro file, allow you to select one
  character, replay that character, and then re-load WF.MAC. (To get
  technical, this is why they will not work in multiple replays - they
  are macros that load macro files and then replay macros contained
  within the new macro file, before reloading the old macro file -
  rather complicated). They were intended for when you wanted to
  insert only one character, and did not want to go through the hassle
  of loading the second macro file etc manually. They also serve as an
  example for other similar situations when you want to create your
  own macros.

  What is happening is that several copies of the selected macro are
  being pushed into the keyboard buffer, instead of several copies of
  the line drawing character, which is what you really want.

  The Solution

  Firstly, you need SINGLE.MAC or DOUBLE.MAC loaded before you can
  replay them many times. Press Alt L and you will be prompted with
  the name of the macro file to load. You will need to type in the
  name including the Word Fugue directory name:

    eg C:\WF\SINGLE.MAC

  or type in the Word Fugue directory name followed by a file name
  mask

    ie  C:\WF\*.MAC

  which will allow you to select the macro file you want from the
  list. Once you have loaded the new macro file, pressing ALT - will
  give you the results you are looking for. You will see a list of
  possible line drawing characters to select from.

  Note that the other macros will not be available while you have the
  line drawing macros loaded. You will need to reload WF.MAC when you
  want to use them.
{.}
{.}
Q Word Fugue sometimes comes up in black and white instead of colour{.}
  {.}
A Word Fugue interrogates BIOS to determine whether you system is set
  to colour or black and white. If BIOS reports that the system is
  black and white, Word Fugue will load in Black and White. You will
  find that this happens after running one particular program, which
  will be switching your machine back to black and white before it
  exits.{.}
  {.}
  The solution is to use the DOS MODE command to switch back to
  colour:{.}
  {.}
        MODE CO80{.}
        {.}
  before you start Word Fugue after you have run the program that
  switches to black and white.{.}
  {.}
  {.}
Q I have a black and white monitor, but sometimes Word Fugue comes up
  in shades of grey that is difficult to read.{.}
  {.}
A This is the corollary of the question above. Some program is
  switching your machine to colour, and Word Fugue detects that and is
  coming up in colour (but your monitor shows the colours as shades of
  grey).{.}
  {.}
  Use the DOS MODE command to change the display mode back to black
  and white before loading Word Fugue:

      MODE BW80         for black and white  (try this one first)
      MODE MONO         for monochrome (works the same as black and
                        white, but different)

  you may find that one command gives you the results you want, while
  the other does not. (You may even see a blank screen for mode mono
  if your card cannot handle this.)

  Alternatively, run Word Fugue with the parameter /B to tell it to
  use black and white colours regardless of the monitor card mode.

           WF *.* /B{.}
      or   WF letter.txt /B{.}
      or   WF /B{.}
{.}
{.}
.CP5
Q When I start Word Fugue, it comes up with a blank screen. Then I
  select Open Another Window to open a file for editing, and the file
  comes up in the bottom half of the screen only.{.}
  {.}
A When you run Word Fugue, it loads with an empty work space titled
  <none>, which means that there is no associated disk file. This
  occupies the first window. If you then press F10 F O you are
  requesting it to "Open Another window", which is why you see the
  second window on screen.

  What you should be doing is:{.}
  either

  1.    WF MYFILE{.}
  or{.}
  2.    WF {.}
        F3 {.}
        MYFILE{.}
        enter{.}

  Option 1 will load Word Fugue with a work space titled MYFILE. If
  the file already exists on disk, it will be read in. If the file
  does not already exist, you will see an empty window ready for you
  to type your file.

  Option 2 will load Word Fugue with the un-named work space <none>,
  and then command it to replace that with a file called MYFILE. As in
  option 1 the file will be loaded if it exists, otherwise you will
  see an empty workspace.

  Pressing function key F3 achieves the same effect as pressing F10 F
  N for New file in this workspace. If the existing contents have been
  modified (you will see a  beside the file name) you will be asked
  whether you want to save the existing file before loading a new
  file.
                            {.}
{.}
Q I can't get any different fonts like italic or underlining to print.
  Sometimes I also get garbage printed.{.}
                                       {.}
A You are using the wrong printer driver. It is an unfortunate fact
  that different brands of printers require different printer drivers.
  Unless you tell it otherwise, Word Fugue comes configured for a
  standard Epson printer, which is the most common printer around.

  You need to know the brand of your printer, and possibly the command
  set it uses. Many of the lesser known printers copy the command set
  from a better known printer, sometimes accurately, sometimes with
  inaccuracies, which makes life difficult when we try to support a
  number of different printers.

  If you call up the print menu (F10 F P or ^KP), you will see one of
  the entries is "Which printer". The text beside it probably reads
  "EPSON.PDF". Press "W" to change that value. You should be prompted
  with

     D:\WF\*.PDF

  Each of the printer drivers for Word Fugue are stored in their own
  files, with the extension set to ".PDF" for Printer Definition File.
  If you press Enter at the prompt, you should see a list of printer
  definition files. Highlight one with a name close to that of your
  printer (or its emulation). The descriptions on the right hand side
  should help. Once you have highlighted one, press Enter to select
  it. {.}
  {.}
.RRL !    W        !       !       !       !       !       !       !    R
  Note you may need to change to the directory in which you installed
       Word Fugue if you are currently in a different directory and
       you have never installed the Home Directory. If the Home
       Directory is installed, Word Fugue will look there, otherwise
       it will look in the current directory.{.}
.RRL W     !       !       !       !       !       !       !       !    R

  Now you will be back at the print menu. You should test your chosen
  PDF to see if it works better. (If it doesn't, try another one).
  Once you are satisfied that you have selected a PDF that works, you
  should save the configuration (F10 O S) so that Word Fugue will use
  it next time you run the program.

  If this doesn't solve the problem, or you cannot find a PDF that
  resembles your printer name, we may need to configure a PDF for you.
  You will need to send us your printer manual (you will get it back!)
  or a photo copy of it. We will send you a PDF configured to work
  with your printer. You would install it as described above.

{.}
Q I keep pressing Enter at the end of a paragraph, but when I reformat
  the paragraph the lines below get "sucked up" into it.{.}
  {.}
A There are essentially 2 methods of delineating a paragraph - some
  programs expect a single carriage return, while others expect a
  double carriage return. By default, Word Fugue is one of the latter.

  With the former, you press Enter part way through a paragraph, and
  wonder why the rest of the paragraph never reformats, while with the
  latter you press enter to start a new line, and wonder why it
  becomes included with the previous line (or the line below). It is a
  stylistic matter, so of course most people love one and hate the
  other.

  However, you can change Word Fugue's behaviour by the use of the
  "Enter gives paragraph" option on the Format Options sub menu of the
  Options menu. (F10 O F E) This toggles the behaviour of the Enter
  key so that pressing Enter will insert a paragraph mark into the
  text. Paragraph marks denote the end of a paragraph for formatting
  purposes, just as a blank line would. Paragraph marks display on
  screen.{.}
  {.}
  This won't of course change any paragraphs you typed prior to
  changing the option, but you can go back and insert paragraph marks
  by using the command Ctrl J J. This will insert a paragraph mark at
  the cursor location, so you should ensure that the cursor is at the
  end of a line.{.}
  {.}
  If you change Word Fugue's configuration, don't forget to save it!{.}
  {.}
  {.}
Q Sometimes when I run Word Fugue, it complains that it cannot find
  the help file or the dictionary file.{.}
  {.}
A You have probably changed from the Word Fugue directory to another
  one containing your documents, and you haven't told Word Fugue where
  to find its files.  You do this by installing Word Fugue's "Home
  Directory".

  To install the home directory, start the program from the Word Fugue
  directory. Press F10 O G (Pull down menu, Options, Global options).
  If the line "Home directory" has nothing following it, then none is
  installed. Press H for home directory. You will see a prompt with
  the directory name. Press Enter to accept that, then press ESC to
  return to the Options sub menu. Press S to save your set-up. When
  you receive the confirmation message, you can press ESC 3 times to
  return to the edit screen.

  A further thing to check whether you have been saving external
  configuration files in different directories. If the Global Option
  "Save configuration file" is ON, then the configuration will be
  written to a file called WF.CFG in the current directory. (This is
  intended for when you want different configurations in different
  directories, but you MUST install the home directory first.) If you
  start the program in a directory containing a WF.CFG, that stored
  configuration will override the one you saved with the home
  directory. If this second config file does not contain an installed
  home directory, you will still have problems.{.}
  {.}
  If you haven't installed the home directory, then once you do you
  should delete all the other WF.CFG files that may be in other
  directories. You can create them again afterwards. Alternatively,
  you can turn them off by use of the Global Option "Config file
  WF.CFG" (F10 O G C). Turning this off stops Word Fugue from using
  configuration files. Be sure to Save Setup after you change this.{.}
  {.}
  {.}
Q I make changes to my Word fugue setup, but sometimes they seem to
  get lost{.}
  {.}
A Word Fugue saves its configuration into a file called WF.CFG in the
  current directory. This means that if you use different directories,
  saving the configuration in one directory will not change that
  stored in another. This feature was demanded by a number of people.
  If you only need one configuration, then you should turn off the use
  of the external configuration file. This is in the Global Options
  menu (F10 O G C). Be sure to Save Setup after this.{.}
  {.}
  {.}
Q What are the label macros in the WF.MAC file?{.}
  {.}
A These macros are activated by ESC F, ESC G, ESC H and ESC I. They
  are intended for printing address labels on sticky labels. They are
  assumed to be one label across, and 1" deep. They are intended to
  be used, but if you have different size mailing labels, you will
  need to change the parameters that the file sets up.

  ESC F creates a file containing the control commands for label
  printing - labels will not print correctly unless you have the
  correct page length set. The macro sets a page length of 9 lines,
  which corresponds to 1" labels. If you have labels of a different
  size, you need to change the page length to the appropriate size.

  ESC G copies a marked block to the label file, and sets it up as a
  page. You would block mark the address you have typed, such as your
  address at the front of this letter, and then ESC G would copy it to
  the label file. You would normally do this if you are writing
  several letters - as you write each letter, the addresses are
  accumulated in the label file.

  ESC H will print the file containing the labels - you should first
  load up your printer with the appropriate sticky labels. You would
  normally do this once you had written and printed all the letters
  you intended to write at that time.

  ESC I will delete the labels from the label file, leaving only the
  control lines. You would do this once you had printed your labels,
  to leave the file ready for the next time.

  If you have 2 or 3 labels across, you should change the .PA in the
  macros to .CB for column break. You will also need to define snaking
  columns in the file creation parameters.{.}
  {.}
  For example:{.}
          .co 2,5 / 35,35{.}
  for 2 columns of text 35 characters wide, with a gutter of 5
  characters between them.{.}
  {.}
  The column break command will cause each new label to be pushed into
  the next column, so that they will print across the page. You could
  also print them down the page by deleting the .PA and not using the
  .CB commands.{.}
  {.}
  {.}
Q How do I obtain a preview of my Printing?{.}
  {.}
A You use the PREVIEW.PDF printer definition file, and print your text
  to a file. You can then load that file to see how the text would
  actually print. You can also use this functions with the "real" PDF
  to create a file that can be copied to a printer at a later time,
  but the print control sequences might get in the way.

{.}
Q Sometimes I see little vertical bars in the Ruler line, and when
  that happens the paragraphs do not seem to reformat properly.
  Several other things seem not to work properly either{.}
  {.}
A You are operating the program in Multicolumn mode - the vertical
  bars you see and the "Tbl R" or "Tbl I" in the upper right corner
  give this away.{.}
{.}
  Multi column mode is used for 2 purposes:{.}
    1.   Moving columns of text around the file{.}
    2.   Defining multiple columns of text on screen. (Tables){.}

.CP5
  You only operate in multi column mode if you have defined tables in
  the ruler line, and you want to wrap each column of text separately,
  yet have the table entries line up.{.}
{.}
  If you press Ctrl KN, you will turn this mode off. This will "fix"
  the following problems:{.}
.RRL  !     W      !       !       !       !       !       !       !    R
   1.    Enter inserts a line above the cursor if in column 1, and
         below the cursor otherwise{.}
   2.    Justification problems - you weren't justifying the paragraph
         as you thought, but were justifying a column of text{.}
   3.    Problems marking text with the mouse - you can only mark a
         columnar block of text with column mode on.{.}
   4.    Assorted cursor positioning problems and block copy/move
         problems. {.}
.RRL W     !       !       !       !       !       !       !       !    R
{.}
.tc    Messages ...........................................#
Messages

  This defines the error messages that Word Fugue may put out from
  time to time.{.}
  {.}


.RRL   W   !       !       !       !       !       !       !       !    R
  ** Warning VGA modes are NON standard **           {.}
    The instructions used to achieve non standard line and screen
    sizes may not work on your monitor. You are advised to test them
    with no files loaded, just in case your machine locks up.{.}

  .DF - no file name specified                       {.}
    You included a dot command to define a mail merge file of data,
    but did not specify the name of the file. The format is{.}
        .DF  filename{.}

  .SV - invalid format specifier                     {.}
    You included a format specifier in the Set Value dot command, but
    it is not valid. Refer to Mail Merge for more information{.}

  Abort printing? (Y/N)                              {.}
    You have requested the print menu be displayed, but you are
    already printing in background. Y will abort the printing and
    display the menu, N will ignore the menu request and continue
    printing.{.}

  Aux dictionary @@@@@@@ not found                   {.}
    The auxiliary dictionary could not be found. The characters @@@@@@
    will be replaced by the name of the file Word Fugue was seeking.
    The name of the auxiliary dictionary can be set from the Lexicon
    names sub menu of the Options menu. (F10 O L A){.}

  Cannot create another window now                   {.}
    You already have 8 windows open, you cannot open another.{.}

  Cannot create index file                           {.}
    The disk may be full, or your DOS FILES setting may be too low. It
    should be at least 20{.}

  Cannot Open File To Generate TOC for               {.}
    You requested a Table of Contents generation, but Word Fugue could
    not locate the file name you specified. Please check its spelling{.}

  Cannot Open File To Index                          {.}
    You requested an Index generation, but Word Fugue could not locate
    the file name you specified. Please check its spelling{.}

  Cannot open include file @@@@@@@@                  {.}
    Table of contents, Indexing or printing will process files
    specified in .FI (file include) commands. However, the file name
    @@@@@@@@ could not be found. Please check all your file include
    statements{.}

  Cannot play back macro while recording             {.}
    You are currently recording a macro. If you really do want to
    replay a second macro, you must edit your macro after you have
    recorded it.{.}

  Cannot read from a device                          {.}
    You specified a file name that DOS has reserved as a device
    identifier, and that device is output only, such as PRN.{.}

  Command aborted                                    {.}
    You pressed ^U to abort a command such as index generation or
    table of contents generation.{.}

  Cursor must be in marked block                     {.}
    The block operation you requested requires that the cursor be
    within the marked block. This is to prevent you from inadvertently
    changing the block when it is not being displayed{.}

  Default extension may not contain wildcards        {.}
    The default file extension for files that you create must be 1,2
    or 3 characters. The extension will be added to each file you
    create unless you specify an extension (or . for no extension). It
    makes no sense to use wild cards here.{.}

  Dictionary @ not found                             {.}
    The main dictionary could not be found. The characters @@@@@@ will
    be replaced by the name of the file Word Fugue was seeking. The
    name of the main dictionary can be set from the Lexicon names
    sub menu of the Options menu. (F10 O L M) It is probable that you
    have not installed the Home directory where Word Fugue will look
    for its support files.{.}

  Disk read error                                    {.}
    DOS reported a read error on the disk. Your file is probably
    corrupted. You should probably throw away the disk and use another
    one. You may need to resort to some file recovery utilities in
    order to recover your text.{.}

  Disk write error occurred                          {.}
    DOS reported a write error on the disk. The write operation is
    aborted. If the disk is full, please insert another one and try
    saving the file again. If you need to format the disk, you will
    need to turn off AUTOSAVE, set Invoke Dos to Available memory, (so
    that Word Fugue does not try to write anything to the disk), and
    then shell to DOS to run the format command.{.}
    {.}
.CP5
    It is also possible that the disk has bad tracks or sectors. In
    this case you should probably throw the disk away.{.}

  Divide by zero                                     {.}
    Your calculation encountered a divisor of zero, which gives an
    undefined result. Please check your formula.{.}

  DOS critical error - Device not ready              {.}
    If this occurs during a file read or write, you will need to have
    your machine serviced. If you have just started writing or reading
    a floppy, check that the drive door is closed{.}

  Error in level number in menu data file            {.}
    The WF.EXE file has been corrupted. Please reinstall from your
    original disks.{.}

  Error Reading Config File - DELETE & rerun         {.}
    The file WF.CFG was found, but it did not contain a valid internal
    identifier. Word Fugue will delete the file, but you must rerun
    the program. The reason is that the file is used to update the
    internal configuration, and the copy of the program in RAM may
    have been corrupted.{.}

  Error reading help index                           {.}
  Error reading help text                            {.}
    The file WF.HLP has been corrupted. You should copy it from the
    original disks, OR run WFINST to regenerate it from the WF.TXT
    file. Refer to Appendix B for more information.{.}

  Error reading MM data file                         {.}
    The Mail Merge Data file was opened, but an error was encountered
    during reading. The file may be corrupt.{.}

  Error reading print file                           {.}
    The file to be printed was opened, but an error was encountered
    during reading. The file may be corrupt.{.}

  Error writing print output file                    {.}
    The print spool file was opened for output, but an error was
    encountered during writing. The disk may be full, or it may be
    corrupt.{.}

  Error writing to configuration file                {.}
    The configuration file WF.CFG was opened for output, but an error
    was encountered during writing. The disk may be full, or it may be
    corrupt.{.}

  Expected open paren                                {.}
    The formula you specified appears to be missing an open
    parenthesis ( at the cursor location. Please check that your
    brackets match.{.}

  Expected operator                                  {.}
    The formula you specified needs an arithmetical operator at the
    cursor location. Please check your formula. Note that
    multiplication is signified by * and not x!{.}

  Expected operator or closed paren                  {.}
    The character encountered should not appear at this position in
    the formula as specified. You are probably missing a closing
    bracket or an arithmetic operator{.}

  Factorial overflow                                 {.}
    The expression of Fact(n) is too large. The largest value that
    Word Fugue can handle is approx 1.1*10^4932, which should be more
    than adequate for most calculations. If you really do need numbers
    this large you should probably get a special purpose program.{.}

  Fatal Runtime Error - Closing Files & Aborting     {.}
    If you get this, we need to know about it. The program has
    crashed, and is trying to save your files, but there is no
    guarantee that this will be successful. Press Enter or Esc to
    continue the termination process. When you are returned to the dos
    prompt, you will see a message like {.}

        Run time error ### @ xxxx:yyyy{.}
        {.}
    Please write these numbers down, as well as some explanation about
    what you were doing at the time, and send it to Fugue Software at
    the address specified in the manual. Please also include your own
    name and a contact address so we can get in touch with you.{.}

  File access denied                                 {.}
    The file you tried to write to is marked as Read Only, or System
    by DOS, or you are on a network, and someone else has opened the
    file for writing.{.}

  File creation error or directory full              {.}
    The disk may be full, or you are running in the root directory and
    you have too many files. You should move some files to
    subdirectories. The root directory on any disk has DOS imposed
    limits on the number of files it can contain. For a 360k floppy
    this only 112 files.{.}

  File Error writing TOC file                        {.}
    The disk may be full, or your DOS FILES setting may be too low. It
    should be at least 20{.}

  File exists!  Append or Overwrite                  {.}
    You requested a block of data be written to disk, or that the
    entire file be saved under another name. That file already exists.
    Your options are to Append the data to the end of the file, or to
    Overwrite the file with the new data.{.}

  File not found                                     {.}
    You requested to read a file into your text, but that file could
    not be found. It may be in another directory, on another disk, or
    you may have misspelled it. Try the wildcards *.* and explore the
    directories on your disk to see if you can locate the file.{.}

  Floating point overflow                            {.}
    The expression you are trying to calculate is too large. The
    largest value that Word Fugue can handle is approx 1.1*10^4932,
    which should be more than adequate for most calculations. If you
    really do need numbers this large you should probably get a
    special purpose program.{.}

  Floating point underflow                           {.}
    The expression you are trying to calculate is too close to zero to
    process. The smallest value that Word Fugue can handle is approx
    3.4*10^-4932, which should be more than adequate for most
    calculations. Simply assume it is zero and be done with it.{.}

  Help file WF.HLP not found                         {.}
    It is probable that you have not installed the Home directory
    where Word Fugue will look for its support files.{.}

  Insert paper, press <Enter> to continue printing   {.}
    This message comes up if you have requested that Word Fugue pause
    between printed pages. Wait until the first page has printed, and
    then insert the new page. When it is lined up, press Enter to
    cause Word Fugue to continue printing.{.}

  Insufficient contiguous memory                     {.}
    Word Fugue cannot find a block of memory large enough to perform
    the operation you requested. If you have multiple windows open,
    you should close as many as you can. Alternatively, exit the
    program and reload it, since memory will be allocated
    contiguously. This error can occur if you have been doing a lot of
    editing with line deletion and creation. The computer memory
    becomes sprinkled with small blocks of vacant memory, but none is
    large enough.{.}

  Insufficient memory                                {.}
    There is not sufficient memory for the operation you requested.
    You may be trying to load a file that is too big.{.}

  Invalid directory path                             {.}
    You specified a directory, but Word Fugue cannot find it{.}

  Invalid integer                                    {.}
    Word Fugue asked for an integer, but you entered something else.
    If you included a decimal point, delete it and the digits
    following.{.}

  Invalid marker number                              {.}
    You specified an operation such as go to a line marker number #,
    but # is not in the range 0 to 9.{.}

  Line too long                                      {.}
    The maximum size of any line is 999 characters. This includes any
    font marker characters in your line. {.}

  Log argument error                                 {.}
    You have probably requested the log of a negative number or zero.
    Logarithms are not defined for these numbers.{.}

  Main program file not found                        {.}
    You requested Word Fugue to Save its Setup, but it cannot find the
    file WF.EXE. This file will be updated with the changes you
    requested.{.}

  Marker has not been set                            {.}
    You requested a go to marker number #, but that marker has not
    been assigned.{.}

  Merge File Not Found                               {.}
    The merge data file specified in the .DF dot command could not be
    found.{.}

  No block is defined                                {.}
    You requested a block operation such as block copy or move, but
    you have not marked a block. You must do this first.{.}

  No files Press ESC to Continue                     {.}
    You requested a directory display, but there are no files matching
    your request. Try *.* instead, or check you spelling.{.}

  No likely alternatives found                       {.}
    The word does not appear in the dictionary, and Word Fugue cannot
    find any alternatives close enough to match. If you find this
    happening, you have probably made at least 3 spelling mistakes in
    the word. You can always edit it from the spelling menu and try
    again.{.}

  Not a valid macro file                             {.}
    The file you requested to be loaded is not a macro file. The
    internal identifier is missing. You may have specified the wrong
    file name, or the macro file may be corrupt.{.}

  Not a valid printer definition file                {.}
    The Printer Definition file you requested to be loaded is not a
    in a valid format. The internal identifier is missing. You may
    have specified the wrong file name, or the PDF may be corrupt.{.}

  @@@@@@ not saved. Save? (Y/N)                      {.}
    You have requested the file @@@@@@ be closed, but you have made
    changes to it and you have not asked for them to be saved. Y will
    save the changes, N will discard them.{.}

  Number outside of acceptable range                 {.}
    You entered a number, but it is too big or too small.{.}

  Open Window command must have keystrokes assigned  {.}
    When you reconfigured Word Fugue's keyboard, you deleted the
    keystrokes assigned to the Open Window command. You will need to
    reinstall this command with keystrokes for it.{.}

  Output file not specified                          {.}
    You requested you print be spooled to a file, but you did not
    specify any file name. You must go back and do that.{.}

  Output File same as Input File                     {.}
    You specified that the spool file created by the printing to have
    the same name as the file you want to print. This will cause the
    original text file to be deleted when printing finishes. Are you
    sure you want to do that?{.}

  Path not found                                     {.}
    The combination of file name and directory name could not be
    found.{.}

  Press ESC to exit, ENTER to continue               {.}
    This is displayed after a number of warning messages. ESC will
    abandon the operation, while Enter will continue it.{.}

  Print file not found                               {.}
    The file you asked to be printed could not be found.{.}

  Printer command stack overflow                     {.}
    You have probably specified headers or footers with printer
    control sequences. The amount of characters in the header lines
    plus the printer control sequences is greater than 1024
    characters, causing this message. You should check your headers
    and footers.{.}

  Printer not responding                             {.}
    The printer is not turned on.{.}

  Printer off line                                   {.}
    The printer is turned on, but is off line. Press the Online
    button. You will need to enter a key to continue printing.{.}

  Printer out of paper                               {.}
    The printer reports that it has run out of paper.{.}

  Problem closing Mail Merge File                    {.}
    A DOS error was encountered while trying to close the mail
    merge data file.{.}

  Problem closing print file                         {.}
    A DOS error was encountered while trying to close the input print
    file.{.}

  Problem closing print output file                  {.}
    A DOS error was encountered while trying to close the output print
    file.{.}

  Save modified document before printing? (Y/N)      {.}
    You requested that a file be printed, but you have made changes to
    it and not saved them. Y will save the changes and start printing,
    while N will abandon the print request.{.}

  Sqrt argument negative                             {.}
    Your calculation results in trying to take the Square root of a
    negative number, which is invalid.{.}

  Start page is larger than stop page                {.}
    You requested printing of only a selection of pages. You will need
    to change the start and stop page numbers.{.}

  Stop spelling check? (Y/N)                         {.}
    You pressed ESC once too often. Y will abandon the spelling check,
    while N will continue.{.}

  Temporary margin must be left of right margin      {.}
    A temporary margin must be within the Left and Right margins.{.}

  Temporary margin not available now                 {.}
    Word Wrap has been turned OFF.{.}

  There is no matching Bracket or End!               {.}
    You requested a match bracket operation, but there is none. {.}

  Typeahead buffer overflow                          {.}
    You are typing while a foreground operation such as index
    generation or table of contents generation is going on. The
    internal buffer is full.{.}

  Unable to create .BAK file                         {.}
    There may not be enough room on the disk, or the previous .BAK
    file may be marked as Read Only, which means that Word Fugue
    cannot delete it.{.}

  Unable to invoke DOS                               {.}
    There is either insufficient memory available (you should try
    changing the Global "Invoke Dos" option to "All memory") or the
    program cannot find COMMAND.COM. When you exit Word Fugue, try
    typing in SET at the dos prompt, and verify that you see a line
    "COMSPEC = C:\COMMAND.COM" or similar. alternatively COMMAND.COM
    may be on a floppy which is not in the drive.{.}

  Unable to reload WF_AUX.DIC                        {.}
    The file is probably bigger than 64,000 characters. You should
    probably add many of the words to the Main dictionary, and then
    use Word Fugue to delete them out of the WF_AUX.DIC file.{.}

  Unknown printer error                              {.}
    The printer reported an error other than OFF Line or Paper Out.
    Please check your printer.{.}

  Valid page numbers are 1..4095                     {.}
    You can only have pages numbered in this range.{.}

  Window is too small to divide                      {.}
    The minimum window size is 2 lines. You cannot make this window
    any smaller.{.}

  Word not recognised  @@@@@@@@                      {.}
    The word @@@@@@ was not found in the Main dictionary or the
    Auxiliary dictionary. You should now ask the spell checker to
    suggest possible correct words.{.}

  Word too long for current margins                  {.}
    You have a word that will not fit between the current margins. It
    will appear on a line by itself.{.}

  Word wrap must be activated                        {.}
    You need to turn on Word Wrap (^OW) for this operation.{.}

  You only have one window open!                     
    You cannot go to another window when you have only one open. You
    will need to open another one first.{.}

