/* miscell.c */

#include <string.h>
#include "windows.h"
#include "info.h"
#include "miscell.h"
#include "term.h"
#include "asdriver.h"
#include "xydriver.h"
#include "term_io.h"

extern HWND hMainWnd;
extern HWND hInfoWnd;

static char *StripFN(char *Ptr)
{char *P;
 P = strrchr(Ptr,'\\');
 if(P==NULL) return Ptr;
 else return (P+1);
} /* end StripFN */

void WindowAS(char *FileName)
{char *Ptr;
 /* initialize info window status */
 Ptr = StripFN(FileName);
 InfoChoose('A');
 InfoFileName(Ptr);
 InfoFileSize( ascGetFileLength() );
 InfoErrors(0);
 InfoStatus("Running");
 EnableBreakButton();
 /* pop up info window */
 ShowWindow(hInfoWnd,SW_SHOW);
 SendMessage(hInfoWnd,WM_USER,0,0L);
}

void WindowXY(char *FileName)
{char *Ptr;
 /* initialize info window status */
 Ptr = StripFN(FileName);
 InfoChoose('X');
 InfoFileName(Ptr);
 InfoPacket(0);
 InfoErrors(0);
 InfoStatus("Running");
 EnableBreakButton();
 /* pop up info window */
 ShowWindow(hInfoWnd,SW_SHOW);
 SendMessage(hInfoWnd,WM_USER,0,0L);
}

void EnableBreakButton(void)
{HMENU hMenu;
 /* enable BREAK button */
 hMenu = GetMenu(hMainWnd);
 EnableMenuItem(hMenu,MSG_BREAK,MF_BYCOMMAND|MF_ENABLED);
 DrawMenuBar(hMainWnd);
}

void DisableBreakButton(void)
{HMENU hMenu;
 /* grey the BREAK button */
 hMenu = GetMenu(hMainWnd);
 EnableMenuItem(hMenu,MSG_BREAK,MF_BYCOMMAND|MF_DISABLED|MF_GRAYED);
 DrawMenuBar(hMainWnd);
}