VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Wave VBX Loop Sample"
   ClientHeight    =   2985
   ClientLeft      =   1650
   ClientTop       =   1920
   ClientWidth     =   4095
   Height          =   3390
   Left            =   1590
   LinkTopic       =   "Form1"
   ScaleHeight     =   2985
   ScaleWidth      =   4095
   Top             =   1575
   Width           =   4215
   Begin CheckBox chkLoop 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Repeated Playing (loop)"
      Height          =   255
      Left            =   240
      TabIndex        =   6
      Top             =   1200
      Width           =   3615
   End
   Begin CheckBox chkExclusive 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Exclusive Playing"
      Height          =   255
      Left            =   240
      TabIndex        =   5
      Top             =   840
      Width           =   3615
   End
   Begin MabryWave Wave1 
      Exclusive       =   0   'False
      FileLength      =   -1
      Filename        =   ""
      Left            =   3480
      Loop            =   0   'False
      LoopCount       =   0   'False
      PlayEnd         =   -1
      PlayStart       =   -1
      Top             =   0
   End
   Begin TextBox txtFilename 
      Height          =   285
      Left            =   240
      TabIndex        =   2
      Text            =   "C:\WINDOWS\RINGIN.WAV"
      Top             =   480
      Width           =   3615
   End
   Begin CommandButton btnStop 
      Caption         =   "Stop"
      Height          =   615
      Left            =   2040
      TabIndex        =   1
      Top             =   2160
      Width           =   1815
   End
   Begin CommandButton btnPlay 
      Caption         =   "Play"
      Height          =   615
      Left            =   240
      TabIndex        =   0
      Top             =   2160
      Width           =   1815
   End
   Begin Label Label2 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   1680
      Width           =   3615
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Filename:"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   240
      Width           =   1935
   End
End
Option Explicit

Dim fChanged As Integer ' flag: has filename changed?

Sub btnPlay_Click ()
    ' make sure the filename is up to date
    SetFilename

    ' play the file
    Wave1.Action = 1
    EnableButtons
    Label2 = "Playing"
End Sub

Sub btnStop_Click ()
    ' stop playing
    Wave1.Action = 4

    ' update buttons
    EnableButtons
End Sub

Sub chkExclusive_Click ()
    Wave1.Exclusive = (chkExclusive.Value <> 0)
End Sub

Sub chkLoop_Click ()
    Wave1.Loop = (chkLoop.Value <> 0)
End Sub

Sub EnableButtons ()
    ' set button status
    Select Case Wave1.Status
        Case 1: ' playing
            btnStop.Enabled = True

        Case 4: ' stopped
            btnStop.Enabled = False
    End Select
End Sub

Sub Form_Load ()
    fChanged = True
    EnableButtons
End Sub

Sub SetFilename ()
    ' if the filename has changed, tell Wave VBX
    If fChanged Then
        ' changed no more
        fChanged = False
        Wave1.Filename = txtFilename
    End If
End Sub

Sub txtFilename_Change ()
    fChanged = True
End Sub

Sub Wave1_PlayDone ()
    EnableButtons
    Label2 = "Stopped"
End Sub

Sub Wave1_PlayLoop (LoopCount As Integer)
    Label2 = "Playing (" & LoopCount & " times)"
End Sub

