(*
GOLDFLAG.INC is included in all GOLD units. You can add any global compiler
directives, etc. to this file.

     The TOT conditional defines are

          FINAL - Enable this directive when you are building the production
                  version of your program. The activated settings are designed
                  to reduce program code size, and increase execution speed.
    CUTANDPASTE - Enables block marking, cutting, pasting in the memo editor.
       WORDWRAP - Support for optional word-wrapping in the memo editor
     NOVGACHARS - Disable this directive if you do not want your application
                  to support custom ASCII characters on VGA systems for
                  line drawing, check boxes, etc.
          FLOAT - Enable this directive if your program will be using extended
                  real types, i.e. single, double, extended and comp. When
                  this directive is not enforced, all real types are set to
                  be plain reals. programs compiled in this state will
                  only run on machines fitted with a math coprocessor
        FLOATEM - This is the same as FLOAT except the program will run
                  on systems that are not equipped with a math coprocessor.
                  In case you were wondering, the compiler directive is an
                  abbreviation for FLOAT EMULATION.
        OVERLAY - This directive should normally be used when you want
                  to overlay Toolkit units. Refer to the file OVERLAY.DOC
                  for further information.

    To active a compile directive, you must use the $DEFINE keyword. For
    example, to enable full floating point math emulation in your program
    include the following statement in the "DEFINES AREA" below:

                     {$DEFINE FLOATEM}
*)

{+++++++++++++++++++++++++++    DEFINES   AREA   +++++++++++++++++++++++++++}
{$DEFINE FINAL}

{$DEFINE CUTANDPASTE}

{$DEFINE WORDWRAP}

{$DEFINE TTT5}

{ $ DEFINE NOVGACHARS}
{ $ DEFINE NOVGAMOUSE}

{ $ DEFINE FLOAT}
{ $ DEFINE FLOATEM}

{$DEFINE OVERLAY}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}





{General compiler directives}

{$V-}   {no string length checking}

{$IFDEF VER70}
{$Q-}   {no arithmetic overflow checking}
{$ENDIF}

{$B-}   {short-circuit boolean-expression evaluation}

{$IFDEF FINAL}
    {$S-,R-,L-,D-}
{$ELSE}
    {$S+}
    {$R+}
    {$L+}
    {$D+}
    {$IFNDEF CHECK}
       {$DEFINE CHECK}
    {$ENDIF}
    {$IFNDEF DEBUG}
       {$DEFINE DEBUG}
    {$ENDIF}
{$ENDIF}

{$IFDEF OVERLAY}
    {$F+}
    {$O+}
{$ENDIF}

{Note the floating point type casting is in the totReal unit}

{$IFDEF FLOAT}
    {$IFDEF FLOATEM}
        {$N+,E+}
    {$ELSE}
        {$N+,E-}
    {$ENDIF}
{$ELSE}
    {$N-,E-}
{$ENDIF}
