'
'                ---  selftest.bas ---
'
'  SELFTEST requires two serial ports on the same computer. The
'  program transmits a test string on one port (FirstCOM) and
'  receives on a second port (SecondCOM), where the two ports are
'  connected via a null modem adapter. The received string is tested
'  against the transmit string (they should be idenical).
'
'  Connect the two serial ports (on a single computer) together
'  using a null modem cable. Be sure to modify the configuration
'  section for non-standard PC ports or to setup your multiport
'  board. Note that many multiport boards are either Digiboard or
'  BOCA board compatible.
'

'$INCLUDE: 'PCL4VB.BI'

DECLARE SUB ErrorCheck(BYVAL Code AS INTEGER)

CONST PC = 1
CONST DB = 2
CONST BB = 3

' Serial I/O buffers

RxBuf256One$ = STRING$(256+16,0)
RxBuf256Two$ = STRING$(256+16,0)
TxBuf256One$ = STRING$(256+16,0)
TxBuf256Two$ = STRING$(256+16,0)

' Global Variables

DIM BaudCode AS INTEGER
DIM TestString AS STRING
DIM TestLength AS INTEGER
DIM FirstCOM AS INTEGER
DIM SecondCOM AS INTEGER
DIM Port AS INTEGER
DIM ComLimit AS INTEGER
DIM C AS INTEGER
DIM TheSwitch AS INTEGER
DIM Vers AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM Code AS INTEGER
DIM BufSeg AS INTEGER
DIM PARMS AS STRING
DIM ARGS(10) AS STRING
DIM NARGS AS INTEGER
DIM X AS STRING

' initialize

BaudCode = Baud9600
TheSwitch = 0
TestString = "This is a test string"

' get arguments

NARGS = 0
PARMS = LTRIM$(RTRIM$(COMMAND$)) + " "
DO
   I = INSTR(PARMS, " ")
   L = LEN(PARMS)
   IF I <= 1 THEN EXIT DO
   NARGS = NARGS + 1
   ARGS(NARGS) = UCASE$(LEFT$(PARMS, I - 1))
   PARMS = LTRIM$(MID$(PARMS,I,L-I+1))
LOOP

IF NARGS <> 3 THEN
   PRINT "Usage: selftest {pc|db|bb} 1stCom 2ndCom"
   STOP
END IF
PRINT  "SELFTEST 3.0"
Vers = SioInfo(ASC("V"))
PRINT "  Lib Ver : ";(Vers\16);".";(Vers MOD 16)
PRINT "  TX Intr : ";
IF SioInfo(ASC("I")) <> 0 THEN
   PRINT "enabled."
ELSE
   PRINT "not enabled."
END IF
IF ARGS(1) = "PC" THEN TheSwitch = PC
IF ARGS(1) = "DB" THEN TheSwitch = DB
IF ARGS(1) = "BB" THEN TheSwitch = BB

IF TheSwitch = 0 THEN
   PRINT "Must specify 'PC', 'DB' or 'BB' as 1st argument"

   PRINT "1st arg ='";ARGS(1);"'"

   PRINT "EG:  SELFTEST PC 1 4"
   STOP
END IF
IF TheSwitch = PC THEN ComLimit = COM4
IF TheSwitch = DB THEN ComLimit = COM8
IF TheSwitch = BB THEN ComLimit = COM16

FirstCOM = VAL(ARGS(2)) -1
SecondCOM = VAL(ARGS(3)) -1
PRINT "FirstCOM  = COM";(1+FirstCOM)
PRINT "SecondCOM = COM";(1+SecondCOM)
IF FirstCOM < COM1 THEN
   PRINT "1stCom must be >= COM1"
   STOP
END IF
IF SecondCOM > ComLimit THEN
   PRINT "2ndCom must be <= COM",(1+ComLimit)
   STOP
END IF
IF FirstCOM >= SecondCOM THEN
   PRINT "1stCom must be < 2ndCom"
   STOP
END IF
IF TheSwitch = DB THEN
   ' Custom Configuration: DigiBoard PC/8
   PRINT "[ Configuring for DigiBoard PC/8 (IRQ5) ]"
   Code = SioPorts(8,COM1,&H140,DIGIBOARD)
   FOR Port = COM1 TO COM8
     ' set DigiBoard UART addresses
      CALL ErrorCheck( SioUART(Port,&H100+8*Port) )
      ' set DigiBoard IRQ
      CALL ErrorCheck( SioIRQ(Port,IRQ5) )
   NEXT Port
END IF
IF TheSwitch = BB THEN
   ' Custom Configuration: BOCA BB2016
   PRINT "[ Configuring for BOCA Board BB2016 (IRQ15) ]"
   Code = SioPorts(16,COM1,&H107,BOCABOARD)
   FOR Port = COM1 TO COM16
     ' set BOCA Board UART addresses
      CALL ErrorCheck( SioUART(Port,&H100+8*Port) )
      ' set BOCA Board IRQ
      CALL ErrorCheck( SioIRQ(Port,IRQ15) )
   NEXT Port
END IF
IF TheSwitch = PC THEN
   ' Custom Configuration: 4 port card
   PRINT "[ Configuring for PC ]"
   Code = SioIRQ(COM1,IRQ4)
   Code = SioIRQ(COM2,IRQ3)
   Code = SioIRQ(COM3,IRQ4)
   Code = SioIRQ(COM4,IRQ3)
END IF
' set parmameters for FirstCOM
CALL ErrorCheck( SioParms(FirstCOM,NoParity,OneStopBit,WordLength8) )
' use 16650 FIFO if present
Code = SioFIFO(FirstCOM,LEVEL_8)
' setup receive buffer
BufSeg = (1+SSEG(RxBuf256One$)) + (SADD(RxBuf256One$) \ 16)
CALL ErrorCheck( SioRxBuf(FirstCOM, BufSeg, Size256) )
IF SioInfo(ASC("I")) <> 0 THEN
   'setup transmit buffer
   BufSeg = (1+SSEG(TxBuf256One$)) + (SADD(TxBuf256One$) \ 16)
   CALL ErrorCheck( SioTxBuf(FirstCOM, BufSeg, Size256) )
END IF
' reset FirstCOM
CALL ErrorCheck( SioReset(FirstCOM, BaudCode) )
' set parmameters for SecondCOM
CALL ErrorCheck( SioParms(SecondCOM,NoParity,OneStopBit,WordLength8) )
' use 16650 FIFO if present
Code = SioFIFO(SecondCOM,LEVEL_8)
' setup receive buffer
BufSeg = (1+SSEG(TxBuf256Two$)) + (SADD(TxBuf256Two$) \ 16)
CALL ErrorCheck( SioRxBuf(SecondCOM, BufSeg, Size256) )
IF SioInfo(ASC("I")) <> 0 THEN
   'setup transmit buffer
   BufSeg = (1+SSEG(TxBuf256Two$)) + (SADD(TxBuf256Two$) \ 16)
   CALL ErrorCheck( SioTxBuf(SecondCOM, BufSeg, Size256) )
END IF
' reset SecondCOM
CALL ErrorCheck( SioReset(SecondCOM, BaudCode) )

CLS
PRINT "Start selftest @ 9600 baud"
TestLength = LEN(TestString)
' send string
PRINT "  Sending: ";
FOR I = 1 TO TestLength
   X$ = MID$(TestString,I,1)
   C = ASC(X$)
   Code = SioPutc(FirstCOM,C)
   PRINT X$;
NEXT I
' receive string
PRINT
PRINT "Receiving: ";
FOR I = 1 TO TestLength
   Code = SioGetc(SecondCOM,18)
   IF Code < 0 THEN
       PRINT "ERROR: ";
       Code = SioError(Code)
       Code = SioDone(FirstCOM)
       Code = Code = SioDone(SecondCOM)
       STOP
    END IF
    ' echo just received char
    PRINT CHR$(Code);
    ' compare character
    X$ = MID$(TestString,I,1)
    IF CHR$(Code) <> X$ THEN
       PRINT
       PRINT "ERROR: Expecting '";X$;"', received '";CHR$(Code)
       Code = SioDone(FirstCOM)
       Code = SioDone(SecondCOM)
       STOP
    END IF
 NEXT I
 PRINT
 PRINT "SUCCESS: Test AOK !"
 Code = SioDone(FirstCOM)
 Code = SioDone(SecondCOM)
END


SUB ErrorCheck(BYVAL Code AS INTEGER)
' trap PCL error codes
IF Code < 0 THEN
     Code = SioError(Code)
     Code = SioDone(FirstCOM)
     Code = SioDone(SecondCOM)
     STOP
END IF
END SUB
