'DLGJB2.FRM
'
'This file is strictly speaking not a Visual Basic form, but it contains
'Commands that should go into a Visual Basic form to properly use the
'DialogJB Dialog Box.

'****************************************************************************
'This is what to use on the Main form to open the dialog box.
'The sample uses a Command Button, but clearly a menu or other device
'would work just as well.
'The sample also loads the files chosen by the Dialog Box into a
'Combo Box on the main form.  You may want to vary this depending on
'the kind of control you want and whether you are loading single or
'multiple files.

Sub cmdGetFile_Click ()  'Or mnuGetFile_Click () etc.
    cboFile.Clear 'This clears the Combo File

'At this point you may want to clear other containers or information
'already loaded into your program.  You may want to save the current
'file.  

    Load frmDialogJB

'You also need to draw a horizontal line called LinShadB on your Main form.
'Make this line invisible (LinShadB.Visible = False). It only appears
'When the DialogJB box is loaded to provide some shading and give a
'3D effect.

LinShadB.X1 = 0
LinShadB.X2 = frmMain.ScaleWidth
LinShadB.Y1 = ((frmDialogJB.ScaleHeight + (frmMain.ScaleHeight - frmDialogJB.ScaleHeight) / 2)) - 110
LinShadB.Y2 = ((frmDialogJB.ScaleHeight + (frmMain.ScaleHeight - frmDialogJB.ScaleHeight) / 2)) - 110
        LinShadB.Visible = True
End Sub

'******************************************************************************
'The following items go in one of your MODULEx.BAS files.  They are
'called by DialogJB for shading and centering.  They are optional.
'The CenterForm routine is useful for most forms.

 
'This gives a 3D effect to most gray colored controls.
'I'm pretty sure I adpated this from Visual Basic Programmer's Journal,
'but I don't know which issue.
Sub Go3dGray (myForm As Form, myCtl As Control)
    myForm.CurrentX = myCtl.Left - 15
    myForm.CurrentY = myCtl.Top + myCtl.Height
    myForm.Line -Step(0, -(myCtl.Height + 15)), RGB(92, 92, 92)
    myForm.Line -Step(myCtl.Width + 15, 0), RGB(92, 92, 92)
    myForm.Line -Step(0, myCtl.Height + 15), RGB(255, 255, 255)
    myForm.Line -Step(-(myCtl.Width + 15), 0), RGB(255, 255, 255)

End Sub

'This gives a 3D effect to the border of any gray form. I used it on
'on the main form as well.
Sub BordGray3d (myForm As Form)
    myForm.Line (15, 15)-((myForm.ScaleWidth - 15), 15), RGB(255, 255, 255)
    myForm.Line (15, 15)-(15, (myForm.ScaleHeight - 15)), RGB(255, 255, 255)
    myForm.Line ((myForm.ScaleWidth - 15), 0)-((myForm.ScaleWidth - 15), myForm.ScaleHeight), RGB(0, 0, 0)
    myForm.Line (0, myForm.ScaleHeight - 15)-(myForm.ScaleWidth, myForm.ScaleHeight - 15), RGB(0, 0, 0)
    myForm.Line (15, (myForm.ScaleHeight - 30))-((myForm.ScaleWidth - 15), (myForm.ScaleHeight - 30)), RGB(92, 92, 92)
    myForm.Line ((myForm.ScaleWidth - 30), 15)-((myForm.ScaleWidth - 30), (myForm.ScaleHeight - 15)), RGB(92, 92, 92)
End Sub

'This is useful routine to center any form on the screen.
'I got this from Teach Yourself Visual Basic 3.0 by John Socha and
'Devra Hall.
Sub CenterForm (aForm As Form)
    Dim X, Y                    ' New top, left for the form

    X = (Screen.Width - aForm.Width) / 2
    Y = (Screen.Height - aForm.Height) / 2
    aForm.Move X, Y             ' Change location of the form
End Sub

'For the GetINIItem$ function and the SetINI subroutine, see the 
'file INIDEMO.ZIP by Curtis Smith available as a free download on many
'BBS's and online services. (Look for Visual Basic or Windows API topics.)

Sub GetINIList (ByVal FileName$, ByVal ListName$, NumElems, ListArray$())
   GroupName$ = "[LIST " + ListName$ + "]"
   Call SetINIParams(FileName$, GroupName$, LineItem$)

   INIFileNum = FreeFile
   Open FileName$ For Input As #INIFileNum
   While Not EOF(INIFileNum)
      Call FindGroup(GroupName$, Found)
      If Found = True Then
         Line Input #INIFileNum, Lne$
         Temp$ = ParseES$(Lne$, Value$)
         NumElems = Val(Value$)
         ReDim ListArray$(NumElems)
         For CX = 1 To NumElems
            Line Input #INIFileNum, ListArray$(CX)
         Next CX
      End If
   Wend
   Close #INIFileNum

End Sub

Function GetINIValue$ (ByVal FileName$, ByVal GroupName$, ByVal LineItem$)
   Call SetINIParams(FileName$, GroupName$, LineItem$)

   INIFileNum = FreeFile
   Open FileName$ For Input As #INIFileNum
   While Not EOF(INIFileNum)
      Call FindGroup(GroupName$, Found)
      If Found = True Then
         FoundValue$ = FindItem$(LineItem$)
      End If
   Wend
   Close #INIFileNum

   ' Strip all spaces and leading-trailing quotes
   Temp$ = LTrim$(RTrim$(FoundValue$))
   If Left$(Temp$, 1) = Chr$(34) Then Temp$ = Mid$(Temp$, 2)
   If Right$(Temp$, 1) = Chr$(34) Then Temp$ = Left$(Temp$, Len(Temp$) - 1)
   Temp$ = LTrim$(RTrim$(FoundValue$))

   GetINIValue = Temp$

End Function

Sub SetINIItem (ByVal FileName$, ByVal GroupName$, ByVal LineItem$, ByVal LineItemValue$)
   Call SetINIParams(FileName$, GroupName$, LineItem$)

   ' Open the CURRENT ini (if one exists)
   If Dir$(FileName$) = "" Then
      INIFileNum = FreeFile
      Open FileName$ For Output As #INIFileNum
      TempFileNum = FreeFile
      Open "C:\INItemp.ini" For Output As #TempFileNum
      Print #TempFileNum, GroupName$
      Print #TempFileNum, LineItem$; "="; LineItemValue$
      Print #TempFileNum, " "

   Else
      ' Open the TEMP file for inputing into
      TempFileNum = FreeFile
      Open "C:\INItemp.ini" For Output As #TempFileNum
      INIFileNum = FreeFile
      Open FileName$ For Input As #INIFileNum


      ' Look for the Group
      Done = False
      Found = False
      Printed = False
      Do
         Line Input #INIFileNum, Lne$  ' Read the Line
         If UCase$(Lne$) = GroupName$ Then
            Found = True
            Done = True
         End If
         If EOF(INIFileNum) Then Done = True
         Print #TempFileNum, Lne$       ' Print the Line
      Loop Until Done

      If Found = False Then
         ' Group not found,  GO ADD A NEW ONE...
         Print #TempFileNum, " "
         Print #TempFileNum, GroupName$
         Print #TempFileNum, LineItem$; "="; LineItemValue$
         Printed = True
      Else
         ' We found the group - now look for the Item
         Done = False
         Found = False
         Do
            Line Input #INIFileNum, Lne$
            If EOF(INIFileNum) Then Done = True
            If Len(Lne$) = 0 And Done = True Then
               ' We reached the eof WITHOUT finding the ITEM
               Done = True
               Print #TempFileNum, LineItem$; "="; LineItemValue$
               Print #TempFileNum, " "
               Printed = True
            Else
               If Left$(Lne$, 1) = "[" Then
                  ' We found the next group WITHOUT finding the ITEM
                  Print #TempFileNum, LineItem$; "="; LineItemValue$  ' Add Item
                  Print #TempFileNum, " "
                  Print #TempFileNum, Lne$                            ' Add NEXT GROUP
                  Done = True
                  Printed = True
               ElseIf Lne$ <> "" Then
                  If ParseES$(Lne$, TempVal$) = LineItem$ Then
                     Found = True
                     Print #TempFileNum, LineItem$; "="; LineItemValue$
                     Done = True
                     Printed = True
                  Else
                     Print #TempFileNum, Lne$
                  End If
               End If
            End If
         Loop Until Done

         If Printed = False Then
            ' We made it this far - and have NOT written the item
            Print #TempFileNum, LineItem$; "="; LineItemValue$
         End If

         ' Add the REST OF THE FILE
         If Not EOF(INIFileNum) Then
            Do
               Line Input #INIFileNum, Lne$
               Print #TempFileNum, Lne$
            Loop Until EOF(INIFileNum)
         End If
      End If
   End If
   Close #INIFileNum
   Close #TempFileNum
   Kill FileName$
   Name "C:\INItemp.ini" As FileName$

End Sub

Sub SetINIParams (FileName$, GroupName$, LineItem$)
   FileName$ = LTrim$(RTrim$(UCase$(FileName$)))
   GroupName$ = LTrim$(RTrim$(UCase$(GroupName$)))
   LineItem$ = LTrim$(RTrim$(UCase$(LineItem$)))


   ' Setup FileName$
   Select Case FileName$
      Case "WIN", "WIN.INI"
         FileName$ = "C:\WINDOWS\WIN.INI"

      Case "SYSTEM", "SYSTEM.INI"
         FileName$ = "C:\WINDOWS\SYSTEM.INI"
      
      Case Else
         If InStr(FileName$, "WINDOWS") = 0 Then
            FileName$ = "C:\Windows\" + FileName$
            If InStr(FileName$, ".") = 0 Then FileName$ = FileName$ + ".INI"
         End If

   End Select

   ' Setup GroupName$
   If Left$(GroupName$, 1) <> "[" Then GroupName$ = "[" + GroupName$
   If Right$(GroupName$, 1) <> "]" Then GroupName$ = GroupName$ + "]"

End Sub

'  "This program is produced by a member of the Association of Shareware
'    Professionals (ASP).  ASP wants to make sure that the shareware
'    principle works for you. If you are unable to resolve a
'    shareware-related problem with an ASP member by contacting the member
'    directly, ASP may be able to help. The ASP Ombudsman can help you
'    resolve a dispute or problem with an ASP member, but does not provide
'    technical support for members' products.  Please write to the ASP
'    Ombudsman at 545 Grover Road, Muskegon, MI USA 49442-9427, Fax
'    616-788-2765, or send a CompuServe message via CompuServe Mail to ASP
'    Ombudsman 70007,3536 (or e-mail 70007.3536@compuserve.com)."
'
'    Member, Educational Software Cooperative (ESC).
'
'Copyright  1995, James Bair, All rights reserved.
'Portions taken from sources as indicated.
'
'                                    ____|__     |                 
' P.O. Box 203                    --|       |    |-------------------
' Shelton CT 06484-0203  USA        |   ____|__  |  Association of
'                                   |  |       |_|  Shareware
'                                   |__|   o   |    Professionals
' CompuServe: 70730,3001          -----|   |   |---------------------
' Internet: 70730.3001@compuserve.com  |___|___|    MEMBER
'  (Queries only) jbair@csunet.ctstateu.edu
'
