unit Example;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, VBXCtrl, Agauge, StdCtrls, Agauge25;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    ScrollBar1: TScrollBar;
    ScrollBar2: TScrollBar;
    aGauge1: TaGauge;
    aGauge2: TaGauge;
    procedure Timer1Timer(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Timer1Timer(Sender: TObject);
begin

   aGauge1.NeedleValue := aGauge1.NeedleValue + Random - 0.5;

   if aGauge1.NeedleValue<0.0 then aGauge1.NeedleValue := 0.0;
   if aGauge1.NeedleValue>50.0 then aGauge1.NeedleValue := 50.0;

   ScrollBar2.Position := Round(aGauge1.NeedleValue*10);

   ScrollBar1.Position := ScrollBar1.Position + Random(3)-1;
   if ScrollBar1.Position = 0 then ScrollBar1.Position := 360
   else if ScrollBar1.Position = 360 then ScrollBar1.Position := 0;

   aGauge2.TicID := 0;
   aGauge2.TicFloatOffset := -ScrollBar1.Position;
   aGauge2.TicID := 1;
   aGauge2.TicFloatOffset := -ScrollBar1.Position;
   aGauge2.NeedleValue := ScrollBar1.Position;

end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin

     aGauge2.TicID := 0;
     aGauge2.TicFloatOffset := -ScrollBar1.Position;
     aGauge2.TicID := 1;
     aGauge2.TicFloatOffset := -ScrollBar1.Position;
     aGauge2.NeedleValue := ScrollBar1.Position;

end;

procedure TForm1.ScrollBar2Change(Sender: TObject);
begin

     aGauge1.NeedleValue := ScrollBar2.Position/10;

end;

end.
