//
//	VECPRO.H	Vector Pro Header File
//
//	Copyright 1994 by Vector Numerics, Inc.
//

#include "math.h"
#include "float.h"
#include "stdlib.h"
#include "errno.h"

#ifndef _VECTOR_PRO_DEFINED
#define _VECTOR_PRO_DEFINED         /* avoid multiple def's  */

struct tenbytes
	{
	double r;
	short s;
	};

#ifndef	POLYNOMIAL_MAX_ORDER
#define POLYNOMIAL_MAX_ORDER	20
#endif

extern short vp_poly_max_order;
extern double vp_pi;

struct poly
	{
	short order;
	char waste[6]; // To force efficient data alignment in memory.
	double co[POLYNOMIAL_MAX_ORDER + 1];
	};

struct polyx
	{
	short order;
	char waste[6]; // To force efficient data alignment in memory.
	struct complex co[POLYNOMIAL_MAX_ORDER + 1];
	};

// Error Return Codes:
//
#define		VP_DIV_BY_0		1
#define		VP_INFINITY		2
#define		VP_OVERFLOW		3
#define		VP_UNDERFLOW		4
#define		VP_SINGULAR		5
#define		VP_OUT_OF_RANGE		6
#define		VP_PARAM_ERROR		7
#define		VP_ILL_CONDITIONED	8
#define		VP_COMPLEX_RESULT	9
#define		VP_INTERNAL_ERROR	10
#define		VP_NO_CONVERGENCE	11
#define		VP_ACC_PLOSS		12
#define		VP_ACC_TLOSS		13
#define		VP_DUPLICATES		14
#define		VP_UNSORTED		15
#define		VP_EXTRAPOLATED		16


short	vecinit(short poly_max_order);
short	sincos(double theta, double * s, double * c);
short 	cpx_add(struct complex * r, struct complex * a, struct complex * b);
short 	cpx_sub(struct complex * r, struct complex * a, struct complex * b);
short 	cpx_mult(struct complex * r, struct complex * a, struct complex * b);
short 	cpx_div(struct complex * r, struct complex * a, struct complex * b);
short	cpx_abs(double * a, struct complex * c);
short	cpx_arg(double * a, struct complex * c);
short	cpx_convert(struct complex * c, double abs, double arg);
short 	cpx_sqrt(struct complex * r, struct complex * a);
short 	cpx_power(struct complex * r, struct complex * a, double exp);
short 	cpx_cpx_power(struct complex * r, struct complex * a, struct complex * exp);
short	cpx_exp(struct complex * r, struct complex * a);
short 	cpx_ln(struct complex * r, struct complex * a);
short 	cpx_sin(struct complex * r, struct complex * a);
short 	cpx_cos(struct complex * r, struct complex * a);
short	poly_zero(struct poly * r);
short	poly_copy(struct poly * r, struct poly * a);
short 	poly_eval(double * r, double x, struct poly * a);
short 	poly_add(struct poly * r, struct poly * a, struct poly * b);
short 	poly_sub(struct poly * r, struct poly * a, struct poly * b);
short 	poly_mult(struct poly * r, struct poly * a, struct poly * b);
short 	poly_div(struct poly * r, struct poly * a, struct poly * b, struct poly * m);
short 	poly_lin_change(struct poly * r, struct poly * a, double ycoeff, double c, double * temp1, double * temp2);
short 	poly_deriv(struct poly * r, struct poly * a);
short 	poly_integ(struct poly * r, struct poly * a);
short 	poly_cpx_convert(struct polyx * r, struct poly * a);
short	poly_cpx_zero(struct polyx * r);
short	poly_cpx_copy(struct polyx * r, struct polyx * a);
short 	poly_cpx_eval(struct complex * r, struct complex * x, struct polyx * a);
short 	poly_cpx_add(struct polyx * r, struct polyx * a, struct polyx * b);
short 	poly_cpx_sub(struct polyx * r, struct polyx * a, struct polyx * b);
short 	poly_cpx_mult(struct polyx * r, struct polyx * a, struct polyx * b);
short 	poly_cpx_div(struct polyx * r, struct polyx * a, struct polyx * b, struct polyx * m);
short 	poly_cpx_lin_change(struct polyx * r, struct polyx * a, struct complex * ycoeff, struct complex * c, 
			    struct complex * temp1, struct complex * temp2);
short 	poly_cpx_deriv(struct polyx * r, struct polyx * a);
short 	poly_cpx_integ(struct polyx * r, struct polyx * a);
short 	poly_cpx_root(struct complex * r, double * c, struct polyx * a, struct complex * guess);
short 	poly_cpx_roots(struct complex * r, double * c, struct polyx * a, struct polyx * tmp, struct polyx * tmp2, struct polyx * tmp3);
short	vec_zero(double * r, short n);
short 	vec_copy(double * r, double * a, short n);
short 	vec_add(double * r, double * a, double * b, short na);
short 	vec_sub(double * r, double * a, double * b, short na);
short 	vec_scalar(double * r, double * a, double x, short na);
short 	vec_unit(double * r, double * a, short na);
short 	vec_dotprod(double * r, double * a, double * b, short nab);
short 	vec_crossprod(double * r, double * a, double * b);
short	vec_total(double * r, short n, short n_inputs, double * a, double afactor, ...);
short	vec_angle(double * r, double * a, double * b, short n);
short	vec_magnitude(double * r, double * a, short n);
short	vec_gendotprod(double * r, char * a, char * b, short na, short a_inc, short b_inc);
short	mat_zero(double * r, short nr, short nc);
short	mat_copy(double * r, double * a, short nr, short nc);
short	mat_ident(double * r, short n);
short	mat_add(double * r, double * a, double * b, short nr, short nc);
short	mat_sub(double * r, double * a, double * b, short nr, short nc);
short	mat_scalar(double * r, double * a, double x, short nr, short nc);
short	mat_mult(double * r, double * a, double * b, short arows, short acols, short bcols);
short	mat_trace(double * t, double * r, short n);
short	mat_transpose(double * r, short nr, short nc, double * a);
short	mat_lud(double * r, short n, short * row_pivots, short * dsign, double * temp, struct tenbytes * temp2);
short	mat_determinant(double * r, short n, short * row_pivots, double * d, short dsign);
short	mat_inverse(double * r, double * a, short n, short * row_pivots, double * tmp1, double * tmp2);
short mat_inverse_errest(double * r, double * orig_a, double * a, short n, short * row_pivots, double * resid, double * err,
			 double * tmp1, double * tmp2, double * tmp3, double * tmp4);
short	mat_solve(double * a, short n, short * row_pivots, double * x, double * b);
short mat_errest(double * orig_a, double * a, short n, short * row_pivots, double * x, double * b, double * resid, double * err,
                 double * tmp1, double * tmp2);
short	mat_colop(double * r, short nr, short nc, short change_col, double x, short from_col);
short	mat_rowop(double * r, short nr, short nc, short change_row, double x, short from_row);
short	mat_zero_p(double * r, short nr, short nc, short rsiz_c);
short	mat_copy_p(double * r, double * a, short nr, short nc, short rsiz_c, short asiz_c);
short	mat_ident_p(double * r, short n, short rsiz_c);
short	mat_add_p(double * r, double * a, double * b, short nr, short nc, short rsiz_c, short asiz_c, short bsiz_c);
short	mat_sub_p(double * r, double * a, double * b, short nr, short nc, short rsiz_c, short asiz_c, short bsiz_c);
short	mat_scalar_p(double * r, double * a, double x, short nr, short nc, short rsiz_c, short asiz_c);
short	mat_mult_p(double * r, double * a, double * b, short arows, short acols, short bcols, short rsiz_c, short asiz_c, short bsiz_c);
short	mat_trace_p(double * t, double * r, short n, short rsiz_c);
short	mat_transpose_p(double * r, short nr, short nc, double * a, short rsiz_c, short asiz_c);
short	mat_lud_p(double * r, short n, short * row_pivots, short * dsign, double * temp, struct tenbytes * temp2, short rsiz_c);
short	mat_determinant_p(double * r, short n, short * row_pivots, double * d, short dsign, short rsiz_c);
short	mat_inverse_p(double * r, double * a, short n, short * row_pivots, double * tmp1, double * tmp2, short rsiz_c, short asiz_c);
short mat_inverse_errest_p(double * r, double * orig_a, double * a, short n, short * row_pivots, double * resid, double * err,
			   double * tmp1, double * tmp2, double * tmp3, double * tmp4,
			   short rsiz_c, short orig_a_siz_c, short asiz_c);
short	mat_solve_p(double * a, short n, short * row_pivots, double * x, double * b, short rsiz_c);
short mat_errest_p(double * orig_a, double * a, short n, short * row_pivots, double * x, double * b, double * resid, double * err,
                 double * tmp1, double * tmp2, short orig_a_siz_c, short asiz_c);
short	mat_colop_p(double * r, short nr, short nc, short change_col, double x, short from_col, short rsiz_c);
short	mat_rowop_p(double * r, short nr, short nc, short change_row, double x, short from_row, short rsiz_c);
short	binary_search_i(double * x, short n, double xi);
short	binary_search(double * x, short n, double xi);
short	heap_sort(double * x, short n, double ** others, short n_others);
short	cubic_spline(double * x, double * y, double * y2, double * temp, short n);
short	cubic_spline_int(double * x, double * y, double * y2, short n, double xi, double * yi);

// Error recovery versions:
short	sincos_e(double theta, double * s, double * c);
short 	cpx_add_e(struct complex * r, struct complex * a, struct complex * b);
short 	cpx_sub_e(struct complex * r, struct complex * a, struct complex * b);
short 	cpx_mult_e(struct complex * r, struct complex * a, struct complex * b);
short 	cpx_div_e(struct complex * r, struct complex * a, struct complex * b);
short	cpx_abs_e(double * a, struct complex * c);
short	cpx_argument_e(double * a, struct complex * c);
short	cpx_convert_e(struct complex * c, double abs, double arg);
short 	cpx_sqrt_e(struct complex * r, struct complex * a);
short 	cpx_power_e(struct complex * r, struct complex * a, double exp);
short 	cpx_cpx_power_e(struct complex * r, struct complex * a, struct complex * exp);
short	cpx_exp_e(struct complex * r, struct complex * a);
short 	cpx_ln_e(struct complex * r, struct complex * a);
short 	cpx_sin_e(struct complex * r, struct complex * a);
short 	cpx_cos_e(struct complex * r, struct complex * a);
short	poly_zero_e(struct poly * r);
short	poly_copy_e(struct poly * r, struct poly * a);
short 	poly_eval_e(double * r, double x, struct poly * a);
short 	poly_add_e(struct poly * r, struct poly * a, struct poly * b);
short 	poly_sub_e(struct poly * r, struct poly * a, struct poly * b);
short 	poly_mult_e(struct poly * r, struct poly * a, struct poly * b);
short 	poly_div_e(struct poly * r, struct poly * a, struct poly * b, struct poly * m);
short 	poly_lin_change_e(struct poly * r, struct poly * a, double ycoeff, double c, double * temp1, double * temp2);
short 	poly_deriv_e(struct poly * r, struct poly * a);
short 	poly_integ_e(struct poly * r, struct poly * a);
short 	poly_cpx_convert_e(struct polyx * r, struct poly * a);
short	poly_cpx_zero_e(struct polyx * r);
short	poly_cpx_copy_e(struct polyx * r, struct polyx * a);
short 	poly_cpx_eval_e(struct complex * r, struct complex * x, struct polyx * a);
short 	poly_cpx_add_e(struct polyx * r, struct polyx * a, struct polyx * b);
short 	poly_cpx_sub_e(struct polyx * r, struct polyx * a, struct polyx * b);
short 	poly_cpx_mult_e(struct polyx * r, struct polyx * a, struct polyx * b);
short 	poly_cpx_div_e(struct polyx * r, struct polyx * a, struct polyx * b, struct polyx * m);
short 	poly_cpx_lin_change_e(struct polyx * r, struct polyx * a, struct complex * ycoeff, struct complex * c, 
			    struct complex * temp1, struct complex * temp2);
short 	poly_cpx_deriv_e(struct polyx * r, struct polyx * a);
short 	poly_cpx_integ_e(struct polyx * r, struct polyx * a);
short 	poly_cpx_root_e(struct complex * r, double * c, struct polyx * a, struct complex * guess);
short 	poly_cpx_roots_e(struct complex * r, double * c, struct polyx * a, struct polyx * tmp, struct polyx * tmp2, struct polyx * tmp3);
short	vec_zero_e(double * r, short n);
short 	vec_copy_e(double * r, double * a, short n);
short 	vec_add_e(double * r, double * a, double * b, short na);
short 	vec_sub_e(double * r, double * a, double * b, short na);
short 	vec_scalar_e(double * r, double * a, double x, short na);
short 	vec_unit_e(double * r, double * a, short na);
short 	vec_dotprod_e(double * r, double * a, double * b, short nab);
short 	vec_crossprod_e(double * r, double * a, double * b);
short	vec_total_e(double * r, short n, short n_inputs, double * a, double afactor, ...);
short	vec_angle_e(double * r, double * a, double * b, short n);
short	vec_magnitude_e(double * r, double * a, short n);
short	vec_gendotprod_e(double * r, char * a, char * b, short na, short a_inc, short b_inc);
short	mat_zero_e(double * r, short nr, short nc);
short	mat_copy_e(double * r, double * a, short nr, short nc);
short	mat_ident_e(double * r, short n);
short	mat_add_e(double * r, double * a, double * b, short nr, short nc);
short	mat_sub_e(double * r, double * a, double * b, short nr, short nc);
short	mat_scalar_e(double * r, double * a, double x, short nr, short nc);
short	mat_mult_e(double * r, double * a, double * b, short arows, short acols, short bcols);
short	mat_trace_e(double * t, double * r, short n);
short	mat_transpose_e(double * r, short nr, short nc, double * a);
short	mat_lud_e(double * r, short n, short * row_pivots, short * dsign, double * temp, struct tenbytes * temp2);
short	mat_determinant_e(double * r, short n, short * row_pivots, double * d, short dsign);
short	mat_inverse_e(double * r, double * a, short n, short * row_pivots, double * tmp1, double * tmp2);
short mat_inverse_errest_e(double * r, double * orig_a, double * a, short n, short * row_pivots, double * resid, double * err,
			 double * tmp1, double * tmp2, double * tmp3, double * tmp4);
short	mat_solve_e(double * a, short n, short * row_pivots, double * x, double * b);
short mat_errest_e(double * orig_a, double * a, short n, short * row_pivots, double * x, double * b, double * resid, double * err,
                 double * tmp1, double * tmp2);
short	mat_colop_e(double * r, short nr, short nc, short change_col, double x, short from_col);
short	mat_rowop_e(double * r, short nr, short nc, short change_row, double x, short from_row);
short	mat_zero_p_e(double * r, short nr, short nc, short rsiz_c);
short	mat_copy_p_e(double * r, double * a, short nr, short nc, short rsiz_c, short asiz_c);
short	mat_ident_p_e(double * r, short n, short rsiz_c);
short	mat_add_p_e(double * r, double * a, double * b, short nr, short nc, short rsiz_c, short asiz_c, short bsiz_c);
short	mat_sub_p_e(double * r, double * a, double * b, short nr, short nc, short rsiz_c, short asiz_c, short bsiz_c);
short	mat_scalar_p_e(double * r, double * a, double x, short nr, short nc, short rsiz_c, short asiz_c);
short	mat_mult_p_e(double * r, double * a, double * b, short arows, short acols, short bcols, short rsiz_c, short asiz_c, short bsiz_c);
short	mat_trace_p_e(double * t, double * r, short n, short rsiz_c);
short	mat_transpose_p_e(double * r, short nr, short nc, double * a, short rsiz_c, short asiz_c);
short	mat_lud_p_e(double * r, short n, short * row_pivots, short * dsign, double * temp, struct tenbytes * temp2, short rsiz_c);
short	mat_determinant_p_e(double * r, short n, short * row_pivots, double * d, short dsign, short rsiz_c);
short	mat_inverse_p_e(double * r, double * a, short n, short * row_pivots, double * tmp1, double * tmp2, short rsiz_c, short asiz_c);
short mat_inverse_errest_p_e(double * r, double * orig_a, double * a, short n, short * row_pivots, double * resid, double * err,
			   double * tmp1, double * tmp2, double * tmp3, double * tmp4,
			   short rsiz_c, short orig_a_siz_c, short asiz_c);
short	mat_solve_p_e(double * a, short n, short * row_pivots, double * x, double * b, short rsiz_c);
short mat_errest_p_e(double * orig_a, double * a, short n, short * row_pivots, double * x, double * b, double * resid, double * err,
                 double * tmp1, double * tmp2, short orig_a_siz_c, short asiz_c);
short	mat_colop_p_e(double * r, short nr, short nc, short change_col, double x, short from_col, short rsiz_c);
short	mat_rowop_p_e(double * r, short nr, short nc, short change_row, double x, short from_row, short rsiz_c);
short	binary_search_i_e(double * x, short n, double xi);
short	binary_search_e(double * x, short n, double xi);
short	heap_sort_e(double * x, short n, double ** others, short n_others);
short	cubic_spline_e(double * x, double * y, double * y2, double * temp, short n);
short	cubic_spline_int_e(double * x, double * y, double * y2, short n, double xi, double * yi);

#endif

