



     PC-File Version 7 Users Guide                              1




     PC-File

     User Guide

     Copyright

     Copyright 1982-1993 by Jim Button. Copyright 1984-1993 by
     ButtonWare, Inc. All rights reserved.

     The software described in this manual is protected by
     copyright laws.

     This manual is protected by copyright laws. No part of this
     manual may be reproduced, transmitted, transcribed, stored in
     a retrieval system, or translated into any language, natural
     or computer, in any form or by any means, without the prior
     written permission of ButtonWare, Inc.

     Information in this manual is subject to change without notice
     and does not represent a commitment on the part of ButtonWare,
     Inc. ButtonWare may make improvements and/or changes in this
     manual or in the product(s) and/or program(s) described in
     this manual at any time.

     This product could include technical inaccuracies or
     typographical errors. Changes are periodically made to the
     information herein; these changes may be incorporated in new
     editions of this product.

     Trademarks

     ButtonWare and PC-File are registered trademarks of
     ButtonWare, Inc.

     Other brand and product names are trademarks or registered
     trademarks of their holders.

     Credits

     The ButtonWare team: Mary Ayres, Nancy Bedell, Jim Button,
     Christiane Carder, Jim Coleman, Lynne Cooley, Chuck Cooper,
     Vivanne Cornelius, Suzanne Eyring, Suzanne Faith, Steve
     Hansen, David Husch, Steve Klem, Dave Knopf, Helen Knopf, John
     Knopf, Stephen Knopf, Francis Langlois, Craig McDonald, Gary
     Peaslee, Sue Pennock, John Reiher, Mark Roberts, David Ruf,
     Kevin Smith, Steve Wilson.

  
     
     TABLE OF CONTENTS
     
     NOTES ON THE ON-DISK MANUAL .........................   2
     GETTING STARTED WITH PC-FILE ........................   3
     CHAPTER 1  NAVIGATING IN PC-FILE ....................  12
                Starting, Exiting, Video modes, the Mouse,
                the Keyboard, the Screen, Menus, Using Help,
                Backing up the database
     CHAPTER 2  CREATING A DATABASE STRUCTURE ............  31
     CHAPTER 3  MODIFYING A DATABASE STRUCTURE ...........  48
     CHAPTER 4  FIELD ATTRIBUTES .........................  64
                What they are, Types (Automatic data,
                Validation, Formatting, Data restriction)
     CHAPTER 5  VIEWS ....................................  79
                General, the Record View Designer, the Table
                View Designer
     CHAPTER 6  ADDING DATA .............................. 101
     CHAPTER 7  FINDING AND MODIFYING DATA ............... 107
     CHAPTER 8  SORTING AND INDEXING DATA ................ 131
     CHAPTER 9  CREATING REPORTS ......................... 149
                Page reports, Mail Label reports, Free Form,
                Language, Bar Codes
     CHAPTER 10 WRITING LETTERS AND MERGING DATA ......... 201
     CHAPTER 11 PRINTING REPORTS AND LETTERS ............. 213
     CHAPTER 12 CREATING GRAPHS .......................... 224
     CHAPTER 13 UTILITIES ................................ 239
                Exporting, Importing, Exchange, File
                management, COnfiguring, Packing, Repairing
     CHAPTER 14 PRINTING LABELS WITH PC-LABEL ............ 276
     CHAPTER 15 TOOLS .................................... 297
                Dropping to DOS, Phone Dialer, Snapshot
                labels, the Calculator, Spell checking
     CHAPTER 16 MACROS ................................... 311
     CHAPTER 17 CALCULATIONS ............................. 324
                Guidelines, Mathematical, Date, Time,
                Conditional, Random Numbers, String
                functions, Relational lookups
     CHAPTER 18 BATCH POSTING ............................ 343
     CHAPTER 19 MEMORY USAGE AND PERFORMANCE ............. 350
     
     




     PC-File Version 7 Users Guide                              2




     NOTES ON THE ON-DISK MANUAL

     The retail (printed) manuals were written using Microsoft Word
     for Windows and formatted with Ventura Publisher 4.1. Screens
     were captured using HiJaak by Inset Systems. Text is in
     Garamond, headings in Helvetica Condensed, and callouts in
     Tekton. The manuals were printed by R.R. Donnelley & Sons
     Company.

     We have tried to provide you with everything necessary to
     evaluate PC-File. The program uses clear, informative menus.
     Help screens are always available.  Also, the file "CARD" can
     be printed to create a quick reference card with a summary of
     the program commands.  The file "STARTUP" gives answers to the
     most common start-up problems. This is sufficient for most
     people to evaluate the program. However,  some people prefer
     to have a copy of the printed manual.

     In prior shareware versions of PC-File our manual was over 500
     pages long and many people complained.  Therefore this time we
     have shortened the manual so as to give you complete
     information about each feature but to avoid repetition and the
     obvious. PLEASE NOTE  YOU CAN ALWAYS GET CONTEXT SENSITIVE
     HELP BY PRESSING F1.


     Note that there are no pretty screen pictures in the disk
     manual, and the tabbing in some of the tables isn't perfect.
     This is because much of the pictorial information is lost when
     we translate from our typeset document to a a text file on the
     disk. This isn't possible in a text file that will print on
     all printers.

     To keep costs down, the on-disk documentation is not included
     with purchased copies of PC-File.  Purchased copies include a
     complete printed User's Manual, typeset and bound, which 
     includes screen shots and more examples, a Tutorial for beginners, 
     and an Index.It's 681 pages long.

     ButtonWare, Inc. 325 118th Ave. SE, Suite 200 Bellevue, WA
     98005 ISBN 0-922692-38-6




     PC-File Version 7 Users Guide                              3



     GETTING STARTED WITH PC-FILE

     This section is designed to help you get up and running with
     PC-File. This section contains information on your PC-File
     package, PC-File requirements, and installation instructions.


     WELCOME TO PC-FILE

     Congratulations! You've made an excellent choice for your file
     management needs. PC-File is a perfect fit for everyone
     needing to manage their data-beginners and advanced users-
     corporate, small business, and home users.

     PC-File does just what you need a database to do-store,
     organize, retrieve, manipulate, and update information.
     Whether it's your mailing list or your membership list. Your
     clients, your customers, or your contacts. Sales, inventory,
     expenses, payables and receivables, even your hobby collection
     . . . PC-File can keep a record of it.

     About the Getting Started Section

     This section is intended for all users of PC-File Version 7,
     including users of previous versions of PC-File. Whether PC-
     File is your first software program or you're an experienced
     computer user, we highly recommend you read and follow the
     instructions in this section.

     This section is intended to:

       Familiarize you with the PC-File package

       Inform you of PC-File Version 7 requirements

       Guide you in installing PC-File

       Tell you how to register your copy of PC-File

     In addition to this section, the User Guide contains the PC-
     File Tutorial section and the PC-File Reference section. The
     PC-File Tutorial provides hands-on exercises to help you learn
     PC-File. The PC- File Reference section provides information
     and instructions on using PC-File.


     REQUESTING TECHNICAL SUPPORT




     PC-File Version 7 Users Guide                              4


     The Technical Support Information card included with this
     package contains up-to-date phone numbers, operating hours,
     and other information to assist you in obtaining technical
     support. We provide 30 days of free phone support after you
     register PC-File. The 30-day free support period begins on the
     date of your first call and ends 30 days following. To receive
     technical support during your 30-day free support period, call
     (206) 454-0479.

     Options for obtaining technical support after your 30-day free
     support period ends, include:

       Pay-as-you-go Phone Support: 1-900-454-8000

       Yearly Support Plan: call (206) 454-0479 for information

       CompuServe Information Service: ButtonWare is located in
       Section 1 of the PCVENA forum

       Electronic Bulletin Board Support: (206) 454-7875

     Refer to the Technical Support Information card included with
     this package for further details on any of the technical
     support options listed above.


     REQUESTING CUSTOMER SERVICE

     ButtonWare's Customer Service department exists to serve you.
     If you have any billing, shipping, non-technical questions or
     comments about your package or registration, please contact
     us. To reach our Customer Service department, call 206-454-
     0479 Monday through Friday between 8:00 a.m. and 5:00 p.m.
     (Pacific time). If you prefer, you can write a letter and mail
     it to ButtonWare Customer Service, P.O. Box 96058, Bellevue,
     WA 98009-9818 or fax it to us at 206-454-1838.


     BEFORE YOU BEGIN

     Before you begin working with PC-File, you need to:

       Check the contents of your package

       Make sure you have the correct equipment to run PC-File

       Install PC-File

       Register your copy of PC-File (Unless you purchased this
       package directly from ButtonWare, in which case you are
       automatically registered.)

     This section discusses each of these procedures. After you've
     completed these procedures you'll be ready to put PC-File to
     work.




     PC-File Version 7 Users Guide                              5


     Checking the Contents of Your Package

     Before installing PC-File, we recommend you check the contents
     of your package. Your package should contain the following
     materials:

       PC-File User Guide

       Technical Support Information card

       Licence Agreement envelope containing: One set of 5 1/4"
       disks (Disk One, Disk Two, and Disk Three); and one set of 3
       1/2" disks (Disk One and Disk Two)

     NOTE: Upgrade packages purchased from ButtonWare contain one
     set of the requested disk size, unless you requested both
     sizes. "Retail" upgrade packages contain one set of the size
     indicated on the package, and contain a Disk Exchange Card
     that you can return to ButtonWare, if you require the other
     disk size.

       Registration card (Unless you purchased this package
       directly from ButtonWare.)

     If any item is missing or damaged, contact your PC-File dealer
     immediately. Or, if you purchased this product from
     ButtonWare, call our Customer Service department at 206-454-
     0479.


     Requirements for Using PC-File 7

     PC-File is designed to work on IBM PC, XT, AT, PS/2, and 100%
     compatible computers. In order to use PC-File, your computer
     must have the following:

     MS-DOS or PC-DOS 3.0 or higher 450K available RAM (more is
     recommended) A hard drive with a minimum of 1.5 megabytes
     available disk storage.

     To determine the version of DOS installed on your computer,
     use the DOS VER command. At the DOS prompt, type ver and press
     ENTER. To determine how much RAM and disk storage space are
     available, use the DOS CHKDSK command. At the DOS prompt, type
     chkdsk and press ENTER. The last line should indicate at least
     460,800 bytes free, if you have the minimum 450K available
     RAM. For more information on these commands, please refer to
     your DOS manual.

     Listed below are additional hardware items which are not
     required to use PC-File, but are highly recommended:

       A printer (dot matrix, daisy wheel, laser, or PostScript)

       A mouse




     PC-File Version 7 Users Guide                              6


       A CGA, EGA, VGA, or Hercules graphics card and compatible
       monitor (only required to display graphs; EGA or VGA
       required to run in graphics mode)

       A Hayes compatible modem (only required to dial phone
       numbers stored in your databases)



     INSTALLING PC-FILE

     Before you begin using PC-File, you must install it to a hard
     drive. PC-File includes an installation program designed to
     make this step quick and easy. The installation process
     normally takes less than 5 minutes.

     To install PC-File:

     1.Turn on your computer.

     2.Insert PC-File Disk One in drive A.

     3.At the DOS prompt, type a:install and press ENTER. If you
       insert the disk into a different drive, substitute the
       appropriate letter for a.  The installation program begins.
       A screen appears asking you to choose whether to install in
       color or in black and white.

     4.Choose C to run the install program in color, or choose B to
       run the install program in black & white. Choose the option
       which contains the most readable text on your screen. The
       main installation menu appears.

     5.Press F10 to continue and do a complete installation. If you
       do not want to install certain types of files, use the arrow
       keys to move the highlight bar, and press ENTER to toggle
       the checkmark on the highlighted item.  PC-File asks you to
       "Enter the Source Drive". This is usually the drive you
       inserted Disk One into.

     6.Press ENTER to accept the default drive letter. To choose a
       different drive, press the key of the letter of that drive.
       PC-File asks you to "Enter
     7.the Destination Drive". This is the drive you want to
       install PC-File on to.

     8.Press ENTER to accept the default answer. To choose a
       different destination drive, choose the letter for the
       destination drive you want to install PC-File to.

     9.PC-File asks you to "Enter the Destination Directory". This
       is the directory path on the destination drive where PC-File
       will be installed. The default destination directory is
       \PCF7.




     PC-File Version 7 Users Guide                              7


     10.  Press ENTER to accept the default answer. To install PC-
       File to a differentdirectory, type in that full directory
       path. If the directory you choose does not exist, PC-File
       will create it. PC-File begins copying files to your hard
       drive. Each file is listed as it is being installed.
       Depending on the type of disks you are installing from, PC-
       File may ask you to insert DISK TWO and DISK THREE. After
       PC-File has installed all the files, you are asked about
       changes to you CONFIG.SYS file. Your CONFIG.SYS file may
       require changes so that PC-File runs properly on your
       computer. You can let the installation program make the
       changes for you, or you can bypass these changes.

     11.  Choose Y to let the Install program make changes to your
       CONFIG.SYS file.

     12.  Choose N, to bypass making changes to your CONFIG.SYS
       file.

     13.  The last step of the Installation process is reading the
       READ.ME file. The READ.ME file is automatically displayed.
       Use the arrow keys to scroll through the entire file. It is
       important to read the READ.ME file before you begin using
       PC-File. It may contain important information added after
       the PC-File manuals were printed.

     14.  After you're finished reading the READ.ME file, press ESC
       to quit and return to the DOS prompt.

     The Install program puts you into the directory where you
     installed PC-File.

     Checking the Installation Process

     After the Installation program is finished, start PC-File to
     ensure that the installation process was successful.

     To start PC-File, at the DOS prompt, type pcf and press ENTER.
     The PC- File screen and logo are displayed. To exit PC-File
     using a mouse, click on File to display the File menu, then
     click on the Exit menu option. When the exit window displays,
     click on the Exit button. To exit PC-File using the keyboard,
     press ALT-F to display the File menu, then press X to select
     the Exit option. When the exit window displays, press X to
     select the Exit button.

     If the PC-File screen and logo are not displayed, first check
     to make sure your computer has the minimum requirements to run
     PC-File. Then re-install the program following the
     instructions above. If after re- installing the program, you
     still cannot successfully start and exit PC-File, please call
     our Technical Support department at 206-454-2629.


     INSTALLING YOUR MOUSE




     PC-File Version 7 Users Guide                              8


     Although a mouse is not required to use PC-File, it allows you
     to perform a variety of PC-File functions without having to
     use the keyboard.

     To use your mouse with PC-File, you must install it before you
     start PC-File. Refer to the manual included with your mouse
     for specific instructions on installing your mouse. If a mouse
     is connected to your computer and PC-File does not recognize
     it, refer to the manual included with your mouse for
     troubleshooting information.


     REGISTERING YOUR COPY OF PC-FILE

     Before you start using PC-File, there is one final thing to
     do-register your copy. (NOTE: You do not need to register PC-
     File if you purchased this package directly from ButtonWare-
     you are automatically registered at that time.) When you
     register your copy of PC-File, you are placed on our mailing
     list and will receive notifications of updates, new products,
     and special offers available only to registered users. In
     addition, when you register your copy of PC-File, you receive
     30 days of free
     product support.

     To register your copy of PC-File, simply fill out the
     registration card included in your package and mail it to us.
     Or, if you prefer, you can register by fax or phone. To
     register by fax, fill out the registration card and fax it to
     ButtonWare at 206-454-1838. To register by phone, call 1-800-
     JBUTTON (1-800-528-8866) or 206-454-0479.



     UPGRADING FROM PREVIOUS VERSIONS OF PC-FILE

     What Needs To Be Updated

     Data Files

     PC-File 6.5, PC-File 6.0, PC-File 5.0, and PC-File:dB
     databases are compatible with PC-File 7. No conversion is
     necessary.

     PC-File+, PC-File/R, and PC-File III databases are not
     directly compatible with PC-File 7. However, the data can be
     easily converted to a PC-File 7 database using the conversion
     program, FCONVERT, included with PC-File 7.

     Report, Letter, and Graph Files

     PC-File, 6.5, PC-File 6.0, PC-File:dB, and PC-File+ reports,
     letters, and graph files are compatible with PC-File 7. No
     conversion is necessary.




     PC-File Version 7 Users Guide                              9


     PC-File/R and PC-File III reports and letters are not
     compatible and must be redefined using PC-File 7-there is no
     way to convert them.

     Macros (Smart Keys)

     Some menus have changed from PC-File 6.0 and 6.5 to PC-File 7,
     which may require you to redefine or edit some macros.

     Because the menus and keystrokes have changed, macros from PC-
     File 5.0 and earlier versions are not compatible with PC-File
     7-you must redefine them.

     Redefining macros is an easy task using the Recording option
     on the Macros menu.

     Snapshot Labels

     Snapshot labels defined with PC-File 6.0 and 6.5 are
     compatible with PC-File 7.

     You must redefine snapshot labels defined with PC-File 5.0 and
     previous versions. In PC-File 7, simply define a Mailing Label
     using the Report menu, then "attach" the report to a snapshot
     definition using the Configuration option on the Utilities
     menu. See Chapter 15, "Taking Snapshot Labels" for details.


     CONVERTING YOUR DATABASES

     FCONVERT converts existing PC-File+, PC-File/R, and PC-File
     III databases to the PC-File 7 format. You DO NOT have to run
     FCONVERT on PC-File 5.0, 6.0 and 6.5 databases.

     FCONVERT is easy to use. You answer a few questions, and
     FCONVERT does the rest of the work. FCONVERT only converts one
     database at a time, so if you have more than one database to
     convert, you need to run FCONVERT on each database separately.

     FCONVERT reads the old format database and writes a new copy
     in the PC-File 7 format. The original database files are not
     deleted, overwritten, or altered in any way by FCONVERT. You
     should back up your old database files (.HDR, .DTA, and .INX
     files) either before or after running FCONVERT. After running
     FCONVERT, you will probably want to delete the old database
     files to free up disk space.

     Before you start FCONVERT, you must locate the database you
     want to convert. If the database is in a different directory
     than FCONVERT, you must use the complete path name of the
     database when prompted. For example, if you are converting a
     PC-File+ database called PEOPLE which is stored in the PCF
     subdirectory on drive C, the database's full path name is
     C:\PCF\PEOPLE.

     To run FCONVERT:




     PC-File Version 7 Users Guide                             10



     1.Change to the drive and directory containing FCONVERT (the
       drive and directory where PC-File 7 is installed). You can
       skip this step if this drive and directory is referenced in
       your DOS PATH.

     2.Type fconvert and press ENTER.

     3.FCONVERT prompts you for the full path name of the database
       you want to convert. Type it in and press ENTER. The
       extension isn't required. Using the PC-File+ example above,
       you would type c:\pcf\people and press ENTER.

     4.FCONVERT prompts you for the full path name of your new
       database. The extension isn't required. For example, to name
       your new PEOPLE database PEOPLE2 and put it into the DATA
       subdirectory on the D drive, type d:\data\people2 and press
       ENTER.

     5.For each numeric field (a field name ending with a # sign),
       FCONVERT asks you how many decimal positions you want. The #
       sign at the end of the field name is eliminated. Any # or
       other "illegal" characters (punctuation characters, and
       first character must be a letter) within the field name are
       replaced with underscore characters. You may need to edit
       reports, letters, and graph files to reflect these field
       name changes.

     6.If the database contains a superfield less than 254
       characters long, you must indicate whether you want the
       field converted to a memo field or a scrollable character
       (window) field. A superfield greater than 254 characters is
       automatically converted to a memo field.

     See the Reference Section, Chapter 2, "What is a Database
     Structure" for more information on memo fields. When FCONVERT
     completes the conversion, your database is ready to use in PC-
     File 7.


     BACKWARD COMPATIBILITY

     Databases originally created in PC-File:dB, PC-File 5.0, PC-
     File 6.0, and PC-File 6.5 can be opened by PC-File 7 without
     conversion. These versions and PC-File 7 all use the dBASE
     data file format (.DBF and .DBT (for memos) files). When PC-
     File 7 opens databases created with these versions of PC-File,
     it creates its own "header file" for the database that is
     saved under the same name as the database with a .DBH
     extension. For example, opening a database created under an
     earlier dBASE version called ACCOUNTS with PC-File 7 creates
     an ACCOUNTS.DBH file. This does not overwrite the "header
     file" used by the earlier versions (.HDB files), which allows
     you to continue to open the database under the earlier
     versions.




     PC-File Version 7 Users Guide                             11


     As long as you do not change the structure of the database
     using Redefine from the File menu in PC-File 7, you can
     continue to open the database using the earlier dBASE versions
     of PC-File. However, PC-File 7 will not update any indexes
     used by the earlier versions-you must rebuild indexes with the
     earlier version to access any new information added under PC-
     File 7.

     Redefining a database originally created in a earlier dBASE
     version of PC-File using PC-File 7 does not update the old
     .HDB file. To be able to open the database with the earlier
     version, you must delete the database's .HDB file which will
     allow you to "adopt" the redefined database. Any new databases
     created with PC-File 7 can also be "adopted" by previous dBASE
     versions of PC-File.

     To open databases from pre-dBASE versions of PC-File (PC-
     File/R, PC- File III, and PC-File+) with PC-File 7, you must
     convert them to the dBASE format using FCONVERT. If the
     database's structure was not changed using Redefine from the
     File menu in PC-File 7, you can open the database by importing
     the data from the PC-File 7 database's .DBF file back into the
     older version database. Any old database that has been
     redefined in PC-File 7, and any new database created in PC-
     File 7, can be opened using a pre-dBASE version of PC-File by
     first creating a new database that matches the structure
     exactly (use Database Description from the Utilities menu in
     PC-File 7 to see the stucture). Then import the data from the
     PC-File 7 database's .DBF file.


     WHAT TO DO NEXT

     Congratulations! You are now ready to begin learning and using
     PC-File. If you are new to PC-File, you will find the PC-File
     Tutorial that follows this section very helpful. The tutorial
     includes a variety of informative exercises to teach you the
     basic skills for using PC-File. For detailed information and
     instructions on using PC-File, refer to the PC-File Reference
     Section.




     PC-File Version 7 Users Guide                             12



     CHAPTER 1 NAVIGATING IN PC-FILE

     This chapter introduces you to some of the concepts and
     features of PC- File. It describes how to start and exit from
     PC-File, and how to navigate through the menus and screens.
     The chapter also lists the keys used in PC-File, and explains
     how to back up your databases.

     Starting PC-File

     Before you can begin using PC-File, you must install it. See
     the Getting Started section for information on installing PC-
     File.

     To start PC-File:

     1.Change to the drive and directory containing the PC-File
       program files. If you have accepted the installation
       defaults, this will be the \PCFILE directory on your C
       drive. If you have included that drive and directory in your
       DOS PATH statement, you can skip this step.

     2.At the DOS prompt, type pcf and press ENTER. If you are
       using Microsoft Windows and have added PC-File as a non-
       Windows application, choose the PC-File icon.

     The PC-File menu bar displays once you start the program.

     NOTE: You can load a database automatically when starting PC-
     File by following the PCF command with the database file
     specification. For example, to start PC-File 7 and load the
     database called CONTACTS in your \DATA directory on your D
     drive, you would type:

          pcf d:\data\contacts

     and press ENTER.

     Note that you do not include an extension following the
     database name.

     You can also change the parameters for the current session of
     PC-File by adding switches to the start command. See Chapter
     13, "Adding Commands at the DOS Prompt" for details on command
     line switches.

     Exiting PC-File

     When you exit PC-File, the program displays an exit window.
     The window provides brief information on the number of records
     processed during the current session.

     To quit PC-File:

     1.Choose File from the menu bar.




     PC-File Version 7 Users Guide                             13



     2.Choose Exit from the File menu.

     3.Choose Exit from the exit window.  If you change your mind,
       choose Resume to return to PC-File.

     Graphic and Character Modes

     PC-File operates in one of two modes:

       Graphics mode

       Character mode

     PC-File performs the same functions in both modes. Graphics
     mode presents a crisper, more modern appearance than Character
     mode, but Character mode offers somewhat more speed when PC-
     File is writing data to the screen and uses about 10K less
     memory.

     Graphics mode is designed for use with VGA, EGA, and Hercules-
     compatible monochrome monitors. Even with one of these
     monitors, however, you can switch to Character mode to speed
     up an operation.

     On the other hand, if you have a CGA monitor (monochrome or
     color), you can only use Character mode.

     PC-File defaults to operating in Graphics mode. You can switch
     from Graphics to Character mode, but you can do so only by
     restarting PC- File. There are two ways:

       When you start PC-File, add /CHARMODE to your starting
       command to switch to Character mode for the current session.
       For example, type pcf /charmode at the DOS prompt. PC-File
       reverts to the default (Graphics mode) the next time you
       start the program.

       Turn off Graphics mode in your configuration profile by
       removing the X from the Graphics mode check box. After
       saving the change, exit from PC-File and restart it. You
       remain in Character mode until you change the profile again
       or load another profile. See Chapter 13, "Utilities," for
       information on configuration profiles.

     Using the Mouse

     If you have a mouse, you can use it throughout most of PC-File
     to make your work easier and quicker. The only major area of
     the program where the mouse is not functional is the PC-Label
     utility.

     You must have the mouse driver that came with your mouse
     installed and loaded before starting PC-File. Refer to the
     documentation that came with your mouse for details on driver
     installation.




     PC-File Version 7 Users Guide                             14



     Use the left button of the mouse for almost every action in
     PC-File.

     The right button is only used to call up the list of macros
     for invoking execution of a macro. If you have a three-button
     mouse, the center button is not functional in PC-File.

     The mouse cursor changes shape in Graphics mode in PC-File,
     depending on what you are pointing at:

       The basic mouse cursor is an arrow or pointer, which you can
       use to choose options and buttons.

       An I-beam appears when you move the cursor into a text box,
       field, or edit window, where you can enter text.

       The cursor takes the shape of a hand when you move it over
       the title bar of a dialog box or Help window that can be
       moved about the screen.

       An hourglass appears when PC-File is performing a task that
       requires that you wait for it to finish before going on to
       the next step.

     NOTE: In Character mode, the cursor appears as a rectangular
     block at all times.

     You can block a section of text with the mouse in order to
     delete it or move it. To block the text, place the cursor at
     one end of the block and press the left mouse button. Holding
     the button down, drag the cursor to the other end of the
     block. Release the button. The block appears in reverse type.
     Use DEL to delete the text; SHIFT-DEL to delete the text and
     copy it to the buffer; CTRL-INS to copy the text to the buffer
     without deleting it; and use SHIFT-INS to copy the text from
     the buffer to another location on the screen. See Chapter 7,
     "Finding and Modifying Data," for more information on using
     the buffer.

     Using the Keyboard

     With its pull-down menus, buttons, and other features, PC-File
     is designed to be used with a mouse. If you have a mouse
     installed, you will undoubtedly find the mouse often makes it
     easier to navigate through PC-File. But any action you take in
     PC-File with a mouse can also be taken with a keystroke or
     series of keystrokes.

     Sometimes, in fact, you will find the keyboard quicker than
     the mouse. Some hot keys, for example, often prove to be
     quicker than their menu or button equivalent.

     When recording macros, you must use the keyboard instead of
     the mouse- mouse actions are not recorded.




     PC-File Version 7 Users Guide                             15


     Keys specific to a particular area or operation of PC-File are
     pointed out throughout this manual. However, a complete list
     of the keys is given below as reference.

     Navigation Keys

     Navigation keys allow you to move around on the screen. They
     normally operate in a similar fashion no matter where you are
     in PC-File. If they have multiple uses, each is explained
     below.

     Keys: Function

       ENTER:  Activate the current entry; move on to the next
       step.

       ESC:  Cancel the current operation; move back one step.

       ALT: Switch the cursor between the menu bar and the work
       area (the current record, or editing windows and dialog
       boxes with menu bars). For example, when editing a record,
       press ALT to move the cursor to the menu bar. Press ALT
       again to move the cursor back into the record. ALT-letter
       Hold down ALT and press the underlined or highlighted letter
       of a menu bar option to display the pull-down menu for that
       option. In dialog boxes, press ALT and the underlined or
       highlighted letter to choose buttons or check boxes.

       HOME: Move the cursor to the leftmost position or choice.

       END: Move the cursor to the rightmost position or choice.

       CTRL-RIGHT ARROW: Move the cursor to the first character of
       the next word.

       CTRL-LEFT ARROW: Move the cursor to the first character of
       the previous word.

       CTRL-HOME: Move the cursor to the top-leftmost position in a
       memo field or edit window.

       CTRL-END: Move the cursor to the bottom-rightmost position
       in a memo field or edit window.

       PGUP: Scrolls one window full of information above the
       currently visible window area.

       PGDN: Scrolls one window full of information below the
       currently visible window area.

       CTRL-PGUP: Move the cursor to the first field on the screen,
       when viewing records.

       CTRL-PGDN: Move the cursor to the last field on the screen,
       when viewing records.




     PC-File Version 7 Users Guide                             16


       TAB: Move the cursor to the next field, button, or option.
       The cursor moves from left to right and top to bottom. At
       the bottom-rightmost position, the cursor "wraps around"
       back to the top-leftmost position.

       SHIFT-TAB: The opposite of TAB: move the cursor to the
       previous field, button, or option. The cursor moves from
       right to left and bottom to top. At the top-leftmost
       position, the cursor "wraps around" back to the bottom-
       rightmost position.

       CTRL-TAB: Move to the right in a Table view, Modify mode.

       CTRL-SHIFT-TAB: Move to the left in a Table view, Modify
       mode.

       LEFT ARROW: Move the cursor one position or option to the
       left. On menus, at the leftmost position, cursor "wraps
       around" to the rightmost position.

       RIGHT ARROW: Move the cursor one position or option to the
       right. On menus, at the rightmost position, the cursor
       "wraps around" to the leftmost position.

       UP ARROW: Move cursor up one position, field, or option. At
       the top position, the cursor "wraps around" to the bottom.

       DOWN ARROW: Move cursor down one position, field, or option.
       At the bottom position, cursor "wraps around" to the top.


     Editing Keys

     Use editing keys in edit windows and within fields and text
     boxes to make changes to the text.

     To select or block a section of text using the keyboard, place
     the cursor at one end of the block. Then, hold SHIFT down
     while you move the cursor to the other end of the block with
     the ARROW keys or other key combinations listed below. You can
     then delete or move the block of text. Use DEL or BACKSPACE to
     delete the text. See the section on reading to and writing
     from the buffer in Chapter 7, "Finding and Modifying Data,"
     for information on moving blocks of text.

     Keys: Function

       BACKSPACE: Move the cursor one position to the left,
       deleting the character in that position or the selected
       block

       DEL: Delete the character to the right of the cursor, or the
       blocked text

       CTRL-DEL: Deletes the word the cursor is currently on.




     PC-File Version 7 Users Guide                             17


       INS: Toggle between insert and replace mode; the mode is
       indicated by the size of the cursor

       SHIFT-RIGHT ARROW: Start or extend the selection one
       character position to the right

       SHIFT-LEFT ARROW: Start or extend the selection one
       character position to the left

       SHIFT-UP ARROW: Start or extend the selection up one line

       SHIFT-DOWN ARROW: Start or extend the selection down one
       line

       SHIFT-END: Select all characters from the cursor to the end
       of the line

       SHIFT-HOME: Select all characters from the cursor to the
       beginning of the line

       CTRL-SHIFT-RIGHT ARROW: Start or extend the selection one
       word to the right

       CTRL-SHIFT-LEFT ARROW: Start or extend the selection one
       word to the left


     Hot Keys

     Hot keys are key combinations designed specifically for often-
     used actions in PC-File. If you don't have a mouse, you must
     use hot keys for some of the buttons on the button bar. Other
     hot keys replicate menu options. For example, you can choose
     Drop to DOS from the Tools menu, or you can press CTRL-D.
     Several of the hot keys provide editing functions.

     Hot key Function

       CTRL-A Continue search

       CTRL-B Blank from cursor to end of field or line

       CTRL-C Bring up the calculator (Tools/Calculator)

       CTRL-D Drop to DOS (Tools/Drop to DOS)

       CTRL-E Expand memo field to a window

       CTRL-F Duplicate field from previously-viewed record

       CTRL-H Forces insert mode; not a "toggle" like INS key (for
       macros)

       CTRL-I Switch to another index

       CTRL-J Dial phone number (Tools/Telephone dialer)




     PC-File Version 7 Users Guide                             18



       CTRL-L Print snapshot label (Tools/Snapshot)

       CTRL-M Display macro menu to invoke macro (Macro/Execute)

       CTRL-N Display next record (in Record view)

       CTRL-O Toggle between flip data and insert tilde, and flip
       data and remove tilde

       CTRL-P Display previous record (in Record view)

       CTRL-Q Spell check current selection

       CTRL-R Duplicate previously viewed record when adding

       CTRL-S Simple search

       CTRL-T Toggle between current and most recent view

       CTRL-V View memo window

       CTRL-W Display cursor location box (letters, Free form, and
       Language reports only)

       CTRL-Y Begin and end recording macro (Macro/Begin recording
       and Macro/End recording)

       ALT-O Choose OK in dialog boxes and windows

       ALT-C Choose Cancel in dialog boxes and windows

       ALT-F7 Use with ARROW keys to move dialog boxes and windows

       ALT-F8 Use with ARROW keys to resize memo window

       ALT-F10 Resize memo window to full screen

       SHIFT-DEL Delete selected text and copy to buffer

       CTRL-INS Copy selected text to buffer

       SHIFT-INS Paste selected text from buffer




     PC-File Version 7 Users Guide                             19



     Elements of the PC-File Screen

     PC-File features easy-to-use pull-down menus and dialog boxes
     throughout the program. This section explains the various
     features of the program and how to navigate in them, using a
     mouse or the keyboard.

     The Basic Screen

     When you open a database, PC-File displays the first record on
     the screen, based on the current index.

     The title bar displays the name and description (if there is
     one) of the open database. If no database is open, only the
     program name displays.

     The menu bar is the main menu for PC-File. Choosing any of the
     options on the menu bar displays a pull-down menu, from which
     you choose the actions you want to take. In some parts of PC-
     File, a small menu bar serves the current screen.

     The work area varies, depending on where you are in PC-File.
     It may be a displayed record, or an edit window for defining a
     database, report, or letter.

     Dialog boxes display to request information from you.

     Command buttons appear on the button bar for commonly used
     functions when they are appropriate. Use hot key equivalents
     if you don't have a mouse, or prefer using the keyboard.

     The status line displays the description of the current index
     and the number of records in the open database. This line is
     for information only and is not accessible with the cursor.


     Moving Between Elements with a Mouse

     If you use a mouse, you can move between the menus, work area,
     and buttons by moving the cursor to the appropriate location
     and clicking. For example, if you are modifying a record in
     the work area and want to move to the next record, you can
     click on the Next button at the bottom of the screen. If you
     want to move to the menu, click on the menu option.

     Moving Between Elements with the Keyboard

     Press ALT to toggle between the menu bar and the work area. If
     the cursor is in the work area, press ALT to move to the File
     menu. If you are on the menu, pressing ALT takes you to the
     first field in the work area.




     PC-File Version 7 Users Guide                             20


     Press ALT-letter, where "letter" equals the underlined or
     highlighted letter of the menu bar option, to move from the
     work area to a specific menu. For example, press ALT-S to
     display the Search menu.

     To access the buttons on the button bar, use the appropriate
     hot keys. For example, to display the next record, press CTRL-
     N. The hot keys are listed above and in Chapter 7, "Finding
     and Modifying Data."


     The Menu Bar

     Each option on the menu bar serves as the heading for the menu
     that pulls down below it. Thus, Edit is an option on the menu
     bar and is also the name of the menu that displays when you
     choose it.

     Some features about menu options should be pointed out:

     A grayed-out option is not currently active. Most options
     become active once you open a database.

     An ellipsis (three dots) following an option indicates that
     more information is needed before the action specified is
     taken. Normally a dialog box displays when you choose the
     option.

     A check-mark indicates that one of two options is chosen. For
     example, on the Edit menu, you can toggle between Modify mode
     and Read-only mode. Only one of these options can be chosen at
     a time. Choose the unchecked option to change options.

     Choosing Menu Options with a Mouse

     To display a pull-down menu, click once on the menu bar
     option. To choose an option on a pull-down menu, click once on
     that option. For example, to open a database, click on the
     word File to open the File menu, then click on Open to display
     a dialog box.

     Choosing Menu Options with the Keyboard

     Use the left and right arrows, or TAB and SHIFT-TAB, to move
     along the menu bar. Highlight an option and press ENTER or the
     DOWN ARROW to display the pull-down menu. If no menu is pulled
     down, you can also press the first letter of the menu bar
     option to highlight it and display its pull-down menu. If you
     are elsewhere on the screen, press ALT and the underlined or
     highlighted letter of the menu bar option to display the pull-
     down menu. For example, press ALT-S to display the Search
     menu.




     PC-File Version 7 Users Guide                             21


     Once a pull-down menu is displayed, press the underlined or
     highlighted letter of an option to choose that option. You can
     also use the UP and DOWN ARROWS to highlight an option, then
     press ENTER to choose it.

     Dialog Boxes

     PC-File uses dialog boxes to request information. You may be
     asked to choose an option from a list, menu, or group of
     buttons, or enter a name or description. Dialog boxes take on
     a wide variety of shapes and forms in PC-File, but they are
     simple to use.

     Moving Dialog Boxes

     Most dialog boxes can be moved if they cover something you
     want to see while the box is on the screen.

     With a mouse, point at the title bar, hold the left button
     down and drag the dialog box where you want it. The cursor
     changes to the shape of a hand (in Graphics mode only) when
     you move it onto a title bar.

     With the keyboard, press ALT-F7, then use the ARROW keys to
     reposition the box. Press ENTER once the box outline is
     located where you want it.

     Moving Within Dialog Boxes

     Dialog boxes normally contain one or more elements, including
     buttons, boxes, and lists. Use the following techniques to
     move within and between these elements.

     With a mouse, click on the element of the dialog box you want
     to move to or change. If it is a command or option button,
     clicking once activates the button.

     With the keyboard, use ALT-letter, where "letter" is the
     underlined or highlighted letter of the appropriate element,
     to move the cursor to that element. For option buttons and
     check boxes, ALT-letter is the only access if you don't have a
     mouse. For other elements, you can also use TAB and SHIFT-TAB
     to move within and between elements. Use TAB to move to the
     right or down, SHIFT-TAB to move up or to the left.

     To accept the current options, choose the OK button or press
     ALT-O.

     Choose the Cancel button (you can press ALT-C) or press ESC to
     cancel the operation and move back one step.


     Elements of a Dialog Box

     Dialog boxes can contain command and option buttons, text and
     list boxes, and check boxes.




     PC-File Version 7 Users Guide                             22




     Command Buttons

     Command buttons are the rectangular buttons used to initiate
     an action. They appear on the button bar as well as in dialog
     boxes. The OK and Cancel buttons found in most dialog boxes
     are command buttons.

     With a mouse, click once on a command button to initiate the
     action.

     With the keyboard, press the underlined or highlighted letter
     on the button to initiate the action. If the dialog box
     includes a text box, press ALT and the underlined or
     highlighted letter. For the OK and Cancel buttons, press ALT-O
     or ALT-C respectively to initiate the action. You can also
     move the cursor to the command button and press ENTER.


     Text Boxes

     Text boxes allow you to type in information. When you move the
     mouse cursor to a text box, the mouse cursor changes from an
     arrow to an I- beam.

     Type the appropriate text in the highlighted box. In some
     cases, default text may be shown, in which case you can leave
     the default or type over it.

     All text boxes have a limit to the number of characters you
     can enter. Some text boxes are scrollable, allowing you to
     enter more information than the displayed area indicates. In
     those cases, the text scrolls to the left. Either way, PC-File
     beeps when you reach the character limit of the box.


     List Boxes

     A list box provides a menu of options to choose from. Some
     list boxes permit just one choice; others, called check-off
     lists, allow for multiple selections.

     List boxes often include scroll bars, indicating there may be
     more options than are shown.

     With a mouse, click above or below the scroll box or on the
     scroll arrows to scroll up or down the list of options. You
     can also drag the scroll box. To do so, click on the scroll
     box, hold the mouse button down, and drag the box up or down
     the scroll bar. Click on an option to choose it.

     With the keyboard, use the UP and DOWN ARROWS to scroll. To
     choose an option, move the highlight to the desired option
     with TAB and SHIFT-TAB or UP and DOWN ARROWS and press ENTER.




     PC-File Version 7 Users Guide                             23



     When you may need to make more that one selection from a list,
     PC-File uses a field selection list box. Check-off list boxes
     display a checkmark next to each option you select. If the
     order of selection is important, a number indicating the order
     also displays.

     With a mouse, click on an option to select it. Repeat for each
     additional selection you want to make.

     With the keyboard, use the UP and DOWN ARROWS to highlight an
     option. Press ENTER to select the option. Repeat for each
     additional selection you want to make.

     You cannot undo individual selections. If you make a selection
     in error, you must undo all of your selections and make them
     over again. Choose the Reset button to remove all checkmarks
     and numbers.

     Once you have finished making all of your selections, choose
     OK to initiate the action.


     Option Buttons

     PC-File uses option buttons to indicate available program
     options. You can only choose one option at a time.

     With a mouse, click on the button to choose it.

     With the keyboard, press ALT-letter, where "letter" is the
     underlined or highlighted letter of the button label, to
     choose the appropriate button.


     Check Boxes

     Check boxes allow you to turn individual options ON and OFF.
     An X in the box indicates the option is turned ON.

     A check box is a toggle. Choose it once to turn the option ON;
     choose it again to turn the option OFF.

     With a mouse, click within the box itself to choose it. Don't
     click on the label.

     With the keyboard, press ALT-letter, where "letter" is the
     underlined or highlighted letter of the box label, to choose
     it.


     The Work Area

     The work area in PC-File is of three types:

       The main screen




     PC-File Version 7 Users Guide                             24


       The edit window
       The view designer


     The main screen is the screen you are looking at when you are
     adding, modifying, or viewing your records. When modifying or
     viewing records, you can be in either of two formats: a Record
     view or a Table view.

     The edit window is a specialized word processor which displays
     when you write a letter, or create a report using the Free
     form and Language formats. Within the edit window you can
     enter text

     The view designer is used to create and modify database views.
     The view designer lets you manipulate text and fields as
     objects you can move within a view using the mouse or
     keyboard.

     Editing keys used on both the main screen (in Modify mode
     only) and in the edit window are described later in this
     chapter.


     Drawing Lines and Boxes

     Within the edit window only, PC-File lets you draw lines and
     boxes as part of a structure. Lines and boxes can add clarity
     to the structure by enclosing and sectioning off related
     fields.

     You can create lines and boxes by using characters from the
     ASCII table. To use these characters, hold down ALT while
     keying in the decimal value of the character. Then release the
     ALT key. For example, to enter +, hold down ALT and key in the
     numbers 2 1 8, using the numeric keypad on the right side of
     the keyboard.

     The complete ASCII Table is found in Appendix D.

     Other ASCII characters, such as letters from other languages,
     can be entered in the same way.


     Status Windows

     Printing a report or checking for duplicate records in a large
     database can often take several minutes. PC-File provides a
     handy feature that lets you know how the operation is
     progressing.

     This feature, called a Status window, appears in the lower
     right corner of your screen. It displays during all record
     processing, except when you are printing a report, letter, or
     graph to the screen. In those cases, the window could block
     your view, so it is not displayed.




     PC-File Version 7 Users Guide                             25



     The fields and status bars in the window are described below:

       Records: Shows total number of records in the database,
       including any deleted records whose space has not been
       reused.

       Scanned: Indicates the number of records read.

       Selected: Indicates number of records selected.

       Percent selected: Indicates the percentage of records read
       that have been selected. If you choose All records, this
       always shows 100 percent. If you choose Some records, it
       indicates what percentage have been selected from those read
       so far.

       Percent complete: Indicates what percentage of the total
       records in the database have been read.


     Selecting Files and Fields

     Two operations show up repeatedly in PC-File. To ensure that
     you understand how to perform these operations, the procedures
     are detailed here in full.

     Selecting a File

     File selection dialog boxes appear when you want to open a
     database or a feature of the database, such as a report or
     letter, that PC-File maintains in a separate file. Use this
     dialog box to choose the file you want.

     There are two ways to select a file:

       Choose the path and file from the directory and file list
       boxes

       Enter the path and file in the text box

     The path is the drive and directory where the file is located.
     Directories can be nested within other directories down to
     many levels.


     To choose the file from the list boxes:

     1.Choose the path first, using the directory list box.

       Choose (..) to move up the hierarchy of directories, if
       necessary. Choose a drive letter to change drives. Choose a
       directory to list the files in that directory. The current
       path is displayed above the directory list box.

     2.Choose the file from the file list box.




     PC-File Version 7 Users Guide                             26



       All the files in the current directory with the file
       extension appropriate to the current file selection dialog
       box are listed. For example, if you are selecting a
       database, all files with the extension .DBF located in the
       current directory are listed.


     To enter the file in the text box:

     1.Place the cursor at the start of the text box.

     2.Type in the path and file name. The file extension is
       usually unnecessary. For example, to select the MEMBERS
       database, type c:\pcfile\sample\members
       If the drive listed is already correct, you can just enter
       the directory and filename. For example, type
       \pcfile\sample\members If the path is already correct, you
       can just enter the file name. For example, type members

     3.Press ENTER or choose OK.

     If you can't remember where your file is located, use the
     command buttons labeled "This drive" or "All drives." Choose
     "This drive" to display all the appropriate files on the
     current drive. Choose "All drives" to display the appropriate
     files in drives C through Z. PC- File searches up to 10
     subdirectories deep and displays the first 100 appropriate
     files it finds.


     Selecting a Field or Partial Field

     Many PC-File operations require that you choose one or more
     fields from the database. When that step arises, PC-File
     displays a field selection dialog box.

     In some cases, you can select just a single field. To do so,
     click on the field with the mouse or use the arrow keys to
     highlight the field and press ENTER.

     In other cases, you can select multiple fields. Choose the
     fields in the order of importance. A check mark and a number
     representing the order appears next to each field as you
     select it. When you have chosen all the fields you want,
     choose OK.

     In rare cases, you may want to choose the same field twice. If
     you choose a field a second time, only the second number
     appears next to the field. However, the field is used twice in
     the operation, in the order selected.

     If you make a mistake while choosing multiple fields, choose
     Reset. The check marks and numbers disappear, allowing you to
     start over.




     PC-File Version 7 Users Guide                             27


     You can also choose a partial field. For example, if you want
     to use the first five digits of a nine-digit zip code field,
     you can designate those character positions in the field.

     To select a partial field, use the text box in the field
     selection dialog box. Enter the partial field in the following
     format:

          Field name,starting position,number of positions

     The starting position is the position of the first character
     you want to choose from the field. The number of positions is
     the total number of characters in your selected partial field,
     beginning with that first character. Use commas between the
     three parts of the command. Do NOT use spaces.

     As an example, consider a field called Phone that contains
     numbers in the following format: 206-454-0479. To print just
     the phone number without the area code, you would designate a
     partial field of just the last eight characters. In the text
     box, you would type

          Phone,5,8

     The example shows a partial field selection starting at the
     fifth position and selecting eight characters.

     In the example of the nine-digit zip code field, enter the
     partial field like this:

          Zipcode,1,5

     This prints five characters of the field, starting with the
     first character.

     You can use the text box for entering whole fields, as well as
     partial fields. If you want to select a whole field in this
     way, you only need to enter the field name.

     The text box can be handy for recording macros as well. To
     choose a field while recording a macro, type the field name in
     the text box. This avoids possible problems with any changes
     in the order of the fields in the list box.


     Using Help

     PC-File provides an on-line Help system throughout the
     program. This Help system is context-sensitive, providing
     instant information about the current screen or dialog box.

     Help takes several forms in PC-File. The following chart
     illustrates the available options:

     Menu option: Key: Purpose




     PC-File Version 7 Users Guide                             28


     Help now: F1: Context-sensitive Help about current     option,
     dialog box, or screen

     General Help: ALT-F1: Reference help (a list of   keys,
     navigation tips, and menu information)

     Choose OK or press ESC to remove a Help window from the
     screen.

     Help windows work like dialog boxes in that you can move them
     around the screen if they are covering something you want to
     see. With a mouse, place the cursor on the title bar, press
     the left button, and drag the window. With the keyboard, press
     ALT-F7, then use the arrow keys to move the window.


     Backing Up Your Databases

     Back up your databases frequently. Your databases are the
     result of your time and effort and, perhaps, money. You can
     never predict when a database may be damaged. You or other
     users might erase data by mistake, your hard disk may crash,
     or the electricity may go out. If you have no backup, all
     could be lost.

     Keep at least two copies of each database on separate floppy
     disks in addition to the copy you use regularly. You might
     want to get into a routine of backing up one copy one day and
     the other copy the following day. Some users maintain a copy
     for each day of the week, with the day clearly marked on the
     floppy disk.

     Back up all the database files when you first create a
     database. Once you have done that, you only need to back up
     those files you make changes to. For example, when you add or
     modify data, back up the data file. If you create or modify a
     report, back up the report file.

     There are several ways to back up a database:

       Use the DOS BACKUP command

       Use a special backup program or tape software

       Use the DOS COPY command

       Use the Copy option in PC-File (choose File Management from
       the Utilities menu)

     Each method is explained below.

     NOTE: You can't back up an open database. If you use the Copy
     option in PC-File to back up a database, close the current
     database first. If you backup from the DOS prompt, exit from
     PC-File and then issue the BACKUP command.




     PC-File Version 7 Users Guide                             29


     Using the DOS BACKUP Command

     If a database is too large to fit on a single floppy disk, use
     the DOS BACKUP command. This command lets you copy the entire
     database onto several floppy disks. You must use the DOS
     RESTORE command to copy the database back onto a hard disk, if
     that need arises. See your DOS manual for more information on
     the use of these commands.

     To back up a database using the DOS BACKUP command:

     1.At the DOS prompt, enter the command to back up the
       database. For example, to back up the MEMBERS database to
       floppy disks in drive A, you would type the command

          backup c:\pcfile\sample\members.* a:

          and press ENTER.

     Using Special Backup Programs

     You can back up databases with programs specifically designed
     for that purpose. You can also use tape backups for databases.
     If you have a special backup program, see the manual that
     comes with it for instructions.

     Using the DOS COPY Command

     If your database is small enough to fit on a single disk, you
     can use the DOS COPY command. See your DOS manual for more
     details on using this command.

     To back up files using the DOS COPY command:

     1.At the DOS prompt, enter the command to copy the database.
       For example, to copy the MEMBERS database to a floppy disk
       in drive A, you would type the command

          copy c:\pcfile\sample\members.* a:

          and press ENTER.

     Using PC-File's Copy Option

     PC-File makes it easy to back up files from within the
     program. The procedure is not quite as fast as the DOS
     commands, but you don't have to exit from the program to do
     it. And PC-File groups the files in such a way that backing up
     is easier.

     NOTE: If copying to a floppy disk, the database files (files
     with extensions .DBF, .DBT, and .HDB) must fit on one disk. If
     your database files don't fit on a single disk, you must use
     the DOS BACKUP command or a special backup program instead.




     PC-File Version 7 Users Guide                             30


     To back up files using the PC-File copy option:

     1.Choose Utilities from the menu bar.

     2.Choose File management from the Utilities menu. PC-File
       prompts you to choose one of three options: Copy, Delete or
       Rename.

     3.Choose Copy.

     4.Choose the type of file to copy. Choose Database to back up
       the structure and data in a database. All database files
       with the listed file extensions will be copied. The other
       options copy files with the indicated file extensions.

     5.Choose or enter the drive, path, and file name you are
       copying from.

     6.Choose or enter the drive, path, and file name you are
       copying to. If you are copying to a floppy disk, you
       normally just need to enter the drive and file name.

     NOTE: For information about PC-File files and file extensions,
     see Appendix C, "Program and Database Files."




     PC-File Version 7 Users Guide                             31




     CHAPTER 2 CREATING A DATABASE STRUCTURE

     The first step in defining a database is defining the database
     structure. You "tell" PC-File what your fields will be named,
     what type of data will be stored in them, and how long each
     field will be. This chapter covers the details of this
     process, plus other database design considerations. Opening
     and closing an existing database is also described.

     Opening and Closing a Database

     Some menu options, such as Configuration, are accessible
     without an open database. However, unless you are creating a
     new database, you will generally want to open a database once
     you start PC-File. You can then begin working with the
     database. Alternatively, you can open a database when starting
     PC-File from DOS.

     Opening a Database

     To open a database:

     1.Choose File from the menu bar.

     2.Choose Open from the File menu. A file selection dialog box
       appears, with the databases in the current directory listed.

     3.Choose the database you want to open by clicking on it and
       choosing OK, or highlight the text box and type in the
       database name. If the database is located in another
       directory, use the Directory list box to move to that
       directory. You can open only one database at a time. If you
       open a second database, PC-File automatically closes the
       first database.

     NOTE: You can open any database that uses dBASE-format files.
     These are files created with a program such as dBASE or FoxPRO
     and which use the extension .DBF. PC-File creates a header
     file automatically, which allows you to use certain features
     specific to PC-File. You are also prompted to enter a database
     description. The description is optional.

     To load a database automatically when starting PC-File from
     DOS type pcf followed by the database file specification. You
     do not need to include the database file extension. For
     example, to start PC-File and load a database called CONTACTS
     in the \DATA directory on drive D, you would type the
     following at the DOS command prompt:

          pcf d:\data\contacts

     and press ENTER.

     To open a database when starting PC-File:




     PC-File Version 7 Users Guide                             32



     1.Type PCF at the DOS prompt followed by the desired
       database's file specification in the following format:
       pcf d:\subdirectory\databasename

     2.Press ENTER

     Closing a Database

     To close a database:

     1.Choose File from the menu bar.

     2.Choose Close from the File menu. If you are ready to quit
       PC-File, you can choose Exit instead. The program closes the
       database automatically.

     If you want to open another database, choose Open from the
     File menu. PC-File closes the current database before opening
     a new one.


     The Database Structure

     PC-File allows you to create a database easily by defining a
     basic database structure. The database structure defines what
     fields you will have for each record in your database. (See
     Lesson 1, "Understanding Databases," in the Tutorial section
     if you are not familiar with database terminology and
     concepts.)

     After you have created the basic database structure, you can
     add additional features if you want. You can:

       Change field attributes, such as calculations, special
       formatting, or data validation rules, using the Field
       Attributes option on the File menu.

       Create different views to change the way the data is
       displayed in the work area using the Create option on the
       Views menu.

       Define indexes to sort your data different ways using the
       Index Maintenance option on the File menu.

     This section explains how to create the basic database
     structure. See Chapter 4, "Adding and Modifying Field
     Attributes" for details on how to change field attributes. See
     Chapter 5, "Database Views" for details on how to change the
     view of the data. See Chapter 8, "Indexing Data" for details
     on how to create indexes.


     There are three ways to create a new database structure:

       Create a database structure from scratch




     PC-File Version 7 Users Guide                             33



       Create a database structure by patterning after an existing
       database

       Redefine an existing database and build a new file

     Patterning after a database copies only the original
     database's structure: field names, lengths, and types. If you
     also want to copy a database's field attributes and custom
     views, you must redefine an existing database. Redefining also
     gives you the option to transfer some, all, or none of the
     records to the new database.

     This chapter explains how to create a database structure from
     scratch or by patterning after another database. See Chapter
     3, "Modifying a Database Structure," for information on how to
     redefine an existing database.

     What is a Database Structure?

     The single most important element of a database is its
     structure. The database structure consists of the fields you
     want for each record in your database. Each field represents a
     different category within the set of pieces of information
     that make up a record.

     Each field has a field name that uniquely identifies it within
     the database structure. The field name appears on the entry
     screen when entering records, and is also used to access a
     field's data for many other database operations such as
     calculations, printing reports, defining indexes, relational
     operations, and exporting.

     Each field has a field type that is determined by the kind of
     information you will be storing in the field. A field in PC-
     File can be one of five field types: Character, Numeric, Date,
     Logical, or Memo.

     Lastly, each field has a field length that determines how many
     chararacters you can enter and store in the field.

     A simple example of a database base structure would be a
     database to store names and phone numbers. To create such a
     database, you might define a database structure with 3 fields
     named: FIRST_NAME, LAST_NAME, and PHONE.

     After naming the fields, you need to determine what field
     types to use. The FIRST_NAME and LAST_NAME fields will only
     contain letters and possibly punctuation, so they both would
     be designated as character type fields. The PHONE field will
     contain numbers, so you might think it should be a numeric
     field type. But a phone number field will also contain dashes
     between numbers and possibly parentheses around area codes. A
     numeric field will only store numeric values, therefore you
     must also
     designate PHONE as a character field.




     PC-File Version 7 Users Guide                             34



     You also need to determine how long to make your fields.
     Choose lengths that are appropriate for the data you will be
     working with, keeping in mind that even empty fields and
     spaces at the end of a field entry take up disk space. You
     might make FIRST_NAME 10 characters long, LAST_NAME 15
     characters long, and PHONE 14 characters long (assuming you
     are formatting your phone numbers like: (555) 555-1234).

     See the "Fields and Field Characteristics" section later in
     this chapter for more details on field names, types, and
     lengths.


     Maximum Record Size

     The overall size of each record is determined by the sum of
     the lengths of all fields, except memo fields each of which
     account for 10 characters of the record size. The maximum
     number of characters PC-File allows per record is 4,000. And,
     you can have no more than 128 fields per record.

     To calculate the record size of your database strucuture, add
     the lengths of each character and numeric field, plus 8 for
     each date field, 1 for each logical field, and 10 for each
     memo field. This number must total 4,000 or less.

     (Note: Memo field data is stored in a separate file-the number
     10 used for memo fields when calculating record size accounts
     for the information stored in the main data file that "points"
     to data stored in the memo file.)

     Here is an sample calculation to determine the record size for
     a simple database:

     FIELD          Type           Length

     FIRST_NAME     Character      15
     LAST_NAME      Character      15
     PHONE          Character      15
     ENROLL_DATE    Date           8
     MEMBER_YN      Logical        1
     DUES_PAID      Numeric        6
     NOTES          Memo           10

     Total Size 70


     Fields and Field Elements

     The building blocks of a database structure are the fields.
     Creating a database basically involves defining the elements
     of each field. The field elements that you can define in PC-
     File are listed below.

     Elements: Purpose




     PC-File Version 7 Users Guide                             35



     Field Name: Uniquely identifies a field.

     Field Type: Defines the kind of data a field contains. The
     field type may limit what characters are allowed, the format
     that is accepted, and how the data is handled for sorting,
     searching, or calculations.

     Length: Defines the number of characters allowed in a field.
     The lengths allowed vary for each field type. For character
     fields, you can select a length that exceeds 65 characters,
     but only 65 characaters will display in the work area at once.

     Decimals: Applies only to numeric data. This determines how
     many places to the right of the decimal to display.
     Calculations in numeric fields are rounded to this number of
     places.

     Physical Order: The order in which you enter the fields is the
     physical order of the data base. Fields will initially be
     accessed in this order. However, you can provide different
     access orders by defining custom views (see Chapter 5).

     The field name, field type and length are required elements
     for all fields. Decimals are only required for numeric fields
     and can be set to zero. At zero, any data entered on the right
     side of the decimal is rounded and is not stored in the
     database.


     Field Names

     Field names can be up to 10 characters long and can contain
     letters, numbers, or the underscore ( _ ) character. Field
     names must start with a letter. Spaces are not allowed.

     All field names in the same database must be unique. PC-File
     treats both uppercase and lowercase letters in field names the
     same. Thus, you couldn't name two separate fields PHONE and
     Phone in the same database.

     NOTE: By default, PC-File puts the field names on the screen
     next to the fields. This shows you which fields correspond to
     which field names. You can change this text or put additional
     text on the screen by defining a custom view. Custom views
     allow you to put nearly any text on the screen-you don't have
     to follow the rules for field names mentioned above. See
     Chapter 5, "Views" for details on how to define custom views.


     Field Types

     Field type determines the kind of information that can be
     entered into a field. It can also determine the length of a
     field, or a range of lengths. Field type must be defined for
     every field.




     PC-File Version 7 Users Guide                             36



     The table below lists each of the five field types supported
     by PC- File, their length or range of lengths, and their
     allowable characters. Additional information about each field
     type follows the table.

     Field type: Field length: Allowable characters

       Character: 1 to 254: All letters, numbers, and other
       characters found on a typical keyboard (all ASCII characters
       with a decimal value over 31)

       Numeric: 1 to 19: All numbers, and optionally: the decimal
       point (period), leading minus sign (hyphen), or leading plus
       sign

       Date: 8: All numbers, plus the slash, hyphen, or period

       Logical: 1: T or F, Y or N

       Memo: 5000: Same as Character fields, except for _ which is
       reserved as a control character.

     Character Fields

     Most fields you define are of this type. Character fields can
     include letters, numbers, and most other characters found on a
     typical keyboard. Additionally, you can enter extended
     characters by pressing the ALT key and entering the
     character's ASCII decimal value on the numeric keypad. You can
     also enter extended characters directly from the keyboard if
     your system is configured to use character sets for languages
     other than United States English with the DOS KEYB program-
     see your DOS manual for details.

     Numeric Fields

     Numeric fields contain arithmetic values. They are precise up
     to eight decimal positions.

     Just because a field contains numbers does not mean it should
     be a numeric field. As a general rule, if using the data in a
     calculation would be meaningless, define the field as a
     character field. For example, you would not use phone numbers
     in a calculation, so a phone number field should be defined as
     a character field.

     Additionally, PC-File discards everything to the right of the
     first non-numeric character it encounters in a numeric field.
     If you enter data that contains both numbers and other
     characters into a numeric field, some of your data will be
     lost. For example, if you enter the phone number 206-555-1212
     into a numeric field, PC-File converts and stores this as a
     value of 206. Zip codes, social security numbers, or part
     numbers are other good examples of data that contain numbers
     but should be stored




     PC-File Version 7 Users Guide                             37


     in character fields.

     Fields that you define to number records consecutively should
     be numeric fields. These fields are often used to sort records
     and defining them as character fields will result in the
     following sort: 1, 10, 101, 11, 2, 21-PC-File essentially
     "alphabetizes" numbers entered into character type fields. The
     same set of numbers entered in a numeric field would be sorted
     properly: 1, 2, 10, 11, 21, 101.

     Numeric fields are never displayed or stored as blank. PC-File
     displays and stores 0 in any numeric fields left blank when
     adding records.

     Date Fields

     Typical date fields are birth dates, expiration dates, and due
     dates. Unless you want to use a non-standard date format, you
     should define any field you want to enter dates into as a date
     type field. This allows PC-File to properly sort and search
     the field.

     Internally date fields are always stored as 8 characters of
     data in a YYYYMMDD format. When defining date type fields for
     your database structure, the only length allowed is 8.
     However, date fields can be displayed using either 8- or 10-
     character formatting (using either a 2- digit or 4-digit
     year). Date formatting is set using the Default Date Format
     options on the Configuration dialog, or by setting Date format
     as a field attribute. See Chapter 13, "Default Date Format"
     and Chapter 4 "Date
     Format" for details on how to change date display formatting.
     If you do not set date display formatting, PC-File defaults to
     displaying dates in 10-character MM/DD/YYYY format.


     NOTE: The following information assumes you are using PC-
     File's default Month/Day/Year formatting. You can reconfigure
     PC-File to use other date formats using the Configure option
     on the Utilities menu. See Chapter 13, "Default Date Format"
     for details.

     Date fields will only accept entries made in valid formats.
     Regardless of how dates are configured to display, PC-File
     only accepts date entries in two formats:

     MM/DD/YY-"March 1, 1993" would be typed in as: 03/01/93 or
     3/1/93. Internally, PC-File converts and stores this as
     19930301. PC-File assumes the date is in the 20th century and
     adds 19 at the beginning of the stored data for all dates
     entered in the MM/DD/YY format.




     PC-File Version 7 Users Guide                             38


     MM/DD/YYYY-"March 1, 2001" would be typed in as: 03/01/2001 or
     3/1/2001. Internally, PC-File converts and stores this as
     20010301. Because the full year is provided when entering
     dates in this format, no century is assumed. This allows you
     to enter dates from any century.

     PC-File will display dates entered using either format as
     MM/DD/YYYY, unless date display formatting was changed using
     Configuration or Field Attribute settings.


     NOTE: While date fields formatted to display 8-character date
     formats also accept entries in either MM/DD/YYYY format, and
     internally store the full year so entered, PC-File converts
     the dates to display in MM/DD/YY format. PC-File sorts
     properly if this field is indexed, but you cannot visually
     distinguish between dates from different centuries. For
     example, MM/DD/YYYY formatted data entered for "January 1,
     1901" and "January 1, 2001" display identically: 01/01/01.
     Therefore, you should always
     use a 10-character date display formatting for entering dates
     before 1900 or after 1999.

     Also, PC-File date type fields convert any year entered as
     less than 100 to a 20th century year. Therefore, PC-File date
     fields can only be used to store dates from the years 100 AD
     to 9999 AD.

     Logical Fields

     Logical fields are used for either/or situations. You can
     enter only one character: T (True), F (False), Y (Yes), or N
     (No), using either upper- or lowercase letters.

     Memo Fields

     Memo fields are a type of character field, but with a much
     longer maximum field length (5000 characters). Use them to
     store large amounts of text. Memo fields can't be indexed.

     Use memo fields sparingly, as memo text requires an additional
     file that can take up large amounts of disk space. Also, each
     memo field requires additional system memory. As a general
     rule, you should limit the number of memo fields in your
     database to preferably no more than 2.

     NOTE: However, you may not be able to use a database defined
     with the maximum of 10 memo fields. PC-File has to set aside
     memory to manage each memo field when it opens the database.
     How much memory PC-File can use may vary depending on how the
     system it is running on is configured.




     PC-File Version 7 Users Guide                             39


     Memo text is stored in a file called databasename.DBT, where
     "databasename" is the name of the database. Within that file,
     memo text is stored in blocks of 512 characters. In other
     words, at least 512 bytes of space are used up even if the
     field only contains a single character. On the other hand, if
     the field is left blank, no space is taken up in the memo
     file. Once the amount of data in a memo field exceeds 512
     characters, an additional 512 bytes is added to the .DBT file,
     and so on up to the 5000 character size limit. Choose the
     character field type unless: you will need more than 254
     characters for the field; if the field will be used
     infrequently; or if you don't need to worry about disk space.



     NOTE: When you edit a memo field, PC-File attempts to reuse
     the blocks previously used in the .DBT file. If PC-File is not
     able to reuse the blocks, they are set aside (but still remain
     as part of the .DBT) and new blocks are used. For this reason,
     if you edit your memo fields frequently, the .DBT file may
     grow larger than you expect it should be relative to the size
     of the rest of the database. Packing the database using Pack
     on the Utilities menu will remove unused information from the
     .DBT.

     Length

     The field length is the maximum number of characters available
     for data entry. Defining a field length of 15 characters for a
     LASTNAME field, for example, would allow the entry of any last
     name up to 15 characters in length.

     Field length is determined by field type. Some field types
     allow you to set the field length within a range, while others
     are predetermined. For example, character fields can be from 1
     to 254 characters long, but date fields must be 8 characters
     long. The field lengths allowed for each field type are
     described in the table at the beginning of the "Field Type"
     section.

     Decimal Places

     Numeric fields require that you specify the number of
     positions to the right of the decimal. PC-File provides
     precision for up to eight places to the right of the decimal.

     The number you enter for the field length specifies the total
     length of the numeric field. If you are defining decimal
     places, the total length includes a position for the decimal
     point plus any positions to the right of the decimal point.
     The maximum number of decimal places you can define is the
     field length minus two, keeping in mind that the decimal point
     itself is part of the total length. In other words, if you
     define a numeric field as 10 positions long, you can place up
     to eight of




     PC-File Version 7 Users Guide                             40


     those positions to the right of the decimal. The largest
     number you could enter into a field with a length of 10 and 8
     decimal places would be: 9.99999999.

     Data Length vs. Display Length

     PC-File distinguishes between data lengths and display
     lengths. The data length is the maximum number of characters
     the field can contain. The display length is the number of
     characters that show on the data entry screen at one time. For
     character and memo fields, the data length can exceed the
     display length. You are specifying the data length when you
     define or redefine a database structure.

     The maximum data length for character fields is 254
     characters. If you want to store more than 65 characters in a
     character field, you should specify that when you create the
     database. If you forget to do this or change your mind later,
     you can use the Redefine option on the File menu to change a
     field's data length.

     PC-File defaults to using display lengths of 65 for all memo
     fields and for character fields with data lengths longer than
     65. For character fields with data lengths 65 or less, PC-File
     defaults to using a display width that matches the data
     length. You can set the display width to be less than the data
     length for character fields and memo fields using the View
     designer as explained in Chapter 5.

     You can scroll within a field that has a data length larger
     than its display length. It's as if you were looking at the
     field through a window, only able to see part of the data at
     any one time. To see other portions of the field, you move the
     cursor left or right, which moves the visual window across the
     data.

     A memo field always has a data length larger than than its
     display length. You can scroll through the memo as described
     above, or you can pop up an editing window to view or edit the
     memo's contents. See Chapter 4, "Entering Data in a Memo
     Field" and Chapter 5, "Viewing a Memo Field" for more details.

     Numeric and logical type fields display lengths must be the
     same as their data lengths-you cannot change their display
     widths. Date fields' default display lengths are 10.




     PC-File Version 7 Users Guide                             41




     Creating a New Database Structure

     The process of creating a new database structure brings
     together all the elements discussed above. If you have any
     questions about specific elements while defining your new
     database structure, refer to the preceding sections for
     details on each element in the database structure: Field Name,
     Field Type, Field Length, and Decimals.

     Defining by Patterning After an Existing Database

     If you want, you can start the database definition process by
     patterning after the structure of an existing database. This
     is useful if you want to create a copy of a database, or to
     start from another database's definition.

     Starting by "patterning after" only copies the existing
     database's structure: the field's names, their types, and
     lengths-calculations and other field attributes are not
     copied. If you also want to copy the database's field
     attributes and custom views, you must open the database you
     want to copy and use the Redefine option on the File menu,
     choosing to build a new file. See Chapter 3 for details on
     redefining.

     When you choose New from the File Menu, you will be asked

     Pattern after Existing Database?

     Answering Yes to this dialog displays a file selection dialog
     box so you can choose the database structure to copy. After
     you choose the database to copy, the Define screen displays
     with the copied database's field definitions. You can then
     continue with the definition process: adding, modifying, or
     deleting fields as necessary.

     Answering No to this dialog proceeds to an empty Define screen
     to allow you to define a database from scratch.


     To start defining a database by patterning after an existing
     database:

     1.Choose New from the File menu.

     2.Choose Yes. The file selection dialog displays. See Chapter
       1, "Selecting a File" for more information on how to use a
       file selection dialog box.

     3.Choose the database to pattern after. The Define screen
       displays with the selected database's field characteristics
       filled in. Continue the definition process as described
       below.




     PC-File Version 7 Users Guide                             42



     The Define Screen

     After you answer the "pattern after" prompt, the Database
     Structure Screen appears.

     The Define screen consists of 5 columns of information: Field
     Number, Field Name, Type, Length, and Decimals. PC-File
     determines the field number and you enter the rest of the
     information for each field's definition.

     PC-File will start with one blank field definition line for
     you to enter information. A new field definition line is added
     whenever you advance below the last line in the Define screen,
     up to the maximum of 128 fields.

     The scroll bar to the right of the field definition lines is
     used to scroll the field list when defining more fields than
     will fit on the screen.

     The left end of the button bar of the Define screen has three
     buttons: Add, Insert, and Delete. These buttons can be used to
     edit your field list, if necessary.

     The OK button on the right end of the button bar lets you
     continue the definition process when you are done specifying
     all the field details on the Define Screen.


     Navigating in the Define Screen

     Once you start adding fields, PC-File displays as many field
     definition lines as will fit on the screen. If you define more
     fields than fit on the screen at once, you can scroll up and
     down to view additional lines.

     You can navigate within the field definition lines on the
     Define screen using either the keyboard or the mouse. Whenever
     you advance below the current definition line, a new line is
     created up to a maximum of 128 lines.

     Navigating with the Mouse in the Define Screen

     To move to a field element:

       Point to the desired field element and click the left mouse
       button. The cursor becomes active in the selected field
       element.

     To scroll one field line:

       Click on the up or down arrow on the scroll bar.

     To scroll one screen full of lines:

       Click above or below the scroll box.




     PC-File Version 7 Users Guide                             43



     Navigating with the Keyboard in the Define Screen

     To move to a field element:

       Press TAB and SHIFT-TAB or the ARROW keys to move between
       field elements.

     You can also advance to the next element by pressing ENTER.
     The UP and DOWN ARROWS are particularly useful when moving up
     and down in the list.

     To scroll one line:

       Press UP ARROW or DOWN ARROW.

     To scroll one screen full of lines:

       Press PAGE UP or PAGE DOWN.

     Entering a Field Name

     A field name can be no longer than 10 characters, and must
     start with a letter, and can only contain letters, digits, or
     the underscore character (_).


     To enter a field name:

     1.Move the cursor to the Field name column in the line you
       want to define.

     2.Type the field name.

     Choosing a Field Type

     To specify a field type:

     1.Click on Type button.

     2.Choose the field type.

     Or...

     1.Move the cursor to the Type column in the line you want to
       define.

     2.Type the letter for the field type you want to define:
       C=Character, N=Numeric, D=Date, L=Logical, and M=Memo.

     Defining a Field Length

     You can define the lengths for Character and Numeric fields
     within the limits described above under "Field Types." Other
     field types are pre- defined.




     PC-File Version 7 Users Guide                             44



     To define a field's length:

     1.Move the cursor to the Length column in the line you want to
       define.

     2.Type the number for the desired field length.

     Defining Decimal Places

     You can define the number of decimal places for numeric
     fields. The maximum number of decimal places you can define is
     two less than the total length of the field.

     To define the number of decimal places (for numeric fields
     only):

     1.Move the cursor to the Decimals column in the line you want
       to define.

     2.Type the number of decimal places.

     Inserting, Deleting, and Adding Field Lines

     After you have started specifying field details, you may need
     to edit your field list. The three tools buttons in the lower
     left corner of the Define screen allow you to edit your field
     definition list to insert or delete lines, and to add new
     lines at the end of the list.

     The Insert button allows you to insert a field definition line
     above the line the cursor is on. This allows you to add a
     field somewhere other than the end of the list, in the event
     that you forgot to define it when initially entering field
     definitions.

     The Delete button allows you delete the field definition line
     the cursor is currently on, if you decide that you don't need
     it or if you need to move its definition to a different
     location.

     The Add button allows you to add a blank field definition line
     to the end of the list. You can also add new definition lines
     by navigating with TAB or ENTER below the last definition
     line.


     To insert a new field definition line:

     1.Move the cursor to the line that you want to insert a field
       above.

     2.Choose the Insert button on the tool bar. A new field entry
       line is inserted above the cursor.

     To delete a field definition line:




     PC-File Version 7 Users Guide                             45



     1.Move the cursor to the field definition line you want to
       delete.

     2.Choose the Delete button on the tool bar.

     3.Choose Yes to delete the line. The current field definition
       line is deleted.


     To add a field definition line at the bottom:

     1.Choose the Add button on the tool bar. A new field
       definition line is added at the bottom of the define screen.

     Or...

     1.Navigate below the last line of the current definition. A
       new definition line is created for each line you advance.

     Moving Field Definition Lines

     To move a current field line to re-order fields, you must add
     or insert a new blank definition line at the location you want
     to move the field to, re-enter the definition at the new
     location, then delete the field from its old location.

     There is no way to cut, copy, or paste an entire field
     definition line in one operation to make this process simpler.
     However, you can cut, copy, or paste one element of a field
     definition at a time by highlighting it and then using the
     edit keys: SHIFT-DEL (to cut), CTRL- INS (to copy), or SHIFT-
     INS (to paste).

     NOTE: You can not copy or paste the field type letter. You
     must re- enter the field type using the Type button. Also, you
     cannot copy the Length for Date, Logical, and Memo fields,
     because their lengths are automatically supplied when you use
     the Type button.

     To move a field definition:

     1.Add or insert a blank line at the location you want to move
       the field to.

     2.Re-enter or copy and paste the "old" field definition to the
       new location.

     3.Delete the old field definition line.


     Naming the Database




     PC-File Version 7 Users Guide                             46


     Once you finish defining the database structure, choose OK to
     continue with the definition process. PC-File will prompt you
     to name your database. Give your database a name that
     describes its content and is easily identifiable to you and
     any other users. If you maintain several databases, it is
     helpful to use names that clearly indicate which is which.

     PC-File uses the database name to name several files that
     contain the data and structure of the database; therefore, you
     must follow DOS filename rules when naming the database. Use
     no more than eight characters in the name, using letters,
     numbers, and valid punctuation marks. You cannot use spaces.
     See your DOS manual for specifics. Each database within a
     directory must have a unique name.


     To name a database:

     1.Use the directory list box in the file selection dialog box
       to move to the drive and directory in which you want to
       locate the database. See the instructions in Chapter 1,
       "Navigating in PC-File," if you have questions about using
       the file selection dialog box.

     2.Enter the database name in the text box. You do not have to
       include a file extension.

     3.Choose OK when you finish.

     You can overwrite an existing database by giving a new
     database the same name. Be aware, though, that all data in the
     original database will be lost.


     Describing the Database

     After you finish naming your new database, PC-File will prompt
     you to enter a database description.

     The database description provides additional information about
     a database. It is displayed in the field selection dialog box
     when you highlight the database name, and in the title bar
     once the database is open. The description can be particularly
     useful when you have a number of databases that are similar
     and need more than the eight-character limit allowed in a
     database name to describe them clearly. However, the
     description is optional.


     To describe a database:

     1.Enter the description in the box when prompted by the
       program. The description can be up to 50 characters in
       length.

     2.Choose OK when you finish.




     PC-File Version 7 Users Guide                             47



     3.Choose OK to bypass the description if you choose not to
       enter one.


     Overview of Creating a Database Structure

     The following procedure provides an overview to bring together
     all of the elements of the database structure creation
     process.

     To create a Database Structure:

     1.Choose New from the File menu. The "Pattern After" dialog
       box displays.

     2.Choose whether to pattern after an existing database. See
       "Defining by Patterning After" for details on how to choose
       a database to pattern after. The Define Screen displays.

     3.Enter or edit the Field Names, Types, Lengths and Decimals
       for each field you want to define. Any field definition
       lines left blank will be ignored. Use the tool bar buttons
       to insert, delete or to add new field definition lines, if
       necessary.

     4.Choose OK when you have finished entering all of your field
       definitions. The file selection dialog box displays.

     5.Use the directory list box in the file to move to the drive
       and directory you want to save the database in.

     6.Type the database name in the text box. You do not have to
       include a file extension.

     7.Choose OK to continue. The database description dialog box
       displays.

     8.Type a description up to 50 characters long in the text box.

     9.Choose OK. An information box displays indicating additional
       database features you may want to define. See Chapter 4 for
       information on adding Field Attributes, and see Chapter 5
       for information on how to define custom Views.

     10.  Choose OK to clear the information box. The work area
       displays an empty record ready for you to start adding data.




     PC-File Version 7 Users Guide                             48




     CHAPTER 3 MODIFYING A DATABASE STRUCTURE


     This chapter explains how to redefine a database structure.
     Redefine a database to make any changes to the structure:
     adding, removing, or re- ordering fields; changing field
     types; and changing field lengths (and decimal places for
     numeric fields). You can also redefine a database to create a
     copy or a subset of the original database. Or you can redefine
     as a way of defining a new database starting from a current
     database's definition.

     What Does Redefine Mean?

     Once you have defined and used a database, you may find a need
     to change it. For example, you might decide to add a phone
     field to a database of names and addresses. Or you could
     discover that some addresses are longer than the space you
     allotted for them, and decide to lengthen the field.

     You can add fields and delete fields. You can add fields at
     the end of your existing fields, or you can insert them in the
     middle of your list of fields to keep your fields in a
     particular order.

     PC-File allows you to change each of the four elements of your
     database structure. These elements are the same as those used
     in creating a new database: field name, field type, length,
     and decimals. You can change the names of your fields with
     redefine. If it is appropriate, you can change the type of
     field you are using. You can increase or decrease the length
     of a field to accommodate your information. And you can add or
     shorten the amount of information to store after the decimal
     place for
     numeric fields.

     After you modify your structure, PC-File transfers all of your
     data into the new structure. Most commonly this is simply a
     matter of copying any data from "old" fields into the "new"
     fields-PC-File automatically matches the field names and
     transfers the data. However, it is also possible to split or
     join "old" fields during the transfer process using special
     procedures.

     You can change the database structure whether or not the
     database contains data. If there is data, you can also use
     Redefine to copy all or selected groups of records to new
     databases to produce new copies or subsets of the current
     database. You can also choose to copy none of the original
     database's records to produce an empty database.




     PC-File Version 7 Users Guide                             49


     NOTE: The Redefine option on the File menu ONLY changes the
     database structure, that is the specifics of the field
     definitions. To rearrange fields on the entry screen, you must
     use the Create option on the Views menu to create a custom
     view. Or, if you already have custom views, use the Modify
     option on the Views menu.


     Overview of Changes to Database Structure

     PC-File allows you to perform the following operations with
     Redefine:

       Add new fields by inserting or adding to end of list
       Delete any field from list
       Change field order (by deleting and re-inserting)
       Change field names
       Change field types
       Change field lengths (within the limitations of the field
       type)
       Change number decimal places in numeric fields
       Split or join field contents
       Create a new copy or subset of a database

     Each of these operations will be covered in more detail in the
     sections that follow.

     Internally, all these changes to the database require the
     creation of a new database data file (.DBF). However, for all
     operations except producing a subset or copy, you can retain
     the original database name when performing all redefine
     operations. You don't have to build a new database under a new
     name, delete the original, and rename the database as you did
     in previous versions of PC-File.


     Starting the Redefine Process

     You must open a database before you can redefine it; the
     Redefine option is grayed out otherwise. In addition, you can
     only redefine the open database. You can't make changes to one
     database from within another database.

     To start redefining a database:

     1.Open the database you want to redefine.

     2.Choose File from the menu bar.

     3.Choose Redefine from the File menu.




     PC-File Version 7 Users Guide                             50


     The Redefine screen functions exactly like the Define screen
     used to originally define the database structure except that
     it starts with the current database structure already
     displayed. You can easily move around the Redefine screen
     using either the mouse or the keyboard. See Chapter 2,
     "Navigating in the Define Screen"-the same procedures
     documented there work for navigating in the Redefine screen.

     The following sections describe the various operations you can
     perform on the Redefine screen, and how to complete the
     redefinition process.


     Changing Current Field Definitions

     You can change the four elements of the database structure on
     the Redefine screen:

       Field Name
       Type
       Length (for character and numeric fields)
       Decimals (for numeric fields)

     These are the same elements you define when you create a
     database structure from scratch. See Chapter 2, "Creating a
     New Database Structure" for more details on these elements. In
     particular, see the sections: "Entering a Field Name,"
     "Choosing a Field Type," "Defining a Field Length," and
     "Defining Decimal Places" for step-by-step procedures. Also
     see the sections "Maximum Record Size" and "Fields and Field
     Elements" for information about limitations on record size and
     field lengths, and for
     details on field types.

     Making changes to the structure is easy, just move the cursor
     to the element that you would like to change and edit or
     redefine it. For example, to change a field name from "FIRST"
     to "FIRSTNAME," simply move the cursor to the field name FIRST
     and type FIRSTNAME.

     To change a field element:

     1.Move the cursor to the element you want to change, e.g.
       field name, using the mouse or the keyboard.

     2.Edit or redefine the field element.

     NOTE: You can use the standard navigation and editing keys for
     all text boxes on the Redefine screen. See Chapter 1, "Editing
     Keys" for the specifics.

     3.Repeat steps 1 and 2 for all elements you want to change.




     PC-File Version 7 Users Guide                             51


     4.When you have completed all your changes, choose OK. Skip
       this step if you also need to insert, delete, add, or move
       fields. These procedures are described in the following
       sections.

     Inserting, Deleting, Adding, and Moving Fields

     The three tools buttons (Add, Insert, and Delete) on the left
     end of the button bar allow you to edit your field definition
     list.

     The Insert button allows you to insert a new field definition
     line above the line the cursor is on. This allows you to add a
     field somewhere other than the end of the list.

     The Delete button allows you delete the field definition line
     the cursor is currently on, to eliminate that field (or if you
     need to move its definition to a different location).

     The Add button allows you to add a blank field definition line
     to the end of the list. You can also add new definition lines
     by navigating below the last line with TAB, ENTER, or DOWN
     ARROW.

     To insert a field:

     1.Move the cursor to the line that you want to insert a field
       above.

     2.Choose the Insert button. A blank line is inserted above the
       line that was current in step 1 and the rest of the fields
       move down. The cursor is on the new blank line.

     3.Enter the definition for your new field.

     To delete a field:

     1.Move the cursor to the field definition line you want to
       delete.

     2.Choose the Delete button.

     3.Choose Yes. The line that was current in step 1 is removed
       and any following lines move up.


     To add a new field definition line at the bottom:

     1.Choose the Add button. A blank field definition is added at
       the bottom of the field list. The cursor is on the new blank
       line.

     2.Enter the definition for your new field.

     Or...




     PC-File Version 7 Users Guide                             52


     1.Navigate below the last line of the current definition using
       TAB, ENTER, or DOWN ARROW. A new definition line is created
       for each line you advance.

     2.Enter the definition for your new field.

     Moving Fields

     There are two "main" reasons you may need to change the field
     order:

       To improve the organization of your database

       All fields referenced in a field calculation must come
       before the field that contains the calculation for the
       calculation to work properly

     To move a current field line to re-order fields, you must add
     or insert a new blank definition line at the location you want
     to move the field to, re-enter the definition at the new
     location, then delete the field from its old location.

     There is no way to cut, copy, or paste an entire field
     definition line in one operation to make this process simpler.
     However, you can cut, copy, or paste one element of a field
     definition at a time by highlighting it and then using the
     edit keys: SHIFT-DEL (to cut), CTRL- INS (to copy), or SHIFT-
     INS (to paste).

     NOTE: You cannot copy or paste the field type letter. You must
     re-enter the field type using the Type button. Also, you
     cannot copy the Length for Date, Logical, and Memo fields,
     because their lengths are automatically supplied when you use
     the Type button.

     To move a field definition:

     1.Add or insert a blank line at the location you want to move
       the field to.

     2.Re-enter or copy and paste the "old" field definition to the
       new location.

     3.Delete the old field definition line.


     Mapping Field Data

     Once you finish making changes to the structure of your
     database as described above, PC-File gets ready to transfer
     the data from the original data file to a new data file. In
     doing so, PC-File must determine where the data for each field
     comes from. This process is called mapping.

     When you choose OK from the Redefine screen the Mapping screen
     displays.




     PC-File Version 7 Users Guide                             53



     The New Fields column shows the field names for the database
     that you have just created with the Redefine process. The
     Comes From column shows which fields from the original
     database are mapped to the fields in the New Fields column.

     PC-File automatically maps all field names that match. If you
     haven't changed any of your current field names, you will see
     same name in both the New Fields and the Comes From columns
     for each field. Any new fields you added in the Redefine
     process will be blank in the Comes From column. Generally, you
     don't need to map new fields because you will be entering data
     for them later. In most cases, since PC-File has done the
     mapping for you, you can simply choose OK to continue the
     redefine process.

     However, if you have changed a field name, PC-File will no
     longer recognize the field name and the Comes From column will
     be blank for that field-you must choose the data source for
     that field. For example, if you have changed a field name from
     FIRST to FIRSTNAME, you must tell PC-File that you want the
     information from the old FIRST field to be put into the new
     FIRSTNAME field.

     NOTE: If you rename many of your current fields and add
     several new fields or re-order fields, you should double-check
     to make sure that all fields are mapped properly. In this
     case, it may be less confusing to rename your current fields
     first using the Field Attributes option on the File menu. Then
     add the new fields or re-order using the Redefine option.

     There are two other reasons you may need to map your fields:

       To split portions of a current field into other fields

       To join two current fields into one

     You must type in special codes into the Comes From column to
     split or join fields.

     There are two ways to map your fields. You can select them by
     using the List button or by typing field names into the Comes
     From column directly.

     Selecting Fields Using the List Button

     If you changed the name of a field, you will need to map the
     old field to the new field. The List button provides a simple
     way to do this. Choosing the List button displays a list of
     the old field names on the right side of the Mapping screen.




     PC-File Version 7 Users Guide                             54


     The Old Field List Box shows all fields from your current
     database, including any fields that you deleted. All fields
     that have already been mapped by PC-File have a checkmark next
     to them. To map a field, put the cursor in the Comes From
     column next to the New Field you want to map. Then choose a
     field from the Old Field List. This inserts that field's name
     into the Comes From column.

     To map your fields with the List button:

     1.Highlight the box in the Comes From column next to the New
       Field name you want to map. The box should be empty.

     2.Choose the List button. The Old Fields List displays on the
       right-hand portion of the screen. The cursor is active in
       the list.

     3.Click on the field you want to map with the mouse, or
       navigate to the name of the field with the TAB key and press
       ENTER. The field name is inserted into the Comes From
       column.

     4.Repeat steps 1 through 3 for each field you want to map.
       When you have finished mapping your fields, choose OK to
       continue the redefine process.

     Selecting Fields by Typing Names

     Alternatively you can map fields by simply typing the name of
     the old field in the appropriate Comes From text box. This may
     be a faster method if you are only using the keyboard.
     However, you must type in the name exactly as it is saved in
     the database. You can press ALT-L to display the Old Field
     List for reference.

     To map your fields by typing the field names:

     1.Move the cursor to the box next to your new field name. The
       box should be empty.

     2.Type in the name of the field which will be mapped to your
       new field.

     3.Repeat steps 1 through 3 for each field you want to map.
       When you have finished mapping your fields, choose OK to
       continue the redefine process.

     Specifying a Portion of a Field




     PC-File Version 7 Users Guide                             55


     You can use the type in method to do more than simple mapping.
     You can use it to transfer a portion of a field using
     substring notation. Substring notation specifies the starting
     position, and length of the partial field. To use substring
     notation, type the name of the field followed by a comma, then
     type the number for the starting position, and another comma
     followed by the number of characters to transfer. For example,
     typing ZIPCODE,1,5 in the Comes From box transfers the first
     five characters of the field ZIPCODE. Likewise, typing
     ZIPCODE,7,4 transfers the last four characters starting from
     the seventh character in the field.

     Joining Two Fields

     You can also use the type in method to join two fields. To do
     so, type the field name, a semi-colon and the second field
     name. For example, type FIRSTNAME;LASTNAME to join the fields
     FIRSTNAME and LASTNAME.

     Saving Your Changes

     After you have mapped all your fields you are presented with
     the option to either update the current database or save the
     redefined database as a new file.

     Unless you want to make a new copy or subset of the current
     database, choose Update Current. If you choose Save As, the
     original database is not modified, and your changes will be
     saved to a new database file.

     Updating the Current Database

     If you choose Update Current at the Save Changes dialog, PC-
     File performs the update and takes you back to the menu bar.
     You are finished with the redefining operation.

     When updating the current database, PC-File needs to write a
     new copy of the data file. PC-File renames the original
     database file as a backup using this format:

          TMPnn.DBF

     where "nn" is a unique number. PC-File does this as a security
     measure: If you made a mistake or if something were to go
     wrong during the Redefine process, you can reclaim your
     original database by opening the TMPnn.DBF file.

     After PC-File creates the TMPnn backup file, it then creates
     the updated database using the original name including all
     your current records.




     PC-File Version 7 Users Guide                             56


     PC-File displays an information screen at the end of the
     updating process telling you what TMPnn name was used for the
     backup of the database files. You may want to write down the
     TMPnn file name at this point, in case you need it in the
     future. Once you are certain the Redefine operation was
     successful, you can delete the TMPnn file using the File
     Maintenance option on the Utilities menu.

     NOTE: If you want to copy only a selected group of records,
     you must use the Save As option. Use a new database name or
     use the same name making sure to write the redefined database
     to a different drive or directory than the original database.

     To update the current database:

     1.At the Save Changes dialog box, choose Update Current. A
       status window with a bar graph showing the rate of progress
       displays in the lower right corner. When all records have
       been transferred, an information box displays showing the
       TMPnn name for the backup of the original database.

     2.Choose OK to clear the information box. The redefine
       operation is complete and you are returned to the redefined
       database.

     Saving Changes as a New Database

     If you choose Save As at the Save Changes dialog box, PC-File
     first prompts you to to name and describe the new database
     file, then you choose which records you want to transfer. This
     will save the redefined database as a new file, leaving the
     original database the way it was when you started the
     redefinition process.

     PC-File may take some time to generate the new file after you
     choose which records to transfer. This will depend on the size
     of the database, how you select which records to copy, and the
     speed of your system. A status window with a bar graph shows
     the rate of progress.

     Naming the New Database

     Naming the new database is the first step in the Save As
     process. After you choose Save As, PC-File displays the file
     selection dialog box.

     When the file selection dialog box displays, you can either:

       Give the database a new name and save in the current
       directory

       Change the drive or directory using the Directories list
       box, and then save the new database with the original name
       or a new name




     PC-File Version 7 Users Guide                             57


     Enter the name of the new database in the text box of the file
     selection dialog box.

     Describing the New Database

     Once you have chosen the name and location for the new
     database, PC- File prompts you to enter a description. If the
     database being redefined had a description, it appears as the
     default. You can use the same description or enter a new one.
     The description is optional. Descriptions can be up to 50
     characters in length.

     Transferring Records

     After naming and describing the new file, PC-File asks you
     whether you want to transfer all, some, or none of the current
     records to the new file.

     Choose All to either transfer all the records or select which
     records to transfer one at a time.

     Choose Some to conduct a search to determine what records to
     transfer. (See Chapter 7, "Finding and Modifying Data," if you
     have questions about how to conduct a search.) Conducting a
     search lets you create a subset of your old database. For
     example, you could define a database containing records for
     just one year, eliminating records from previous years. Or you
     could select sales reps from just one area, setting up a
     separate database for that region.

     Choose None to create a new empty database-no records are
     transferred from the previous database and the redefinition
     process is finished.

     Approving Records

     After choosing All or Some, PC-File displays the first record
     to transfer overlaid with the Record approval dialog box.

     Choosing All clears the Record approval dialog box and
     transfers all or some records depending on the choice you made
     at the Transfer Which Records dialog box.

     Choosing Yes, transfers that one record and displays the next
     one with the Record approval dialog box. Choosing No skips the
     current record and displays the next one with the Record
     approval dialog box. You can continue in this fashion to
     approve records to transfer one at a time until no records
     remain to display. At any point in the record approval process
     you can choose All to stop approving records and transfer all
     remaining records. Choose Quit to stop approving records and
     complete the
     redefinition.

     To save the redefined database as a new file:




     PC-File Version 7 Users Guide                             58


     1.At the Save Changes dialog box, choose Save As. The Save As
       file selection dialog box displays.

     2.If you want to save the database in a new location, change
       the drive and directory with the Directories list box,
       otherwise skip this step.

     3.Type the new name in the text box.

     4.Choose OK.  The Database Description dialog box displays.

     5.Enter a file description up to 50 characters long.

     6.   Choose OK.
     The Transfer Which Records dialog box displays.

     7.Choose whether to transfer All, Some, or None of the current
       records. If you choose None, the new database is copied to
       the new name and the redefinition process is completed.

     8.If you chose Some, the Type of Search dialog displays.
       Choose the type of search and enter your search criteria.
       See Chapter 7, "Conducting a Search" for details on how to
       enter a search. Otherwise, skip this step.  The first record
       is displayed with the Record Approval dialog box.

     9.Choose All to transfer all records without interruption. To
       approve records one at a time: Choose Yes to accept a
       record; Choose No to skip a record; Choose Quit to stop the
       approval process.

     If you chose All in step 9, a status bar graph displays
     showing the rate of progress.

     When all records are transferred the redefinition is complete.
     If you use the Record Approval dialog to approve records one
     at a time, the redefinition process is completed when you run
     out of records to choose from, or if you choose Quit.

     Rebuilding Indexes

     If you defined any indexes for your database before beginning
     the redefine process, PC-File will ask if you want to rebuild
     the indexes after it has finished saving the data you selected
     to the new database structure. See Chapter 8, "Indexing Data"
     for more details.

     Choose No if you do not want the new database to have the same
     indexes as the original database.

     If you have a large database with several indexes, it could
     take a long time to rebuild them all, or you may not have the
     time right now to rebuild them. If you choose No, you can make
     indexes for you database at any time later.




     PC-File Version 7 Users Guide                             59


     Choose Yes if you want PC-File to rebuild all the indexes the
     original databases had.

     Rebuilding all the indexes may take a long time if you have a
     very large database and several indexes. PC-File will attempt
     to rebuild all the indexes for your database, but it may not
     be able to. If you made any changes to fields included in any
     of the index definitions, PC- File will tell you which indexes
     it was unable to rebuild.




     PC-File Version 7 Users Guide                             60


     Overview of Procedures for Redefining

     The following procedure presents an overview of the entire
     redefinition process from start to finish.


     To redefine a database:

     Open the database you want to redefine.

     1.Choose Redefine from the File menu. The Redefine screen
       displays.

     2.Make the desired changes to the field list. See the sections
       "Changing Current Field Definitions" and "Inserting,
       Deleting, Adding, and Moving Fields" for details.

     3.Choose OK when you have made all the changes you want to
       make to the field list. The Mapping screen displays.

     4.Map fields if necessary (see "Mapping Field Data" for
       details), otherwise choose OK to continue.

     5.Choose whether to Update or Save As. If you choose Update,
       the Status window displays to show the rate of progress. If
       you choose Save As, you must name and describe the new
       database, and then specify which records to transfer. See
       "Saving Changes as a New Database" for details.

     6.Choose Yes to rebuild indexes, or No to omit the current
       indexes.

     The Redefine process is finished.


     How Redefining Affects Other Database Characteristics

     Redefining only changes the characteristics of your data file
     (databasename.DBF), but there are many other areas of your
     database which may be affected by the changes you made. PC-
     File lets you define many additional attributes and
     characteristics about your database and fields including

       Field Attributes

       Custom Views

       Indexes

       Reports, Letters & Graphs

       Macro definitions

       Batch Posting definitions




     PC-File Version 7 Users Guide                             61


     These features are optional, so you might have defined only a
     few or none at all. You may not need to update any of these
     features, or you may need to update all of them-it all depends
     on the extent of the changes you made to the database
     structure. Each section below describes briefly how to know if
     you need to make additional changes.

     Changes to Field Attributes

     PC-File lets you define field attributes which control and
     automate what happens in each field. See Chapter 4, "Field
     Attributes" for more details.

     What to check:

       If you changed any field names, those field's attributes are
       retained as long as they have been properly mapped to the
       new database's field names.

       If you added new fields to your database structure, you may
       want to define new field attributes for them.

       If you deleted any fields or changed any existing field
       names when you redefined, you may also need to update
       calculation and relational lookup attributes. Additionally,
       if you have any other databases which do relational lookups
       on the database you redefined, you may need to update those
       databases' relational lookup attributes if they referenced
       any deleted field or fields whose names you changed.

     Changes to Custom Views

     PC-File lets you define additional "views" to display your
     data in different ways. See Chapter 5, "Views" for more
     details.

     Redefining retains any custom views you defined for the
     original database. However, because you can delete and rename
     fields when redefining, pre-existing custom views that
     contained those fields will be affected.

     What to check:


       Deleted fields are removed from all custom views

       Renamed fields will remain in the view as long as they have
       been properly mapped to the new database's field names.

       New fields will not appear in any of your custom views. If
       you want your new field(s) to appear in any your custom
       views you must modify the views to add the new field(s).

     The two Default views always reflect the current database
     structure, so they will automatically reflect any changes you
     make during when redefining.




     PC-File Version 7 Users Guide                             62



     Changes to Indexes

     PC-File lets you define indexes which allow you to customize
     the order your records are displayed in. See Chapter 8,
     "Indexing Data" for more details.

     If you defined any indexes for your database prior to
     redefining the structure, PC-File asks you if you want to
     rebuild the database's indexes. If you answer Yes, PC-File
     will attempt to rebuild all the indexes you had defined.

     Index definitions are dependent on field names, field types
     and field lengths. Deleting fields or changing field names,
     lengths, or types can cause indexes to become invalid.

     What to check:

       If an index contains a reference to field that has been
       deleted or modified in any way, PC-File will tell you it was
       unable to build the index. You may want to remake any
       indexes PC-File was unable to rebuild.

     Changes to Reports, Letters & Graphs

     Printing Reports, Letters and Graphs are some of PC-File's
     useful features. See Chapter 9, "Creating Reports," Chapter
     10, "Writing Letters," and Chapter 12 "Creating Graphs," for
     more details.

     Because any number of databases might be able to use the same
     reports, letters and graphs, PC-File will not attempt to make
     any changes to them when you redefine a database structure.

     What to check:

       If you deleted fields, or changed fields names, lengths or
       types, you must update any reports, letters and graphs used
       with that database to reflect those changes.

     Changes to Macro Definitions

     Macros allow you to simplify complicated or repetitive tasks
     by recording the keystrokes so you can play them back at any
     time. See Chapter 16, "Using Macros" for more details.

     Because you can record nearly any task in PC-File into a
     macro, it is almost impossible to list everything you should
     look at after having made changes to the database structure.
     Below is a list of the most common changes that will disrupt
     macros.

     What to check:




     PC-File Version 7 Users Guide                             63


       If any of your macro reference a field name and you changed
       that field's name, you will need to modify the macro to
       reflect the new name.

       If any of your macros are designed specifically to navigate
       to certain fields in a view and that view has changed
       because you deleted fields, you may need to modify the
       macro.

       If any of your macros reference a database name and you
       saved the redefined database structure to a new name, you
       will need to modify the macro to reflect the new name.

     Changes to Batch Posting Definitions

     PC-File's Batch Posting feature allows you to update
     information in other databases with information in the current
     database. See Chapter 18, "Batch Posting" for more details.

     What to check:

       If you have any databases that perform batch posting on the
       database you redefined, those databases' post definitions
       must be updated if they referenced fields you deleted or
       fields whose names you changed.




     PC-File Version 7 Users Guide                             64




     Chapter 4 FIELD ATTRIBUTES

     PC-File's field attributes let you control and automate what
     happens in each field. Field attributes can: supply automatic
     data, such as calculations; perform certain kinds of
     validation, such as defining the range of allowed values;
     control date, and character formatting; and can restrict when
     a field can be edited. Field attributes can be combined and
     applied selectively for each field. This chapter tells you how
     to define, modify, and delete field attributes.

     What are Field Attributes?

     PC-File's field attributes control what happens in a field in
     addition to the restrictions placed by a field's type. Field
     attributes fall under four basic categories based on how they
     affect the field: Automatic Data, Validation, Formatting, and
     Data Restriction.

     Automatic Data field attributes automatically supply data to a
     field from several different sources:

       Automatic Date-from the system date

       Automatic Time-from the system time

       Serial Number-supplies an automatically incrementing serial
       number

       Calculation-from a calculation based on other field's values

       Relational Lookup-retrieves data from other databases

       Default Text-from default text you define

       Automatic Dupe-by duplicating field data from the previous
       record

       Validation field attributes confirm that data has been
       correctly entered:

       Must Answer-confirms that something was entered

       Validate Range-confirms that the data entered falls within a
       defined range

     Formatting field attributes control formatting:

       Date Format-defines the display format for date-type fields

       Case Force-converts entered characters to either: upper-,
       lower-, or mixed case

     Data Restriction field attributes control what can be entered:




     PC-File Version 7 Users Guide                             65



       Not Editable-controls whether a field can be edited

       Character Restriction-controls which characters can be
       entered

     Each of these field attributes and how to assign them are
     discussed below.

     When Are Field Attributes Applied?

     You can control when PC-File applies Automatic Data
     attributes. For example, you can have an Automatic Date
     attribute supply the system date only when a record is first
     added. See the discussion under "When are Automatic Data
     Attributes Applied?" for more details.

     All other field attributes, except Not Editable, are applied
     at all times.

     How Many Field Attributes Per Field?

     To provide the greatest flexibility, PC-File lets you assign
     any number of field attributes per field. For example, for the
     same field you may assign Character Restriction to allow only
     certain characters to be entered, and assign Validate Range to
     define a range of allowed values, and assign Must Answer to
     make sure that something is always entered in the field.

     However, this means that it is possible to assign conflicting
     attributes to the same field. For example, PC-File will not
     prevent you from assigning both Automatic Date and Automatic
     Time attributes to the same field-the attribute assigned last
     would overwrite the other. Another example: PC-File will not
     prevent you from assigning Validate Range to limit the allowed
     range of values and then adding a Calculation that produces a
     result outside of the specified range. If you are assigning
     more
     than one attribute to a field, be careful not to assign
     attributes that will conflict with each other.

     Except for Calculation, Relational Lookup, and Default Data
     attributes, PC-File does prevent you from assigning more than
     one of the same attribute to a field.

     The Field Attribute Definition Process

     To start the Field Attribute definition process with the
     database you want to work with must be open. Then, choosing
     the Field Attribute option on the File menu displays a Field
     Selection dialog box.

     The Field Selection dialog box lets you choose which field you
     want to work with from the list. Once you choose a field, the
     Atrribute dialog box displays.




     PC-File Version 7 Users Guide                             66


     The Name text box at the top of the box lets you edit and
     change the field's name. The Available Attributes list on the
     left side shows all the field attributes you can work with.
     The Current Attributes list shows all attributes that are
     defined for the field. You can perform as many field attribute
     operations on the field as you want: add, delete, or modify
     one or more field attributes. Choosing OK returns you to the
     Field Attribute field selection dialog box to let you work
     with another
     field.


     To start working with field attributes:

     1.Open the database you want to work with.

     2.Choose Field Attribute from the File menu. The Field Section
       dialog box displays.

     3.Choose the field you want to work with. The Field Attribute
       Definition dialog box displays.

     4.Continue the Field Attribute definition process as described
       below.

     Adding a Field Attribute

     Once you have the Field Attribute Definition dialog box for
     the desired field displayed, you can add Field Attributes. The
     following procedure outlines the basic steps for adding an
     attribute. See the section for each attribute type later in
     this chapter for full details.


     To add a field attribute:

     1.Select the attribute you want to assign from the Available
       Attributes list.

     2.Choose the Add button. The dialog for the selected attribute
       displays. See the appropriate section later in this chapter
       for full details on each attribute.

     3.Choose OK when you are finished defining the attribute. You
       are returned to the Field Attribute Definition dialog box.

     Deleting a Field Attribute

     You can easily delete field attributes once you have the Field
     Attribute Definition dialog box displayed.

     To delete a field attribute:

     1.Select the attribute you want to delete from the Current
       Attributes list box.




     PC-File Version 7 Users Guide                             67


     2.Choose the Delete button. A confirmation dialog box
       displays.

     3.Choose Yes to delete the selected attribute.

     Modifying a Field Attribute

     Once you have assigned a field attribute, you may find you
     need to modify its definition. The following procedure
     outlines the basic steps for modifying an attribute. See the
     appropriate section later in this chapter for the full details
     on each attribute type.

     To modify a field attribute:

     1.Select the attribute you want to modify from the Current
       Attributes list box.

     2.Choose the Modify button. The appropriate dialog box for the
       selected field attribute displays. See the appropriate
       section later in this chapter for full details on the
       attribute you are working with.

     3.Choose OK when you are finished modifying the attribute.

     Completing the Field Attribute Definition Process

     You can perform any number of field attribute operations using
     the Field Attribute Definition dialog box. Once you are
     finished working with the field, choosing OK on the Field
     Attribute Definition dialog box returns you to the Field
     Section dialog box. You can choose to work with another field
     or choose OK on the Field Selection dialog box to return to
     the work area.

     Details on how to define each field attribute are covered in
     the following sections.

     Defining Automatic Data Attributes

     PC-File allows you to set up seven different types of
     automatic data attributes:

       Automatic Date
       Automatic Time
       Automatic Duplication
       Calculations
       Default Text
       Relational Lookups
       Serial Numbers

     Each of these options is described in detail later in this
     section.

     When are Automatic Data Attributes Applied?




     PC-File Version 7 Users Guide                             68


     Automatic Data attributes generate their data at a time that
     you specify. PC-File controls when an Automatic Data attribute
     generates its output three ways.

     You can determine if the attribute is applied:

       When adding records, when modifying records, or both

       When you begin editing the record, or when you exit the
       record

       Only when the field is empty, not empty, or at all times

     When you add or modify an Automatic Data attribute, a dialog
     box is displayed.

     There may be differences in the dialog box depending on what
     kind of Automatic Data attribute you are defining, but all
     dialog boxes have these three sets of options. In most cases,
     you can choose the default choices that PC-File provides.
     However, you may want to modify the options for different
     purposes. How each group of options affects Automatic Data
     attributes is described below.

     During Which Operations

     The When Adding Records and When Modifying Records check boxes
     determine whether the attribute is applied only when you add
     records, only when you modify records, or both.

     For example, you might want to assign an Automatic Date
     attribute to the ENTER_DATE field in an invoicing database.
     Turn on the When Adding Records check box to specify that the
     Automatic Date is only supplied when adding a record. Also,
     make sure that the When Modifying Records check box is turned
     off. Then each time you add a new record (invoice), PC-File
     automatically puts today's date in ENTER_DATE for you.

     Similarly, you might put an Automatic Date attribute in a
     MODIFYDATE field to track when a record was last modified.
     Turn on the When Modifying Records check box and make sure the
     When Adding Records check box is turned off to apply the
     attribute only when the record is modified.

     You can turn on both check boxes to apply an attribute when
     both adding and modifying records. Also, if you want to
     temporarily disable an attribute without having to delete and
     re-enter it, you can turn off both When Adding and When
     Modifying check boxes.

     At What Time During the Operation

     The When You Begin Editing and When You Exit The Record option
     buttons control at what time the attribute is applied while
     you are editing a record.




     PC-File Version 7 Users Guide                             69


     The When You Begin Editing option behaves slightly differently
     depending on whether the attribute is being applied when
     adding or modifying a record. When adding, this option causes
     the automatic data to be supplied as soon as you start adding
     a record-the output of this attribute will be visible as soon
     as you choose to add a record. When modifying, this option
     causes the automatic data to be supplied as soon as you access
     any field in a record and start typing.

     Typically, the When You Begin Editing option is used for
     information you want to show at the start of an editing
     session. Automatic Date, Automatic Time, Automatic
     Duplication, Default Text, and Serial Number would typically
     be set with the When You Begin Editing option.

     The When You Exit The Record option causes the automatic data
     to be supplied as soon as you are finished working with a
     record. This is typically used for the two Automatic Data
     attributes that depend on information from other fields:
     Calculations and Relational Lookups.

     Apply When Empty or Not Empty

     The Empty and Always option buttons control whether you can
     override an Automatic Data attribute when entering data.

     For example, if you choose the Always option button and both
     When Adding and When Modifying from the During Which
     Operations options, you cannot ever enter your own data into
     the field-the automatic data will replace anything you enter.
     However, when the attribute is set to perform only if the
     field is empty, if you type something to replace the automatic
     data, PC-File will not replace your entry.

     The Not Empty option button causes the Automatic Data
     attribute to perform only when there is something in the
     field. You can use this option to trigger the Automatic Data
     attribute whenever you enter something into the field.

     Automatic Date

     PC-File allows you to add a field attribute that automatically
     puts today's date in the field. PC-File gets this date from
     your computer's system date. You can use this attribute in
     Date, Character, and Memo type fields. Use the When to Apply
     options to determine when to generate the date.

     To add an automatic date attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field selection dialog box displays.

     2.Choose the field to add the automatic date attribute to. The
       Field Attributes dialog box displays.

     3.Select Automatic Date from the Available Attributes list.




     PC-File Version 7 Users Guide                             70



     4.Choose Add to add the attribute. The Automatic Date dialog
       box displays with When to Apply options.

     5.Select when to apply the automatic date.

     NOTE: Selecting when to apply an automatic field attribute can
     be daunting. See the section, "When are Automatic Field
     Attributes Applied," for a detailed explanation. For example,
     you may want to have the date supplied automatically only when
     you add a record. Optionally, you may want to apply the date
     when you modify a record to see when you last updated it.

     6.Choose OK to apply this attribute to the field.

     Automatic Duplication

     Automatic Duplication is similar to adding Default Text to a
     field. However, while Default Text always inserts the same
     data in a field, Automatic Duplication inserts whatever data
     appeared in the same field in the previously viewed record. In
     either case, you can type over the current information. This
     attribute makes entering a series of records with the same
     data simpler. For example, you could use a duplication mask
     for a STATE field in which you entered all the WA addresses
     first, then
     moved on to the OR addresses, and from there to the CA
     addresses and so on.

     To add an automatic duplication attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field for Automatic Duplication. The Field
       Attributes dialog box displays.

     3.Select Automatic Dupe from the Available Attributes list
       box.

     4.Choose Add. The Automatic Duplication dialog box with When
       to Apply options displays.

     5.Select when to apply.

     6.Choose OK to apply this attribute to the field.

     Automatic Time

     PC-File allows you to add a field attribute that automatically
     generates the time from you computer's system time. Like the
     automatic date, you can generate the time when you add a new
     record or when you modify.

     To put in an automatic time field:




     PC-File Version 7 Users Guide                             71


     1.With a database open, choose Field Attributes from the File
       menu. The Field selection dialog box displays.

     2.Choose the field to add the Automatic time attribute to. The
       Field Attributes dialog box displays.

     3.Select Automatic Time from the Available Attributes list
       box.

     4.Choose Add. The Automatic Time dialog box with When to Apply
       options displays.

     5.Select when to apply the Automatic time attribute.

     6.Choose OK to apply this attribute to the field.

     Calculations

     Using the Calculation field attribute you can create a field
     that generates its own data through a calculation. For each
     record, PC-File performs the calculation at the time you
     specify and enters the results in the field.

     You can use any of the calculations described in Chapter 17,
     "Calculations." This includes mathematical, date, and string
     calculations as well as relational lookups. In most cases, you
     will want to define a relational lookup using the dialog boxes
     displayed when choosing the Relational Lookup field attribute
     as explained later in this chapter in the "Relational Lookup,"
     section.

     The outermost set of parentheses around a calculation is
     optional, as PC-File adds them automatically. Field
     calculations can include other field names, numeric constants,
     and functions. See Chapter 17, "Calculations," for information
     on using calculations in PC-File.

     Here are some examples of calculations:

          FIRST_NAME;" ";LAST_NAME

          ((TODAY#) - (BUY_DATE ( @DAY#,mdy)))

          TOTAL_AMT *1.0825

     To add a calculation:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field to add the calculation to. The Field
       Attributes dialog box displays.

     3.Select Calculation from the Available Attributes list.




     PC-File Version 7 Users Guide                             72


     4.Choose Add. The Calculation dialog box with a text box for
       entering the calculation and the When to Apply options
       displays.

     5.Type the calculation in the Calculation text box.

     6.Select when to apply the calculation using the options below
       the Calculation text box.

     7.Choose OK to apply this attribute to the field.

     Default Text

     If you want the same data to appear in a field in most records
     or in every record, add a Default Text attribute to that
     field. For example, suppose that most of the addresses in a
     database are from Walla Walla. To save you from having to type
     WALLA WALLA every time a new record is added, you can insert
     WALLA WALLA as default text in the city field. You can then
     skip over that field most of the time. When a different city
     is needed, type it right over the default text.

     Here are some examples of default data:

          WALLA WALLA CA 01/22/93

     To add a Default Text attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field to add the Default Text attribute to. The
       Field Attributes dialog box displays.

     3.Select Default Data from the Available Attributes list.

     4.Choose Add. The Default Text dialog box with a text box for
       entering the default data displays.

     5.Type the text to be used as Default Text in the text box.

     6.Select when to apply using the When to Apply options.

     7.Choose OK to apply this attribute to the field.

     Serial Number

     The Serial Number attribute lets you define a field that
     contains an incrementing number for each record. Typically
     this feature is used to automatically enter a number in a
     field each time you add a record. This is useful if you need a
     unique identifier for each record, or if you need to know the
     order each record was added to the database. Sorting the
     database does not change these numbers, and numbers are never
     reused, even if a record is deleted.




     PC-File Version 7 Users Guide                             73


     You can define which number will be used as the starting
     number and what number will be used to increment by. By
     default the serial number will start at 1 and increment by 1
     so the first record added will be number 1, the second record
     number 2, and so on in a series. However, you can choose any
     starting number or interval by typing the desired values in
     the text boxes on the Serial Number dialog box.

     NOTE: In previous versions of PC-File, serial numbers were
     called unique numbers. Previous versions include PC-File 6.5,
     6.0, 5.01, 5.0, PC-File:dB and others.

     To add a Serial Number attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field to add the Serial Number attribute to. The
       Field Attributes dialog box displays.

     3.Select Serial Number from the Available Attributes list.

     4.Choose Add. The Serial Number dialog box with When to Apply
       options displays.

     5.Type the starting number and the number to increment by, if
       desired.

     6.Select when to apply the serial number.

     7.Choose OK to add this attribute to the field.

     Relational Lookups

     Relational lookups are a special type of calculation that
     provide you with a way to "pull" information from another
     database into the present database.

     You can define a lookup by either entering a formula in the
     text box on Relational Lookup dialog box, or by choosing the
     Define Lookup button and PC-File will step you through the
     lookup definition process. See Chapter 17, "Relational
     Lookups" for more details on how relational lookups work and
     how to define relational lookup formulas.

     To add a Relational Lookup:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field to add Relational Lookup attribute to. The
       Field Attributes dialog box displays.

     3.Select Relational Lookup from the Available Attributes list.




     PC-File Version 7 Users Guide                             74


     4.Choose Add. The Relational Lookup dialog box with When to
       Apply options displays.

     5.Type the relational lookup formula into the text box, or
       choose the Define Lookup button. (See Chapter 17, "Defining
       Basic Lookups" for details on how to define a relational
       lookup.)

     6.Select when to apply the relational lookup.

     7.Choose OK to add this attribute to the field.


     Defining Validation Attributes

     Validation attributes apply data validation rules to allow you
     to control the way a user of your database enters data. The
     defined validation rules are applied as the user exits the
     field after entering data. If the data entered does not meet
     the validation criterion, a dialog box displays to inform the
     user what must be done to continue.

     Use the Must Answer attribute to create fields which require
     user input. Use the Validate Range attribute to limit the
     range of permissible data entered into a field. Validation
     attributes are applied at all times, when adding and modifying
     records.

     Must Answer

     Use Must Answer to require the user to enter data into a
     field. For example, you might have a database for tracking
     customer's orders. In order to keep track of every record, you
     might want to ensure that each order entered in the database
     includes the customer's identification number. Assigning the
     Must Answer attribute to the ID_NUMBER field reminds the user
     to enter data for the field whenever a new record is added.
     PC-File will not allow the user to continue until the field is
     filled.

     NOTE: Adding the Must Answer attribute to a numeric type field
     requires a non-zero entry. That is, entering 0 is always
     considered to be empty. Do not use the Must Answer attribute
     on numeric fields if zero is considered a valid entry for the
     field.

     To add a Must Answer field attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field which you would like to be Must Answer. The
       Field Attributes dialog box displays.

     3.Select Must Answer from the Available Attributes list.




     PC-File Version 7 Users Guide                             75


     4.Choose Add. An information dialog displays to indicate Must
       Answer has been added.

     5.Choose OK to add this attribute to the field.

     Validate Range

     Use Validate Range to limit the range of values a user can
     enter into a field. Setting the minimum and maximum values
     defines the range that will be allowed. Whenever the range is
     exceeded, PC-File notifies the user of the defined range and
     allows the user to continue editing to enter a correct value.
     The user cannot leave a record as long as the value exceeds
     the defined range.

     Generally you would use this attribute to define a numeric
     range. For example, from a minimum of 1 to a maximum of 100.
     However, you can also define a range of characters. For
     example, a minimum of A and a maximum of E to include A, B, C,
     D and E.

     To add a Validate Range field attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field to assign Validate Range to. The Field
       Attributes dialog box displays.

     3.Select Validate Range from the Available Attributes list.

     4.Choose Add. The Validate Range dialog box displays. It
       contains two text boxes: one for the lowest allowed value
       and one for highest allowed value.

     5.Type the values for the lowest and highest allowed values.

     6.Choose OK to accept the values.

     7.Choose OK to add this attribute to the field.

     Defining Formatting Attributes

     Formatting attributes determine how data displays in the
     field. PC-File gives you two Formatting Attribute options:
     Force Case and Date Format.

     Force Case

     You can specify three different case combinations with the
     force case attribute. You can force the entry into all upper
     case; all lower case; or mixed case, where the first letter of
     each word is capitalized and the rest of each word is in lower
     case. The Force Case attribute is applied as soon as the user
     exits the field.




     PC-File Version 7 Users Guide                             76


     To add a Force Case field attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field for the Force Case attribute. The Field
       Attributes dialog box displays.

     3.Select Force Case from the Available Attributes list.

     4.Choose Add to add the attribute. The Force Case dialog box
       displays. There is a set of option buttons: one for UPPER,
       one for lower, and one for Mixed Case.

     5.Select the button that corresponds with the desired case
       option.

     6.Choose OK to accept the selection.

     7.Choose OK to apply Force Case to the selected field.

     Date Format

     You can apply a particular date format with the date format
     attribute. This attribute allows you to change the date
     display format from MM/DD/YY to MM/DD/YYYY for example. You
     can choose a different Month- Day-Year sequence. You can also
     change the delimiter from slash (/) to hyphen (-) or period
     (.). The Data Format field attribute only applies to the field
     you select at the beginning of the field attribute definition
     process. You can assign different date formats for different
     date fields, if
     you want.

     NOTE: In most cases you will want to set date formatting for
     all fields at once using the Default Date Format options on
     the Configuration dialog. The Date Format field attribute only
     applies to one date field at a time and will override
     Configuration Default Date Format settings for that field
     only.

     To add a Date Format field attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field to apply data formatting to. The Field
       Attributes dialog box displays.

     3.Select Date Format from the Available Attributes list.

     4.Choose Add to add the attribute. The Date Format dialog box
       displays. There are option buttons for the display order of
       day, month and year; year display, two or four digits; and
       the separator: "-", "/" or ".".




     PC-File Version 7 Users Guide                             77


     5.Select the desired options for the order, year display and
       separator.

     6.Choose OK to accept these selections.

     7.Choose OK to apply the Date Format.

     Defining Data Restriction Attributes

     Data Restriction field attributes are much like Validation
     attributes except they are applied immediately, not as the
     user exits the field. PC-File gives you two options: Not
     Editable and Restrict Character.

     Not Editable

     The Not Editable field attribute to prevents data from being
     altered. This attribute prevents the cursor from entering the
     fields-pressing TAB while editing will bypass the field. You
     can prevent editing only when Adding, only when Modifying, or
     both. For example, if you have a field that has a calculated
     result that you don't want altered, configure the Not Editable
     attribute to apply when both adding and modifying records.
     However, you might want to allow user input when adding the
     record, but then prevent users from changing the field
     afterwards. In this case, you would choose to apply the Not
     Editable attribute only when modifying.

     To add a Not Editable field attribute:

     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field. The Field Attributes dialog box displays.

     3.Select Not Editable from the Available Attributes list .

     4.Choose Add. The Not Editable dialog box with When to Apply
       options display.

     5.Choose when to apply the Not Editable attribute.

     6.Choose OK to apply this attribute to the field.

     Restrict Characters

     Use the Restrict Characters field attribute to limit the
     characters the user can type in a field. You can restrict a
     field to accept only letters or only numbers for example.
     There is no way to define a range of allowed characters when
     doing this-you must type every allowed character when defining
     the Restrict Character attribute. This restriction applies
     whenever you add or modify data.

     To add a Restrict Character field attribute:




     PC-File Version 7 Users Guide                             78


     1.With a database open, choose Field Attributes from the File
       menu. The Field Selection dialog box displays.

     2.Choose the field. The Field Attributes dialog box displays.

     3.Select Restrict Characters from the Available Attributes
       list.

     4.Choose Add. The Restrict Characters dialog box displays.
       There is a box into which you enter the characters that you
       will allow the user to enter into the field.

     5.Type in each character you want to permit in the field in
       the text box.

     6.Choose OK to accept this selection.


     7.Choose OK to apply this attribute to the field.




     PC-File Version 7 Users Guide                             79



     CHAPTER 5 VIEWS

     In this chapter, you will be introduced to database views.
     Default Record and Default Table views will be introduced. How
     to navigate within views is also discussed. In addition, you
     will learn how to switch, create, modify, and delete
     customized Record and Table views.

     What are Views?

     Views are simply the different ways that you can display your
     data while working in PC-File. PC-File provides two kinds of
     views of your data:

       Record views
       Table views


     Record Views

     A Record view displays one record at a time.

     There are advantages to using either kind of view. Most of the
     time, you can see more of each record's data at once in a
     Record view. This gives you more information at your finger
     tips about each record.


     Table Views

     A Table view displays multiple records in a column format,
     much like a spreadsheet. You can page up and down to reveal
     other records, and scroll horizontally to display fields that
     don't fit on the screen.

     Table views show more than one record at a time and therefore
     are a better way to compare information from one record to
     another. Generally, you can't display as much of each record's
     information at once in a Table view as you can in Record view,
     but you can scroll across the table to view additional columns
     of data.

     Default Views

     Whenever you create a database, PC-File automatically creates
     two default views which are always named: Default Record View
     and Default Table View. Default views display every field in
     your database and the fields are displayed in the "physical
     order"-the order you defined the fields when creating the
     database structure.

     Custom Views




     PC-File Version 7 Users Guide                             80


     In addition to the default views, you can create custom views
     of either type. A custom view contains only the fields you
     specify in the order you determine. Using custom Record views
     you can organize the screen any way you want and include
     additional text, such as a title, headings, and data entry
     instructions. Using custom Table views you can choose which
     fields to show in the table and their order.

     Custom views can be particularly useful if your database has a
     large number of fields and you have more than one work group
     working with the database. You can create custom views that
     display different sets of fields for each work group. For
     example, one work group may only want to see fields containing
     name and address information for maintaining a mailing list,
     but another work group may want to view accounting fields for
     billing customers.

     You do not have to define custom views to use your database.
     You can access any database using just the two default views
     PC-File generates when you create the database structure.



     The Views Menu

     Choosing Views on the menu bar displays this list of options:

       The Switch option on the Views menu displays a list of your
       views to choose from. Pressing CTRL-T toggles between the
       last two views you've selected.

       The Create option lets you define custom views.

       The Modify option lets you change any of your custom views.

       The Delete option lets you delete any custom views you no
       longer need.

     These options have no effect on default views-the two default
     views cannot be modified or deleted.

     Each of these options are discussed in detail later in this
     chapter.

     Viewing Your Data

     When you open a database, PC-File displays the first record or
     group of records (based on the current index) on the screen.
     The area where the record displays is called the work area.


     NOTE: PC-File always starts up with the last view that was
     active when the database was closed.

     Switching Views




     PC-File Version 7 Users Guide                             81


     You may switch between views so that you can better see the
     data that is important for you. For example, you can browse
     through a group of records in a Table view to find a specific
     record. Once you've found the record that you want, you could
     switch to a Record view to see more of the data for that
     particular record.

     To switch between views:

     1.Choose Switch from the Views menu. The Switch View dialog
       box will display.

     2.Select the view that you would like to use from the list
       box.

     3.Choose OK. PC-File switches to the selected view.

     NOTE: There will always be at least two views to select when
     switching views. If you haven't created any custom views, you
     will only see the two default record and table views. See
     "Creating and Modifying Views" later in this chapter for
     information on creating custom views.

     Toggling Between Two Views

     You can move quickly between two views using CTRL-T. Pressing
     CTRL-T switches you to the view that you most recently viewed.
     Pressing CTRL-T will move you back to your original view.

     For example, if you are in the Default Table view and last
     used the Default Record view, you could move back to the
     Default Record view by pressing CTRL-T. To move back to the
     Default Table view, press CTRL-T again.

     To toggle between the two most recent views:

     1.Press CTRL-T to switch to the most recently used view. PC-
       File switches to the previous view.

     2.Press CTRL-T again. PC-File switches back to the original
       view.

     Navigating Within Views

     The following sections describe how to navigate within Record
     and Table views to display your data. See Chapter 6 for
     details on how to add records, and see Chapter 7 for details
     on how to search for and modify records.

     Navigating in a Record View


     The following table describes the mouse and keyboard options
     for navigating within a Record view.

     Function: Mouse Action: Keyboard




     PC-File Version 7 Users Guide                             82



     Display next record: Click Next button: CTRL-N

     Display previous record: Click Previous button: CTRL-P


     Scroll down one line: Click the down arrow on the scroll bar:
     N/A

     Scroll up one line: Click the up arrow on the scroll bar: N/A

     Scroll down a page: Click below scroll box: PGDN

     Scroll up a page: Click above scroll box: PGUP

     Jump to bottom of view: Drag scroll box to bottom of scroll
     bar: CTRL-PDN

     Jump to top of view: Drag scroll box to top of scroll bar:
     CTRL-PGUP


     You can edit fields in a record as long as the Read-only
     option on Edit menu is not checked. Use TAB and SHIFT-TAB to
     move between fields, or click on a field with the mouse. The
     current field is highlighted with a different color or shading
     than the other fields. The cursor displays as a flashing
     underscore.

     Navigating in a Table View

     Table views let you browse through your database many records
     at a time. Columns are distinguished by color on a color
     monitor, by shades of gray on a monochrome monitor. The width
     of each column in the Default Table view reflects the field
     length you defined when you created the database structure.
     However, you can define a custom Table view with narrower
     display widths. PC-File only displays entire columns on the
     screen, not partial columns. Thus, in some cases, empty space
     may appear on the right side of your screen.


     The records display in order based on the current index. If
     you switch indexes, the records rearrange on the screen to
     match the new index.

     The following table describes the mouse and keyboard options
     for moving around the screen in a Table view.

     Function: Mouse Action: Keyboard

     Scroll one column to the right: Click on right arrow on
     horizontal scroll bar: CTRL-TAB

     Scroll one column to the left: Click on left arrow on
     horizontal scroll bar: CTRL-SHIFT-TAB




     PC-File Version 7 Users Guide                             83



     Scroll right one screenful of columns: Click to the right of
     the scroll box on the horizontal scroll bar: N/A

     Scroll left one screenful of columns: Click to the left of the
     scroll box on the horizontal scroll bar: N/A

     Scroll to the right most column: Drag the scroll box on the
     horizontal scroll bar to the right end: N/A

     Scroll to the left most column: Drag the scroll box on the
     horizontal scroll bar to the left end: N/A

     Scroll the screen down one row: Click the up arrow on the
     vertical scroll bar: N/A

     Scroll the screen up one row: Click above the scroll box on
     the vertical scroll bar: N/A

     Page down one screenful: Click below the scroll box on the
     vertical scroll bar: PGDN

     Page up one screenful: Click above the scroll box on the
     vertical scroll bar: PGUP

     Pressing TAB moves the highlight one column to the right
     within the current screenful. Pressing SHIFT-TAB moves the
     highlight one column to the left. Once the highlight reaches
     the rightmost or leftmost column in the current screen, the
     window scrolls one column each time you press TAB or SHIFT-
     TAB. This differs from CTRL-TAB and CTRL-SHIFT-TAB in that
     they scroll the entire screen one column regardless of which
     column the highlight is on.

     Similarly, UP ARROW and DOWN ARROW move the highlight up and
     down one row within the current screenful. Once the highlight
     reaches the top or bottom of the current screenful, the entire
     screen will scroll. This differs from clicking the up and down
     arrows on the vertical scroll bar in that this always scrolls
     the entire screenful up or down one line.

     Viewing a Memo Field

     Memo fields, which hold up to 5000 characters of data, can be
     expanded for viewing and modification. When you expand a memo
     field, a memo window displays. This window can be resized as
     needed.

     You can display a memo window in either Record or Table views.
     You can also display a memo window for viewing AND
     modification, or only for viewing. Follow these guidelines to
     display a memo window:

       The Read-only mode on the Edit menu must be off to display a
       memo window for viewing AND modification.




     PC-File Version 7 Users Guide                             84


       You can display a memo window, for viewing only, when Read-
       only mode is on or off.

     To display a memo window for viewing and modification:

     1.Highlight the memo field you want to display and edit.

     2.Press CTRL-E. You can also click on the Up arrow button at
       the end of the field. The memo field expands to a memo
       window.

     3.Make any changes necessary to the memo.

     4.Choose OK to save your changes and close the window.

     Choose Cancel or press ESC to close the window without saving
     any changes.

     To display a memo window for viewing only:

     1.Display the record containing the memo you want to view.

     2.Press CTRL-V. The memo field expands to a memo window.

     3.Choose OK or press ESC when you finish viewing the data.

     To resize the memo window with a mouse:

     1.Click on the maximize button in the upper right corner to
       expand the window to full size. Click on the same button to
       return the window to its original size.

     As an alternative, move the cursor to one of the corners of
     the window, hold down the left mouse button, and drag the
     sides of the window. In this manner, you can expand or shrink
     the window.

     To resize the memo window with the keyboard:

     1.Press ALT-F10 to expand the window to full size. Press ALT-
       F10 again to return the window to its original size.

     As an alternative, press ALT-F8. Then use the arrow keys to
     expand or shrink an outline of the window. When the outline
     reflects the size you want, press ENTER.

     You can also move the memo window in the same manner that you
     move dialog boxes or Help windows.



     NOTE: Character fields can't be expanded to a window, even if
     you have defined a data length longer than the display length.
     You must scroll through the text within the defined display.

     Creating and Modifying Custom Views




     PC-File Version 7 Users Guide                             85



     The View Designer is where you create or modify views. There
     is a view designer for Record views and one for Table views.
     You can create views completely from scratch, or you can
     pattern one view after another. Patterning one view after
     another will save you time if the view you would like to
     create is similar to one of the existing views, especially
     with Record views.

     PC-File lets you create up to 10 custom views of either type.
     For example, you could have two Table views and three Record
     views. In general, only define the views you absolutely need,
     as too many views can be confusing.

     A view should reflect a particular need for your data. For
     example, you may have a database that is filled with address
     information about your clients, but most of the time, you only
     need their names and phone numbers. This would be a good
     reason to have a custom view that displays only the name and
     phone number information.

     Starting the View Designing Process

     You create custom views using the Record View and Table View
     Designers. Using the View Designers you specify and lay out
     the information that you want for your custom views.

     To create a new view from scratch

     1.With a database open, choose Create from the Views menu.

     2.Choose No when prompted to pattern after an existing view.

     3.Choose whether to create a Record view or a Table view. The
       Record View Designer or the Table View Designer display
       depending on the kind of view you choose in step 3.

     To create a new view by patterning after an existing view:

     1.With a database open, choose Create from the Views menu.

     2.Choose Yes when prompted to pattern after an existing view.
       The View selection dialog box displays.

     3.Choose the view you want to pattern after.

     4.Choose OK.

     The Record View Designer or the Table View Designer displays
     depending on the kind of view you chose in step 3.

     The details for defining each view type are covered in the
     following sections.


     The Record View Designer




     PC-File Version 7 Users Guide                             86



     You customize your Record view layouts in the Record View
     Designer. Here are the parts of the Record View Designer that
     are important to understand:

     The Cursor

     The cursor can be controlled by either the mouse or the arrow
     keys in most places throughout the View designer work area. As
     long a you have a mouse installed (if you don't, see Chapter
     1, "Installing Your Mouse" for more information), the View
     designer displays both a blinking square cursor and a mouse
     pointer. In graphics display mode, the mouse pointer displays
     as an arrow. However, in character display mode, the shape of
     the mouse pointer is identical to the square cursor, but the
     mouse pointer does not blink and it is a contrasting color.

       Using the keyboard, move the cursor using the ARROW keys
       anywhere in the View designer.

       Using a mouse, move the mouse pointer to a location and then
       click the left button to move the cursor to that location.

     The Button Bar

     The button bar is the area at the bottom of the screen just
     below the View designer work area. It contains the tools you
     will use to create views. When you first enter the View
     Designer the only buttons available are Field and Text. The
     Edit, Delete and Move buttons are greyed out-they become
     available once you place and select fields or text.


     Navigating in the Record View Designer

     You can navigate within the Record view designer work area
     using either the mouse or the keyboard. This section describes
     the different ways to scroll the screen. The sections
     following this, describe how to place fields and text. Then
     how to select, move, modify, and delete fields and text is
     discussed.

     The following table describes the mouse and keyboard options
     for scrolling the Record View Designer:

     Function: Mouse Action: Keyboard

     Scroll down one line: Click the down arrow on the scroll bar:
     N/A

     Scroll up one line: Click the up arrow on the scroll bar: N/A

     Scroll down a page: Click below scroll box PGDN

     Scroll up a page: Click above scroll box PGUP




     PC-File Version 7 Users Guide                             87


     Jump to bottom of view: Drag scroll box to bottom of scroll
     bar: CTRL-PGDN

     Jump to top of view: Drag scroll box to top of scroll bar:
     CTRL-PGUP


     Placing Fields

     You can place a field in the work area of the Record View
     designer two ways:

       Using Field button on the button bar

       Using Insert New Item dialog box

     Both methods afford you the use of the keyboard or the mouse.

     Using the Field Button

     Choosing the Field button displays the Field Details dialog
     box.

     You choose which field to place by scrolling through the Field
     list until the desired field displays.

     You can also use the Field Details dialog box to specify how
     much of a field will display at once by entering that value in
     the Display Width text box. For example, you may have a field
     with a data length of 65, but you only need to see 10
     characters of the data at a time. By defining the display
     width to be 10, you create a scrolling window that displays 10
     characters of the field's data at a time.

     A field's display width can be no longer than the data length
     (the length you specified when defining the database
     structure) up to a maximum of 65. You cannot change the
     display width for numeric fields, they always display their
     full data length. This also holds true for logical fields
     which can only be 1 character position long.

     You can also check the Show Field Name option to place the
     field name immediately to the left of the field. Do not check
     this option if you want to enter your own field label that
     does not use the internal "dBASE" field name. In that case,
     place text to format the field label (see "Placing Text" later
     in this chapter for details).


     Using the Insert Item Dialog Box




     PC-File Version 7 Users Guide                             88


     You can also display the Field Details dialog box by first
     invoking the Insert Item dialog box. To do this with the
     keyboard, move the cursor to the desired location and press
     ENTER. To do this with the mouse, you must click twice in the
     same location: Click once to move the cursor to the desired
     location, then click a second time directly on the cursor.
     This is functionally very similar to "double-clicking," but
     how fast you click is not important-you must click twice in
     the same spot to display the Insert New Item dialog box.
     Either action displays the Insert dialog box.

     This dialog box gives you the option to place either a field
     or text. Choosing Field displays the Field Details dialog
     described earlier.

     Note that most fields display with the field name enclosed in
     brackets. The area enclosed in brackets shows where the data
     will display. How much space is between the brackets is
     determined by the display width you define. If the display
     width is shorter than the number of characters in the field
     name, you will not be able to see the entire field name with
     the brackets. Also, a closing bracket will not display if the
     display width is less than the number of characters in the
     field name plus two.

     Once a field is placed in the view, you can move, modify, or
     delete it if necessary. See "Selecting, Moving, Modifying, and
     Deleting View Objects" later in this chapter for details.

     To place a field using the Field button:

     1.Move the cursor where you want place your field.

     2.Click on the Field button or press ALT-F. The Field Details
       box will display. The Field box will be empty. To choose a
       field, use one of these four methods:

       Type the field name in the box.

     Or...

       Use the UP and DOWN ARROW keys to move through the list of
       the fields until the desired field is highlighted;

     Or...

       Press TAB to move the highlight to the down arrow button at
       the right of the field box and press ENTER to see an entire
       list of the fields. Select a field for placement and choose
       OK;

     Or...

       Using the mouse, click on the down arrow button to see an
       entire list of the fields. Select a field for placement and
       choose OK.




     PC-File Version 7 Users Guide                             89



     3.Change the display width if you want by typing a value in
       the Display Width text box.


     NOTE: The display width cannot exceed the data width for that
     field.

     4.Turn on the Show Field Name option, if desired.

     5.Choose OK from the Field Details box.

     The field is placed in the work area.

     To place a field using the Insert New Item dialog box:

     1.Move the cursor where you want to place your field.

     2.Click the left button on the mouse twice in the same spot,
       or press ENTER. The Insert New Item dialog box displays.

     3.Choose Field. The Field Details dialog box displays. The
       Field text box will be empty. Choose a field using one of
       these four methods:

       Type the field name in the Field text box.

     Or...

       Press DOWN ARROW to move through a list of the fields until
       the desired field is displayed.

     Or...

       Press TAB to move the highlight to the down arrow button at
       the right of the Field text box and press ENTER to see an
       entire list of the fields. Select a field for placement and
       choose OK.

     Or...

       Using the mouse, click on the down arrow button at the right
       of the Field text box to see an entire list of the fields.
       Select a field for placement and choose OK.

     4.Change the display width if you want by typing a value in
       the Display Width text box.

     5.Turn on the Show Field Name option, if desired.

     6.Choose OK from the Field Details box. The field is placed in
       the work area.

     Placing Text




     PC-File Version 7 Users Guide                             90


     There are many reasons to place text in your view. You can
     replace the "normal" field name with a text label that is
     easier to for your database users to understand. You can place
     instructions on the screen to help the user. You could list
     the choices for a given field as text in the view. Or you can
     place lines to divide the data entry screen into groups.

     Placing text is similar to placing fields. You can place text
     in the work area of the view designer two ways:

       Using Text button on the button bar

       Using Insert New Item dialog box

     You can use either method using the mouse or the keyboard.

     Once text is placed in the view, you can move, modify, or
     delete it if necessary. See "Selecting, Moving, Modifying, and
     Deleting View Objects" later in this chapter for details.

     To place text using the Text button:

     1.Move the cursor to where you want your text.

     2.Click the Text button or press ALT-T. A dialog box will
       display, prompting you to Enter Text. The Text box will be
       empty.

     3.Type in your text in the Enter Text box.

     4.Choose OK.

     To place text using the Insert New Item dialog box:

     1.Move the cursor to where you want your text.

     2.Click the left button on the mouse twice in the same spot,
       or press ENTER. The Insert New Item dialog box displays.

     3.Choose Text. A dialog box will display, prompting you to
       Enter Text.

     4.Type in your text in the Enter Text box.

     5.Choose OK.

     Selecting, Moving, Modifying, and Deleting View Objects

     Once you have fields and text (view objects) in the View
     Designer work area, you may find you need to edit them to get
     your view "just right." These options are also useful if you
     started the view definition process by patterning after
     another view.




     PC-File Version 7 Users Guide                             91


     You must first select a view object before you can work with
     it. For moving and deleting view objects, PC-File lets you
     select multiple objects at once. However, you can only select
     one object at a time when modifying the definition of a view
     object.

     Selecting a Single View Object

     You must select an object before you can make any changes to
     it. You can select an object with the keyboard or the mouse.

     Using the keyboard to select an object:

     1.Use TAB and SHIFT-TAB or the ARROW KEYS to move the cursor
       to the object.

     2.Press SPACEBAR.

     The current object displays in a different color to indicate
     that it is selected.

     Using the mouse to select an object:

     1.Move the mouse cursor over the object.

     2.Click the left mouse button. The current object displays in
       a different color to indicate that it is selected.

     Selecting Multiple View Objects

     You can select more than one object in the View Designer. Use
     multiple selection when there is a group of more than one
     objects that you would like to move as a group to another area
     of the work area. You can also select multiple objects to
     delete them all at once.

     Using the keyboard to select multiple view objects:

     1.Use TAB and SHIFT-TAB or the ARROW KEYS to move the cursor
       to the first object that you want to select.

     2.Press CTRL-SPACEBAR. The object will change color,
       signifying that it is selected.

     3.Move the cursor to the next object that you want to select.

     4.Press CTRL-SPACEBAR. Both objects display in a different
       color, signifying that they are selected.

     5.Continue in this fashion until all the fields you want to
       work with are selected.

     Using the mouse to select multiple view objects:

     1.Move the mouse cursor to the first object that you want to
       select.




     PC-File Version 7 Users Guide                             92



     2.Hold down the CTRL key and click the left mouse button. The
       object will change color, signifying that it is selected.

     3.Move the mouse cursor to the next object that you want to
       select.

     4.Hold down the CTRL key and click the left mouse button. Both
       objects display in a different color, signifying that they
       are selected.

     5.Continue in this fashion until all the fields you want to
       work with are selected.

     Moving Selected View Objects

     Once you have selected one or more objects, you can move them
     to another location in the work space using either the
     keyboard or mouse.

     Using the keyboard to move view objects:

     1.Select the object or group of objects that you would like to
       move.

     2.Choose the Move button by pressing ALT-M.

     3.Using the ARROW keys, move the cursor to the new location
       for the objects.

     4.Press SPACEBAR to de-select and "drop" the objects in the
       new location.

     Using the mouse to move view objects:

     1.Select the objects or group of objects that you would like
       to move.

     2.Place the mouse cursor on any one of the selected objects,
       depress the left mouse button and hold it down.

     3.Drag the objects to the new location and release the left
       mouse button.

     4.Move the mouse cursor to an unused portion of the work area
       and press the left mouse button to de-select and "drop" the
       objects in the new location.

     Modifying View Objects

     Once you have placed view objects you may find you need to
     modify the definition of the object. You can modify the
     definition of any view object while the Record View designer
     is active. You can only modify one view object at a time.

     To modify a view object:




     PC-File Version 7 Users Guide                             93



     1.Select the object to modify.

     2.Choose Edit from the button bar.

     Or...

       Press ENTER.

     Or...

       Click the left button on the mouse twice on the desired
       object. The appropriate dialog box will display for editing
       a field object or a text object.

     3.Make any changes to the object.

     4.Choose OK.

     Deleting View Objects

     You can delete one or more view objects after selecting them.

     To delete view objects:

     1.Select the object or group of objects you want to delete.

     2.Choose Delete from the button bar. A dialog box displays to
       confirm that you want to delete the selected objects.

     3.Choose Yes to delete the selected objects.

     Completing the Record View Definition Process

     When you are happy with the design of your custom record view,
     you need to choose OK from the button bar to continue with the
     record view definition process. This displays the Access Order
     screen.

     The numbers next to each of the fields indicate the current
     order the fields will be accessed when entering data. By
     default, the access order is determined by the order you
     placed the fields in your view. The first field you placed is
     numbered 1; the second field you place numbered 2, and so on.
     This sequence is irrespective of where the field is placed in
     the work area. If this order is acceptable, you can choose OK
     to continue on to name your new view and conclude the
     definition process. The following section describes how to
     customize the access order.

     Setting Access Order




     PC-File Version 7 Users Guide                             94


     There are many ways to access the fields in your views. You
     may want a particular field to be accessed first in spite of
     the fact that the field is in the middle of work area. Or if
     you have more than one field per line, you may prefer either a
     left to right or a top to bottom access order.

     PC-File lets you change the access order easily. There are
     three access orders that can be applied automatically using
     the Sequence button. Choosing the Sequence button displays the
     Field Order dialog box.

     Left to Right

     If you have two or more fields per line, you can access all
     the fields in a row from left to right before moving to the
     next row. Choosing the Left to Right option automatically
     renumbers your fields in a left to right access order.

     Top to Bottom

     If you have two or more columns of data, you may prefer to
     access all of one column top to bottom before moving to the
     next one. Choosing the Top to Bottom option automatically
     renumbers your fields in this sequence.

     Physical

     The physical order is the order of the fields in the database
     structure. When you created the database structure, the order
     in which you entered the fields determined the physical order.
     The Default Record view reflects the physical order for your
     database. Choosing the Physical (DBF) option automatically
     renumbers your fields in this sequence.

     Custom Order

     You can also change the access order to anything you want by
     typing the desired sequence number next to each field. To do
     this, you do not choose the Sequence button, simply navigate
     to each field on the Access Order screen and type the desired
     sequence number.

     If you are defining a custom order for a large number of
     fields the Refresh button may come in handy. Choosing the
     Refresh button resolves any duplication in the sequence you
     are defining. For example, if the first two fields in your
     view are both numbered 1, choosing Refresh will leave the
     first field numbered 1, renumber the second field to 2, and
     renumber all following fields from 3 forward. You can also use
     the Refresh button to quickly move a field to the end of the
     access order. To do this: type a number greater than the total
     number of fields in your database in the field, then choose
     Refresh.

     To define the view's access order automatically:




     PC-File Version 7 Users Guide                             95


     Choose the Sequence button. The Field Order dialog box
     displays.

     1.Choose the desired option. The access order is renumbered.

     2.Choose OK on the button bar to continue with the view
       definition.

     3.To define a custom access order:

     1.Navigate to a text box next to a field using TAB or SHIFT-
       TAB, the ARROW keys, or by clicking in the text box.

     2.Type the number for the desired sequence in the access
       order.

     3.Repeat steps 1 and 2 until all fields are numbered. Choose
       Refresh to resolve duplication, if desired.

     4.Choose OK on the button bar to continue with the view
       definition.

     Naming the View

     After you have defined the access order, you must name your
     custom Record view to complete the view definition process.
     Choosing OK from the Access Order screen displays the View
     Name dialog box:

     A default name of "Custom Record View" displays in the box.
     You generally will want to use a more descriptive name. Each
     view must have a unique name. You can enter a name up to 30
     characters long.

     To name a Record view:

     1.Type in a name for the view.

     2.Choose OK.

     The record view definition process is complete. You are
     returned to the main PC-File work area. Your new record view
     is now active.



     Overview of Creating a Custom Record View

     This overview will take you through the basic steps for
     creating a view. You can pattern a view after one of the
     default views or any other view that has been defined. In this
     example, you will create a completely new view.

     To create a new Record view:

     1.Open a database.




     PC-File Version 7 Users Guide                             96



     2.Choose Create from the View menu. A decision box will
       display.

     3.Choose No. The Create View dialog box will display.

     4.Choose Record View. You will then move into the View
       Designer. The work area is blank.

     5.Place your field and text objects in the work area.

     6.Choose OK.

     7.Select the sequence for access order.

     8.Choose OK.

     9.Enter a name for the View.

     10.  Choose OK. The newly defined Record view is active.

     Modifying a Custom Record View

     You can modify any of the Custom Record views you have created
     using the Modify option on the Views menu. You cannot modify
     the Default Record view.

     Choosing Modify presents you with a list of all of your custom
     views, both record and table views. The view designer that
     displays after you choose a view to modify depends on the kind
     of view you choose from the list. For this reason, you may
     want to include the kind of view as part of each custom view's
     name when creating them so that you can easily distinguish
     them.

     Once you have the selected view active in the Record View
     designer, you can use any of the procedures described in the
     "Adding Fields", "Adding Text", and "Selecting, Moving,
     Modifying, and Deleting View Objects" sections to modify the
     view.

     To modify a Record view:

     1.Open a database.

     2.Choose Modify from the Views menu.

     3.Select a Record view to modify.

     4.Choose OK. The Record View Designer displays. The work area
       displays the objects that currently make up the view.

     5.Edit the field and text objects in the work area.

     6.Choose OK.




     PC-File Version 7 Users Guide                             97


     7.Select the sequence for access order.

     8.Choose OK.

     9.Enter a name for the view.

     10.  Choose OK. The modification process is complete.

     Deleting a Record View

     You can delete a view at anytime. If you created a view to
     more easily complete a particular task, you can delete that
     view when you have finished.

     To delete a Record view:

     1.Choose Delete from the Views menu.

     2.Select the view to delete.

     3.Choose OK.




     PC-File Version 7 Users Guide                             98



     The Table View Designer

     Use the Table view designer to specify which fields to put
     into a custom Table view and to determine the order they
     display in. The Table View designer is accessed from the View
     menu like the Record view designer.

     Just like record views, you can start the Table view
     definition process by patterning after other Table views, or
     you can create them from scratch. Unlike creating Record
     views, there are not as many differences between creating a
     Table view with a pattern or without a pattern.

     After you choose to define a Table view, the Table View
     designer displays.

     The Field Name column displays each of the field names for all
     of the fields in your database. You cannot edit the field
     names.

     The Column column lets you determine the order the columns in
     your custom Table view will display. For example, typing a 1
     for a field causes that field's column to display at the far
     left of the Table View work area. Similarly, typing a 3 for a
     field causes that field to display as the third column from
     the left. Any field that you do not enter a number for will
     not be included in the view.

     The Width column defaults to displaying the current display
     width for each field. Changing the Width number increases or
     decreases how much of the field displays at once in the
     resulting Table view-the display width of each column. You
     cannot enter a width that is larger than the field's data
     length. You cannot specify a width of zero, but you can
     exclude a field from displaying by not typing a Column number
     for that field. And you cannot change the display width for
     numeric fields- numeric
     always display their full data length.

     Creating a Table View

     To create a new Table view:

     1.Open a database.

     2.Choose Create from the View menu. A decision box will
       display.

     3.Choose No. The Create View box will display.

     4.Choose Table View. The Table View Designer displays.

     5.Move the highlight to the column field.




     PC-File Version 7 Users Guide                             99


     6.Type the number corresponding to the column where this field
       should display.

     7.Move the highlight to the display width.

     8.Type an appropriate display width.

     9.Repeat this procedure for each of the fields you wish to
       display.

     10.  Choose OK to continue the Table View definition process.

     Naming the View

     After you have determined the columns and display widths, you
     must name your custom Table view. The default name is Custom
     Table View. You generally will want to use a more descriptive
     name. It's a good idea to include the type of view (Record or
     Table) in the name.

     To name a Table view:

     After you have determined the columns and display widths, a
     dialog box will display prompting you to enter a view name:

     1.Type in a name for the view. You can type up to 30 alpha-
       numeric characters.

     2.Choose OK.

     Modifying Custom Table Views

     You can modify any of the Custom Table views you have created
     using the Modify option on the Views menu. You cannot modify
     the Default Table view.

     Choosing Modify presents you with a list of all of your custom
     views, both record and table views. The view designer that
     displays after you choose a view to modify depends on the kind
     of view you choose from the list. For this reason, you may
     want to include the kind of view as part of each custom view's
     name when creating them so that you can easily distinguish
     them.

     Once you have the selected view in the Table View designer,
     you can modify its definition.

     To modify a Custom Table view:

     1.Open a database.

     2.Choose Modify from the Views menu.

     3.Select a Table view to modify.

     4.Choose OK. The Table View Designer displays.




     PC-File Version 7 Users Guide                            100



     5.Edit the Table view definition

     6.Choose OK.

     7.Enter a name for the view.

     8.Choose OK. The modification process is complete.

     Deleting Table Views

     You can delete a Table view at anytime. If you created a view
     to more easily complete a particular task, you can delete that
     view when you have finished.

     To delete a Table view:

     1.Choose Delete from the Views menu.

     2.Select the view to delete.

     3.Choose OK.




     PC-File Version 7 Users Guide                            101




     CHAPTER 6 ADDING DATA

     Once you create a database structure, you can begin adding
     data. Data is normally added one record at a time through the
     data entry screen. This chapter explains the procedures
     involved in adding data.


     Data Entry

     Data is normally added to a database on the data entry screen.
     When you add records, the current record on the screen clears
     and the cursor moves to the first entry field. You can then
     begin adding records, one at a time.

     You can add new records in either Record or Table views by
     choosing the Add option from the Edit menu or by choosing the
     Add button on the button bar. In a Record view, an empty
     record is displayed for you to fill out. In a Table view, an
     empty row is displayed at the top of the table for you to fill
     out. The new record is saved when you finish entering the data
     and navigate to a new record or choose to add another record.

     During data entry, the entire menu bar is available. If you
     perform another menu operation (except Tools menu options)
     while adding a record, the new record is automatically saved
     before proceeding.

     NOTE: You can also add data to a database by importing a file.
     See Chapter 13, "Utilities," for information on this method of
     adding data.

     You can add up to 1 billion records in a database. It is more
     likely that you will run out of space on your hard disk before
     you encounter the limits of PC-File itself.

     Adding a Record

     The procedures for entering a record are the same, whether you
     are in Record view or Table view.

     To add a record:

     1.Open the database.

     2.Choose Add from the Edit menu, or choose the Add button on
       the button bar (press ALT-A, if using a keyboard). An empty
       record data entry screen displays if you are in a Record
       view, or an empty row displays on the top row if you are in
       a Table view.

     3.Enter the record. Press TAB or ENTER to move from one field
       to the next. Use SHIFT-TAB to move to the previous field to
       correct an error.




     PC-File Version 7 Users Guide                            102



     4.Repeat these steps to add additional records.

     See Chapter 5, "Navigating Within Views" for full details on
     how to move around within a record.

     Saving a Record

     Each new record is saved as soon as you choose to add
     additional records or when you navigate to a pre-existing
     record (using the Prev and Next buttons or CTRL-P and CTRL-N).
     Also, if you perform another menu operation (except Tools menu
     options) while adding a record, the new record is
     automatically saved.

     Cancelling an Added Record

     You can cancel adding a new record at any point before the
     record is saved by choosing the Cancel button or by pressing
     ESC. A visual cue that cancelling is possible is that the
     Cancel button is greyed-out once the record has been added.

     Entering Data in a Memo Field

     Memo fields differ from other fields in that you can expand
     the display during data entry. The field expands to a window,
     allowing you to see most or all of your entry. This makes data
     entry and formatting much easier.

     A memo field is identifiable by the up arrow button that
     displays at the end of the field.

     To expand a memo field:

     1.Click on the button at the end of the field. From the
       keyboard, place the cursor in the field and press CTRL-E.
       The field expands to a window.

     If necessary, you can resize the window.

     To resize the window with a mouse:

     1.Click on the maximize button in the upper right corner to
       expand the window to full size. Click on the same button to
       return the window to its original size.

       As an alternative, move the cursor to one of the corners or
       sides of the window, hold down the left mouse button, and
       drag the sides of the window. In this manner, you can expand
       or shrink the window.

     To resize the window with the keyboard:

     1.Press ALT-F10 to expand the window to full size. Press ALT-
       F10 again to return the window to its original size.




     PC-File Version 7 Users Guide                            103


       As an alternative, press ALT-F8. Then use the arrow keys to
       expand or shrink an outline of the window. When the outline
       reflects the size you want, press ENTER.

     You can also move the memo window in the same way that you
     move dialog boxes or Help windows.

     To close a memo window:

     1.Choose the OK button. This saves the memo entry and closes
       the window.

       If you don't want to save your entry or changes, choose
       Cancel or press ESC instead. In that case, PC-File prompts
       you to save changes before closing the window. Choose No if
       you don't want to save your changes.

     Once you close a memo window, only the first line of the memo
     displays in the field.

     You can enter up to 5000 characters in a memo field.

     NOTE: You can't expand character fields to a window, even if
     you have defined a data length that is longer than the display
     length. Instead, the text scrolls to the left as you enter
     data in the field.

     You can also spell check the contents of your memo field using
     the Spell button. See Chapter 15, "Using the Spell Checker"
     for details on how to use the spell checker dialog box.


     Do You Get a Beep?

     Some field types and field attributes place limitations on the
     characters that can be entered in a field. For example, you
     can't enter letters in a numeric field, and you can only enter
     the letters y, n, t, and f in logical fields. The Character
     Restriction field attribute can further limit the characters
     that can be entered.

     If the computer beeps at you when you are entering data, it's
     because you're trying to enter a character that isn't
     permitted in that particular field or because the field is
     full and characters are being deleted from the end.

     Not Editable

     If the cursor skips over a field, or if PC-File beeps when you
     try to click in a field, the Not Editable field attribute has
     been set for that field. As its name implies, the Not Editable
     field attribute is used to prevent the contents of a field
     from being edited. See Chapter 4 for details on the Not
     Editable field attribute.

     Leaving Fields Blank




     PC-File Version 7 Users Guide                            104



     The field type determines what happens to a field that you
     leave blank. If the field is numeric, PC-File places a 0 in
     the blank field. If the numeric field includes a decimal, PC-
     File includes a 0 before the decimal and a 0 for each
     character to the right of the decimal. Thus, a field with
     three characters to the right of the decimal looks like this
     when left blank: 0.000.

     All other field types display no characters in the field if
     left blank during data entry.

     Using Calculation Fields

     If you have defined a field with a calculation, the data in
     the field is derived from the calculation. PC-File allows you
     to access calculation fields and even enter data in them.
     However, the data displayed in the record is the data derived
     from the calculation. PC- File ignores any data you have
     entered by accident or otherwise, unless you chose the Only
     When Field is Empty option when defining the calculation.

     To prevent yourself or other users from entering or editing
     the result of a calculation, you can add the Not Editable
     field attribute. See Chapter 4 for details on how to do this.


     Shortcuts and Helpful Tips

     PC-File provides a number of hot keys and other short cuts to
     make data entry as easy as possible.

     Duplicating Fields and Records

     PC-File can automatically enter data from the previously
     viewed or added record into the current record. You can choose
     between duplicating a single field or duplicating all fields
     from the cursor position to the end of the record. Either way
     can shorten the time it takes to add data.

     Duplicating a field overrides any default data that you
     entered in a field when defining the database.

     Duplicating a Single Field

     Duplicate a single field when only that field repeats itself,
     but not the fields that follow. For example, if you are
     entering address information, it is likely that you could
     encounter two addresses in a row from the same state, but with
     a different zip code.

     To duplicate a field:

     1.Place the cursor in the field.




     PC-File Version 7 Users Guide                            105


     2.Press CTRL-F. The data from the previously-viewed or added
       record is copied into the current record.

     Duplicating to the End of the Record

     You can duplicate all data from the current field forward in
     access order to the end of the current view. For example, you
     may find in entering addresses that the city, state, and zip
     code information is the same for the current record as for the
     previously viewed or added record. It's probably quicker to
     copy the data from the previous record than to type it in
     again.

     To duplicate all data to the end of the record:

     1.Place the cursor in the appropriate field.

     2.Press CTRL-R. PC-File copies the data for that field and all
       subsequent fields (in access order) from the previous
       record.

     Once you complete the duplication, you can make changes before
     adding the record to the database.

     CTRL-R is most useful in either of two situations:

       When two records are almost exactly the same, and you just
       have to change one or two fields after making the
       duplication.

       When the last few fields in a record are the same. In that
       case, enter the information in the early fields, then press
       CTRL-R when you reach those fields that can be copied from
       one record to the next.

     NOTE: Be cautious in using CTRL-R if your database contains a
     field with the Serial Number field attribute. PC-File makes an
     exact duplicate with CTRL-R, including the Serial Number
     field. Thus, you would end up with two records with the same
     number in that particular field. You can get around this if
     the Serial Number field is the first field in the record. In
     that case, move the cursor to the second field before pressing
     CTRL-R.

     Memorizing Data

     If you want to enter the same data in a field quite often, you
     can copy the data to the buffer and paste it into a field
     whenever necessary. To do that, use the read from and write to
     hot keys. These hot keys are explained in detail in Chapter 7,
     "Finding and Modifying Data."




     PC-File Version 7 Users Guide                            106


     NOTE: If you find yourself using the buffer for one particular
     field a lot of the time, consider entering default data in the
     field instead. You can always overwrite the default data if
     necessary. See the section on entering default data in Chapter
     2, "Creating a Database."

     Using the Flip Data Character

     PC-File provides the tilde (~) character to flip data within a
     field. The tilde is most often used in name fields that
     include both the first and last name within a single field.
     Being able to flip the data lets you enter the last name first
     for sorting purposes, then flip the last name and first name
     to print mailing labels.


     NOTE: For most databases, it is recommended that you place
     first names and last names in separate fields. If you do that,
     you don't need the tilde.

     To flip data, type the tilde between the two parts of the
     field that you want to flip in every record you enter. Then,
     when you print out a report, whether on-screen or to a
     printer, the two parts of the field display in flipped order.

     Thus, if you enter Ratite ~Janet in the field when adding
     data, Janet Ratite appears in the report. Be sure to enter a
     space between the last name and the tilde that precedes the
     first name.

     NOTE: Make sure the flip data option is turned ON (checked) in
     the Print options dialog box.

     You can also flip data when you are adding or modifying a
     record. With the cursor in the field you want to flip, press
     CTRL-O to flip the data. This is most useful if you have
     entered dozens of names in one order, then realize you want
     them in reverse order for sorting. You can modify each record
     by placing the cursor in the proper field and pressing CTRL-O.
     This is much faster than retyping each one.




     PC-File Version 7 Users Guide                            107



     CHAPTER 7 FINDING AND MODIFYING DATA

     To find data, choose one of two powerful search options. To
     modify records, display a record, click in the field or press
     ALT to move the cursor into the record and then TAB to the
     field, and make your changes. These operations and more are
     covered in this chapter.

     The Search and Modify Options

     Locating data, viewing that data, and making changes to it are
     key ingredients of any database. PC-File provides a variety of
     alternatives for all three operations.

     For the most part, these operations are activated or performed
     from the options on the Edit and Search menus. These menus are
     illustrated below and each of the options described briefly.
     You can also locate records by simply browsing through the
     database as described in Chapter 5, "Views."

     The Search Menu

     Use the options on the Search menu to navigate through your
     records:

     Choose Beginning to display the first record in the database,
     based on the current index. Choose End to display the last
     record, also based on the current index. If you change
     indexes, these records are likely to change.

     You can also choose the Search button on the button bar to
     conduct a Simple search.

     The Edit Menu


     With the exception of Add, the options on the Edit menu are
     used for making changes to your data. You can make changes as
     long as the Read- only option is not checked. Checking the
     Read-only option permits you to view the data, but allows no
     access for making changes.

     Switching edit modes and making changes is covered in detail
     in the section "Modifying and Deleting Records," at the end of
     this chapter.

     The Add option is covered in Chapter 6, "Adding Data."

     Paging Through Records




     PC-File Version 7 Users Guide                            108


     For the most part, finding data means conducting a search for
     that data. You define specific criteria, then let PC-File
     search for the records that meet the criteria. However, you
     can also page through your records. PC-File lets you page
     through one record at a time in a Record view or a screen's
     worth of records in a Table view.

     Whether you page through one record or many records at a time
     depends on the current view. Display a Record view to page
     through one at a time. Use the Next and Prev buttons or CTRL-N
     and CTRL-P to page forward and backward in your database.

     Displaying a Table view lets you page through your records a
     screenful at a time. Use PGDN and PGUP to display the next
     screen or the previous screen of records. You can also use the
     UP and DOWN ARROW keys to move one record at a time.
     Alternatively, you can use the vertical scroll bar on the
     right side of a table view to page through records in a Table
     view.

     See Chapter 5, "Navigating Within Views" for full details on
     how to navigate within Record and Table views.

     You can also jump to the first or last record in your
     database, based on the current index, at any time. To display
     the first record or group of records, choose Beginning from
     the Search menu. To display the last record or group of
     records, choose End from the Search menu.

     Conducting a Search

     PC-File allows up to a billion records in a database, so fast
     and efficient methods of searching for data are an important
     feature of the program. Paging through your records, either in
     Record or Table view, can be useful, but offers little help
     when you want to find information in a large database quickly
     and easily.

     PC-File provides three powerful search options:

       Simple

       Formula

       Global

     A Simple search satisfies most search needs and is easy to
     learn and use. A Formula search provides more power than a
     Simple search, but requires you to enter a search command. Use
     a Global search to look in all but memo fields for specific
     text.

     Within Simple and Formula searches, you can look for records
     that "sound like" the search criteria, scan through a specific
     field for a word or part of a word, enter wildcard characters,
     and use comparison operators.




     PC-File Version 7 Users Guide                            109



     When you conduct a search, PC-File displays the first record
     found that satisfies the search criteria. To see the next
     record that satisfies the search criteria, click on the Again
     button or press CTRL-A.

     Choosing the Search Type

     For the most part, you will probably conduct Simple searches
     when looking for specific records. A Simple search is quicker
     and easier to conduct and powerful enough for most needs.
     However, there are some kinds of searches that can only be
     done with a Formula search. A Global search is most useful for
     searching for data when you are unsure in which field you need
     to look.

     Advantages of a Simple Search

     When you choose Simple search from the Search menu, PC-File
     displays your data entry screen and lets you enter the search
     criteria in the appropriate field(s).

     To search for all members in your database that live in
     Seattle, you simply type the word Seattle in the CITY field,
     as shown above.

     There are several advantages of a Simple search when compared
     to a Formula search. A Simple search:

       Is more intuitive

       Requires fewer keystrokes

       Allows less likelihood of making a typing mistake

       Doesn't require a knowledge of search command syntax

     It is likely you will conduct Simple searches in all cases
     except those that require a Formula search.

     Advantages of a Formula Search

     When you choose Formula from the Search menu, PC-File displays
     a dialog box for entering a search command.

     A Formula search is more powerful than a Simple search. You
     can conduct certain kinds of searches with a Formula search
     that you can't with a Simple search. Among them are searches
     that:

       Include more than one search criterion within a particular
       field

       Use OR statements

       Require a calculation




     PC-File Version 7 Users Guide                            110



     If you want to search for all members that live in either
     Seattle OR Portland, or you want to search for all members
     that live in Seattle OR have a last name of Jones, you must
     use a Formula search. (You could search for all members that
     live in Seattle AND have a last name of Jones using a Simple
     search, but to use OR, you must conduct a Formula search.)

     Advantages of a Global Search

     A Global search lets you scan through all the fields in your
     database, other than memo fields, for a specific bit of
     information or text. It is most useful when you have multiple
     fields that contain the same type of information. For example,
     if you have several name fields or several fields listing
     parts or parts numbers, use a Global search if you are unsure
     which field contains the data you are looking for.

     On the other hand, if you know which field you want to look
     in, conduct a Simple search instead, using the scan-across
     search method (described below). The Simple search is faster,
     as PC-File doesn't have to look through all the fields for the
     information. You can also use the scan- across method to
     conduct searches in memo fields, which you can't do with a
     Global search.

     Index Autoswitching

     On large databases, indexing the field you are searching on
     will speed up most Simple and Formula searches quite
     dramatically. (See Chapter 8, "Sorting and Indexing Data" for
     details on how to define indexes.) This increase in searching
     speed will only occur if the index for the field you are
     searching on is current when searching is performed. The
     current index is always indicated on the Status line on the
     bottom of the screen.

     By default, PC-File will automatically switch to the best
     index (if one is available) when performing a Simple or
     Formula search. This feature is called autoswitching.

     For example, suppose your database has an index on the ZIPCODE
     field and an index on the LASTNAME field. If the LASTNAME
     index was current when you conducted a Simple search on the
     ZIPCODE field, PC-File would autoswitch to the ZIPCODE index
     to perform the search as quickly as possible.

     There may be occasions where you want to prevent autoswitching
     from occuring. For example, suppose you have indexes on the
     STATE and the ZIPCODE fields. You might enter a search to find
     records for a particular state, but you want the records found
     to display in the ZIPCODE order. With autoswitching on, PC-
     File would always switch to the STATE. However, the bottom
     line of the Simple screen and Formula search dialog box has
     two option buttons to toggle autoswitching on and off.
     Choosing the No




     PC-File Version 7 Users Guide                            111


     button turns autoswitching off, choosing the Yes button turns
     autoswitching on.

     There is also an Index button in the lower left corner of the
     Simple search screen and Formula search dialog box. Choosing
     this button lets you manually switch the current index. See
     Chapter 8, "Switching Indexes" for details on how to switch
     indexes.

     Methods of Entering Search Criteria

     There are five different ways of entering search criteria in
     Simple and Formula searches. They include

       Generic

       Scan-across

       Sounds-like

       Wildcard

       Comparison

     All five methods can be used in both Simple and Formula
     searches. You can also combine the methods within one search,
     though there are some limitations that arise. For example, you
     cannot use the scan-across method in numeric fields. The
     limitations are covered in the discussion on each method
     below.

     NOTE: Determine case sensitivity in the Configuration option
     on the Utilities menu. If you make searches case sensitive,
     entering SEATTLE will not find Seattle or SEAttle. If you make
     searches case insensitive, then SEATTLE retrieves records for
     Seattle or SEAttle.

     NOTE: Search criteria in Simple and Formula searches require
     the use of specific characters. Those characters are ?, ~, and
     _. Because these characters are part of the search syntax, you
     cannot search for them using Simple or Formula searches.
     However, you can search for these characters using the Global
     search method.

     Generic Searches

     The generic search is the default method of entering search
     criteria. In a generic search, you enter the search criteria
     just as it appears in the record. For example, to retrieve
     records in which the city is listed as Seattle, type Seattle
     in the City field.

     You can also enter part of a word, but it must be the first
     part. For example, type le to retrieve records that start with
     LE in the field, such as LEOPARD or LEMUR. Records containing
     CATTLE or TURTLE would not be retrieved.




     PC-File Version 7 Users Guide                            112



     For the Simple search option, a generic search requires no
     special characters. Enter just the search criteria themselves.

     For the Formula search option, place quotation marks " "
     around the search criteria for generic searches. The quotation
     marks are part of the command syntax.

     If you only want to find occurrences of JOHN and not JOHNSON
     or JOHNSTON, follow the N with a space.

     Use only generic searches or comparison searches when
     searching for values in numeric fields. In addition, you must
     search for the actual value; you can't search for part of the
     value. For example, if you enter 1 in a numeric field search,
     PC-File only finds records where the value is 1, not 12 or
     100.

     Scan-across Searches

     Use the tilde (~) to look for an occurrence of a word or
     characters anywhere within a field. Thus, ~LE would retrieve
     records for Leopard, Lemur, Cattle, and Turtle.

     If you only want to find occurrences that end in LE, follow
     the LE with a space. Only Cattle and Turtle would be retrieved
     in that case.

     In Formula searches, place the tilde before and after the
     search criteria, like so: ~LE~ or ~PARD~.

     You can't use a scan-across search in a numeric field.

     Sounds-like Searches

     Use the question mark (?) to conduct a sounds-like search. A
     sounds- like search retrieves records that sound the same as
     the search information. This is used to find a name when
     you're uncertain of the spelling. For example, if you enter
     ?Rawlins, PC-File retrieves records such as Rollings, Rollins,
     Rawlings, and Rawlins.

     The first character of a sounds-like search must be the same.
     For example, you wouldn't be able to find Cranston if you
     asked for ?Kranston.

     Place a question mark before and after the search criteria in
     Formula searches, like so: ?RAWLINS? or ?SMITH?. In Simple
     searches, place the question mark in front of the search
     criteria only.

     Sounds-like searches can only be conducted on character
     fields.

     Wildcard Searches




     PC-File Version 7 Users Guide                            113


     Use an underscore ( _ ) to indicate wildcard characters
     appearing in fixed positions within a field. For example,
     suppose you wanted to find all members with a renewal date in
     the month of May. You could enter 05/__/____ or 05/__/1993 in
     the renewal date field to display those records. This example
     assumes you are using the default MM/DD/YYYY date display
     format. Enter wildcard searches on dates using the field's
     current display format.

     NOTE: When searching on a date field, you must enter the date
     in the the field's current display format. Also, if you enter
     searches on dates using the display format, you must include
     the separator characters. For example, if you are using the
     MM/DD/YYYY format, include both slashes in the search
     expression.

     When you enter the wildcard character as part of the search
     criteria, PC-File accepts any character found in that
     position.

     You cannot use wildcard characters in combination with sounds-
     like or global searches. Also, you can't use wildcards to
     search numeric fields. This is because a number in a numeric
     field is handled as a single value-PC-File does not "see" it
     as a string of separate characters. However, you can perform a
     wildcard search on a number stored in a character field.

     Comparison Searches

     Use comparison operator symbols when performing a simple
     search to search for data that is "greater than," "greater
     than or equal to," "less than," "less than or equal to," or
     "not equal to." You do this by typing the appropriate
     comparison operator followed by the search data on the Simple
     Search screen. You can use any of the following comparison
     symbols:

     Symbol    Comparison Operation

     >         Greater than

     <         Less than

     >=        Greater than or equal to

     <=        Less than or equal to

     ! or !=   Not equal to (the equals sign is not 
          required)

     For example, suppose you want to search for all checks with
     numbers greater than 1000 and dates on or before (less than or
     equal to) January 31, 1993. To do this you would type >1000 in
     your Check Number field and <=01/31/93 in your Check Date
     field on the Simple search screen.




     PC-File Version 7 Users Guide                            114


     NOTE: The number of spaces available to enter search criteria
     on the Simple search screen are limited to 2 characters
     greater than the display length of the field, except for date
     and memo fields. This provides 2 extra spaces for you to enter
     your comparison operator, if necessary. The contents of the
     search field will scroll 2 spaces if you enter a search
     criterion that is longer than the field's display width.
     Searches on dates will scroll up to 12 spaces, and searches on
     memos will scroll up to 65 spaces.

     You cannot include more than one comparison per field when
     conducting a Simple search. For example, you cannot enter
     >1000 & <1100 to find records greater than 1000 and less than
     1100. You must use a Formula search to do this.

     Also, in a Simple search, all search criteria must be met to
     find a record. The Simple search mentioned in the Check Number
     example above would be equivalent to a Formula search like
     this:

          CHECK_NO > 1000 & CHK_DATE <= "01/31/92"

     A simple search is always equivalent to a Formula search using
     "and" operations: "find records where both x and y are true."
     Any search that requires "or" operations must be entered as a
     Formula search.

     See "Conducting a Formula Search" for details on how to use
     comparison operators in Formula searches.

     Conducting a Simple Search

     Generally, you'll want to conduct a Simple search unless the
     complexity of the search criteria requires that you conduct a
     Formula search. Use any of the five methods of entering search
     criteria described above when conducting a Simple search.

     To conduct a Simple search:

     1.Choose the Search button or press CTRL-S. The Simple search
       screen displays.

     2.Enter the search criteria in the appropriate field(s).

     3.Turn off Autoswitch, if you want to remain in the current
       index. See "Index Autoswitching" earlier in this chapter for
       details.

     4.Choose OK to begin the search. PC-File displays the first
       record that meets the criteria.

     5.Choose the Again button or press CTRL-A to display the next
       record that meets the criteria. Repeat this step to retrieve
       all additional records that meet the criteria.




     PC-File Version 7 Users Guide                            115


     PC-File interprets unused character positions that follow your
     criteria as wildcards. Thus, if you search for the name Anders
     in a last name field, you'll find records for Anders,
     Anderson, and Andersen. If you only want to find records for
     Anders, enter a space with SPACEBAR after the last character
     in Anders.

     You can enter search criteria in a single field or in multiple
     fields. For example, to search for members living in Seattle,
     move the cursor to the City field and type Seattle. That is a
     single field search.

     A multiple-field search is a more selective type of search. If
     you enter search data in multiple fields, all of the data must
     match before the record is considered found.

     For example, you can search for zoo members living in Seattle
     that are life members.

     Only the records for those people that are both life members
     and live in Seattle are found as a result of the above search.

     Conducting a Formula Search

     A Formula search provides more power than a Simple search.
     With a Formula search, you enter the entire search command
     rather than just the search criteria. This gives you more
     flexibility when conducting the search.

     For example, you can enter multiple search criteria for a
     specific field. And you can use OR as a logical operator, as
     well as AND.

     To conduct a Formula search:

     1.Choose Search from the menu bar.

     2.Choose Formula from the Search menu. A dialog box appears.

     3.Enter the search command in the text box.

     4.Turn off Autoswitch, if you want to remain in the current
       index. See "Index Autoswitching" earlier in this chapter for
       details.

     5.Choose OK to begin the search. The first record that meets
       the search criteria displays.

     6.Click on the Again button or press CTRL-A to display
       additional records that meet the search criteria. The
       Formula search dialog box allows up to 250 characters.

     The Format of a Search Command

     A Formula search command follows a basic format containing a
     Search Location, a Comparison Operator and Search Criteria.




     PC-File Version 7 Users Guide                            116



     The search location always appears on the left side of the
     comparison operator and the search criteria on the right side.


     Another example illustrates a more involved search command:

     LASTNM = "SMITH" | LASTNM = "JONES" & CITY = SEATTLE"

     Translated into plain English, this command says "First find
     anyone named SMITH or JONES, then make sure the city is
     SEATTLE."

     You can include up to 34 comparisons in a search command. Use
     spaces as you see fit to improve readability. They don't
     affect the command, except when used in search criteria to
     indicate a space.

     The components of a search command are explained in detail
     below, followed by examples of various search commands.

     Search Location

     The search location is normally a field in the database, but
     can also be a calculation. The search location always appears
     on the left side of a comparison. Enter field names without
     any punctuation, as follows:

          LASTNAME = "SMITH"

     However, you can enter just enough of the field name so that
     PC-File recognizes it as unique in the database. Thus

          LA = "SMITH"

     would be fine as long as no other field in the database begins
     with LA.

     You must enter a search location for each comparison within a
     command. For example, you cannot enter

          LASTNAME = "SMITH" | "JONES"
          **INCORRECT**

     You must enter a field name for each criteria separately, like
     this:

          LASTNAME = "SMITH" | LASTNAME = "JONES"      **CORRECT**


     A calculation used as a search location can be any valid
     numeric or date calculation. You can't use relational lookups.
     The following example illustrates a calculation involving two
     fields:

          (TOTALDUE - AMTPD) >= 500




     PC-File Version 7 Users Guide                            117



     In this calculation, the program searches for all records
     where the balance due is greater than or equal to $500.


     Comparison Operators

     Comparison operators determine the relationship between the
     search location and the search criteria. The six comparison
     operators are:

     Equal to                 =
     Not equal to             !=
     Greater than             >
     Less than                <
     Greater than or equal    <=
     Less than or equal to    <=

     The operator Equal to (=) means that the comparison is exact.
     The command

          LASTNAME = "SMITH"

     will not find SMYTH (unless you do a sounds-like search). It
     will only find SMITH.

     PC-File follows the ASCII table in determining the order of
     alphanumeric characters. Greater than refers to those
     characters with higher numbers on the ASCII table. Less than
     is the opposite. Case insensitivity changes the rules
     slightly, making SMITH also equal to Smith, rather than Less
     than (Uppercase letters are lower in the ASCII table than
     lowercase letters).

     The operators Not equal to (!=), Greater than or equal to
     (>=), and Less than or equal to (<=) should always be entered
     in the order shown. Do not place the equal sign first.

     Search Criteria

     The right side of each comparison is normally a constant, but
     can also be a calculation or a field. In a Formula search, the
     constant must be surrounded by special characters. The only
     exception occurs when you use a numeric value as a constant.
     In that case, quotation marks are optional.

     The characters differ depending on the method of entering
     search criteria, as follows:

     Generic Quotation marks       (")  "SMITH"

     Scan-across Tilde             (~)       ~MIT~

     Sounds-like Question mark     (?)  ?SMITH?




     PC-File Version 7 Users Guide                            118


     The wildcard character ( _ ) must be used only in combination
     with generic and scan-across searches. You can't use wildcards
     with sounds- like searches.

     Logical Operators

     Use logical operators to link multiple comparisons. Use the
     ampersand (&) for AND and the pipe (|) for OR. On most
     keyboards, the pipe appears on the same key as the backslash.
     It is not a colon. PC-File does not recognize the words OR and
     AND as logical operators, so be sure to use the symbols
     instead.

     The operator AND means that both comparisons must be met to
     satisfy the search criteria. The operator OR means that either
     can be met. Normally OR is used when you are linking
     comparisons for the same field and AND is used when linking
     comparisons from different fields. Thus, in the search command

          STATE = "WA" | STATE = "CA"

     you must use the operator OR because both abbreviations do not
     appear in one record.

     Parentheses

     Parentheses are used to group comparisons logically. In many
     search commands, they are necessary to make the command work
     properly. Without them you would retrieve a different group of
     records.

     In most cases, a command that includes both logical operators
     requires parentheses to make the command work properly. For
     example, the command

          CITY = "SEATTLE" & (NAME = "JONES" | NAME =  "SMITH")

     would produce a different result without the parentheses. As
     it is, the search retrieves all records in which the city is
     SEATTLE and the name is either JONES or SMITH. Remove the
     parentheses and the command retrieves all records in which the
     city is SEATTLE and the name is JONES, plus those records for
     which the name is SMITH, no matter what the city.

     The reason it works this way is that PC-File reads commands
     from left to right. However, it disregards the previous
     logical operator when it encounters a new logical operator,
     unless it also encounters parentheses. Parentheses force the
     program to consider the information within the parentheses as
     a unit. Thus, with the parentheses in place in the above
     example, there are two main parts to the search command, which
     it considers together. Without the parentheses, PC-File
     disregards the AND when
     it gets to the OR, and treats it separately.




     PC-File Version 7 Users Guide                            119


     You normally don't need parentheses when you only use OR or
     only use AND in the command. For example, in the command

          STATE = "WA" | STATE = "CA" | STATE = "NY"

     parentheses are unnecessary. The same is true with the command

          NAME = "JONES" & STATE = "WA" & YEAR = "1985"

     However, in the search command

          STATE = "WA" & (NAME != ?SMITH? & NAME !=    ?JONES?)

     the parentheses make a difference in the records retrieved.

     Examples of Formula Search Commands

     A number of examples further illustrate the syntax used in
     Formula search commands. The examples are shown in uppercase
     letters, but uppercase letters are not required.

     Example #1

     The following example can also be performed as a Simple search
     by typing >150 into the AMOUNT field on the Simple search
     screen.

          AMOUNT > 150

     Example #2

     The following example can also be performed as a Simple search
     because an AND operation is assumed when using multiple search
     criteria in a Simple search. To perform this search as a
     Simple search, type <150 into the AMOUNT field and type
     >=03/15/91 into the DATE field.

          AMOUNT < 150 & DATE >= "03/15/91"

     Using the logical operator for AND requires that both criteria
     be met. As with the previous example, numeric values (150 in
     this case) don't require quotation marks. PC-File would find
     the same records if you did use quotation marks, though.

     Example #3

     In the following example, PC-File searches for all records
     between the two dates. This search cannot be performed as a
     Simple search because you cannot enter multiple criteria for
     one field.

          DATE > "03/15/91" & DATE < "03/31/91"

     Example #4




     PC-File Version 7 Users Guide                            120


     In the following example, PC-File searches for records with
     one or the other member number. The numbers are enclosed in
     quotation marks because Member_no is a character field, not a
     numeric field. This and all the following examples cannot be
     performed as Simple searches.

          MEMBER_NO = "001729" | MEMBER_NO = "096119"

     Example #5

     In the following example, PC-File searches for records with a
     specific date and either one or the other member number.

          DATE = "05/05/91" & (MEMBER_NO = "001729" |  MEMBER_NO =
     "096119")

     Example #6

     When using the comparison operator Not equal to (!=) with
     multiple criteria, you generally want to use AND (&) as a
     logical operator, rather than OR ( | ), as in the following
     example:

          DATE != "02/14/91" & DATE != "02/15/91"

     If you were to use OR, PC-File would search for dates not
     equal to 2/14/91, which includes 2/15/91, and dates not equal
     to 2/15/91, which includes 2/14/91. You must use AND to
     exclude both dates.

     Example #7

     Wildcards are especially useful when searching for dates. The
     following example illustrates this:

          DATE = "03/__/91" | DATE = "04/__/91"

     This command searches for all records with dates in the months
     of March and April.

     Example #8

     A global search looks everywhere for the search criteria
     except in memo fields. For memo fields, use a scan-across
     search, as follows:

          COMMENTS = ~cold~ | COMMENTS = ~icy~

     This command searches for the words cold and icy throughout
     the memo field.

     Conducting a Global Search




     PC-File Version 7 Users Guide                            121


     Global searches are similar to scan-across searches in that
     you can search for a word or part of a word. However, a global
     search looks through all fields (except memo fields) of all
     the records, while a scan-across search looks only in the
     designated field.

     When you conduct a Global search, enter the search criteria
     just as it appears in the records. PC-File treats the search
     criteria as a character string. Don't use quotation marks or
     other punctuation, unless that punctuation is part of the
     string you are searching for. You can't use wildcards either.
     If you enter an underscore character, PC-File searches for
     data containing an underscore.

     As long as case sensitivity remains turned off in your
     configuration profile, PC-File searches for both uppercase and
     lowercase variations on the criteria.

     You can't use multiple criteria, comparison operators, or
     logical operators in a Global search.

     To conduct a Global search:

     1.Choose Search from the menu bar.

     2.Choose Global search from the Search menu. PC-File prompts
       you for the search criteria.

     3.Enter the criteria in the text box.

     4.Choose OK. PC-File conducts the search and displays the
       first record that meets the criteria.

     5.Click on the Search Again button or press CTRL-A to display
       additional records that meet the search criteria.

     Because PC-File searches the data file in global searches, you
     must enter dates in the format they are maintained in this
     file: YYYYMMDD.

     Checking For Duplicate Records

     Duplicate records often appear in databases, particularly in
     mailing lists. PC-File makes it easy to find and display
     duplicate records, allowing you to delete them.

     There are two ways to process duplicate records:

       Display the duplicate records side by side, then choose to
       delete the record on the right, on the left, both, or
       neither of the records.

       Print a report listing all duplicate records, either on-
       screen, to a printer, or to a file. Then you can go back and
       consolidate data and delete duplicate records as necessary.




     PC-File Version 7 Users Guide                            122


     If you are the cautious type, you might want to run a report
     of your duplicate records before you start to compare and
     delete them on the screen. A report gives you time to check
     for address changes and other possible causes of duplicates
     that you might not catch if you go through the records quickly
     on the screen.

     How Duplicate Records Are Found

     Records are checked for duplication by comparing the data in
     one or more fields. You choose the fields from the database by
     which you want the data compared. You can choose up to 10
     fields. Be aware, though, that duplication exists only where
     two records are identical in all fields being compared. Thus,
     the more fields you select for comparison, the stiffer the
     comparison.

     PC-File ONLY compares adjacent records. For example, the data
     in the second record is compared to the data in the first and
     third records, but is NOT compared to the data in the fourth,
     fifth, or any other records. As the order of the records is
     based on the current index, it is important that your primary
     field of comparison (the first comparative field selected)
     coincides with your current index. If you are using last names
     as the primary comparison field, for example, a database
     indexed by
     zip codes will likely miss some if not all of the
     duplications.

     Displaying Duplicate Records

     Placing duplicate records side by side makes it easy to
     compare the fields in each record.

     The two records show two people with the same first and last
     name, but different addresses. This is in fact two separate
     people. You would not want to delete either record.

     To display duplicate records side by side:

     1.Choose Search from the menu bar.

     2.Choose Duplicate records from the Search menu.

     3.Choose one or more fields from the list box by which you
       want to compare records. The primary field of comparison
       should match your index. All other comparison fields are up
       to you. Select no more than 10. You can compare based on a
       portion of field by typing the notation for a partial field
       in the text box, e.g. ZIP,1,5 only compares the first 5
       characters of the ZIP field. See Chapter 1, "Selecting a
       Field or Partial Field" for more details.

     4.Choose OK when you finish selecting fields. A dialog box
       displays.




     PC-File Version 7 Users Guide                            123


     5.Choose Now when asked what course you want to take. The
       first pair of duplicates displays on the screen, along with
       a dialog box.

     6.Choose to delete the record on the left side of the screen,
       the record on the right side of the screen, both records, or
       neither record. The next pair of duplicates displays.

     7.Display each pair of duplicates and choose one of the
       options until you have gone through all the duplicate
       records. A box displays when you finish, informing you how
       many duplicate records were displayed and deleted.

     Printing a Report of Your Duplicate Records

     A printed report of your duplicate records can be handy for
     checking address changes, determining what causes duplication,
     and generally examining your duplicates before deleting any of
     them.

     PC-File prompts you to make several choices while defining a
     duplicates report, as follows:

     Print to the screen, a printer, or disk

     Print to the screen if you suspect just a few duplicates or
     want to check to see if there are any duplicates at all.

     Print to the default printer if you want a report you can
     study at length.

     Print to disk to produce a report that you can read with a
     word processing program or text editor. PC-File prints an
     ASCII file called databasename.DUP, located on the current
     directory. With a word processing program or text editor, you
     can conduct searches, which can be helpful if you have a lot
     of duplications. Use this option also if you have no printer
     currently available.

     Print all data or compared data

     You can print data from all the fields in the database for
     each duplicate record, or just the data in the fields you have
     chosen for comparison. If you feel you can compare duplicate
     records adequately with just the comparison data, just print
     compared data. Otherwise, you probably want to print all the
     data.

     If printing to a printer, you can also choose all the fields,
     then truncate those fields that don't fit within the width of
     the printer.

     Do you want to truncate?




     PC-File Version 7 Users Guide                            124


     If you are printing to the printer and the fields extend
     beyond the width of the printer, PC-File asks if you want to
     truncate the data. Choose Yes to print just the fields that
     fit. Choosing No results in data being printed off the edge of
     the paper, wrapping, or being truncated anyway. It depends on
     your printer.

     To print a duplicates report:

     1.Choose Search from the menu bar.

     2.Choose Duplicate records from the Search menu.

     3.Choose one or more fields from the list box by which you
       want to compare records. The primary field of comparison
       should match your index. All other comparison fields are up
       to you. Select no more than 10. You can enter a partial
       field for comparison by entering the field, starting
       position, and number of characters in the text box. See the
       section on choosing partial fields in Chapter 1, "Navigating
       in PC-File."


     4.Choose OK when you finish selecting fields. A dialog box
       displays.

     5.Choose List when asked what action you want to take.

     6.Choose to print the report to the screen, the printer, or to
       a file.

     7.Choose to print all data or just the data from the fields
       you have chosen for comparison.

     If you choose to print to the screen, the report displays on
     the screen. There is no way to stop and start the display if
     the duplicates run beyond a single screen.

     If you choose to print to a printer, the printing operation
     begins unless the fields being printed don't fit within the
     width of the printer. In that case, PC-File prompts you to
     truncate the fields to those that do fit.

     If you choose to print to a disk, PC-File prints a list of the
     duplicates to a file on the current directory named
     databasename.DUP.

     Modifying and Deleting Records

     The Read-only Mode option on the Edit menu must be off (not
     checked) to modify or delete records. This is true whether you
     are modifying or deleting individual records or making global
     changes or deletions.




     PC-File Version 7 Users Guide                            125


     As long as Read-only Mode is off, you can modify or delete a
     single record any time it is displayed on the screen. Global
     changes, on the other hand, can be made without displaying the
     individual records.

     In some cases, PC-File also lets you undo changes and restore
     deleted records.

     Read-only Mode

     Read-only mode permits the viewing of your data only. This
     option is provided because it is very easy to modify records
     otherwise. In Read- only mode you can navigate within records,
     but you cannot modify data. You can access the menu bar and
     the button bar; however all options on the Edit menu other
     than Read-only Mode are grayed out. Only the Edit menu is
     affected by Read-only mode. There are no limitations on other
     activities within PC-File, such as creating reports, printing
     graphs, and so
     on.

     Read-only mode is on when the Read-only Mode option is checked
     on the Edit menu.

     To toggle Read-only mode on and off:

     1.Choose Edit from the menu bar.

     2.Choose Read-only Mode.

     When a check mark is displayed to the left of the Read-only
     Mode menu option, Read-only Mode is on. When there is no check
     mark to the left, Read-only mode is off.

     Reading to and Writing from the Buffer

     PC-File provides a buffer that you can read to and write from
     at anytime. A buffer is a storage area that holds data in
     memory until it is needed. It is most useful for copying data
     from one spot and pasting it to another.

     You can use the buffer to hold data from fields in your
     records and from the edit window. The buffer is particularly
     useful when recording a recursive macro to make changes to a
     group of records. See Chapter 16, "Using Macros," for
     information on recursive macros.

     Only one block of data is held in the buffer at a time. If you
     read another block of data to the buffer, it replaces what was
     there before. The previous block of data is gone.

     You can use the following hot keys to read and write to the
     buffer.

          Hot key    Function




     PC-File Version 7 Users Guide                            126


          CTRL-INS   Read to the buffer

          SHIFT-DEL  Read to the buffer and delete

          SHIFT-INS  Write to the screen from the buffer


     To read to the buffer:

     1.Select the data you want to read to the buffer.

     2.Press CTRL-INS to copy the data to the buffer. If you want
       to copy the data to the buffer and delete it from its
       current location at the same time, press SHIFT-DEL instead.

     To write from the buffer:

     1.Place the cursor where you want the data to appear.

     2.Press SHIFT-INS to copy from the buffer to the screen.

     Data remains in the buffer only during the current session.
     When you exit from PC-File, the buffer is emptied.

     Modifying a Record

     Changes can be made to any record displayed on the screen, as
     long as you are in Modify mode. It doesn't matter whether you
     displayed the record by paging through your database or by
     conducting a search. Nor does it matter whether you are in
     Record view or Table view. If you can move the cursor to the
     fields in a record, you can change the record.

     To change a record, simply type in the correct information.
     You can type right over the previous entry, or erase the field
     first (by pressing CTRL-B) and then type in the correction.
     You can also use BACKSPACE and DEL to erase current data.


     Saving Your Changes

     Changes made to a record are saved automatically as soon as
     you leave the record. This is true whether you move to a new
     record or choose a menu option to begin a new action. Even if
     you choose Exit on the File menu, the change is saved.

     Automatic saving works in Table view just as it does in Record
     view. As soon as you move the cursor from one record to
     another, any changes made in the previous record are saved.

     Canceling a Change

     If you make changes to a record, then decide you don't like
     the changes, you can undo them. However, you can only undo
     them if you haven't saved the changes by moving to a new
     record.




     PC-File Version 7 Users Guide                            127



     To undo changes to a record:

     1.Choose Edit from the menu bar.

     2.Choose Cancel Changes from the Edit menu, or press CTRL-C or
       ESC. The record is restored to its state when it was last
       saved.

     Recalculating

     Press ALT-R or choose the Recalc button to rerun any
     calculations in your records for which data has changed. All
     the calculations in the current record, whether in a Record
     view or a Table view, are rerun.

     This button is most useful for relational lookups in which the
     data in the lookup database has changed, and for date
     calculations in which one or more dates have changed.

     The results of the recalculation display on your screen as
     soon as the calculation is finished, or when you save the
     record.

     Deleting a Record

     You can delete records in a Record view or a Table view.

     To delete a record in a Record view:

     1.Display the record on the screen.

     2.Choose Edit from the menu bar.

     3.Choose Delete from the Edit menu.

     4.Choose Yes when asked to confirm the deletion.

     The next record replaces the deleted record on the screen. If
     there is no next record, the previous record is shown.

     To delete a record in a Table view:

     1.Place the cursor anywhere within the record you want to
       delete.

     2.Choose Edit from the menu bar

     3.Choose Delete from the Edit menu.

     4.Choose Yes when asked to confirm the deletion. PC-File
       refreshes the screen, deleting the record in the process.




     PC-File Version 7 Users Guide                            128


     If you change your mind after you have deleted a record, you
     must use the Undelete option on the Edit menu. See the section
     below on undeleting records. The Cancel Changes option on the
     Edit menu restores only fields, not deleted records.

     NOTE: A record is not removed from the data file when it is
     deleted, it is only removed from view. For this reason, the
     record count that displays in the lower left corner of the
     screen stays the same after deleting records. For the same
     reason, deleting records does not reduce the size of the data
     file. You can pack the database to permanently remove all
     deleted records from the data file. See Chapter 13, "Packing a
     Database" for details on packing.

     Modifying Multiple Records

     You can modify all or a selected group of records in your
     database at one time, using the Global modify option on the
     Edit menu. For example, if the post office changes a
     particular zip code from 98007 to 98008, you can select all
     the records with the 98007 zip code and change them to 98008
     without displaying the records.

     Using Global modify to change a selected group of records
     assumes that there is some common denominator within the
     database that you can use as a criteria for selecting those
     records. The change in the zip code, for example, provides
     criteria by which you can search for specific records. A batch
     of address changes from your members, on the other hand, does
     not provide the criteria necessary to make a global change. In
     that case you would have to make changes individually.

     There are also some types of global changes that you can't
     make with the Global modify option, but that you can make with
     a recursive macro. Generally those changes involve variable
     length data and inserting data within other data. See Chapter
     16, "Using Macros," for information on what types of changes
     you can make with a recursive macro that you can't make with
     Global modify.

     You can only make changes in the open database.

     To make a global change:

     1.Choose Edit from the menu bar.

     2.Choose Global modify from the Edit menu.

     3.Choose All or Some from the dialog box that displays. Choose
       All to change ALL the records in the database. Choose Some
       if you want to make changes to a selected group of records.
       PC-File prompts you to conduct a search. See the section on
       searching earlier in this chapter.

     4.Enter the change or changes on the screen that displays.




     PC-File Version 7 Users Guide                            129


     5.Choose OK.

     6.PC-File displays the first record selected and asks if you
       want to make changes to the displayed record.

          Choose Yes to change the current record and display the
          next.

          Choose No to leave the displayed record as is, and
          display the next record.

          Choose All to make the prescribed changes to the current
          and all remaining records.

          Choose Quit to quit the operation.

     Use spaces to blank out characters in a change.

     Use wildcards to prevent changes to specific characters within
     a field you are changing. The wildcard character is the
     underscore ( _ ). Place it in a field you are changing to
     indicate you want no change at that particular spot. For
     example, if you are changing a nine-digit zip code field, but
     want no changes to the last four digits, use the underscore in
     the last four spots. Do not use blank spaces in those spots,
     as they will blank out that portion of the zip code in all
     records that are changed.

     Deleting Multiple Records

     If you want to delete all or a large group of records in your
     database, you may be able to use the Global delete option on
     the Edit menu. As with the Global modify option, you can only
     delete a selected group of records if there is a common
     denominator that allows you to select these records.

     You can only delete records in the open database.

     NOTE: A record is not removed from the data file when it is
     deleted, it is only removed from view. For this reason, the
     record count that displays in the lower left corner of the
     screen stays the same after deleting records. For the same
     reason, deleting records does not reduce the size of the data
     file. You can pack the database to permanently remove all
     deleted records from the data file. See Chapter 13, "Packing a
     Database" for details on packing.

     To delete multiple records:

     1.Choose Edit from the menu bar.

     2.Choose Global delete from the Edit menu.




     PC-File Version 7 Users Guide                            130


     3.Choose All or Some from the dialog box that displays. Choose
       All to delete ALL the records in the database. Choose Some
       to delete a selected group of records. PC-File prompts you
       to conduct a search. See the section on searching earlier in
       this chapter.

     4.PC-File displays the first selected record and asks if you
       want to delete it. Choose Yes to delete the record and
       display the next record. Choose No to leave it as is and
       display the next record. Choose All to delete it and all the
       remaining selected records as well. Choose Quit to quit the
       operation.

     Recovering Deleted Records

     You can restore records that you have deleted if you change
     your mind about them or find you have deleted them by mistake.
     This includes records deleted individually or through a global
     delete.

     The reason you can recover deleted records is that PC-File
     doesn't erase records when you delete them. Instead it just
     removes them from view.

     However, if you pack the database all deleted records are
     erased (see Chapter 13, "Packing a Database" for details on
     packing). Also, redefining the database writes a new copy of
     the data file which omits deleted records. Therefore, you
     cannot undelete records deleted before packing or redefining.

     To recover deleted records:

     1.Choose Edit from the menu bar.

     2.Choose Undelete records from the Edit menu. PC-File displays
       the deleted records that it finds one at a time. You can
       then choose which records you want to restore.




     PC-File Version 7 Users Guide                            131




     CHAPTER 8 SORTING AND INDEXING DATA

     PC-File uses indexes to sort data. Indexes are normally based
     on one or more fields in your database. However, they can also
     include dBASE and PC-File functions, as well as calculations.
     This chapter tells you how to create and use indexes.

     Rearranging Data

     Data in a database is always arranged in some order. It might
     only be the order that it was entered, but it does have an
     order. To be most useful for you, it should be arranged
     according to your needs.

     To print out mailing labels, for example, you might want the
     labels arranged in zip code order. To print out a phone list
     from the same database, however, sorting the records in
     alphabetical order by last name would be more useful.

     In PC-File, indexes are used to sort data. Indexes are
     normally based on fields, the data within the field is used
     for the sort. Thus, if you index on a zip code field, the data
     is arranged in the order of the zip code numbers. You can
     arrange indexes in either ascending or descending order.

     Indexes can also include functions (normally dBASE functions)
     and calculations. These are called Formula indexes.

     You can create several indexes for a database, allowing you to
     quickly rearrange the data in any order you want it. For
     example, you could arrange files in zip code order to print
     out a set of mailing labels, then quickly switch to
     alphabetical order by last name to print a membership list. If
     you're viewing your data in a Table view on the screen,
     switching indexes rearranges the data as you watch.

     You can also define indexes that sort on multiple fields. For
     example, you can create an index that sorts first on the last
     name field, then on the first name field. Thus, when you get
     to the Smiths, Andy would appear first, then Bob, then
     Charles.

     PC-File also lets you create one index for each database that
     is based on a selected group of records only. This is called a
     Subgroup index. You can redefine this index whenever the need
     arises.

     Along with sorting data, indexes speed up the process of
     searching for records. Conducting a search using an indexed
     field is a faster operation than conducting the search on a
     non-indexed field.

     Unindexed Order




     PC-File Version 7 Users Guide                            132


     Sometimes, you will find it advantageous to use no indexes.
     You can see the data in the order in which it was entered by
     using the Unindexed Order option. This option can be useful
     when you have small databases because you don't need to create
     additional files, and searches are still fast because there is
     little data.

     Indexing Operations

     When you create a database, you don't need to define an index.
     However, an index can be very useful because it displays your
     data in a particular order. One index may be all you need.
     However, it is likely that you will find a need for additional
     indexes, or that you need to modify a current index. When you
     do, choose Index Maintenance from the File menu. PC-File
     displays a dialog box.

     The command buttons are used to access each of the indexing
     operations. These operations are described briefly below.

     Make Index

     If you find a need for an index, it is easy to create one. You
     will find yourself creating indexes as the need arises. For
     example, you can decide what indexes you need as you create
     reports that require specific sorting options. When that
     occurs, choose this option from the dialog box to define the
     index.

     Make Subgroup

     Use this option when you want to work with a specific subset
     of records from the whole database. If you wanted to print all
     the records that have a specific zipcode, you would create a
     subgroup of only those records. Using this index, PC-File
     would only need to manipulate these records and not the whole
     database. When you have a large database and only need to work
     with one easily identifiable portion, this is a convenient way
     to do it.

     Delete Index

     If you find you have created indexes you don't use, delete
     them. Updating indexes when you add or modify data takes time,
     so keep only those you need. Select the index to delete, then
     choose this option from the dialog box.

     Rename Index

     If you want to change the name you gave an index, you can
     rename it. Renaming does not affect the DOS file name, only
     the description used to identify the index.

     Rebuild Index




     PC-File Version 7 Users Guide                            133


     If you suspect that you have a "bad" index, rebuild that
     index. A "bad" index usually results from some unforeseen
     trouble like a power outage while adding records. Use this
     option to rebuild only one index. In some cases, PC-File
     prompts you to rebuild an index when it encounters a problem
     with an index. See Chapter 13, "Repairing a Database" for more
     information.

     Rebuild All

     Use this option to rebuild all the indexes associated with a
     database. See Rebuild Indexes above for more information.

     Switching Indexes

     PC-File lets you switch indexes at almost any time. You may
     want to switch indexes prior to printing a report or while
     paging through a Table view of your records.

     NOTE: The current index is always listed on the status line at
     the bottom of the main screen.

     There are three ways to switch indexes in PC-File:

     Press CTRL-I

     Use this hot key to display a list of the indexes defined for
     the current database. Choose the index you want from the list.

     Use the menu

     Choose Index Switch from the File menu, then choose the
     appropriate index from the list.

     Let PC-File switch the index automatically

     PC-File lets you choose whether to automatically switch
     indexes when performing Simple and Formula searches. This is
     called autoswitching. When you conduct a search for records
     with autoswitching on, PC-File automatically switches indexes
     to the field you are searching on, if that field is indexed.
     This will generally make the search go faster. PC-File will
     also autoswitch to unindexed access if that is the most
     efficient way to perform the search. If the search field is
     not indexed, PC-File
     maintains the current index.

     If you want to prevent an automatic index switch, turn off the
     Autoswitch option from the Simple or Formula search screen.
     See Chapter 7, "Index Autoswitching" for more information on
     the Autoswitch feature.

     To switch indexes:

     1.Choose File from the menu bar.




     PC-File Version 7 Users Guide                            134


     2.Choose Index Switch from the File menu. As an alternative to
       steps 1 and 2, press CTRL-I. The Switch Index dialog box
       displays.

     3.Choose the index you want from the list. Data is arranged
       according to the new index.

     In PC-Label, the hot key CTRL-I doesn't function. To switch
     indexes, choose Define/modify setup from the PC-Label Main
     Menu. On the setup screen, choose Define Search to display a
     list of the current indexes. Choose the one you want. The list
     of indexes only displays if you have more than one index
     defined in the database.


     Index Maintenance Operations

     Indexes are very helpful in managing your data, and generally,
     you will employ indexes at one time or another. You create and
     maintain indexes using the Index Maintenance option on the
     File menu which displays a dialog box.

     When you create an index, you designate which field or fields
     take precedence in sorting the data. For example, in a list of
     names and addresses, you could sort the data by first names,
     by last names, by addresses, cities, and so on. Obviously,
     some fields make more sense for sorting than others. If you
     are creating mailing labels, you probably want to sort by zip
     codes. If you are creating a phone list, sorting by last name
     is more logical, or, if it's a short list, perhaps by first
     name.

     In a database, you can determine what fields to sort by as the
     need arises. If you have created a database to print mailing
     labels, then decide later to use the same list to keep track
     of membership renewals, you can add an index based on the
     renewal date.



     Choosing the Type of Index

     To create a new index, choose Index Maintenance from the File
     menu, then choose Make Index from the dialog box. PC-File
     displays the following dialog box, prompting you to choose the
     type of index you want to create.

     Choose either the Simple index or Formula index option.

     A Simple index lets you sort data directly on the contents of
     one or more fields. You can:

       Sort on up to 10 fields, each one sorting within the
       previous field

       Order each field in ascending or descending order




     PC-File Version 7 Users Guide                            135



       Sort on partial fields

     Simple indexes should handle most of your indexing needs.
     However, there are some kinds of indexes you can't define with
     the Simple index option. For those you need to create a
     Formula index.

     A Formula index allows for a wider range of index definitions
     by letting you define an index in the form of an expression.
     With an expression, you can enter dBASE and PC-File functions.
     Functions allow you to:

       Enter a calculation as part of an index

       Define an index based on the record number

     Both Simple indexes and Formula indexes are explained in depth
     below.

     Defining a Simple Index

     A Simple index lets you sort data directly on the contents of
     one or more fields. For example, you can create an index based
     on a single zip code field. You can also create an index based
     on both a last name field and on a first name field. You can
     include up to 10 fields in an index.

     Each field you add in an index is nested, in a sense, within
     the previous field. Thus, in the above example, last names are
     sorted first, then first names are sorted within the last
     names. The Johnsons would appear before the Kelloggs, and
     within the list of Johnsons, Bob would appear before Kathleen
     and Kathleen before Vicki.

     Whether you index on a single field or multiple fields, each
     field is sorted in ascending or descending order. Ascending
     order sorts spaces first, then 0 to 9, then A to Z, and from
     earlier to later. Descending order runs in the opposite
     direction. The default is ascending order.

     For indexes with multiple fields, you select the order for
     each field individually. Thus, if you define an index sorted
     first on state, then on zip code, you could sort the state
     field in descending order and the zip code field in ascending
     order.

     You can also sort on partial fields, in both single and
     multiple field indexes. Thus, you could index first on a state
     field, then on just the first five characters of a 10-
     character zip code field.




     PC-File Version 7 Users Guide                            136


     NOTE: You can't sort memo fields. You can sort date fields,
     but you can't sort dates in character-type fields with a
     Simple index. If you try to sort dates in character fields,
     08/27/78 would sort after 03/27/91, as the date would be
     treated as a string and 08 comes after 03.

     To define a simple index:

     1.Choose File from the menu bar.

     2.Choose Index Maintenance from the File menu. The Index
       Maintenance dialog box displays.

     3.Choose Make Index. PC-File prompts you to choose the type of
       index.

     4.Choose Simple index. A field selection dialog box displays.

     5.Determine the sorting order for the primary field. Leave the
       default of Ascending, or choose the Descending option
       button.

     6.Choose the primary field you want to sort on. The field you
       select is checked and displays in the Selected list. The
       number 1 and the letter A (for ascending) or D (for
       descending) displays next to the field name. If you are
       indexing on just a single field, choose OK and skip the next
       two steps.

     7.If you are defining a multiple-field index, repeat the
       previous two steps for each field you add. First determine
       the order by choosing the appropriate option button, then
       choose the field. The second field you choose appears in the
       Selected list right below the first field with the
       appropriate letter, A or D, next to it; the third field
       appears below the first two with the appropriate letter next
       to it, and so on. You can choose a partial field instead of
       an entire field for any part of the index. To do so, enter
       the field name, starting position, and number of characters
       in the text box. See the section on choosing partial fields
       in Chapter 1, "Navigating in PC-File," for more information
       on this operation.

     8.Choose OK when you finish.

     9.Enter a description up to 30 characters long for the index
       when prompted or leave the default suggestion. A status box
       displays indicating the how the index building operation is
       proceeding. This may take a long time on large databases.
       Once the index is completely built, PC-File displays an
       information box indicating that the new index is now
       current.
     10.  Choose OK.

     11.  Choose OK to clear the information box.




     PC-File Version 7 Users Guide                            137


     Defining a Formula Index

     When you create a formula index, you enter an expression in a
     text box. With index expressions, you can enter dBASE and PC-
     File functions, as well as calculations.

     Functions are commands that perform a specific, predefined
     action. For example, the function UPPER converts all
     characters to uppercase. The function TOSTR converts all non-
     character field data to character strings.

     Index expressions range from basic to complex. The following
     illustrates a basic index expression:

     UPPER(Lastname)

     This expression defines a single field index for the field
     Lastname. The function UPPER converts all characters to
     uppercase. That forces the field to sort without concern for
     case sensitivity. It also assumes that case sensitivity
     remains turned off in your configuration profile.

     It is unlikely you would define this index with the Formula
     option, as you could create the same index more quickly with
     the Simple index option. (The function UPPER is assumed in
     Simple indexes as long as case sensitivity is turned off.)

     A more complex index expression might look like this:

     SUBSTR(Part_no,4,2) + LEFT(Code,3) + TOSTR(Date)

     This expression defines an index based on three fields. Both
     the Part_no and Code fields are character fields. The SUBSTR
     function performs the same operation as defining a partial
     field in a Simple index. The LEFT function also lets you
     define a partial field, but the field always starts with the
     first character in the field. In the example above, it uses
     the first three characters of the Code field. The TOSTR
     function converts the date into a character string. This
     expression can also be accomplished with a Simple index.

     PC-File lets you pattern a new index after any other index
     within the current database. When you get ready to enter an
     index expression, choose the Pattern button instead. PC-File
     displays the list of indexes. Choose the one you want to use.
     PC-File enters the index expression in the text box. You can
     then edit it to fit your new index.

     To create a Formula index:

     1.Choose File from the menu bar.

     2.Choose Index Maintenance from the File menu. The Index
       Maintenance dialog box displays.




     PC-File Version 7 Users Guide                            138


     3.Choose Make Index. PC-File prompts you to choose the type of
       index.

     4.Choose Formula index. A text box displays.

     5.Enter an index expression in the text box. Choose the
       Pattern after button if there is another index expression
       after which you want to pattern the current index. Choose
       the appropriate index when prompted.

     6.Choose OK when you finish entering the index expression.

     7.Enter a description up to 30 characters long for the index
       when prompted or leave the default suggestion.

     8.Choose OK. A status box displays indicating the how the
       index building operation is proceeding. This may take a long
       time on large databases. Once the index is completely built,
       PC-File displays an information box indicating that the new
       index is now current.

     9.Choose OK to clear the information box.

     NOTE: As with Simple indexes, you can't use memo fields in
     Formula indexes.

     Guidelines for Formula Indexes

     There are a few guidelines you should keep in mind when
     creating Formula indexes:

       Use complete field names in index expressions.

       Expressions are limited to 100 characters.

       The data that results from the expression is also limited to
       100 characters. Thus, you could not sort on two 60-character
       fields together. Use partial fields for one or both of them.

       If you are mixing field types within an expression, convert
       all the fields to character strings, using the TOSTR or STR
       functions.

       Ensure that you use the same number of left and right
       parentheses in an expression.

       When you use the CALC function, enclose the calculation
       within quotation marks as well as within parentheses. For
       example: CALC("Amount + 3")

       Expressions are evaluated left to right and inside of
       parentheses first. For example, in the expression CALC("5 *
       (2 + 3)"), the addition of 2 + 3 takes place first, then the
       result is multiplied by 5. The result is 25. If the
       expression read CALC("(5 * 2) + 3"), 5 is multiplied by 2
       and the result is added to 3. The result is 13.




     PC-File Version 7 Users Guide                            139



     Formula Functions

     You can find a complete list of dBASE functions in a dBASE
     manual. The ones most often employed in indexing in PC-File
     are explained below. This list also contains four functions
     specific to PC-File.

     UPPER(field)

     Converts all characters to uppercase before performing the
     action. This makes the expression case insensitive. Use this
     expression only when you have case sensitivity for sorting
     turned OFF in your configuration profile.

     SUBSTR(field,starting position,length)

     Use this function to define a partial field for sorting.

     LEFT(field,length)

     This function also creates a partial field, in this case
     starting with the first character and running to the right the
     prescribed length.

     RIGHT(field,length)

     The opposite of the previous function. Creates a partial field
     starting with the last character and running to the left the
     prescribed number of characters.

     TOSTR(field)

     Converts the data in a numeric, date, or logical field to a
     character string so that it can be indexed. Indexes in
     ascending order. This function is specific to PC-File.

     STR(field,length,decimal)

     Converts numeric values to a character string for indexing.
     Specify the length and the number of places to the right of
     the decimal. Because you can specify the length with this
     function, it produces a much shorter result than the TOSTR
     function, and thus is recommended when converting numeric
     values.

     DESCEND(field)

     This function operates like the TOSTR function, in that it
     converts the data in a numeric, date, or logical field to a
     character string. However, it indexes in descending order.

     VAL(field)




     PC-File Version 7 Users Guide                            140


     The opposite of TOSTR in that it converts a character string
     to a numeric value. Use it for indexing numeric data in
     character-type fields when the data is of different lengths.

     RECNO( )

     Each record is assigned a record number within the data file
     based on the order it was entered. This function sorts the
     records in that order.

     IIF(condition, field1,field2)

     If condition is true, uses the data in field 1 as the index
     data. If condition is false, uses the data in field 2 instead.
     This function is most often used to sort data based on the
     second expression when the first expression comes up with a
     blank.

     SOUNDEX(field)

     Use this function to sort data that sounds alike. Thus, if
     used with a last name field, this function would sort names
     that are similar in sound together. For example, Smith and
     Smythe would sort together. This function is specific to PC-
     File.

     ROMAN(field)

     Converts roman numerals to numbers before sorting. Like the
     previous function, this function is specific to PC-File.

     CALC("calculation")

     Use this PC-File function for any calculation you want to use
     in an index. Use both quotation marks and parentheses around
     the calculation itself.

     Examples of Formula Indexes

     The following examples illustrate some Formula indexes.
     Several basic examples are illustrated first to show how to
     put an expression together.

     Multi-level Sorting

     You can define a multi-level index in either the Simple index
     option or the Formula index option. A Formula multi-level
     index expression looks like this:

     UPPER(Lastname + Firstname)

     The function UPPER converts all characters to uppercase,
     essentially causing the index to sort without sensitivity to
     case. The first field in the expression, Lastname, is the
     primary sort field. Thus, records are sorted first on the last
     name and then on the first name.




     PC-File Version 7 Users Guide                            141



     This expression is equivalent to a Simple index in which you
     selected the Lastname field as the first field and the
     Firstname field as the second field.

     You can also enter the expression in this way:

     UPPER(Lastname) + UPPER(Firstname)

     Since there is a limit of 100 characters for expressions, it
     is recommended that you use the first method above, which is
     shorter. If you are sorting on character fields, you may
     string as many of these expressions together as will fit in
     the 100-character window. For example, you could define this
     index:

     UPPER(Company+Dept_No+Manager+Employee+Acct_no)

     As with Simple indexes, you can sort to 10 levels in a Formula
     index.

     Indexing Multiple Non-Character Fields

     If you define a multiple field index, some or all of which are
     non- character fields, you must convert all the fields to
     character strings. The only exception to this rule is an index
     with all numeric fields in which you want to add the data
     together before indexing.

     Thus, if you index on a character field and a date field,
     convert the date field to a character string. The same rule
     applies if you combine a date field and a numeric field, or
     any other combination of field types.

     NOTE: You can't index on memo fields, no matter what you try
     to do to them.

     Use the function TOSTR to convert date and logical fields to
     character strings and the function STR to convert numeric
     fields to a character string. Several examples illustrate the
     use of these functions.

     If you indexed on the company name and the company number,
     your index expression might look like this:

     UPPER(Company) + STR(Comp_no,8,0)

     The STR function converts the numeric field Comp_no to a
     character string.

     The following index, used in the Donation database,
     illustrates the conversion of a date field to a character
     string:

     UPPER(Member_no) + TOSTR(Date)




     PC-File Version 7 Users Guide                            142


     In the case of date fields only, PC-File reorders the data
     internally so that it reads the date as year, month, and day.
     That way the date is sorted properly.

     If you index on two date fields, convert both of them to
     character strings:

     TOSTR(Duedate) + TOSTR(Duedate2)

     In most cases, you also want to convert the numeric fields in
     an index containing multiple fields to character strings. If
     you leave the data as numeric values, PC-File adds the data in
     each record before indexing it. That would result in a
     different index order than you would get if you converted the
     data to character strings.

     Indexing Character Fields Containing Numeric Data

     If you have a character field that contains numeric data, you
     may want to convert the character data to numeric values for
     sorting. This is necessary because character fields locate
     data flush left, which can cause problems if the values are of
     different length. The following example illustrates how a
     character field containing numeric values might sort: 1, 10,
     100, 2, 26.

     Changing these character strings to numeric values forces them
     to sort in the proper numeric order, as follows: 1, 2, 10, 26,
     100.

     Use the function VAL to convert character strings to numeric
     values. An index might look like this:

     VAL(MemberID)

     If the numeric data in a character field is all the same
     length, the conversion to numeric values is unnecessary.

     Sorting by Record Number

     When you add data to a database, PC-File derives an internal
     record number for each record. The first record is assigned
     number 1, the second record number 2, and so on. Within limits
     (see note below), you can sort your data in the order it was
     entered by sorting on the derived record number.

     Use the function RECNO to sort by record number. To sort on
     the record number alone, enter the expression RECNO( ) in the
     text box. Be sure to use the parentheses, but with nothing
     between them. If you combine the record number with other
     fields in an index, convert the record number to a character
     string, like this:

     UPPER(Lastname + STR(RECNO(),6,0)




     PC-File Version 7 Users Guide                            143


     NOTE: If you delete records, records added later replace the
     deleted records. The record numbers of the deleted records are
     assigned to the new records-in this case, RECNO will not give
     you an accurate representation of the order the data was
     entered.

     Increasing Speed on Large Databases with Duplicate Entries

     Adding, modifying, and searching for records in large
     databases with a large number of duplicate entries can slow
     PC-File down. This is because indexes are most efficient when
     PC-File is searching for unique entries. For example, suppose
     you have a large database indexed on Last_name and you have a
     1000 entries under the name Smith. If you search for the most
     recently added Smith record, PC- File has to search through
     the 999 previous entries before it can locate the record you
     want. You can make PC-File operate faster by defining a
     Formula index that adds the record number at the end of the
     Last_name index entry, like this:

     UPPER(Last_name + STR(RECNO(),6,0))

     You should consider using this type of index if more than 10
     records have the same duplicated index information. It is
     especially helpful if you have a large number of records where
     the indexed field is blank.

     Using a Calculation to Sort

     You can sort on a calculation. Normally, the calculation used
     in indexes involve arithmetic operations involving two or more
     numeric fields. For example, you can subtract the data in one
     field from another, and index on the balance. Or you can add
     the values in two or more fields together.

     You can use the PC-File function CALC to perform calculations,
     or you can perform them without a function. Use the CALC
     function if you want to abbreviate field names, as in the
     example below, and when performing date calculations. The CALC
     function is the only indexing function that allows you to
     abbreviate field names.

     For example, an index in the sample database called Attend
     looks like this:

     CALC("Pr + Y + A + Sn + Pa + C + Sp + Sc + O")

     This calculation adds the attendance figures for each category
     together and then sorts on the total. The field names are
     shortened to conserve space, but remain unique within the
     database.


     Creating a Subgroup Index




     PC-File Version 7 Users Guide                            144


     You can create one index within a database that sorts a
     selected group of records. This can be a time-saver when
     working with a large database.

     For example, you might want to send out a mailing to just
     those people who have been members for more than 40 years. If
     this group amounts to about 300 out of 20,000 members, you
     could create a separate zipcode index for just those 300
     members. Then, when you get ready to print mailing labels, PC-
     File doesn't have to search through your entire database to
     find and print labels for 300 records. For a large database,
     this can save a lot of time, even if you only print the labels
     once.

     You can have only one Subgroup index within any given database
     and it will always be named Subgroup Index. If you try to
     create another Subgroup index, PC-File will prompt you to
     delete your existing subgroup index before proceeding to
     create one.

     Subgroup indexes are designed to be used on a temporary basis.
     Create a new Subgroup index every time you find a need for
     using just a small part of a large database. You can use
     Subgroup indexes for reports, letters, labels, redefining
     databases, and graphs.

     A Subgroup index can be a Simple or Formula index. It is
     created much the same way as you have defined one of your
     other indexes.

     To create a Subgroup index:

     1.Choose File from the menu bar.

     2.Choose Index Maintenance from the File menu. The Index
       Maintenance dialog box displays.

     3.Choose Make Subgroup. If you already have a Subgroup Index,
       you will be prompted to delete it before moving onto the
       next step in the procedure. A dialog box displays prompting
       you to choose the type of index to define. You can select
       either type of index to create. Subgroup indexes can be
       either simple or formula indexes. See above, "Defining a
       Simple Index" or "Defining a Formula Index" for more
       information.

     4.Choose the kind of index you want to make and define the
       index as you would any other index. PC-File prompts you to
       choose the type of search.

     5.Choose Simple or Formula search. See Chapter 7, "Finding and
       Modifying Data," for more information on searches.

     6.Define the search criteria. PC-File performs the search and
       defines the index.




     PC-File Version 7 Users Guide                            145


     When you get ready to perform the operation that requires the
     Subgroup index, press CTRL-I to switch indexes. Choose the
     index labeled Subgroup Index from the list. This index remains
     current until you switch indexes again.

     Once a Subgroup index is defined, it remains available until
     you overwrite the file with a new Subgroup index for that
     database. However, all updated records within the database are
     added to this index, even if they wouldn't have been included
     initially. For example, if you defined the subgroup to include
     records where State = CA, all records added or modified in the
     database since you created the Subgroup index are added to it,
     no matter what the State. Thus, you need to recreate this
     index if
     you update the database.


     Renaming an Index

     You may find it necessary to rename an index. PC-File allows
     you to do this easily.

     To rename an index:

     1.Choose File from the menu bar.

     2.Choose Index Maintenance from the File menu. The Index
       Maintenance dialog box displays including a list of the
       available indexes.

     3.Select the index you want to rename from the Indexes list.

     4.Choose Rename Index. The Rename Index dialog box will
       display.

     5.Type in a new name up to 30 characters long.

     6.Choose OK.

     Modifying an Index Expression

     If you find that an index doesn't quite work the way you
     hoped, you can modify the index expression using the Formula
     option and try it again. To modify an expression, start by
     making a new index, then display a pattern of the one you want
     to edit. Make changes to expression, then build the new index.
     Then delete the original "problem" index as described in the
     "Deleting an Index" section later in this chapter.

     To modify an index expression:

     1.Choose File from the menu bar.

     2.Choose Index Maintenance from the File menu.

     3.Choose Make Index.




     PC-File Version 7 Users Guide                            146



     4.Choose Formula.

     5.Choose the Pattern after button.

     6.Choose the index you want to use as a pattern.

     7.Modify the expression.

     8.Choose OK.

     9.Enter a name for the index up to 30 characters long or
       accept the default.

     10.  Choose OK. PC-File builds the index.

     11.  Delete the old index as described in the "Deleting an
       Index" section later in this chapter.

     Rebuilding Indexes

     Sometimes indexes need to be rebuilt. Rebuilding an index
     recreates the index, though with the same definition, the same
     name, and the same file name. If you want to make changes to
     the index, you have to make a new index instead.

     PC-File allows you to rebuild just one index or all your
     indexes at once. The Index Maintenance dialog box provides
     both options. There are two ways to rebuild indexes:

       Choose "Rebuild Index" or "Rebuild All" from the Index
       Maintenance dialog box

       Choose "Rebuild the index" when PC-File prompts you to
       rebuild an index

     If you suspect a problem with an index, rebuilding the indexes
     in the database may solve the problem. For example, if your
     searches aren't working properly, try rebuilding the indexes.
     You may find that takes care of the problem.

     To rebuild one index:

     1.Choose File from the menu bar.

     2.Choose Index Maintenance from the File menu. The Index
       Maintenance dialog box displays including a list of the
       available indexes.

     3.Select the index to rebuild from the Indexes list.

     4.Choose Rebuild Index. PC-File rebuilds that index.

     To rebuild all indexes:

     1.Choose File from the menu bar.




     PC-File Version 7 Users Guide                            147



     2.Choose Index Maintenance from the File menu. The Index
       Maintenance dialog box displays.

     3.Choose Rebuild All.

     4.Choose OK.

     PC-File rebuilds all the indexes in the current database.

     NOTE: When you choose to rebuild all the indexes in the
     database, PC- File deletes the Subgroup index if there is one.
     You can't rebuild a Subgroup index; you have to remake it.

     Rebuilding "Bad" Indexes

     If PC-File detects a "bad" index, it displays a dialog box
     that lets you decide how you want to handle it.

     "Bad" indexes can result in a variety of circumstances. If a
     power outage occurred when adding records, your indexes may be
     corrupted. If this were to happen, you would rebuild all the
     indexes for the database that were in use at the time of the
     power interruption. See Chapter 13, "Repairing a Database" for
     more information.

     You can choose to Rebuild the index, delete the index, or
     ignore the warning.

     Ignoring the warning is the same as choosing Cancel.

     To rebuild an index when prompted:

     1.Choose Rebuild the Index when the Bad Index dialog box
       displays. PC-File rebuilds the index.

     Bad indexes can also result from a corrupted data or index
     file or from a damaged disk. You can try copying your files to
     another directory to see if that remedies the problem. You can
     also run the DOS CHKDSK /F command to check for damaged files.
     See your DOS manual for information on using this command. See
     Chapter 11, "Repairing a Database" for more details on how to
     address a corrupted database.

     WARNING: Exit from ALL programs and applications before
     running the CHKDSK /F command. Do not use the Drop to DOS
     option to run this command. If you are running Windows, exit
     from Windows and return to the DOS prompt before running the
     command. Otherwise, damage to the File Allocation Table on
     your hard disk can result.

     Deleting an Index




     PC-File Version 7 Users Guide                            148


     Too many indexed fields in a database slow down operations and
     take up space. Each time you add, modify, or delete data in a
     database, PC-File updates each index. This takes time. If you
     have indexes that you don't use for sorting or searching, get
     rid of them. You can always redefine them if you find a need
     for them in the future.

     When you delete an index, PC-File deletes the file for that
     index and removes any reference to the index in the header
     file.

     To delete an index:

     1.Choose File from the menu bar.

     2.Choose Index Maintenance from the File menu. The Index
       Maintenance dialog box displays including a list of the
       available indexes.

     3.Select the index you want to delete from the Indexes list.

     4.Choose Delete Index. The index is deleted from the database.

     NOTE: If you delete an index file with the DOS DELETE command,
     the reference to the index in the header file doesn't get
     deleted. As a result, PC-File warns you that the index may be
     damaged the next time you open the database.

     PC-File Index Files

     In previous versions of PC-File (PC-File:dB, PC-File 5.x, and
     PC-File 6.x), index files were saved to whatever name the user
     specified using .NDX extensions. This could sometimes cause
     problems because index files from different database could be
     accidentally overwritten.

     In this version of PC-File, all indexes for a database are
     saved to the same name as the database with an .NDn extention,
     where "n" is a digit 0-9. For example, if a database named
     CONTACTS has three indexes defined for it the indexes would be
     named: CONTACTS.ND0, CONTACTS.ND1, and CONTACTS.ND3.

     This naming convention applies to all indexes regardless of
     how they were defined.




     PC-File Version 7 Users Guide                            149




     CHAPTER 9 CREATING REPORTS

     Reports are one of the most important features of a database
     program. Reports let you rearrange your data for viewing or
     printing in a wide variety of formats. You can create mailing
     labels, phone lists, invoices, checks, inventories, and
     quarterly sales reports. This chapter tells you how to create
     a new report. See Chapter 11, "Printing Reports and Letters,"
     for information on printing a report.



     Introduction

     Use PC-File to create the report that fits your needs using a
     format that fits your experience.

     Fit your needs by creating any of a wide variety of report
     types, including mailing labels and phone lists, invoices,
     checks, inventory reports, and quarterly sales reports.

     Fit your experience by selecting the report-generating format
     that's right for you. PC-File provides five formats for your
     use, ranging from an easy single record per page format to a
     very flexible but also complex command statement format.

     When you create a report, you essentially create a report
     structure. The structure is saved to a separate file. The file
     carries the report name and the extension .REP.

     Choosing a Report Format

     PC-File provides five format options for defining a report:
     Page, Row, Mail label, Free form, and Language. If you are
     inexperienced in creating reports, consider using one of the
     first three options, as PC- File leads you through the
     operation each step of the way.

     More experienced users should select the format that serves
     their current needs. The simpler formats are generally faster,
     but not as flexible as the Free form and Language formats.
     However, you can define a report using any format, then go
     back and edit it with either the Free form or Language
     formats. Thus, you could lay out a report quickly with the Row
     format, for example, then edit the report to add whatever
     changes and features you want.

     The five report formats are explained briefly below. Choose
     the format that will help you produce the report you want.

     PAGE




     PC-File Version 7 Users Guide                            150


     Prints one record per page-similar to the format of a data
     entry screen designed with the Record view designer. All the
     fields in the database are used, and all or some records are
     printed. This is the quickest and easiest format.

     ROW

     Prints the data in columns, with the field names listed across
     the top of the screen. You can select and order the fields you
     want displayed. Automatically totals and subtotals numeric
     fields. Also lets you enter a title for the report.

     MAIL LABEL

     Defines simple mailing labels in a single column format. This
     format is also useful for defining snapshot labels. For multi-
     column mailing labels, use the mailing label program (PC-
     Label) described in Chapter 14.

     FREE FORM

     Lets you "paint" the report on the screen. You place titles,
     headings, and fields where you want them. This is the most
     visual format for creating a report, as you can see what your
     report will look like as you create it. Use this format when
     you want more flexibility of design than found in the first
     three formats.

     Along with giving you a lot more flexibility in the design of
     the report, the Free form format lets you subtotal and total
     numeric fields, add system fields, perform calculations, and
     add miscellaneous text and lines. You can also use Free form
     to edit a report, although complex reports are better edited
     using the Language format.

     LANGUAGE

     Gives you complete flexibility and control over your report.
     In addition to the operations permitted with the Free form
     format, the Language format allows you to use IF commands,
     perform calculations on subtotals and totals, use buckets to
     accumulate totals and hold string text, and use the
     conditional page command.

     The Language format lets you edit any report, no matter what
     format you produced it in. However, the Language format does
     require some knowledge of programming concepts.


     Using the Page Format

     The Page format provides the quickest and easiest method for
     creating a report. Each record is printed on a separate page,
     with the fields arranged just as they appear in one of your
     Record views.




     PC-File Version 7 Users Guide                            151


     All fields defined in the Record view you choose are used in
     the report. Reports stretch to as many pages as necessary for
     each record to accommodate all the fields.

     To create a report using Page format:

     1.Choose Print from the menu bar.

     2.Choose Reports from the Print menu.

     3.Choose New from the dialog box listing the operations.

     4.Choose Page from the dialog box listing the formats.

     5.A dialog displays to choose which Record view to pattern
       your page report on.

     6.Choose the view you want from the list.

     7.   Choose OK. PC-File creates the report while you wait.

     8.When prompted to save the report, choose Yes or No. Choose
       Yes if you want to save the report for future viewing or
       printing. Choose No if you want to print or view the report
       only once, and don't want to save it. PC-File displays the
       Print options dialog box. See Chapter 11 for information on
       printing reports.

     9.If you chose Yes in the previous step, enter a report
       description of up to 50 characters. Choose OK when you
       finish. The description is optional, but can be useful in
       reminding you of the contents of the report at some later
       date.

     10.  Enter a report name of up to eight characters. Choose OK.
       The Print options dialog box displays. See Chapter 11 for
       information on printing reports.

     Using the Row Format

     A report defined in the Row format lines up the data in
     columns across the page. This format lets you choose the
     fields to be printed and select their order of appearance. You
     can also enter a title for the report, either when creating
     the report or prior to printing.

     Limiting the number of fields allows you to create specialized
     reports within a database. For example, five of 12 fields were
     selected to create the report shown above. In the same
     database you could run out a phone list by selecting the name
     and phone number fields.




     PC-File Version 7 Users Guide                            152


     PC-File prints the fields side by side with one space between
     each field. If the report is printed to the screen and is
     wider than 79 characters, only the first 79 characters of each
     row are displayed. When sending the report to the printer, the
     width should not exceed what the printer can print on one
     line. Consider using condensed type if it does run over
     somewhat.

     All numeric fields used in a Row-formatted report generate
     subtotals and totals, which are printed in the appropriate
     places in the report.

     NOTE: To print Subtotals, you must also choose the Subtotals
     option in the Print options dialog box. See Chapter 11 for
     information about this operation.

     Only the display length of character and memo fields prints
     when you use the Row format. To print the entire field, you
     must edit the field using the Free form or Language format.
     See the section on using these formats later in this chapter
     for more information.

     To create a report using Row format:

     1.Choose Print from the menu bar.

     2.Choose Reports from the Print menu.

     3.Choose New from the dialog box listing the operations.

     4.Choose Row from the dialog box listing the formats. PC-File
       displays a check-off dialog box, listing the fields in your
       database.

     5.Choose the fields you want to appear on the report, in the
       order that you want them to appear.

     6.Choose OK when you are finished choosing all the fields to
       include in your row report.

     7.The Title dialog box displays.

     8.Enter a permanent title for the teport. If you leave this
       box blank, PC-File prompts you for a temporary title each
       time you print the report. A permanent title can be up to 65
       characters in length, while temporary titles can only be 35
       characters in length.

     9.When prompted to save the report, choose Yes or No. Choose
       Yes if you want to save the report for future viewing or
       printing. Choose No if you want to print or view the report
       only once, and don't want to save it. PC-File displays the
       Print options dialog box. See Chapter 11 for information on
       printing reports.




     PC-File Version 7 Users Guide                            153


     10.  If you chose Yes in the previous step, enter a report
       description of up to 50 characters. Choose OK when you
       finish. The description is optional, but can be useful in
       reminding you of the contents of the report at some later
       date.

     11.  Enter a report name of up to eight characters. Choose OK.
       The Print options dialog box displays. See Chapter 11 for
       information on printing reports.

     Using the Mail Label Format

     Use the Mail label format to define simple mailing labels to
     be printed in single column format. The mail label option is
     also used to create a format for snapshot labels. See Chapter
     15, "Tools" for information on snapshot labels.

     For more complex labels, such as labels in a side by side
     format, use the PC-Label utility, described in Chapter 14.

     When you create labels using this format, first determine the
     number of print lines per label. The print lines are the total
     number of lines from the top of one mailing label to the top
     of the next label. The print lines include both the lines on
     which the name and address are printed and the blank lines
     above or below the name and address. The common one-inch label
     has six lines, but your label stock may have a different
     number of lines. Font size can also determine the number of
     lines on your
     label.

     To create a report using Mail label format:

     1.Choose Print from the menu bar.

     2.Choose Reports from the Print menu.

     3.Choose New from the dialog box listing the operations.

     4.Choose Mail label from the dialog box listing the formats.

     5.Enter the number of print lines for each label. The default
       is 6.

     6.Choose OK.

     7.The dialog box to select the fields to print on the first
       line of the label displays.

     8.Select the fields that you want to print on the line in the
       order you want them printed across the line. For example, to
       print a first name field followed by a last name field:
       Select the field containing the first name first, then
       select the field containing the last name. Each field is
       numbered as you select it and it displays in the Selected
       list.




     PC-File Version 7 Users Guide                            154



     9.Choose OK when you are finished selecting all the fields for
       that line. If you want to leave the line blank, choose OK
       without selecting any fields.

     10.  Repeat steps 8 and 9 for each of the following lines. The
       numbering starts over for each line. Choose OK after
       selecting the fields for each line.

     11.  When prompted to save the report, choose Yes or No.
       Choose Yes if you want to save the labels for future viewing
       or printing. Choose No if you want to print or view the
       report only once, and don't want to save it. PC-File
       displays the Print options dialog box. See Chapter 11 for
       information on printing reports.

     12.  If you chose Yes in the previous step, enter a report
       description of up to 50 characters. Choose OK when you
       finish. The description is optional, but can be useful in
       reminding you of the contents of the report at some later
       date.

     13.  Enter a report name of up to eight characters. Choose OK.

     The Print options dialog box displays. See Chapter 11 for
     information on printing reports.

     Lines that have no data to print from a given record are
     removed automatically by PC-File. Thus, you can format the
     label for three line addresses, knowing that records with only
     two lines worth of data will print neatly.

     This format prints one space between fields which appear on
     the same line. If you want punctuation between fields, you can
     either include it in the field when you enter data or edit the
     report using the Free form or Language format.

     Using the Free Form Format

     The Free form format lets you create a report by painting it
     directly on the screen. Giving you much more flexibility than
     the Row, Page, and Label formats, the Free form format lets
     you enter title lines and headings, locate fields where you
     want, draw lines, and sum the data into subtotals and totals.

     While providing flexibility, Free form also makes creating a
     report relatively easy. You use a special edit window divided
     into six sections to create your report. This allows you to
     build the report piece-by-piece. You can format fields
     directly from the keyboard, or you can have PC-File enter
     fields for you. Report fields can pull data from database
     fields, system fields (like the computer's clock),
     calculations, and field totals.




     PC-File Version 7 Users Guide                            155


     You can also edit any existing report, no matter what format
     you used to create it. Thus, you can define a quick report
     with the Page format, then display the report in Free form and
     play around with it until you get exactly what you want.

     Procedures for Creating a Free Form Report

     This section briefly outlines the procedures for creating a
     new report using the Free form format. Each of the various
     features that go into making up a Free form report, such as
     text and fields, are covered in more depth later in this
     section.

     To create a Free form report:

     1.Choose Print from the menu bar.

     2.Choose Reports from the Print menu.

     3.Choose New from the dialog box listing the operations.

     4.Choose Free form from the dialog box listing the formats.
       The Free form edit window displays.

     5.Paint the report on the screen. Enter text, fields, and any
       lines or boxes within the appropriate sections. Choose OK
       when you finish.

     6.Choose Yes or No when prompted to save the report. Choose
       Yes if you want to save the report for future viewing or
       printing. Choose No if you want to print or view the report
       only once, and don't want to save it. PC-File displays the
       Print options dialog box. See Chapter 11 for information on
       printing reports.

     7.If you chose Yes in the previous step, enter a report
       description of up to 50 characters. Choose OK when you
       finish. The description is optional, but can be useful in
       reminding you of the contents of the report at some later
       date.

     8.Enter a report name of up to eight characters. Choose OK.

     The Print options dialog box displays. See Chapter 11 for
     information on printing reports.

     Procedures for Modifying a Report Using Free Form

     You can display any existing report in the Free form edit
     window. You can then make changes to it and add any features
     available in Free form. Thus, you might find it useful to
     create a report quickly with another format, such as Row, then
     add to the report structure as needed by modifying it in the
     Free form window.

     To modify a report in the Free form window:




     PC-File Version 7 Users Guide                            156



     1.Choose Print from the menu bar.

     2.Choose Reports from the Print menu.

     3.Choose Modify from the dialog box listing the operations.

     4.Choose Free form from the dialog box listing the edit
       formats. PC-File displays the Free form edit window.

     5.Choose File from edit window menu bar.

     6.Choose Open from the File menu.

     7.Choose the report you want to modify from the file selection
       dialog box. The report displays in the edit window, broken
       down appropriately between the different sections.

     8.Make your changes to the report.

     9.Choose Save from the File menu when you finish. If you want
       to save the modified report under a new name, choose Save As
       instead. The original report remains unchanged in that case.

     10.  Enter a new description or leave the default. The Print
       options dialog box displays. See Chapter 11 for information
       on printing reports.

     Free Form Guidelines

     Though the Free form edit window is divided into sections, it
     is the same edit window found elsewhere in PC-File.

     Follow these guidelines in using the edit window and creating
     a Free form report:

     Sections

     The edit window is divided into the six report sections. Each
     section will scroll up to 120 characters wide. There is no way
     to set a right margin to wrap lines-you must indicate the end
     of a line manually by pressing ENTER when you want to break to
     a new line. Enter only the information in each section that
     you intend. If you don't want to use a section, leave it
     blank. The end marker (<<) should appear in the first line of
     those sections you leave blank.

     You don't have to define the report in the order suggested by
     the sections. If fact, it may be easier to enter fields in the
     Detail section of the report before doing anything else. That
     can help you line up headings in the Heading section, and
     subtotals and totals in their respective sections.

     Formatting Commands




     PC-File Version 7 Users Guide                            157


     Use formatting commands to force a new page, compress out
     blank lines, or enter printer codes. The formatting commands
     are described in detail beginning on page 202. You can use any
     of the formatting commands that begin with a period, like .FF
     or .GROUP. Enter these commands on a separate line.

     Blank lines

     All blank lines are saved and printed as blank lines. Enter
     only those blank lines that you want.

     Lines

     You can use the hyphen or underscore characters to create
     lines on a report, or you can use ASCII characters to make
     lines and boxes. See the section on creating lines and boxes
     in Chapter 1, "Navigating in PC-File," for more information.
     Use lines in any section of a report format.

     Text

     Anything typed in the edit window other than form feeds or
     fields (indicated by field markers) is text. Text is printed
     on the report just as it is entered on the screen. Uppercase
     and lowercase letters are read as entered.

     The Free Form Window

     The Free form edit window is divided into six sections,
     representing the six parts of a Free form report.

     Navigating in Free Form

     This section explains how to move between and within the six
     sections of the Free form edit window, how to expand each
     section for easier use, and how to determine the current
     location of the cursor.

     To move between sections:

     1.Click on the appropriate section with the mouse. With the
       keyboard, use TAB and SHIFT-TAB to move between the
       sections. The active section of the window is shaded darker
       than the rest of the window.

     You can "paint" a report within each section in either of two
     views:

       A contracted view

       An expanded view




     PC-File Version 7 Users Guide                            158


     The contracted view is the view you see of each section when
     you first open the Free form edit window. You can enter text
     and fields in this view, but you can only see two or three
     lines of the section at a time. As you move from one line to
     another within a section, a new line scrolls into view.

     Expanding each section individually makes it easier to define
     and format that section, as well as to visualize what you are
     doing. However, the menus are unavailable when a section is
     expanded.

     To expand a section to a window:

     1.Place the cursor in the section you want to expand.

     2.Press CTRL-E. The section expands to a window.

     Paint your report in this format, then choose OK to return the
     section window to its original contracted size.

     If necessary, you can determine the current location of the
     cursor in the edit window, in either the contracted or
     expanded section windows. This can be handy for lining up
     fields with their respective column headings.

     To display the cursor location:

     1.Press CTRL-W. A dialog box displays, indicating the current
       row and column location of the cursor.

     2.Choose OK to return to the edit window.

     Report Sections

     A Free form report consists of up to six sections. These
     sections- Cover, Heading, Detail, Subtotal, Total, and
     Footing-each control a specific part of the report. Only those
     sections you define in your report are used when the report is
     printed.

     Cover

     This section is used to print text once at the beginning of a
     report. You can define a separate title page or print a title
     at the top of the first page of the report. Use a form feed
     (.FF) after the title to locate it on a separate title page.

     Heading

     The text in the Heading section is printed at the top of each
     page. Use this section to print titles, page numbers, column
     headings, and lines under the headings.

     Detail




     PC-File Version 7 Users Guide                            159


     This is the most important section, as it is here that the
     records from the database are printed. Everything in the
     Detail section is printed once for each record selected.
     Without a Detail section, data from individual records won't
     be printed.

     Subtotal

     The Subtotal section is only printed when a subtotal break is
     requested. The Subtotal section can be used to print text,
     subtotals of numeric fields, and blank lines.

     Total

     The Total section is printed at the end of a report after all
     of the records have been printed. Items that usually appear in
     the Total section include totals for numeric fields, the
     number of records printed, and any criteria used for selecting
     records.

     Footing

     This section is printed at the end of each page, and
     determines the bottom margin on each page. Information in the
     Footing section can include page numbers, blank lines, and
     text. The Footing section is required in any report that
     includes any section other than a Detail section, and with any
     report that needs a bottom margin on each page. The Footing
     section should contain at least one printed line (which can be
     blank).

     The Free Form Menus

     The menu bar at the top of the Free form window contains three
     options. Two of the options-File and Data-display pull-down
     menus when selected. The Help option displays a Help window.

     Using the File Menu

     Use the File menu to open and save reports.

     Option    Purpose

     New       Start a new report

     Open      Display an existing report

     Save As   Save the current report to a new name or 
          directory

     OK        Quit the Free form edit window; PC-File prompts you
     to save

     Cancel    Quit the Free form edit window




     PC-File Version 7 Users Guide                            160


     When you first display the Free form edit window for the
     purpose of creating a report, you don't need to choose New
     from the File menu. This option is designed to clear an
     existing report from the screen and provide you with an empty
     edit window for starting a new report.


     Using the Data Menu

     You can enter fields in your report from the keyboard or have
     PC-File enter them for you. Use the options on the Data menu
     to have PC-File enter the fields.

     Option              Purpose

     Field (trimmed)     Displays a field selection dialog box.
     Choose a field from the dialog box. Enters data with the
     spaces removed.

     Field (padded)      Displays a field selection dialog box.
     Choose a field from the dialog box. Enters data without the
     spaces removed.

     Field (bar code)    Displays a field selection dialog box,
     followed by bar code type and bar code height dialog boxes.
     Enters data formatted to print as bar code. See "Printing Bar
     Codes" later in this chapter for details.

     System field        Displays a list of system field options.
     Choose an option to enter system-generated data.

     Calculation         Displays a text box for entering a
     calculation. Data is generated by the calculation.

     Lookup (relational)      Displays relational lookup definition
     dialog boxes. See "Defining Relational Lookups" for details.


     Entering Text

     Use text in a Free form report for titles, field headings and
     labels, lines and boxes, and miscellaneous descriptions or
     information. To enter text, place the cursor where you want
     the text to begin and type the text from the keyboard. PC-File
     prints uppercase and lowercase letters just as they are
     entered.

     Be sure you enter text in the correct section of the report.
     If you want the title of the report to print at the beginning
     only, for example, enter it in the Cover section. If you want
     it printed on every page, place it in the Heading section.




     PC-File Version 7 Users Guide                            161


     Most if not all fields should have labels, headings, or a
     description associated with them on the report. In rare cases,
     data can stand alone without some kind of descriptive label
     next to it or above it. For example, the current date
     displayed at the top of a report normally doesn't need to be
     identified.

     If you build the report to display columns of data, use field
     headings above the data. Headings generally should be entered
     in the Heading section of a report. They are then printed on
     each page of the report, making it clear for readers to
     understand what the data is without having to refer back to
     the first page. The following report illustrates the use of
     field headings.

     Field headings are often enhanced by entering a single or
     double line beneath them. You can use the hyphen or equal sign
     for this purpose, though on most printers these produce broken
     lines. Use line characters from the ASCII table to create a
     solid line. See the section on creating lines and boxes in
     Chapter 1, "Navigating in PC-File," for more information on
     these characters.

     Locating Fields

     Fields are defined in a Free form report to pull data from one
     of four places:

       Database fields
       A calculation
       The system (such as the computer's clock)
       A summation of other fields

     You can locate fields in any of the six sections of a report,
     but there are limitations on the type of field you can locate
     in certain sections. These limitations are outlined below:

          Section: Valid Fields

          Cover: System fields

          Heading, Detail, and Footing: System fields, database
          fields, and calculated fields

          Subtotal and Total: System fields and summations of other
          fields




     PC-File Version 7 Users Guide                            162


     Fields are represented in the Free form edit window with the
     use of two marker characters: the "at" sign (@) or the "pound"
     sign (#). These markers appear on the Free Form edit window
     only. They don't show up when you print a report. These
     characters are automatically placed on the screen when
     choosing options from the Data menu. If you type field marker
     characters directly from the keyboard, which character you use
     determines whether the data you have formatted for this
     location prints as a padded field or a trimmed field.

     The at (@) sign is used to print your data as a padded field.
     A padded field includes extra spaces to "pad" the printed data
     to the number of marker characters on the Free form edit
     window. For example, if there are 10 at signs on the report
     structure screen, but the data printing for a given record at
     that location is only 5 characters long, PC-File will "print"
     5 extra spaces at the end of the data. Padded fields are
     generally used to line up data in columns when printing more
     than one field per line.

     The pound sign (#) is used to print your data as a trimmed
     field. A trimmed field removes any leading or trailing spaces
     in the data, but not internal spaces. This format is commonly
     used when combining first and last name fields, and city,
     state, and zipcode fields when printing addresses.

     You can use either marker character with data from any field
     type, system field, subtotal, total, or calculation. You
     cannot mix the two characters within one string of marker
     characters for one field.

     For most fields, you can use either of two methods for
     entering the field markers:

       Choose options from the Data menu

       Type the characters directly from the keyboard

     If you use the options on the Data menu, PC-File prompts you
     to define the data source as you place each item. This method
     is recommended, as most users find it less confusing. If you
     enter a field from the keyboard, PC-File prompts you to define
     the data source after you finish painting the entire report.
     Both methods are described below.

     Guidelines for Locating Fields

     Follow these guidelines when locating and defining your fields
     in a report:

     Spacing

     There must be at least one space between each field, and at
     least one space between a field and any text.

     Field length




     PC-File Version 7 Users Guide                            163



     The number of field markers you enter to designate a field on
     the screen determines the number of characters that can appear
     in the report. For example, @@@@@ or ##### prints a maximum of
     five characters. If you create a field in the report that is
     shorter than the field in the database, PC-File truncates data
     that is longer than the report field. The same is true for
     system fields, summations, and calculations, so be sure to
     make your fields long enough to hold the data you expect to
     fill them with. This is generally not an issue when using the
     Data menu to place report items, because the Data menu options
     will automatically place the same number of field markers as
     the field's display length.

     Wrapping fields

     The maximum number of field markers you can use in one field
     is 65. PC-File ignores all field markers after the 65th in a
     group. For memo fields or character fields longer than 65
     characters, you can choose to print only the first 65
     characters of the field, or you can use one of two methods to
     wrap the data to two or more lines.

     One method is to enter a single set of field markers on your
     Free form report, then edit the report using the Language
     format. Change the print mask for the field from @'s to a
     "word wrap mask," which allows the data to wrap to its full
     length. When using this method you only have one wrapping
     field per line and no field can print to the right of that
     field. See the section, "Character Masks" later in this
     chapter for more information.

     The other method is to enter as many sets of @'s as necessary
     to print all the data. Then define each set of field markers
     as successive partial fields. For example, for a 100-character
     field called Description, you might define two 50-character
     partial fields, like this:

     Description,1,50 Description,51,50

     The first 50 characters of data print in the first group of at
     signs and the second 50 characters print in the second group.

     Entering Fields from the Data Menu

     You can enter any kind of field from the Data menu other than
     a summation field. Summation fields must be entered from the
     keyboard, in either the Subtotal or Total sections of the
     report.

     Entering fields from the Data menu is a two step operation:

       Choose an option from the menu.

       Define the data source.




     PC-File Version 7 Users Guide                            164


     Which option you select determines how you define the data
     source. For padded and trimmed fields, you choose the field
     from the field selection dialog box. For calculations, enter
     the expression in the text box. For system fields, choose one
     of 10 system field options from a dialog box.

     Once you define the data source, PC-File determines the
     correct field marker and the field length. For calculations,
     you are prompted for a field length.

     To enter fields from the Data menu:

     1.Place the cursor where you want the field to start.

     2.Choose Data from the menu bar.

     3.Choose the appropriate option from the Data menu. The dialog
       box that displays depends on your choice of option.

     4.Define the data source by choosing an option from the dialog
       box or entering a calculation. PC-File enters the field
       markers in the report.

     You can lengthen or shorten a field entered from the menu if
     necessary. For example, if you have defined a field with a
     field length of 15 characters, but know that none of the data
     in that field is more than 12 characters in length, you can
     shorten the field when you locate it on your report
     accordingly.


     Entering Fields from the Keyboard

     You can enter a field yourself by typing it into the
     appropriate section in the edit window. Use the desired marker
     character and enter the correct number of characters to
     indicate the field length. For example, type @@@@@@@@ if you
     are printing an 8-character field as a padded field. You can
     enter any type of field from the keyboard.

     Fields entered from the keyboard are defined in a different
     manner than fields entered from the Data menu. Since you don't
     define the source of data for a field when you just type in a
     series of field markers, PC- File has to prompt you for the
     source. It does this after you have finished painting the
     entire report and choose to save it. A dialog box displays for
     each field that must be defined. A set of question marks
     replaces the field that PC-File is prompting you to define.
     Choose the type
     of data source first, such as System field, then the source
     itself.

     To enter a field from the keyboard:

     1.Place the cursor where you want the field to start.




     PC-File Version 7 Users Guide                            165


     2.Type the field information. Indicate length by the number of
       characters you enter. Choose the field marker based on how
       you intend to define the field.

     To define the source of data for fields entered from the
     keyboard:

     1.Paint the entire report in the Free form edit window.

     2.Choose Save from the Free form File menu. PC-File displays a
       dialog box prompting you to define the source of data for
       the first field that you entered from the keyboard.

     3.Choose the appropriate data source button. Depending on the
       button you chose, PC-File prompts you to choose a database
       field or a system field, or enter a calculation.

     4.Choose the appropriate option or enter a calculation.

     5.PC-File moves to the next undefined field and prompts you
       for a data source. Fields that you defined using the Data
       menu options are skipped over, as PC-File already knows the
       data source.

     Defining the Fields

     How you define the field is determined by how you enter the
     field in the report. If you enter a field from the Data menu,
     you define the source of data for the field during the process
     of entering it on the screen. If you enter a field from the
     keyboard, PC-File prompts you to define the source of data for
     the field after you have painted your entire report in the
     edit window.

     No matter which method you use, however, you must define the
     source of data. This section describes each of the four source
     options:

       Data fields
       System fields
       Summations
       Calculations

     Data Fields

     If you enter fields from the Data menu, you can define either
     padded or trimmed fields. If you enter a field from the
     keyboard, it is assumed to be a padded field.

     A padded field retains blank spaces that occur in a field.
     Thus, if you define a report field as 15 characters long, 15
     characters print each time, even if some of them are blank.
     Use padded fields in reports when you want to maintain data in
     columns.




     PC-File Version 7 Users Guide                            166


     If you define a trimmed field, on the other hand, PC-File
     removes the trailing spaces, printing only the data within
     each field. Use trimmed fields for mailing labels, in
     particular, where you want the data within fields to flow
     together.

     For example, if you define the City, State, and Zip code
     fields as trimmed fields on an address label like this:

          ############, ## #####

     PC-File removes trailing spaces from the City field any time
     the city name is less than 12 characters in length. Thus, the
     report would produce an address like this:

          Seattle, WA 98103

     The State and Zip code fields adjust to the length of the data
     in the city field as it changes from record to record.

     System Fields

     System fields can be located in any section of the report. A
     system field pulls data directly from the computer, the
     program, the database, and even the operator. For example, you
     can use a system field to have PC-File enter the current date
     any time you print the report.

     There are 10 system fields supported in the Free form format,
     as follows:

     System field: Description

     Date now: The current date as determined by the computer's
     calendar.

     Time now: The current time as determined by the computer's
     clock.

     Page number: Displays the current page number, counting the
     first one as page 1.

     Records in database: The current number of records in the
     database.

     Selection criteria: Any criteria used to select records to be
     printed. For example, if you chose to just print reports with
     Washington addresses, the criteria might be STATE=WA.

     Index field: The index currently active when you print the
     report.

     Qty in Subtotal group: Number of records in the current
     subtotal.

     Field name of Subtotalgroup: The field you chose to subtotal.




     PC-File Version 7 Users Guide                            167



     Count of records printed: The total number of records printed.

     Operator input: PC-File prompts the user for input at this
     point.


     Summations

     If your report includes fields for which you want to show
     subtotals or totals, you must enter them in their respective
     section of the report. Subtotals are always defined in the
     Subtotal section and totals are always defined in the Total
     section.

     When you include a subtotal in a report, you define both the
     field you want to sum into subtotals and the field that
     determines the subtotal break. The subtotal break is the
     manner in which you group records that you want to subtotal.

     For example, you could subtotal sales volume by month or by
     department. In that case, sales would be the field you sum and
     month or department would be the break field.

     You define the field you want to sum when you define the field
     marker in the Subtotal section of your report. Enter a
     subtotal field marker from the keyboard only.

     The subtotal break field is defined later when you print the
     report using the Print Options dialog box. At that time, you
     indicate that you want to perform subtotals, then PC-File asks
     for the break field. See Chapter 11 for more information on
     this operation.

     If you include a total in a report, you just define which
     field to sum up. Totals only print at the end of a report.

     Calculations

     Calculations can be used in the Detail, Heading, and Footing
     sections of a report. You can use any type of calculation
     supported by PC-File. Calculations are described in Chapter
     17, "Calculations."

     However, you can't perform calculations on subtotals or totals
     using the Free form format. For example, you couldn't figure a
     commission based on a subtotal of sales. To do that, you would
     have to edit the report in Language format and add the
     commission calculation to the Subtotal section.

     Formatting and IF Commands




     PC-File Version 7 Users Guide                            168


     The Free form format supports most of the formatting commands
     described in the "Formatting Commands" section of the "Using
     the Language Format" section. Refer to the appropriate
     sections for details on how they work. The commands supported
     are:

     .FF
     .CP n
     .GROUP
     .EGROUP
     .EGROUP R
     .REFORMAT nn
     .ENDREFORMAT

     To use these commands in a Free form report enter each command
     on a line of it's own in the report section where you want it
     to take effect.

     The "Printer Markers" and the "Printer Control Codes" commands
     also documented in the "Formatting Commands" section of the
     "Using the Language Format" section cannot be used in Free
     form reports. However, you can edit a report originally
     formatted as a Free form report using the Language Format to
     insert these commands.

     You can also use the commands documented in the "IF Commands"
     section of the "Using the Language Format" section. Each IF
     command must be entered on a line of it's own in the report
     section you want affected.


     Using the Language Format

     As you create a report using one of the simpler formats (such
     as Row or Free form), PC-File translates it into written
     command statements. You don't see these command statements, as
     they remain below the surface of the report format, one level
     down. But it is these statements that PC- File reads when it
     prints a report.

     For example, when you enter a column heading with a line under
     it while painting a Free form report, PC-File translates that
     action into five command statements, as shown below.

     Free form

     Last name
     ========


     Commands

     =1
     "Last name"
     /1
     =1




     PC-File Version 7 Users Guide                            169


     "========"

     The first command statement indicates the column at which the
     heading starts, the second tells the program to print the
     heading, the third moves the printer down one line, the fourth
     indicates the column at which the line starts, and the last
     statement tells the program to draw the line.

     The command statements are, in a sense, the report language
     for PC- File. You can work with the command statements by
     choosing the Language format. You can either create a new
     report or edit an existing report, no matter what format was
     used to create it. In most cases, in fact, you will find it
     easier to create a report in another format, such as Row or
     Free form, then edit and customize it in the Language format.

     The advantage of the Language format is that it gives you the
     widest range of flexibility in PC-File. Among the features
     only available in Language format are:

       the ability to perform calculations upon subtotals, totals,
       and buckets

       the ability to use all formatting commands

       the ability to use printer markers and word wrap

     A report displayed in the Language format is a series of
     command statements, each on its own line. There are seven
     kinds of commands recognized in PC-File.


     Type of command     Description

     Section head        Specify the beginning of a 
               section

     Formatting          Define location of text and 
               fields, and set printer codes

     Text                Enter text, including titles, 
               column heads, and lines, in a 
          report

     Data field          Define which field to print

     System field        Pull information from the 
               computer, the database (other 
          than from a field), or from                       the
     operator

     Calculation         Perform a calculation or a 
               relational lookup

     IF                  Set conditions for performing 
               an operation




     PC-File Version 7 Users Guide                            170




     A command statement can also include print masks and buckets.
     Print masks are used to define how data is formatted when it
     prints. Buckets are used to hold data or text temporarily.

     Each type of command, along with print masks and buckets, is
     explained in detail later in this chapter.

     Procedures for Creating a Language Format Report

     To create a report using the Language format:

     1.Choose Print from the menu bar.

     2.Choose Reports from the Print menu.

     3.Choose New from the dialog box listing the operations.

     4.Choose Language from the dialog box listing the formats. The
       edit window displays.

     5.Create the report by entering the command statements in the
       edit window.

     6.Choose OK when you finish.

     7.When prompted to save the report, choose Yes or No. Choose
       Yes if you want to save the report for future viewing or
       printing. Choose No if you want to print or view the report
       only once, and don't want to save it. PC-File displays the
       Print options dialog box. See Chapter 11 for information on
       printing reports.

     8.If you chose Yes in the previous step, enter a report
       description of up to 50 characters. Choose OK when you
       finish. The description is optional, but can be useful in
       reminding you of the contents of the report at some later
       date.

     9.Enter a report name of up to eight characters. Choose OK.
       The Print options dialog box displays. See Chapter 11 for
       information on printing reports.


     Procedures for Modifying a Report With the Language Format

     To edit a report using the Language format:

     1.Choose Print from the menu bar.

     2.Choose Reports from the Print menu.

     3.Choose Modify from the dialog box listing the operations.




     PC-File Version 7 Users Guide                            171


     4.Choose Language from the dialog box listing the formats. The
       file selection dialog box displays.

     5.Choose the report you want to edit. The report appears in
       the edit window.

     6.Make your changes to the report.

     7.Choose OK when you finish.

     8.Give the report a new name if you want to keep the original
       report, or accept the original name to overwrite the report.

     9.Enter a description (optional).

     Basic Guidelines

     PC-File displays the edit window when you choose to create or
     edit a report using the Language format. However, you can use
     any word processor that can produce an ordinary ASCII file
     (also referred to as "DOS text" or "unformatted" files) to
     create or edit the report. Just be sure to store the report in
     a file using the .REP extension.

     Follow these simple rules when creating or editing a report
     using the Language format:

       Enter each command statement on a separate line.

       Use no more than one line and 80 characters for each command
       statement.

     As with the Free form format, use only the sections you need.

     Section Head Commands

     The Language format divides up a report into the same six
     sections found in the Free form format: Cover, Heading,
     Detail, Subtotal, Total, and Footing. Each section head begins
     with a colon and must be in all uppercase letters, like this:

     :DETAIL :TOTAL

     Sections can be ordered in any sequence. However, for clarity
     in reading a report definition, it is easier to keep the
     sections in the basic order that the report follows. For more
     information on the purpose and parameters of each section, see
     "Report Sections" in the section on Free form formats earlier
     in this chapter.

     Formatting Commands

     Use formatting commands to tell PC-File where and how to print
     text and fields. Formatting commands control line and
     character spacing, compress out blank lines, and insert
     printer control codes.




     PC-File Version 7 Users Guide                            172



     The following formatting commands are used in PC-File.

     Command        Description

     =nn            Horizontal tab (tab to column nn)

     /n             Line feed (insert n lines)

     .FF            Form feed (start new page)

     .CP n          Conditional page (start new page if 
          less than n lines left on page)

     .GROUP         Compress lines within grouping

     .EGROUP        End grouping

     .EGROUP R      End grouping, but replace lines at 
          end

     .x             Printer markers (where x is a print 
          enhancement or style, such as                     .BOLD)

     .A nn,nn       Printer control codes


     Formatting commands amount to over half the commands used in a
     report, as they dictate the placement of fields and text
     within the report.

     Each of the formatting commands are explained in more detail
     below.

     Horizontal Tab

     Use =nn to control the horizontal print location. The nn
     indicates the column that is tabbed to, not the number of
     spaces to insert before the next piece of data. For example,
     the command =40 would tab to column 40 and =73 would tab to
     column 73. To move the print head to the first column in the
     next line, use the line feed command instead.

     You can't tab backwards on a line. For example, you can't
     locate a field at column 73 on a line and then locate another
     field at column 40 on the same line. Commands must be issued
     with the idea that the print head will move from left to right
     on a line.

     The following sample shows two horizontal tabs.

     :DETAIL
     =25
     [SALUTATION]
     =29
     [FIRSTNAME]




     PC-File Version 7 Users Guide                            173



     Line Feed

     The /n command tells the printer to move down n number of
     lines. To skip down five lines you would use the command /5.
     Each section that doesn't end with a form feed (.FF) must end
     with a line feed.

     The following sample shows several line feeds.

     :DETAIL
     /1
     [FIRSTNAME]
     /1
     [LASTNAME]
     /2

     Form Feed

     The .FF command tells the printer to begin a new page, even if
     the current page is not full. The form feed is most useful for
     printing a cover page at the beginning of a report or for
     starting a new page after each subtotal break. DO NOT use the
     .FF command in the Heading or Footing sections. If you use .FF
     in the Cover, Detail, Subtotal, or Total sections, you must
     include a Footing section with at least one line feed (/1)
     command. If any data is printed in the section with a form
     feed, you
     must also have a line feed before the form feed.

     The following sample shows a form feed used to begin a new
     page.

     :DETAIL
     /1
     [FIRSTNAME]
     /1
     [LASTNAME]
     /2
     .FF


     Conditional Page

     Use the .CP n command to prevent several lines of data from
     being split between two pages. The .CP n command tells the
     printer to begin a new page, but only if there are less than n
     lines left on a page. The number of lines taken into account
     does not include any lines in headers or footers-if you are
     printing 66 lines per page, and you have a 3 line header and a
     3 line footer, the conditional page command will check for how
     many of the 60 "body" lines remain. For example, the command
     .CP 8 will prompt PC-File to check how many lines are left on
     the page. If there are less than eight lines left, the printer
     will skip to the next page.




     PC-File Version 7 Users Guide                            174


     The .CP n command is normally placed at the beginning of a
     section, but never at the end (as it would serve no purpose).
     Don't use the .CP n command in the Heading or Footing section.
     And don't use it to determine the bottom margin on the page.
     Use a Footing section with a line feed instead.

     The following sample shows a conditional page command.

     :DETAIL
     .CP 3
     /1
     [FIRSTNAME]
     /1
     [LASTNAME]
     /1

     Line Compression

     The .GROUP, .EGROUP, and .EGROUP R commands are used to
     compress lines, most often in address lists and mailing
     labels. Addresses are often formatted for four or five lines
     to accommodate those addresses that need them, but most
     addresses are only three or four lines long. Without the line
     compression commands, you could end up with mailing labels
     that look like this:

     Janet Ratite
     438 Savannah Way

     Seattle, WA 98103

     To remove blank lines from addresses, place the .GROUP command
     before and the .EGROUP command after the commands that locate
     your name and address fields. Use the .EGROUP R command
     instead of .EGROUP to place any blank lines removed from the
     middle of an address after the last data line in the group.
     This command is most used in mailing labels where you must
     maintain the same number of lines for each label.

     Here's an example of a typical label report using the .GROUP
     and .EGROUP R commands:

     :DETAIL
     .GROUP
     [NAME]
     /1
     [ADDRESS1]
     /1
     [ADDRESS2]
     /1
     <CITY>
     ", "
     <STATE>
     " "
     <ZIP>
     .EGROUP R




     PC-File Version 7 Users Guide                            175


     /3


     Every .GROUP command must be followed by either an .EGROUP or
     an .EGROUP R command.

     Reformatting Commands

     There are times where you need to reformat a section of a
     report to a particular width. For example, if you are printing
     several fields of varying length in the midst of a paragraph
     of constant text. Use the .REFORMAT nn (where nn is the width
     you want the following lines reformatted to) and .ENDREFORMAT
     commands to reformat the paragraph to the specified width.

     You use the .REFORMAT and .ENDREFORMAT commands like the
     .GROUP and .EGROUP commands-surround the Text and Field
     commands to be reformatted. Each command should be placed on a
     line by itself, and should start at the left edge. For
     example:

     .REFORMAT 55
     "If you have questions, call your local sales"
     "office at:
     "
     <PHONE>
     ". "
     "Your salesperson will answer any questions"
     "you have."
     /1
     .ENDREFORMAT

     This would reformat the paragraph to a width of 55. The
     resulting paragraph would look something like this:

     If you have any questions, call your local sales office at:
     555-1234. Your salesperson will answer any questions you have.

     Printer markers

     Use printer markers to change character formatting within the
     report. Printer markers are available for many of the standard
     print enhancements, such as bold, italics, and underlined
     type.

     The available printer markers are:

     .NORMAL
     .CONDENSED
     .BOLD
     .ITALIC
     .UNDERLINE
     .PORTRAIT
     .LANDSCAPE
     .PROPORTIONAL
     .DOUBLEWIDE




     PC-File Version 7 Users Guide                            176


     .USERn (where n is 1-5)

     Enter a printer marker where you want a change in the font or
     type to occur. Use the marker .NORMAL to return to the
     default.

     For example, if you want to make the title of a report
     boldface, it might look like this:

     :HEADING
     .BOLD
     "Current Member List"
     .NORMAL
     /1
     :DETAIL
     <LASTNAME>
     " "
     <FIRSTNAME> /1


     .USERn is a user-defined printer marker. You can define up to
     five of these markers in a configuration profile. See Chapter
     13, "Utilities" for information on defining these markers.

     Printer Control Codes

     To change character formatting in ways not defined with the
     printer markers listed above, use the ASCII (A nn,nn) command.
     The values following A represent the ASCII decimal value of
     the printer control code. For example, if you want to change
     the typeface for a particular section of a report, enter the
     ASCII command for that particular typeface. You can then use
     the printer marker .NORMAL to change back to the default
     typeface.

     You can also use the ASCII command to enter characters not
     available on the keyboard.

     Enter the command in the format

          .A nn,nn

     with a space between A and the printer code string. Follow
     each ASCII value with a comma, but no space. For example:

          .A 27,38,108,49,79

     You can use up to 67 characters in an ASCII command. If you
     need more than that, as some laser printer fonts do, divide
     the command into two or more commands.

     Text Commands




     PC-File Version 7 Users Guide                            177


     Use text commands to print text. Text includes titles,
     headings, lines, and miscellaneous text that appears in a
     report. Text is always surrounded by quotation marks in a text
     command statement, as shown in the following example:

     :HEADING
     "Current Member List"
     /1
     :DETAIL
     <LASTNAME>
     " "
     <LASTNAME>
     /1

     Enter text as you want it to appear in the report; that is,
     words you want to appear in uppercase letters, enter in
     uppercase.

     Database Field Commands

     Use database field commands to print data from fields in your
     database. Field commands are entered in either of two modes:

          [field]   padded field

          <field>   trimmed field (spaces removed)


     Use a padded field to line up fields in columns. This format
     is most often used in combination with horizontal tab
     commands. For example, the commands

     =4
     [City]
     =18
     [St]

     produce a report like this

          Miami              FL
          Tallahassee        FL

     Use a trimmed field to remove trailing spaces (and leading
     spaces, if they appear, but not internal spaces). This format
     is most often used when combining first and last name fields,
     city, state, and zipcode fields, and in similar situations.

     A text command, such as the addition of a space or comma, is
     often used with these commands. The commands

     =4
     <City>
     ", "
     <St>

     produce a report like this




     PC-File Version 7 Users Guide                            178



          Miami, FL
          Tallahassee, FL

     PC-File lets you designate a partial field with either mode as
     well, though this is most often used with square bracketed
     fields, as follows:

     =4
     [City,1,12]
     =17
     [St,1,2]

     Database field commands can be used with print masks and
     buckets, which are explained later in this chapter.

     System Field Commands

     Use system field commands to print data that is taken from the
     system in one form or another. System field commands include
     commands to print the current time or date as recorded by the
     computer, page numbers, and counts of records. The command to
     prompt the user to key in information is a system field
     command as well.

     System field commands available in the Language format are:

     Command        Description

     [DATE*]        System date

     [TIME*]        System time

     [PAGE*]        Current page number

     [SELECT*]      Selection criteria for the report

     [SORT*]        Current index-field index is 
          attached to, not index formula

     [COUNT*]       Number of records printed

     [RECORDS*]     Number of records in database

     [KEYIN*msg]    Prompt for operator input

     System field commands must be entered in uppercase letters,
     followed by an asterisk (*), and enclosed in brackets. Like
     data field commands, system field command statements can
     include print masks and buckets.

     PC-File also provides system field commands for handling data
     derived from subtotal operations. See "Subtotal Report
     Commands" later in this chapter for details.




     PC-File Version 7 Users Guide                            179


     Calculation Commands

     A calculation can use a database field, a system field, a
     constant, or a total bucket. You can use any PC-File-supported
     calculation in a report. A calculation must be surrounded by
     parentheses.

     When entering a calculation in a report, type field names as
     they appear in the database; do not use brackets. Constants
     must be surrounded by quotation marks. System fields and total
     buckets must be surrounded by square brackets. System fields
     must be entered in uppercase with an asterisk following the
     system field name. Relational calculations must be surrounded
     by parentheses.

     The following example illustrates the use of a calculation in
     a report.

     :DETAIL
     /1
     (DONATION * 12):zz,zzz.##:

     For more information on calculations, see Chapter 17,
     "Calculations."

     IF Commands

     Use the IF...ENDIF commands when you want PC-File to perform a
     task only when certain conditions are met. In most cases, this
     means that PC-File checks the data within a field or
     calculation, then performs the task if the data meets the
     condition(s) set within the IF command.

     IF commands follow a set format:

     .IF (a comparison calculation)
     Things to do if true (can be many commands long) .ELSE
     Things to do if not true (can be many commands    long)
     .ENDIF

     Every .IF statement must have a matching .ENDIF statement. The
     .ELSE statement is optional, however.

     You can't put an IF statement within another IF statement,
     which is known as "nesting" statements in programming
     languages. Use separate IF commands rather than nesting the IF
     commands. This doesn't mean you can't have many commands
     between the IF command and the ENDIF command-you can use as
     many commands as necessary within memory limitations.

     The following example selectively performs a calculation based
     on the contents of the Tax field, where the Tax field is used
     to indicate whether or not an item is taxable.

     .IF (Tax = " Y")
     " Amount of tax for this item is "




     PC-File Version 7 Users Guide                            180


     ([Amount]*.081):zz#.##:
     .ELSE
     " Not a taxable item"
     .ENDIF

     The IF statement calculates the tax when there is a Y in the
     Tax field and prints "Not a taxable item" when there is an N
     in the Tax field.

     IF commands are closely related to complex searches. All of
     the valid complex search operators work in IF commands,
     including scan-across, soundex, generic, and wildcard
     searches. The IF command can also include system fields, total
     buckets, and calculations in the IF condition. System fields
     and total buckets must be enclosed by square brackets.

     The following example of an IF command shows how to print
     address information using relational lookups once for each
     subtotal group. This example uses relational lookups to pull
     in the address information based on an account number present
     in both the Customer list database and the Order database.
     This report is run from within the Order database.

     :DETAIL
     .IF ([SUBCOUNT*] = 1)
     [Company]
     /1
     (@Acct_no,Customer,Cust_ID,Address)
     /1
     (@*,City)
     ", "
     (@*,State)
     " "
     (@*,Zipcode)
     /1
     .ENDIF


     Print Masks

     Use print masks to format a field or calculation. Print masks
     can be used to restrict the output to a certain length, add
     dollar signs or decimal places to numeric entries, or suppress
     leading zeroes.

     Print masks are not commands; instead, they are added to
     commands to indicate how the command should be printed. You
     can use them with database field commands, system field
     commands, and calculation commands.

     Print masks are always enclosed within colons, and follow the
     command itself, as the following examples illustrate:

     [Month]:@@@:




     PC-File Version 7 Users Guide                            181


          Only the first three characters of the field called Month
          are printed

     [Amount]:$$,$$$.##:

          Adds a dollar sign to a numeric figure

     Print masks are not mandatory for fields or calculations
     (except for date calculations), but are useful when you want
     to prescribe how the field will look in the report.

     There are three types of print masks:

          Character masks
          Numeric masks
          Empty masks

     The different types of masks are explained below.

     Character Masks

     There are two character masks:
          the :@@@: mask limits the number of characters that print
          in a field;
          the :Wnn: word wrap mask (where nn is a number) limits
          the width of the printed data to nn characters, wrapping
          any additional text from one line to the next.

     For :@@@: masks, the number of @ characters between the colons
     equals the width of the printed field. Thus, :@@: prints the
     first two characters in the field, and :@@@@@@: prints the
     first six characters. Any characters beyond the formatted
     width are not printed. For the word wrap mask, the number
     following the W determines the width at which the printed data
     will wrap. For example, :W6: prints no more than six
     characters wide, but will use as many lines as it takes to
     print all the data in the
     field.

     The following examples illustrate how character masks format
     data in a report:

     [Name]         Roosevelt

     [Name]:@@@@@:  Roose

     [Notes]:W6:    This
                    member
                    has no
                    phone.

     The word wrap mask doesn't split words. It is most useful with
     memo fields and scroll fields, but can be used with any field
     type, including numeric fields.




     PC-File Version 7 Users Guide                            182


     The :@@@: mask can be used with any field type, but they are
     most appropriate for fields that contain character data:
     character, date, and memo fields.

     Both kinds of character masks cause output to be left-aligned.

     Numeric Masks

     The pound sign (#) and the lowercase z represent digits and
     are used to format numeric fields. The only difference between
     the two masks is that the lowercase z suppresses leading
     zeros, the # doesn't. The following examples show how the two
     masks would treat the same data:

     [Amount]:##,###.##:      02,564.50

     [Amount]:zz,zzz.zz:       2,564.50

     If the value of a field was zero, the two masks would handle
     it as follows:

     [Amount]:##,###.##:      00,000.00

     [Amount]:zz,zzz.zz:

     Commas and decimal points should be placed where you want them
     to appear in the field. A leading comma will not print if
     there are no digits to the left of it, as shown in the
     following example:

     [Amount]:zz,zzz.##:      26.49

     The asterisk (*) and dollar sign ($) are used as floating
     characters in numeric fields, and are useful for check
     writing. Both suppress leading zeros, like the lowercase z.
     The $ prints a single dollar sign immediately to the left of
     the first non-zero digit, while the * prints as many asterisks
     as space allows. The following examples illustrate their use.

     [Amount]:$$,$$$.##:      $4.52

     [Amount]:**,***.##: *****4.52

     Any other characters placed in a numeric print mask will print
     as entered, as shown in the following examples:

     [Item]:zz-zz:       2-45

     [Serial_no]:TY######:    TY040090

     All numeric print masks cause the value to be right-aligned.

     Empty Masks




     PC-File Version 7 Users Guide                            183


     Empty masks are used in combination with buckets, which are
     explained in the next section. Essentially, an empty mask
     (also called a null mask) prevents the value in the field from
     being printed. Instead, the value is placed in the bucket,
     sort of a temporary holding bin. An empty mask looks like
     this:

     [Amount]::`Amt

     The value in the Amount field is added to the bucket `Amt. The
     empty mask, represented by the double colon (::), prevents the
     value from being printed.

     Buckets

     As the name implies, buckets are storage containers. In PC-
     File, they are used to store values temporarily. Temporary
     storage is useful in two ways:

     To accumulate numeric values (the total can then be printed in
     the report or used in a calculation)

     To hold text to be printed later Buckets used to accumulate
     numeric values are called total buckets; those used to hold
     text are called string buckets.

     Buckets are like print masks in that they are not commands
     themselves, but are used in command statements. Buckets can be
     used with text commands (string buckets only), database field
     commands, system field commands, and calculation commands.

     A bucket is designated by a name of one to five characters,
     using only letters (no numbers, spaces, or punctuation). You
     can use more than five characters, but any characters after
     the fifth character are ignored. Bucket names are case-
     sensitive; uppercase and lowercase names are different. Total
     bucket names are preceded by a backwards apostrophe (`);
     string bucket names are preceded by the backwards apostrophe
     and the dollar sign ($).

     Examples of valid total bucket names are:

     `a `Value `VALUE

     Valid string bucket names include:

     `$a `$Name `$TITLE

     Using Total Buckets

     As mentioned above, total buckets are used to accumulate
     numeric totals. There are two steps to using total buckets.




     PC-File Version 7 Users Guide                            184


     In the Detail section of the report, specify the field or
     calculation for which you want to accumulate totals. Subtotals
     and Totals for a particular field are accumulated in the same
     bucket.

     In the Subtotal and/or Total section of the report, print the
     bucket or use it in a calculation.

     To specify the field or calculation to be accumulated, simply
     place the bucket name at the end of the command line. For
     example, in this command statement

     [Commission]:: `Comm

     the data in the Commission field is accumulated in a bucket
     called Comm. The individual values are not printed as a result
     of the empty mask (::).

     In the command statement

     (Price*Quantity):zz,zzz.##:`Amt

     the result of the calculation is printed in the format
     zz,zzz.## and is also accumulated in the bucket called Amt for
     later use.

     To print the value in a bucket, enclose the bucket name in
     square brackets, just as you would a field name. Include a
     print mask to format the output. The buckets created in the
     earlier examples are printed like this:

     [`Comm]:$$$.##: [`Amt]:zz,zzz.##:

     You can also include bucket totals in calculations. The result
     of the calculation is then printed. A calculation that
     includes a bucket might look like this:

     ([`Amt]*[Tax]):$$,$$$.##:

     A total bucket can be used to keep a count. To keep a count,
     use the calculation

     (1)::`x

     This calculation adds 1 to the bucket called x each time it is
     encountered, thus accumulating a running count. The empty mask
     (::) keeps it from printing.

     To set a bucket to zero, use the command

     (0-[`Value])::`Value

     In this calculation, the value of the bucket called Value is
     subtracted from zero, resulting in a negative value. When the
     negative bucket value is added to the positive bucket value,
     the result is always zero.




     PC-File Version 7 Users Guide                            185



     Using String Buckets

     String buckets hold text in memory until you are ready to
     print it. Unlike total buckets, string buckets can't
     accumulate or append text. If you add another string of text
     to a bucket, it replaces the previous contents. However, you
     can have several different string buckets in memory at one
     time.

     To store text in a string bucket, include the string bucket
     name at the end of the command line. In the text command

     "Janet Ratite" `$Name

     the name Janet Ratite is stored in a bucket called Name.

     In the database field command

     [State]:@@:`$St

     each state name in the field called State is stored in a
     bucket called St. At the same time, it prints out in a two-
     character format as indicated by the mask.


     If you create a report using the Row format, and decide to
     enter the title of your report each time you print it, the
     command

     <KEYIN*TITLE LINE>::`$TITLE

     appears in the Cover section of the report if you print it out
     in Language format. This command prints the message TITLE LINE
     when you call up the report, then holds your response in a
     string bucket called TITLE.

     To print out the text string that is stored in a string
     bucket, enclose the bucket name in brackets, just as you would
     a field. For example, in the last example above, the title is
     printed with the following command:

     [`$TITLE]

     String buckets can be used in any section of the report.


     Subtotal Report Commands




     PC-File Version 7 Users Guide                            186


     PC-File provides special system field commands to handle data
     derived from subtotal operations. While you would typically
     only use one subtotal level, PC-File allows up to nine levels
     of subtotal breaks. For example, you might want to print a
     report for a database tracking sales that breaks to print
     subtotals on three levels: Level 1 - Region, Level 2 - Branch,
     and Level 3 - Salesperson. Level 1 breaks are the largest,
     most general subtotal groupings, level 2 are groups break
     within level 1,
     level 3 groups break within level 2, and so on. Use subtotal
     report commands to print subtotal data, or to control what
     happens for each subtotal level.

     [SUBLEVEL*]

     Returns the level number of the subtotal break that caused the
     current :SUBTOTAL section to print. Level 1 is the first
     (outermost) subtotal level, level 9 is the last (innermost)
     level. This command is generally used in .IF statement
     conditions to control what happens for each break when
     performing multiple level subtotal breaks.

     [SUBCMD*n]

     Returns the subtotal trigger formula in dBASE format. For
     example: (MONTH(date)). Omit "n" to have PC-File return the
     formula for the current level, replace "n" with 1-9 to return
     the command for a particular level. For example, [SUBCMD*3]
     returns the trigger formula for subtotal level 3.

     [SUBCOUNT*n]

     Returns the number of records printed in a subtotal group.
     Omit "n" to return the current level's group, replace "n" with
     1-9 to return the number of records for that level's groups.
     For example, [SUBCOUNT*2] returns the number of records for
     the current level 2 group.

     [SUBFLD*n]

     Returns the subtotal trigger field name. Omit "n" to return
     the current level's trigger field, replace "n" with 1-9 to
     return the trigger field for that level. For example,
     [SUBFLD*5] returns the trigger field name for subtotal level
     5.

     [SUBID*n]

     Returns the data (either from the field or the result of the
     trigger formula) that triggered the subtotal break. Omit "n"
     to return the current level's trigger data, replace "n" with
     1-9 to return the trigger data for that level. For example,
     [SUBID*7] returns the current trigger data for subtotal level
     7.

     Subtotal Levels and Total Buckets




     PC-File Version 7 Users Guide                            187



     Individual total buckets hold the values from all subtotal
     levels at the same time. When you enter the bucket command in
     the :SUBTOTAL section of a report, for example:

     :SUBTOTAL [`AMT]:zzz,zz#.##: /1

     PC-File returns the value for the level that triggered the
     subtotal break. You can refer to a specific subtotal level by
     putting the appropriate level number immediately after the
     bucket name, for example: [`AMT3] returns the subtotal for
     subtotal level 3. Note that the "3" following "AMT" is NOT
     part of the bucket name, it is only used to force PC-File to
     return the bucket value for that level.

     If you are only choosing one subtotal break when printing your
     report, you do not need to use subtotal level numbers ("n" in
     the descriptions above). Also, even when performing multiple
     level subtotal breaks, you only need to use level numbers to
     force a subtotal system field to return data for that level.
     If you do not include level numbers, the current subtotal
     break level is assumed.

     With all the above commands, you can also refer to level 0,
     which is the level that is never reset, that is, the grand
     total level. For example, using [`AMT0] in the :SUBTOTAL
     section would print the running total.

     A typical :SUBTOTAL section for multiple level breaks uses .IF
     statements to determine what action to take for each subtotal
     level. For example, a three-level report might print total
     buckets for levels 2 and 3, printing an extra blank line after
     level 2 breaks, and feed to a new page for level 1 breaks:

     :SUBTOTAL
     .IF ([SUBLEVEL*] > 1)
     "Totals: "
     [`AMT]:zzz,zz#.##:
     /1
     .ENDIF
     .IF ([SUBLEVEL*] = 2)
     /1
     .ENDIF
     .IF ([SUBLEVEL*] = 1)
     .FORMFEED
     .ENDIF



     Printing Bar Codes




     PC-File Version 7 Users Guide                            188


     PC-File can print a large variety of bar codes on most dot-
     matrix and laser printers-without requiring special drivers or
     font cartridges. For example, you can use PC-File to print
     zipcode bar codes (Postnet) directly on envelopes, postcards
     or labels. You can also use this feature to print price tags,
     inventory control labels, and inventory control sheets in UPC
     and many other bar code formats.

     Printers Supported

     PC-File's bar code printing supports the following printers
     (and should work on any printer that fully emulates any of
     these printers):

          PostScript
          Epson 9 pin
          Epson 24 pin
          IBM Proprinter 9 pin
          IBM Proprinter 24 pin
          HP LaserJet
          HP DeskJet
          Toshiba 24 pin
          Okidata Microline Standard

     NOTE: You must use Configuration on the Utilities menu to
     choose the type of printer you are using before formatting
     reports to print bar codes. See "Configuring Your Database" in
     Chapter 13 for details.

     Also note that bar codes will only appear in printed output or
     as graphic commands when printing to a disk file. Bar codes
     will NOT display when choosing Display on the Print Options
     dialog box. The bar code graphics commands when printing to a
     disk file are specifically for the printer you choose when
     configuring your database.


     Available Bar Code Formats

     PC-File supports the following bar code types:

     UPC-A

     The standard bar code for items for sale to the public, UPC-A
     is the bar code used at grocery stores. The standard UPC-A
     code contains 1 system digit, 5 digits for the manufacturer
     number, and 5 digits for the product number. PC-File's bar
     code output also supports 2 or 5 supplemental digits that can
     follow the standard UPC-A code's 11 digits.

     UPC-E




     PC-File Version 7 Users Guide                            189


     A zero-suppressed and compressed version of the UPC code. The
     same number and kind of digits as UPC-A (including 2 and 5
     supplemental codes) can be encoded, but the code number must
     have at least 4 zeros. The possible number of different
     product numbers encoded varies from 5 to 1000 depending on the
     where the zeros are in the UPC code number.

     EAN/JAN-13

     An extended version of the UPC code containing digits to
     encode the country of origin. EAN/JAN-13 codes contain 2
     digits for the country code, 10 digits for the product
     information and a checksum number. Since the checksum number
     is generated, the standard EAN/JAN-13 input code number
     contains 12 characters. EAN/JAN-13 also supports 2 or 5 digit
     supplemental codes.

     EAN/JAN-8

     A shorter version of the EAN/JAN code composed of 2 country
     digits, 5 data digits, and a generated checksum number. Also
     supports 2 or 5 digit supplemental codes.

     3 of 9 (Code 39)

     Probably the most common bar code because it allows digits,
     letters and some punctuation to be bar coded. It is standard
     for many government bar code specifications. An input string
     of 2 to 30 characters is supported. All lowercase letters are
     converted to uppercase letters.

     Extended 3 of 9

     Supports every character in the standard ASCII 128 character
     set, including uppercase and lowercase letters and control
     codes. Supports codes from 2 to 30 characters in length.

     Interleaved 2 of 5

     A numeric-only bar code that supports numbers from 2 to 30
     digits.

     Code 128

     A very compact bar code that can encode the full ASCII 128
     character set. Supports codes from 2 to 30 characters in
     length.

     Codabar

     Encodes digits and the + - $ : / . symbols, often used to
     encode dollar figures and mathematical values. Supports codes
     from 2 to 30 characters long.

     ZIP + 4 Postnet




     PC-File Version 7 Users Guide                            190


     The special bar code to encode ZIP+4 codes for mailing
     addresses. Also supports 5 and 11 digit ZIP codes.

     MSI Plessey

     Used most often in grocery stores for shelf labels. A numeric-
     only code that supports codes from 2 to 15 characters in
     length.

     Code 93

     A compressed version of the 3 of 9 bar code.

     Extended 93

     A compressed version of the Extended 3 of 9 bar code.

     UCC-128

     19 digit fixed length numeric bar code used on shipping
     containers for items marked with UPC code.


     The following table summarizes the type and number of
     characters allowed for each bar code type:


          Bar Code Type Input Length Allowed Characters


          UPC-A 11,13, or 16 N

          UPC-E 11,13, or 16 N

          EAN/JAN-13 12, 14, or 17 N

          EAN/JAN-8 7, 9 or 12 N

          3 of 9 (Code 39) 2 to 30 N-U-P

          Extended 39 2 to 30 N-U-L-P-C

          Interleaved 2 of 5 2 to 30 N

          Code 128 2 to 30 N-U-L-P-C

          Codabar 2 to 30 N

          ZIP+4 Postnet 5, 9, or 11 N

          MSI Plessey 2 to 30 N

          Code 93 2 to 30 N-U-P

          Extended 93 2 to 30 N-U-L-P




     PC-File Version 7 Users Guide                            191


          UCC-128 19 N



     Allowed Characters:

          N-Numbers (0-9)
          U-Uppercase (A-Z)
          L-Lowercase (a-z)
          P-Punctuation
          C-Control Characters (ASCII values less than 32)



     Bar Code Printing Restrictions

     PC-File can only print one bar code per line. Additionally,
     nothing can be printed to the right on the same line as a bar
     code. Further, each of the bar code types supports specific
     data lengths and types of characters. See "Table of Bar Code
     Input Requirements" above for the input requirements of each
     type of bar code. Also note that bar codes will only appear in
     printed output or as graphic commands when printing to a disk
     file. Bar codes will NOT display when choosing Display on the
     Print
     Options dialog box.

     Type of Bar Code Dialog Box

     PC-File can produce 14 types of bar code output (see list and
     descriptions of available bar code types above). When using
     the Row, Mail Label, and Free Form formats, PC-File displays a
     dialog box for each field you've formatted to print as a bar
     code.

     The top line of the dialog box lists the name of the field
     that will print as a bar code. Type the corresponding letter,
     or click the mouse on the appropriate button to choose what
     type of bar code to print.

     Bar Code Height Dialog Box

     After you've chosen the type of bar code, PC-File displays the
     following dialog box to choose how high to print the bar code.

     Type the corresponding number or click the mouse on the
     appropriate button to select the height of your bar code
     output.

     NOTE: This dialog box does not appear when printing the ZIP+4
     Postnet bar code which can only print one height.




     PC-File Version 7 Users Guide                            192




     Printing Bar Codes with Row Format

     You can use a Row Format report to quickly produce reports in
     a one record per row format. Using the Row Format you can
     print bar codes for inventory control catalogs and the like.
     PC-File can only print one bar code per line with no other
     data or text printing to the right of the bar code. Therefore,
     you can only choose to print one field as a bar code with a
     Row Format report, and it must either be the only field you
     choose or the rightmost field you choose.

     First, you must choose any fields you want to print as text
     from the list box in the order you want to print them across
     the page. Then, to format the last (or only) field to print as
     a bar code, type the field's name followed by a comma and the
     letter "B" in the text box above the field selection list box
     (like FIELDNAME,B in the picture above), then press ENTER.

     For example, after you have made the menu selections to format
     a Row Report, the Field Selection dialog box is displayed.

     At this point, there should be a checkmark and a sequence
     number next to the left of each of the fields you have chosen.
     The field you chose to print as a bar code must be the last
     (or only) field in the sequence. If it is not, choose Reset
     and choose your fields again. Choose OK to continue with the
     report definition.

     After you choose OK, PC-File displays the bar code type
     selection box for the field you selected to print as a bar
     code. After choosing the bar code type, PC-File displays the
     bar code height selection box. The top border of both dialog
     boxes shows which field you are formatting to print as a bar
     code.

     To print bar code data using Row Format:

     1.Choose Reports from the Print menu.

     2.Choose New.

     3.Choose Row Format.

     4.Choose the fields you want to print as text:

          Click on the field name in the list box. Or...

          Highlight the field name in the list box and press ENTER.
          Or...

          Type the fieldname in the text box and press ENTER.

     5.Choose the field you want to print as a bar code:




     PC-File Version 7 Users Guide                            193


          Move the highlight to the text box above the field
          selection list box, if it isn't there already.

          Type the desired field's name exactly as it appears in
          the field selection list box, followed by a comma and the
          letter "B."

          Press ENTER.

       For example, to format a field named ZIPCODE for bar code
       printing, type: zipcode,b then press ENTER.

     6.Choose OK to continue.

     7.Choose the bar code type.

     8.Choose the bar code height. (The bar code height dialog box
       does not display when formatting ZIP+4 bar code).

     9.Type the report title and save the report, if desired.

     10.  Make selections on the Print Options dialog box. See
       Chapter 11, "The Print Options" for details).

     11.  Choose OK to print.

     See "Using the Row Format" earlier in this chapter for more
     information on printing using Row format.




     PC-File Version 7 Users Guide                            194



     Printing Bar Codes with Mailing Label Format

     PC-File now produces bar codes on labels. If you send mailings
     of 250- 500 pieces or more at a time, you may be able to save
     anywhere from 2o to over 5o per piece when using ZIP+4 bar
     coded addressing! (As of this printing-contact your local Post
     Office for up-to-date information on discounts and addressing
     standards). You can also use this feature to print labels with
     bar codes in other formats for applications such as inventory
     control tags and UPC price tags.

     Formatting labels to print bar codes with the Mail Label
     format works much like the procedure used with Row format. The
     same restrictions hold: You can print no more than one bar
     code per line, and if anything else is printing on that line,
     the bar code must be the last thing printing on the line. When
     selecting fields for each line of your label, type the field's
     name followed by a comma and the letter "B" to have that
     field's data print as a bar code. This triggers PC-File to
     display the bar code type and bar code size dialog boxes
     discussed at the beginning of this section. Note that the bar
     code definition dialog boxes do not display until you choose
     OK after choosing all fields for that line in the label.

     To print bar codes using the Mail Label report option:

     1.Choose Reports from the Print menu.

     2.Choose New.

     3.Choose Mail Label.

     4.Type the number of lines per label and choose OK.

     5.First, choose the fields (if any) you want to print as text
       on the first line of the label:


            Click on the field name in the list box. Or..

            Highlight the Field name in the list box and press
            ENTER. Or...

            Type the fieldname in the text box and press ENTER.

          Repeat for all fields to print as text on the first line.

     6.Only after choosing all fields to print as text, choose a
       field (if any) to print as a bar code on the first line:

          Move the highlight to the text box above the field
          selection list box, if it isn't there already.

          Type the desired field's name exactly as it appears in
          the field selection list box.




     PC-File Version 7 Users Guide                            195



          Type a comma followed by the letter "B."

          Press ENTER. For example, to format a field named ZIPCODE
          for bar code printing type: ZIPCODE,B then press ENTER.
          Remember: Do not choose any additional fields to print to
          the right of a bar code.

     7.Choose OK.

     8.If you have formatted a field to print as a bar code, the
       bar code type and height definition dialog boxes display as
       described above (height definition does not display for
       ZIP+4). Answer each box appropriately.

     9.Repeat steps 5-8 to define each line of the label.

     10.  Type a name and save the label format, if desired.

     11.  Make selections on the Print Options dialog box. See
       Chapter 11, "The Print Options," for details on the Print
       Options dialog box.

     12.  Choose OK to print.

     See "Using the Mailing Label Format" earlier in this chapter
     for more information on using the Mail Label format.




     PC-File Version 7 Users Guide                            196



     Printing Bar Codes with Free Form Format

     The Free Form format gives you more flexibility than either
     the Row or Mail Label formats. Use the Free Form format to
     print more complex labels, postcards, envelopes, catalogs,
     order forms, and other reports with bar codes. However, the
     same printing restrictions apply to all formats: only one bar
     code per line and nothing can print to the right of the bar
     code.

     A new menu option has been added to the Free Form report Data
     menu to let you to choose to print a field as a bar code. The
     Field (bar code) option lets you format a field to print as a
     bar code: First, place the cursor where you want the bar code
     to print in the appropriate report section (Heading, Detail,
     etc.). Then, pull down the Data menu and choose the Field (bar
     code) option. A field selection list box dialog appears to let
     you choose which field to print. After selecting the field to
     print, the Type of Bar Code dialog box is displayed, followed
     by the Bar Code Height dialog box.

     To print bar codes using the Free Form format:

     1.Choose Reports from the Print menu.

     2.Choose New.

     3.Choose Free Form.

     4.Move the cursor where you want to print the bar code, in the
       appropriate report section.

     5.Choose Field (bar code) from the Data menu.

     6.Choose the field from the list box.

     7.Choose the bar code type.

     8.Choose the bar code height. (The bar code height dialog box
       does not display when formatting ZIP+4 bar codes.) A row of
       @'s the length of the selected field appears in the location
       the bar code will print.

     9.Repeat steps 4-8 to print any    additional fields as a bar
       code. Remember not to print more than one bar code per line
       and do not print anything to the right of a bar code.

     10.  Format any additional fields as trimmed or padded text,
       system data, subtotals, or totals; typing any other text
       directly from the keyboard.

     11.  Choose OK from the File menu.

     12.  Choose Yes to if you want to save your report.




     PC-File Version 7 Users Guide                            197


     13.  Type a report description up to 50 characters, if you
       answered Yes in step 12.

     14.  Type a report name of up to 8 characters. Choose OK.

     15.  Make appropriate selections on the Print Options dialog
       box and choose OK to print your report. See "The Print
       Options" in Chapter 11 for more information on the Print
       Options dialog box.


     Printing Bar Codes with Language Format

     You can use the Language format to print fields or other data
     as a bar code by placing an appropriately formatted print mask
     after the data you want to print as a bar code. This includes
     printing calculations, relational lookups, string buckets,
     totals, subtotals, system fields, or formatted strings of
     text. The same printing restrictions apply as with other
     report formats: one bar code per line and no printing to the
     right of a bar code.

     The format of a bar code print mask is as follows:

     [Fieldname]:BAR*, Type, Height, ShowErrors:

     Or...

     (Calculation):BAR*, Type, Height, ShowErrors:

     Or...

     "String":BAR*, Type, Height, ShowErrors:

     Where "Fieldname" is a valid field name in the database you
     are printing from. "Fieldname" can also be a valid total
     bucket name, string bucket name, or system field name.

     Where "Calculation" is a valid PC-File calculation or
     relational lookup.

     Where "String" is any string of alphanumeric characters. Make
     sure that the number and kind of characters are supported by
     the bar code type you want to print.

     Replace "Type" with a number, 1 through 14, to print the
     desired bar code type. Refer to "Bar Code Type Numbers" below
     for the appropriate number.

     Replace "Height" with a number from 1 to 9 to print the bar
     code that many lines high. This setting is ignored for ZIP+4
     Postnet bar codes, which always print at a fixed height.




     PC-File Version 7 Users Guide                            198


     Replace "ShowErrors" with a 1 to cause PC-File to print error
     messages if it encounters problems when printing bar codes.
     (See Bar Code Errors for details). Replace "ShowErrors" with 0
     or omit to suppress printing of bar code error messages.

     Bar Code Type Numbers

     Bar Code Type Type Number

     UPC-A 1

     UPC-B 2

     EAN/JAN-13 3

     EAN/JAN-8 4

     3 of 9 (Code 39) 5

     Extended 3 of 9 6

     Interleaved 2 of 5 7

     Code 128 8

     Codabar 9

     ZIP+4 Postnet 10

     MSI Plessey 11

     Code 93 12

     Extended 93 13

     UCC-128 14



     For example, the line in a PC-File language report to print a
     field named ZIPCODE using the ZIP+4 Postnet bar code would
     look like this:

     [ZIPCODE]:BAR*,10,1:

     The number 10 following BAR* tells PC-File to use Postnet bar
     code. The number 1 to its right indicates 1 line high,
     although this number can be omitted for ZIP+4 Postnet bar code
     because Postnet only prints one height. Omitting anything to
     the right of the height number, suppresses the printing of
     error codes.

     Another example to print a field CODE using UPC-A bar code 3
     lines high and print error messages would look like this:

     [CODE]:BAR*,1,3,1:




     PC-File Version 7 Users Guide                            199



     The first number after BAR*, 1, indicates UPC-A bar code type,
     3 tells PC-File to print the bar code 3 lines high, the 1 at
     the end causes error messages to print if errors are
     encountered.

     To Print Bar Codes Using the Report Language Editor:

     1.Choose Reports from the Print menu.

     2.Choose New, if you are writing a report from scratch, or
       choose Modify, if you are editing a pre-existing report to
       print bar codes.

     3.Choose Language, if you chose New in step 2, or choose
       Language Editor, if you chose Modify in step 2, then choose
       the report to edit.

     4.Put a mask in the :BAR*, Type, Height, ShowErrors: format
       after any field or calculation you want to print as a bar
       code. Make sure only one bar code is printing per line, and
       that nothing prints to the right of a bar code.

     5.Choose OK and save the report.

     6.Answer Print Options dialog box appropriately. See "The
       Print Options" in Chapter 11 for more information on the
       Print Options dialog box.

     7.Choose OK to print.

     Refer to "Using the Language Format" earlier in this chapter
     for further details on using Language format.

     Bar Code Error Messages

     PC-File does not print bar code error messages for bar code
     reports set up with the Row, Mailing Label or Free Form
     formats. In this case, if PC-File encounters an error when
     printing any record, it will not print that record's bar code.
     You can use the Language Editor to modify bar code reports to
     print error messages, regardless of the method originally used
     to define them. To do this, insert a comma and a 1 at the end
     of the :*BAR: print mask. For example, if the line in your
     report format
     originally looks like this:

     [CODE]:BAR*,1,5:

     Inserting a comma and a 1 after the 5, like this:

     [CODE]:BAR*,1,5,1:

     causes PC-File to print error messages when it encounters
     them.




     PC-File Version 7 Users Guide                            200


     The error message prints directly on the page or label in the
     location where the bar code would have appeared had an error
     not occurred. The error message is printed in this format:

     BAR*x Error y

     where "x" is the Bar Code Type Number (see the table of bar
     code types above), and "y" is the Bar Code Error Number. The
     following table explains the significance of each error
     number.


     Bar Code Error Message Numbers

     Error Significance Number

     1 Wrong bar code type number in :BAR*:mask

     2 Length of input string is 0 or greater than 30

     3 Length of text is greater than 30

     4* Wrong printer number

     5 Trying to print beyond the 250th column position on the page

     6 Bar code height is greater than 20 (2") or less than 1

     7* Checksum is greater than 2

     8* Number of passes <1 or >5 on dot matrix printers

     9 Wrong number of characters, or characters not supported by
     bar code type



     Error message numbers in the table followed with an asterisk
     should not appear-PC-File does not allow you to control these
     functions. In nearly all cases, the only error you will see is
     "Error 9" which indicates that the data you are trying to
     print does not meet the requirements for the chosen bar code
     type. For example, you cannot encode Canadian Postal Codes
     using the Postnet bar code format which requires 5 or 10 digit
     zipcodes (no letters).




     PC-File Version 7 Users Guide                            201




     CHAPTER 10 WRITING LETTERS AND MERGING DATA

     PC-File's letter writing utility lets you combine word
     processing and data retrieval to create form letters. You can
     merge name and address information, as well as other data,
     easily and quickly. This chapter tells you how to do it. For
     information on printing letters, see Chapter 11, "Printing
     Reports and Letters."


     Overview

     Form letters combine text from the keyboard and data from a
     database. Thus, you can type up a basic letter, then merge in
     name and address information, as well as other data, and print
     out hundreds of "personal" letters. You can print out letters
     for all or a selected group of your records.

     PC-File uses the edit window for creating form letters. The
     edit window is a basic word processing utility that provides
     many of the same editing options available in other editors
     and word processors. See Chapter 1, "Navigating in PC-File,"
     for information on the editing tools usable in the edit
     window.

     You create a form letter just as you would a regular letter,
     except that you enter commands where you want to insert data
     from a database. When you print the letter, PC-File replaces
     the commands with the data from your records.

     Commands are also used to help format the letter. These
     commands let you determine spacing, enter special printing
     codes, and feed a new page through the printer at the right
     time.

     Text is typed into the letter just as it is with any word
     processing program. The commands can also be typed in, but
     must include special characters so that PC-File interprets
     them correctly. Or you can have PC-File enter the commands by
     choosing them from a menu.

     Writing a Letter

     Form letters include the text of the letter and the commands
     that merge data and control formatting. Combining text with
     these commands requires a bit of planning before you start.
     Decide what information you want to pull from a database and
     where you intend to place it in the letter. You may want to
     sketch out the letter on paper first.

     If you plan to use data from more than one database, decide
     which database provides the majority of the data. Create the
     letter with that database open. You can use relational lookups
     to pull in data from the secondary database.




     PC-File Version 7 Users Guide                            202



     Letter Writing Procedures

     The basic procedures involved in creating a form letter are
     outlined below. The specifics of entering mail merge commands
     are covered in detail later in this chapter.

     To create a letter:

     1.Open the primary database. The primary database is the
       database that will supply most or all of the data for your
       letter.

     2.Choose Print from the menu bar.

     3.Choose Letters from the Print menu. A dialog box displays.

     4.Choose New from the dialog box.

     5.Accept the column width of 70 characters, or enter a new
       width up to 120 characters. A width of 70 characters assumes
       a 3/4 inch margin on each side if you are using 8.5x11 paper
       and normal type. To increase the side margins, decrease the
       number of characters.

     6.Type your letter, including the appropriate mail merge
       commands, in the edit window. You can type in the mail merge
       commands yourself or, in most cases, choose the Insert
       button to have PC-File enter the commands.

     7.Choose OK when you finish.

     8.Choose Yes when prompted to save the letter.
       Choose No if you are sure you will only use it once.

     9.If you choose to save the letter, enter a name in the dialog
       box. You don't need to enter the extension, as PC-File adds
       it automatically.

     10.  Enter a description (optional).

     The Print Options dialog box appears. See Chapter 11,
     "Printing Reports and Letters," for information on printing a
     letter.

     Letter Writing Guidelines

     When you call up the letter writing utility to enter a new
     letter, the Edit Window appears.

     Use the edit window just as you would any other text editor or
     word processing program. Text wraps automatically from one
     line to the next as you type the letter.

     Follow these guidelines as you type your letter.




     PC-File Version 7 Users Guide                            203


     Top margin

     The letter writing utility does not provide for a top margin
     or header. You must determine the margin by inserting the
     appropriate number of lines at the start of the letter. For
     dot matrix and daisy wheel printers, drop down six lines for
     each inch of top margin required.

     Laser printers insert a three-line margin automatically, so
     you should insert blank lines at the top for whatever margin
     you want beyond three lines.

     Side margins

     Start your text in column 1. Don't try to increase your left
     margin by moving your text in from column one. Instead,
     determine your margins by increasing or decreasing the page
     width when prompted by PC-File. If your letter prints too far
     to the left or right on the paper, you can move the paper in
     some printers. You can also move the copy, to the right only,
     by increasing the number in the Left margin parameter in the
     Print Options dialog box.

     Bottom margin

     Place a form feed (.FF) at the bottom of the letter. The form
     feed kicks the letter out of the printer so that each letter
     starts on a new page. If your letter appears to be fairly
     long, determine the number of lines in the top margin and in
     the letter itself, then subtract them from the page length. In
     that way you can decide if you have enough room for a bottom
     margin or need to extend the letter to two pages.

     Multi-page letters

     If your form letter runs to more than one page, place a form
     feed (.FF) on the bottom of each page. The top margin of each
     page begins on the line immediately following the form feed
     for the previous page. You can include up to five pages in a
     letter. Be sure to include a form feed at the end of the final
     page.

     Determining Where You Are

     You can determine the current location of the cursor in the
     letter writing edit window (and in the Free form report edit
     window). This can be handy for lining up fields and
     determining how many lines you have used.

     To display the cursor location:

     Press CTRL-W. A dialog box displays, indicating the current
     row and column location of the cursor. Choose OK to return to
     the edit window.

     Spell Checking Your Letter




     PC-File Version 7 Users Guide                            204



     You can check the spelling in your letter at any time by
     choosing the Spell button on the bottom of the Letter editing
     window. See Chapter 15, "Spell Checking" for details on how to
     use the Spell Check dialog box.

     Adding Mail Merge Commands

     There are two ways to add mail merge commands to a letter:

       1. Type them in.

       2. Choose them from a dialog box.

     You can type the commands in yourself, following the
     formatting rules for entering the different types of commands
     correctly. These rules are described in the sections on the
     commands.

     An easier method is to use the Insert button. With this button
     you can have PC-File enter most of the available mail merge
     commands for you.

     Using the Insert Button

     Use the Insert button on the button bar to have PC-File enter
     merge commands for you. Choosing the button displays a list of
     commands, from which you can choose the one you want.

     To choose the Insert button, click on it or press ALT-I.

     To have PC-File enter a command:

       1. Place the cursor where you want to locate the merge
          command.

       2. Choose the Insert button from the bottom of the screen.
          PC-File remembers the location of the cursor in the edit
          window before you move it to choose the Insert button. A
          dialog box displays.

       3. Choose the appropriate option. For example, choose Data.
          Another dialog box displays.

       4. Choose a field from the dialog box. PC-File prints out
          the field name at the cursor location on the letter. The
          field name is formatted as a trimmed field.




     PC-File Version 7 Users Guide                            205


     Of the options in the insert dialog box, Data and Keyed data
     require additional information before they print a command to
     the screen. The Data option requires that you choose a field
     from the database. The Keyed data option displays a text box,
     allowing you to enter a prompt for the operator. The remaining
     options print commands directly to the screen. For the
     IF...ELSE...ENDIF command, you must enter the IF expression
     between the parentheses. You can erase the ELSE command if it
     isn't
     necessary.

     You can enter other commands in a letter from the keyboard
     that do not appear as options in the Insert dialog box.
     However, they are less often used than those offered. All of
     the commands are explained below.

     Command Guidelines

     Mail merge commands must be entered in a specific way in order
     for PC- File to recognize that they are commands and not text.
     If you use the Insert button, PC-File enters commands as they
     should appear. If you type the commands yourself, be sure to
     follow the rules described below.

     Start all mail merge commands with a period.

     Enter command words in uppercase letters. The exceptions are
     database field names, calculations, and any message included
     with a KEYIN command.

     Place all formatting and IF commands on a line by themselves,
     and begin these commands in the first column. Don't count the
     lines used by the commands as part of a letter. PC-File reads
     the commands, but eliminates the lines they occupy.

     Types of Commands

     Mail merge commands can be divided into five basic types:

     Type Function

          Data field commands Insert data from database fields

          System field commands Allow for user input and insert
          current date

          Formatting commands Determine the format and design of
          the letter

          Calculation commands Enter the results of a calculation

          IF commands Let you include or exclude text based on a
          comparison

     Each type of command is covered separately below.




     PC-File Version 7 Users Guide                            206


     Data Field Commands

     The most commonly used mail merge commands are the field
     commands. Field commands add data directly from fields in your
     database. For example, you would use a field command to enter
     first name, last name, address, city, state, and zip code from
     the respective fields in the database.

     Field commands can be entered in uppercase or lowercase
     letters. There are two formats:

     Trimmed field Padded field

     Trimmed Field

     Extra spaces are removed from the end of data when you
     designate a trimmed field. Thus, if the City field is 15
     characters in length, but the city is Seattle, only the seven
     characters in the city name are printed. The remaining eight
     spaces in the field are removed.

     This is the most commonly used format for letters, and is
     practically a must in addresses, where you want the data in
     the first name and last name fields, as well as the data in
     the city, state, and zip code fields, to flow together. If you
     use the Insert button to enter a field, it is formatted as a
     trimmed field.

     Trimmed fields are indicated with angle brackets around the
     field name. Thus, trimmed fields are entered like this:
     .<City>

     The following example shows the use of trimmed fields in an
     address. Spaces and punctuation are added where needed. For
     example, one space is entered between the first and last
     names. A comma and a space separate the city and state fields,
     as is normally the case, while a space separates the state
     from the zip code. The brackets and periods do not count as
     spaces.

     .<FNAME> .<LNAME> .<ADDRESS1> .<ADDRESS2> .<CITY>,.<ST> .<ZIP>

     You can abbreviate the field name in trimmed formats, as long
     as there is enough of the field name to identify it as unique
     in the database.

     Padded Field

     Use a padded field when you want to retain all the spacing
     within a field. This format is most useful when you want to
     set up columns of data in your letter. The field length you
     define in the letter doesn't have to be the same length as the
     data entry field, but if you create a shorter field in the
     letter, data that extends beyond that length is truncated.




     PC-File Version 7 Users Guide                            207


     Padded field are indicated with square brackets [ ] around the
     field name. Enter the number of characters between the
     brackets that you want to allow for in the letter.

     Padded field commands look like this:

     .[Habitat ] .[Species ]

     Use blank spaces after the field name to add the necessary
     padding to the field command. Thus, if the field name is seven
     characters long and the field itself is 15 characters long,
     add eight blank spaces after the field name to give the field
     the necessary spacing for the data.

     You can abbreviate the field name in padded formats, as long
     as there is enough of the field name to identify it as unique
     in the database.

     If you enter a field with the Insert button, it is formatted
     as a trimmed field. Change the angle brackets to square
     brackets to define the field as a padded field.

     System Field Commands

     System fields normally provide for automatic data from the
     computer. For letters, you can have PC-File enter the current
     date, or prompt the user to key in data during the printing of
     each record.

     Current Date

     This command pulls the current date from your computer or
     network system. It is handy when you plan to reuse a letter
     and don't want to update the current date each time you print
     it. Enter it in the format .<DATE*> or choose Current date
     from the Insert dialog box. Be sure to enter the asterisk in
     the field if you add it yourself. Otherwise, PC-File
     interprets the command as a field command, and looks for a
     field called DATE in your database.

     Keyed Data

     Use this command to set up a field that allows user input for
     each record. While printing letters, the printer pauses and
     displays the prompt (message) you entered as part of the
     command. Press ENTER once you finish entering the message to
     continue printing.

     Choose Keyed data from the Insert dialog box to have PC-File
     set up the keyed data command. PC-File asks you for the
     message to prompt the user with during the printing of each
     letter. Enter the message as you want it to appear on the
     screen. For example, you could enter Type p.s. here.

     To enter the command yourself, type both the command and the
     message. For example, you could use the following command:




     PC-File Version 7 Users Guide                            208



     .<KEYIN*Type a personal note here>

     With the angle bracket format, you don't have to indicate the
     field length of the user input. You can enter up to 65
     characters for each letter. If you want to fix the length of
     the potential input, use square brackets around the command.

     Always use the asterisk (*) with the system commands, as
     illustrated above.

     Formatting Commands

     As the name suggests, use these commands to format a letter.
     The commands can remove unwanted blank lines, force a page
     change, and set printer codes for special character formatting
     such as bold or italics.

     You can enter the more commonly used formatting commands from
     the Insert dialog box. You'll have to enter the printer codes
     yourself.

     Formatting commands do not use brackets, but must be preceded
     by a period and entered in uppercase letters.

     Form Feed

     The .FF or .FORMFEED command (use either format) tells PC-File
     to skip to a new page. Use the command at the end of a one
     page letter. Without the command, the page won't kick out
     unless it also happens to be the last printable line of the
     page. For letters with multiple pages, use the form feed at
     the end of each page.

     Always enter a form feed command on a line by itself and start
     it at the left margin.

     Conditional Page

     The .CP n command skips to a new page, but only if there are
     less than n lines left on the page. For example, the command
     .CP 8 would skip to a new page only if there were less than
     eight lines left on the current page. This command is useful
     when you want to prevent a section of a letter from being
     split between two pages.

     Always enter a conditional page command on a line by itself
     and start it at the left margin.

     Reformatting Commands




     PC-File Version 7 Users Guide                            209


     There are times where you need to reformat a section of a
     letter to a particular width. For example, if you are printing
     several fields of varying length in the midst of a paragraph.
     The .REFORMAT nn (where nn is the width you want the following
     lines reformatted to) and .ENDREFORMAT commands reformat the
     paragraph to the specified width.

     To use the .REFORMAT nn and .ENDREFORMAT commands surround the
     paragraph to be reformatted. Each command should be placed on
     a line by itself, and should start at the left edge. For
     example:

     .REFORMAT 55 If you have any questions, please call your local
     sales office at: .<PHONE>. Your salesperson will be happy to
     answer any questions you have. .ENDREFORMAT

     This would reformat the paragraph to a width of 55. The
     resulting paragraph would look something like this:

     If you have any questions, please call your local sales office
     at: 555-1234. Your salesperson will be happy to answer any
     questions you have.

     Do not surround more than one paragraph with the .REFORMAT nn
     and .ENDREFORMAT or they will be reformatted into a single
     paragraph. Use the commands around each paragraph you need to
     reformat.

     Line Compression (Begin group and End group)

     The .GROUP, .EGROUP, and .EGROUP R commands are used to
     compress out blank lines, most often in addresses. Addresses
     can be formatted to accommodate four or five lines, but often
     require only three or four lines. With the line compression
     commands, blank lines resulting from empty fields are
     compressed out.

     Place the .GROUP command before and the .EGROUP command after
     the body of text in which you want the blank lines removed.
     Use .EGROUP R in place of .EGROUP if you want to relocate the
     blank lines to the end of the grouping, thus maintaining the
     overall line spacing. If you are entering the commands from
     the Insert dialog box, you have to add the space and the R
     from the keyboard.

     The following example illustrates the use of the line
     compression commands:

          .GROUP
          .<FNAME> .<LNAME>>
          .<ADDRESS1>
          .<<ADDRESS2>
          .<CITY>,.<ST>> .<ZIP>
          .EGROUP




     PC-File Version 7 Users Guide                            210


     For those cases with no data in the ADDRESS2 field, the blank
     line gets compressed out.

     Always enter line compression commands on a line by themselves
     and start the command at the left margin.

     Printer Markers

     Use printer markers to change character formatting within your
     letter. Printer markers are available for many of the standard
     print enhancements, such as bold, italics, and underlined
     type. You have to enter printer markers from the keyboard;
     they are not available from the Insert dialog box.

     The available printer markers are:

          .NORMAL
          .CONDENSED
          .BOLD
          .ITALIC
          .UNDERLINE
          .PORTRAIT
          .LANDSCAPE
          .PROPORTIONAL
          .DOUBLEWIDE
          .USERn (where n is 1-5)

     Enter a printer marker where you want a change in the font or
     type to occur. Use the marker .NORMAL to return to the
     default.

     The following line taken from the sample letter illustrates
     the use of a pair of printer markers.

     ...5-acre .BOLDRocky Mtn.NORMAL habitat for ...

     You can enter a printer marker at the start of a letter to
     enhance the entire letter. For markers such as .PORTRAIT and
     .LANDSCAPE, you would normally do that anyway.

     The .USERn printer markers are user-defined printer codes that
     you can set in your configuration profile. If you think you
     might use a particular print enhancement on a regular basis,
     consider creating a user-defined code. Otherwise, you can use
     ASCII decimal value for the code, described below. See Chapter
     13, "Utilities," for information on user-defined printer
     codes.

     Miscellaneous Printer Codes

     You can imbed printer codes other than those listed as printer
     markers. To imbed these codes, use the ASCII command.




     PC-File Version 7 Users Guide                            211


     For example, if you want to insert a superscript or subscript
     character into a letter, you have to use the ASCII command.
     You can also change the line spacing in this way. Normally,
     line spacing is set to 6 lines per inch. You can change it to
     8 lines per inch to accent a particular paragraph or tighten
     up the entire letter.

     The ASCII command follows this format: .A nn,nn . The .A is
     followed by a space, then by the decimal values of printer
     control characters, each separated by a comma. A space must
     follow the last digit in the command. The space at the end of
     the command is not printed. See your printer manual for the
     printer codes and their respective decimal values.

     Calculation Commands

     Calculations can be used in letters in much the same way they
     are used in reports. The answer to the calculation appears in
     each letter at the prescribed location.

     Use both angle brackets and parentheses to enclose
     calculations, as shown:

     .<(@Member_no,Donation,Member_no,Amount):$$,$##.##:>

     This relational lookup pulls the data from the Amount field in
     the Donation database by using the Member_no field common to
     both the Members and Donation database.

     Use print masks with calculations to specify the formatting.
     In the above example, the print mask adds the dollar sign and
     punctuation to the data. Enclose the print mask within colons.
     Enter the closing angle bracket after the mask. Print masks
     are explained in detail in Chapter 9, "Creating Reports."

     All types of calculations supported by PC-File can be used in
     a letter, including relational lookups. See Chapter 17,
     "Calculations," for information on using calculations.

     IF Commands

     IF commands can be useful in letters to include or omit
     information based on a comparison. For example, you can use an
     IF to include a middle initial in a name when the field
     contains data, but omit it and close up the space when the
     field is empty.

     IF commands also follow a set format:

          .IF (add a comparison calculation)
          Things to do if true (can be many commands long)
          .ELSE
          Things to do if not true (can be many commands long)
          .ENDIF




     PC-File Version 7 Users Guide                            212


     Every .IF statement must have a matching .ENDIF statement. The
     .ELSE statement is optional. Always start the commands in the
     first column of the letter.

     The following example illustrates the use of an IF command in
     a letter:

          .IF (Middle = " ")
          .<First>> .<Last>
          .ELSE .
          <First> .<Middle> .<Last>
          .ENDIF
          .<Address>
          .<City>,.<State> .<Zip>

     The comparison is always contained on the same line with the
     .IF command. The .ELSE and .ENDIF commands must appear on
     lines by themselves. For that reason, you can't include IF
     commands within the body of a paragraph of text. The lines
     used by the commands disappear when you print the letter.

     Choose the option If, Else, Endif from the Insert dialog box
     to have PC-File enter the command for you. PC-File prints the
     three commands on separate lines. You can remove the Else
     command if you don't use it.

     Modifying a Letter

     You can call up an existing letter and make changes to it at
     any time.

     To modify a letter:

     1.Choose Print from the menu bar.

     2.Choose Letters from the Print menu.

     3.Choose Modify from the dialog box. A file selection dialog
       box appears.

     4.Choose the letter you want to modify from the list.

     5.Accept the column width of 70 characters, or enter a new
       width up to 120 characters.

     6.Make your changes to the letter.

     7.Choose OK when you finish.

     8.Choose Yes to save the letter.

     9.Accept the current description or enter a new one. The
       modified letter is saved.




     PC-File Version 7 Users Guide                            213




     CHAPTER 11 PRINTING REPORTS AND LETTERS

     Reports and letters follow similar printing procedures and use
     the same dialog box for setting printing parameters. This
     chapter explains those procedures and parameters. In addition,
     this chapter covers Printer setup, an option on the Print
     menu.



     Printing Procedures

     PC-File simplifies the process of printing a report or letter.
     When you get ready to print, the program displays the Print
     options dialog box. Make all your necessary settings and
     adjustments there. When you finish, you are ready to begin
     printing.

     Before attempting to print a report or letter, be sure your
     computer is properly connected to the printer and that PC-File
     is configured for your printer. For information on configuring
     your printer, see Chapter 13, "Utilities," and the section on
     printer setup later in this chapter.

     NOTE: Printing graphs and multi-column labels follow separate
     procedures. See Chapter 12, "Creating Graphs," for information
     on printing graphs. See Chapter 14 for information on printing
     labels created with PC-Label. See Chapter 15, "Tools," for
     information on printing snapshot labels.

     To print a report or letter, you can either choose an existing
     report or letter or create a new one. In either case, PC-File
     displays the Print options dialog box that allows you to set
     the parameters for printing.

     To print a report or letter:

     1.Choose Print from the menu bar.

     2.Choose Report or Letter from the Print menu, depending on
       which one you want to print.

       PC-File displays a dialog box. The options are the same
       whether you choose reports or letters.

     3.Choose Run from the dialog box.

       If you are creating or modifying a report or letter before
       printing, choose the appropriate option. When you finish,
       the Print options dialog box displays.

     4.Choose the report or letter from the file selection dialog
       box.




     PC-File Version 7 Users Guide                            214


       The Print options dialog box displays.

     5.Set the options you want and choose OK.

       If you are printing a report, the settings are saved to a
       file, named reportname.ANS. The settings become the default
       the next time you print the report.

       If you are printing a letter, the settings only pertain to
       the current printing. The program default settings display
       the next time you print the letter.

     6.What happens next depends upon your settings in the Print
       Options box.

       If you chose to print Some records, PC-File prompts you to
       conduct a search for the records you want to print.

       If you chose to print to disk, PC-File prompts you to enter
       a path and file name.

       If you checked the Do Subtotals box, PC-File prompts you to
       enter the field or calculation that triggers the subtotal.

     7.If you are printing to a printer or to a file, PC-File
       displays the first record on the screen and prompts you to
       choose Yes, No, All, or Quit.

     This prompt displays for two reasons. First, it allows you to
     choose a selected group of records for which there is no
     precise selection criteria. In other words, you can print a
     random group of records. Secondly, if you have defined a
     selection criteria, it lets you assure yourself your criteria
     is correct by viewing your records. Once you feel certain you
     have chosen the right records, you don't have to look at the
     rest.

     8.Choose Yes to print the record and display the next.

     9.Choose No to skip the current record and display the next.

     10.  Choose All to print the current record and all the
       remaining records that meet the selection criteria without
       any further prompting.

     11.  Choose Quit to stop printing the report or letter.

     If you are printing to the screen, PC-File displays the report
     or letter without prompting you.




     PC-File Version 7 Users Guide                            215



     The Print Options

     PC-File displays the Print options dialog box when you are
     ready to print a report or letter. Set your printing
     parameters there.

     The setting options are the same for both letters and reports,
     but PC- File handles the two features differently. This is
     because reports are often run repeatedly, while letters are
     more likely to be used only once.

     When you print a report, PC-File remembers the settings from
     the Print options window and places them in a file. The file
     is named reportname.ANS. The settings are then used as the
     default anytime you print that particular report. Presumably,
     you would not have to reset any of the parameters. If you do
     make a change, that becomes the new default.

     For letters, PC-File doesn't retain the settings and doesn't
     create a file for them. After you print a letter, PC-File
     replaces your settings with the program default. Thus, if you
     want to double-space a letter, you have to set the line
     spacing parameter to 2 each time you print the letter.

     Each parameter in the Print options dialog box is explained
     below.

     Print

     You can choose which records in your database you want to
     print. Choose All records to print all the records in your
     database; choose Some records to select certain records. If
     you choose to print Some records, PC-File prompts you to
     select the records by conducting a search. See Chapter 7,
     "Finding and Modifying Data," for information on conducting a
     search.

     You can also print selected records for which there is no
     specific criteria. For example, you may want to print letters
     to send to a few members chosen at random from the database.
     To do this, choose All records. When you get ready to print,
     the records display one by one on the screen for you to
     select. Choose the records you want to print. You can follow
     the same procedure after choosing Some records if you want to
     pick out selected records from within a specific subgroup of
     your database.

     The program default is All records.

     Output

     PC-File can print a report or letter to the printer, screen,
     or to a file on the disk. To select the output device, choose
     the appropriate option. Only one option can be selected at a
     time. The program default is Printer.




     PC-File Version 7 Users Guide                            216



     If you select Printer as the output device, PC-File prints to
     the printer port selected in the configuration profile or in
     Printer setup.

     If you print to a file on the disk, PC-File prompts you for
     the drive, path, and file name. Enter the output file
     specifications in the dialog box. For example, you might type:
     c:\pcfile\sample\temp.txt.

     The file printed to disk is an ASCII file.

     Subtotals

     Subtotal breaks allow you to separate groups of related
     records in a report. You can then print subtotal values for
     each group, or you can just separate the groupings by
     inserting blank lines or page breaks between them.

     Creating subtotal breaks is a two-part process. The first part
     involves creating a Subtotal section within the report and
     defining the action that will occur. See Chapter 9, "Creating
     Reports," for details. For the second part, select the
     Subtotals option button in the Print options dialog box,
     choose OK, then name the break. A subtotal break can be a
     field, a portion of a field, or a calculation.

     Normally, a break is a field or partial field. Whenever the
     data in the break field changes, a new subtotal grouping is
     triggered. The following example shows a subtotal break on the
     first letter of the last name. When the first letter changes,
     a blank line is inserted to break up the names.

     A subtotal break can produce a simple break or a break with
     subtotals.

     Subtotal breaks can also be based on calculations. You can use
     the same information in the above example, but break it on a
     calculation based on the amount of the donation. The subtotal
     break calculation is (Amount >150). The result is illustrated
     below.

     PC-File allows up to nine levels of subtotal breaks. For
     example, you could subtotal by product within salesperson
     within department within division. In general, the primary
     subtotal level should be the current index field.

     After you choose how to perform subtotals, PC-File lets you
     choose whether you want to print the data from the break only
     once when it changes or every time it appears. This is called
     group highlighting. Turning group highlighting ON prevents the
     data from being repeated over and over. Group highlighting
     works on every subtotal level. In the previous two examples,
     group highlighting is turned off. The following example shows
     the Donation report subtotaled on Member_no with group
     highlighting




     PC-File Version 7 Users Guide                            217


     turned on.

     In addition to group highlighting, PC-File provides the
     option, "New Page After Subtotals." Choosing this option
     causes your report to feed to a new page at the end of each
     level 1 subtotal break. You must use the Language format to
     set up more sophisicated paging when performing multiple level
     subtotal breaks. See the section, "Subtotal Report Commands"
     in Chapter 9, for details.

     The default is for subtotals to be turned off. When the
     setting is turned off, the Subtotal section of the report is
     ignored. The subtotal setting is always ignored when you print
     a letter.

     To set subtotal breaks:

     1.Select the Subtotals option button.

     2.Choose OK when you finish with the dialog box.

     3.Enter the primary subtotal break. You can choose a field
       name or enter a calculation into the text box and press
       ENTER.

     4.Repeat step 3 for any additional subtotal break levels. You
       can enter up to nine levels of subtotal breaks.

     5.Choose Cancel when you finish entering breaks.

     6.Choose Group Highlighting or New Page After Subtotals, if
       desired.

     7.Choose OK.

     PC-File prints the report to your specifications.

     Pause Between Pages

     If you feed paper into your printer manually, select the Pause
     Between Pages option button on the Print Options dialog box.
     The program will pause after each page, allowing you to insert
     a new sheet of paper. Press any key to start printing again.

     The program default is No Page Pause.

     Flip Data

     PC-File normally flips the data in a field containing the flip
     character, a tilde (~). This is indicated by the Flip Data
     option button on the Print Options dialog box. You can
     suppress the flip action by selecting the Don't Flip Data
     option button instead.




     PC-File Version 7 Users Guide                            218


     For example, if a name field contains data entered in the
     format LASTNAME ~FIRSTNAME, and you leave Flip Data on, PC-
     File prints data in the order FIRSTNAME LASTNAME. If you
     select Don't Flip Data, the data in the field remains in the
     LASTNAME ~FIRSTNAME format. The tilde prints as part of the
     data.

     The program default is Flip Data. If you have no fields
     containing tildes, this setting is ignored.

     Normal Type/Condensed Type

     PC-File can print a report using one of two pre-defined print
     sizes. These sizes are determined in your configuration
     profile, based on the printer you choose or the user codes you
     set.

     Condensed type is most useful for reports that are wider than
     the normal carriage width. Normally, you should use condensed
     type if your report exceeds 80 characters in width. Otherwise,
     the printer will either wrap each line of the report to the
     next line or it will print off the edge of the paper.

     Most printers other than daisy-wheel printers are set up to
     handle normal and condensed type. However, you can enter new
     printer codes in your configuration profile so that the normal
     and condensed options actually produce some other type style.
     For example, you can enter printer codes for condensed type
     that will print a larger type size or a landscape format.

     The program default is Normal Type, in which case your report
     or letter prints in normal type. Select the Condensed Type
     option button to print in condensed type.

     Number of Copies

     You can print up to 99 copies of your report or letter in one
     printing. If you have a multi-page report or letter, PC-File
     normally prints the entire document before it begins the next
     copy.

     Enter the number of copies you want to print. The default is
     1.

     Line Spacing

     You can set the line spacing in a report or letter. For
     reports, the spacing only affects the Detail section. For
     letters, the entire letter is affected, including the name and
     address.

     Enter 1 to single-space the report or letter. Enter 2 to
     double-space it. The default is 1.




     PC-File Version 7 Users Guide                            219


     For reports, enter 0 to prevent the Detail section from
     printing. This is useful when only the subtotal or total
     information is required.

     NOTE: If you want to double space the body of a letter, but
     not the name and address, you must enter the extra line
     spacing directly into the letter itself.

     Left Margin

     The Left margin parameter lets you add extra spaces to the
     left side of your report or letter, beyond the normal left
     margin. This is especially useful if you have a narrow report
     that you want to center. For example, if you print a phone
     listing that includes just names and phone numbers, you could
     increase the left margin to center the two columns of data.

     The program default is 0.

     Page Length

     The page length setting makes it easy to adjust the length of
     your report or letter for different size paper and different
     types of printers without changing the configuration profile.
     To change the number of lines per page, enter the new page
     length. The default is 66 lines per page.

     For reports, PC-File calculates the number of lines of Detail
     per page by subtracting the number of lines in the Heading and
     Footing sections from the page length. To adjust your top and
     bottom margins, edit the report format and change the size of
     the Heading and Footing sections.

     Laser printers usually require a page length of 60 lines when
     printing in portrait mode and 45 lines in landscape mode. Dot
     matrix and daisy wheel printers normally use 66 lines. For
     legal size paper, the page length is 78 for laser printers and
     84 for other printers. You can determine the number of lines
     per page by multiplying the page length in inches times the
     number of lines per inch.

     The program default is 66.

     NOTE: If each page of your report or letter prints higher on
     the page than the previous one, increase the page length; if
     it prints lower, decrease it.

     Start at Page #

     Normally, printing starts on the first page of a report. This
     setting lets you start printing on a later page.

     For example, if you have already printed part of the report
     and need to restart printing (after a paper jam, for example),
     this permits you to skip over what has already been printed.




     PC-File Version 7 Users Guide                            220


     NOTE: Don't change your selection criteria midway through
     printing a report or set of letters. PC-File uses the original
     selection criteria for printing.

     The program default is 1.

     Printer Setup

     Use the Printer setup option on the Print menu to override the
     printer defaults in the current configuration profile. These
     default settings include page length, printer, and printer
     port. This option is most useful if you only need to change
     printers or page lengths on rare occasions. If you need to
     change settings on a regular basis, it is recommended that you
     define an auxiliary configuration profile. You can then load
     that profile when you want to change your settings. Refer to
     Chapter 13,
     "Utilities," for information on auxiliary profiles.

     Changes made using the Printer setup option remain in effect
     only during the current session in PC-File. The settings are
     overriden if you load another configuration profile.

     To change your printer defaults temporarily:

     1.Choose Print from the menu bar.

     2.Choose Printer setup from the Print menu.

       The printer setup dialog box displays.

     3.Set the options you want.

     4.Choose OK.

     Your printer options are adjusted for the current session
     based on your settings.

     NOTE: The Page length setting in the Print options dialog box
     overrides the setting defined with the Printer setup option.
     Be sure to check that the settings match when you print your
     report or letter.

     Common Printing Problems

     This section lists some of the common problems that occur with
     printing reports and letters, and offers suggestions on how to
     correct them. Most of the problems relate to reports only,
     though some refer to both reports and letters.

     Bad Report Format Message

     If PC-File does not recognize a field name or names in a
     report or letter when asking to print them, a message displays
     in this format:




     PC-File Version 7 Users Guide                            221


     Bad Report Format Field: fieldname

     where "fieldname" is a field in your report or letter.

     This occurs when:

     A field name is spelled incorrectly in the report or letter
     The report or letter was defined for a different database
     (with different field names)

     The name of the field has changed since the report or letter
     was defined

     To correct the problem, first check to make sure the report or
     letter was defined to go with the current database. Then check
     the field name in the document with the field name in the
     database. You can run a database description (from the
     Utilities menu) to get a complete list of the database fields
     if necessary.

     If the Bad Report Format message displays when trying to print
     a system field, check to make sure that the system field name
     is followed by an asterisk and that the system field name is
     entered entirely in uppercase letters.

     The Document Creeps Up or Down the Page

     There are several reasons why a report or letter might creep
     up or down the page.

     Incorrect page length

     Check the Page length setting in the Print options dialog box
     to see that it is correct. Generally, if the report is
     creeping up the page, you should increase the page length. If
     the report is creeping down the page, you should decrease it.

     Report too wide

     The printer may be wrapping information from one line to the
     next. This happens when the report is too wide for your
     printer to print. (This is seldom a problem with letters.) To
     correct this problem, edit the report using the Language
     format option. Insert a new line with the /1 command after the
     command to print the last field that fits on one line.
     Alternatively, you may be able to print the report in
     condensed print so that all columns fit on one line.

     Missing line feeds

     The report may not have a /1 command at the end of each
     section. Generally, every section should end with at least one
     /1 command. The only exception to this rule is if the section
     ends with a .FF. You can edit reports with the Language editor
     to make sure the line feeds are in place.




     PC-File Version 7 Users Guide                            222


     Missing Footing section

     Generally, every report should include a Footing section with
     at least one line feed command (/1) at the end. The only
     exception is when the report contains only a Detail section
     and is designed to print on continuous form labels or cards.

     The Report Prints on the Perforation

     There are three reasons why PC-File might print on the bottom
     perforation.

     Missing or incorrect Footing section

     The report does not have a Footing section, or the Footing
     section is not defined to print a bottom margin (blank lines).
     The number of blank lines at the end of the Footing section
     determine the bottom margin of each page. Edit the report and
     add the following line in the Footing section:

     /6

     If the report already has a Footing section, add six line
     feeds (/6) at the end of the section. This gives you a one-
     inch bottom margin. You can increase the number of line feeds
     to lengthen the bottom margin, or decrease it to shorten the
     bottom margin.

     PC-File determines how many lines of data to print per page by
     subtracting the number of lines in the Heading and Footing
     section from the page length. For example, if the page length
     is 66 and there are 4 lines in the Heading section and 5 lines
     in the Footing section, PC-File prints 57 lines of data per
     page.

     Do not use the .CP command in the Detail section to determine
     the bottom margin. The .CP command is used only to prevent
     data from being split between two pages.

     Incorrect page length

     Check to see that the page length is correct. Refer to the
     section "The Report Creeps Up or Down the Page" above for more
     information.

     Incorrect page alignment

     The initial page alignment may be incorrect. To ensure the
     initial page alignment is correct, the printer should be
     aligned to the top of the page before printing begins. Do not
     manually move the paper in the printer. Use the buttons on the
     printer to move the paper. You can also align the paper in the
     printer, turn the printer off, then turn the printer on to
     reset the printer to the top of the page.




     PC-File Version 7 Users Guide                            223


     On laser printers, make sure the Form feed light is not on
     before you start printing.

     Nothing Prints on the Report or Only Headings Print

     There are four possible reasons why no data prints on the
     report.

     Incorrect line spacing setting

     Check the Line spacing setting in the Print options dialog
     box. To print the data from individual records, line spacing
     must be set at 1 or higher. If you set the line spacing at 0,
     data from individual records is not printed; only the Cover,
     Heading, Subtotal, Total, and Footing sections are printed.

     Report incorrectly defined

     Make sure the report is defined correctly. The commands to
     print data from individual records must be in the Detail
     section. Refer to Chapter 9, "Creating Reports," to make sure
     you have defined the rest of your report correctly.

     No records meet selection criteria

     If you are printing some records rather than all of them,
     check to see that you haven't narrowed the range so much that
     no records meet your selection criteria. Try printing the
     report selecting all records. If nothing prints, investigate
     the other possible reasons.

     Damaged file or index

     The index or data file may be damaged. Rebuild the indexes or
     run the Repair option from the Utilities menu. However, if you
     can view your records while browsing, this is not the reason.

     The Heading Only Prints on the First Page

     There are two possible reasons why the heading information
     only prints on the first page.

     1.Heading incorrectly defined

       The heading information is defined in the Cover section
       instead of the Heading section. The Cover section is only
       printed once at the beginning of the report.

     2.Footing incorrectly defined

       If you have a Heading section, you must have a Footing
       section. If nothing else, at least enter a line feed (/1) in
       the footing section.




     PC-File Version 7 Users Guide                            224




     CHAPTER 12 CREATING GRAPHS

     You can create visual representations of your data with PC-
     File's graphing option. PC-File walks you through the process
     step by step. Once you have created a basic graph, you can
     switch between several different types, including line graphs,
     bar graphs, and pie charts.


     Graphing Your Database

     PC-File can give you a graphic view of your data. Graphing can
     be an especially powerful way to present data because it
     allows you to summarize large volumes of data in an easily
     understood picture.

     You can create several types of graphs-line graphs, horizontal
     and vertical bar charts, pie charts, scatter charts,
     overlapped bar charts, and cumulative bar and line graphs. And
     once you create a graph, you can switch back and forth between
     the different types to find the one that best displays your
     data.

     You can also add a grid, calculate and display an average, and
     determine and show smoothed averages.

     Graphing data can seem a bit intimidating to an inexperienced
     user, but, in fact, it can be a lot of fun. So don't be afraid
     to give it a try. PC-File walks you through the process of
     creating a graph step by step. It usually only takes a minute
     or two to create a graph, so if you make a mistake, you can
     try it again.

     System Requirements

     The PC-File graphing utility will display a graph on most
     monitors and print a graph on most printers in use today.
     However, check the following requirements to see that your
     equipment meets the minimum needs of the program.

     Monitors

     The following monitors support the PC-File graphing utility:

          Hercules or Hercules-compatible monochrome

          CGA

          EGA

          VGA




     PC-File Version 7 Users Guide                            225


     The graphing utility runs "as is" on a color monitor. However,
     if you have a Hercules or Hercules-compatible graphics card
     and a monochrome monitor, you must run a special program
     before you can produce graphs. The program is called
     MSHERC.COM. It is included with PC-File and is automatically
     loaded onto your hard disk when you install PC-File.

     If you intend to work with the graphing utility and have a
     monochrome monitor, you need to run MSHERC.COM before you
     start PC-File. To run the program, type msherc at the DOS
     prompt and press ENTER. The program runs through quickly and
     returns you to the DOS prompt.

     If you use the graphing option regularly, enter the command
     MSHERC in your AUTOEXEC.BAT file. The program will run
     automatically each time you boot up. Refer to your DOS manual
     for more information on the AUTOEXEC.BAT file.

     Printers

     Graphs created with PC-File can be printed on the following
     printers:

          Epson (FX) dot matrix

          Epson (MX) / IBM dot matrix

          Okidata dot matrix

          HP Laserjet

          PostScript printers

     For other printers, you may be able to use the DOS GRAPHICS
     command to print graphs as they appear on the screen. See your
     DOS manual for information on using this command.

     Graphing Concepts

     During the process of defining a graph, PC-File introduces a
     number of concepts that may not be completely clear to the
     user at first glance. These concepts are explained in detail
     below.

     Subtotals and Totals

     You must choose between graphing subtotals and totals during
     the process of defining a graph. The difference is fairly
     straightforward. Choose Subtotals if you want to graph the
     data within a field or within several fields. Choose Totals if
     you want to compare the totals of two or more fields. In other
     words, if you want to graph records within a field or fields,
     choose subtotals; if you want to graph a summation of all the
     records from several fields, choose totals.

     Values and Counts




     PC-File Version 7 Users Guide                            226



     During graph definition, PC-File asks you to choose between
     accumulating Values or Counts. Values refers to the actual
     data in the database that you are graphing. Counts refers to
     the number of records being graphed.

     In most cases, you want to choose values. If you are graphing
     sales by each employee, zoo attendance by year, or increases
     in the captive snow leopard population, you are graphing data
     from a database and should select Values. Values should always
     be numeric.

     It is much less likely that you would choose counts. If you
     wanted to count the number of sales made by each employee,
     rather than total the sales themselves, you would choose
     counts. In that case you would graph the number of records,
     with each record representing a sale, rather than the sales
     data itself.

     Counts are also useful when the data is not numeric. For
     example, if you want to graph the number of members that lived
     in each state, you could just count the records by state.

     Graph Titles

     PC-File prompts you to enter four titles for the graph. These
     titles include the main graph title, a subtitle, a category
     heading and a variable heading. The placement of these titles
     is illustrated below.

     The title and subtitle always appear above the graph. They are
     synonymous with a report title and subtitle.

     The variable heading normally appears on the vertical axis of
     the graph. It describes the data of the fields you are
     graphing. For example, if you are graphing sales by month,
     sales would be your variable heading.

     The category heading normally appears along the horizontal
     axis of a graph. It often describes the contents of the field
     that you choose for the subtotal break (which is described
     below). For example, if you are graphing sales by month, month
     is the field on which you categorize the data, and is your
     likely category heading.

     Exceptions to the rules are horizontal bar graphs and pie
     charts. In horizontal bar graphs, the headings are reversed.
     In pie charts, the variable heading normally displays as a
     description beneath the chart and the category heading is used
     with a legend on the side. The legend provides a description
     for the wedges of the pie.

     The titles are case sensitive, and thus appear just as you
     enter them.

     All titles are optional. Press ENTER to skip a title.




     PC-File Version 7 Users Guide                            227



     Subtotal Breaks

     If you graph subtotals, PC-File prompts you to choose a
     subtotal break. The subtotal break is normally the field by
     which you are grouping your data (it can also be a
     calculation). In that way it is very similar to a subtotal
     break in a report.

     Normally, the subtotal break is the field plotted along the
     horizontal axis of the graph. This is the same field on which
     you based the category heading. The subtotal break is usually
     not a field that you are graphing.

     If you are graphing sales by month, the break field is month.
     If you are graphing sales by department, the break field is
     department.

     Types of Graphs

     There are four basic kinds of graphs that you can create in
     PC-File. Read the descriptions below to help you decide which
     kind you want to use for the data you are graphing. However,
     once you define a graph, you can switch back and forth between
     various graph types, using the same selected data. In that
     way, you can often tell which is the best representation of
     your data.

     Line Graphs

     In general, line graphs are useful for seeing trends-increases
     or decreases-over time.

     Line graphs can also be used to plot engineering or scientific
     data. How temperature readings in one city vary over several
     months, or how a car's gas mileage changes as the r.p.m.'s
     increase are two simple examples of possible uses for line
     graphs.

     Scatter Graphs

     Scatter graphs are very similar to line graphs. (Line graphs
     are actually scatter graphs with lines drawn between the
     points.) Scatter graphs are most useful when you have a lot of
     points to plot. As a general rule, if you will be plotting
     more than 20 points, a scatter graph or line graph will give
     you a clearer visual summary of your information than one of
     the other graph formats.

     Pie Charts

     Pie charts are the least flexible of all the graph choices.
     They are primarily used to compare or show percentages. If you
     want your graph to answer the question, "how much of the pie
     did this person/these people get?" you probably want a pie
     chart.




     PC-File Version 7 Users Guide                            228



     Pie charts are not good if you will be plotting many fields,
     or if you will have many subtotal breaks. A pie chart becomes
     cluttered and hard to interpret with more than 10 or 15
     wedges.

     Bar Graphs

     Bar graphs are one of the most versatile of all the graph
     formats. Like pie charts, they are useful for visual
     comparison, but instead of showing you a percentage, bar
     graphs show actual numeric amounts. Like line graphs, you can
     use bar graphs to show trends by plotting the values of one or
     several fields' data over time.

     The strong point of bar graphs is their ability to show
     numerical amounts, be it dollars, time, mileage, etc. The
     choice between horizontal or vertical bar graphs is strictly a
     matter of preference. You can easily switch between either
     style to decide which you prefer.

     Defining a Graph

     Before you begin to define a graph, you should know:

          Which fields you are graphing

          Whether you are graphing subtotals or totals

          If graphing subtotals, which field or fields will serve
          as the break

          Whether you are using values or counts

     You might find it handy to sketch your graph on paper first.
     Draw a basic graph, indicating which fields you want to use
     and how the data will appear when graphed. Decide on the
     titles and headings. With your sketch in front of you, the
     actual process of defining a graph on the screen will take
     only a few moments.

     To define a graph:

     1.Choose Print from the menu bar.

     2.Choose Graphs from the Print menu.

     3.Choose New from the dialog box listing the operations. A
       file selection dialog box displays.

     4.Enter a file name for your graph in the text box. Choose OK.
       PC-File prompts you to choose how the data should be
       summarized.




     PC-File Version 7 Users Guide                            229


     5.Choose one of the four options. For example, if you are
       graphing totals rather than subtotals and counts rather than
       values, choose the fourth option, Total Counts. PC-File
       displays a field selection dialog box.

     6.Choose the fields you want to graph, in the order you want
       them to appear on the graph from left to right. PC-File
       displays a dialog box asking you to enter the titles and
       headings for the graph.

     7.Enter the Title, subtitle, and headings in the appropriate
       text boxes. Press ENTER to skip any of the titles. Choose OK
       to continue.

     8.Choose a default graph type. You can switch types later if
       you want. PC-File prompts you to save the graph.

     9.Choose Yes to save the graph or No to run the graph only
       once.
     10.  PC-File displays another field selection dialog box.

     11.  Choose the subtotal break.

     12.  Choose to graph all or some records.

     13.  Perform a search if you chose some records. PC-File
       displays the first record and asks if you want to output
       this record.

     14.  Choose Yes to graph this record and display the next.
       Choose No to skip this record and display the next. Choose
       All to output this and all remaining selected records
       without further prompting. PC-File displays the graph on the
       screen. Instructions for using
     15.  the menu commands on the graphing screen are covered
       below.

     Viewing and Printing a Graph

     Once you have displayed a graph on the screen, you have
     several options:

     Switch to a different type of graph Add one or more of the
     optional features Print the graph

     To perform any of these actions, use the menu. Press the
     letter M to display the menu. There are two menu lines, as
     shown below.

     The General menu, on the top line, remains the same no matter
     which graph type is displayed. The Type menu, on the bottom
     line, varies, depending on the type of graph displayed. The
     name of the menu also varies, depending on the type of graph
     currently displayed. For example, in the above screen, the
     menu is called Bar because a bar graph is displayed.




     PC-File Version 7 Users Guide                            230


     To choose an option from either menu line, press the letter
     indicated. You can choose options in this manner whether or
     not the menu is displayed.

     NOTE: The mouse is inactive within the graphing utility, so
     you must use the keyboard to choose menu options.

     The General Menu Options

     Of the nine options on the General menu, use the last five -
     Pie, Line, H(orizontal) bar, V(ertical) bar, and Scatter - to
     switch between the different graph types.

     Choose Quit when you finish to leave the graphing utility and
     return to the PC-File menu bar.

     The first three options on the General menu, Output, Color,
     and Menu, are explained in detail below.

     Output

     Choose Output to print the graph. There are several steps
     involved in printing. During printing, the menu bar, if
     currently displayed, is removed from the screen and is not
     printed.

     To print a graph:

     1.Choose Output from the General menu.

     2.Choose Portrait, Landscape, or GIF from the dialog box that
       displays.

       Portrait prints the graph in the normal vertical manner.

       Landscape rotates the graph 90 degrees and prints a somewhat
       larger image of the graph. If you are making overhead
       projector view foils, you probably want to use landscape.

       The GIF format produces a graphics file that can be imported
       into documents in most word processing or desktop publishing
       programs. GIF files are in a standard graphics format that
       is compressed to minimize the amount of disk space used. PC-
       File defines GIF files with names like PCG2_nnn.GIF, where
       nnn is a number such as 001. GIF files are defined to the
       current directory.

     3.If you chose Portrait or Landscape, choose the output
       printer from the list that displays.




     PC-File Version 7 Users Guide                            231


       Choose Epson for Epson FX and LQ model printers only. Choose
       IBM for IBM printers, Epson MX model printers, and Okidata
       printers set to IBM mode. Choose Okidata if your Okidata
       printer isn't set to IBM mode. Choose Laserjet for all HP-
       compatible laser printers. Choose PostScript for all
       printers with a PostScript driver. We recommend that you use
       PostScript if you have it. It produces the best quality
       output of all the options available.

     4.For PostScript only, another menu displays.

       Choose an option from this menu.

       Decide whether you are printing to a file or to the printer,
       then choose between pattern fill or gray fill.

       Pattern fill produces various patterns in the rectangles of
       bar charts and the wedges of pie charts, while gray fill
       colors those same areas in shades of gray. Choosing gray
       fill results in a much faster printing operation.

     As the graph prints, the screen colors change to their
     "negative" colors to show the progress of the printing
     process. When creating Postscript output, the graph is redrawn
     on the screen twice.

     When printing is completed, the graph is redrawn on the screen
     and the menu redisplayed (depending upon the state of the M
     toggle.)

     NOTE: If you are printing a Pie chart, it is redrawn on the
     screen when you select the orientation of the output. The
     aspect ratio defined for the selected orientation is used.

     Color

     Some colors may not show up clearly on your screen. The Color
     option allows you to select those colors which show up best,
     and also permits you to select the foreground and background
     colors. Your selections are saved to a file, called PCG2.ASP,
     and used in future graphing operations.

     NOTE: The Color option has no effect if you are using a
     monochrome or CGA screen, both of which display in black and
     white. CGA monitors display in black and white because the
     resolution is at its maximum in that mode.

     To change colors:




     PC-File Version 7 Users Guide                            232


     Choose Color from the General menu. PC-File displays a dialog
     box. Adjust the background and foreground colors if you want.
     Press B repeatedly to run through the available background
     colors, and press F repeatedly to run through the foreground
     colors until you have the color combination that you prefer.
     Turn any of the detail colors off. To turn a detail color off,
     press the number that is displayed to the left of the
     respective color bar. An N is displayed to the right of the
     bar when the
     color is turned off. Press the number again to turn it back
     on. You can press Q at any time to go back to your graph and
     view the current colors. Press C to return to the color
     screen. Press Q to return to the graph when you finish.

     Menu

     The Menu option toggles the menu display on and off. When the
     menu lines are not displayed, the message (press M for menu)
     is shown at the lower-right of your screen. You can press
     SHIFT-F1 to remove this message.

     The menu lines do not need to be displayed for you to choose
     any of the menu options. (When you print the graph, the menu
     lines are removed for you automatically.)

     The Type Menu Options

     Use the options on the Type menu to enhance your graphs. You
     can add a grid, display a calculated average, display smoothed
     averages, or replot your graph on a logarithmic scale.

     There are 14 enhancement options. The options available on the
     Type menu vary, depending on the type of graph currently
     displayed. Only those options that appear on the menu for the
     current graph can be used.

     All of the options are explained below.

     Bound

     You can change the scale of a graph with the Bound option.
     This is done in three steps.

     First, edit the GRAPH.ME file, using any text editor or word
     processing program that saves standard ASCII (non-formatted)
     files. Insert a one-line BOUND command before the first TITLE
     line in the file. Use the format

     BOUND:Xh,X1,Yh,Y1,0,Ch

     where

     Xh is the maximum X axis value X1 is the minimum X axis value
     Yh is the maximum Y axis value Y1 is the minimum Y axis value
     0 (zero) is required Ch is the maximum cumulative value




     PC-File Version 7 Users Guide                            233


     For example, to set the scale of the Y axis so that the
     maximum value is 500 and the minimum value is 1, and the
     maximum cumulative value is 5000, use the command

     BOUND:0,0,500,1,0,5000

     Second, after saving the edited GRAPH.ME file, run the
     graphing utility in stand-alone mode, from the DOS prompt.
     Making sure you are in the directory that contains both the
     PCG2.EXE file and the GRAPH.ME file, type pcg2 at the DOS
     prompt and press ENTER. When the graph is displayed, the old
     scale is still in effect.

     For the third step, choose Bound from the menu. The graph
     displays with the new scale in effect. Use the Bound option as
     a toggle to switch between the normal scale and the scale
     specified in the GRAPH.ME file.

     The Bound option is available with line, scatter, and bar
     graphs.

     Log

     Choose the Log option (by pressing the letter T) to change the
     scale along the vertical axis to a logarithmic scale. Choose
     Log again to return to the normal scale.

     The Log option is available with line, scatter, and bar
     graphs.

     Grid

     Place grid lines on your graph by choosing the Grid option.
     Remove the grid lines by choosing Grid again.

     The Grid option is available with line, scatter, and bar
     graphs.

     Xchg

     If you are using multiple variables in your graph, you can
     switch the way the data elements are displayed with the Xchg
     option. Choose Xchg to swap the elements. Choose it again to
     return to the original graph.

     The Xchg option is available with all types of graphs.

     Cum

     Use the Cum option to produce cumulative line and bar graphs.
     This option is most useful when you have multiple variables.
     The Y value of the points for each group at a given position
     on the X axis are totaled to produce this graph.




     PC-File Version 7 Users Guide                            234


     The Cum option is a toggle. Choose the option once to produce
     the cumulative graph, choose it again to return to the normal
     graph.

     The Overlap and Log options become inactive when you display a
     cumulative graph. The Cum option is available with line and
     bar graphs.

     Avg

     Choose the Avg option to draw a line across the graph showing
     the average or mean of all the data. This lets you see which
     points are above the average and which are below.

     To remove the average line, refresh the current graph format.
     For example, if you are viewing a scatter graph, press S to
     display a new scatter graph without the line.

     The Avg option is available with line, scatter, and bar
     graphs.

     Overlap

     The Overlap option lets you produce a somewhat more
     aesthetically pleasing bar graph, in which the bars within a
     group overlap each other.

     Press E to overlap the bars; press E again to return to the
     non- overlapped graph.

     Overlap is inactive for cumulative bar graphs.

     Fit

     To display the trend of your data, choose Fit. This option
     uses the method of least squares to calculate the regression
     line.

     To remove the line, refresh the current graph format by
     choosing the format again.

     The Fit option is available with line and scatter graphs.

     (0-9)Smoothed Avg

     Smoothed averages are used to show trends when you have a lot
     of data which varies considerably.

     Unlike the average line, which shows a single average of all
     the data, a smoothed average is produced by calculating an
     average for each point on the graph based on the values a
     specified number of data points to the left and right of that
     point.




     PC-File Version 7 Users Guide                            235


     The number you select (from 0 to 9) controls the amount of
     smoothing used. The number chosen is the number of points to
     the left and to the right that are included in the smoothed
     average. For example, if you press 2, then 2 points to the
     left, the current point, and 2 points to the right are
     included in the average for each plotted point. The higher the
     number you choose, the greater the amount of smoothing.

     Choosing 0 means that no points to the right or left are
     included in the average and you essentially duplicate a line
     graph. Choosing 9 on a graph with just 9 data points is the
     same as choosing the Avg option.

     You can display as many smoothed averages on your line or
     scatter graph as you want. To remove the lines, refresh the
     current graph format by choosing the format again.

     Aspect

     The Aspect option is used to make your pie charts round, both
     on- screen and printed. This option works by letting you
     adjust the aspect ratio of the circle. Aspect ratio is the
     ratio of height to width. If your pie charts appear elliptical
     rather than round, adjust the height and width with this
     option.

     When you choose Aspect, PC-File displays a screen with a
     circle enclosed in a box. Use this screen to adjust the
     roundness of the pie chart on your monitor only. To adjust the
     roundness of a printed pie chart, press P for Portrait or L
     for Landscape, depending on which format you plan to use. In
     either case, a similar screen displays. However, all three
     screens are separate and adjust the aspect of the pie for
     their respective uses only: the monitor, portrait print, or
     landscape print.

     In all three cases, use the arrow keys to adjust the
     horizontal and vertical dimensions until the circle appears
     round and the box appears square. The box makes it easier to
     tell if the dimensions of the circle are correct.

          The right arrow increases the width

          The left arrow decreases the width

          The down arrow increases the height

          The up arrow decreases the height

     Whichever arrow key you depress, hold it down for a few
     seconds. The degree of change with each keystroke is very
     slight, so you have to give it time to change. This allows you
     to really fine-tune the circle.




     PC-File Version 7 Users Guide                            236


     If you correct the aspect ratio for either portrait or
     landscape printing, you can print out a test circle to check
     it. With the respective screen in view, press P to print.
     Choose your printer from the menu that displays. The line
     inside the circle helps you differentiate between vertical and
     horizontal on your screen versus your printed output.

     Press Q to exit from the screens and return to the pie chart
     itself. Use the Output option to print the chart with the
     corrected aspect ratio.

     The aspect ratios are saved to the file PCG2.ASP and used in
     future graphs.

     Wedge

     You can emphasize specific slices of a pie chart by pulling
     wedges of the pie away from the center. If you are displaying
     multiple pies, the wedge(s) you pull out apply to all the
     pies.

     A new menu displays when you choose Wedge, and one section of
     the pie changes to a solid color. The solid-colored wedge is
     the active wedge.

     Use the menu options as follows:

          Detach the solid slice

          Attach the solid slice

          Skip to the next slice

          Return all detached sections to the center and exit the
          Wedge option screen

          Quit the Wedge option screen, saving your modifications

     Moving around the entire pie also causes you to exit the Wedge
     option screen.

     Disp

     If your pie chart appears cluttered, you can move the heading
     and percentage labels to a separate legend. This can create a
     much more pleasing display.

     The Disp option is actually a three-way toggle. Press D once
     to create a legend and move the heading labels next to it.
     Press D again to add the percent labels to the legend as well.
     Press D a third time to remove the legend and return to the
     original pie chart.

     (1-2)#pies




     PC-File Version 7 Users Guide                            237


     If you graphed multiple fields, each field is displayed on a
     separate pie chart. This option lets you display two pies on
     the screen at one time.

     Press 2 to display two pies on the screen side by side. Press
     1 to display just one pie.

     Next group

     If you graphed multiple fields, each field is displayed on a
     separate pie chart. This option lets you cycle through the
     pies, either one or two at a time, depending on your selection
     for the previous option.

     Editing Graphs

     Generally, if you make a mistake in defining a graph, the
     easiest thing to do is start over again. That's particularly
     true once you have some experience in creating graphs.

     However, there are some other options, though they are
     somewhat limited.

     If you selected the wrong subtotal break or selected too many
     or the wrong records, just rerun the graph. PC-File prompts
     you to rename the subtotal break and select the records to
     graph every time you run a graph you have already created.

     You can also edit the graph files. PC-File produces two files
     when you create a graph:

       FILENAME.GR

       GRAPH.ME

     FILENAME.GR contains the commands you issued as you created
     the graph. Basically, this is the structure of the graph. This
     file is like a report file and can be edited using the command
     format in reports.

     To edit a .GR file:

     1.Change the .GR extension to .REP.

       Use the DOS RENAME command to change the extension while at
       the DOS prompt. (See your DOS manual for information on this
       command.) You can use the Drop to DOS option in PC-File to
       display the DOS prompt.

     2.Return to PC-File and choose Reports from the Print menu.

     3.Choose Modify from the first dialog box, then the Language
       editor from the next one.

     4.Choose the graph file from the file selection dialog box.




     PC-File Version 7 Users Guide                            238


     5.Edit the file just as you would a report.

     6.Return to the DOS prompt and change the file extension back
       to .GR.

     7.Return to PC-File and call up the corrected graph.

     The GRAPH.ME file contains the data from the current graph.
     When you create or display another graph, the data from that
     graph replaces the previous data. Thus, there is just one
     GRAPH.ME file, which is rewritten every time you run a graph.

     You can edit the GRAPH.ME file using any text editor or word
     processing program that saves ASCII (unformatted) files.
     However, it is unlikely you will want to do so, unless you
     need to add a BOUND command (which is explained earlier in
     this chapter).

     If you want to save a particular GRAPH.ME file, rename it
     using the DOS RENAME command so it doesn't get overwritten.
     Change the name back to GRAPH.ME when you want to display the
     graph.




     PC-File Version 7 Users Guide                            239




     CHAPTER 13 UTILITIES

     This chapter covers the first four and the last three options
     on the Utilities menu. Exporting and importing files lets you
     exchange data between PC-File databases and most, if not all,
     of the popular database and spreadsheet programs. File
     management allows you to copy, delete, and rename files within
     PC-File. Use Configuration to set the parameters that
     influence the way PC-File looks and works. Use Pack to remove
     deleted records. Use Repair to fix damaged databases. And, use
     Database Description to document the structure of your
     database.



     Exporting and Importing Files

     Exchanging data with other programs or files is an important
     feature of PC-File. You can import data from and export data
     to just about any of the popular database and spreadsheet
     programs, including Lotus, Multiplan, and Excel. (Since PC-
     File databases are already in dBASE format, no transfer is
     necessary with dBASE files.) You can also move data to and
     from word processing data files used for mail merging,
     including those handled by WordPerfect, WordStar, and
     Microsoft Word.

     Imported data can be added to an empty database or appended to
     existing records. You can also use the import feature to
     append records from one PC-File database to another.

     When exporting data, PC-File creates a new file. Data is not
     appended to an existing file.

     Exchange Formats

     PC-File supports almost a dozen formats for transferring data
     between files. These include the data interchange format
     (.DIF) used by Lotus and Excel for transferring data, comma
     and line delimited formats, ASCII files, and the formats used
     by the major word processing programs for data merge in form
     letters.

     To transfer files to and from programs that don't support one
     of these formats, consult the program's manual and select a
     format common to both. For example, if you want to transfer a
     file in a Paradox format to PC-File, convert the Paradox file
     to the dBASE III format. You can then open it in PC-File, with
     no importing necessary. Whenever possible, convert to a dBASE
     file, as that eliminates the need to import the file in PC-
     File. However, if necessary, you can convert the file to ASCII
     or
     some other format and then convert that to the PC-File format.




     PC-File Version 7 Users Guide                            240


     PC-File can exchange data using the following formats:

     PC-File/dBASE

     PC-File uses the dBASE format, so it isn't necessary to export
     this format. However, you can export using this format to
     easily specify which fields and records to include in a new
     file. You can also use this format in importing. PC-File's
     dBASE import feature provides convenient way to tell PC-File
     where to put the fields from the database you are importing.

     Select this format only when you want to append (import) one.
     DBF file to another. These can be files created using PC-File,
     dBASE III, dBASE III PLUS, dBASE IV, FoxPRO, or any other
     programs that use the .DBF format. PC-File can't open dBASE IV
     files that contain more than 128 fields or float type fields.
     Also dBASE IV memo field data is not compatible.

     DIF

     The data interchange format is used by many spreadsheet and
     database programs for transferring data. These include Lotus
     1-2-3, Multiplan, and Microsoft Excel. For 1-2-3, convert the
     .WKS files to .DIF before making the transfer. For Multiplan,
     convert the SYLK files to .DIF before making the transfer. For
     Excel, save the .XLS file to a .DIF file.

     Fixed length

     Fixed length format is used by many programs which create
     "random" files. Every record is exactly the same length, with
     no delimiters or record separators. The only way to tell where
     one record stops and the next one starts is by knowing the
     exact length of each field. This format is just like the text
     editor format described below, except that the end of each
     record is not marked by a carriage return.

     Mail-merge

     This format consists of data fields separated by commas, with
     quotation marks surrounding fields that contain a comma. The
     end of each record has a carriage-return and optionally a line
     feed. Many word processing programs, including WordStar and
     Microsoft Word, use this format for their data files when
     creating form letters. It is also produced by many BASIC
     programs, and is an export option in many database programs.
     PC-File also gives you the option to put quotation marks
     around all fields,
     for programs that require them.

     Lotus .PRN




     PC-File Version 7 Users Guide                            241


     This is essentially the same format as mail-merge, with one
     exception. In the mail-merge format, if a field is blank or
     empty, nothing is written out except the comma, or, if all
     fields are enclosed in quotation marks, a space appears
     between the quotation marks. In .PRN files, if a character
     field is blank, a pair of quotation marks is written out,
     followed by the comma. If a numeric field is blank, 0 is
     written out. PRN files can be imported into 1-2- 3 by using
     the File Import Numbers
     command sequence in Lotus 1-2-3. The Lotus .PRN format is
     supported on export, but not import. To import a .PRN file
     created by 1-2-3 into PC-File, use the text editor format.

     Line delimited

     This format places each field on a separate line. It's
     sometimes called "field delimited" or "field per line" format.
     The only way to know where one record stops and another starts
     is to know exactly how many fields exist in each record. Each
     record must have the same number of lines. Blank fields are
     stored as blank lines. PeachText uses this format.

     Text editor or SDF format

     This format consists of fixed length fields with no separators
     between fields. The end of each record has a carriage return
     and sometimes a line-feed. This format is produced by many
     text editor and word processing programs, and is an
     export/import option in many database programs. If you were to
     look at a file in this format with your word processor, it
     would look like a columnar or tabular report, with each record
     on a separate line and each field starting at a fixed
     location.

     User-defined delimiter

     This format allows you to exchange data with programs that
     don't use one of the standard formats. You specify the field
     delimiter on import, and the field and record delimiter on
     export. When importing using this format, PC-File assumes the
     record delimiter is either a line-feed or carriage-
     return/line-feed.

     WordPerfect

     PC-File can transfer to or from WordPerfect secondary merge
     files and document files, but in most cases, you want to
     transfer data to and from the secondary merge files. For
     importing files, PC-File detects which version of WordPerfect
     you are using (4.2, 5.0, or 5.1) and handles the data
     accordingly. To export, choose the WordPerfect version you are
     exporting to when prompted.

     ASCII files




     PC-File Version 7 Users Guide                            242


     PC-File can import and export ASCII files. The ASCII formats
     supported by PC-File are fixed length, mail-merge, line
     delimited, text editor (.SDF), and Lotus .PRN


     Exporting Data

     Export data from a PC-File file when you want to use that data
     in another program or format. You can export all the data in
     the file or just selected records. You can also choose to
     export selected fields if you want.

     PC-File lets you select records as you export, viewing each
     record and exporting just those you want. Or you can choose
     just to export all the selected records without looking at
     them. Data is exported in sequence according to the current
     index.

     If you were exporting names and addresses for merging into a
     fundraising letter written in WordPerfect, you could select
     just the name and address fields and leave out extraneous
     fields such as the phone numbers. Plus, you could just select
     those members that live within a specific geographic area.

     The procedures for exporting data are the same for all format
     options except mail-merge and user-defined delimiter. Each of
     these two options requires an additional step, which is
     explained following the basic procedures.

     To export data:

     1.Make sure there is enough space on the receiving disk or
       drive to hold the data you are about to export. Fixed length
       and text editor formats occupy somewhat more disk space than
       .DBF files.

     2.Open the database from which you want to export data. You
       cannot export from a closed database.

     3.Choose Utilities from the menu bar.

     4.Choose Export from the Utilities menu. The export format
       dialog box displays.

     5.Choose the format type you want your exported file to take.
       The file selection dialog box displays.

     6.Choose the path and enter the file name you want to save the
       exported data to.

     7.Refer to additional steps described below if you chose an
       export format of mail-merge or user-defined delimited file.




     PC-File Version 7 Users Guide                            243


     8.Choose to flip the data or not. Choose Yes if the data
       contains a tilde (~) character and you want to flip the
       output. This is most likely in a mail-merge when you want to
       flip first and last names. Choose No if there is no data
       that needs to be flipped.

     9.Choose to export All or Some Fields. Choose Some if you want
       to limit the fields that are exported. PC- File displays the
       database fields in a check-off list box. Choose each field
       you want to export. A checkmark appears next to the fields
       that you choose. If you want to export a portion of a field,
       choose the Options button and designate the portion. Choose
       All to export all the fields in the database.

     10.  Choose to export All or Some Records. Choose Some if you
       want to limit the records that are exported. PC- File asks
       if you want to conduct a simple or formula search for the
       records. Choose the search mode and then enter the search
       criteria or command. See Chapter 7, "Finding and Modifying
       Data," for more information on searching. Choose All to
       export all records in the database, or to choose them as
       they are exported.

     11.  Choose Yes, No, All, or Quit once the export operation
       begins and the first record displays. Choose Yes to export
       the record displayed. Choose No if you don't want to export
       the displayed record. Choose All if you want to export the
       current record and all the remaining selected records
       without being asked again. Choose Quit to stop the
       operation.

     Mail-merge

     Various word processing programs handle the mail-merge format
     differently, so PC-File asks you to define a couple of
     additional options during the export process. The two steps
     below are inserted in the above procedures.

     1.   Choose Yes or No when asked if the first record of the
     exported file should contain the field names.

          Choose Yes if using a program like Microsoft Word, 
          which requires the field names in the first record.

          Choose No if field names are not required.

     2.   Choose Yes or No when asked if you want quotation 
          marks around every field.

          Choose Yes if the program you are exporting to 
          requires quotation marks around every field, even when 
          the field doesn't contain a comma. See your manual if 
          you are unsure about the program requirements.

          Choose No otherwise.




     PC-File Version 7 Users Guide                            244


     Continue on with step 8 in the main export procedures.

     User-defined Delimiter

     As the format name suggests, you get to define the delimiter
     used between fields and between records. A delimiter is a
     character used as a separator between each field and each
     record. The backslash (\) is the character sometimes used in
     non-standard programs.

     The steps below are inserted in the main export procedures.

     1.Choose the field delimiter. If you choose ASCII decimal
       value, PC-File prompts you to enter the value. If you choose
       Keyboard character, PC-File prompts you to enter the
       character. For example, you could choose Keyboard character,
       then enter a backslash in the text box that displays.

     2.Choose the record delimiter. Just as with the previous step,
       PC-File prompts you to enter the ASCII decimal value or the
       Keyboard character if you choose one of them as the option.

     3.Choose Yes or No when asked if the first record of the
       exported file should contain the field names. Choose Yes if
       using a program like Microsoft Word, which requires the
       field names in the first record. Choose No if field names
       are not required.

     Continue on with the rest of the main export procedures.

     NOTE: If you need to export to a format not supported by the
     export function, you can create a report in PC-File that
     converts the data to the correct format. Print the report to a
     disk file. It is then ready for use in the desired format.

     The exported file will have one of the following names:

          PC-File/dBASE  filename.DBF

          DIF            filename.DIF

          Fixed length   filename.FXD

          Lotus PRN           filename.PRN

          Mail-merge          filename.WS

          Line delimited      filename.LD

          Text editor    ilename.SDF

          User-defined   filename.USR

          WordPerfect    filename.WP

     Importing Data




     PC-File Version 7 Users Guide                            245



     You can import files or databases created with other programs.
     You can also use the import feature to append records from
     another PC-File database to the current database. PC-File
     imports the data into the current (opened) database.

     To import data, you have to open an existing database or
     define a new database to which it will be imported. Unlike the
     export process, you cannot create the receiving file (the
     current database) during the import process.

     The format of the import file determines certain requirements
     of the database, as follows:

     If you are importing from the text editor (.SDF) or fixed
     length format, the database must match the import file
     exactly. The database must be defined with the fields in the
     same sequence as they exist in the import file, with the same
     number of fields, and matching field lengths.

     If you are importing from another PC-File database or dBASE
     file, the database must have the same field lengths, but not
     necessarily the same number of fields. PC-File lets you map
     the fields from the database you are importing from to the
     fields of the open database.

     If you are importing from the line delimited format, the
     database must have the same number of fields in the same
     sequence as the file you are importing. Field lengths should
     be at least as long as those in the import file to avoid
     truncation of data.

     If you are importing from any other format, PC-File does not
     require that the import file have the same number of fields or
     matching field lengths, but does require the fields to be in
     the same order. If the import file contains more fields than
     the database, the extra fields are ignored. If the import file
     contains fewer fields than the database, the fields at the end
     of the record in the database are left blank. This is also
     true for field lengths. If the import file contains fields
     longer
     than those defined in the database, data in those fields are
     truncated to the database field length. If the import file
     contains fields which are shorter than the database, the extra
     spaces are filled with blanks.

     The files being imported can have any file extensions, except
     for dBASE files, which must have a .DBF extension, and DIF
     files, which must have a .DIF extension.

     Mapping Field Data from dBASE Files

     This section only applies to importing from dBASE files. If
     you are importing from any other format, skip ahead to the
     "Overview of Importing Process" section for a step-by-step
     description of the importing process.




     PC-File Version 7 Users Guide                            246



     PC-File allows you to readily import files from PC-File or any
     other software product that create dBASE III + compatible
     file. These files must have the .DBF file extension.

     After you have chosen the Normal DBF format and the
     appropriate file to import, the Mapping screen displays.

     If you are familiar with redefining a database structure,
     mapping will be quite familiar. Import mapping is quite
     similar to the process used in redefining a database
     structure.

     The Fields column shows the field name for the open database.
     The Comes From column shows which fields from the imported
     database are mapped to the fields in the Fields column.

     PC-File automatically maps all field names that match. If you
     have identical fields in the open database and the import
     database, you will see the same name in both the New Fields
     and the Come From columns for each identical field. In many
     cases, when PC-File has done the mapping for you, you cam
     simply choose OK to continue the importing process.

     However, if a field does not have a match, the Comes From
     column will be blank for that field-you must choose the data
     source for that field. For example, if you have a field name
     FIRST in the open database, but your import database has a
     field name FIRSTNAME, you must tell PC-File that you want the
     information from the FIRSTNAME to be put into the FIRST field.

     There are two ways to map your fields. You can select them by
     using the List button or by typing field names into the Comes
     From column directly.

     Selecting Fields Using the List Button

     You will need to map any fields that don't have an exact match
     with the fields in the open database. The List button provides
     a simple way to do this. Choosing the List button displays a
     list of the field names from the import database on the right
     side of the Mapping screen.

     The Import Fields List Box shows all the fields from the
     import database. All fields that have already been mapped by
     PC-File have a checkmark next to them. To map a field, put the
     cursor in the Comes From column next to the field in the
     Fields column you want to map. Then, choose a field from the
     Import Fields List. This inserts that field's name into the
     Comes From column.

     To map import fields with the List button:




     PC-File Version 7 Users Guide                            247


     Highlight the text box in the Come From column next to the
     Fields name you want to map. The text box should be empty.
     Choose the List button The Import Fields List displays on the
     right half of the screen. The cursor is active in the list.
     Click on the field you want to map, or navigate to the name of
     the field with the keyboard and press ENTER. The field name
     from the Import Field List is entered into the Come From list
     next to the field you choose in step 1. Repeat steps 1 through
     3 for each
     field you want to map. When you have finished mapping your
     fields, choose OK to continue the importing process.

     Selecting Fields by Typing Names

     Alternatively, you can map fields by simply typing the name of
     the import field in the appropriate Comes From text box. This
     may be a faster method if you are only using the keyboard.
     However, you must type in the name exactly as it is saved in
     the database. You can press ALT-L to display the Import Fields
     List for reference.

     To map your fields by typing names:

     Move the cursor to the text box next to the field you want to
     map. The box should be empty. Type in the name of the field
     that will be mapped from the import file. Repeat steps 1 and 2
     for each field you want to map. When you have finished mapping
     your fields, choose OK to continue the importing process.


     Overview of Importing Process

     To import data:

     Open the database into which the data is to be imported.
     Choose Utilities from the menu bar. Choose Import from the
     Utilities menu. The import format dialog box displays. Choose
     the format of the import file. If you select the User-defined
     delimiter option, PC-File asks you to choose the field
     delimiter; the record delimiter is set automatically as a
     carriage return/line feed. Choose the path and file name of
     the import file in the file selection dialog box. If you chose
     Normal DBF in step 4,
     you must map the fields as described above in, "Mapping Field
     Data from dBASE Files." Choose to append the new records to
     the current database or to overwrite the current database. If
     you choose to append, the imported records are added to the
     current database and will be ordered according to the current
     index. If you choose to overwrite, the current records are
     DELETED and the new records start at record 1. Choose to
     import All or Some records. Choose Some if you want to limit
     the records that




     PC-File Version 7 Users Guide                            248


     are imported. PC- File asks if you want to conduct a simple or
     formula search for the records. Choose the search mode and
     then enter the search criteria or command. See Chapter 5,
     "Finding and Modifying Data," for more information on
     searching. Choose All to import all records in the database,
     or to let yourself choose them as they are imported. Choose
     Yes, No, All, or Quit once the import operation begins and the
     first record displays. Choose Yes to import the record
     displayed. Choose No if
     you don't want to import the displayed record. Choose All if
     you want to import the current record and all the remaining
     records without being asked again. Choose Quit to stop the
     operation.


     NOTE: It is recommended that you choose Yes for the first few
     records to make sure they are being imported properly. If they
     are not, choose Quit to stop the operation. Check to see that
     the current database matches the import file in the ways it is
     supposed to (as described previously). Make whatever
     adjustments are necessary and begin the import operation
     again.




     PC-File Version 7 Users Guide                            249



     Managing Files

     Most people use DOS commands or, if they have Windows, the
     File Manager, to copy, delete, and rename files. However, you
     may find it easier to use the File Management option in PC-
     File to perform those functions on your database files.

     PC-File creates several files as you define a database,
     including a header file, data file, configuration file, memo
     file, and separate files for each index. In addition, every
     report, graph, and letter you create adds a new file. Making a
     copy of all those files using a DOS command could be
     confusing, particularly if you have more than one database in
     a directory.

     With the File Management option, however, PC-File lists the
     files associated with a database and lets you copy, delete, or
     rename those files in groups or, to a limited extent,
     individually.

     You can perform file management functions on either an open or
     closed database.

     Types of Database Files

     Whether you choose to copy, delete, or rename a file or
     database, PC- File displays a list of the types of files in
     the database.

     Choose the option from the list that suits your purpose. The
     Database and Report options include all the files that have
     their file extensions listed. The remaining options only
     include individual files with the extension shown.

     If, for example, you wanted to copy a database to a floppy
     disk, you would choose the first option, Database files. All
     the database files that include the listed extensions would be
     copied to the disk. If you wanted to copy the two database
     reports that you had defined as well, you would have to repeat
     the copy operation twice, once for each report, choosing the
     Report files option from the above list during the process.

     Copying a File

     The Copy option is useful for making backup copies of your
     database, for making a copy to take to another machine, and
     for a variety of other purposes. It is important that you make
     a backup copy of your database(s) and associated files, and
     update the backup on a regular basis. You never know when you
     might need to refer to a backup copy. See Chapter 1,
     "Navigating in PC-File," for more information on backing up
     your database.

     NOTE: If you want to copy your database to make changes to the
     structure, use the Redefine option on the File menu instead.




     PC-File Version 7 Users Guide                            250



     When you copy a database, you must either give the copy a
     unique name or place it on a separate directory or disk from
     the current database. Otherwise you will overwrite the current
     database files.

     Be sure you have enough space for copying the database files.
     If you are copying to a floppy disk and your database takes up
     more space than is available on the disk, you can use the DOS
     BACKUP command, or various software backup utilities.

     To copy files:

     1.Choose Utilities from the menu bar.

     2.Choose File Management from the Utilities menu.

     3.Choose Copy from the File Management dialog box.

     4.Choose the type of file(s) you want to copy.

     5.Choose the file or database that you want to copy.

     6.Enter the drive, path, and file or database name that you
       want to copy to. If you are copying to a different drive or
       path, you can give the file or database the same name. If
       you are copying to the same drive and path, you must give
       the file a new name.

     PC-File copies the file(s).

     Deleting a File

     To delete files:

     1.Choose Utilities from the menu bar.

     2.Choose File Management from the Utilities menu.

     3.Choose Delete from the File Management dialog box.

     4.Choose the type of file(s) you want to delete.

     5.Choose the file or database that you want to delete.

     6.Choose Yes to confirm the deletion. Choose No if you decide
       not to delete the file or database.

     PC-File deletes the file(s).

     When you delete database files, PC-File first looks in the
     header file for the names of the index files. The index files
     are deleted along with the other database files.

     You can delete the database that is currently open. If you do,
     the result is that no database is open.




     PC-File Version 7 Users Guide                            251



     Renaming a File

     To rename files:

     1.Choose Utilities from the menu bar.

     2.Choose File Management from the Utilities menu.

     3.Choose Rename from the File Management dialog box.

     4.Choose the type of file(s) you want to rename.

     5.Choose the file or database that you want to rename.

     6.Enter the new name for the file or database. The name must
       be unique within the directory and follow DOS filename
       rules.

     PC-File renames the file(s).

     Configuring Your Database

     Once installed, PC-File is configured and ready to run. All
     the necessary configuration parameters are defined. Many of
     the parameters, such as screen color and case sensitivity, are
     set by defaults in the program. Others, such as mode of
     operation and printer port, are determined during
     installation.

     However, the configuration parameters can be altered at any
     time. For example, you can change the screen colors, add
     password limitations, or set a default database to open when
     you start PC-File.

     In addition, PC-File lets you define a different set of
     configuration parameters for each database. Thus, you could
     define different color combinations for each database. PC-File
     even lets you define auxiliary sets of parameters that can be
     pulled up for special purposes, such as connecting to an
     alternative printer.

     There are eight basic parameters that can be defined in your
     configuration, some of which include multiple settings. They
     are described briefly here and in more detail later in the
     chapter.

     Parameter: Description

     Display :Turn graphics mode ON or OFF and set your screen
     colors

     Printer: Determine printer port, printer, and page length

     Default Date Format: Set the default display format for date-
     type fields




     PC-File Version 7 Users Guide                            252



     Phone Dialer: Determine the modem port and enter dialing codes
     and prefixes

     Snapshot: Define the mailing label formats and printer port

     Passwords: Define passwords for a database

     Case sensitive: Define whether PC-File distinguishes between
     uppercase and lowercase letters during sorts and searches

     Default database: Open a specific database automatically upon
     starting PC-File


     Configuration Files


     PC-File allows for multiple configurations. Each configuration
     profile is maintained in a separate file. Configuration files
     use the extension .PRO.

     There are three types of configuration files:

     Master profile

     The master configuration file is called PCFILE.PRO. If you
     have only one configuration file, this is it. This file was
     installed with your other program files, and should remain in
     the directory with those files. PCFILE.PRO contains the
     configuration defaults, including those set during
     installation.

     Database profiles

     Profiles associated with specific databases need to be named
     after the database (databasename.PRO). You can define a
     separate profile for each database. If PC-File finds a profile
     of the same name as the database when you open a database, it
     loads the configuration settings in that profile, overriding
     PCFILE.PRO.

     Databasename.PRO files should be located in the same
     directories as the databases with which they are associated.

     Auxiliary profiles

     Auxiliary profiles can also be defined, using whatever name
     you want (as long as you follow DOS filename rules) with the
     extension .PRO. Auxiliary profiles can be loaded as needed.

     Auxiliary profiles can be located anywhere, as you can define
     the path when you load them. However, if an auxiliary profile
     is associated with a specific database, it is easiest to
     locate the profile in the same directory as the other database
     files.




     PC-File Version 7 Users Guide                            253



     Why Define Additional Profiles?

     PCFILE.PRO may prove to be the only configuration profile you
     need. If you define and use just one database, you can fit the
     configuration to that database. You can always modify it if
     you buy a new printer, add a modem, or simply want to change
     your screen colors. You can also modify it temporarily. For
     example, you could switch your screen colors for a few
     sessions, then switch back.

     Even with several databases, the master profile may prove to
     be all you need. It's when your system gets more sophisticated
     that multiple profiles begin to become useful. The most likely
     reasons for using several profiles are:

     Using more than one printer Using passwords in multiple
     databases Defining separate snapshot label layouts for
     different databases

     Database profiles are practically a necessity for using
     passwords, which are normally designed to limit access to a
     particular database or part of a database.

     There may be other reasons for defining multiple profiles as
     well. One particular database may require case sensitivity in
     sorting, while others may not. Or you might want to define
     different color schemes for each database, making it always
     easy to tell which one is open.

     Which Profile is Current?

     When you choose Configuration from the Utilities menu, the
     current configuration profile displays on the screen. However,
     it is important to understand which profile gets loaded when,
     without having to call up the screen to read the title bar.
     The following guidelines apply:

     PCFILE.PRO is loaded automatically when you start PC-File, as
     long as you start PC-File from a directory containing a copy
     of PCFILE.PRO. (You can copy the master profile to as many
     directories as you want.) Thus, if you have set the path for
     PC-File in your AUTOEXEC.BAT file and start the program from
     some other directory, copy the master profile to that
     directory.

     If you start PC-File from a directory that doesn't contain
     PCFILE.PRO, no profile is in effect. In that case, PC-File
     assumes certain defaults. These defaults are listed below.

     If you have created a databasename.PRO, that profile takes
     effect when you open the associated database, as long as the
     profile is in the same directory. The database profile
     overrides PCFILE.PRO, but only to the extent that it differs
     from the master profile.




     PC-File Version 7 Users Guide                            254


     If PC-File can't find a profile on the current directory, it
     assumes certain defaults. The defaults are:

     Parameter: Default

     Display mode:  Graphics (VGA, EGA, and Hercules-compatible
     monochrome); Character (CGA)

     Display colors:  Nautical (VGA, EGA, and CGA); Black & White
     (mono)

     Printer port:  LPT1

     Page length:  66

     Default Date Format:  MM/DD/YYY (Month-Day-Year, 4-digit, and
     Slash)

     Modem port:  COM1

     Long distance code:  1

     Modem dialing code:  ATD

     Case sensitive searches:  Off

     Case sensitive indexes Off


     The Configuration Window

     You can open a configuration window whether a profile is
     currently loaded or not. The configuration window is a dialog
     box with a menu bar.

     To open the configuration window:

     1.Choose Utilities from the menu bar.

     2.Choose Configuration from the Utilities menu.

     The window displays the different parameters that you can set.
     The three command buttons in the lower left corner of the
     window display dialog boxes.

     The Configuration Menu

     The menu bar at the top has two options. Help! displays a Help
     window. The File option displays a pull-down menu of options.

     Use the options on Configuration menu as follows:

     Option:  Description

     Load:  Load and display an existing profile




     PC-File Version 7 Users Guide                            255


     Save:  Save the current profile

     Save As:  Save the current profile to a new name

     Exit:  Quit the configuration window


     The options on the File menu are explained below.

     Loading a Profile

     Loading an existing profile and displaying it on the screen
     are a single operation.

     To load and display a profile:

     1.Choose File from the configuration window menu bar.

     2.Choose Load from the File menu. The file selection dialog
       box displays.

     3.Choose the profile you want to open.

     The profile is loaded into memory and displayed on the screen.

     To close the configuration window, choose Exit from the
     configuration window File menu. The window closes, but the
     profile remains active.


     Modifying a Profile

     To modify a profile, display the configuration window and make
     your changes to the parameters. If the profile you want to
     modify is currently loaded into memory, all you have to do is
     display it on the screen. If you want to modify another
     profile, you must first load that profile. Follow the
     procedure outlined above for loading a profile.

     Once you modify a profile, you must save your changes.
     Choosing Save from the File menu saves to the name you loaded,
     choosing Save As allows you to save to a new name.

     To save a modified profile to its original name:

     1.Choose File from the configuration window menu bar.

     2.Choose Save from the File menu.

     The profile is saved.

     To save a modified profile to a new name:

     1.Choose File from the configuration window menu bar.

     2.Choose Save As. The file selection dialog box displays.




     PC-File Version 7 Users Guide                            256



     3.Enter a new name in the text box.

     The changes you made are saved to the new name.

     Creating a New Profile

     You can create a new profile in the same manner as you modify
     an existing one, except you give the profile a new name. You
     would only use this method to create an auxilliary profile
     that is loaded on demand.

     To define a new profile:

     1.Display the configuration window.

     2.Make any necessary changes to the parameters.

     3.Choose Save As from the File menu.

     4.Enter a new name for the profile in the text box.

     The new profile is now loaded in memory.


     The Configuration Parameters

     When you choose Configuration from the Utilities menu, the
     configuration profile currently loaded in memory displays.

     Each of the profile options is explained below.

     Display Mode

     PC-File operates in two modes: Graphics mode and Character
     mode. Graphics mode is designed for VGA, EGA, and Hercules-
     compatible monochrome monitors, Character mode for CGA
     monitors. PC-File determined which type of monitor you were
     using when you installed the program and set the mode
     accordingly. You can switch modes in certain cases, however.
     When you can switch and why you might want to are explained in
     Chapter 1, "Navigating in PC-File."

     To switch modes:

     1.Choose the Graphics mode check-off box.

     PC-File is operating in graphics mode when the box is checked,
     in character mode when it's not. However, you have to exit PC-
     File and start it again for a change in mode to take effect.

     Screen Colors




     PC-File Version 7 Users Guide                            257


     PC-File provides four pre-defined color schemes, allowing you
     to change the color patterns on your screen. Each color scheme
     includes pre-set foreground and background color settings.
     Additionally, PC- File provides the Customize option that lets
     you specify the colors for particular screen elements so you
     can customize your screen colors.

     The Nautical color scheme is the default for all color monitor
     cards; Black & White is the default for Hercules cards. If you
     have a CGA card with a monochrome monitor or an LCD, you might
     want to switch to Black & White if you didn't during
     installation.

     To select a pre-defined color scheme:

     1.Choose the option button you want.

     The colors on your screen change immediately to reflect your
     choice.

     Customizing Screen Colors

     Choosing the Customize button to the right of the User option
     button displays the Design Colors dialog box.

     Choosing an option in the list box sets either the background
     or the foreground color of the designated screen element (with
     the exception of Window Border, which has only one option).
     When you choose an option from the list box, that option is
     highlighted and a checkmark displays to its left indicating it
     is active. The 16 colored buttons to the right of the list box
     both set and indicate the current color of the active screen
     element. An "X" on the color button indicates which color is
     active for the current screen element.

     To set colors, choose an item from the list, then choose the
     desired color button. New color settings are effective
     immediately, reflected in the colors of the Design Colors
     dialog box and screen areas visible behind it.

     If you make a color choice that makes the screen unreadable,
     such as choosing the same color for both the background and
     foreground of a screen element, choose another color button.
     If you decide you don't like the color choices you have made
     and want to start over, press ESC or choose Cancel. This
     returns you to the main Configuration window and restores your
     original colors. Choosing Customize again at this point re-
     displays the Design Colors dialog box.

     To customize screen colors:

     1.Choose Customize.

     2.Choose a screen element to change from the list box.

     3.Choose the desired color button.




     PC-File Version 7 Users Guide                            258



     4.Repeat steps 2 and 3 for each area you want to customize.

     5.Choose OK when you are done setting colors.

     Printer

     These parameters let you set the default page length, printer,
     and printer port for your system. You can override these
     defaults when you print a report, letter, graph, or set of
     mailing labels if necessary.

     To set printer defaults:

     1.Enter a default page length if different than 66 lines per
       page. Sixty-six is the standard page length for a dot matrix
       printer. If you use a laser printer, you probably want to
       set the page length at 60. If you use paper of a different
       length, or your printer uses a different line spacing,
       adjust the page length accordingly.

     2.Choose the printer from the list box. If your printer is not
       listed, press F1 to display the Help window. A list of
       printers compatible with those shown in the list box
       displays. If you still don't see your printer, and your
       printer manual doesn't mention one of the listed printers as
       compatible, choose User codes from the list. A dialog box
       displays, allowing you to define the printer codes yourself.
       Your printer manual If you intend to print to disk rather
       than to a printer, choose No codes. Printer codes appear as
       scrambled text and symbols when printed to a file, so it is
       better to omit them.

     Choose the printer port.

     Default Date Format

     PC-File provides you with convenient ways to format your
     dates. Using the Default Date Format options in the
     Configuration window, will apply to any date fields which
     don't have Date Format field attributes set with the Field
     Attributes option on the File menu. To have all your date
     fields display in the same format, use the Default Date Format
     options in the Configuration window.

     The default format is Month-Day-Year order, four digit year
     and slashes (/) as separators. The resulting date for December
     29, 1961, would be as follows:

     12/29/1961

     You change your default date format by changing each of the
     elements of the format: order, year and separator. Make the
     choice for each element that accurately reflects your desired
     date format.




     PC-File Version 7 Users Guide                            259


     PC-File can accomodate many date formats including those used
     throughout Europe and Japan. In Switzerland, you might choose
     Day- Month-Year order, four digit year, and period (.) as a
     separator. The resulting date would be as follows:

     29.12.1961

     To set the default date format:

     1.Choose an order for month, day and year.

     2.Choose either two or four digit years.

     3.Choose a separator to use between the elements.

     Phone Dialer

     If you use the autodialing feature of PC-File, you'll want to
     check the dialer parameters in your configuration profile. You
     can define the modem port, dialing code, long distance prefix,
     and access prefix. Some of these parameters have defaults that
     you may need to change.

     To define dialing parameters:

     1.Choose the Phone dialer command button from the
       configuration window. A dialog box displays.

     2.Define the parameters to fit your system.

     3.Choose OK.

     The dialing parameters are defined as follows:

     Dialing port

     PC-File assumes your modem is connected to the COM1 port. If
     it is connected to one of the other COM ports, change the
     profile accordingly.

     Modem dialing command

     The dialing command activates the modem. It essentially tells
     the modem that you are about to make a call. The default
     dialing command is ATD. ATD is used with Hayes-compatible
     modems to make either pulse or tone calls. You can change the
     command to ATDT if you want to force the modem to use tones, a
     slightly faster process. You must have a touchtone phone, in
     that case. You can enter other codes if necessary. See your
     modem manual for more information.

     Line access prefix

     The line access prefix is the number required to dial outside
     of your office telephone system. Most often this is the number
     9. Enter the appropriate prefix for your telephone system.




     PC-File Version 7 Users Guide                            260



     Long distance prefix

     The default long distance prefix is 1. If your particular
     phone system requires a different prefix, enter that here.

     PC-File sends the long distance prefix when dialing phone
     numbers that are 10 digits or longer, unless the phone number
     begins with a zero. For long distance calls outside of the
     U.S. and Canada, incorporate the long distance prefix into the
     phone number in your database. When PC-File reads a number
     that starts with 0, it skips the long distance prefix in your
     configuration.

     Also, you should enter "1" in your phone number field for long
     distance calls within your area, unless your phone company
     requires you to dial the local area code for long distance
     calls. If your phone company requires area codes for all long
     distance calls, enter the area code in your phone number field
     for all long distance numbers and PC-File will automatically
     send the long distance prefix.

     Snapshot

     The snapshot feature lets you print mailing labels one at a
     time. If you intend to print snapshot labels, you must follow
     these initial steps:

     1.Define the label report.

     2.Assign the label report to a snapshot.

     3.Define the output (printer port or file).

     Steps 2 and 3 are implemented in the configuration profile,
     and are explained here. Defining a label report is covered
     Chapter 9, "Using the Mail Label Format." Printing a snapshot
     is discussed in greater detail in the section on snapshot
     labels in Chapter 15, "Tools."

     You can assign up to five labels in a profile. Each label is
     assigned to a number, which you select when you print the
     label.

     Labels are normally assigned within a databasename.PRO file,
     as you would generally associate a label with a particular
     database. However, you can assign labels in PCFILE.PRO if you
     expect to use them with several databases that share the same
     field names, or if you only have one database.

     To assign a label and define the output:

     1.buttons Choose the Snapshot button. A dialog box with five
       numbered displays.




     PC-File Version 7 Users Guide                            261


     2.Choose the number to which you want to assign the label. A
       file selection dialog box displays.

     3.Choose the report upon which the label is based. The output
       dialog box displays.

     4.Choose the printer port or file.

     If you choose file, PC-File prompts you to name the file.
     Repeat these steps for each snapshot label.

     Passwords

     PC-File allows you to define passwords to prohibit access to
     specific operations within the program. You can define
     passwords for all your databases, or for specific databases.

     The passwords do NOT protect databases from being accessed by
     unauthorized persons. Passwords in PC-File are mainly designed
     to prevent users from accidentally performing operations that
     they don't normally do.

     If you define a password for a particular function, you must
     enter the correct password when you access that function. For
     example, if you define a password for adding data, PC-File
     prompts you for the password when you choose Add on the Edit
     menu. If you don't enter the correct password, PC-File won't
     let you add new records.

     To prohibit access to certain operations within a specific
     database, define a database profile and determine your
     passwords within that profile. If you want to prohibit access
     within all your databases, you can define passwords within the
     master profile. If you don't define passwords for a database,
     all users of the database can perform any operation on that
     database.

     You can control access to the following operations with
     passwords:

       Adding records (Add)

       Modifying records (Modify)

       Deleting records (Delete)

       Opening the database (Read)

       Accessing the Utilities menu options and the record, modify,
       and delete macro options (and associated hot keys).
       (Utilities)

       Accessing the Print menu options (Print)




     PC-File Version 7 Users Guide                            262


     PC-File passwords are from one to three characters long and
     can include any character on the keyboard. Here are some valid
     passwords:

          TED

          JR

          911

          ?%#

          Hi!

     Passwords are not case sensitive, so you can type in Ted, ted,
     or TED for the password TED.

     If you want, you can use the same password for all password
     options.

     NOTE: If you define passwords, write your passwords down
     somewhere. It's embarrassing to get locked out of your own
     database.

     To define passwords:

     1.Open the appropriate profile.

     2.Choose the Password command button in the configuration
       window. The password dialog box displays.

     3.Type in a password in the text box for each operation that
       you want to control. Passwords display in the Password
       dialog box; however, they don't display as you type them in
       when accessing a restricted part of the program.

     4.Choose OK.

     Case Sensitive

     PC-File normally treats uppercase and lowercase letters the
     same throughout the program. However, you can require that PC-
     File distinguish between the two during searches and/or sorts.

     With case sensitive searching, PC-File finds records based
     precisely on how you enter the search criteria. For example,
     if you request all records for WALLA WALLA, records for Walla
     Walla and walla walla are not displayed as a result of the
     search.




     PC-File Version 7 Users Guide                            263


     With case sensitive indexing, PC-File sorts records based on
     the rule that uppercase letters precede lowercase letters. For
     example, BOTHELL would come before Bellevue, as an uppercase O
     comes before a lowercase e. For the same reason, anchorage
     would follow Tacoma in a sorted list, and les Baux would
     follow Zurich. If you change case sensitivity, you have to
     rebuild existing indexes, using the Index option on the File
     menu, for the change to take effect.

     To turn case sensitivity ON:

     1.Place a check in the appropriate box by choosing it.

     Generally, if you want case sensitivity, you would select it
     for both searches and sorts.

     Default Database

     If you use a particular database all or most of the time, you
     can prompt PC-File to open that database for you automatically
     when you start PC-File.

     Define a database default in the master profile (PCFILE.PRO)
     only. Defining a default database in a database profile is
     redundant, as a specific database profile doesn't get loaded
     until the database is opened.

     To enter a default database:

     1.Type the drive, path, and database name in the appropriate
       text boxes.

     Enter only the drive letter; no colon is necessary. However,
     the backslash is necessary before a directory name.

     You can define just the drive or just the drive and directory
     if you want. A default path provides a shortcut if you use
     several databases regularly that are located on the same drive
     or even in the same directory. It makes opening the database
     just a little bit quicker.

     Advanced Profile Parameters

     Configuration profiles are relatively easy to understand and
     define when viewed in the configuration window. However, a
     profile can also be edited or viewed with a text editor (or
     word processing program). Profiles viewed through a text
     editor display the parameters as commands, rather than
     buttons, check boxes, or other forms that they take in the
     configuration window. For example, to select a printer port in
     the configuration window, you choose one of the seven option
     buttons. The same
     parameter is represented by the command /PRPORT,x (where x is
     the name of the printer port) when viewed with a text editor.




     PC-File Version 7 Users Guide                            264


     The major reason for accessing a configuration profile with a
     text editor is that you can add several parameters here that
     you can't add in the configuration window.

     Editing a Profile With a Text Editor

     To edit a profile with a text editor, start the editor and
     open the appropriate .PRO file. You will see a file that looks
     like this:

     /VIEW,R
     /PAGELEN,66
     /PHPORT,COM1
     /PHINIT,ATD
     /PHLONG,1,
     /PRPORT,LPT1
     /PRINTER,No_Codes

     Only parameters you have changed appear in the file. The
     defaults are stored within the program and do not show up in
     this file.

     You can add parameters to the file by typing them in at the
     end of the current text. Place each parameter on a separate
     line.

     Hidden Profile Commands

     Several parameters that you can't add in the configuration
     window can be added when you use an editor. These parameters
     are:

     /MEMOW,n

     Sets the width of the memo field edit window. For example, to
     set the width of the window to 75, type /MEMOW,75 in your
     profile. The maximum width is 78 chartacters.

     /NOSNOW

     Changes the way PC-File displays on some CGA monitors to
     prevent flickering or "snow."

     /NOXMS

     Prevents PC-File from using extended memory.

     /NOEMS

     Prevents PC-File from using expanded memory.

     /READONLY

     Sets the default on the Edit menu to Read-only mode.

     Adding Commands at the DOS Prompt




     PC-File Version 7 Users Guide                            265



     You can change any configuration parameter for the current
     session of PC-File by adding that parameter to the command
     when you start the program. For example, you could enter pcf
     /COLOR,4 at the DOS prompt. The command "pcf" starts PC-File
     and /COLOR,4 tells the program to change the colors for the
     current session from the current default to black & white.
     Separate pcf from the rest of the command(s) with a space. If
     you need to include more than one command, separate each
     command with a comma (but no space).

     Entering a configuration command at the DOS prompt overrides
     the current default, but does not change the setting in the
     profile. The next time you start PC-File, the original setting
     takes effect.

     You can also set up a batch file containing specific
     configuration parameters that you want to use at specific
     times. In a batch file, enter all parameters on one line, like
     this:

     pcf /NOSNOW, /READONLY, /CHARMODE



     Configuration Command Summary

     The following table lists all of the configuration commands.
     You can enter these commands in a configuration profile file
     or at the DOS prompt when starting PC-File.

     Precede all commands with a forward slash (/) and enter the
     commands in uppercase letters. Commands that take variables
     are indicated with an x or n following the command. An n
     indicates a number or string of numbers separated by commas
     (e.g. /LANDSCAPE, 27,38,108,49,79), an x indicates a string
     variable. Use a comma between the command and the variable,
     with no space.

     For example, to define a password for data entry, you might
     enter /ADDPW,jdh. The variable, jdh, is the password you are
     defining.

     Command Explanation

     /ADDPW,x Define password for data entry

     /BOLD,n Define print codes for boldface type

     /CASEFIND Set case sensitivity for searches

     /CASESORT Set case sensitivity for sorts

     /CHARMODE Set character mode of operation

     /COLOR,n Set color palette




     PC-File Version 7 Users Guide                            266



     /CONDENSED,n Define print codes for condensed type

     /DATEFORMAT,x Define default date format

     /DELPW,x Define password to allow deletions

     /DOUBLEWIDE,n Define print codes for wide type

     /DRIVE,x Define default drive

     /FILE,x Define default database

     /ITALIC,n Define print codes for italic type

     /LANDSCAPE,n Define print codes for landscape format

     /MEMOW,n Define the default width of the memo field edit
     window

     /MODPW,x Define password for Modify mode

     /NORMAL,n Define print codes for normal type

     /NOEMS Prevents use of expanded memory

     /NOXMS Prevents use of extended memory

     /NOSNOW Prevents snow on some CGA monitors

     /PAGELEN,n Define page length

     /PATH,x Define default path

     /PHINIT,n Define dialing initialization code

     /PHPRE,n Define phone line access prefix

     /PHPORT,x Define modem port

     /PHLONG,n Define long distance code

     /PORTRAIT,n Define print codes for portrait print

     /POSTSCRIPT Set for PostScript output

     /PRINTPW,x Define password to allow access to Print menu

     /PROPORTIONAL,n Define print codes for proportional font

     /PRPORT,x Define printer port

     /READONLY Set read-only mode as default

     /SNAP1,x Assign first snapshot label report




     PC-File Version 7 Users Guide                            267


     /SNAP2,x Assign second snapshot label report

     /SNAP3,x Assign third snapshot label report

     /SNAP4,x Assign fourth snapshot label report

     /SNAP5,x Assign fifth snapshot label report

     /SYSPW,x Define password to allow access to Utilities menu

     /UNDERLINE,n Define print codes for underlined type

     /USEPW,x Define password to open database

     /USER1,n Enter user-defined print codes

     /USER2,n Enter user-defined print codes

     /USER3,n Enter user-defined print codes

     /USER4,n Enter user-defined print codes

     /USER5,n Enter user-defined print codes


     If you are using a profile defined in a previous version of
     PC-File, some commands may appear that are not described on
     the list above. These commands, such as /FG (foreground
     colors) and /BG (background colors), have been replaced or
     phased out. They are ignored by the program.


     Packing a Database

     When you delete records, PC-File removes the records from view
     and internally marks them as deleted, but they remain in the
     database file (.DBF). This allows you to reclaim accidentally
     deleted records using the Undelete option on the Edit menu.
     The marked records are still counted as part of the database
     after deleting them. This is reflected in the number of
     records displayed at the bottom of the main screen and printed
     in reports.

     To remove deleted records from the database permenantly, you
     mus use the Pack option on the Utilities menu.

     If the database has memo fields, packing also affects the size
     of a database's .DBT file by removing any unused memo entries
     from the .DBT file. Unused memo entries can arise (1) if
     records with memo entries are deleted, or (2) if a memo is
     edited in such a way that the disk space the memo originally
     occupied cannot be reused.

     How Packing Works




     PC-File Version 7 Users Guide                            268


     First, PC-File renames the original database to a temporary
     name. Then, the active records are copied to new files using
     the original file names. At minimum, the active records in the
     .DBF file are copied. If your database has memo fields, the
     active memos in the .DBT file are also copied. Because packing
     generates new data files without deleting the originals,
     completing the packing operation requires about as much
     available disk space as the original database occupied (this
     can be somewhat less depending on how many records and memo
     entries will be removed by packing). Once the .DBF and .DBT
     files are packed, PC-File rebuilds all indexes for the
     database and returns you to the database, if the database was
     open when you started packing. If the database was not open
     when you started packing, indexes are rebuilt the next time
     the database is opened.

     If you have a large database, packing may take a long time.
     This will vary depending on the number of records removed, the
     complexity of the indexes that need to be rebuilt, and the
     speed of your system. In this case, you may want to consider
     running the packing operation overnight.

     PC-File renames the original database files to names in the
     format TMPnnnn.xxx, where "nnnnn" is some number that will
     create unique file names and "xxx" is the appropriate
     extension (at minimum, .DBF and .HDB, also .DBT if the
     database has memo fields). PC-File does this as a security
     measure to ensure that the original database cannot be damaged
     if you lose power during the packing operation. The TMPnnnn
     name is displayed in a message that appears at the end of the
     packing operation. Write
     down the TMPnnnn name so you can delete the database with the
     Utilities, File Management option once you are certain the
     packing operation was successful.

     To be more secure, you may want to copy the TMP files to a
     backup disk and rename them to their original names before
     deleting them. Assuming the files will fit on the drive you
     copy them to, you can copy and rename in one operation using a
     DOS command in the form:

     COPY c:\path\TMPnnnn.* d:\path\originalname.*

     where "c:\path" is the location of the original file,"TMPnnnn"
     is the name PC-File displayed at the end of the packing
     operation, "d:\path" is the drive and path you want to copy
     to, and "originalname" is the original name of the database.
     For example, if you packed a file named CLIENTS located on
     c:\pcfile\data that was renamed TMP27, you could copy and
     rename the original files to your A drive using this command:

     COPY c:\pcfile\data\TMP27.* a:CLIENTS.*

     NOTE: This command only renames the copied files on drive A,
     the TMP27 files would remain in c:\pcfile\data and those are
     the files you would delete to free disk space.




     PC-File Version 7 Users Guide                            269



     As an alternative to this procedure, you may want to backup
     your database files before packing.

     To pack a database:

     1.Open the database you want to pack. If no database is open
       when you choose the Pack option, PC-File will prompt you to
       choose the database you want to pack using the Open a File
       dialog box.

     2.Choose Utilities. C

     3.hoose Pack.

     4.Choose Yes to start the packing process.

     5.Note the TMP name of the original database and delete it
       with the Utilities, File Management option once you are
       certain that packing was successful. Alternatively, copy all
       files with this name (.HDB, .DBF, and possibly .DBT) as a
       backup, before deleting them.




     PC-File Version 7 Users Guide                            270



     Repairing a Database

     The Repair utility exists to correct certain kinds of damage
     that can occur to a database file. However, you should not
     assume that the Repair utility can correct all forms of file
     damage, or that this means you do not have to maintain regular
     backups of your files. Above all else, making regular backups
     of your database-ideally as often as the database is modified-
     is your best means of data security. See "Backing Up Your
     Database" for some suggestions on ways to back up databases.

     Even if you backup regularly, there may be times a database
     file becomes damaged before it has been backed up. In this
     case, the following procedures might allow you to reclaim a
     damaged database.

     Some of the signs that indicate your database file may be
     damaged are:

       "Garbage" characters (characters other than letters, numbers
       or punctuation) appear in your data, or data is lost.

       PC-File will not open your database (typically PC-File
       displays an error message with error code 4097 in this
       case).

       PC-File displays an error message (typically with error code
       4097) when making new indexes or re-building old indexes.

       PC-File indicates fewer records than should be in the
       database.

       PC-File cannot locate records you know exist.

     Preliminary Steps

     In many cases, the problem lies not in the data file, but in
     problems with one or more of the index files. This can be
     caused by someone turning off the computer without properly
     exiting PC-File (using Exit on the File menu), or by power
     loss or a power surge while PC-File is running.

     If PC-File can't open your database, follow the procedures
     described under "To Repair a Database" below. If PC-File can
     open the database, try rebuilding the indexes using the
     following steps before trying anything else:

     To rebuild all indexes

     1.Open the database.

     2.Choose File.

     3.Choose Index Maintenance.




     PC-File Version 7 Users Guide                            271


     4.Choose Rebuild All.

     If your database continues to have problems, the next thing to
     check is to make sure that the problem is not due to an error
     in the way DOS is storing the data file. For example, if DOS's
     file information indicates that the data file is smaller than
     it actually is, PC-File will not be able to read all the
     records in the database. To cover this possibility, the next
     thing to try is to run the DOS CHKDSK utility using the /F
     parameter to make sure that DOS's file information is correct.

     WARNING: Before running CHKDSK /F, you MUST quit all the way
     out of PC-File using Exit on the File menu and exit any other
     program running "on top" DOS, such as Microsoft Windows or a
     menu program. Failure to do so can damage files.

     To run CHKDSK against your database:

     1.Make a backup of your database.

     2.Exit all the way out of PC-File (using Exit on the File
       menu. DO NOT use CTRL-D or Drop to DOS on the Tools menu)
       and exit any program running "on top" of DOS such as
       Microsoft Windows or a menu program.

     3.Run the DOS CHKDSK /F command to correct logical file errors
       (refer to your DOS manual for details).

     4.Rebuild all indexes as described above.

     NOTE: As an alternative to the above procedure, you can use a
     third- party utility program (such as Norton Utilities, PC-
     Tools, SpinRite, etc.) to correct file and disk errors.


     Using Repair

     If your database still has problems after trying the two
     procedures above, damage may have occurred to your database's
     data files (.DBF and .DBT). The reasons this can happen are
     numerous, but are typically due to something that damages the
     magnetic information that is stored on your hard drive or
     floppy disk. For example:

     Loss of power during a disk operation.

     Wear and tear on the hard drive surface

     Physical shocks and poor handling of the hard drive can cause
     "head crashes" which literally scrape data from the hard
     drive's platters. Likewise, floppy disks can eventually wear
     out or become physically damaged.

     Magnetic damage, static discharge, or power surges




     PC-File Version 7 Users Guide                            272


     These environmental influences can erase or corrupt the
     magnetic information on a disk.

     "Track Drift" or old formatting

     When you first purchased your hard drive, it was either
     formatted at the factory or by a technician. The formatting is
     the filing system that shows your computer where it can store
     new files and keeps track of where old files are stored. Over
     time the tracks of the formatting can drift as the bearings of
     the hard drive wear, or the formatting (which is magnetic
     information itself) can fade or become damaged.

     Hardware errors in the disk controller

     The disk controller, the part of your computer which controls
     all access to disk drives, can damage or lose files if it
     isn't working properly.

     Program errors

     An error in any program, or conflicts between simultaneously
     running programs, can potentially damage disk information.
     Errors and conflicts which damage files can occur when
     software accesses the disk, or causes a conflict in RAM. This
     includes any of the following: application software, such as
     databases, spreadsheets, or word processors; errors or
     conflicts with memory-resident software (TSR's and device
     drivers) such as screen blankers, disk caching, task
     switching, menus or shells, memory
     management programs, or drivers for special hardware support;
     or errors in operating system software, DOS's or windowing
     OS's.

     If the damage was relatively minor, and there is no ongoing
     hardware problem or disk formatting error, you can generally
     repair damage with the following steps.


     To Repair a database:

     1.Make a backup copy of your database.

     2.Run the DOS CHKDSK /F command on the disk where your data
       resides directly from the DOS command line.

     3.WARNING: You MUST fully exit PC-File using Exit on the File
       menu-NOT CTRL-D or Drop to DOS on the Tools menu. Fully exit
       any other programs running "on top" of DOS, such as Windows
       or menu programs, before running the CHKDSK /F command-
       failure to do so could cause further problems.

     4.Correct any problems the CHKDSK command reports before
       proceeding. Refer to your DOS manual for details on the
       CHKDSK command.




     PC-File Version 7 Users Guide                            273


     5.Start PC-File and open the damaged database using the File,
       Open menu sequence. If PC-File will not open the database,
       proceed to step 4.

     6.Choose Utilities.

     7.Choose Repair. If you were unable to open the database in
       step 3, a file selection dialog box is displayed. Choose the
       database to repair at this point and choose OK.

     8.Choose Yes to scan for illegal characters.

     A status box displays showing the rate of progress. Some
     errors are automatically repaired. These errors and repairs
     are reported as they are encountered. Other errors present an
     option in this format:

          Error: This database has: problem

          PC-File can attempt to repair this problem, but doing so
          might further damage the database.

          If you have not made a backup of this database DO NOT
          choose Yes to proceed.

          If you have made a backup, you can safely choose Yes.

          Should PC-File attempt this repair? (Yes/No/Cancel)

     where "problem" is a brief description of the error in
     question. Correcting errors of this type might cause further
     damage to the database, because PC-File has to make certain
     assumptions that might be incorrect. You should only proceed
     with these options if you performed all preliminary steps:
     making a backup and correcting file errors with CHKDSK /F or a
     third-party utility program.

     An information box displays at the end of the Repair process
     indicating what repairs were done. PC-File tests the indexes
     and rebuilds them, if necessary.

     If your database still has problems after performing all of
     the above procedures, try packing the database as described in
     the section "Packing a Database." Only do this after trying
     all of the above procedures. If using Repair seemed to make
     the problems worse (this is possible if the assumptions Repair
     uses are inappropriate for the detected problem), restore a
     backup of your database before packing. Packing generates a
     new copy of the database, which can correct some problems that
     Repair
     does not correct due to risk to the original file.




     PC-File Version 7 Users Guide                            274


     If you still have problems after performing all the above,
     your file might be irrevocably damaged. Repair utilities such
     as Ashton-Tate's dBASE File Recovery, or other dBASE file
     recovery programs can perform more involved repair procedures
     that might allow you to reclaim the database. It is also
     possible that hardware or disk errors might be the source of
     the problem-run a diagnostic program or contact a technician
     if you suspect this is the source of your problem. Assuming
     your hardware is fine and your database cannot be recovered
     with PC-File's Repair command, Pack command, or a third- party
     repair utility, your only recourse is to restore your most
     recent backup of the database.

     Database Description

     PC-File lets you print a description of your database, listing
     the fields and the relevant information about each field. Data
     contained in the fields is not printed, just information on
     the fields. This feature can be useful when redefining or
     creating a database, or just as a reminder of field length and
     type. In fact, it's a good idea to keep on hand a printed
     description of each of your databases.

     The Datebase Description has five main parts:

     Database Structure

     This section shows the database's field names, a letter for
     the field type (C=Character, N=Numeric, D=Date, L=Logical, and
     M=Memo), the data length, and decimal place (only for numeric
     fields).

     Indexes

     This section shows the index search field, followed by the
     description with the index dBASE expression under it.

     Field Attributes

     This section lists any fields that have field attributes
     assigned, which attributes are associtated with the field, and
     the "when" assignments for the each attribute.

     List of Views

     This section lists all views in the database and their type.

     Pictures of Custom Record Views

     If there are any Custom Record views defined for the database
     a "picture" of each view is printed. If there are no Custom
     Record views, this section is omitted.

     The Database Description option gives you three output
     options:




     PC-File Version 7 Users Guide                            275


     Printer Prints your database's description using the printer
     indicated by the current profile.

     Screen Displays your database's description on screen

     Disk Stores your database's description in a disk file

     To produce a database description:

     1.Choose Utilities.

     2.Choose Ddatabase Description.

     3.Choose the database you want a description of, if no
       database is currently open.

     4.Choose Printer to print your database description. Or...
       Choose Screen to display your database description on
       screen. Or... Choose Disk to store your database description
       in a disk file, type the file name, and choose OK.




     PC-File Version 7 Users Guide                            276



     CHAPTER 14 PRINTING LABELS WITH PC-LABEL

     PC-Label is unique in that it can be accessed from both the
     menu and the DOS prompt. This chapter provides information on
     accessing and using PC-Label.



     Introduction

     A mailing label utility is one of the most-commonly used
     features of a database program. PC-File provides an easy-to-
     use labels program, PC- Label, that lets you produce mailing
     labels on almost any stock available. Over a dozen label
     templates are provided, and you can create your own for those
     that aren't.

     PC-Label is actually a separate program that runs with PC-
     File. In previous versions of PC-File, it was only accessible
     from the DOS prompt. You can now access PC-Label from the PC-
     File menu bar as well as from the DOS prompt.

     NOTE: The mouse is NOT functional within PC-Label, so don't be
     surprised if you don't see a pointer on the screen when using
     it.

     Creating and Printing Mailing Labels

     The ability to generate mailing labels is one of the most
     important and useful features of a database program. PC-File
     provides three options for producing mailing labels. You may
     find yourself using all three at different times. Choose the
     method that will do the job you want.

     Snapshot labels

     You can print out a single label while entering or displaying
     a record in a database. This is most useful when you want to
     print a label as needed or keep track of needed labels one at
     a time. See Chapter 11, "Utilities," to set up the snapshot
     label format in your configuration profile, and Chapter 13,
     "Tools," for information on printing a snapshot label.

     Single column labels in Reports

     Use the mailing label format in the Reports option to print
     out single column labels. Only a minimum amount of formatting
     is necessary, making this an easy way to print labels if you
     aren't using multi-column labels. See Chapter 7, "Creating
     Reports," for more information.

     PC-Label




     PC-File Version 7 Users Guide                            277


     This program, which can be run from the PC-File menu bar or
     from the DOS prompt, provides the most flexibility. You can
     set up a template for any label format, compress out lines and
     spaces, and add text to the labels. PC-Label also handles
     other kinds of files, not just those from PC-File databases;
     these include PC-Type, PC- Calc+, and comma-delimited files.

     This chapter covers only the PC-Label utility.

     Starting PC-Label

     PC-Label can be run from within PC-File or from the DOS
     prompt. If you start within PC-File, the program drops you out
     to PC-Label. The program works the same way, no matter where
     you start it from.

     To start PC-Label from the PC-File menu bar:

     1.Open the database you want to use.

     2.Choose Utilities from the menu bar

     3.Choose Labels from the Utilities menu. The PC-Label Main
       menu appears.

     To start PC-Label from the DOS prompt:

     1.Move to the directory that contains your PC-File program
       files.

     2.Type pclabel at the DOS prompt and press ENTER. You can add
       a file specification to your start command if you have an
       existing label definition and plan to use it immediately.
       For example, you might enter pclabel c:\pcfile\members.lbl
       to start up the label program and load the members.lbl label
       definition at the same time. Otherwise, you can load the
       defined label once you start the label program.

     If you have a graphics monitor that doesn't support color (not
     just a standard monochrome screen), enter pclabel /green at
     the prompt to set your colors to black and white.

     Once you start PC-Label, the PC-Label Main Menu appears.

     The PC-Label Main Menu

     All options necessary to create and print labels are provided
     from the Main Menu. The options are defined as follows:

     Load existing setup

     If you have created a label definition in the past, you can
     load that definition and start printing labels.

     Define/modify setup




     PC-File Version 7 Users Guide                            278


     Use this option to define the parameters for a label. The
     parameters include the label dimensions, number of labels
     across the page, label layout, number of copies of each label
     you want printed, and several other factors that determine how
     your labels will look.

     Print labels

     Once you have loaded or defined a label definition, you can
     print the labels.

     Save current setup

     Unless you know you will never print labels again, save your
     label definition for future use. The label definition is saved
     to a file with the extension .LBL. Like a report file, this
     file contains the definition only (essentially a list of the
     parameters you defined in the setup), not the actual data that
     prints on each label.

     Quit/Exit PC-Label

     Exit from PC-Label when you have finished. You will return to
     where you came from, either the PC-File menu bar or the DOS
     prompt.

     The first four options on the menu are covered in detail
     below.

     Loading an Existing Label Setup

     Use the Load existing setup option to load a label definition
     that has been previously defined. Once the setup is loaded,
     choose Define/modify setup to modify the setup. Choose Print
     labels to print a set of labels.

     If you want to use an existing label setup with a new
     database, load that setup and change only the Label source
     location (database path and name) parameter on the setup
     screen. Then save the setup and give it a new name.

     To load an existing label setup:

     Choose Load existing setup on the PC-Label Main Menu.

     Enter the path and label filename in the edit box. You don't
     need to enter the .LBL extension. If the label file resides on
     the current directory, just enter the file name, without a
     path. The program assumes the current directory. As an
     alternative, just enter the path for the label file. The
     program displays a list of the label files on that directory,
     from which you can choose the one you want.

     Defining or Modifying a Setup




     PC-File Version 7 Users Guide                            279


     You must define a setup before you can print labels. A label
     setup is defined on the setup screen, a menu of over a dozen
     parameters that determine the format and look of your labels.
     To display the setup screen, choose Define/modify setup on the
     PC-Label Main Menu.

     The settings for each parameter are shown in the center of the
     screen. A window of helpful information appears on the right.
     The information is pertinent to the setting currently
     highlighted, and changes as you move through the settings.

     Most of the parameters have default settings already in place.
     You can leave or change these defaults. To change a default or
     enter new information, highlight the appropriate field, then
     press ENTER. Pressing ENTER activates the field. Once you do
     this, one of four things happens:

       An edit window displays, allowing you to enter information

       The field toggles to another option

       A menu of options displays, allowing you to choose one

       A new screen appears, allowing further input

     It is important that you check each parameter and make sure
     the settings are correct for your needs. At the bare minimum,
     however, give attention to three parameters:

       Label Source Location

       Label Sheet definition

       Label layout

     You can't print a label unless you have defined these
     parameters. All the parameters are covered in detail below.

     To define a label setup:

     1.Choose Define label setup from the PC-Label Main Menu.

     2.Choose a Label Source Type and enter a Label Source
       Location, if it isn't filled in already. PC-Label won't
       allow you to make other changes or entries without first
       choosing the database you are using.

     3.Define any other options according to your needs. Most
       important are the Label Sheet definition and Label layout
       options. You can't print labels without laying out the
       label. For all options on the Setup screen, highlight the
       option and press ENTER to make any changes to it.

     4.Press F10 when you finish to return to the PC-Label Main
       Menu.




     PC-File Version 7 Users Guide                            280


     5.Unless you know you will use this setup only once, save it
       by choosing Save current setup from the Main Menu.

     To modify a label setup:

     1.Choose Load existing setup from the PC-Label Main Menu.

     2.Choose the label file you want to modify.

     3.Choose Define/modify setup from the PC-Label Main Menu.

     4.Make your changes to the setup.

     5.Press F10 to return to the Main Menu.

     6.Choose Save current setup from the menu.

     7.Press ENTER twice to save the setup with the same name.

     An explanation of each parameter on the setup screen follows.

     Label Source Type

     Choose the type of data file that you are using for your
     source. In most cases, you will use the default of PC-File,
     which includes all recent versions of PC-File and dBASE.

     PC-Label lets you use any of the following types of data
     files:

     PC-File 7

     This is the default option that is used to print labels with
     PC- File 7 databases. The following options are only used with
     files produced by other ButtonWare programs and ASCII files.

     PC-File 6

     Along with databases created in PC-File 6.0, 5.0, and PC-
     File:dB, this format includes dBASE III, dBASE III Plus, and
     dBASE IV files. PC-Label looks for a file with a .DBF
     extension.

     PC-File+

     This earlier version of PC-File used files with extensions
     .DTA, .HDR, and .INX. PC-Label looks for all three types of
     files when you use this format.

     PC-Calc+

     ButtonWare's spreadsheet program files use the file extension
     .PCC.

     Comma-delimited




     PC-File Version 7 Users Guide                            281


     Files of this type consist of data fields separated by commas.
     Often, double quotation marks are used around each field in
     addition to the commas. A carriage return ends each record,
     occasionally with a line feed as well.

     ASCII-L

     Files of this type consist of fixed length fields with no
     separators between them. Each record ends with a carriage
     return and sometimes a line feed. PC-Label prompts you to set
     the length of each field when you get ready to print. Indicate
     the length of each field by filling the space with a different
     character (letter) from the keyboard.

     ASCII-C

     Files of this type consist of one field on each line. Each
     record is separated by one or more blank lines.

     To set the Label Source Type:

     1.Highlight the Label Source type field.

     2.Press ENTER repeatedly to toggle through the list of source
       types. PC-File is the default.

     Label Source Location

     The Label Source Location is the actual file that contains the
     data for the labels. PC-Label requires both the path and the
     database name. Don't use any file extension.

     If you opened a database before starting Labels from the menu
     bar in PC-File, the path and database name are displayed here
     already.

     To enter the label source:

     1.Highlight the Label Source Location field and press ENTER.

     2.Enter the path and database name in the edit window at the
       bottom of the screen. The file extension is not necessary
       unless PC-Label prompts you for it. For example, type
       c:\pcfile\sample\members.  As an alternative, enter just the
       path and press ENTER. A list of the databases in the
       directory displays. Choose the database you want.

     3.If the database is in the current directory, press ENTER to
       bypass the edit window and display the menu of databases; or
       just type the name of the database in the edit window.

     NOTE: If you select comma-delimited, ASCII-L, or ASCII-C as
     the source type, you have to indicate a file extension. For
     example, if your comma-delimited file has the extension .WS,
     type ws when prompted for the extension.




     PC-File Version 7 Users Guide                            282


     Define Search (and switch indexes)

     PC-Label lets you print all the records in the database, or a
     selected group of them. The default is to print all the
     records. To print a selected group, choose this option and
     define the group you want to select.

     The Define Search option also lets you change indexes for a
     PC-File database. If you have multiple indexes, use this
     option to select an alternate index. The new index changes the
     order of the labels during printing.

     The procedures for defining the search vary slightly,
     depending on the type of database file you are using. The
     procedures for a PC-File file are spelled out first, followed
     by the procedures for all other types of files.

     To define the search for PC-File databases or to change
     indexes:

     1.Highlight the Define Search field and press ENTER. A menu
       listing the indexes in your database appears. The current
       index is highlighted.

     2.Choose the index for the order you want to print in. A menu
       appears, providing options for selecting records. If you
       just wanted to change indexes, press ENTER to return to the
       setup screen. Otherwise, proceed to the next step.

     3.Choose the type of search you want to conduct. For Simple
       searches, highlight the appropriate field and press ENTER.
       Enter the string of data you want the program to search for
       in selecting records. For Formula searches, enter the search
       command in the edit window at the bottom of the screen.

     PC-Label supports all of the search capabilities of PC-File.
     See Chapter 5, "Finding and Modifying Data," for more
     information on conducting searches.

     To define the search for other types of databases:

     1.Highlight the Define Search field and press ENTER. A menu
       appears, providing search options.

     2.Choose the type of search you want to conduct. For Simple
       searches, highlight the appropriate field and press ENTER.
       Enter the string of data you want the program to search for
       in selecting records. For Formula searches, enter the search
       command in the edit window at the bottom of the screen.

     Output Destination

     PC-Label lets you print to a printer or to a file. Use the
     Output destination option to set the port to which your
     printer is connected or to name the file.




     PC-File Version 7 Users Guide                            283


     The default for this field is LPT1, the first parallel port.
     Most dot matrix and laser printers use LPT1. However, printers
     can be connected to LPT2 or to a serial (COM) port.

     Printing your labels to a file can be useful for a couple of
     reasons. You can edit the labels with a word processing
     program. You can also print the labels directly from the file
     using the DOS PRINT command and continue working in the
     database at the same time.

     NOTE: Be sure you have enough space on your disk if you print
     labels to a file. A large database of names can take up a lot
     of space.

     To set an alternative printer port:

     1.Highlight the Output destination field and press ENTER.

     2.Press ENTER again when asked for a file extension.

     3.When prompted for the path, press ENTER.

     4.When prompted for the file name, enter the printer port
       device name. For example, type lpt2 to print to the second
       parallel port.

     NOTE: If you want to print to a serial port, such as COM1, be
     sure to initialize your printer by using the DOS MODE command.
     Consult your DOS manual for further instructions on this
     procedure.

     To print to a file:

     1.Highlight the Output destination field and press ENTER.

     2.Enter the file extension (without the period) of the file to
       which you want to print the labels. For example, type txt in
       the edit window and press ENTER. Leave this blank if no file
       extension is desired. Just be sure that if you want to
       access the file with a word processing program, the
       extension is compatible with that program.

     3.Enter the path name when prompted. Press ENTER to bypass the
       path if you want to be in the current directory.

     4.Choose a file from the list that PC-Label displays. Normally
       you'll choose New File from this list.

     5.Name the file if you are creating a new file, and press
       ENTER.

     No. of Copies

     You can print up to 99 copies of your labels. If you want to
     print more copies than that, you will have to choose the print
     option more than once.




     PC-File Version 7 Users Guide                            284



     The default is 1.

     To define the number of copies:

     1.Highlight the No. of copies field and press ENTER.

     2.Enter the number of copies in the edit window at the bottom
       of your screen.

     Copies Definition

     PC-Label ignores this option unless you choose to print more
     than one copy of your labels. If you do print multiple copies,
     you can print them one of two ways: By Group or By Label.

     By Group

     PC-Label prints all of the records once, then prints the
     entire group again, repeating until the desired number of
     copies has been printed. Thus, if you decided to print five
     copies of your labels, the entire set of labels would print
     out once, then again and again until you had printed it five
     times. By Group is the default.

     By Label

     PC-Label prints the first record the desired number of times,
     then prints the second record the desired number of times, and
     so on until all records are printed the specified number of
     times. Thus, if you decided to print five copies of your
     labels, the first record would print five times, then the
     second record would print five times, and so on.

     No matter which way you choose, consider changing the Formfeed
     option (described below) to End of each set. By doing that,
     the printer kicks out the last sheet of each set of labels
     before beginning the next set. That way each set of labels
     would be on separate sheets. However, that option can also
     prove to be wasteful of labels.

     To define how additional copies are printed:

     Highlight the Copies definition field. Press ENTER to toggle
     between the two options.

     Compress Blank Lines

     Line compression is important for maintaining the appearance
     of your labels. Without line compression, you can end up with
     blank lines in many of the labels. For example, if you're
     printing five lines of information, and one line is empty for
     a particular record, line compression prevents PC-Label from
     leaving a gaping hole in that label.




     PC-File Version 7 Users Guide                            285


     Line compression removes blank lines from within a label and
     replaces them at the end of the label. That way the number of
     lines in a label remains constant, maintaining the proper
     formatting for the entire sheet.

     The sample labels below illustrate the differences between
     printing labels with line compression and without line
     compression.

     Compress Blank Lines YES
          Janet Ratite

          438 Savannah Way
          Seattle, WA 98103

          Robert T. Hare
          Rapid Flo Corp.
          8900 Brushwood Avenue
          Redmond, WA 98052

     Compress Blank Lines NO


          Janet Ratite
          438 Savannah Way
          Seattle, WA 98103


          Robert T. Hare
          Rapid Flo Corp.
          8900 Brushwood Avenue
          Redmond, WA 98052


     To set the line compression option:

     1.Highlight the Compress blank lines field.

     2.Press ENTER to toggle between YES and NO The default is YES
       (line compression is on).

     Centering

     This option lets you center each record vertically and
     horizontally on the label, based on the longest line and the
     number of lines within each record. If you leave centering
     off, PC-Label starts each label at the same place on the same
     line.

     Centering overrides the fixed placement of fields which you
     establish when you lay out a label. Label layout is covered
     later in this chapter.

     However, centering does not mean centering each line of an
     address on the label. PC-Label doesn't do that. Each record is
     centered as a whole.




     PC-File Version 7 Users Guide                            286



     Whether or not you center is largely an aesthetic decision.
     However, centering can sometimes cause problems with alignment
     of multi-column labels. If you want to center multi-column
     labels, leave the centering option off until you make sure the
     labels are aligned, then turn the centering option on.

     To set the centering option:

     1.Highlight the Centering field.

     2.Press ENTER to toggle between YES and NO. The default is
       YES.

     Pause If Truncation

     Data that doesn't fit within the space you have defined on a
     label will be truncated (cut off). You can ask PC-Label to
     alert you every time that occurs while you are printing.

     You may want to set this option ON the first time you run a
     set of labels in order to check for any field length problems.
     Truncated addresses can result in mail being returned because
     of incomplete addresses. Once you are satisfied that all your
     data fits, turn this option OFF.

     To set the Pause if truncation option:

     1.Highlight the Pause if truncation field.

     2.Press ENTER to toggle between YES and NO. The default is NO.

     Escape Code Toggle

     You may want to print the first line of your mailing labels in
     bold face, or perhaps include a return address in italics. To
     use a type style other than regular type, follow these steps:

     1.Toggle the Escape Code Toggle ON.

     2.Set the escape codes for your printer.

     3.Place the codes on the label when you lay it out.

     Setting the escape codes is explained in the following section
     (Print Escape Code) and placing the codes on the label is
     explained in the section on Label Layout later in this
     chapter.

     To set the Escape code toggle:

     1.Highlight the Escape code toggle field.

     2.Press ENTER to toggle the Escape codes ON and OFF. The
       default is ON.




     PC-File Version 7 Users Guide                            287


     If you don't use any escape codes in your label format, this
     feature is ignored, whether it is on or off.

     NOTE: If you print to a file, escape codes appear as garbled
     text. If you have used escape codes in your label, turn the
     toggle OFF when printing to a file, unless you will be
     printing the file later and wish to retain the escape codes.

     Print Escape Code

     Printers print in normal typeface unless they are told
     otherwise. To tell a printer to use bold face, you must send
     the printer an escape code. Then you must send another escape
     code to tell it to return to normal type. Each printer
     understands specific escape codes for each of the various
     character formats (bold, italic, underline, subscript, etc.)
     and different printers understand different codes. If you want
     to use various character formats in your labels, you must tell
     PC- Label what codes
     your printer understands. To do that, you use the Print Escape
     Code option on the Setup menu.

     NOTE: Any print codes set in the configuration profile don't
     apply to PC-Label.

     Highlight the Print Escape Code field and press ENTER. A
     dialog box appears.

     The Print Escape Code Menu displays escape codes for all Epson
     dot matrix printers and any other printers set to an Epson
     mode. If you are using this type of printer, your work is
     probably done. If you are using a different printer, consult
     the printer manual for the printer escape codes.

     The menu has two parts. At the top is the setup code. This is
     the field that is highlighted when the menu first appears.
     Below that is a listing of five individual character formats
     and the printer escape codes that turn them on and off. The
     two parts are discussed separately.

     Setup Code

     The setup code field lets you enter an all-encompassing escape
     code for your labels. If you wanted to print your entire label
     in italics or condensed type, for example, you would enter the
     appropriate escape code here. You would not have to place a
     code on the label definition itself.

     Character Formats

     You can access and change the information in any of the three
     columns on the menu. The center column lists the character
     format, the left column indicates the printer escape code that
     turns that character format on and the right column indicates
     the printer escape code that turns it off.




     PC-File Version 7 Users Guide                            288


     To make changes to the formats and codes, highlight the
     appropriate entry and type your change into the edit window
     that appears. Press ENTER to replace the previous entry with
     your change.

     You only need to correct those codes that you plan to use. If
     your printer reads different codes than the ones shown, but
     you only plan to use the bold format in your labels, you need
     only change the escape codes for bold. The other formats and
     their escape codes will be ignored.

     If you want to use a format that is not listed, such as small
     capitals or double wide letters (available on some dot matrix
     printers), enter the format name in the center column over one
     of the current formats. Then enter the escape codes listed in
     your printer manual that turn the format on and off.

     Escape codes normally consist of two or three characters.
     These characters can be entered as decimal values between
     braces, or the actual character can be entered using ALT and
     the numeric keypad. For example, the Epson dot matrix code to
     turn off bold face is {27}{65} in decimal and _A using the ALT
     key and keypad. You can also mix the two ({27}A), as the
     default values indicate.

     Label Sheet Definition

     PC-Label provides 14 templates from which you can choose the
     one that matches your label stock. If none of them match, you
     can design a layout that will.

     To select a template:

     1.Highlight the Label Sheet definition field and press ENTER.
       A window listing the label template options appears.

     2.Highlight the template that matches your label stock. The
       dimensions of your label stock should be listed on the side
       of the box containing the labels. Choose User-defined if
       none of the templates match your label stock.

     3.Press ENTER to close the window.

     If you selected a template, you return to the Setup menu. The
     template you selected is now listed on the screen.

     If you selected User-defined, a label definition screen
     displays on which you can create your own template.

     NOTE: If your labels are 1" high, use the 15/16" equivalent.
     The other sixteenth of an inch is the space between each
     label.

     Creating your Own Template




     PC-File Version 7 Users Guide                            289


     To create your own template, first choose the template that
     most closely resembles the template you have in mind. Then,
     when you choose User-defined, the values for that template
     display as the defaults.

     For example, if you are working with labels that are 4 x 1 1/3
     (2- up), choose a template like 4 x 1 7/16 (2-up). That way
     you have to change fewer values when you define the template.

     The procedures for creating a user-defined template are
     explained below, followed by a description of the Label Sheet
     Format Definition screen.

     To create a User-defined label template:

     1.Highlight the option Label Sheet definition and press ENTER.

     2.Choose the template that most closely resembles the template
       you want to design.

     3.Press ENTER to display the list of template options again.

     4.Choose User-defined from the menu of templates. The Label
       Sheet Format Definition screen appears. It is here you
       create a template.

     5.Highlight each option you want to change and press ENTER to
       activate it.

     6.Fill in the proper dimension in the edit window that appears
       at the bottom of the screen for each option.

     7.Test your answers by printing out a test sheet of labels.

     8.Make any necessary changes to the label dimensions.

     9.Press F10 when you finish to return to the setup screen.

     The User-defined Template Options

     Each of the options on the template is described below.

     Number of labels across

     Indicate the number of labels printed across your label sheet.
     The minimum is one, the maximum is 25.

     Width of label and space between

     Enter the number of characters from the left edge of one label
     to the left edge of the next label. This field is ignored with
     single column labels.

     Label width




     PC-File Version 7 Users Guide                            290


     Enter the number of characters that represent the width of a
     label. Most printers are set up to print 10 characters per
     inch, but this is not always the case, particularly if you are
     using condensed or elite type. Check your printer fonts if you
     have problems with this dimension.

     Top margin

     Enter the number of lines at the top of each sheet of labels.
     This option is only in effect when you feed sheets of labels
     manually and have set the Feed method (the next option on the
     setup menu) to By Sheet. Continuous feeding ignores this
     option.

     Number of labels down

     Enter the number contained in one column of one page of
     labels.

     Height of label and space between

     Enter the number of lines from the top of one label to the top
     of the next label. This is normally one line more than the
     label height.

     Label height

     Enter the number of lines on one label.

     Run a test

     Press ENTER with the Make template field highlighted to print
     a test sheet. Follow the directions on the screen to check
     your dimensions. If they are not correct, make the necessary
     changes and run another test.


     Feed Method

     PC-Label lets you choose between two methods of paper feed:
     Continuous and By Sheet. The default is Continuous, as this is
     the normal method for most printers, including laser printers.
     However, if you must feed each sheet of labels manually, or
     want a pause between each page, choose the By Sheet method.

     To set the feed method:

     Highlight the Feed method field Press ENTER to toggle between
     Continuous and By Sheet.

     Formfeed




     PC-File Version 7 Users Guide                            291


     This option lets you add an extra form feed for specific
     instances where it might be necessary. There are three
     settings: None, End of each sheet, and End of each set. Which
     setting you choose depends partly on the feed method you
     selected in the previous option.

     None

     In most cases you want to leave the formfeed off (set to
     None). More than likely your printer will formfeed
     automatically after each sheet and at the end of the printing.

     End of each sheet

     Choose this option only if you are using the By Sheet feed
     method. This forces the last page or any other pages that are
     not fully printed to kick out of the printer.

     End of each set

     Choose this option if you are using continuous feed and are
     printing more than one set (copy) of labels. This option will
     kick out a page at the end of each set, thus forcing the next
     set to start on a new page. A set consists of one "print" of
     labels, whether printed By Group or By Label (see Copies
     Definition above).

     To set the formfeed:

     1.Highlight the Formfeed field.

     2.Press ENTER to toggle between None, End of each sheet, and
       End of each set. The default is None.

     Label Layout

     Use the Label Layout option to design how your labels will
     look. Designing a label encompasses locating the fields,
     adding text, defining the borders, and adding character
     formatting.

     There is no default layout or template for the design of an
     individual label, so you must define this option. Your labels
     will not print unless you do.

     To layout a label, highlight the option and press ENTER.

     The edit window in the center of the screen is sized according
     to the dimensions you selected under the Label Sheet
     Definition option. It is within this window that you define
     your label. This operation is explained below.

     Locating Fields and Text




     PC-File Version 7 Users Guide                            292


     All the fields in the database are listed at the top of the
     screen. Each field is numbered; use the numbers to locate the
     fields on the label rather than the names.

     The last four fields listed are system fields. These fields
     can be used for all labels. They are explained in detail
     later.

     Text intended to appear on all labels can be entered directly
     onto the label definition. For example, if your labels are
     large enough, you could enter a return address in the top left
     corner.

     All fields, including system fields, and text must be preceded
     by either of two location markers: the at sign (@) or the
     question mark (?). These markers are used as follows:

     At sign (@)

     Fix the data or text at a specific location by preceding it
     with the @. The field or text that follows the @ will always
     start in the spot where you have placed it on the label. The @
     itself marks the beginning of the field.

     Question mark (?)

     Precede fields or text with a ? when you want the data to
     slide to the left until it encounters other data, the left
     margin of the label as defined by the left bracket ( [ ), or
     the left edge of the label. The use of brackets is explained
     later in this section.


     I
     Using System Fields

     The four system fields provide extra features that can be
     added to your labels. The system fields are located on a label
     definition in the same way as a data field, using the number
     in place of the field name and preceding the field number with
     an @ or ?.

     Recno

     This field lets you print the current record number on each
     label, based on the current index.

     Date

     Use this field to print the current date, taken from the
     system calendar.

     Time

     Use this field to print the current time, taken from the
     system clock.




     PC-File Version 7 Users Guide                            293



     Keyin

     Use this field to enable you to enter data from the keyboard
     onto each label. The printer pauses when it encounters this
     field in each label. Press ENTER when you finish keying in
     data to continue printing.

     Unlike other fields, you must define the size of a keyin
     field. You do this by following the keyin field number with
     any character from the keyboard, repeated until the end of the
     field. For example, if you want to define a keyin field eight
     characters long, you might enter

     @18aaaaaa

     Note that the "18" is considered part of the eight character
     spaces following the @ or ?. You can replace the a's with any
     other keyboard characters, other than those reserved for other
     use on the label, such as the @, ?, and the brackets used
     around field names.

     Centering the Label and Compressing Lines

     Use square brackets [ ] to define specific areas within a
     label for centering and line compression. Follow these
     guidelines for using brackets.

       If Centering and Line compression are turned off, brackets
       have no effect.

       If either centering or line compression, or both, are turned
       on, the entire label is affected if you do not use brackets.

       If either or both functions are turned on, and you do use
       brackets, only the part of the label enclosed by brackets is
       affected.

     Thus, not using brackets is the same as using brackets around
     the entire label (if centering or line compression is turned
     on).

     Adding Character Formatting

     You can add character formatting to a label if you have
     toggled the Escape code ON and defined the printer escapes
     codes for your printer. If so, the character formats for which
     you have defined escape codes are displayed at the bottom of
     your screen, below the edit window. Each one is indicated by a
     print marker, such as <<1>> or <<4>>. Use these print markers
     to indicate character format changes on the label.

     To indicate a change in character formatting, place the print
     marker at the spot where the change occurs. For example, to
     make a particular field bold, you might locate a field like
     this:




     PC-File Version 7 Users Guide                            294



          ?<<1>>9<<2>>

     Note that the print marker follows the ? or @ for the field it
     affects.

     Use no more than 16 different print markers in one label
     definition, and only one for each field or text entry. In
     other words, you cannot combine bold and italic formatting for
     a particular field or text entry. Also, do not change the type
     size when printing multi-column labels.

     Workspace Drive

     PC-Label uses a small amount of temporary work space when
     printing labels. This work space, amounting to eight bytes per
     label, is placed in a temporary file. Use this option to
     indicate the drive on which that file is placed.

     To set the workspace drive:

     1.Highlight the Workspace drive field and press ENTER.

     2.Enter the drive in the edit window that appears. The default
       is C.

     NOTE: The temporary file is removed from your disk when PC-
     Label has finished processing. However, be sure you have
     enough space to accommodate the temporary file when printing
     labels.


     Printing Labels

     When you first start printing a set of labels, you need to
     make sure the label stock is correctly aligned in the printer
     and that the parameters you have defined for the label
     definition are correct. PC- Label lets you check these by
     providing a test option at the start of printing. Use this
     option to make sure everything is lined up correctly.

     When you choose Print labels on the PC-Label Main Menu, your
     labels are printed to the printer or to a file, depending on
     the output destination you chose on the Setup screen. The two
     operations are handled in different ways by the program and
     are covered separately below.

     To print labels to a printer:

     1.Choose Print labels from the PC-Label Main Menu.




     PC-File Version 7 Users Guide                            295


     2.Choose Yes or No to position your label sheet in the
       printer. Choose Yes if you are unsure of the placement of
       the label stock in your printer. PC-Label goes through a set
       of screens that will help you position the first sheet
       properly. Choose No if you are familiar with placing the
       label stock in the printer.

     3.If you chose Yes to the previous step, choose Yes or No when
       the program prompts you to align the labels again. Choose
       Yes to test the alignment again. Choose No if you feel
       certain the alignment is correct.

     4.Choose Yes, No, or Yes & don't ask, or press ESC, when PC-
       Label displays the first label and asks if you want to print
       it. Choose Yes to print it. Choose No to skip this label and
       continue to next label. Choose Yes & don't ask to print all
       the labels without reviewing them on the screen. Press ESC
       to display the following prompts: Abort-to abort the
       printing process (to return to the main menu) Backup-to
       backup to the previous label Continue-continue the printing
       process Choose the appropriate response.

     To print labels to a file:

     1.Choose Print labels on the PC-Label Main Menu.

     2.Enter the extension, then the path and file name to which
       you want to print the labels.

     3.Choose Yes, No, or Yes & don't ask when PC-Label displays
       the first label and asks if you want to print it. Choose Yes
       to print the label to the file. Choose No to abort the
       process. Choose Yes & don't ask to print all the labels
       without reviewing them on the screen. Press ESC to display
       the following prompts: Abort-to abort the printing process
       (to return to the main menu) Backup-to backup to the
       previous label Continue-continue the printing process Choose
       the appropriate response.

     Saving the Current Setup

     Once you have defined a label setup, you should save it for
     future use. You can save it before or after you print labels
     with it, but be sure to save it before you exit from PC-Label
     or it will be lost.

     A label setup is saved in a file with an .LBL extension. PC-
     Label adds this extension automatically when you name the
     file.

     To save the current setup:

     1.Choose Save current setup on the PC-Label Main Menu.




     PC-File Version 7 Users Guide                            296


     2.Enter the path (drive and directory) where you want the file
       to be stored. Do NOT include the file name. If you want to
       store the file on the current directory, press ENTER to
       bypass this box.

     3.Choose New File.LBL from the list that displays to save the
       setup with a new name. Choose another file name if you want
       to save the setup to a current file, overwriting that file
       in the process.

     4.Enter the name of the file if you chose New File.LBL. Follow
       DOS filename rules in naming the file. You don't need to
       enter the extension, as PC-Label adds it automatically.




     PC-File Version 7 Users Guide                            297



     CHAPTER 15 TOOLS

     PC-File includes four small utilities, all easily accessible
     from the Tools menu or with a hot key. You can have PC-File
     dial a phone number for you, drop to the DOS prompt, print a
     single label, or perform a calculation. PC-File also has a
     spell checking utility for correcting spelling errors in
     fields and letters. This chapter explains how to use these
     features.


     Overview

     PC-File provides several options on the Tools menu that
     perform small but very useful tasks. For example, you can
     temporarily drop out of PC- File, grab almost all of the
     memory used by the program, run another program, then return
     to the same spot without losing a step.

     PC-File also treats you like a CEO. Display a record on the
     screen and the program will dial the phone for you and tell
     you when to pick up the receiver.

     The Tools options are explained briefly below and in more
     detail in the sections that follow.

     Option Hot key Action

     Drop to DOS CTRL-D Lets you issue DOS commands and run other
     programs Telephone Dialer CTRL-J Dials the phone number
     selected on the current record Snapshot Label CTRL-L Prints a
     mailing label for the current record Calculator CTRL-C Lets
     you enter and memorize a calculation


     Dropping to DOS

     The Drop to DOS option lets you exit from PC-File temporarily.
     You can then issue DOS commands or even run another program.
     When you return to PC-File, you are in the same place you left
     off.

     You may want to copy a file or group of files to another
     directory, or perhaps delete files to make more room for data.
     Or you may want to open another program, such as a
     spreadsheet, and look at a file from which you are about to
     import data.

     Before you drop to DOS, determine what action you intend to
     take. There are two forks in the road as you drop to DOS, and
     the action you intend to take determines the forks you should
     follow. The two forks involve:

     Issuing single or multiple DOS commands Deciding whether you
     need to free up memory




     PC-File Version 7 Users Guide                            298



     Single or Multiple DOS Commands?

     When you choose Drop to DOS from the Tools menu (or press
     CTRL-D), PC- File displays a dialog box.

     To issue a single DOS command, type the command in the dialog
     box. Once DOS completes the command, press any key to return
     to PC-File.

     To issue multiple commands, leave the text box empty and
     choose OK. PC- File takes you to the DOS prompt, from which
     you can enter multiple commands. When you are ready to return
     to PC-File, type exit at the DOS prompt and press ENTER.

     If you want to open another program, you can do it either from
     the dialog box or from the DOS prompt. If you have to change
     directories first, you need to move to the DOS prompt, as
     multiple commands are needed.

     Free Up Memory?

     Once you enter a command in the dialog box, PC-File asks if
     you want to free up memory. In most cases, answer Yes if you
     plan to run another program, or answer No if you are just
     issuing DOS commands.

     In rare cases, the opposite may be true. If your computer has
     a lot of memory, you may not have to free up memory to run
     some programs. If you have a minimum of memory, you may have
     to free up some just to run a series of DOS commands.

     PC-File frees up memory by writing a temporary file to disk.
     The temporary file contains the actions you have taken in PC-
     File, so you can return to where you left off. All but just
     over 20K of memory that PC-File normally uses is freed up.

     NOTE: Be sure you don't delete the temporary file written by
     PC-File. Temporary files are named TEMPxxxx.PCF, with the x's
     being any combination of characters.

     NOTE: Though dropping to DOS should not interfere with PC-
     File, it is recommended that you save whatever you are
     currently working on. For example, if you are creating a
     report, save the report, then drop to DOS. While unlikely, it
     is possible you could run out of memory and have to reboot.


     Autodialing a Phone Number

     Along with its main function as a database program, PC-File
     includes several important features of a communications
     program. If you have a modem, you can display records that
     include phone numbers and use PC- File to dial the phone.




     PC-File Version 7 Users Guide                            299


     As an added bonus, PC-File keeps track of your phone calls.
     After a call ends, an entry is made in a telephone log file,
     which you can later use to verify the charges on your phone
     bill.

     NOTE: You can't use PC-File to "talk" to another computer,
     such as a bulletin board, or to a fax machine. It's only
     useful for talking to another person (or listening to an
     answering machine or voice mail).

     Autodialing Requirements

     To make use of the autodialing feature, you need the following
     equipment and data:

     Communications port

     You must have a serial communications port on your computer.
     This can be COM1, COM2, COM3, or COM4.

     Modem

     You must have a "Hayes compatible" modem connected to your
     communications port. It doesn't have to actually be a Hayes
     modem. It just has to be able to recognize a few of the Hayes
     modem commands. Most modems can do this.

     The modem is essential because PC-File uses it to actually
     place the phone call. After the phone number has been dialed,
     the modem is no longer needed. PC-File bypasses the modem so
     you can talk on your handset.

     Handset

     This is the actual telephone. Plug the telephone into the
     modem. There's usually a connector on the modem that says "to
     phone" or "handset", or something similar.

     You can use a dial (pulse) or touch-tone phone. PC-File
     assumes you have a dial phone unless you specify you have a
     touch-tone phone by changing the modem dialing command in your
     configuration profile. See Chapter 13, "Utilities," for
     information.

     Database

     You must have some phone numbers that PC-File can use to place
     the call. The phone numbers come from a field in a database.
     The database might be a "customer" database, or a "sales
     leads" database, or any type of database that contains phone
     numbers. The phone number must be in a field named "phone", or
     have "phone" as part of the name. You can have multiple phone
     fields in a database, as PC-File prompts you for the number
     you want to call if it detects more than one phone number
     field.




     PC-File Version 7 Users Guide                            300



     Setting Up a Database for Autodialing

     If you intend to use the autodialing features of PC-File,
     check your configuration profile to make sure the modem port
     and dialer settings are correct. (See the section on
     configuration in Chapter 13, "Utilities," for information.)
     Then follow these guidelines when defining your database:

     The phone field

     When the telephone dialer is activated, it looks at each of
     the field names in the database. If any field name includes
     the characters "phone", that field is assumed to contain a
     phone number. Be sure to use the word "phone" in the
     appropriate field(s).

     If you have multiple phone fields, PC-File will prompt you to
     select one of them when you make a call.

     The phone number

     The phone numbers should normally be entered as numeric digits
     (though the field should be a character-type field). Some
     modems can translate characters to digits, but many can't.
     Thus, it is recommended that you enter (800)J-BUTTON as
     (800)528-8866. You can include spaces, parentheses, or hyphens
     for clarity, although they aren't required.

     Embedded commands

     You can include Hayes modem commands in the phone number
     field, though they are normally unnecessary. PC-File
     automatically sends the ATD command to alert the modem that
     you are about to use it. Other commands, such as including a 9
     before the number to dial out of an office, should be included
     in the phone access commands in the configuration profile. See
     Chapter 13, "Utilities," for information on setting up your
     phone profile. See your modem manual for information on Hayes
     modem commands.

     Comments

     If you want to include a comment (information that will not be
     sent to the modem) in a phone number field, precede the
     comment with a semicolon. For example, you might type 528-
     8866; ask for Janet.

     Long distance codes

     For long distance calls outside of your area code, don't
     include the "1" (long distance access code) with the phone
     number. You do need to include the area code, however. PC-File
     automatically adds the 1 for all phone numbers that are 10
     digits or longer, unless the number starts with a zero (calls
     outside the U.S. and Canada).




     PC-File Version 7 Users Guide                            301



     For long distance calls within your area code, you must
     include the "1," unless your local phone company requires you
     to dial the area code for long distance calls within your area
     code. In that case, treat it like any other long distance
     number and enter the area code into your phone field.

     Here are some valid phone numbers:

     528-8866 a local call

     1-528-8866 long distance within the area code

     1 528 8866 same as above

     (206) 528-8866 long distance to a different area code

     206-528-8866 same as above

     011-312-322-1 foreign call (PC-File doesn't send a 1)



     Placing a Call

     Be sure the modem and telephone are hooked up correctly and
     the port and access codes are properly configured in the
     database configuration profile.

     To place a call:

     1.Display the record containing the phone number you wish to
       call. You can be in either Modify mode or Read-only mode. If
       you are in a Table view, highlight the record. You do not
       have to highlight the phone field itself. You must have the
       record itself displayed. You can't place a call from a
       letter or report that contains phone number data.

     2.Choose Tools from the menu bar.

     3.Choose Telephone dialer from the Tools menu. As an
       alternative to steps 2 and 3, press CTRL-J to activate
       autodial. To recall this hot key, remember that the J stands
       for Jingle.

     4.Choose the phone number to call if there is more than one
       phone field in the record. PC-File displays a dialog box
       listing the phone numbers when multiple phone fields are
       defined in a record.

     5.Wait while the call is being made. Normally you can hear the
       modem dialing and the rings or busy signal that follow.




     PC-File Version 7 Users Guide                            302


     6.Pick up the handset and press ENTER as instructed on the
       screen. Pressing ENTER starts the timer that records the
       length of the call. Picking up the handset releases the
       modem from the phone line. Do NOT pick up the handset until
       the dialing is completed, as it interrupts the dialing
       process.

     7.Press ENTER again when you finish the call to stop the
       timer, then replace the handset. If you need to use your
       computer while you're talking on the phone, you can stop the
       timer whenever you want. This removes the timing message
       from the screen, but allows you to continue the phone
       conversation. Of course, the entry in your phone log will
       reflect a shorter call duration due to the early stoppage of
       the call timer.

     The Phone Log

     A different phone log is kept for each database. The log is
     called databasename.CDS.

     PC-File adds a new entry in the .CDS file for each call. The
     entry always includes the current date, phone number dialed,
     starting time and call duration, and the port to which the
     modem is connected. The program also picks up information from
     any fields which include the characters "name", "company",
     "city", "state", and "country".

     Printing and Displaying a Phone Log

     All of the information in the phone log is in ASCII character
     format. Thus, you can display or print out your phone log
     using any program that reads ASCII files. This includes most
     text editors and word processing programs.

     NOTE: If you have to change the extension .CDS to a different
     extension in order to display the file in a word processing
     program, be sure to save it back as a text file if you want to
     continue adding phone calls to it.

     You can also print the log directly by using the DOS PRINT
     command. At the DOS prompt, type print databasename.cds and
     press ENTER. Be sure you are in the same directory as the
     file. The log prints to the default printer.

     Deleting a Phone Log

     Each phone call made is added to the end of the current
     database phone log. If you want to clean out the phone log and
     start a fresh one, just delete the file using the DOS DELETE
     or ERASE command. For example, type del databasename.cds at
     the DOS prompt and press ENTER.

     PC-File automatically creates a new log for the database the
     next time you make a call.




     PC-File Version 7 Users Guide                            303



     Taking Snapshot Labels

     Snapshot labels let you print a single mailing label for the
     currently displayed record. This can be a handy feature,
     particularly for those users that take phone orders or for one
     reason or another want to print out labels one at a time.

     You can also print snapshot labels to a file, then print them
     out all at once at a later time. That might be a better way to
     do it, if you are not set up for printing single labels.

     You can also use this feature to save snippets of information
     other than mailing labels. In fact, the snapshot label feature
     can be used for a wide variety of possibilities. For example,
     you can set up a phone log format to remember who called. You
     can format envelopes with both a mailing and return address,
     using the Free form format in Reports. You can format a COD
     label or invoicing form for quick printing. You can even print
     snapshot letters if you want.

     Snapshot Label Procedures

     "Snapping" a snapshot label is a simple process, but there are
     several preliminary steps before you can actually take the
     snapshot.

     To define and take a snapshot label:

     1.Define a report structure for your snapshot label. Reports
       are normally defined using the Mail label format of the
       Report generator, though you can use any format. See
       "Defining the Snapshot Structure" below for more
       information.

     2.Assign a report to a snapshot number. You do that in your
       configuration profile. See Chapter 13, "Utilities," for
       information.

     3.Select the output for the snapshot. You can print to a
       printer or to a file. This decision is also entered in your
       configuration profile.

     4.Display a record on the screen. You can be in Record view or
       Table view. In Table view, the record currently highlighted
       is used.

     5.Take the snapshot. Choose Tools from the menu bar and
       Snapshot label from the Tools menu. As an alternative, press
       CTRL-L. If you have multiple snapshot label formats attached
       to the current database, PC-File prompts you to choose one.
       If printing to a printer, be sure it is properly hooked up
       and turned on.

     Defining the Snapshot Structure




     PC-File Version 7 Users Guide                            304


     A snapshot label is a report incorporating just one record
     from your database. Like a report, you must first outline the
     structure of the snapshot before you can print it.

     You can use any of the report formats for defining a snapshot
     report, though for actual mailing labels, the Mail label
     format is probably the easiest. If you use the Free form or
     Language formats, you can only use the Detail section. A
     snapshot does not read any other section in a report.

     You can use a report for snapshots that you also use for
     printing a regular report. For example, if you have created a
     report for printing mailing labels, you can use the same
     structure for snapshots. You can also create reports for just
     using with snapshots.

     Once you have defined the report structure, you must assign it
     to a snapshot. You can define up to five snapshot reports in
     each database. At the same time, you must tell PC-File whether
     you want to print that snapshot to a file or to the printer.
     Both operations are handled in the configuration profile. See
     Chapter 13, "Utilities," for information on these operations.

     NOTE: You can't use a mailing label defined in the PC-Label
     utility for a snapshot.

     Using the Calculator

     The Calculator option on the Tools menu emulates a standard 4-
     function calculator which responds to either the mouse or the
     keyboard (including the keypad). You can perform any type of
     calculation that is functional within PC-File, including
     arithmetic and date calculations, string calculations, and
     relational lookups. See Chapter 17, "Calculations," for more
     details on performing calculations.

     If a calculation includes one or more field names, the data
     from the currently displayed or highlighted record is used in
     the calculation.

     Choosing the Calculator option on the Tools menu, or pressing
     CTRL-C displays the calculator dialog box.

     The text box at the top of the window displays the calculation
     as a formula reading left to right, for example, 123.4 + 567.8
     - 901. If the calculation exceeds the length of the text box,
     the display will scroll up to a total of 120 characters. You
     can enter any valid PC-File calculation containing numbers,
     field names, and all supported functions:

     Date calculations (@TODAY#), (@DAY#,mask), and (@DATE,mask)

     Relational lookups (@shared field in current db, lookup
     database, shared field in lookup db, lookup field)




     PC-File Version 7 Users Guide                            305


     Logical expressions Comparisons using any of the following
     operators:

     < Less than

     > Greater than

     & And

     | Or

     ( ) Parentheses

     NOTE: Logical operators which use the = sign cannot be typed
     in directly because pressing the = key causes the calculator
     to display its result. It is possible to copy a logical
     expression from an editing window or text box in another area
     of PC-File with CTRL-INS and paste it into the calculation
     text box with SHIFT-INS.

     Math functions + Addition

     - Subtraction

     * Multiplication

     / Division

     ^ Exponentiation

     % Modulo (Remainder)


     String functions UPCASE( ), LOWCASE( ), MIXCASE( ), LASTWORD(
     ), FIRSTWORD( ), TRIM( ), and ; (semicolon) the concatenation
     operator.

     The result of your calculation is not displayed until you
     click = on the calculator, press the = key, or press ENTER.
     The result does not automatically clear, allowing you to
     display an intermediate result and continue, incorporating the
     result into subsequent calculations, if you want.

     In addition to standard number, decimal, add, subtract,
     multiply, divide and equals keys, there are seven other keys :

     clr

     The Clear key clears the calculation text box. Also, if the
     contents of the text box has been memorized with the Store
     (sto) key, pressing it a second time after clearing the text
     box clears the memorized contents.

     sto




     PC-File Version 7 Users Guide                            306


     The Store key memorizes the full contents of the calculation
     text box. This can be the result of a calculation (after
     pressing =) or a calculation formula itself (before pressing
     =). As much of the memorized contents as possible displays
     above the calculation text box. Choosing Store with something
     already memorized replaces the previously memorized value.

     rcl

     The Recall key retrieves the value or calculation stored with
     the Store key.

     cpy

     The Copy key copies the full contents of the calculation text
     box to a memory buffer allowing you to "paste" it with SHIFT-
     INS. This is generally used to copy the result of a
     calculation into a field after exiting the calculator window.

     exit

     The Exit key removes the calculator window.

     fld

     The Field key displays a dialog box that allows you to choose
     data from any field and copies it to the end of the contents
     of the calculation text box. This key does not appear when the
     Calculator is invoked with no database open.

     LU

     The Lookup key displays two dialog boxes that allows you to
     retrieve data from a field in a related database. See Defining
     Relational Lookups, below, for details on how to use the
     Lookup dialog boxes. This key does not appear when the
     Calculator is invoked when no database is open.

     NOTE: The Store key and the Copy key differ slightly in
     function. Each stores its memorized information to a separate
     memory buffer. The Store key can only be used to memorize and
     copy information within the Calculator window, and must be
     used in conjunction with the Recall key. The Copy key copies
     the current contents of the calculaton text box to the same
     buffer used for the CTRL-INS, SHIFT-DEL, and SHIFT-INS edit
     keys, and is used to copy the memorized information to any
     active field or text
     box used in PC-File.

     Additionally, both the Store and Copy keys only copy the
     entire contents of the calculation text box, to copy a portion
     of the text box: highlight the desired portion, press CTRL-
     INS, move the cursor to the location you want to copy to and
     press SHIFT-INS.

     To perform a calculation:




     PC-File Version 7 Users Guide                            307



     1.Choose Tools from the menu bar.

     2.Choose Calculator from the Tools menu. As an alternative to
       steps 1 and 2, press CTRL-C.

     3.Enter the calculation into the text box using any of the
       following methods:

          Using the keyboard

          Using the numeric keypad

          Clicking the key buttons on the Calculator window with
          the mouse.

     4.Press ENTER or click = to display the answer.

     5.Choose the Copy key or press CTRL-P if you want to save the
       answer to the cut-and-paste buffer.

     6.Choose Exit to remove the Calculator window.

     To write an answer saved to the cut-and-paste buffer to a
     field or text box, move the cursor to the desired location and
     press SHIFT-INS.

     The cut-and-paste buffer is shared by the Copy key and the
     edit keys: CTRL-INS and SHIFT-DEL. The cut-and-paste buffer
     only holds one memorized item at a time. Subsequent uses of
     the Copy key, CTRL-INS, or SHIFT-DEL replaces whatever was
     previously in the cut-and-paste buffer.


     Using the Spell Checker

     The Spell Checker is available in many areas of the program.
     You can check data in memo fields or the text of letters used
     in a mail merge. The Spell Checker is accessed as a tool on
     the button bar or by pressing CTRL-Q. You cannot access the
     spell checker from the Tools menu, but it is included in this
     part of the documentation because it is used like a tool.

     There are two ways to invoke the spell checker.

       Press CTRL-Q.

       Click on the Spell Button with the mouse.

     When a misspelled word is encountered a dialog box displays.

     The spell checker in PC-File is similar to any spell checker
     you may have used in a word processor. When you spell check
     text in PC-File, it pauses and displays any misspelled word.
     You then have four options:




     PC-File Version 7 Users Guide                            308


     Option: Function

     Ignore :  Ignore the misspelled word and continue the spell
     checking.

     Suggest:  Suggest options for the misspelled word.

     Add:  Add the current word to the user dictionary.

     Re-type:  Re-type the current word in the edit box, making the
     proper corrections.

     Ignore

     Use this option when you use a word or acronym such as NASA.
     You might want to include NASA in a memo, but not add it to
     the user dictionary. Choose Ignore to skip the current word
     and continue spell checking.

     Suggest

     Use this option when you want to see various options for
     corrected spellings. After using the Suggest option, you can
     select one of the suggestions from the list and then choose
     Replace to replace the misspelled word with that selection. If
     the correct word is not among the suggestions, you can re-type
     the word, making any changes necessary. You can then Replace
     the word or Add the word. Adding the word will both replace
     the word and add it to the user dictionary.

     Add

     This is used to add frequently used words to the user
     dictionary that are not found in a common dictionary. Proper
     names are common additions to the user dictionary. The name
     "Frankie Angelosi" is not in the dictionary. "Frankie
     Angelosi" could be added to the user dictionary so that PC-
     File will not stop each time it found the name. Choose Add to
     add the current word to the user dictionary.

     Re-typing

     You can also edit the current word, making the correction by
     hand as opposed to having PC-File make any suggestions. For
     example, PC- file would stop on the word "aftr." It may be
     easier to simply add "e" to the current word in the edit box
     and make "after" instead of pressing Suggest and then Replace.
     Re-type the current word in the edit box to make changes by
     hand.

     After you have made changes to a word, you can replace the
     original word with the changed word by choosing Replace. You
     can also choose Add to add the changed word to the user
     dictionary and replace the original word with the newly added
     word.




     PC-File Version 7 Users Guide                            309


     You can stop the spell checker at anytime by choosing CANCEL.

     Spell Checking Memo Fields

     You can use the spell checker in memo fields. You can use it
     at anytime: when you first enter the data or later, when
     examining your data.

     To use the spell checker in a memo field:

     1.Expand the memo field by pressing CTRL-E or clicking on the
       up arrow button to the right of the memo field.

     2.Choose Spell. PC-File begins spell checking the entire memo
       field. When a misspelled word is encountered the Spell Check
       dialog box displays.

     3.Make the appropriate corrections using: Ignore, Suggest, Add
       or re- typing for all misspelled words.

     Spell Checking in the Letter Writer

     The Spell Checker is available in the Letter Writing part of
     PC-File. You can check the spelling at any point in the
     document. The Spell Checker always starts at the point of the
     cursor and moves through the document to the end. To check an
     entire document, move the cursor the top of the document and
     choose Spell.

     To use the spell checker in a letter:

     1.Move the cursor to the first word to spell check, or move
       the cursor to the beginning of the letter to spell check the
       whole letter.

     2.Choose Spell. PC-File begins spell checking the letter. When
       a misspelled word is encountered the Spell Check dialog box
       displays.

     3.Make the appropriate corrections using: Ignore, Suggest, Add
       or re- typing for all misspelled words.

     Spell Checking Other Fields or Text

     You can invoke the spell checker in other fields or anywhere
     the "I- beam" text cursor is active. For example, the spell
     checker will check the contents of any text box including
     fields.

     To spell check other fields or text:

     1.Place the cursor in any field or area the text cursor is
       active.




     PC-File Version 7 Users Guide                            310


     2.Press CTRL-Q. PC-File begins spell checking the letter. When
       a misspelled word is encountered, the Spell Check dialog box
       displays.

     3.Make the appropriate corrections using: Ignore, Suggest, Add
       or re- typing for all misspelled words.




     PC-File Version 7 Users Guide                            311



     CHAPTER 16 USING MACROS

     A macro is a shortcut around repetitive work. Instead of
     typing out the name of your company repeatedly, you can record
     a macro and enter it with just two keystrokes. Or you could
     set up a macro to run out a weekly report. Macros are easy to
     set up and easy to use. This chapter explains how.



     Why Use Macros?

     Recording a macro is similar to using a tape recorder. You
     turn on the record option, make the recording, then turn it
     off. Later you can play it back just as it was recorded.

     Macros are essentially a tool to help you cut down on
     repetitive tasks. Any PC-File operation that you perform often
     is a good candidate to become a macro.

     For example, if you find yourself typing out your name and
     address repeatedly while using PC-File's letter writing
     feature, record the operation as a macro. You won't have to
     ever type it again.

     You could also set up a macro to print out a weekly or monthly
     report. Record every step, from opening the appropriate
     database to printing. You can even record a printer setup
     change, switching from a default dot matrix printer to the
     laser printer, then switching back again when the printing is
     completed.

     PC-File also lets you insert a pause in a macro that allows
     user input from the keyboard. Thus, you could enter a new
     title for a report from the keyboard in the middle of
     executing a macro.

     A macro can also be useful for making changes to your records.
     If you have imported a database, for example, and want to
     divide the information in a particular field into two fields,
     a recursive macro can save you a lot of time and effort. With
     a recursive macro, PC-File loops through every record, making
     the requested changes.

     Macro Guidelines

     A macro is a single command that represents a sequence of
     previously- recorded commands and keystrokes. Executing the
     macro results in the entire sequence of commands being played
     back.

     PC-File makes it easy to record and execute macros. Follow
     these guidelines when creating and using macros:

     Macro identifiers




     PC-File Version 7 Users Guide                            312



     In PC-File, macros are identified by one of the 26 letters of
     the alphabet. You can also create a special startup macro and
     identify with an asterisk (*).

     Macro descriptions

     Along with choosing an identifier, you can enter a macro
     description. Enter a description that will remind you what
     operation the macro performs. Descriptions can be up to 30
     characters long.

     Macro window

     PC-File lists all macros in a window. The window displays
     after you record a macro, allowing you to choose an
     identifier. You also display the window to execute, modify, or
     delete a macro.

     Macro files

     Each window of macros is stored in a separate file. Macros
     created with no database open are stored in PCFILE.MAC. This
     file loads automatically when you start PC-File. Macros
     created within a database are stored in a file called
     databasename.MAC. A different file is created for each
     database. The file loads when you open the database. If you
     need more than the 26 macros allowed within one file, you can
     set up an additional file and load it into the database
     whenever it's needed.

     Macro limits

     A macro can contain up to 1000 characters. Some keystrokes,
     such as entering a single letter, require only one character.
     Others, such as pressing ENTER, require up to seven or eight
     characters. Thus, it is impossible to say how many commands
     can be entered in a single macro, but the limit of 1000
     characters is large enough to include most operations. If you
     suspect that an operation will need more than the limit
     allows, you can divide the operation between two macros,
     starting the second macro as part of the operation in the
     first macro.

     Planning a Macro

     Before you record a macro, plan out what you want to do. You
     might want to list the steps involved and run through them
     once. This can save you from having to edit or re-record the
     macro later on.

     Among the points to consider before you record a macro:

     Consider the starting point




     PC-File Version 7 Users Guide                            313


     Think about where you will be in PC-File when you run the
     macro in the future. For example, if you set up a macro to run
     a weekly report, do you start the macro with the database open
     or do you include the opening of the database in the macro?

     Mouse commands are ignored

     Macros do not record mouse commands. Thus, if you use a mouse
     with PC-File, learn the keyboard commands for those steps that
     you normally perform with a mouse. Then, when you record the
     macro, record only keyboard commands. Mouse commands are
     ignored during recording and skipped over when playing back
     the macro.

     Mistakes are recorded

     If you make a mistake while recording a macro, the mistake and
     your correction become part of the macro. For example, if you
     spell a word wrong while typing it in, the mistake, the
     deletion, and the correction all become part of the macro.
     Though the end result is correct, you may want to edit the
     macro after you finish recording it to remove the mistake.

     Arrow keys can be dangerous in macros

     When possible, avoid using the arrow keys to make selections
     from lists. After all, lists change. Whether it is a list of
     files or a list of fields, the options are variable and can
     change from week to week. For example, you can create a new
     report or delete an old one, changing the lineup of report
     files. Or you could redefine the fields in a database.

     Thus, instead of using the arrow keys to highlight a field or
     file, type the field or file name in the text box within the
     respective dialog box. That ensures that any changes to the
     order of the options on the list don't affect the macro.

     Menu option availability can also change, as the result of
     some options being grayed out. It is recommended that you
     press the underlined letter of an option rather than using
     arrow keys to choose it.

     The Macro Options

     Use the options on the Macros menu (or the hot keys, if
     available) to create and use Macros.

     Option: Explanation

     Execute: (CTRL-M or right Display macro window to select and
     run a mouse button) macro

     Begin recording: (CTRL-Y) Start recording a macro

     End recording: (CTRL-Y) Stop recording a macro




     PC-File Version 7 Users Guide                            314


     Modify: Edit a macro description or definition

     Delete: Erase a macro

     Load new set: Create or load a macro file



     Recording a Macro

     You must use the keyboard when recording a macro. Mouse
     commands are ignored during the recording and skipped over
     during execution of the macro.

     PC-File indicates that a macro is being recorded by making an
     audible sound every time you depress a key.

     To record a macro:

     1.Choose Macros from the menu bar.

     2.Choose Begin recording from the Macros menu. As an
       alternative to steps above, press CTRL-Y.

     3.Press ENTER to remove the message window and begin
       recording.

     4.Perform the operation you want to record.

     5.Choose End recording from the Macros menu, or press CTRL-Y
       again.

     6.Identify the macro by choosing a letter from the window that
       displays.

     7.Enter a description of the macro. The description is
       optional, but recommended. You can enter a description of up
       to 30 characters.

     8.Edit the macro contents if necessary. The macro contents
       display the keystrokes you made during the recording of the
       macro in a written format. You can edit the macro by editing
       the written definition. See the section on modifying a macro
       below.

     9.Choose OK when you have finished.

     Pausing for User Input

     You can force a macro to pause and accept keyboard input from
     an operator during execution. This can be handy for entering a
     new title for a report each time you run it, or to include
     specific criteria as part of a formula search.

     To include a pause in a macro:




     PC-File Version 7 Users Guide                            315


     Type {INPUT} at the point where you want keyboard input.

     In most cases, you should be able to insert the pause while
     recording the macro. For example, to force a pause allowing
     the user to enter a report title, you could enter {INPUT} as
     the report title when recording the macro. Obviously, the
     report you print out during the macro recording process would
     have a rather unusual title, but presumably the main purpose
     is to record the macro for future use. As an alternative, you
     could enter a legitimate title, then edit the macro afterwards
     and replace the title keystrokes with {INPUT}.

     The following example illustrates a macro that allows the user
     to enter a new page number on which to start printing after a
     paper jam:

     plrdonation{ENTER}{TAB}{TAB}{TAB}{TAB}{INPUT}{ENTER}{ENTER}

     The macro assumes the sample database Member is open. In the
     first part of the macro, plrdonation, PC-File chooses Print
     from the menu bar (p), Letters from the Print menu (l), and
     Run from the dialog box (r), then types in the name of the
     letter (donation) in the text box of the file selection dialog
     box. {ENTER} closes the file selection dialog box and opens
     the Print options dialog box. The four {TAB}s move the cursor
     to the Start at page # text box, where the user can enter a
     new page number over the default of 1. {ENTER} pressed twice
     resumes the printing.

     During execution of a macro, PC-File beeps twice to indicate
     that information is requested from the user. The message
     "Pausing" displays on the information line when the {INPUT}
     command is in effect. Pressing ENTER causes the macro to
     resume playing.

     Slowing Down a Macro

     If you have a problem when running a macro, it can be
     difficult to see where the problem is occurring when the macro
     is playing back at normal speed. PC-File has a command to slow
     down macro execution to allow you to more easily "debug"
     macros. This command can also be useful to slow down a macro
     for demonstration purposes, so that your audience can see more
     clearly what operations the macro is performing.

     The format of the delay command is:

          {DELAY-nn}

     where "nn" is approximately the number of tenths of seconds
     you want PC-File to delay the execution of each step in the
     macro.




     PC-File Version 7 Users Guide                            316


     Like the INPUT command, in many cases you can insert a DELAY
     command while recording a macro, but more typically you would
     edit a macro and insert it. See "Modifying a Macro" for
     details on editing macros.

     Once issued, a DELAY command continues to take effect for the
     rest of the program session, or until a DELAY command to reset
     macro speed to normal is issued. For this reason, you would
     typically insert or record a DELAY command at the point you
     want the macro to slow down, and then add another DELAY
     command at the end of the macro to reset macro speed to
     normal. For example:

     {DELAY-10} macro commands {DELAY-0}

     where "macro commands" is your macro definition.

     To slow down a macro while recording a macro:

     1.Type {DELAY-nn} (where "nn" is the number of tenths of
       seconds you want to delay each macro step) at the point you
       want PC-File to slow down your macro.

     2.Type {DELAY-0} at the point you want normal macro execution
       speed to resume.

     NOTE: If you do not include a {DELAY-0} command following a
     DELAY command to slow down macro execution, the execution of
     all other macros during that session will be slowed down.

     Defining a Startup Macro

     You can define a startup macro to run automatically when you
     start PC- File or open a database. A startup macro is useful
     for those procedures that you find yourself repeating at the
     beginning of each session. For example, you could use the
     startup macro to make sure a particular index is in effect
     when you open the database, or to print the daily report.

     The startup macro is identified by the asterisk (*). You can
     define a separate startup macro for each database.

     To record a startup macro:

     1.Follow the procedures described above for recording any
       other macro.

     2.When you choose the identifier, choose * instead of a
       letter.

     Only use the startup identifier for a macro that you want to
     run EVERY time you open the database. Otherwise, leave it
     unused.




     PC-File Version 7 Users Guide                            317


     If you do create a startup macro, you can also choose that
     macro from the window, just as you would any other macro, if
     you want to perform the actions that it executes.

     NOTE: Startup macros only run when you open a database. They
     are NOT programmed to run when you load a new macro file into
     memory that includes a startup macro. Loading macro files is
     covered at the end of the chapter.

     Nesting Macros

     You can nest a macro within another macro. You do that by
     recording a macro, then including the execution of that macro
     in the recording of another macro. When you run the parent
     macro, the nested macro plays out as part of the operation.

     Use nested macros to:

       Run a macro as part of the operation of several other macros

       Run a recursive macro (used to loop through records) as part
       of a larger process

       Handle long operations that stretch beyond the limits of a
       single macro

     Nested macros can be used anywhere within their parent macros:
     at the start, in the middle, or at the end. You can nest
     macros down to several levels if you want.

     To include one macro within another, just run the child macro
     as one of the steps while recording the parent macro. A child
     macro takes this format: {CTRL-M}x. The keystroke {CTRL-M}
     displays the macro window. The letter x represents the
     identifier (A through Z or the *) of the nested macro. Thus a
     nested macro looks something like this:

     ...{ENTER}{CTRL-M}B{ALT-E}...

     In this example, the nested macro listed as B in the current
     macro file is executed between the macro keystrokes {ENTER}
     and {ALT-E}.

     Recursive Macros

     A recursive macro is a macro that loops back on itself. It
     works on the same principle as a nested macro, except that
     instead of calling another macro, the macro calls itself. In
     that way, it repeats itself over and over.

     A recursive macro is most useful for modifying records,
     repeating the same change over and over. You define the macro
     so that it modifies a record, then repeats itself, in the
     process moving on to the next record.




     PC-File Version 7 Users Guide                            318


     You can use recursive macros to add or delete data from
     records or move data after splitting or combining fields. For
     example, if you split a name field into first name and last
     name fields, you could use a recursive macro to move data to
     the appropriate fields for each record in the database.

     Recursive macros can be used with all the records in a
     database, or just some of the records.

     Defining a Recursive Macro

     In creating a macro that loops over and over, you want to
     repeat only those steps that are necessary. Therefore, start
     recording a recursive macro with the first record on the
     screen. Don't record those steps involved with searching or
     defining the records you want to see, as the program will loop
     through that process every time it repeats.

     You can, however, create a recursive macro and then nest it
     into another macro that performs the operations necessary to
     bring up the first record, or perhaps into a macro that
     defines the current index.

     To define a recursive macro:

     1.Decide whether you are going to modify all records or some
       records. If modifying all records, display the beginning
       record on the screen. If modifying some records, conduct a
       simple or formula search for the records you want to modify.
       Display the first selected record on the screen.

     2.Make sure you are in Modify mode.

     3.Press CTRL-Y or choose Begin recording from the Macros menu.

     4.Choose OK to remove the message window from the screen and
       begin recording.

     5.Modify the first record. If necessary, use  TAB to move to
       the field or fields you want to modify. Don't use the mouse.

     6.Display the next record, either by pressing CTRL-N (if you
       chose all records) or CTRL-S (if you chose some records).

     7.Type {CTRL-M}x (where "x" is the letter you want to save the
       macro under in step 9).

     8.Press CTRL-Y to stop recording.

     9.Identify the macro by choosing a letter typed for "x" in
       step 7.

     10.  Enter a description of the macro.

     Executing a Macro




     PC-File Version 7 Users Guide                            319


     Before running a macro, make sure you are at the same place in
     the program as you were when you started recording the macro.

     To execute a macro:

     1.Press CTRL-M. As an alternative, choose Execute from the
       Macros menu or press the right mouse button.

     2.Choose the macro from the window. You can choose the macro
       by pressing the letter key that identifies it, by
       highlighting the macro and pressing ENTER, or by clicking on
       it. The macro plays out the recorded steps of the operation
       as you watch.

     If you decide to stop a macro during operation, press ESC.
     However, you can't continue the macro once you stop it. You
     must start over again from the beginning.

     Modifying a Macro

     Each keystroke in a macro is recorded by PC-File in written
     form. You can edit the macro definition to modify or fix a
     macro, thus saving yourself the trouble of having to re-record
     it.

     You can edit the macro description at the same time as you
     edit the macro definition.

     To edit a macro:

     1.Choose Macros from the menu bar.

     2.Choose Modify from the Macros menu.

     3.Choose the macro you want to edit from the macro window. A
       dialog box displays, showing both the macro description and
       the definition.

     4.Make your changes. You can change both the description and
       the definition in this dialog box.

     5.Choose OK when you finish.

     Letters, numbers, and punctuation marks are displayed as you
     type them. As illustrated in the above screen, letters appear
     in lowercase, just as they are typed. For example, if you
     press o to choose the option Open from the File menu, it
     displays in the macro definition as o. Other keys are
     indicated by their name enclosed in braces. For example, ENTER
     is indicated like this: {ENTER}. Operations such as choosing
     menu options and using dialog boxes are indicated by the
     keystrokes used to perform them.

     The following table lists many of the keys and how they appear
     in a macro:




     PC-File Version 7 Users Guide                            320


     KEY             MACRO DEFINITION

     ENTER                {ENTER}

     ESC             {ESC}

     BACKSPACE       {BKSP}

     DELETE          {DEL}

     INSERT          {INS}

     Down arrow           {DOWN}

     Up arrow        {UP}

     Right arrow          {RIGHT}

     Left arrow           {LEFT}

     HOME            {HOME}

     END             {END}

     Function key    {Fn}
      where n = number

     PAGE UP         {PGUP}

     PAGE DOWN       {PGDN}

     TAB             {TAB}



     Though key names appear in uppercase letters, you can enter
     them in lowercase or mixed-case letters when editing the macro
     definition.

     Key combinations that include the SHIFT, CTRL, and ALT keys
     appear as follows:

     {ALT-F}{CTRL-D}{SHIFT-TAB}

     However, when you edit key combinations, you can enter them in
     any of the following formats:

     {c D}{CTRL-D}{CNTL+D}{CONTROL D}

     You can use a space, hyphen, or plus as a separator between
     the keys. For ALT, CTRL, and SHIFT, you can spell the word
     out, use just the initial letter, or use an acceptable
     shortened form (like CTRL and CNTL).




     PC-File Version 7 Users Guide                            321


     NOTE: Though a key combination like SHIFT-TAB displays the
     entire combination, uppercase letters and punctuation that
     require you to use the SHIFT key don't display the SHIFT in
     the macro definition. For example, $ displays as $, not as
     {SHIFT-4}, and T displays as T, not as SHIFT-t.

     Macro files are ASCII files, so you can also edit them with
     any text editor. Maintain the same formatting as displayed.
     You might want to make a backup copy of your file before you
     make too many changes.

     Deleting a Macro

     If you decide you no longer need a macro, you can delete the
     macro. You can then reuse the macro identifier for another
     macro.

     To delete a macro:

     1.Choose Macros from the menu bar.

     2.Choose Delete from the Macros menu.

     3.Choose the macro you want to delete from the macro window.

     4.Choose Y when asked to confirm the deletion.

       The macro and its description is deleted.

     Macro Files

     There are three types of macro files:

       PCFILE.MAC

       Database macro files

       Auxiliary macro files

     Each macro file can contain up to 26 macros labeled A through
     Z, plus a startup macro (*). The macro file name is displayed
     on the title bar of the macro window.

     PC-FILE.MAC loads into memory automatically when you start PC-
     File. It remains in memory until you open a database. You can
     define separate macros in PCFILE.MAC to start each database,
     and even use it as a menu for novice users. If you create a
     startup macro in PCFILE.MAC, it executes automatically when
     you start PC-File. If you want to use it as a menu for novice
     users, define the startup macro as {CTRL-M}, which would open
     the macro window.




     PC-File Version 7 Users Guide                            322


     Once you open a database, PC-File replaces PCFILE.MAC in
     memory with a file named databasename.MAC. Any macro you
     create with a database open is saved to the macro file named
     after the database. Macros saved to this file perform
     operations within the database.

     You can create auxiliary macro files, as well. Once created,
     you can load auxiliary files into memory whenever you need
     them.

     Creating an Auxiliary Macro File

     There are several reasons for defining additional macro files:

       You define more than the maximum number of macros in a
       particular database

       You want to use certain macros in more than one database

       You want to create macros for operations that occur prior to
       opening a database, or that include the opening of a
       database as part of the macro.

     To create a new macro file:

     1.Choose Macros from the menu bar.

     2.Choose Load new set from the Macros menu. A file selection
       dialog box displays.

     3.Enter a name for the new macro file in the file selection
       dialog box. Be sure the new name doesn't conflict with a
       current macro file. You can locate the new macro file in the
       current directory or in another directory if you want.

     4.Choose OK.

     You have created a new macro file with a new name. It is
     currently empty of macros, but is loaded into memory. Any
     macros you define now are stored in this file.

     Loading a Macro File

     To use macros located in a file other than the current file,
     you need to load that file into memory. When you load another
     macro file, the current macro file closes. Only one macro file
     can be open at a time.

     1.To load another macro file:

     2.Choose Macros from the menu bar.

     3.Choose Load new set from the Macros menu. The file selection
       dialog box displays.




     PC-File Version 7 Users Guide                            323


     4.Choose the macro file you want to load. All macro files use
       the extension .MAC.

     The new macro file is loaded into memory. The macros in that
     file are now available to you.




     PC-File Version 7 Users Guide                            324



     CHAPTER 17 CALCULATIONS

     One way to create data in a database is through a calculation.
     This chapter covers the different types of calculations you
     can use in PC-File.



     Introduction

     Calculations and lookups are a fundamental and important part
     of database management. In PC-File, they can be used during
     any of several operations, including:

       Defining a database

       Searching for a record

       Creating Formula Indexes

       Creating a report

       Creating a letter

       Using the calculator (from the Tools menu or by pressing
       CTRL-C)

     This chapter takes an overall look at calculations and
     lookups. An attempt is made to give you a fairly complete look
     at the various types of calculations and some of the ways they
     are used in PC-File. The types of calculations that are
     functional for any particular operation within PC-File are
     described in the section on that operation.

     Calculations include mathematical, date, conditional, and
     random number calculations, string functions and relational
     lookups. They are defined as follows:

     Mathematical calculations let you add, subtract, multiply,
     divide, exponentiate, and find the modulo.

     Date calculations let you perform calculations on dates to
     determine the number of days between dates or a future date.

     Conditional calculations let you make decisions based on the
     contents of a field.

     Random number calculations let you create random numbers and
     use them in further calculations.

     String functions let you convert letters to different cases,
     and manipulate strings of alphanumeric characters.

     Relational lookups let you retrieve data from other databases.




     PC-File Version 7 Users Guide                            325


     Each type of calculation is covered separately in this
     chapter.

     Calculation Guidelines

     Calculations can include field data, system fields, constants,
     functions, and, in reports only, buckets. Normally you use
     only numeric and date fields in calculations, but you can use
     character and logical fields.

     Follow these basic guidelines when using a calculation:

     Punctuation

     With one exception, always start a calculation with a left
     parenthesis and end it with a right parenthesis, like this:

     (Total - Balance)

     The only exception to this rule is with the calculator, which
     you can display by choosing Calculator from the Tools menu or
     pressing CTRL- C. Outside parentheses are not necessary in
     that case, but are permitted.

     Parentheses should always be matched. This means the number of
     left parentheses should equal the number of right parentheses.
     However, if they are not matched, PC-File will still perform
     the calculation. The results may or may not be correct.

     Normally, you must enclose constants within quotation marks.
     Constants can be enclosed in the scan across (~) or sounds-
     like (?) characters in place of quotation marks in searches
     and comparisons. For example, to search for all names that
     sound like Riley, you might enter the expression

          Name = ?Riley?

     Spaces

     You can use spaces freely within a calculation to make the
     formula more readable. For example, each of the following will
     produce the same result:

          (Total-Balance)
          (Total - Balance)
          ( Total - Balance )

     Field Names

     Field names used in calculations only have to contain enough
     of the name to uniquely identify the field. Each of these
     calculations is functionally the same:

          (Total - Balance)
          (Tot - Bal)




     PC-File Version 7 Users Guide                            326


     Sequence Order

     Actions enclosed within parentheses are performed first within
     a calculation, starting with the innermost nested action. For
     example, in the calculation

     ((Washington + Oregon) * 128.25)

     the addition within the inner parentheses (Washington +
     Oregon) is performed first, followed by the multiplication.

     Within a pair of parentheses, the sequence of calculation
     follows this order:

     1.Exponentiation (^)

     2.Multiplication (*), division (/), and modulo (%), each with
       equal priority

     3.Addition (+) and subtraction (-), each with equal priority

     For example, in the calculation

     (1 + 2 * 3 ^ 2 + 1)

     You first square the 3 (3 ^ 2) to produce 9, then multiply by
     2 to get 18, and finally add 1 twice to equal 20.



     Operators

     There are three types of operators: mathematical operators,
     comparison operators, and connecting operators.

     Mathematical operators are used to compute values. They
     include:

     +     Addition

     -     Subtraction

     *     Multiplication

     /     Division

     ^     Exponentiation

     %     Modulo


     The ^ character is SHIFT-6 on most keyboards.

     Exponentiation and modulo are explained in the section on
     mathematical calculations below.




     PC-File Version 7 Users Guide                            327


     Comparison operators determine whether a relationship exists
     between two values. They include:

     =     Equal to

     !=    Not equal to

     >     Greater than

     <     Less than

     >=    Greater than or equal to

     <=    Less than or equal to



     The connecting operators link multiple conditions within a
     calculation. There are two connecting operators defined in PC-
     File:

     &     And

     |     Or


     The symbol for Or is called the pipe character and is SHIFT-\
     on most keyboards. It is not a colon.

     Mathematical Calculations

     The most common type of calculations used in databases are
     basic mathematical computations. These involve the arithmetic
     operations of addition, subtraction, multiplication, and
     division, as well as exponentiation and modulo.

     Mathematical calculations can include fields and/or constants.
     Normally you will use numeric fields in your calculations, but
     you can use character fields as well.

     The following are examples of basic mathematical calculations:

          (Gross - Cost)
          (Price * Tax)
          (Yr_income / 12)
          (Sales * Commission)

     Modulo is the process of determining the remainder after
     dividing one number by another. For example, if you divide 5
     by 2, you get 2 with 1 left over. The 1 left over is the
     modulo. If you divide 2 by 3, you get 0 with 2 left over. The
     modulo is 2. Divide 18 by 6 and you get 3 with 0 left over.
     The modulo is 0. You can use a modulo for a number of
     different purposes. The following example illustrates a modulo
     used in a calculation to skip a line in a report every five
     records during printing:




     PC-File Version 7 Users Guide                            328



          .IF([COUNT*]%5 = 0)
          /1
          .ENDIF

     In this conditional calculation, a line feed (/1) is entered
     whenever the count of records is evenly divisible by 5.

     Exponentiation is used to raise a number to a certain power.
     Use the carot (SHIFT-6 on most keyboards) to indicate an
     exponential calculation. For example, 4 ^ 3 means 4 to the
     third power, or 4 * 4 * 4. The calculation 10 ^ 4 means 10 *
     10 * 10 * 10. You can use n ^ .5 to find the square root for
     any number (n).

     Date and Time Calculations

     Use date calculations to compute the number of days between
     two dates and to generate new dates by adding and subtracting
     days from a given date. Date calculations are performed by
     figuring out the "day number" of a date, which is the number
     of days between January 1, 1901 and the date in question.

     Date calculations can be performed on both date and character
     type fields.

     PC-File also has a time function to return the current system
     time.

     Date Functions

     PC-File supports three date functions to help you perform date
     calculations. The functions carry out the work of converting
     dates to day numbers and day numbers to dates. They are
     explained below and their use illustrated in a number of
     sample calculations that follow.

     (@TODAY#)

     Creates today's day number based on the date provided by your
     computer or network. That number could then be used as part of
     a calculation.

     For example, the day number for July 4, 1992 is 33,423, which
     means that is the number of days between 1/1/1901 and
     7/4/1992.

     (@DAY#,mask)

     This function is similar to the previous function, but
     converts any given date to a day number. The date to be
     converted always appears before the function, either as a
     constant or as a field containing dates.




     PC-File Version 7 Users Guide                            329


     The mask indicates the format of the date that is to be
     converted. Without it the program could get confused in the
     process of converting to a day number. Valid masks are:

          ymd
          ydm
          mdy
          myd
          dmy
          dym
          yymmdd
          yyyymmdd

     The letter y represents year, m represents month, and d
     represents day.

     The three-character masks assume that your dates have at least
     one separator character between month, day, and year. It
     doesn't matter what the separator is. The date conversion
     capabilities are very flexible. Here are some examples of
     dates that will be handled correctly by 3-character masks:

          10/16/91
          10.16.91
          10-16-1991
          Oct. 16, '91
          October 16, 1991
          16 Oct 1991

     The six-character mask yymmdd is used for character type
     fields in which the date has no separator characters. These
     fields are assumed to contain six adjacent digits, two each
     for year, month, and day. For example: 911016.

     The eight-character mask is used for character type fields in
     which the date is entered without separator characters in the
     yyyymmdd format. For example: 19911016.

     (@DATE,mask)

     Converts a day number to a date. This function is normally
     used when you want the calculation to result in an actual
     date.

     The mask indicates the format in which you want the date
     output. You can use any of the three-, six-, or eight-
     character masks used with the previous function, but you must
     include a separator character after the three-character masks.
     For example, use mdy/ to produce a date like 10/16/91 or dmy-
     to produce a date like 16- 10-91. You can also use periods as
     the separator.




     PC-File Version 7 Users Guide                            330


     You can also replace the y with the number 4 to print a four-
     digit year, such as 1992 or 2001. This is especially handy for
     dates that run into the next century. Enter the mask in the
     format md4/ or md4- to produce dates like this: 09/18/1992 or
     09-18-1992.

     Follow the three-character mask with any letter to produce a
     date that includes the month abbreviated to three letters. For
     example, the mask mdyX produces a date like OCT 16, 1991 and
     the mask dmyX produces 16 OCT 91.

     The date functions must be surrounded by parentheses, as shown
     above. TODAY, DATE and DAY must be uppercase and the mask must
     be lowercase. All the functions must be preceded by the at (@)
     sign and the functions TODAY and DAY must be followed by the
     pound (#) sign.

     NOTE: The system field [DATE*] can be used in reports and
     letters to print today's date as determined by your computer.
     [DATE*] is not a function in the same sense as those listed
     above and cannot be used in calculations, as it does not
     produce a day number.

     Sample Date Calculations

     Several date calculations illustrate the use of date
     functions.

     Finding Elapsed Number of Days

     You can determine the number of days that have gone by since a
     certain day, or the number of days between two dates.

     For example, you can determine how many days have elapsed
     since Buy_date. Assume that Buy_date is in the format "mdy".

     ((@TODAY#) - (Buy_date (@DAY#,mdy)))

     The function (@TODAY#) determines the day number for the
     current date. A day number is also calculated for the date
     held in the Buy_date field. The second day number is then
     subtracted from the first to compute the number of days
     elapsed.

     You can also find out how many days it took a customer to pay
     his bill by subtracting Buy_date from Pay_date. Assume that
     both dates are in "mdy" format.

     ((Pay_date (@DAY#,mdy)) - (Buy_date (@DAY#,mdy)))

     First, the date in Pay_date is retrieved and converted to a
     day number. Then, the date in Buy_date is retrieved and
     converted to a day number. Finally, the Buy_date day number is
     subtracted from the Pay_date day number to produce the
     difference in days between the two dates.




     PC-File Version 7 Users Guide                            331


     Comparing dates

     The following two examples show you how to compare one date to
     another date. These examples can be used for searching and
     selecting records.

     The first example selects records where Due_date is later than
     today's date.

     ((Due_date(@DAY#,mdy)) > (@TODAY#))

     The second example selects records where Due_date is earlier
     than the constant of 01/02/91.

     ((Due_date(@DAY#,mdy)) < ("01/02/91"(@DAY#,mdy)))

     Always enclose dates used as constants within quotation marks
     when performing calculations.

     Calculating a future date

     The following example calculates a new date 60 days after the
     CONTACT date.

     (((Contact(@DAY#,mdy))+60) (@DATE,mdy/))

     First, the date in the Contact field is converted to a day
     number. Then 60 is added to the day number. Finally, the day
     number is converted back to a date in the "mdy" format. If
     Contact contained the date 1/2/91, the result would be
     03/03/91.

     The Time Function

     PC-File also provides a time function that returns the current
     system time in military time format (24-hour) for hours and
     minutes (HH:MM). The time function is (@TIMENOW). You can use
     (@TIMENOW) as a calculation in a character field to return the
     current time. Or you can use it in the pop-up calculator
     (CTRL-C) to produce an on-demand time stamp.

     The time function only returns a character result and cannot
     be used in mathematical calculations.

     Conditional Calculations

     You often have situations where you want to perform an
     operation, but only under certain conditions. For example, you
     may want to add sales tax to a price only when the customer
     lives in the state of Washington. Or you may want to issue a
     refund, but only if an item is returned within 10 days. For
     these types of situations, use conditional calculations.

     Conditional calculations use IF commands in reports and
     letters, but elsewhere they must be set up to work without
     them. IF commands always follow a set format:




     PC-File Version 7 Users Guide                            332



          .IF (comparison statement)
          Things to do if true
          .ELSE
          Things to do if false
          .ENDIF

     You can use IF commands in reports or letters only. Every .IF
     statement must have a matching .ENDIF statement. The .ELSE
     statement is optional. Place each part of the command on a
     separate line by itself.

     To determine the price of items in which some items are
     taxable and some are not, you might set up a conditional
     calculation like this:

          .IF (Taxable = "Y")
          (Qty * Amt * 1.06)
          .ELSE
          (Qty * Amt)
          .ENDIF

     This calculation assumes you have a field called Taxable in
     which you can enter Y or N, as well as fields Qty and Amt. If
     the data in the field Taxable is Y, the calculation determines
     the total price including the tax of 6 percent. (If you just
     multiply the amount by the quantity by .06, you determine only
     the tax; multiplying the amount by the quantity by 1.06 gives
     you the total price.) If the data in the field Taxable is not
     Y, the tax is not multiplied in.

     You can simulate an IF command for use in defining a field. To
     simulate the above example in a field, you might enter this
     calculation to define a field:

     (((Tax ="Y")*Qty*Amt*1.06)+((Tax ="N")*Qty*Amt))

     This calculation works because PC-File assigns a value of 1 to
     true statements and a value of 0 to false statements. Thus, if
     the data in the field called Tax is Y, the first half of the
     equation is true and the second half of the equation is false.
     In that case the tax is applied, because the first half of the
     equation is multiplied by 1 and the second half by 0.
     Multiplying a number by 0 results in 0. If the data in the
     field called Tax is N, then the first half of the equation is
     false and
     no tax is included.

     Random Number Calculations

     Use random number calculations to pull records from your
     database at random. Random record searches are particularly
     handy for market research or to pull up a random selection of
     your members, say to set up a tennis tournament.




     PC-File Version 7 Users Guide                            333


     PC-File provides the function (@RANDOM#) to do much of the
     work for you. This function creates a random number between 0
     and 1.

     The easiest way to use the Random number function is to define
     a separate random number field within your database. Then
     enter the function as a calculation in the field
     characteristics dialog box. The field should be numeric and
     contain several characters to the right of the decimal. The
     data in the field displays as a random number, like .05324 and
     .00812. You can then sort on this field and choose the first
     so many records to give yourself a random selection.

     Though you can sort on a field that contains random numbers,
     random number calculations can't be used in a Formula index.

     String Functions

     The term string is used as shorthand for the phrase "string of
     characters"-a group or row of alphanumeric characters
     (letters, numbers, spaces, and punctuation characters). For
     example, anything you might enter into a field can be
     considered a string, such as: names, part numbers, phone
     numbers, prices, dates, or zip codes. The plural, "strings",
     refers to separate groups of characters from more than one
     source. In PC-File, sources of strings are:

       The contents of a field

       A "substring" or portion of a field, such as [DATE,7,2]

       A string of characters surrounded by quotes, such as "ab"

       A report command language system field, such as [DATE*]

       A report command language total or string bucket, such as
       [`ABC] or [`$ABC]

       The result of a calculation that produces a string, such as
       some date calculations, or the string calculations described
       below

     The term "string" also implies processing data solely as a
     series characters-not as numeric values, dates, or logical
     values. For example, the string "123" is processed differently
     from the numeric value "123." The string "123" is processed as
     the character "one" followed by the characters "two" and
     "three." Whereas, the numeric value "123" is processed as the
     value "one hundred and twenty-three." This does not mean that
     the source of a string can only be a character- type field or
     the result
     of an operation on characters. PC-File can process the
     contents of any field type as a string, even the results of
     numeric calculations can be treated as strings.

     PC-File's string functions let you:




     PC-File Version 7 Users Guide                            334



       Convert letters to upper-, lower-, or mixed case

       Isolate the first or last word in a string of words

       Trim spaces in a string

       Join strings of characters

     String functions can be used wherever PC-File calculations can
     be entered: field calculations, report calculations, .IF
     statement conditions, formula searches, with the pop-up
     calculator, and when redefining databases. Except, string
     functions cannot be used when defining a formula index, use
     dBASE equivalents-such as UPPER( ) or LOWER( )-instead. String
     function names must be entered in uppercase.

     "Argument" in following information refers to any of the
     following:

       A field name

       A "substring" or portion of a field, such as [DATE,7,2]

       A string of characters surrounded by quotation marks, for
       example: "This is a string of characters"

       A report language system field, such as [DATE*]

       A report language total bucket or string bucket, such as
       [`total] or [`$string]

       A nested calculation, such as (UPCASE(LAST(field1)))

     System field names must be in uppercase letters and surrounded
     with square [ ] brackets. Bucket names must be surrounded with
     square [ ] brackets. Nested calculations must have properly
     balanced parentheses.

     When using a report Language format, the entire string
     calculation must be contained on one line (which is true of
     any calculation in a report format). When using PC-File's
     Language Editor, this limits your calculations to 78
     characters, the maximum width the Language Editor can handle.
     However, you can edit a report .REP file with an editor or
     word processor outside of PC-File that allows for longer lines
     as long as that program can save unformatted files (sometimes
     referred to as "ASCII
     files" or "DOS text files").

     UPCASE(argument)

     This function converts all letter characters in a string to
     uppercase. Numbers and punctuation are not affected.




     PC-File Version 7 Users Guide                            335


     For example, if a field COMPANY contained the entry "Zippy-
     Cleen-2u," the calculation

     (UPCASE(COMPANY))

     would return "ZIPPY-CLEEN-2U."

     LOWCASE(argument)

     This function converts all letter characters in a string to
     lowercase. Numbers and punctuation are not affected.

     For example, if a field COMPANY contained the entry "Zippy-
     Cleen-2U," the calculation

     (LOWCASE(COMPANY))

     would return "zippy-cleen-2u."

     MIXCASE(argument)

     This function converts the first letter in each word in a
     string into uppercase and all following letters in each word
     to lowercase. For this purpose, a word is defined as a string
     of letters separated by anything other than a letter. Numbers
     and punctuation are not affected. This function is commonly
     used to change a name field with all upper case letters into
     mixed case.

     For example, if a field NAME contained the entry "JANE SMITH-
     JONES," the calculation

     (MIXCASE(NAME))

     would return "Jane Smith-Jones." Note that "Jones" in the
     hyphenated last name is left as an uppercase letter. If the
     result from the previous example, "zippy-cleen-2u" were used:

     (MIXCASE(COMPANY))

     would return "Zippy-Cleen-2U." Note that the "u" following "2"
     is made uppercase, because both the hyphen and "2" are treated
     as space between words.

     LASTWORD(argument)

     This function isolates the last word in a string. For this
     purpose, unlike MIXCASE, a word is defined as any string of
     characters separated by at least one space.

     For example, if a field NAME contained the entry "Jane Smith-
     Jones," the calculation

     (LASTWORD(NAME))




     PC-File Version 7 Users Guide                            336


     would return "Smith-Jones." Note that in this case the full
     hyphenated name is treated as one word, where the MIXCASE
     function would treat it as two separate words.

     FIRSTWORD(argument)

     This function isolates the first word in a string. For this
     purpose, a word is defined as any string of characters
     separated by at least one space.

     For example, if a field COMPANY contained the entry "Wilton-
     Smythe & Barney," the calculation

     (FIRSTWORD(COMPANY))

     would return "Wilton-Smythe." Note that in this case the full
     hyphenated name is treated as one word, where the MIXCASE
     function would treat it as two separate words.

     TRIM(argument)

     This function removes all space characters from the right end
     of a string. Most commonly this function is used to remove
     trailing spaces from the contents of a field when joining two
     or more strings together (see below).

     Concatenation or Joining of Strings

     "Concatenation" in programming and application languages
     refers to joining strings of characters together. PC-File
     symbolizes this operation with the semicolon (;), which is
     used like plus or minus signs in arithmetic calculations by
     placing the semicolon between strings or string calculations
     you want joined.

     For example, to join the two fields FIRST and LAST with a
     space between them, trimming any trailing spaces from FIRST,
     you would use the calculation

     (TRIM(FIRST);" ";LAST)

     which for a record containing "John" in FIRST and "Jones" in
     LAST would return "John Jones."

     Note that " " is used to put a space between the two fields
     because TRIM removes all trailing spaces from FIRST.

     Without using the TRIM function and " ", the full field length
     of FIRST (including trailing spaces) would appear before LAST.
     For example, if FIRST is a 10-character long field, the
     calculation:

     (FIRST;LAST)

     using the same data returns "John Jones."




     PC-File Version 7 Users Guide                            337


     You can use any of the string functions listed above as
     arguments. For example, the calculation:

     ("MR. ";UPPER(TRIM(FIRST));" ";UPPER(LAST))

     returns "MR. JOHN JONES."

     NOTE: You do not have to use the outermost set of parentheses
     when entering a string calculation into a field, when using
     the pop-up calculator, or when entering a calculation in a
     Free Form report. A set of parentheses is assumed in these
     areas of the program. For example, in any of the
     aforementioned areas you could type:

     TRIM(FIRST);" ";LAST

     However, you must use an outermost set of parentheses when
     entering string calculations into a report command format with
     the Language Editor. When using the Language Editor, the same
     calculation would have to be entered:

     (TRIM(FIRST);" ";LAST)

     Also, using square brackets around field names is optional in
     the Language editor. For example,

     (TRIM([FIRST]);" ";[LAST])

     is accepted by PC-File. However, do not use angle brackets
     around field names in any calculations.

     Relational Lookups

     Relational lookups are calculations only in the broadest sense
     of the word. They don't involve the mathematics associated
     with other calculations, but they do go through some
     contortions to provide an answer for you.

     Relational lookups establish a link between two databases and
     allow you to copy data from one database into another. For
     example, you could look up a company name and address in a
     database and copy it into another database to print out with
     each invoice.

     Relational lookups require that the two databases share common
     data. In other words, both databases must have a field with
     the same field type and contain records that have matching
     data. You can only perform a lookup for matching data in one
     shared field.

     For example, to copy a name and address from a database, you
     might use a customer number field shared by both databases. Or
     you could have a shared company name field, and copy the
     address from the second database.




     PC-File Version 7 Users Guide                            338


     NOTE: If a relational lookup field calculation finds no
     matching record, spaces are returned. This will write over,
     that is, "blank out" any current field entry and prevent you
     from overriding the lookup. If you need to prevent this from
     happening, choose Only When Field is Empty when prompted "When
     to apply this operation?" when entering the lookup. Also, if
     more than one record matches, only data from the first record
     found is returned.

     There are two types of lookups in PC-File: a basic lookup and
     a fast lookup. You can use the fast lookup only after you have
     used a basic lookup.

     Defining Basic Lookups

     You can define basic lookups using either of two methods:

       The dialog box method

       The formula method

     The simplest and most reliable way of defining a basic lookup
     is using the dialog box method. The main reason to enter
     relational lookups using the formula method is to enter
     specialized forms of lookups such as a fast lookup.

     Using the Dialog Box Method

     You can define basic lookups using the dialog box method
     throughout PC- File in most places lookups can be used:

       When creating and redefining databases

       When defining Free Form and Language format reports

       When writing Letters

       When using the pop-up calculator (CTRL-C)

     Depending on what area of the PC-File you are in, you either
     press a command button (the Lookup button when defining,
     redefining, or using the Language format; the LU button on the
     pop-up calculator; and the L button after choosing the Insert
     button when writing a letter) or make a menu selection (when
     using the Free Form format) to invoke the first lookup dialog
     box. The rest of the defining process works identically for
     all program areas.

     Choosing the Lookup Database




     PC-File Version 7 Users Guide                            339


     Relational lookups are defined using two dialog boxes. The
     first dialog box is used to pick which database you want to
     copy data from. This database is called the lookup database.
     The dialog box used to choose the lookup database looks and
     works same as the file selection boxes used throughout PC-File
     to open databases and other files. See Chapter 1, "Selecting a
     File" for details on how to use the features of a file
     selection dialog box.

     Defining the Fields to Match With and Copy From

     Once you chose the database to copy from, a second dialog box
     displays.

     The top two lines of the dialog box list the two databases
     affected by the lookup. The Current file is the database
     currently open into which the lookup data will be copied. The
     Lookup file is the database selected with the previous dialog
     box from which the lookup data will be copied.

     The two list boxes on either side of "MATCH WITH" determine
     which fields link the two databases. Generally this is a field
     that contains something that is uniquely in common between the
     two databases, such as a part number, ID number, or social
     security number. The two fields don't have to have the same
     name, but they do have to be of the same field type and
     length. Choose the field to match with from the current
     database with the left "Field" list box. Choose the field to
     match with from the lookup database with the right "Lookup
     field" list box.

     Choose which field to retrieve the lookup data from with the
     "Retrieve field" list box in the lower right corner of the
     Define Lookup dialog box.

     What appears below the heading "Current Field" in the lower
     left corner depends on what area of the program you are in:

       The field that the lookup data will be copied into displays,
       if you are entering a calculation when defining or
       redefining a database.

       "Calculator" displays when using the LU button on the pop-up
       calculator.

       "Report" displays when defining a relational lookup for a
       report.

     Choosing OK either defines the relational lookup formula for
     the field or report, or displays the result when using the
     pop-up calculator.

     To define a basic lookup using the dialog box method:




     PC-File Version 7 Users Guide                            340


     1.Depending on what area of the PC-File you are in, either
       choose the Lookup command button or choose the Lookup menu
       selection to invoke the first lookup dialog box.

     2.Choose the Lookup database from the Files list box. Use the
       directories list box or the Search buttons if the database
       you want to copy from is not in the current directory.

     3.Choose the field in the current database to match with from
       the upper left-hand list box.

     4.Choose the field in the lookup database to match with from
       the upper right-hand list box.

     5.Choose the field to copy from using the lower right-hand
       list box.

     6.Choose OK to continue.


     Using the Formula Method

     You can define basic lookups using the formula method wherever
     you can type other PC-File calculations, such as: in field
     calculations, in reports and letters, and when using the pop-
     up calculator. You can even use relational lookups as part of
     a formula search or an .IF statement condition.

     To perform a lookup, you need to know four things:

       the name of the shared field in the current database

       the name of the lookup database

       the name of the shared field in the lookup database

       the name of the lookup field in the lookup database

     The lookup field is the field from which you want to pull data
     into the current database.

     To use a lookup, follow this format:

          (@shared field in current database,lookup database,shared
          field in lookup database,lookup field)

     Enclose relational lookups in parentheses, and always use the
     at (@) sign at the beginning of the lookup expression. Then
     list the shared field in the current database, the lookup
     database, the shared field in the lookup database, and finally
     the lookup field.

     A relational lookup might look something like this:

          (@member_no,member,member_no,firstname)




     PC-File Version 7 Users Guide                            341


     You could read that lookup like this:

     "Using the Member_no field in the current database, go to the
     Members database and find the record with the same data in the
     Member_no field in that database. Then retrieve the data from
     the Firstname field."

     The shared fields don't have to have the same name, though
     they do have to be of the same field type and length. The
     lookup could look like this instead:

     (@member_no,member,number,firstname)

     The Member_no and Number fields contain the same data.

     The lookup database name can include a path if necessary. For
     example, if the Members database were on a different
     directory, you could enter the lookup like this:

     (@member_no,\pcfile\member,member_no,firstname)

     You can include a drive name if necessary, but do NOT include
     a file extension.

     Fast Lookups

     When you want to retrieve two or more fields from the same
     record of the same database, you can use a fast lookup for all
     fields after the first lookup. For the first lookup, use a
     basic lookup defined with either method outlined above. For
     all subsequent lookups from that database use the format:

     (@*,lookup data)

     With the Member database, subsequent lookups might look like
     this:

          (@*,lastname)
          (@*,address1)
          (@*,city)

     The fast lookup assumes that you are looking in the same
     database and the same record as you used in the first lookup.
     Each time PC-File performs a basic lookup, it memorizes the
     entire matching record. Subsequent fast lookups can pull any
     fields from that memorized record without having to search the
     lookup database. In that way you could pull in the complete
     name and address contained in another database quickly and
     easily.




     PC-File Version 7 Users Guide                            342


     NOTE: Fast lookups will only work correctly if a basic lookup
     has been performed as the first lookup within the same record.
     PC-File performs field calculations in the same order fields
     are accessed. For this reason, you must make sure that the
     field that you entered the basic lookup into is accessed
     before any fields containing fast lookups. See Chapter 3,
     "Modifying a Database Structure" if you need to change this.
     For the same reason, when entering the lookups make sure that
     all lookups are
     performed at the same time. If you have any doubts about any
     of these requirements, do not use Fast lookups.

     Troubleshooting Calculations

     If the calculations in your database don't give you the
     correct results, investigate the following:

       Check field names to make sure they are spelled correctly.
       If you have abbreviated field names, make sure PC-File can
       tell which fields you mean.

       Make sure you have used the correct operator. Use the
       asterisk for multiplication, not an x. Use != for "not equal
       to" and the pipe character, which is SHIFT-backslash on most
       keyboards, for "or."

       Check your expression to see that you have an equal number
       of left and right parentheses.

       Make sure date, time, and random number functions are
       entered in uppercase letters and that the functions are
       preceded by the at (@) sign. The mask following an @DAY#
       function, e.g. mdy/, must be in lowercase. All but the
       (@DATE) and (@TIMENOW) functions must be followed by the
       pound (#) sign.

       For relational lookups, make sure the lookup database
       contains the data you think it does. If necessary, conduct a
       search in the lookup database to confirm that it does in
       fact contain the data.

       Lookup data may not be returned if the index in the lookup
       database is damaged. Rebuild the indexes if necessary.

     For explanations of error messages, see Appendix D.




     PC-File Version 7 Users Guide                            343



     CHAPTER 18 BATCH POSTING

     The Batch Post command on the Utilities menu is a powerful
     feature that lets you to update a remote or "destination"
     database with information from the current or "source"
     database. This operation is referred to as "posting." Also,
     for added security, PC-File has a Batch Post "undo" feature
     that allows you to restore data changed by your last posting.

     What is Batch Posting?

     Batch posting sends data from the current or source database
     to a remote or destination database. Most typically, the
     source database is a database used to keep track of
     transactions liking billing or invoicing. Likewise, the
     destination database is a "master" database used to track
     items such as account balances or inventory. In order for
     systems like this to work properly, you must have a field
     containing data held in common between both databases that can
     be used to establish the desired
     link-such as an account number, social security number, ID
     number, part number, or SKU number.

     Just like a relational lookup, PC-File establishes the link
     between the two databases by matching the data held in common
     between the two databases. Only one field in each database can
     be used to establish the link. For example, an account number
     field in one database can be used as a link to post to any
     other database with a field containing matching account
     numbers.

     Unlike a relational lookup, posting cannot be used like a
     field calculation that is performed whenever a record is added
     or modified. Posting must be performed as a "batch" operation
     by running a post definition on demand using the Run option on
     the Batch Post dialog box. You are also given the option to
     run a posting immediately after you define it. This batch mode
     of operation distinguishes PC-File's Batch Post from "fully
     relational" programs that will automatically post data
     whenever the
     linked data in the source database is changed.

     You must run a Batch Post from the source database-the
     database in which the posting was originally defined. When
     running a Batch Post you have the option to post from all or
     selected records in the source database.

     A Batch Post definition can only post from one source database
     to one destination database. However, you can define as many
     Batch Post definitions as you want to allow you to post from
     one database to any number of destination databases. And, if
     you wish, you could automate the process by defining a macro
     to run each Batch Post definition in succession.

     Which Records Are Affected?




     PC-File Version 7 Users Guide                            344



     When posting, the relationship between records in the source
     and destination databases can be:

     One to One

     One matching record from the source database posts to one
     record in the destination database. This assumes each matching
     record is unique in its respective database, or that you have
     selected to post only records from the source database that
     have a unique match in the destination database.

     One to Many

     One record from the source database posts to one or more
     matching records in the destination database. This assumes
     that each record in the source database matches one or more
     records in the destination database. Or, that you have
     selected a set of non- duplicate records that have one or more
     matches each in the destination database.

     Many to One

     Many matching records from the source database post to one
     matching record in the destination database. This assumes that
     there is at least one set of records with duplicate match
     fields in the source database that match a unique record in
     the source database.

     The form the relationship between the databases involved in a
     Batch Post operation takes depends on either how the data is
     entered, or which records you select when posting. For
     example, let's say you want to post only last month's receipts
     from database A to database B. Either database A must contain
     only last month's records-you deleted or archived any previous
     month's records-or you must choose Some when running the
     posting and search on a date field to select only last month's
     records.


     NOTE: When performing a One to Many posting, make sure that
     the matching field in the destination database is indexed.
     Otherwise, all matches won't be found and posted. This is a
     good idea as a general rule, as this will also speed up the
     searches performed when posting.


     Post Actions

     A Batch Post operation can consist of one or more post
     actions. A post action is a transaction between one field in
     the source database and one field in the destination database.
     Each post action can perform one of the following operations
     on the designated destination database field:

     Replace




     PC-File Version 7 Users Guide                            345


     Replaces with data from the source database

     Add
     Adds the value from the source database

     Subtract From
     Subtracts the value from the source database

     Multiply
     Multiplies by the value from the source database

     Divide Into
     Divides by the value from the source database

     The last four options are mathematical operations, which are
     only appropriate for numeric values.

     For example, you could update an Inventory database from a
     Transactions database by choosing to match on the part number
     field, then define your post action to subtract the Quantity
     field in the Transactions database from the Quantity field in
     the Inventory database.

     Likewise, an Accounts database can be updated by using Add,
     for credits, or Subtract From, for debits, as post actions
     from a Transactions database.


     Defining a Batch Post

     To define a Batch Post operation, you must first open the
     database you want to post from. Then choose the Batch Post
     option from the Utilities menu which displays the Destination
     File dialog box. This dialog box works identically to the Open
     dialog box that you use to open a database. See "Selecting a
     File" in Chapter 1 for details on how to use a file selection
     dialog box. The database you choose with the Destination File
     dialog box is the destination database-the database the source
     database (the database currently open) posts to.

     Once you have chosen the destination database, the Define
     Posting dialog is displayed.

     This dialog box is organized into two columns of list boxes to
     define post actions, with a large list box at the bottom that
     summarizes the post actions defined. The two list boxes in the
     left column list fields from the source database and the two
     list boxes in the right column lists fields from the
     destination database.

     Choosing the "Match to" Fields




     PC-File Version 7 Users Guide                            346


     The first list box in each column (the "match to" list boxes)
     defines which field from each database to match on. You can
     only choose one field from the source database to match on one
     field from the destination database. Choose a field from each
     "match to" list box by clicking on the desired field, or
     highlighting the field and pressing ENTER. A checkmark appears
     to the left indicating the field is selected.

     Defining Post Actions

     The second list box in each column (the "post to" list boxes)
     and the radio buttons between them define how each post action
     is performed. Defining a post action is a four-step process:

     1.Choosing the source field from the left list box.

     2.Choosing the radio button to determine how to post the
       source data: Replace, Add, Subtract, Multiply, or Divide.

     3.Choosing the destination field to post to from the right
       list box.

     4.Choosing the Accept command button to define the post
       action.

     After you choose the Accept command button, the defined post
     action appears in the Post Actions list box. Continue this
     four-step process to define as many post actions as you
     desire. If you define more post actions than can be displayed
     at once in the list box, use the scroll bar to the right of
     the post actions list box to review your post actions. If you
     make a mistake when defining a post action, highlight its
     description in the post actions list box and choose Undo 1.

     Choose OK to complete the posting definition. You are then
     asked if you want to save the post definition. Choose Yes and
     save the file, if you intend to run this post operation more
     than once, or if you will not being running it immediately
     after it is defined. Choose No if you want to run this post
     operation immediately after defining it and do not need to
     save it.


     To define a Batch Post:

     1.Choose Utilities from the menu bar.

     2.Choose Batch Post.

     3.Choose Define a New Posting.

     4.Choose the destination database using the file selection
       dialog box. Choose OK to continue.

     5.Choose the Match to field for the source database from the
       first list box on the left.




     PC-File Version 7 Users Guide                            347



     6.Choose the Match to field for the destination database from
       the first list box on the right.

     7.Perform the following four steps using the Post to list
       boxes and radio buttons between them for each post action
       you want to define:

       Choose the source field from the left-hand list box.

       Choose the radio button to determine how to post the source
       data.

       Choose the destination field to post to from the right-hand
       list box.

       Choose the Accept command button to define the post action.
       Repeat these steps for every post action you want to define.

     8.Choose OK to proceed.

     9.Save your posting definition, if you want to use it again in
       the future.

     10.  Choose to run the post definition, if desired.

     Running a Batch Post

     You can run your post operation either immediately after
     defining it, or if you have saved the post definition, by
     choosing the Run option on the Batch Post dialog box. You must
     be in the source database you originally defined the posting
     from to run a previously defined posting.

     When running a posting you can post from all or some records.
     If you choose All records, every record in the source database
     is checked for a match or matches in the destination database-
     when a match is found the post action or actions are performed
     on that record. This continues until all records in the source
     database are processed. If you choose Some records, you enter
     a Simple, Formula, or Global search to select which records
     from the source database will be processed. Again, only
     matching records are posted.




     PC-File Version 7 Users Guide                            348


     Regardless of whether you choose to post from All or Some
     records, the first record you are presented with displays a
     dialog box with the prompt, "Post from this record?" with Yes,
     No, All, or Quit buttons. Generally you will choose All to
     have PC-File automatically process your records. However, you
     can use the Yes and No buttons to manually choose which of the
     records to process. Choosing Yes accepts that record and
     proceeds to the next one. Answering Yes does not necessarily
     mean that the records data will be posted to the destination
     database- data will be posted only if the two "match to"
     fields' data matches. Choosing No omits that record and
     proceeds to the next one. Choosing Quit stops the posting
     process.

     To run a previously defined Batch Post:

     1.Choose Utilities.

     2.Choose Batch Post.

     3.Choose the desired post definition.

     4.Choose All or Some.

     5.If you chose All above, the first record to post from is
       displayed, prompting "Post from this record?
       Yes/No/All/Quit." Answer appropriately to post data.

     6.If you chose Some proceed to next step.

     7.If you chose Some above, choose the method to select records
       with and enter your selection criteria. Refer to the
       appropriate section under "Conducting a Search" for details.

     8.Answer the "Post from this Record?" prompt appropriately to
       post data.

     UnPost-Undoing a Batch Post

     The UnPost option on the Batch Post dialog box allows you to
     "undo" the last posting you performed on a database. PC-File
     maintains a log file of all data that is changed by a post
     operation. This log file is saved under the same name as the
     affected database with a .LOG extension. For example, a
     database named BALANCE would have an UnPost log file named
     BALANCE.LOG. To undo the most recent posting to a database,
     you must be in the database that was posted to (not the
     database the posting was defined from) and choose the UnPost
     option on the Batch Post dialog box.

     The UnPost log file only keeps track of the changes made by
     the last posting. Therefore, if you perform a posting in error
     you must immediately restore changes before performing any
     other posting operation on that database.




     PC-File Version 7 Users Guide                            349


     For additional security, you can make backup copies of .LOG
     files before performing additional postings to a database.
     Then, if you need to restore changed data, you can copy the
     backup copy of the .LOG file into the same directory as the
     affected database and use the UnPost option to restore data.
     Note that the .LOG file only keeps track of data changed in a
     single post operation. If you have made several postings and
     wish to restore all data changed across all those postings,
     you must have backed up .LOG files between every posting
     (either to separate floppies or by renaming each .LOG file to
     a unique name). Then you must UnPost each .LOG file in order
     from the most recent posting back to the earliest posting you
     want to undo.

     For the greatest level of security, back up the entire
     database before any posting.

     To undo a Batch Post:

     1.Open the database that you want to UnPost.

     2.Choose Utilities.

     3.Choose UnPost. A dialog box displays showing the date the
       database was last changed. If this date later than the time
       of the posting you want to undo, proceeding probably will
       not restore the desired data. You must either copy the
       appropriate databasename.LOG file into your data directory
       and repeat steps 1-3, or restore a backup of the database
       itself.

     4.Choose Yes to continue.

     When the UnPost operation is finished an information box
     displays showing the number of records restored.




     PC-File Version 7 Users Guide                            350



     CHAPTER 19 MEMORY USAGE AND PERFORMANCE

     PC-File performance has been sped up using a number of
     different methods. Some improvements relate to specifically to
     the program's internal workings: reworking and optimization of
     the way the program displays screen images and improvements in
     the compiler technology. Other improvements have been made in
     the way PC-File exploits your system's memory and disk
     resources.



     Kinds of Memory

     Before discussing how PC-File uses memory, let's briefly cover
     the various kinds of memory available on PC systems.

     A PC system can have up to 3 kinds of RAM memory storage:

     Conventional memory

     The memory that standard DOS programs can use, up to a maximum
     of 640K. DOS COMMAND.COM uses some conventional memory, any
     device drivers or memory-resident programs (TSR's) listed in
     your CONFIG.SYS and AUTOEXEC.BAT files use additional memory.
     The amount of conventional memory you have available to run
     programs in after booting your computer is displayed on the
     last line of the report listed by running the DOS CHKDSK
     command.

     Extended memory (XMS)

     Memory in addition to conventional memory, not available on
     8086/88 computers, only on 80286 or higher models. Available
     through the use of add-on hardware cards, and directly on the
     motherboard on many newer model computers.

     Expanded memory (EMS)

     Memory in addition to conventional memory, so-called "paged"
     memory based on standards established by Lotus, Intel and
     Microsoft (LIM EMS). Generally available through the use of an
     add-on hardware card. 386 and 486 computers can make extended
     memory act as expanded memory using device drivers such as
     EMM386.EXE (which is included with MS-DOS 5.0).

     How PC-File Uses Memory

     When PC-File is running, pressing CTRL-Z displays an
     information window.

     Each number listed has the following significance:

     Available RAM




     PC-File Version 7 Users Guide                            351


     The total amount of conventional memory currently available
     within PC-File, not counting memory for Overlay Buffer or Disk
     Buffer (if any).

     Minimum RAM

     The lowest amount of conventional memory available at any
     point within a session.

     Overlay Buffer

     The amount of conventional memory set aside to swap "overlays"
     in and out of memory. Overlays are portions of the program
     that are ordinarily loaded from disk whenever they are
     required. When the overlay buffer is active, the first time
     PC-File requires an overlay it copies the overlay from disk
     into the overlay buffer. Once an overlay has been copied to
     memory, PC-File can make subsequent accesses much more
     quickly.

     Disk Buffer

     The amount of conventional memory set aside to cache data
     records and index entries for faster database access. This
     number will vary from 0 to 16000 depending on how much
     conventional memory is available when PC-File is started.

     Using Extended (or Expanded) Memory

     If PC-File has detected either extended or expanded memory on
     your system, the last line in the box will read either "Using
     extended memory" or "Using expanded memory." PC-File will not
     use both kinds of memory at the same time. If your machine has
     both kinds of memory, PC-File will use expanded memory because
     it is less likely to conflict with other programs. PC-File
     does not list the amount of extended or expanded memory in
     use. It uses as much as it needs, typically not more than
     500K.

     PC-File can use this additional memory to swap overlays in the
     same fashion described under "Overlay Buffer." Additionally,
     PC-File can use expanded memory to swap the contents of
     conventional memory when using the Drop to DOS command on the
     Tools menu and choosing to free memory, when using the Labels
     command on the Utilities menu, or when graphing.

     Memory Usage Configuration Commands




     PC-File Version 7 Users Guide                            352


     Two configuration commands have been added to PC-File to allow
     you to control whether or not PC-File will use expanded or
     extended memory: /NOXMS and /NOEMS. These can be used like all
     configuration commands, either directly from the DOS prompt
     when starting PC-File, or by editing your .PRO file with any
     editor or word processor that can save unformatted ASCII
     files. See Chapter 13, "Advanced Profile Parameters" for
     details on editing a profile or using configuration commands
     at the DOS prompt.

     /NOXMS
     Prevents PC-File from using extended memory

     /NOEMS
     Prevents PC-File from using expanded memory

     You might need to use these commands if PC-File's use of
     extended or expanded memory appears to be in conflict with
     other programs. Also, if your systems has both kinds of
     memory, PC-File will use expanded (EMS) memory by default.
     Using just the /NOEMS configuration command forces PC-File to
     use extended memory instead.

     APPENDIX A

     IF YOU NEED TECHNICAL SUPPORT



     If you are unable to find the answers to your questions in the
     manuals or help windows, we invite you to call our Technical
     Support department. They will be happy to answer any technical
     questions you have about PC-File.

     To receive technical support, call 1-900-454-8000 Monday
     through Friday. If you are unable to use the 900 number for
     technical support or would prefer a prepaid support plan that
     provides for unlimited technical support on an annual basis,
     please contact us at 1-800-528-8866 for information on
     purchasing a Product Support Plan.

     If you have a modem, you can also contact our Technical
     Support department on our bulletin board or on CompuServe. Our
     bulletin board operates 24 hours a day, 7 days a week. The
     bulletin board phone number is 206-454-7875. There is no
     charge to use our bulletin board, other than your long
     distance charge. You can reach our Technical Support
     department on CompuServe in Section 1 of the PCVENA forum.
     Type go pcvena at the CompuServe ! prompt to access the PCVENA
     forum. Regular connect charges apply when using CompuServe.

     To help us help you, please be prepared to provide the
     following information when you call.

       Computer brand and model




     PC-File Version 7 Users Guide                            353


       Available RAM (as reported by DOS CHKDSK or MEM)

       DOS version being used

       Memory resident programs installed

       Printer brand and model

       Monitor brand and model

       Exact wording of any error message(s)

     If possible, be at your computer when you call, with your
     computer on. Also, it often helps if you have available the
     database description printout (produced using Database
     Description on the Utilities menu) for the database in
     question, as well as a printout of any report format you are
     having problems with.




     PC-File Version 7 Users Guide                            354



     APPENDIX B


     PROGRAM AND DATABASE FILES



     PC-File consists of over a dozen program files. All of these
     files are loaded when you install the program. Two of the
     files--PCF.EXE and PCF.HLP--are absolutely essential for
     running PC-File. The other program files can be erased if
     necessary. Refer to the list below to see what you lose if you
     delete a file.

     PC-File creates a variety of files for each database that you
     define. Some of these, such as the header and data files, are
     an integral part of the database. Others, like report and
     letter files, are added as you define those features in the
     database.

     Your PC-File disks also contain several dozen sample files.
     The examples in the manuals refer to these sample files.

     All of the program files and each type of database file are
     explained below.



     PROGRAM FILES

     FCONVERT.COM

     This is a standalone program that converts PC-File III, PC-
     File/R, and PC-File+ databases into the new PC-File (dBASE III
     PLUS) format. You can delete this program after you have no
     further use for it.

     INSTALL.EXE

     The PC-File install program. It comes on Disk One, but is not
     copied onto your hard disk.

     MSHERC.COM

     This program must be run before you can produce graphs on a
     Hercules monitor. If you have a VGA, EGA, or CGA monitor, you
     can delete this file.

     PCF.DIC

     This file contains the 100,000 word dictionary used by PC-
     File's spell checker. You can delete this file if you will not
     be using the spell checker.

     PCF.EXE




     PC-File Version 7 Users Guide                            355



     The main program module of PC-File. Don't impinge the
     integrity of this file at all. You must start PC-File from the
     directory that contains this file or place PC-File on your DOS
     path.

     PCF.HLP

     This is another main file, without which PC-File will not run.
     This file contains not only the Help window text, but most of
     the other screen text as well. Place this file on the same
     drive and in the same subdirectory with PCF.EXE.

     PCF.PIF

     The Windows PIF (Program Information File) used to run PC-File
     in Graphics mode under Microsoft Windows. Run this file
     directly from the File Manager, or use New on the File menu of
     the Program Manager to define it as a Program Item.

     PCF.SUP

     The "supplemental" dictionary file that is created when you
     use the Add function in the spell checker to add words to your
     personal dictionary file.

     PCFCHAR.PIF

     The Windows PIF (Program Information File) used to run PC-File
     in Character mode under Microsoft Windows. Run this file
     directly from the File Manager, or use New on the File menu of
     the Program Manager to define it as a Program Item.

     PCFLOGO.IMG

     This file contains the PC-File "paper clip" logo that displays
     when you first start PC-File in Graphics mode. You can delete
     this file if you want.

     PCFILE.MAC

     The master macro file. You can create macros in this file to
     open your databases or perform other operations outside of
     individual databases. This file is not required to use PC-
     File.

     PCFILE.PRO

     The master configuration profile file. This file controls the
     operating environment of PC-File, including the mode of
     operation, screen colors, passwords, and telephone dialing
     codes. This file is not required to use PC-File.

     PCG2.EXE




     PC-File Version 7 Users Guide                            356


     This is the graphing display program. If you will be producing
     graphs, this program must be in the same subdirectory as your
     other PC-File programs. If you will not be producing graphs,
     you can delete this program.

     PCG2.ASP

     This file is created when you set colors or a different aspect
     ratio for graphing. This file is not required to use PC-File.

     PCLABEL.EXE

     An external/internal utility that allows you to print mailing
     labels in a one-up or multi-up format. You can delete this
     file if you have no intentions of using PC-Label.

     READ.ME

     A text file provided for additional information. You can view
     this file with any word processor that reads ASCII files, or
     print it on your printer by typing copy a:read.me prn at the
     DOS prompt. You can then delete the file.

     SHOWR.EXE

     A file viewer program used to display the READ.ME file at the
     end of installation process. You can run this program as a
     standalone DOS application to view ASCII files, if you wish.
     You can safely delete this file.


     DATABASE FILES

     databasename.CDS

     This is the telephone log that is kept whenever you tell PC-
     File to dial a telephone number. Delete this file whenever you
     want to start a new log.

     databasename.DBF

     This file contains the actual data you enter into your
     database.

     databasename.DBT

     Data entered in memo fields is contained in this file. All
     memo data within a database is stored in this file, even if
     you have two or more memo fields.

     databasename.DBH




     PC-File Version 7 Users Guide                            357


     The header file is created when you define a database. It
     contains information about the structure and contents of the
     database. This file is also created by PC-File when you open a
     dBASE-type database that was created by some other program,
     such as dBASE or FoxPRO.

     databasename.MAC

     This file is created if you define any macros for a database.
     It contains the macro definitions for use with the database.

     databasename.PRO

     This file is created if you define a separate configuration
     profile for a particular database.

     databasename.ND9

     This is the Subgroup index file for the database. You can have
     only one Subgroup index within a particular database.

     databasename.NDn (Where "n" is 1 through 8)

     Each index for a database is saved to a separate file under
     the same name as the database with an .NDn extention. For
     example, if your database has two indexes they would have .ND1
     and .ND2 extensions.

     filename.ANS

     This file stores your Print options dialog box settings for
     each report. When you reprint a report, the appropriate ANS
     file is used to set the printing defaults.

     filename.GR

     This file is created when you define a graph. It contains the
     commands that define the structure of the graph. A different
     file is created for each graph. If you change the file
     extension to .REP, you can edit this file with the Language
     editor.

     filename.LBL

     This file is created by PC-Label when you save the label
     setup. It contains the commands that define the structure and
     defaults of the label.

     filename.LTR

     This file is created when you define a mail-merge letter. It
     contains the commands that define the structure of the letter.
     A different file is created for each letter.

     filename.MAC




     PC-File Version 7 Users Guide                            358


     This file is created if you define any auxiliary macro files.

     filename.REP

     This file is created when you define a report. It contains the
     commands that define the structure of the report. A different
     file is created for each report.

     GRAPH.ME

     This file contains the data for the most-recently created
     graph. The data in the file changes every time you create a
     new graph, as the new data replaces the old data. It's an
     ASCII text file which you can edit with any text editor or
     word processing program.

     TMPnn.DBF, .DBH, .DBT, .PRO, and .MAC

     These files are created as a backup copy of your database when
     choosing to Update the current database when redefining using
     the Paint method, and when packing your database. All file
     types that existed for the original database are created:
     .DBH, .DBF, .DBT, .PRO, and .MAC. You can safely delete these
     files, after confirming that your redefine or packing
     operation was successful.

     TMPnn.OLD

     This file is created as a temporary work file when you define
     a report, letter, or graph without saving them. Ordinarily,
     you will not see these files, they will be deleted when PC-
     File is through with these operations. They might be left on
     your disk if your machine loses power or locks while the
     program is running. They can be safely deleted.

     TEMPnnnn.PCF

     This file is created when you choose to free up memory when
     dropping to DOS from within PC-File. The file allows you to
     return to where you were in PC-File. Don't delete the file
     while temporarily dropping to DOS from PC-File.




     PC-File Version 7 Users Guide                            359



     APPENDIX C

     ASCII TABLE


     Listed below is an ASCII table. The ASCII table includes the
     decimal and hexadecimal values for each ASCII character, as
     well as the ASCII character itself. To enter an ASCII
     character not found on your keyboard in a field, text window
     or edit window, hold down ALT while keying in the ASCII
     decimal value of the character using the numeric keypad. Then
     release the ALT key. For example, to enter u in a field, hold
     down ALT and key in the numbers 1 2 9, using the numeric
     keypad on the right side of the keyboard. Then release the ALT
     key. Note that you cannot use the number keys on the top row
     of the keyboard.




     PC-File Version 7 Users Guide                            360



     APPENDIX D

     ERROR/INFORMATION MESSAGES



     Listed below are various PC-File error and information
     messages, explanations and recommended actions. The messages
     are listed in alphabetical order.

     ?????

     Question marks printed in a report or letter indicate that PC-
     File doesn't recognize the field name(s) included in the
     report or letter. See Chapter 9,"Printing Reports and
     Letters," for more information.

     ?BAD ANSKEY

     The "lookup field" referenced in a relational lookup is not a
     valid field in the lookup database. Make sure that the field
     name is spelled correctly. The "lookup field" is the field in
     the lookup database containing the value to return, and is the
     fourth parameter in a relational lookup.

     ?BAD DB

     The "lookup database" referenced in a relational lookup is not
     a valid PC-File database. The "lookup database" is the
     database containing the data to retrieve, and is the second
     parameter in a relational lookup.

     ?BAD DB ID

     PC-File had problems opening the "lookup database" specified
     in a relational lookup. Make sure the database name is spelled
     properly and exists on the specified drive and subdirectory.

     ?BAD DBKEY

     The "shared field in lookup database" field referenced in a
     relational lookup is not a valid field in the lookup database.
     Make sure that the field name is spelled correctly. The
     "shared field in lookup database" is the field in the lookup
     database containing the lookup value, and is the third
     parameter in a relational lookup.

     ?BAD KEY1

     The "shared field in the current database" referenced in a
     relational lookup is not a valid field in the current
     database. Make sure the field name is spelled correctly. The
     "shared field in the current database" is the field in the
     current database containing the value to lookup, and is the
     first parameter in a relational lookup.




     PC-File Version 7 Users Guide                            361



     ?BAD USAGE

     The syntax of a relational lookup is incorrect. Relational
     lookups must be entered in the format (@shared field in
     current database, lookup database, shared field in lookup
     database, lookup field) or (*,lookup field).

     ?CANCELED

     The relational lookup operation was canceled by pressing ESC.

     ?NO RAM

     The computer does not have enough RAM memory to perform a
     relational lookup. See the error "Out of Memory."

     Beginning of file

     You are trying to display the previous record while viewing
     the first record in the database.

     Can't create (filename)

     PC-File has encountered an error when creating a new file.
     (The file name is included in the message.) This message may
     indicate that the data disk is full, that there are too many
     files on the disk, that there is a hardware or disk error,
     your network rights won't allow you to create files, or the
     FILES statement in your CONFIG.SYS file needs to be increased.

     Can't delete (filename or data)

     PC-File has encountered an error deleting a file or data in a
     file. This usually indicates a hardware error or a disk error.
     If the message refers to a file, it could mean that the file
     is marked by DOS as a read-only file.

     Can't get memo

     PC-File has encountered an error reading the memo file. This
     indicates that the memo file is missing, or there is a
     hardware error or a disk error. The memo file (.DBT) must have
     the same name as the data file (.DBF), and must be stored on
     the same drive and subdirectory as the data file.

     Can't open (filename)

     The file named in the message cannot be opened for processing.
     There could be several reasons for this:

       The file could not be found, because you gave the wrong name
       for it.

       The file could not be found, because you specified the wrong
       disk drive or subdirectory.




     PC-File Version 7 Users Guide                            362



       The file is in use by someone else on your system.

       You are having hardware or disk errors.

       The FILES= statement in your CONFIG.SYS file is too small.
       Increase it to 20 or more.

       The file may have been damaged in some way. See Chapter 12,
       "External/Internal Utilities," for information on repairing
       a database.

     Can't open .LOG file

     PC-File can't open the file that keeps track of changes made
     during a posting. If the destination database resides on a
     network drive, you might not have "rights" to open or create
     the files. There may be an insufficient number of file handles
     available to open a file--try increasing the number after
     FILES= in your CONFIG.SYS file, reboot and try running the
     posting again. Also, there may be insufficient disk space to
     open the .LOG file.

     Can't open .PST file

     The batch post definition file can't be opened. The file might
     be damaged. If the file resides on a network drive, you might
     not have "rights" to open the file. There may be an
     insufficient number of file handles available to open a file--
     try increasing the number after FILES= in your CONFIG.SYS
     file, reboot and try opening the .PST file again.

     Can't run DOS

     You've tried to run a DOS command from within PC-File and the
     DOS command cannot be processed. There could be several
     reasons for this:

     COMMAND.COM cannot be found on the disk, or is damaged.

     If you told PC-File to free up all memory, PC-File requires
     about 700K of disk space. The disk may be too full.

     Not enough RAM is available to execute the command; or the
     available memory has been corrupted.

     Can't write (filename)

     PC-File has encountered an error writing to a file. This
     usually indicates a full disk, hardware error, a disk error,
     or that the file is marked by DOS as a read-only file.

     Cancel changes to this record?




     PC-File Version 7 Users Guide                            363


     You selected the Cancel Changes option from the Edit menu, or
     pressed ESC after modifying a records. If you answer Yes to
     the question, PC-File ignores all changes made to the current
     record and restores the record to the original data before you
     began editing the record.

     Contains reference to unknown field

     When you select a report or letter to print, PC-File compares
     the field names referenced in the report or letter with those
     in the current database. If the report or letter contains a
     reference to a field name that doesn't exist in the current
     database, PC-File displays this message. You should modify the
     report or letter to include the correct field name references.
     If you don't, PC-File prints question marks where the field
     data is to be printed.

     Creation error

     PC-File has encountered an error trying to create a new file.
     This error usually indicates a full disk or a hardware or disk
     error. If PC-File displays this message when defining a
     database, make sure that the database definition is valid,
     i.e., make sure field names, types, and lengths are valid.

     Data length wrong

     The record length indicated in the .DBF header does not match
     the calculated record length (the sum of field lengths). The
     Repair command cannot correct this type of damage. Try using
     Pack on the Utilities menu to correct this.

     DBH doesn't match DBF

     Both the .DBH and .DBF files store the number of fields, and
     each field's length and type. There is a discrepancy between
     the number of fields or one or more fields' length or type.
     You can redefine the database to create a new database with
     matching .DBH and .DBF files. Alternatively, you can delete
     the .DBH file and let PC-File adopt to the database. If you
     change the database structure with a program other than PC-
     File, you must delete the .DBH file and let PC-File adopt it.

     Decimals must be less than number

     When defining or redefining a database, you can provide the
     number of decimal places for each numeric field. The maximum
     number of decimal places is the field length minus 2. For
     example, if you have a numeric field of length 8, the maximum
     number of decimal positions is 6.

     Drive not available or drive door is open




     PC-File Version 7 Users Guide                            364


     You are attempting to access an unavailable drive. If the
     drive you are trying to access is a floppy drive, make sure
     that the drive contains a formatted disk and that the drive
     door is closed.

     End of file

     You are attempting to display the next record while viewing
     the last record in the database. If you receive this message
     unexpectedly, it may mean that one or more of the indexes is
     damaged. You should rebuild all indexes using the Index option
     on the File menu.

     Error 0

     PC-File has encountered an error reading or writing to a file.
     This usually indicates a full disk or invalid path. It can
     also indicate a hardware error or a disk error.

     Error adopting dBASE file

     You selected a data file (.DBF) that doesn't have a
     corresponding header file (.DBH) and there is a problem
     creating the header file. PC-File reads dBASE III Plus
     compatible data files. If your data file is not dBase III Plus
     compatible, PC-File can't adopt it.

     Error deleting database record

     PC-File has encountered an error deleting a record. This
     usually indicates a damaged index, hardware error, or a disk
     error.

     Error during posting

     An error has occurred while PC-File was trying to post
     information to the destination file. This might indicate
     insufficient disk space, a disk error, or if the destination
     database resides on a network drive, you might not have
     "rights" to open and write to the files.

     Error making index (16386)

     This error will occur if you are attempting to define a
     Formula Index using a logical field without converting its
     data to a string using the TOSTR function. For example:

     UPPER(fieldname) **Incorrect**

     TOSTR(fieldname) **Correct**

     See "Defining a Formula Index" in Chapter 8 for details.

     Error reading (filename)




     PC-File Version 7 Users Guide                            365


     PC-File can't read the named file. The message can indicate
     that the file has been damaged in some way. You may be having
     difficulties with the disk itself. Either the data disk has a
     bad sector, or errors are occurring in the disk controller
     card.

     Error reading DBF field table

     The .DBF header can't be read, or the .DBF can't be opened.
     The file might be damaged. If the file resides on a network
     drive, you might not have "rights" to open the file. There may
     be an insufficient number of file handles available to open a
     file. Increase the number after FILES= in your CONFIG.SYS file
     and reboot.

     Error reading DBF header

     The .DBF header can't be read, or the .DBF can't be opened.
     The file might be damaged. If the file resides on a network
     drive, you might not have "rights" to open the file. There may
     be an insufficient number of file handles available to open a
     file--try increasing the number after FILES= in your
     CONFIG.SYS file, reboot and try repair again.

     Error reading memo (fieldname)

     This error will occur if PC-File encounters a memo field that
     it can't read:

     In "interactive" situations like viewing and editing in Record
     view and Table view, PC-File leaves the unavailable memo blank
     and displays an error message in this format:

     ----------------------------

     Error reading memo (fieldname)

     This database may be damaged

     [ OK ] [CANCEL]

     ----------------------------

     In "batch" situations like reports and export, PC-File prints
     or exports:

     Memo data not available

     in place of the damaged memo information. An error message in
     the following format will also display on the screen for 2
     seconds:

     ----------------------------

     Error reading memo (fieldname)




     PC-File Version 7 Users Guide                            366


     This database may be damaged

     -----------------------------

     You might be able to correct this problem using either the
     Repair or the Pack options on the Utilities menu. See
     "Repairing a Database" and "Packing a Database" for details.

     Error writing on (filename)

     PC-File can't write to the named file. Also, make sure that
     the disk isn't already full. If it is full, no more data can
     be written to it. You may be having difficulties with the disk
     itself. Either the data disk has a bad sector, or errors are
     occurring in the disk controller card. If writing to a floppy
     disk, make sure the disk doesn't have a write-protect tab on
     it.

     Exit memo without saving changes?

     When editing a memo field, PC-File displays this message when
     you choose Cancel. If you exit without saving, PC-File ignores
     all changes made to the memo field during the current editing
     session.

     Field display length exceeds 65 characters

     The maximum number of characters you can display for any field
     on one line is 65. However, the actual data length for
     character and memo fields can be much longer. Character fields
     can contain up to 254 characters. Memo fields can contain up
     to 5000 characters. When creating or modifying a View, you
     cannot use more than 65 characters for a field's display
     length.

     Field type (type) invalid for field length (length)

     You are defining or redefining a database and have provided an
     invalid field length. Character fields must be 1 to 254
     characters long. Numeric fields must be 1 to 19 characters
     long. Date fields must be 8 or 10 characters long. Logical
     fields must be 1 character long. Memo fields must be 5000
     characters long. Before you can proceed with the database
     definition or redefinition, you must either change the field
     type or field length.

     In the output database (databasename), The "Match to" field
     (fieldname) is not indexed. Posting may be slow. Continue?

     For PC-File to perform posting as quickly as possible, the
     field to match on in the database you are posting to should be
     indexed, so PC-File can perform a fast search on the index. If
     the match field is not indexed, PC-File performs a much slower
     sequential search.

     Incompatible memo format




     PC-File Version 7 Users Guide                            367



     The .DBF file has memo fields that are stored in dBASE IV
     format--PC-File can only use dBASE III or III+ format memos.

     Index expression too long. Ignoring excess.

     This error message can occur when you are defining a Simple
     Index (see "Creating an Index" for details) and you choose too
     many fields to index. All fields indexed up to the point you
     receive this message will be used if you continue. PC-File
     generates a dBase index expression which cannot be more than
     100 characters long. The total number of fields you can index
     will vary depending on the lengths of the field names, the
     types of fields indexed, and how many fields are indexed in
     descending or
     ascending sequence. Depending on the situation, you may be
     able to produce the index you want by defining a Formula Index
     (see "Creating an Index" for details).

     Index key exceeded 100 characters

     Due to limitations of the dBASE index structure, PC-File can't
     index on more than 100 characters of data. For example, PC-
     File can't sort five fields of 30 characters each, because the
     total length would be 150 characters. You need to specify
     fewer fields to index, or index on portions of fields. See
     Chapter 6, "Sorting and Indexing Data" for information on
     indexing portions of fields.

     Invalid field name (name)

     When defining a database, you included invalid characters in a
     field name, or you selected a field and typed a field name
     that doesn't exist. Field names can contain only letters,
     numbers and the underscore ( _ ) character. No punctuation,
     spaces, or other characters are allowed. Field names must
     start with a letter.

     Invalid key expression

     There is an error in the expression you entered for a formula
     index. It could be a misspelled field name or function name,
     or a missing parenthesis.

     Invalid PST file (1st record bad)

     The first line in the .PST file is not in a valid format. The
     .PST might be damaged or has been incorrectly edited. This
     line in the .PST file indicates the "post from" (source)
     database, and should be in this format:

     PCF6,D:\path\databasename




     PC-File Version 7 Users Guide                            368


     where "D" is the drive and "path" is the subdirectory where
     the source database resides, and "databasename" is the name of
     the source database with no extension. For example, posting
     from a database named SALES on drive C in the \PCFILE\DATA
     subdirectory the first line of the .PST file would read:

     PCF6,C:\PCFILE\DATA\SALES

     To correct this problem: Edit the first line of the .PST file
     to the format above, restore a backup copy of the .PST file,
     or redefine the posting from scratch.

     Invalid PST file (2nd rcd bad)

     The second line in the .PST file is not in a valid format. The
     .PST might be damaged or has been incorrectly edited. This
     line in the .PST file indicates the "post to" (destination)
     database, and should be in this format:

     TO:D:\path\databasename.DBH

     where "D" is the drive and "path" is the subdirectory where
     the destination database resides, and "databasename" is the
     name of the destination database. For example, posting to a
     database named INVENTORY on drive C in the \PCFILE\DATA
     subdirectory, the second line of the .PST file would read:

     TO:C:\PCFILE\DATA\INVENTORY.DBH

     To correct this problem: Edit the second line of the .PST file
     to the format above, restore a backup copy of the .PST file,
     or redefine the posting from scratch.

     Invalid PST file (MATCH command expected)

     The third line in the .PST file is not in a valid format. The
     .PST might be damaged or has been incorrectly edited. This
     line in the .PST file indicates which fields to match on, and
     should be in this format:

     MATCH sourcefield to destinationfield

     where "sourcefield" is the match field from the source
     database and "destinationfield" is the match field from
     destination database. For example, matching on a field named
     PART_NO in both databases the third line of the .PST file
     would read:

     MATCH PART_NO to PART_NO

     To correct this problem: Edit the third line of the .PST file
     to the format above, restore a backup copy of the .PST file,
     or redefine the posting from scratch.

     Line length >>80. Truncate the line?




     PC-File Version 7 Users Guide                            369


     You are printing a list of duplicate records and the length of
     the line of data to be printed is greater than 80 characters.
     If you are printing to a wide carriage printer or are using a
     condensed font, you may not want to truncate the line.
     However, if your printer can only print 80 characters per
     line, you do want to truncate the data so that your printer
     doesn't wrap the data from one line to the next.

     LOG file missing: (filename)

     This message appears when using the UnPost command on the
     Batch Post dialog box. Either the .LOG file for the database
     was deleted, or you may be in the wrong database when trying
     to UnPost--you must be in the database that was posted to, not
     the database that was posted from.

     Match To Field isn't indexed

     This message indicates that the field to match on in the
     destination database is not indexed. This does not prevent the
     posting from being performed, but posting will be slower.
     Index the "match to" field for better performance.

     Memo N/A

     You can't use a memo field in a relational lookup.

     Name invalid

     When saving files, you must specify a valid DOS file name.
     Refer to your DOS manual for the valid file name characters.
     Also make sure that you don't have a default drive, path and
     file in the database.PRO file.

     Need a Match Destination field

     You need to choose a field from the "post to" (destination)
     database to match with before you can proceed with your Batch
     post definition.

     Need a Match field from Lookup file

     You need to choose a "match with" field from the Lookup
     database (the database you are retrieving data from) before
     you can proceed.

     Need a Match Source field

     You need to choose a field from the current (source) database
     to match with before you can proceed with your Batch post
     definition.

     Need a POST action




     PC-File Version 7 Users Guide                            370


     You need to define a post action before you can proceed with
     your Batch post definition. See "Defining Post Actions" for
     details.

     Need a Post Destination field

     You need to choose a field from the "post to" (destination)
     database to post to before you can proceed with your Post
     action definition.

     Need a Post Source field

     You need to choose a field from the current (source) database
     to post from before you can proceed with your Post action
     definition.

     Need a Source field

     You need to choose a "match with" field from the current
     (source) database before you can proceed.

     Need an Answer field from Lookup file

     You need to choose the field to retrieve data from in the
     Lookup database before you can proceed.

     No phone number

     To use the telephone dialer option, you must have a field name
     containing the word "phone." You can use the Redefine option
     on the File menu to change the name of the field(s) containing
     your phone number(s) to include the word "phone". See Chapter
     13, "Tools," for more information on the telephone dialer.

     No repairs were performed

     PC-File found no errors that it could correct, or the user has
     answered No to a repair message.

     No snapshot defined

     To use the snapshot label option, you must have a snapshot
     label defined in the current profile. See Chapter 13, "Tools,"
     for more information on snapshot labels.

     Not a compatible DBF file

     The file you are trying to repair is probably a dBASE II file.
     PC-File only uses dBASE III and dBASE III+ .DBF files.

     Not a valid extension




     PC-File Version 7 Users Guide                            371


     You have added an invalid file extension in the file selection
     dialog box. For example, when opening a database, if you
     provide an extension other than DBF, PC-File displays this
     message. In most cases, PC-File adds the extension
     automatically, so you don't have to.

     Not a valid path or file name

     The path or file name you have entered in the file selection
     dialog box doesn't exist or is incorrectly spelled. Also, make
     sure you select the appropriate drive.

     Not found

     PC-File can't find a record matching the search criteria.

     Numeric field exceeds 19

     The maximum field length for numeric fields is 19. You need to
     reduce the size of the numeric field to 19 characters or less.

     Out of Memory

     PC-File has run out of RAM memory (not disk space). To
     determine how much RAM memory is available on your machine,
     refer to the "Getting Started" section.

     PC-File may display an "Out of Memory" message when performing
     an operation which worked earlier in the current session.
     While you are in PC-File, memory can become fragmented, such
     that a large enough block of memory can't be found to perform
     an operation. There are two ways to work around this problem.
     First, quit all the way out of PC-File, then restart PC-File
     and immediately retry the operation that failed. This frees
     all memory, eliminating fragmentation. Second, make more
     memory available by either installing more conventional memory
     in your machine (if you don't have 640K) or by disabling
     memory resident programs. Extended and expanded memory will
     not help avoid this error.

     Another, less common cause of this message is an invalid
     calculation, complex search criteria or .IF statement in a
     report or letter. Examples include angle brackets around field
     names, missing or extra parentheses, and missing or illegal
     operators such as $, << or =. See Chapter 5,"Finding and
     Modifying Data," and Chapter 15, "Calculations," for more
     information.

     Output (post to) file doesn't exist

     PC-File can't find the destination database indicated in the
     .PST file. Either the database has been moved, deleted or
     renamed; or the .PST has been incorrectly edited.




     PC-File Version 7 Users Guide                            372


     To correct this problem: Redefine the posting from scratch, or
     edit the first line in the .PST file to the format described
     under "Invalid PST file (1st record bad)."

     Overwrite data. Are you sure?

     When importing data, you can append the imported records to
     the database without affecting the existing data or you can
     overwrite the existing data. Overwriting deletes the original
     data and replaces it with the imported data. Confirm or cancel
     your decision to overwrite all records in the current database
     to continue.

     Overwrite existing (filename)

     If you are saving a file to an existing file name, PC-File
     asks if you want to overwrite the existing file. If you answer
     Yes, PC-File deletes the existing file and saves the current
     file with the same name.

     Repaired (number)

     This message is displayed at the end of the repair process to
     indicate how many records have been repaired.

     Should be memos, but there aren't

     The .DBF header has a "flag" that indicates if a database has
     memo fields. This message is displayed if the flag indicates
     memos, but there are no fields that show memo type. PC-File
     gives you the option to attempt to repair this problem, if you
     answer Yes to repair, PC-File turns off the flag. The .DBT
     file, if any, is not affected.

     Shouldn't be memos, but there are

     The .DBF header has a "flag" that indicates if a database has
     a memo file (.DBT). This message is displayed if the flag
     indicates no memos, but there are fields that show memo type.
     PC-File gives you the option to attempt to repair this
     problem, if you answer Yes to repair, PC-File resets the
     "flag" to indicate the presence of memos and creates a new
     empty memo file (.DBT), if it is missing.

     The "Match From" Field doesn't exist.

     PC-File can't find the match field for the source database
     indicated in the .PST file. The .PST file might be damaged or
     incorrectly edited, or the field's name might have been
     changed. Redefining the Batch post definition should correct
     this problem.

     The disk is full.




     PC-File Version 7 Users Guide                            373


     There is insufficient space on the destination drive PC-File
     is attempting to write the redefined database on. Either
     eliminate unnecessary files, or try redefining to a higher
     capacity disk, if possible.

     The UNDO file is dated: date Are you sure you want to undo the
     posting?

     This is to inform you the date of the last posting to this
     database. Only records posted to at that time will be
     restored.

     There were (number) transactions for which no matching records
     were found.

     "Number" is the number of records posted from that have no
     matches in the database you are posting to.

     This Post file is incompatible with the current database.

     The .PST file was probably defined for another database, or
     field names might have been changed. Redefining the posting
     should correct the problem.

     Too many fields

     PC-File allows up to 128 fields per database. You are trying
     to define a database with more than 128 fields. If your
     database has more than 128 fields, you should consider
     reorganizing your database structure, or linking multiple
     databases together using relational lookups.

     Unsuccessful ADD operation

     This message usually indicates a damaged index. Rebuild all
     indexes for the database using the Index Maintenance option on
     the File menu. The message could also indicate a damaged data
     file, full disk, or disk error.

     User Canceled

     The user pressed ESC or chose Cancel while running a Batch
     post.

     WARNING: correcting field decimal places

     This message displays when PC-File finds a discrepancy between
     the decimal places for numeric fields indicated in the .DBH
     file and .DBF header. PC-File assumes the .DBF header is
     correct and updates the .DBH's values for decimal places to
     the .DBF header's values.

     WARNING: correcting field length




     PC-File Version 7 Users Guide                            374


     This message displays when PC-File finds a discrepancy between
     the field lengths indicated in the .DBH file and .DBF header.
     PC-File assumes the .DBF header is correct and updates the
     .DBH's field lengths to the .DBF header's values.

     WARNING: correcting field type

     This message displays when PC-File finds a discrepancy between
     the field types indicated in the .DBH file and .DBF header.
     PC-File assumes the .DBF header is correct and the .DBH's
     field types are updated to the .DBF header's values.

     WARNING: correcting number of records

     This message displays when PC-File finds a discrepancy between
     the number of records indicated in the .DBF header and the
     calculated number of records (DBF Length divided by Record
     Length). PC-File assumes the calculated value is correct and
     updates the number of records indicated in the .DBF header to
     the calculated value.

     WARNING: Database may be damaged

     PC-File has detected an error with the data file. You should
     first rebuild all indexes using the Index option on the File
     menu. If the problem persists, repair the database using the
     Repair option on the Utilities menu.

     WARNING: No DBF header termination; continuing

     The end of the .DBF header does not have an end marker. The
     .DBF file is probably from a third-party program. This should
     not affect PC-File's ability to repair and use the file. PC-
     File does not add an end marker, and continues the repair
     process.

     WARNING: PCF.EXE failed integrity check

     PC-File detects a discrepancy while performing an integrity
     check. To correct the problem, you should ensure that your
     data disk(s) are not infected with any viruses, and that there
     are no errors with your data disk(s), then reinstall PC-File.

     WARNING: This index may be damaged

     The index file does not match the data file. You should
     rebuild the index. Make sure you haven't used the same index
     file name for more than one index field. See Chapter 6,
     "Sorting and Indexing Data," for more information on
     rebuilding indexes and naming index files.

     What to print in place of ???????

     PC-File wants to know what field or system data you want to
     print at the current data location in your Free form report.




     PC-File Version 7 Users Guide                            375


     Writing corrected DBF header

     This message displays when a discrepancy is found between the
     number of records indicated in the .DBF header and the
     calculated number of records (DBF Length divided by Record
     Length). The calculated value is assumed to be correct and the
     number of records indicated in the .DBF header is updated to
     that value.

     Writing corrected DBH file

     This message displays when a discrepancy is found between
     field types, field lengths, and numeric field decimal places
     stored in the .DBH file and .DBF header. The .DBF header is
     assumed to be correct and its field definitions are used to
     update the .DBH file.

     Wrong password

     A password is required before you can perform the operation
     you attempted. You provided the wrong password.

     You can't have more than 9 indexes

     PC-File allows up to 9 indexes per database. You already have
     9 indexes. You must delete at least one index before you can
     build another one.

     You must define at least 1 field

     You are telling PC-File you have finished defining or
     redefining a database, but have not defined any fields. Before
     you can proceed with the database definition or redefinition,
     you must define at least one field.

     Your new database has been created. The indexes will be built
     the first time you use the new database.

     This message appears after choosing Build New at the end of
     the Redefine process.

     Your old database had been renamed to: TMPnnnn Your new
     (redefined) database keeps the name that it was redefined
     from. The indexes for your new database will now be created.

     This message appears after choosing Update Current at end of
     the Redefine process. TMPnnnn (where "nnnn" is some number) is
     the name PC-File assigns to the backup copy of the database
     before redefining it.


     ABOUT THE AUTHOR




     PC-File Version 7 Users Guide                            376


     In 1982, Jim Button started a revolution. He wrote a software
     program that was so easy to use, even beginners could master
     it. Yet it was powerful enough to manage information for the
     largest corporations. Its price was less than half its
     competition. Jim was so certain that people would love his
     product, he gave it away for free-requesting payment only if
     they were completely satisfied. He called it PC-File.

     Today, 750,000 copies later, Jim's revolutionary software is
     managing data nationwide. From IBM to the local PTA. Kodak to
     the cub scouts. Nike to your neighborhood sporting goods
     store. And it's not alone. PC-File shares the spotlight with a
     family of powerful products. All are backed by a team
     committed to quality software, personal service and features
     that fit the need.
