Repo Man #1 @9986
Monday, July 8, 1991  12:28 pm


/****************************************************************************
 *
 * DOS 5.0's COMMAND.COM is different from the command.com in previous
 * releases of DOS in that (when it is starting up, at least), it has a
 * smaller stack space defined.  Because WWIV needs to use more stack space
 * than is available, when intercepting DOS calls, this causes some information
 * to be trashed.  This "mod" below "fixes" that by having WWIV use an internal
 * stack when it does things which require more than a minimum amount of stack
 * space.
 *
 * NOTE: Normally, I would have done the stack change in assembly.
 *       Unfortunately, not everyone has an assembler, so I was forced to do it
 *       in C.  It apparently works, but it seems a bit hokey to me.  Don't
 *       try thinking too hard about this code, as that's not the only
 *       weird thing in it.
 *
 * IMPORTANT NOTE: I had someone try installing this in their modified v4.11,
 *                 and they couldn't get it to work under DOS 3.3.  So, only
 *                 install this if you NEED to (DOS 5.0).  I am not assuring
 *                 you that it will work.  So, if it doesn't work, feel free
 *                 to tell me and give me any info about your problems, but I
 *                 am NOT assuring you that it will work.
 *
 ****************************************************************************/

/****************************************************************************
 *
 * In return.c, delete function newintr1().  Block read in the following
 * in its place:
 *
 ****************************************************************************/

#define INT_SAVE_21 0x69

union REGS ni_r;
struct SREGS ni_s;
unsigned ni_n;
char ni_ch,ni_ch1,ni_ss[10],ni_ch2;
unsigned char *ni_st;

static unsigned short ni_stack[100];


#pragma warn -par

void far interrupt newintr1(unsigned bp, unsigned di, unsigned si,
                           unsigned ds, unsigned es, unsigned dx,
                           unsigned cx, unsigned bx, unsigned ax,
                           unsigned ip, unsigned cs, unsigned flags)
{

  unsigned short ni_SS, ni_SP;
#define NEW_STK() { _BX=FP_OFF(&ni_stack[98]); _SS=_DS; _SP=_BX; }
#define OLD_STK() { _AX=ni_SS; _BX=ni_SP; _SS=_AX; _SP=_BX; }



  ni_r.x.ax=ax;
  ni_r.x.bx=bx;
  ni_r.x.cx=cx;
  ni_r.x.dx=dx;
  ni_r.x.si=si;
  ni_r.x.di=di;
  ni_r.x.flags=flags;
  ni_s.ds=ds;
  ni_s.es=es;

  ni_SS=_SS;
  ni_SP=_SP;

  ni_ch=ni_r.h.ah;
  ni_ch1=0;

  switch(ni_ch) {
    case 0x01:
      NEW_STK();
      ni_ch=getkeyext();
      outchr(ni_ch);
      if (hangup)
        ni_ch=3;
      ni_r.h.al=ni_ch;
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x02:
      NEW_STK();
      outchr(ni_r.h.dl);
      ni_ch1=1;
      checka2();
      OLD_STK();
      break;
    case 0x06:
      NEW_STK();
      if (ni_r.h.dl!=0xff) {
        outchr(ni_r.h.dl);
        ni_ch1=1;
      } else {
        if (empty()) {
          ni_r.x.flags |= 64;
        } else {
          ni_r.x.flags &= (0xffff ^ 64);
          ni_r.h.al=getkeyext();
        }
      }
      OLD_STK();
      break;
    case 0x07:
      NEW_STK();
      ni_ch1=1;
      ni_r.h.al=getkeyext();
      OLD_STK();
      break;
    case 0x08:
      NEW_STK();
      ni_ch1=1;
      ni_r.h.al=getkeyext();
      OLD_STK();
      break;
    case 0x09:
      NEW_STK();
      outdosstr((char *) MK_FP(ni_s.ds, ni_r.x.dx));
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0a:
      NEW_STK();
      ni_st=(char *) MK_FP(ni_s.ds,ni_r.x.dx);
      ni_n=(unsigned int)(ni_st[0]);
      if (in_extern==2)
        getkeyext();
      in_extern=0;
      input_extern=1;
      input1(&(ni_st[2]),ni_n-3,1,0);
      input_extern=0;
      in_extern=1;
      ni_st[1]=strlen(&(ni_st[2]));
      strcat(&(ni_st[2]),"\r");
      if ((hangup)) {
        strcpy(&(ni_st[2]),"EXIT\r");
        ni_st[1]=4;
        outstr("Exiting...");
      }
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0b:
      NEW_STK();
      if (empty())
        ni_r.h.al=0x00;
      else
        ni_r.h.al=0xff;
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0c:
      ni_r.h.ah=ni_r.h.al;
      int86x(0x21,&ni_r,&ni_r,&ni_s);
      ni_ch1=1;
      break;
    case 0x3f:
      if (ni_r.x.bx==0x0000) {
        NEW_STK();
        ni_st=(char *)MK_FP(ni_s.ds,ni_r.x.dx);
        inputl(ni_st,ni_r.x.cx);
        strcat(ni_st,"\r\n");
        ni_r.x.ax=strlen(ni_st);
        if (hangup)
          ni_r.x.ax=0;
        ni_r.x.flags &=(0xffff ^ 1);
        ni_ch1=1;
        OLD_STK();
      } else
        int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
      break;
    case 0x40:
      if ((ni_r.x.bx==0x0001) || (ni_r.x.bx==0x0002)) {
        NEW_STK();
        ni_st=(char *)MK_FP(ni_s.ds,ni_r.x.dx);
        for (ni_n=0; ni_n<ni_r.x.cx; ni_n++) {
          outchr(ni_st[ni_n]);
          checka2();
        }
        ni_r.x.ax=ni_r.x.cx;
        ni_r.x.flags &=(0xffff ^ 1);
        ni_ch1=1;
        OLD_STK();
      } else
        int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
      break;
    default:
      int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
      break;
  }

  if (ni_ch1) {
    checkhangup();
    if (hangup) {
      if (hanguptime1<0L) {
        hanguptime1=timer1();
        outstr("Aborting...\r\n");
        ni_r.x.ax=0x4c00;
        int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
      } else {
        if (labs(timer1()-hanguptime1)>36L) {
          hanguptime1=timer1();
          outstr("Aborting...\r\n");
          ni_r.x.ax=0x4c00;
          int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
        }
      }
    }
  }

  ax=ni_r.x.ax;
  bx=ni_r.x.bx;
  cx=ni_r.x.cx;
  dx=ni_r.x.dx;
  si=ni_r.x.si;
  di=ni_r.x.di;
  flags=ni_r.x.flags;
  ds=ni_s.ds;
  es=ni_s.es;
}

#pragma warn +par


/****************************************************************************
 *
 * In extrn.c, delete function newintr1(), and block read this in its place
 * (and yes, it is subtly different):
 *
 ****************************************************************************/



#define INT_SAVE_21 0x69

union REGS ni_r;
struct SREGS ni_s;
unsigned ni_n;
char ni_ch,ni_ch1,ni_ss[10],ni_ch2;
unsigned char *ni_st;

static unsigned short ni_stack[100];


#pragma warn -par

void far interrupt newintr1(unsigned bp, unsigned di, unsigned si,
                           unsigned ds, unsigned es, unsigned dx,
                           unsigned cx, unsigned bx, unsigned ax,
                           unsigned ip, unsigned cs, unsigned flags)
{

  unsigned short ni_SS, ni_SP;
#define NEW_STK() { _BX=FP_OFF(&ni_stack[98]); _SS=_DS; _SP=_BX; }
#define OLD_STK() { _AX=ni_SS; _BX=ni_SP; _SS=_AX; _SP=_BX; }



  ni_r.x.ax=ax;
  ni_r.x.bx=bx;
  ni_r.x.cx=cx;
  ni_r.x.dx=dx;
  ni_r.x.si=si;
  ni_r.x.di=di;
  ni_r.x.flags=flags;
  ni_s.ds=ds;
  ni_s.es=es;

  ni_SS=_SS;
  ni_SP=_SP;

  ni_ch=ni_r.h.ah;
  ni_ch1=0;

  switch(ni_ch) {
    case 0x01:
      NEW_STK();
      ni_ch=getkeyext();
      outchr(ni_ch);
      if (hangup)
        ni_ch=3;
      ni_r.h.al=ni_ch;
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x02:
      NEW_STK();
      outchr(ni_r.h.dl);
      ni_ch1=1;
      checka2();
      OLD_STK();
      break;
    case 0x06:
      NEW_STK();
      if (ni_r.h.dl!=0xff) {
        outchr(ni_r.h.dl);
        ni_ch1=1;
      } else {
        if (empty()) {
          ni_r.x.flags |= 64;
        } else {
          ni_r.x.flags &= (0xffff ^ 64);
          ni_r.h.al=getkeyext();
        }
      }
      OLD_STK();
      break;
    case 0x07:
      NEW_STK();
      ni_ch1=1;
      ni_r.h.al=getkeyext();
      OLD_STK();
      break;
    case 0x08:
      NEW_STK();
      ni_ch1=1;
      ni_r.h.al=getkeyext();
      OLD_STK();
      break;
    case 0x09:
      NEW_STK();
      outdosstr((char *) MK_FP(ni_s.ds, ni_r.x.dx));
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0a:
      NEW_STK();
      ni_st=(char *) MK_FP(ni_s.ds,ni_r.x.dx);
      ni_n=(unsigned int)(ni_st[0]);
      if (in_extern==2)
        getkeyext();
      in_extern=0;
      input_extern=1;
      input1(&(ni_st[2]),ni_n-3,1,0);
      input_extern=0;
      in_extern=1;
      ni_st[1]=strlen(&(ni_st[2]));
      strcat(&(ni_st[2]),"\r");
      if ((hangup)) {
        strcpy(&(ni_st[2]),"EXIT\r");
        ni_st[1]=4;
        outs("Exiting...");
      }
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0b:
      NEW_STK();
      if (empty())
        ni_r.h.al=0x00;
      else
        ni_r.h.al=0xff;
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0c:
      ni_r.h.ah=ni_r.h.al;
      int86x(0x21,&ni_r,&ni_r,&ni_s);
      ni_ch1=1;
      break;
    case 0x3f:
      if (ni_r.x.bx==0x0000) {
        NEW_STK();
        ni_st=(char *)MK_FP(ni_s.ds,ni_r.x.dx);
        inputl(ni_st,ni_r.x.cx);
        strcat(ni_st,"\r\n");
        ni_r.x.ax=strlen(ni_st);
        if (hangup)
          ni_r.x.ax=0;
        ni_r.x.flags &=(0xffff ^ 1);
        ni_ch1=1;
        OLD_STK();
      } else
        int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
      break;
    case 0x40:
      if ((ni_r.x.bx==0x0001) || (ni_r.x.bx==0x0002)) {
        NEW_STK();
        ni_st=(char *)MK_FP(ni_s.ds,ni_r.x.dx);
        for (ni_n=0; ni_n<ni_r.x.cx; ni_n++) {
          outchr(ni_st[ni_n]);
          checka2();
        }
        ni_r.x.ax=ni_r.x.cx;
        ni_r.x.flags &=(0xffff ^ 1);
        ni_ch1=1;
        OLD_STK();
      } else
        int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
      break;
    default:
      int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
      break;
  }

  if (ni_ch1) {
    if (arcling) {
      if ((nextext) && (!abortext)) {
        checka1();
        if (abortext) {
          ni_r.x.ax=0x4c00;
          int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
        }
      }
    }
    checkhangup();
    if (hangup) {
      if (hanguptime1<0L) {
        hanguptime1=timer1();
        outs("Aborting...\r\n");
        ni_r.x.ax=0x4c00;
        int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
      } else {
        if (labs(timer1()-hanguptime1)>36L) {
          hanguptime1=timer1();
          outs("Aborting...\r\n");
          ni_r.x.ax=0x4c00;
          int86x(INT_SAVE_21,&ni_r,&ni_r,&ni_s);
        }
      }
    }
  }

  ax=ni_r.x.ax;
  bx=ni_r.x.bx;
  cx=ni_r.x.cx;
  dx=ni_r.x.dx;
  si=ni_r.x.si;
  di=ni_r.x.di;
  flags=ni_r.x.flags;
  ds=ni_s.ds;
  es=ni_s.es;
}


#pragma warn +par


