[70/83] - Z1-1024S.MOD  -  Allows from 32 to 65535 subs on 4.21a!!
[User] : Zaknafein #1 @2917 <Fleet Admiral>
[Date] : Fri Aug 14 16:15:07 1992
[From] : Menzoberranzan [209-226-5232]
[Area] : Fresno, CA


 Z-MOD #1
 Allows 32 to 65534 subs in increments of 32
 For WWIV version  v4.21A
 Mod version       v1.0
 Skill Level        [4]
 Author & address  1@1(SL) 1@1029(SN) 1@2917(WN) 1@2902(IN) 1@12908(WL)
 Files involved    VARDEC.H
 Total Recompile?  Yes
 Requirements      A fair amount of experience modding.
             
This mod is the first to my knowledge to allow over 254 message subs in
WWIV.  It is a big mod, so you shouldn't attempt it unless you have had
some previous modding experience.  But when you are complete, you will
be able to have up to 65534 message subs in one directory.  This will
probably be the most you will EVER need while you are still considering
BBSing and sysoping as a hobby.  You may also reduce the number of subs
to virtually any number you wish; as long as it is a multiple of 32; these
are valid: 32, 64, 128, 256, 512, 1024, etc up to 65534 subs (the max
allowance of the new sysopsub var minus one).  This makes it ideal to just
change the variable when you need more subs, and since the mod comes with a
convert program to convert your QSCAN.LST over to any new sizes, you can
increase this and decrease this as you need to.

This mod will put all of the qscan information into another file besides
the user.lst file.  This will allow your userrec to stay stock and will
prevent any need for those complicated conversion tactics.  The file that
I have selected is QSCAN.LST, you may choose another if you so please; just
change all occurances of qscan.lst to whatever you want to use.

To my knowledge, this mod will work with any WOMR programs you have, because
it will always write the first 64 subs' qscans to the userrec as well as
the seperate qscan file.  This means that WOMR's will work on the first 32
or 64 subs (depending on which one you get).
             
I cannot guarantee that this will work with all versions of WWIV, but I
can assure you that it works on v4.21A as that is what I am running it
on.  If this does not work for you, I am available for suggestions and
help but not for flame mail saying "You killed my board".  I am not
responsible for anything bad that happens to you, your board, your ego,
or your computer.  So don't complain to me, just unzip your backup that
you should have made before installing this mod.

Which brings us to another point: BACK UP YOUR SOURCE... No matter how
hot a programmer you are, you are still prone to mess up like the rest
of us mortal sysops.  These are the various ways to backup the source:

copy *.c a: <enter> copy *.h a: <enter> and so on.

pkzip source.zip *.c *.h <enter> (for the first backup) and
pkzip -f source.zip <enter> (for subsequent backups)

arj a source.arj *.c *.h <enter> (for the first backup) and
arj f source.arj <enter> (for subsequent backups)

There are other ways to do it with other programs, but these are the most
popular methods and should suffice.

When editing files, pay close attention to the file name on each step.
They will change without the usual "Close and save file, now open xxx.xxx"
line.  Just watch the file names and save, close and open on your own.

Legend:

/*+*/  Add from this line to the next line marked with /*+*/, if the /*+*/
       is just on one a line with code on it (at the start of it), then just
       add the one line.
/*-*/  Delete from this line to the next line marked with /*-*/, if the
       /*-*/ is at the start of a line with code on it, then delete that one
       line only.

Any line that is not marked is a line that should stay the way it is.  These
lines are also good for reference and make it easier to find parts of the
source code.

*> BEGINNING OF MAIN MOD <*

Step 1.  In VARDEC.H

Almost at the top...

#ifdef EXTENDED
             
/*-*/#define MAX_SUBS 64
/*+*/#define MAX_SUBS 1024      /* Make this a multiple of 32 up to 32768 */

#define MAX_DIRS 64
#else

/*-*/
#if MAX_SUBS>32
#define QSCN(i) (*((i>31)?(&thisuser.qscnptr2[i-32]):(&thisuser.qscnptr[i])))
#else
#define QSCN(i) (thisuser.qscnptr[i])
#endif
/*-*/

/*+*/#define QSCN(i) (thisq.qscnptr[i])

/****************************************************************************/


Step 2.  In VARDEC.H

#if MAX_SUBS>32
        unsigned long   qscn2;                  /* additional qscan ptr */
/*-*/   unsigned long   qscnptr2[MAX_SUBS-32];  /* additional quickscan ptrs */
/*+*/   unsigned long   qscnptr2[32];  /* additional quickscan ptrs */

#endif

Step 3.  In VARDEC.H

/*+*/   /* Add somewhere in VARDEC.H (preferrably after userrec) */
#define EXT_NR_ARR (MAX_SUBS/32)

typedef struct {
        unsigned long   qscn[EXT_NR_ARR];       /* qscan configured subs */
                        qscnptr[MAX_SUBS];      /* qscan pointers */
        unsigned int    sysopsub;               /* sysop sub board number */
} qscanrec;
/*+*/

Step 4.  In VARDEC.H

Down a ways...

/* DATA FOR CONVERSION OF MAIN MENU KEYS TO SUB-BOARD NUMBERS */
typedef struct {
             
/*-*/   char            keys[3];
/*+*/   char            keys[6];

        int             subnum;
} usersubrec;

Step 5.  In VARS.H

postrec *msgs;
screentype screensave;

/*+*/qscanrec thisq;
/*+*/int qscanfile;

Now go down to the extern section...

extern postrec *msgs;
extern screentype screensave;

/*+*/extern qscanrec thisq;
/*+*/extern int qscanfile;

Step 6.  In BBS.C       Function "sublist()"
             
Replace the entire void...

/*+*/
void sublist(void)
{
  int i,i1,abort;
  char s[160],s1[80],s2[20],ch;

  abort=0;
  s[0]=0;
  nl();
  pla("Subs available: ",&abort);
  pla("----- - ------ ======================== ----- - ------ 
========================",&abort);
  i=0;
  while ((i<max_subs) && (usub[i].subnum!=-1) && (!abort)) {
    if ((1L << (usub[i].subnum%32)) & thisq.qscn[i/32])
      ch='-';
    else
      ch=' ';
    if (net_sysnum) {
      if (subboards[usub[i].subnum].type) {
        if (subboards[usub[i].subnum].anony & anony_val_net)
          sprintf(s2,"[NET]",net_name);
        else
          sprintf(s2,"<NET>",net_name);
      } else
        strcpy(s2,"");
    }

    sprintf(s1,"%-5.5s %c %-6.6s %-24.24s",
            usub[i].keys,ch,s2,subboards[usub[i].subnum].name);
    strcat(s,s1);
    if ((i%2)==1) {
      pla(s,&abort);
      s[0]=0;
    } else if (((i+1)>=max_subs) || (usub[i+1].subnum==-1))
      pla(s1,&abort);
    else
      strcat(s," ");
    i++;
  }
  if (i==0)
    pla("None.",&abort);
  nl();
}
/*+*/
             
Step 7.  In BBS.C       Function "mainmenu()"

Replace the entire "if" statement...

/*+*/
  if (strcmp(s,"QSCAN")==0) {
    nl();
    prt(5,"Clear Q-Scan pointers? ");
    if (yn()) {
      for (i=0; i<MAX_SUBS; i++)
        thisq.qscnptr[i]=status.qscanptr-1L;
      nl();
      pl("Q-Scan pointers cleared.");
      nl();
    }
  }
/*+*/

Step 8.  In BBS.C

Change all occurances of "read_user(1,&thisuser);" to
"read_user(1,&thisuser,&thisq);"

Do the same with all occurances of "write_user" as well.


Step 9.  In BBSUTL.C    Function "mmkey(..)"

char *mmkey(int dl)
{
  static unsigned char cmd1[10],cmd2[81],ch;
  int i,i1,i2,p;

Add directly after...

/*+*/
  i=0;
  cmd2[0]=0;
  if (dl==0) {
    do {
      ch=upcase(getkey());
      if (ch==13) {
        nl();
        if ((cmd2[0]=='/') && (cmd2[1]=='/')) {
          strcpy(cmd2,(char *)cmd2+2);
          return(cmd2);
        } else
          return(cmd2);
      } else if ((ch==8) && (i>0)) {
        backspace();
        --i;
      } else if ((ch>=32) && (ch<=126) && (i<50)) {
        outchr(ch);
        cmd2[i++]=ch;
        cmd2[i]=0;
      }
      if ((i>1) && (cmd2[0]=='/') && (cmd2[1]!='/')) {
        nl();
        return(cmd2);
      }
      if ((i==1) && (strchr(dc,ch)==NULL)) {
        nl();
        return(cmd2);
      }
      if ((i>1) && (atoi(cmd2)>((num_subs-(num_subs % 10))/10))) {
        nl();
        return(cmd2);
      }
    } while (!hangup);
  } else
/*+*/
             
  do {
    do {
      ch=getkey();

Step 10.  In BBSUTL.C   Function "lcs()"

Replace entire function...

/*+*/
int lcs(void)
{
  slrec ss;

  ss=syscfg.sl[actsl];
  if (cs())
    return(1);
  if (ss.ability & ability_limited_cosysop) {
    if (thisq.sysopsub==65535)
      return(1);
    if (thisq.sysopsub==usub[cursub].subnum)
      return(1);
    else
      return(0);
  } else
    return(0);
}
/*+*/


Step 11.  In BBSUTL1.C  Function "finduser1(...)"

    if (strstr(smallist[i].name,s)!=NULL) {
      i1=smallist[i].number;

/*-*/      read_user(i1,&u);
/*+*/      read_user(i1,&u,NULL);

      sprintf(s1,"Do you mean %s (Y/N/Q) ? ",nam(&u,i1));

Step 12.  In BBSUTL1.C  Function "ssm(...)"

  if (un==65535)
    return;
  if (sy==0) {

/*-*/    read_user(un,&u);
/*+*/    read_user(un,&u,NULL);
             
    if (!(u.inact & inact_deleted)) {
      sprintf(s1,"%sSMW.DAT",syscfg.datadir);

Further down...

      close(f);
      u.sysstatus |= sysstatus_smw;

/*-*/      write_user(un,&u);
/*+*/      write_user(un,&u,NULL);

    }
    close_user();
  } else if (net_sysnum && next_system(sy)) {

Step 13.  In CONIO.C    Function "val_cur_user(...)"

In the variable declarations...

/*-*/  char 
sl[4],dsl[4],exempt[4],sysopsub[4],ar[17],dar[17],restrict[17],rst[17],
/*-*/  char 
sl[4],dsl[4],exempt[6],sysopsub[4],ar[17],dar[17],restrict[17],rst[17],
       t[50];
  int cp,i,done,rc,wx,wy;

  makewindow(wx,wy,50,7);
  itoa((int)thisuser.sl,sl,10);
  itoa((int)thisuser.dsl,dsl,10);
  itoa((int)thisuser.exempt,exempt,10);

/*-*/  itoa((int)thisuser.sysopsub,sysopsub,10);
/*+*/  itoa((int)thisq.sysopsub,sysopsub,10);

  strcpy(rst,restrict_string);
  for (i=0; i<=15; i++) {

And further down in the same function, replace the entire "case"...

/*+*/
      case 6:
        movecsr(wx+12,wy+4);
        editline(sysopsub,5,NUM_ONLY,&rc,"");
        thisq.sysopsub=(unsigned int) atoi(sysopsub);
        sprintf(sysopsub,"%u",thisq.sysopsub);
        sprintf(tl,"%-5s",sysopsub); outs(tl);
        break;
/*+*/

Step 14.  In DEFAULTS.C Function "print_cur_stat()"

      if (thisuser.forwardusr==65535) {
        pl("Closed");
      } else {

/*-*/        read_user(thisuser.forwardusr,&ur);
/*+*/        read_user(thisuser.forwardusr,&ur,NULL);

        if (ur.inact & inact_deleted) {
          thisuser.forwardusr=0;
          pl("Normal");

Step 15.  In DEFAULTS.C Function "l_config_qscan()"

  pl("Boards to q-scan marked with '*'");
  nl();
  for (i=0; (i<max_subs) && (usub[i].subnum!=-1) && (!abort); i++) {
    sprintf(s,"%c %s. %s",

/*-*/
#if MAX_SUBS>32
      (usub[i].subnum>=32)?
         (((1L << (usub[i].subnum-32)) & thisuser.qscn2)?'*':' '):
         (((1L << (usub[i].subnum)) & thisuser.qscn)?'*':' '),
#else
      ((1L << (usub[i].subnum)) & thisuser.qscn)?'*':' ',
#endif
/*-*/

/*+*/      ((1L << (usub[i].subnum % 32)) & thisq.qscn[i/32])?'*':' ',

      usub[i].keys,
      subboards[usub[i].subnum].name);

Step 16.  In DEFAULTS.C Function "config_qscan()"

    outstr("Config: ");
    s=mmkey(0);
    if (s[0])
      for (i=0; (i<max_subs) && (usub[i].subnum!=-1); i++)
        if (strcmp(usub[i].keys,s)==0) {

/*-*/
#if MAX_SUBS>32
   if (usub[i].subnum>=32)
            thisuser.qscn2 ^=((1L) << (usub[i].subnum-32));
          else
            thisuser.qscn ^=((1L) << (usub[i].subnum));
#else
          thisuser.qscn ^=((1L) << (usub[i].subnum));
#endif
/*-*/

/*+*/          thisq.qscn[i/32] ^=((1L) << (usub[i].subnum % 32));

        }
    if (strcmp(s,"Q")==0)

Step 17.  In DIREDIT.C

Change all occurances of "read_user(x,xxx);" and "write_user(x,xxx);" to
"read_user(x,xxx,NULL);" and "write_user(x,xxx,NULL);" respectively.  The
x's are various variables, leave them how they are.

Step 18.  In LILO.C

Change all occurances of "read_user(x,&thisuser);" to "read_user(x,&thisuser,
&thisq);".  Do the same will occurances of write_user.  The x is a variable
of some sort, do not change it.

Step 19.  In MISCCMD.C

Change all occurances of "read_user(x,xxx);" and "write_user(x,xxx);" to
"read_user(x,xxx,NULL);" and "write_user(x,xxx,NULL);" respectively.  The
x's are various variables, leave them how they are.

Step 20.  In MSGBASE.C

Change all occurances of "read_user(x,xxx);" and "write_user(x,xxx);" to
"read_user(x,xxx,NULL);" and "write_user(x,xxx,NULL);" respectively.  The
x's are various variables, leave them how they are.

Step 21.  In MSGBASE1.C

Change all occurances of "read_user(x,xxx);" and "write_user(x,xxx);" to
"read_user(x,xxx,NULL);" and "write_user(x,xxx,NULL);" respectively.  The
x's are various variables, leave them how they are.

Step 22.  In MSGBASE1.C Function "nscan(...)"

  prt(3,"<< Q-Scan All >>");
  nl();
  for (i=ss; (usub[i].subnum!=-1) && (i<max_subs) && (nextsub) && (!hangup); 
i++) {

/*-*/
#if MAX_SUBS>32
    if (((usub[i].subnum<32) && (thisuser.qscn & (1L<<(usub[i].subnum)))) ||
        ((usub[i].subnum>=32) && (thisuser.qscn2 & (1L<<(usub[i].subnum-32)))))
#else
    if (thisuser.qscn & (1L<<(usub[i].subnum)))
#endif
/*-*/

/*+*/    if (thisq.qscn[i/32] & (1L << (usub[i].subnum % 32)))

      qscan(i,&nextsub);
    abort=next=0;

Step 23.  In MULTMAIL.C

Change all occurances of "read_user(x,xxx);" and "write_user(x,xxx);" to
"read_user(x,xxx,NULL);" and "write_user(x,xxx,NULL);" respectively.  The
x's are various variables, leave them how they are.

Step 24.  In NETSUP.C   Function "cleanup_net()"
[Hit Any Key]             
        curlsub=-1;
        if (wfc) {
          wfc=0;

/*-*/          read_user(1,&thisuser);
/*+*/          read_user(1,&thisuser,&thisq);

          fwaiting=thisuser.waiting;
          wfc=1;
        }
      }
      if (check_bbsdata())

Step 25.  In NEWUSER.C  Function "newuser()"

    if (!ok)
      hangup=1;
  }

  memset(&thisuser, 0, sizeof(userrec));

/*+*/  memset(&thisq, 0, sizeof(qscanrec));

  strcpy(thisuser.firston,date());
  strcpy(thisuser.laston,"Never.");

A little further down...

  thisuser.sl=syscfg.newusersl;
  thisuser.dsl=syscfg.newuserdsl;

/*-*/  thisuser.sysopsub=255;
/*+*/  thisq.sysopsub=65535;

  thisuser.ontoday=1;

  thisuser.restrict=syscfg.newuser_restrict;

/*-*/
  thisuser.qscn=0xFFFFFFFF;
#if MAX_SUBS>32
  thisuser.qscn2=0xFFFFFFFF;
#endif
/*-*/

/*+*/
  for (i=0; i<EXT_NR_ARR; i++)
  thisq.qscn[i]=0xffffffff;
/*+*/

  thisuser.nscn1=0xFFFFFFFF;
  thisuser.nscn2=0xFFFFFFFF;
  thisuser.sysstatus=sysstatus_pause_on_page | sysstatus_nscan_file_system;

Down towards the end of the function...

    nl();
    pl("Please wait...");
    nl();

/*-*/    read_user(0,&u);
/*+*/    read_user(0,&u,NULL);

    l1=number_userrecs();
    if (l1==(long) status.users) {
      usernum=status.users+1;
    } else {
      usernum=1;
      do {

/*-*/        read_user(usernum,&u);
/*+*/        read_user(usernum,&u,NULL);

        if ((u.inact & inact_deleted)==0)
          ++usernum;
      } while (((u.inact & inact_deleted)==0) && ((long)usernum<=l1));
    }

/*-*/    write_user(usernum,&thisuser);
/*+*/    write_user(usernum,&thisuser,&thisq);

    close_user();
    isr(usernum,thisuser.name);

Step 26.  In RETURN.C   Variable declarations

int oldx,oldy,flow_control,save_dos;
char ansistr[81];
int change_color;
userrec thisuser;

/*+*/qscanrec thisq;

unsigned int baud_rate;

Step 27.  In RETURN.C   Function "init_r()"

  READ(incom);
  READ(outcom);
  using_modem=incom || outcom;
  READ(thisuser);

/*+*/  READ(thisq);

  READ(flow_control);
  READ(async_irq);
  READ(baud_rate);

Step 28.  In SHRINK.C   Function "restore_data(...)"

    if (global_handle) {
      global_handle=0;
      set_global_handle(1);
    }

/*-*/    read_user(usernum,&thisuser);
/*+*/    read_user(usernum,&thisuser,&thisq);

    useron=1;
    changedsl();

Step 29.  In SHRINK.C   Function "save_state(...)"

  if (f<0)
    return;

  WRITE(incom);
  WRITE(outcom);
  WRITE(thisuser);

/*+*/  WRITE(thisq);

  WRITE(flow_control);
  WRITE(async_irq);


Step 29A.  In SHRINK.C  Function "shrink_out(...)"

  if (ok_shrink) {
    if (state>0) {

/*-*/      write_user(usernum,&thisuser);
/*+*/      write_user(usernum,&thisuser,&thisq);
             
      if (state>1)
        thisuser.sysstatus &= ~sysstatus_pause_on_page;

Step 30.  In SUBEDIT.C

Change all occurances of "read_user(x,xxx);" and "write_user(x,xxx);" to
"read_user(x,xxx,NULL);" and "write_user(x,xxx,NULL);" respectively.  The
x's are various variables, leave them how they are.

Step 31.  In SUBEDIT.C  Function "insert_sub(...)"

Replace entire function...

/*+*/
void insert_sub(int n)
{
  subboardrec r;
  int i,i1,i2,nu;
  userrec u;
  qscanrec q;
  long l1,l2,l3;

  for (i=num_subs-1; i>=n; i--) {
    subboards[i+1]=subboards[i];
    sub_dates[i+1]=sub_dates[i];
  }
  strcpy(r.name,"** NEW SUB **");
  strcpy(r.filename,"NONAME");
  r.key=0;
  r.readsl=10;
  r.postsl=20;
  r.anony=0;
  r.age=0;
  r.maxmsgs=50;
  r.ar=0;
  r.type=0;
  r.storage_type=2;
  subboards[n]=r;
  ++num_subs;
  read_user(1,&u,&q);
  l1=0xffffffff >> 32-(n%32);
  l2=0xffffffff << (n%32)+1;
  l3=1L << (n%32);
  nu=number_userrecs();
  for (i=1; i<=nu; i++) {
    read_user(i,&u,&q);
    if (q.sysopsub!=65535)
      if (q.sysopsub>=n)
        ++q.sysopsub;
    for (i1=num_subs-1; i1>n; i1--)
      q.qscnptr[i1]=q.qscnptr[i1-1];
    q.qscnptr[n]=0L;
    i1=(n/32);
    for (i2=(EXT_NR_ARR-1); i2>i1; i2--)
      q.qscn[i2]=(q.qscn[i2] << 1) | (q.qscn[i2-1] >> 31);
    q.qscn[i1]=(q.qscn[i1] & l1) | ((q.qscn[i1] << 1) & l2) | l3;
    write_user(i,&u,&q);
  }
  modify_sub(n);
}
/*+*/

Step 31A.  In SUBEDIT.C Function "delete_sub(...)"

Replace entire function...

/*+*/
void delete_sub(int n)
{
  int i,i1,i2,nu;
  userrec u;
  qscanrec q;
  long l1,l2;

  sub_type_change(&(subboards[n]), 0);
  for (i=n; i<num_subs; i++) {
    subboards[i]=subboards[i+1];
    sub_dates[i]=sub_dates[i+1];
  }
  --num_subs;
  read_user(1,&u,&q);
  nu=number_userrecs();
  l1=0xffffffff >> ((n+(32-(n % 32)))-n);
  l2=0xffffffff << (n-(n-(n % 32)));
  for (i=1; i<=nu; i++) {
    read_user(i,&u,&q);
    if (q.sysopsub==n)
      q.sysopsub=65535;
    else
      if ((q.sysopsub>n) && (q.sysopsub!=65535))
        --q.sysopsub;
    for (i1=n; i1<num_subs; i1++)
      q.qscnptr[i1]=q.qscnptr[i1+1];
    i1=(n/32);
    q.qscn[i1]=(q.qscn[i1] & l1) | ((q.qscn[i1] >> 1) & l2) | (q.qscn[i1+1] << 31);
    for (i2=i1+1; i2<EXT_NR_ARR; i2++) {
      q.qscn[i2]=(q.qscn[i2] >> 1);
      if ((i2+1)<EXT_NR_ARR)
        q.qscn[i2]=(q.qscn[i2] | (q.qscn[i2+1] << 31));
    }
    write_user(i,&u,&q);
  }
}
/*+*/

Step 32.  In SUBEDIT.C  Function "boardedit()"

      case 'M':
        nl();
        prt(2,"Sub number? ");

/*-*/        input(s,2);
/*+*/        input(s,5);

        i=atoi(s);
        if ((s[0]!=0) && (i>=0) && (i<num_subs))
          modify_sub(i);
        break;
      case 'I':
        if (num_subs<max_subs) {
          nl();
          prt(2,"Insert before which sub? ");

/*-*/          input(s,2);
/*+*/          input(s,5);

          i=atoi(s);
          if ((s[0]!=0) && (i>=0) && (i<=num_subs))
            insert_sub(i);
        }
        break;
      case 'D':
        nl();
        prt(2,"Delete which sub? ");


/*-*/        input(s,2);
/*+*/        input(s,5);

        i=atoi(s);
        if ((s[0]!=0) && (i>=0) && (i<num_subs)) {
          nl();
          sprintf(s1,"Delete %s? ",subboards[i].name);

Step 33.  In SYSOPF.C

Change all occurances of "read_user(x,xxx);" and "write_user(x,xxx);" except
for the one in function "chuser()" to "read_user(x,xxx,NULL);" and
"write_user(x,xxx,NULL);" respectively.  The x's are various variables,
leave them how they are.

Step 34.  In SYSOPF.C   Function "chuser()"

  i=finduser1(s);
  if (i>0) {

/*-*/    write_user(usernum,&thisuser);
/*+*/    write_user(usernum,&thisuser,&thisq);

/*-*/    read_user(i,&thisuser);
/*+*/    read_user(i,&thisuser,&thisq);

    usernum=i;
    close_user();

Step 35.  In UEDIT.C    Function "print_data(...)"
             
/*-*/void print_data(int un, userrec *u, int lng, int cls)
/*+*/void print_data(int un, userrec *u, qscanrec *q, int lng, int cls)

{
  char s[81],s1[81],s2[81],s3[81],s4[81];
  int i;

A bit further down...

  nl();
  npr("SL  : %d  DSL=%d\r\n", u->sl, u->dsl);

/*-*/
  if ((u->sysopsub)!=255)
    npr("SySu: %d\r\n",u->sysopsub);
/*-*/

/*+*/
  if ((q->sysopsub)!=65535)
    npr("SySu: %u\r\n",q->sysopsub);
/*+*/

  if (u->exempt)
    npr("Exem: %d\r\n",u->exempt);
  strcpy(s3,restrict_string);

Step 36.  In UEDIT.C    Function "uedit(...)"

  char s[81],s1[81],s2[81],ch,ch1;
  int i,i1,i2,i3,un,done,nu,done1,full,temp_full,tempu,cls=1;
  userrec u;

/*+*/  unsigned int ui;
/*+*/  qscanrec q;

  if (incom)
    full=0;

A little ways down...

  un=usern;
  done=0;

/*-*/  read_user(un,&u);
/*+*/  read_user(un,&u,&q);

  nu=number_userrecs();
  do {

/*-*/    read_user(un,&u);
/*+*/    read_user(un,&u,&q);

    done1=0;
    temp_full=0;
    do {

/*-*/      print_data(un,&u, ((full) || (temp_full)), cls);
/*+*/      print_data(un,&u,&q, ((full) || (temp_full)), cls);

      nl();

Alot further down, same function...

Replace entire case...

/*+*/
        case 'Y':
          nl();
          prt(2,"New sysop sub? ");
          input(s,5);
          ui=atoi(s);
          if ((ui>=0) && (ui<=65534) && (s[0])) {
            q.sysopsub=ui;
            write_user(un,&u,&q);
          }
          break;
/*+*/

In function "uedit(...)" go back and search for any "write_user(un,&u);"
and change them all to "write_user(un,&u,&q);"

Step 37.  In UEDIT.C

Now go through the entire file and change any "read_user(...)" or
"write_user(...)" so that they have a NULL at the end, like you have done
previously in this mod.  Make sure that you don't put a NULL on one of the
statements that already has a "&q" on it!

Step 38.  In UTILITY.C  Function "frequent_init()"

  okskey=0;
  lines_listed=0;

/*-*/  read_user(1,&thisuser);
/*+*/  read_user(1,&thisuser,&thisq);
             
  if (thisuser.inact & inact_deleted)
    fwaiting=0;
  else
    fwaiting=thisuser.waiting;

Step 39.  In UTILITY.C  Function "close_user()"

Replace entire function...

/*+*/
void close_user(void)
{
  if (userfile!=-1) {
    close(userfile);
    userfile=-1;
  }
  if (qscanfile!=-1) {
    close(qscanfile);
    qscanfile=-1;
  }
}
/*+*/

Step 40.  In UTILITY.C  Function "open_user()"

Replace entire function...

/*+*/
void open_user(void)
{
  char s[81];

  if (userfile==-1) {
    sprintf(s,"%sUSER.LST",syscfg.datadir);
    userfile=open(s,O_RDWR | O_BINARY);
    if (userfile<0) {
      userfile=-1;
    }
  }
  if (qscanfile==-1) {
    sprintf(s,"%sQSCAN.LST",syscfg.datadir);
    qscanfile=open(s, O_RDWR | O_BINARY);
    if (qscanfile<0) {
      qscanfile=-1;
    }
  }
}
/*+*/

Step 41.  In UTILITY.C  Function "read_user(...)"

Replace entire function...

/*+*/
void read_user(unsigned int un, userrec *u, qscanrec *q)
{
  long pos;
  char s[80];
  int i,ok;

  open_user();
  if ((userfile<0) || (un>number_userrecs())) {
    u->inact=inact_deleted;
    fix_user_rec(u);
    return;
  }

  if (((useron) && (un==usernum)) || ((wfc) && (un==1))) {
    *u=thisuser;
    if (q)
      *q=thisq;
      fix_user_rec(u);
    return;
  }
  ok=1;
  pos=((long) syscfg.userreclen) * ((long) un);
  lseek(userfile,pos,SEEK_SET);
  i=read(userfile, (void *)u, syscfg.userreclen);
  if (i==-1) {
    open_user();
    if ((userfile<0) || (un>number_userrecs())) {
      u->inact=inact_deleted;
      fix_user_rec(u);
      return;
    }
    pos=((long) syscfg.userreclen) * ((long) un);
    lseek(userfile,pos,SEEK_SET);
    i=read(userfile, (void *)u, syscfg.userreclen);
    if (i==-1) {
      pl("COULDN'T READ USER.");
      ok=0;
    }
  }
  if (q==NULL) {
    fix_user_rec(u);
  return;
  }
  if (qscanfile<0) {
    sprintf(s,"%sQSCAN.LST",syscfg.datadir);
    qscanfile=open(s, O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
    if (qscanfile<0) {
      npr("CANNOT CREATE %s.\r\n",s);
      end_bbs(noklevel);
    }
  }
  if (un>(filelength(qscanfile)/sizeof(qscanrec))) {
    chsize(qscanfile,un*sizeof(qscanrec));
    memset((void *)q,0,sizeof(qscanrec));
    for (i=0; i<EXT_NR_ARR; i++)
      q->qscn[i]=0xffffffff;
    q->sysopsub=65535;
    fix_user_rec(u);
    return;
  }
  pos=(long)(sizeof(qscanrec)*un);
  lseek(qscanfile,pos,SEEK_SET);
  i=read(qscanfile,(void *)q,sizeof(qscanrec));
  if (i==-1) {
    pl("COULDN'T READ QSCANS.");
    ok=0;
  }
  if (ok) {
    q->qscn[0]=u->qscn;
    for (i=0; i<33; i++)
      q->qscnptr[i]=u->qscnptr[i];
#if MAX_SUBS>32
    q->qscn[1]=u->qscn2;
    for (i=0; i<33; i++)
      q->qscnptr[i+33]=u->qscnptr2[i];
#endif
  }
  fix_user_rec(u);
}
/*+*/

Step 42.  In UTILITY.C  Function "write_user(...)"

Replace entire function...

/*+*/
void write_user(unsigned int un, userrec *u, qscanrec *q)
{
  long pos;
  char s[80];
  unsigned char oldsl;
  int i;

  if (q) {
    u->qscn=q->qscn[0];
    for (i=0; i<33; i++)
      u->qscnptr[i]=q->qscnptr[i];
#if MAX_SUBS>32
    u->qscn2=q->qscn[1];
    for (i=0; i<33; i++)
      u->qscnptr2[i]=q->qscnptr[i+33];
#endif
  }
  if (userfile==-1) {
    sprintf(s,"%sUSER.LST",syscfg.datadir);
    userfile=open(s,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  }
  if (((useron) && (un==usernum)) || ((wfc) && (un==1))) {
    thisuser=*u;
    if (q)
      thisq=*q;
  }
  pos=((long) syscfg.userreclen) * ((long) un);
  lseek(userfile,pos,SEEK_SET);
  i=write(userfile, (void *)u, syscfg.userreclen);
  if (i==-1) {
    sprintf(s,"%sUSER.LST",syscfg.datadir);
    userfile=open(s,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    if (userfile<0) {
      npr("CANNOT CREATE %s.\r\n",s);
      end_bbs(noklevel);
    }
    pos=((long) syscfg.userreclen) * ((long) un);
    lseek(userfile,pos,SEEK_SET);
    i=write(userfile, (void *)u, syscfg.userreclen);
    if (i==-1) {
      pl("COULDN'T WRITE USER.");
    }
    close_user();
  }
  if (q==NULL)
    return;
  open_user();
  if (qscanfile==-1) {
    sprintf(s,"%sQSCAN.LST",syscfg.datadir);
    qscanfile=open(s, O_RDWR | O_BINARY | O_CREAT, S_IWRITE | S_IREAD);
  }
  pos=(long)(un*sizeof(qscanrec));
  if (pos>filelength(qscanfile))
    chsize(qscanfile,pos);
  lseek(qscanfile,pos,SEEK_SET);
  i=write(qscanfile,(void *)q,sizeof(qscanrec));
  if (i==-1) {
    pl("COULDN'T WRITE QSCANS.");
    close_user();
  }
}
/*+*/

Step 43.  In UTILITY.C

Once again, search through the entire file and find any "write_user" or
"read_user" with only 2 parameters.  Add NULL as the last parameter if the
statements you find have only 2 parameters.

Step 44.  In VOTEEDIT.C

Once again, search through the entire file and find any "write_user" or
"read_user" with only 2 parameters.  Add NULL as the last parameter if the
statements you find have only 2 parameters.

Step 45.  In XFER.C

Once again, search through the entire file and find any "write_user" or
"read_user" with only 2 parameters.  Add NULL as the last parameter if the
statements you find have only 2 parameters.

Step 46.  In XINIT.C    Function "init()"

#ifdef EMS_XMS
  if (_OvrInitEms(0,0,16)!=0)
    _OvrInitExt(0L,0);
#endif

  userfile=-1;

/*+*/  qscanfile=-1;

  configfile=-1;
  statusfile=-1;
  dlf=-1;

Step 47.  In XINIT.C    Function "init()"

    numed=numed;
    close(i);
  }
  batch=mallocx(MAX_BATCH * sizeof(batchrec), "batch list");

/*-*/  read_user(1,&thisuser);
/*+*/  read_user(1,&thisuser,&thisq);

  if (thisuser.inact & inact_deleted)
    fwaiting=0;
  else
    fwaiting=thisuser.waiting;

Step 48.  Now, you are complete with the source part of things.  You must
not type MAKE FCNS at the dos prompt to redo your header file.

Step 49.  Now do your favorite method of compilation, whether it is F9
or make.  This should work, although either I messing up or you messing
up is still a factor, so don't be surprised if it doesn't work on the first
try.  The reason why I rated it moderately difficult is to strain out the
amateurs who would not know how to fix a problem should one arise.

*> END OF MAIN MOD <*

Have fun with your essentially unlimited subs!
             
If you need help, I am at all of these addresses:

1@1 (Stormlink)
1@2917 (WWIVnet)
1@12908 (WWIVlink)
1@2902 (ICEnet)
1@1029 (SKYnet)

Or call my board at (209)226-5232 "Menzoberranzan" for an example hands on
experience with the mod!  And many others that I don't publish; you never
know, you may just get inspired!  :)

Z1@1



   
