Revised User Auto-Purge Routine from The Black Dragon.
The Black Dragon #1 @2380    [Black Dragon Enterprises]
Sat Mar 04 11:30:58 1989

Due to problems that other sysops have had with my user auto-purge routine,
here is an exact copy of what my routine looks like in it's current state.
I have not suffered any side effects that other sysops have reported to me.

It will purge any user, excluding the currently logged on one, who hasn't
called in as many days as his SL indicates.  The modification is RSM() is
necessary so that the logged on user won't see messages like "User X read
your mail on ..." when they are directed to the user being purged.

Notice the variable "d" in the autopurge routine is the number of days since
the last logon.  The if statement that follows can be changed so any
comparison on "d" can be made (e.g. d>30 if one has a 30 day policy).

The autopurge routine is set up as a separate file.  On my BBS, it is one
of several routines defined in a file I call LOCAL.C (for local modifications).
>----------------------( User Purge Modification )---------------------<
#include <ctype.h>
#include <stdlib.h>
#include <stat.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <alloc.h>
#include <dir.h>
#include <math.h>
#include <time.h>
#include "vardec.h"
#include "fcns.h"

#define exempt_purge 0x80 /* or whatever isn't already used /*

extern int auto_purge, userfile, usernum;
extern double timeon;
extern configrec syscfg;

void auto_delete()
{
  int count, i;
  float d;
  char s[81];
  userrec u;

  auto_purge=1;
  count=0;
  for (i=2;i<=syscfg.maxusers;i++) {
    read_user(i,&u);
    if (!(u.inact & inact_deleted) && !(u.exempt & exempt_purge)) {
      d=(time(&s)-u.daten)/24.0/3600.0;
      if ((d>u.sl)&& (usernum!=i)) {
        sprintf(s,"=> Auto-deleted user #%d - %s", i, u.name);
        deluser(i);
        sysoplog(s);
        ++count;
      }
    }
  }
  sprintf(s,"Auto-Deleted %d user(s)",count);
  sysoplog(s);
  prt(6,s);
  nl();
  auto_purge=0;
}
>----------------------------( In BBSUTL.C )---------------------------<
extern int auto_purge;

void rsm(int un, userrec *u)
{
  shortmsgrec sm;
  int i,i1,f,any;
  char s1[81];

  any=0;
  if ((u->sysstatus) & sysstatus_smw) {
    sprintf(s1,"%sSMW.DAT",syscfg.datadir);
    f=open(s1,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    i=(int) (filelength(f) / sizeof(shortmsgrec));
    for (i1=0; i1<i; i1++) {
      lseek(f,((long) (i1)) * sizeof(shortmsgrec),SEEK_SET);
      read(f,(void *)&sm,sizeof(shortmsgrec));
      if ((sm.touser==un) && (sm.tosys==0)) {
***=>   if (!auto_purge) pl(sm.message);                   /* CHANGED */
        sm.touser=0;
        sm.tosys=0;
        sm.message[0]=0;
        lseek(f,((long) (i1)) * sizeof(shortmsgrec),SEEK_SET);
        write(f,(void *)&sm,sizeof(shortmsgrec));
        any=1;
      }
    }
    close(f);
    u->sysstatus ^= sysstatus_smw;
    smwcheck=1;
  }
  if (any)
    nl();
}
>------------------------( End of Modification )-----------------------<
        The Black Dragon.