Ŀ
 Mod Name: Credit.mod (v1.0)    Mod Author(s): Arc Angel    WWIVNet 1@4067  
 Difficulty: Fairly advanced, quite a few changes to the code               
 WWIV Version: WWIV v4.22       Date: 10/23/93                              
 Files Affected: batch,bbs,bbsutl,conio,lilo,newuser,sr,uedit,utility,*.h   
 Description: A credit system for WWIV with dl earnings & free files        


Extended:   This modification gives WWIV an advanced credit system complete
            with : 
            * earned credit based on downloads of files the user had
              uploaded (ek)
            * earned dl credit tracked even on extracted downloads
            * change exemptions in addition to ratio exemptions (so charges
              to the account during the exemption period do not adversely
              affect the user later) (exemption 4)
              exempted k is stored to track this (xk), thus specific 
              amounts of exempted credit can be added to an account
              (credit balance is calculated as:
               uk/req_ratio + ek*dl_earned_multiplier - dk + xk)
            * exemption expiration dates (exemptions are valid through 
              the end of the date of expiration)
            * (the time exemption is implemented) (exemption 1)
            * exemptions and the exemption expiration date is shown
              on the (y)our info screen in the main menu and xfer menu
            * the F1 editor and //uedit are modified to allow editing
              the transfer credits ("c" edits credits in //uedit)
            * the xfer command //FREE can be used to mark files as
              free downloads. Free downloads still earn credit for
              the uploader as normal. Files extracted from free downloads
              are also free.
            * the batchfile lists are changed to include size and time

Disclaimer: I am not responsible for any problems or complications due to your
            use of this modification. I urge you to make a full backup of your
            BBS and keep it for at least a few weeks after beginning to use
            your new code.

Key         +  Add this Line



diff -H -b -p ./batch.c Credit/batch.c
*** ./batch.c   Thu Dec 03 19:56:36 1992
--- credit/batch.c      Fri Oct 22 20:34:40 1993
*************** void listbatch(void)
*** 29,34 ****
--- 29,36 ----
  {
    char s[81];
    int abort,i;
+   /* Credit MOD */ char s1[81];
+   /* Credit MOD */ int i1;
  
    abort=0;
    nl();
*************** void listbatch(void)
*** 35,40 ****
--- 37,43 ----
    outstr(get_string(864));
    npr("%d  ",numbatch);
    if (numbatchdl) {
+     /* Credit MOD */ npr("Size - %ldk  ",((batchlen+1023)/1024));
      outstr(get_string(865));
      pl(ctim(batchtime));
    } else
*************** void listbatch(void)
*** 41,46 ****
--- 44,50 ----
      nl();
    nl();
    for (i=0; (i<numbatch) && (!abort) && (!hangup); i++) {
+     /* Credit MOD
      if (batch[i].sending)
        sprintf(s,"%d. (D) %s   %s  %s",i+1, batch[i].filename,
        ctim(batch[i].time),
*************** void listbatch(void)
*** 48,53 ****
--- 52,73 ----
      else
        sprintf(s,"%d. (U) %s             %s",i+1,batch[i].filename,
        directories[batch[i].dir].name);
+     Credit MOD */
+     /* Credit MOD */ if (batch[i].sending) {
+     /* Credit MOD */   sprintf(s,"  . (D) %.13s      k  %.8s  %.30s",batch[i].filename,ctim(batch[i].time),directories[batch[i].dir].name);
+     /* Credit MOD */   itoa(i+1,s1,10);
+     /* Credit MOD */   for (i1=0; i1<strlen(s1); i1++)
+     /* Credit MOD */     s[2-strlen(s1)+i1]=s1[i1];
+     /* Credit MOD */   ltoa((((batch[i].len)+1023)/1024),s1,10);
+     /* Credit MOD */   for (i1=0; i1<strlen(s1); i1++)
+     /* Credit MOD */     s[26-strlen(s1)+i1]=s1[i1];
+     /* Credit MOD */ }
+     /* Credit MOD */ else {
+     /* Credit MOD */   sprintf(s,"  . (U) %.13s                   %.30s",batch[i].filename,directories[batch[i].dir].name);
+     /* Credit MOD */   itoa(i+1,s1,10);
+     /* Credit MOD */   for (i1=0; i1<strlen(s1); i1++)
+     /* Credit MOD */     s[2-strlen(s1)+i1]=s1[i1];
+     /* Credit MOD */ }
  
      pla(s,&abort);
    }
*************** void delbatch(int i)
*** 60,65 ****
--- 80,87 ----
    if (i<numbatch) {
      if (batch[i].sending) {
        batchtime -= batch[i].time;
+       /* Credit MOD */ batchcharge -= batch[i].charge;
+       /* Credit MOD */ batchlen -= batch[i].len;
        --numbatchdl;
      }
      --numbatch;
*************** void downloaded(char *fn, long cps)
*** 74,79 ****
--- 96,103 ----
    int i,i1;
    uploadsrec u;
    char s[81];
+   /* Credit MOD */ char s1[81], s2[81];
+   /* Credit MOD */ userrec uu;
  
    for (i1=0; i1<numbatch; i1++) {
      if ((strcmp(fn,batch[i1].filename)==0) && (batch[i1].sending)) {
*************** void downloaded(char *fn, long cps)
*** 82,89 ****
--- 106,118 ----
        if (i>0) {
        SETREC(i);
        read(dlf,(void *)&u,sizeof(uploadsrec));
+       /* Credit MOD */ if (u.filetype!='F') {
        ++thisuser.downloaded;
        thisuser.dk += (int) ((u.numbytes+1023)/1024);
+       /* Credit MOD */     if (thisuser.exempt & exempt_charge && before_end_of_day(thisuser.exempt_daten))
+       /* Credit MOD */       thisuser.xk += (unsigned long) (u.numbytes+1023)/1024;
+       /* Credit MOD */ }
+       /* Credit MOD */ if (usernum!=u.ownerusr && !(thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten)))
        ++u.numdloads;
        SETREC(i);
        write(dlf,(void *)&u,sizeof(uploadsrec));
*************** void downloaded(char *fn, long cps)
*** 92,102 ****
--- 121,151 ----
        else
          sprintf(s,get_stringx(1,43),u.filename);
        sysoplog(s);
+       /* Credit MOD
        if (syscfg.sysconfig & sysconfig_log_dl) {
          sprintf(s,get_stringx(1,51),
            nam(&thisuser,usernum), u.filename, date());
          ssm(u.ownerusr,0,s);
        }
+       Credit MOD */
+       /* Credit MOD */ if ((usernum!=u.ownerusr) && !(thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten))) {
+       /* Credit MOD */   if ((u.ownersys==0) && (u.ownerusr!=0)) {
+       /* Credit MOD */     read_user(u.ownerusr,&uu);
+       /* Credit MOD */     if ((uu.inact & inact_deleted)==0) {
+       /* Credit MOD */        uu.ek += (1023L+u.numbytes)/1024L;
+       /* Credit MOD */        write_user(u.ownerusr,&uu);
+       /* Credit MOD */     }
+       /* Credit MOD */     if ((syscfg.sysconfig & sysconfig_log_dl) &&
+       /* Credit MOD */         (uu.dsl>=directories[batch[i1].dir].dsl) &&
+       /* Credit MOD */         (uu.age>=directories[batch[i1].dir].age) &&
+       /* Credit MOD */         (!directories[batch[i1].dir].dar ||
+       /* Credit MOD */          (directories[batch[i1].dir].dar & uu.dar)!=0)) {
+       /* Credit MOD */        ltoa((1023L+(u.numbytes*extcfg.dl_earnings_multiplier))/1024L,s2,10);
+       /* Credit MOD */        sprintf(s1,"%.20s downloaded %.13s on %.8s, %.5sk credit earned.",nam(&thisuser,usernum),stripfn(u.filename),date(),s2);
+       /* Credit MOD */        ssm(u.ownerusr,0,s1);
+       /* Credit MOD */     }
+       /* Credit MOD */   }
+       /* Credit MOD */ }
        }
        closedl();
        delbatch(i1);
*************** void uploaded(char *fn, long cps)
*** 255,266 ****
--- 304,318 ----
              }
            }
            closedl();
+         /* Credit MOD */ if (d1>=0)
          delbatch(i1);
          return;
        }
        }
        closedl();
+       /* Credit MOD
        delbatch(i1);
+       Credit MOD */
        if (try_to_ul(fn)) {
        sprintf(s,get_stringx(1,55), fn);
        sysoplog(s);
*************** void ymbatchdl(int had)
*** 290,296 ****
--- 342,351 ----
  
    if (!incom)
      return;
+   /* Credit MOD
    sprintf(s,get_stringx(1,57),numbatchdl, ctim(batchtime));
+   Credit MOD */
+   /* Credit MOD */ sprintf(s,"Ymodem BATCH DL, %d files, size=%ldk, time=%s",numbatchdl, ((batchlen+1023)/1024), ctim(batchtime));
    if (had)
      strcat(s,get_stringx(1,58));
    sysoplog(s);
*************** void ymbatchdl(int had)
*** 303,310 ****
--- 358,369 ----
      tleft(1);
      if ((syscfg.req_ratio>0.0001) && (ratio()<syscfg.req_ratio))
        rr=1;
+     /* Credit MOD
      if (thisuser.exempt & exempt_ratio)
        rr=0;
+     Credit MOD */
+     /* Credit MOD */ if (thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten))
+     /* Credit MOD */   rr=0;
      if (!batch[cur].sending) {
        rr=0;
        ++cur;
*************** void ymbatchdl(int had)
*** 316,322 ****
--- 375,384 ----
          delbatch(cur);
          closedl();
        } else {
+       /* Credit MOD
        sprintf(s,get_stringx(1,59),numbatchdl,ctim(batchtime));
+       Credit MOD */
+       /* Credit MOD */ sprintf(s,"%d files left, Size left = %ldk, Time left = %s\r\n",numbatchdl,((batchlen+1023)/1024),ctim(batchtime));
        outs(s);
          SETREC(i);
          read(dlf,(void *)&u,sizeof(uploadsrec));
*************** void make_dl_batch_list(char *listfn)
*** 465,476 ****
--- 527,546 ----
        cd_to(cdir);
        sprintf(s,"%s%s\r\n",s1,stripfn(batch[i].filename));
        ok=1;
+       /* Credit MOD
        if (nsl() < (batch[i].time + at))
+       Credit MOD */
+       /* Credit MOD */ if (nsl() < (batch[i].time + at) && !(thisuser.exempt & exempt_time && before_end_of_day(thisuser.exempt_daten)))
        ok=0;
+       /* Credit, Credit MOD
        thisk=(batch[i].len+1023)/1024;
        if ((syscfg.req_ratio>0.0001) && (ratio1(addk+thisk)<syscfg.req_ratio) &&
          (!(thisuser.exempt & exempt_ratio)))
        ok=0;
+       Credit, Credit MOD */
+       /* Credit, Credit MOD */ thisk=(batch[i].len+1023)/1024;
+       /* Credit, Credit MOD */ if (((double)(balance()-addk) < 0.0) && !(thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten)))
+       /* Credit, Credit MOD */   ok=0;
        if (ok) {
        write(f,s,strlen(s));
        at += batch[i].time;
*************** void dszbatchdl(int had, char *cmdln, ch
*** 582,589 ****
--- 652,662 ----
    char listfn[81],dl[100];
  
  
+   /* Credit MOD
    sprintf(dl,get_stringx(1,61),
          desc, numbatchdl, ctim(batchtime));
+   Credit MOD */
+   /* Credit MOD */ sprintf(dl,"%s BATCH DL, %d files, size=%ldk, time=%s",desc,numbatchdl,((batchlen+1023)/1024),ctim(batchtime));
    if (had)
      strcat(dl,get_stringx(1,58));
    sysoplog(dl);
*************** void dszbatchul(int had, char *cmdln, ch
*** 618,624 ****
--- 691,699 ----
    ti=timer()-ti;
    if (ti<0)
      ti += 24.0*3600.0;
+   /* Credit MOD
    thisuser.extratime += ti;
+   Credit MOD */
  }
  
  /****************************************************************************/
*************** void batchdl(void)
*** 658,663 ****
--- 733,739 ----
  {
    int i,abort,done,i1,i2,had,dsz;
    char s[81],s1[81],ch,ch1;
+   /* Credit MOD */ long old_balance;
  
    done=0;
    if (numbatch==0) {
*************** void batchdl(void)
*** 704,709 ****
--- 780,787 ----
            numbatch=0;
            numbatchdl=0;
          batchtime=0.0;
+         /* Credit MOD */ batchcharge=0;
+         /* Credit MOD */ batchlen=0;
          done=1;
            pl(get_string(875));
          }
*************** void batchdl(void)
*** 723,728 ****
--- 801,807 ----
        i=get_protocol(xf_up_batch);
        if (i>0) {
  
+         /* Credit MOD */ old_balance = balance();
          dszbatchul(had, externs[i-6].receivebatchfn, externs[i-6].description);
  
          if (!had) {
*************** void batchdl(void)
*** 730,735 ****
--- 809,815 ----
            outstr(get_string(782));
            npr("%-6.3f\r\n",ratio());
          }
+         /* Credit MOD */ npr("You %s have a credit balance of: %ldk\r\n",((old_balance == balance()) ? "still" : "now"),balance());
          done=1;
          }
          break;
*************** void batchdl(void)
*** 752,757 ****
--- 832,838 ----
        i=get_protocol(xf_bi);
        if (i>0) {
  
+         /* Credit MOD */ old_balance = balance();
          bibatch(had, externs[i-6].bibatchfn, externs[i-6].description);
  
          if (!had) {
*************** void batchdl(void)
*** 759,764 ****
--- 840,846 ----
            outstr(get_string(782));
            npr("%-6.3f\r\n",ratio());
          }
+         /* Credit MOD */ npr("You %s have a credit balance of: %ldk\r\n",((old_balance == balance()) ? "still" : "now"),balance());
          done=1;
        }
          break;
*************** void batchdl(void)
*** 785,790 ****
--- 867,873 ----
  
        i=get_protocol(xf_down_batch);
        if (i>0) {
+         /* Credit MOD */ old_balance = balance();
  
          if (i==4) {
            if (over_intern && (over_intern[2].othr & othr_override_internal) &&
*************** void batchdl(void)
*** 800,805 ****
--- 883,889 ----
            outstr(get_string(782));
            npr("%-6.3f\r\n",ratio());
          }
+         /* Credit MOD */ npr("You %s have a credit balance of: %ldk\r\n",((old_balance == balance()) ? "still" : "now"),balance());
          done=1;
        }
        break;



diff -H -b -p ./bbs.c Credit/bbs.c
*** ./bbs.c     Mon Jan 11 19:37:54 1993
--- credit/bbs.c        Fri Oct 22 18:03:06 1993
*************** void mainmenu(void)
*** 558,563 ****
--- 558,567 ----
      set_x_only(1, "POSTS.TXT", 0);
      nscan(0);
      set_x_only(0, NULL, 0);
+     /* Credit MOD */ tempfreefile=1;
+     /* Credit MOD */ strcpy(tempfilename,"POSTS");
+     /* Credit MOD */ tempownersys=0;
+     /* Credit MOD */ tempownerusr=0;
      add_arc("OFFLINE", "POSTS.TXT", 0);
      download_temp_arc("OFFLINE", 0);
    }
*************** void dlmainmenu(void)
*** 799,804 ****
--- 803,810 ----
      sysopchar(s1);
    } else
      sysopchar(s);
+   /* Credit MOD */ if ((strcmp(s,"FREE")==0) && (so()))
+   /* Credit MOD */   freefile();
    if (strcmp(s,"/O")==0)
      hangup=1;
    if (strcmp(s,"/S")==0) {
*************** void dlmainmenu(void)
*** 806,811 ****
--- 812,821 ----
      set_x_only(1,"FILES.TXT", 1);
      searchall();
      set_x_only(0, NULL, 0);
+     /* Credit MOD */ tempfreefile=1;
+     /* Credit MOD */ strcpy(tempfilename,"FILELIST");
+     /* Credit MOD */ tempownersys=0;
+     /* Credit MOD */ tempownerusr=0;
      add_arc("TEMP", "FILES.TXT", 1);
    }
    if ((strcmp(s,"/?")==0) && (dcs()))



diff -H -b -p ./bbsutl.c Credit/bbsutl.c
*** ./bbsutl.c  Fri Jan 08 21:42:12 1993
--- credit/bbsutl.c     Fri Oct 22 17:32:14 1993
*************** void yourinfo(void)
*** 491,496 ****
--- 491,498 ----
    } else
      nl();
    outstr(get_string(606)); pln(thisuser.dsl);
+   /* Credit MOD */ if (thisuser.exempt && before_end_of_day(thisuser.exempt_daten))
+   /* Credit MOD */   npr("Exemptions     : %s%s%s%sthrough %s\r\n",(thisuser.exempt & exempt_time ? "time " : ""),(thisuser.exempt & exempt_ratio ? "balance " : ""),(thisuser.exempt & exempt_charge ? "charges " : ""),(thisuser.exempt & exempt_post ? "post " : ""),ntos(thisuser.exempt_daten));
    outstr(get_string(366)); pl(thisuser.laston);
    outstr(get_string(607)); pln(thisuser.logons);
    outstr(get_string(608)); pln(thisuser.ontoday);



diff -H -b -p ./conio.c Credit/conio.c
*** ./conio.c   Wed Dec 30 17:33:08 1992
--- credit/conio.c      Sat Oct 23 01:23:20 1993
*************** void val_cur_user(void)
*** 684,689 ****
--- 684,690 ----
    char sl[4],dsl[4],exempt[4],sysopsub[4],ar[17],dar[17],restrict[17],rst[17],
         tl[50];
    int cp,i,done,rc,wx,wy;
+   /* Credit MOD */ char ex_dt[9], ndl[33],uk[34],dk[34],ek[34],xk[34],nul[33],gold[33],posts[34],logons[34],timeon[34];
  
    pr_wait(1);
    savescreen(&screensave);
*************** void val_cur_user(void)
*** 690,696 ****
--- 691,711 ----
    curatr=7;
    wx=15;
    wy=4;
+   /* Credit MOD
    makewindow(wx,wy,50,7);
+   Credit MOD */
+   /* Credit MOD */ makewindow(wx,wy,50,10);
+   /* Credit MOD */ ltoa(thisuser.dk,dk,10);
+   /* Credit MOD */ ltoa(thisuser.uk,uk,10);
+   /* Credit MOD */ ltoa(thisuser.ek,ek,10);
+   /* Credit MOD */ ltoa(thisuser.xk,xk,10);
+   /* Credit MOD */ itoa((int)thisuser.downloaded,ndl,10);
+   /* Credit MOD */ itoa((int)thisuser.uploaded,nul,10);
+   /* Credit MOD */ gcvt(thisuser.gold,10,gold);
+   /* Credit MOD */ itoa((int)thisuser.msgpost,posts,10);
+   /* Credit MOD */ itoa((int)thisuser.logons,logons,10);
+   /* Credit MOD */ ultoa((unsigned long)thisuser.timeon,timeon,10);
+   /* Credit MOD */ strcpy(ex_dt,ntos(thisuser.exempt_daten));
    itoa((int)thisuser.sl,sl,10);
    itoa((int)thisuser.dsl,dsl,10);
    itoa((int)thisuser.exempt,exempt,10);
*************** void val_cur_user(void)
*** 721,729 ****
--- 736,754 ----
    movecsr(wx+2,wy+2); sprintf(tl,get_stringx(1,79),dsl); outs(tl);
    movecsr(wx+26,wy+2); sprintf(tl,get_stringx(1,80),dar); outs(tl);
    movecsr(wx+2,wy+3); sprintf(tl,get_stringx(1,81),exempt); outs(tl);
+   /* Credit MOD */ movecsr(wx+12,wy+3); sprintf(tl,"- %s",ex_dt); outs(tl);
    movecsr(wx+26,wy+3); sprintf(tl,get_stringx(1,82),restrict); outs(tl);
    movecsr(wx+2,wy+4); sprintf(tl,get_stringx(1,83),sysopsub); outs(tl);
+   /* Credit MOD
    movecsr(wx+2,wy+5); sprintf(tl,get_stringx(1,84),thisuser.note); outs(tl);
+   Credit MOD */
+   /* Credit MOD */ movecsr(wx+26,wy+4); sprintf(tl,"GOLD : %s",gold); outs(tl);
+   /* Credit MOD */ movecsr(wx+2,wy+5); sprintf(tl,"UL= %3s/%6s/%6s",nul,uk,ek); outs(tl);
+   /* Credit MOD */ movecsr(wx+2,wy+6); sprintf(tl,"DL= %3s/%6s/%6s",ndl,dk,xk); outs(tl);
+   /* Credit MOD */ movecsr(wx+26,wy+5); sprintf(tl,"# OF LOGONS : %s",logons); outs(tl);
+   /* Credit MOD */ movecsr(wx+26,wy+6); sprintf(tl,"TIME ONLINE : %s",timeon); outs(tl);
+   /* Credit MOD */ movecsr(wx+26,wy+7); sprintf(tl,"POSTED MSGS : %s",posts); outs(tl);
+   /* Credit MOD */ movecsr(wx+2,wy+8); sprintf(tl,get_stringx(1,84),thisuser.note); outs(tl);
    while (done==0) {
      switch(cp) {
        case 0:
*************** void val_cur_user(void)
*** 763,769 ****
--- 788,803 ----
          itoa((int)thisuser.exempt,exempt,10);
          sprintf(tl,"%-3s",exempt); outs(tl);
          break;
+       /* Credit MOD */ case 5:
+       /* Credit MOD */   movecsr(wx+14,wy+3);
+       /* Credit MOD */   editline(ex_dt,8,ALL,&rc,"");
+       /* Credit MOD */   thisuser.exempt_daten=ston(ex_dt);
+       /* Credit MOD */   sprintf(tl,"%8s",ex_dt); outs(tl);
+       /* Credit MOD */   break;
+       /* Credit MOD
        case 5:
+       Credit MOD */
+       /* Credit MOD */ case 6:
        movecsr(wx+32,wy+3);
        editline(restrict,16,SET,&rc,rst);
        thisuser.restrict=0;
*************** void val_cur_user(void)
*** 771,777 ****
--- 805,814 ----
          if (restrict[i]!=32)
            thisuser.restrict |= (1 << i);
        break;
+       /* Credit MOD
        case 6:
+       Credit MOD */
+       /* Credit MOD */ case 7:
        movecsr(wx+12,wy+4);
        editline(sysopsub,3,NUM_ONLY,&rc,"");
        *qsc= atoi(sysopsub);
*************** void val_cur_user(void)
*** 778,792 ****
--- 815,909 ----
        itoa((int)*qsc,sysopsub,10);
        sprintf(tl,"%-3s",sysopsub); outs(tl);
        break;
+       /* Credit MOD
        case 7:
+       Credit MOD */
+       /* Credit MOD */ case 8:
+       /* Credit MOD */         movecsr(wx+33,wy+4);
+       /* Credit MOD */         editline(gold,15,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.gold = atof(gold);
+       /* Credit MOD */         gcvt(thisuser.gold,10,gold);
+       /* Credit MOD */         sprintf(tl,"%-15s",gold); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 9:
+       /* Credit MOD */         movecsr(wx+6,wy+5);
+       /* Credit MOD */         editline(nul,3,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.uploaded=(int) atoi(nul);
+       /* Credit MOD */         itoa((int)thisuser.uploaded,nul,10);
+       /* Credit MOD */         sprintf(tl,"%3s",nul); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 10:
+       /* Credit MOD */         movecsr(wx+10,wy+5);
+       /* Credit MOD */         editline(uk,6,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.uk=atol(uk);
+       /* Credit MOD */         ltoa(thisuser.uk,uk,10);
+       /* Credit MOD */         sprintf(tl,"%6s",uk); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 11:
+       /* Credit MOD */         movecsr(wx+17,wy+5);
+       /* Credit MOD */         editline(ek,6,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.ek=atol(ek);
+       /* Credit MOD */         ultoa(thisuser.ek,ek,10);
+       /* Credit MOD */         sprintf(tl,"%6s",ek); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 12:
+       /* Credit MOD */         movecsr(wx+6,wy+6);
+       /* Credit MOD */         editline(ndl,3,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.downloaded=(int) atoi(ndl);
+       /* Credit MOD */         itoa((int)thisuser.downloaded,ndl,10);
+       /* Credit MOD */         sprintf(tl,"%3s",ndl); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 13:
+       /* Credit MOD */         movecsr(wx+10,wy+6);
+       /* Credit MOD */         editline(dk,6,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.dk=atol(dk);
+       /* Credit MOD */         ultoa(thisuser.dk,dk,10);
+       /* Credit MOD */         sprintf(tl,"%6s",dk); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 14:
+       /* Credit MOD */         movecsr(wx+17,wy+6);
+       /* Credit MOD */         editline(xk,6,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.xk=atol(xk);
+       /* Credit MOD */         ultoa(thisuser.xk,xk,10);
+       /* Credit MOD */         sprintf(tl,"%6s",xk); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 15:
+       /* Credit MOD */         movecsr(wx+40,wy+5);
+       /* Credit MOD */         editline(logons,8,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.logons=(int) atoi(logons);
+       /* Credit MOD */         itoa((int)thisuser.logons,logons,10);
+       /* Credit MOD */         sprintf(tl,"%8s",logons); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 16:
+       /* Credit MOD */         movecsr(wx+40,wy+6);
+       /* Credit MOD */         editline(timeon,8,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.timeon=atof(timeon);
+       /* Credit MOD */         ultoa((unsigned long)thisuser.timeon,timeon,10);
+       /* Credit MOD */         sprintf(tl,"%8s",timeon); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 17:
+       /* Credit MOD */         movecsr(wx+40,wy+7);
+       /* Credit MOD */         editline(posts,8,NUM_ONLY,&rc,"");
+       /* Credit MOD */         thisuser.msgpost=(int) atoi(posts);
+       /* Credit MOD */         itoa((int)thisuser.msgpost,posts,10);
+       /* Credit MOD */         sprintf(tl,"%8s",posts); outs(tl);
+       /* Credit MOD */         break;
+       /* Credit MOD */ case 18:
+       /* Credit MOD */                movecsr(wx+8,wy+8);
+       /* Credit MOD
        movecsr(wx+8,wy+5);
+       Credit MOD */
        editline(thisuser.note,40,ALL,&rc,"");
        break;
      }
      switch(rc) {
        case DONE: done=1; break;
+       /* Credit MOD
        case NEXT: cp=(cp+1) % 8; break;
        case PREV: cp--; if (cp==-1) cp=7;  break;
+       Credit MOD */
+       /* Credit MOD */ case NEXT: cp=(cp+1) % 19; break;
+       /* Credit MOD */ case PREV: cp--; if (cp==-1) cp=18;  break;
      }
    }
    restorescreen(&screensave);
*************** void tleft(int x)
*** 1088,1094 ****
--- 1205,1214 ----
    curatr=cc;
    movecsr(cx,cy);
    if ((x) && (useron))
+     /* Credit MOD
      if (nsln==0.0) {
+     Credit MOD */
+     /* Credit MOD */ if ((nsln==0.0) && (! (thisuser.exempt & exempt_time && before_end_of_day(thisuser.exempt_daten)))) {
        nl();
        pl(get_string(926));
        nl();



diff -H -b -p ./lilo.c Credit/lilo.c
*** ./lilo.c    Thu Dec 03 19:55:02 1992
--- credit/lilo.c       Fri Oct 22 18:24:24 1993
*************** void logon(void)
*** 475,480 ****
--- 475,481 ----
    nscandate=thisuser.daten;
    batchtime=0.0;
    numbatchdl=numbatch=0;
+   /* Credit MOD */ batchcharge=batchlen=0;
    i1=0;
    for (i=0; i<20; i++) {
      if (questused[i])
*************** void logoff(void)
*** 519,526 ****
--- 520,529 ----
    ton=timer()-timeon;
    thisuser.timeon += ton;
    thisuser.timeontoday += (ton-extratimecall);
+   /* Credit MOD */ if (! (thisuser.exempt & exempt_time && before_end_of_day(thisuser.exempt_daten))) {
    status.activetoday += (int) (ton/60.0);
    save_status();
+   /* Credit MOD */ }
  
  
    
diff -H -b -p ./newuser.c Credit/newuser.c
*** ./newuser.c Tue Dec 08 19:35:02 1992
--- credit/newuser.c    Fri Oct 22 23:13:14 1993
*************** void newuser(void)
*** 740,745 ****
--- 740,746 ----
      }
      write_user(usernum,&thisuser);
      close_user();
+     /* Credit MOD */ disassociate_uploads(usernum);
      write_qscn(usernum, qsc, 0);
      isr(usernum,thisuser.name);
      ok=0;



diff -H -b -p ./sr.c Credit/sr.c
*** ./sr.c      Thu Dec 03 19:56:10 1992
--- credit/sr.c Fri Oct 22 18:24:22 1993
*************** void maybe_internal(char *fn, int *xferr
*** 463,469 ****
--- 463,472 ----
  }
  
  
+ /* Credit MOD
  void send_file(char *fn, int *sent, int *abort, char ft, char *sfn, int dn, long fs)
+ Credit MOD */
+ /* Credit MOD */ void send_file(char *fn, int *sent, int *abort, char ft, char *sfn, int dn, long fs, long fc)
  {
    int i,i1,ok;
    double percent,t;
*************** void send_file(char *fn, int *sent, int 
*** 519,525 ****
--- 522,538 ----
            t=(12.656) / ((double) (modem_speed)) * ((double)(fs));
          else
            t=0.0;
+         /* Credit MOD
          if (nsl()<=(batchtime + t)) {
+         Credit MOD */
+         /* Credit MOD */ if (((double)(balance()-batchcharge) < 0.0) && !(thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten))) {
+         /* Credit MOD */   nl();
+         /* Credit MOD */   pl("Batch list exceeds credit limit.");
+         /* Credit MOD */   nl();
+         /* Credit MOD */   *sent=0;
+         /* Credit MOD */   *abort=0;
+         /* Credit MOD */ } else
+         /* Credit MOD */ if (nsl()<=(batchtime + t) && !(thisuser.exempt & exempt_time && before_end_of_day(thisuser.exempt_daten))) {
            nl();
            pl(get_string(901));
            nl();
*************** void send_file(char *fn, int *sent, int 
*** 534,539 ****
--- 547,554 ----
                *abort=0;
            } else {
              batchtime += t;
+             /* Credit MOD */ batchcharge += fc;
+             /* Credit MOD */ batchlen += fs;
              strcpy(batch[numbatch].filename,sfn);
              batch[numbatch].dir=dn;
                batch[numbatch].time=t;
*************** void send_file(char *fn, int *sent, int 
*** 544,551 ****
--- 559,569 ----
                ++numbatchdl;
                nl();
                pl(get_string(903));
+             /* Credit MOD
              sprintf(s,"%s - %d  %s - %s",get_string(904),
                      numbatch, get_string(905),ctim(batchtime));
+             Credit MOD */
+             /* Credit MOD */ sprintf(s,"Batch: Files - %d  Size - %ldk  Time - %s",numbatch,((batchlen+1023)/1024),ctim(batchtime));
              nl();
                pl(s);
                nl();



diff -H -b -p ./uedit.c Credit/uedit.c
*** ./uedit.c   Thu Dec 03 19:55:36 1992
--- credit/uedit.c      Fri Oct 22 20:39:50 1993
*************** void print_data(int un, userrec *u, int 
*** 136,143 ****
--- 136,147 ----
      outstr(get_string(250)); npr("%d  %d  I=%d\r\n",u->logons,
        (strcmp(u->laston,date()))?0:u->ontoday,
        u->illegal);
+     /* Credit MOD
      outstr(get_string(251)); npr("U=%d-%ldk   D=%d-%ldk\r\n",u->uploaded,u->uk,
        u->downloaded, u->dk);
+     Credit MOD */
+     /* Credit MOD */ outstr(get_string(251));
+     /* Credit MOD */ npr("U=%d-%ldk   E=%ldk   D=%d-%ldk   X=%ldk   Balance=%ldk\r\n", u->uploaded, u->uk, u->ek, u->downloaded, u->dk, u->xk, (long) (u->uk/(syscfg.req_ratio!=0.0 ? syscfg.req_ratio : 1.0) + u->ek*extcfg.dl_earnings_multiplier + u->xk - u->dk));
      outstr(get_string(252)); pln(u->lastrate);
    }
    if (u->note[0]) {
*************** void print_data(int un, userrec *u, int 
*** 157,164 ****
--- 161,178 ----
      }
    }
    if (u->exempt) {
+     /* Credit MOD */ if (un==usernum || so()) {
+     /* Credit MOD */   int m,dd,y;
+     /* Credit MOD */   struct date d;
+     /* Credit MOD */   struct time t;
+     /* Credit MOD */
+     /* Credit MOD */   unixtodos(u->exempt_daten,&d,&t);
      outstr(get_string(257));
+     /* Credit MOD
      pln(u->exempt);
+     Credit MOD */
+     /* Credit MOD */   npr("%d - %02d/%02d/%02d\r\n",u->exempt,d.da_mon,d.da_day,(d.da_year-1900));
+     /* Credit MOD */ }
    }
    strcpy(s3,restrict_string);
    for (i=0; i<=15; i++) {
*************** void uedit(int usern, int other)
*** 374,379 ****
--- 388,394 ----
    char s[81],s1[81],s2[81],ch,ch1;
    int i,i1,i2,i3,un,done,nu,done1,full,temp_full,tempu,cls=1,done2;
    userrec u;
+   /* Credit MOD */ long li;
  
    u_qsc=(unsigned long *)farmalloc(syscfg.qscn_len);
  
*************** void uedit(int usern, int other)
*** 507,512 ****
--- 522,528 ----
            break;
          case 'C':
          nl();
+         /* Credit MOD
          prt(2,get_string(270));
          input(s,sizeof(u.callsign)-1);
          if (s[0]) {
*************** void uedit(int usern, int other)
*** 519,524 ****
--- 535,572 ----
              write_user(un,&u);
            }
          }
+         Credit MOD */
+         /* Credit MOD */ prt(2,"New upload credits? ");
+         /* Credit MOD */ input(s,10);
+         /* Credit MOD */ li=atol(s);
+         /* Credit MOD */ if (s[0]) {
+         /* Credit MOD */   u.uk=li;
+         /* Credit MOD */   write_user(un,&u);
+         /* Credit MOD */ }
+         /* Credit MOD */ nl();
+         /* Credit MOD */ prt(2,"New earned credits? ");
+         /* Credit MOD */ input(s,10);
+         /* Credit MOD */ li=atol(s);
+         /* Credit MOD */ if (s[0]) {
+         /* Credit MOD */   u.ek=li;
+         /* Credit MOD */   write_user(un,&u);
+         /* Credit MOD */ }
+         /* Credit MOD */ nl();
+         /* Credit MOD */ prt(2,"New download charges? ");
+         /* Credit MOD */ input(s,10);
+         /* Credit MOD */ li=atol(s);
+         /* Credit MOD */ if (s[0]) {
+         /* Credit MOD */   u.dk=li;
+         /* Credit MOD */   write_user(un,&u);
+         /* Credit MOD */ }
+         /* Credit MOD */ nl();
+         /* Credit MOD */ prt(2,"New exempted download credits? ");
+         /* Credit MOD */ input(s,10);
+         /* Credit MOD */ li=atol(s);
+         /* Credit MOD */ if (s[0]) {
+         /* Credit MOD */   u.xk=li;
+         /* Credit MOD */   write_user(un,&u);
+         /* Credit MOD */ }
          break;
        case 'P':
          nl();
*************** void uedit(int usern, int other)
*** 603,608 ****
--- 651,680 ----
            i=atoi(s);
            if ((i>=0) && (i<=255) && (s[0])) {
            u.exempt=i;
+           /* Credit MOD */ if (i>0) {
+           /* Credit MOD */   int m,dd,y;
+           /* Credit MOD */   struct date d;
+           /* Credit MOD */   struct time t;
+           /* Credit MOD */
+           /* Credit MOD */   prt(2,"Enter new exemption expiration date in the format\r\n");
+           /* Credit MOD */   pl(get_string(792));
+           /* Credit MOD */   outstr(":");
+           /* Credit MOD */   mpl(8);
+           /* Credit MOD */   input(s,8);
+           /* Credit MOD */   m=atoi(s);
+           /* Credit MOD */   dd=atoi(&(s[3]));
+           /* Credit MOD */   y=atoi(&(s[6]))+1900;
+           /* Credit MOD */   if ((strlen(s)==8) && (m>0) && (m<=12) && (dd>0) && (dd<32) && (y>=1980)) {
+           /* Credit MOD */     t.ti_min=0;
+           /* Credit MOD */     t.ti_hour=0;
+           /* Credit MOD */     t.ti_hund=0;
+           /* Credit MOD */     t.ti_sec=0;
+           /* Credit MOD */     d.da_year=y;
+           /* Credit MOD */     d.da_day=dd;
+           /* Credit MOD */     d.da_mon=m;
+           /* Credit MOD */     u.exempt_daten=dostounix(&d,&t);
+           /* Credit MOD */   }
+           /* Credit MOD */ }
            write_user(un,&u);
            }
            break;



diff -H -b -p ./utility.c Credit/utility.c
*** ./utility.c Thu Dec 03 19:55:56 1992
--- credit/utility.c    Fri Oct 22 18:09:30 1993
*************** void end_crit(void)
*** 1141,1143 ****
--- 1141,1179 ----
      geninterrupt(0x15);
    }
  }
+ /* Credit MOD */ int before_end_of_day(time_t t)
+ /* Credit MOD */ {
+ /* Credit MOD */   return(time(NULL) < (t + (24L*60L*60L)));
+ /* Credit MOD */ }
+ /* Credit MOD */
+ /* Credit MOD */ long ston(char *s)
+ /* Credit MOD */ {
+ /* Credit MOD */   struct date d;
+ /* Credit MOD */   struct time t;
+ /* Credit MOD */   int m,dd,y;
+ /* Credit MOD */
+ /* Credit MOD */   m=atoi(s);
+ /* Credit MOD */   dd=atoi(&(s[3]));
+ /* Credit MOD */   y=atoi(&(s[6]))+1900;
+ /* Credit MOD */   if ((strlen(s)==8) && (m>0) && (m<=12) && (dd>0) && (dd<32) && (y>=1980)) {
+ /* Credit MOD */     t.ti_min=0;
+ /* Credit MOD */     t.ti_hour=0;
+ /* Credit MOD */     t.ti_hund=0;
+ /* Credit MOD */     t.ti_sec=0;
+ /* Credit MOD */     d.da_year=y;
+ /* Credit MOD */     d.da_day=dd;
+ /* Credit MOD */     d.da_mon=m;
+ /* Credit MOD */     return(dostounix(&d,&t));
+ /* Credit MOD */   } else
+ /* Credit MOD */     return(-1);
+ /* Credit MOD */ }
+ /* Credit MOD */ char *ntos(long n)
+ /* Credit MOD */ {
+ /* Credit MOD */   static char s[9];
+ /* Credit MOD */   struct date d;
+ /* Credit MOD */   struct time t;
+ /* Credit MOD */
+ /* Credit MOD */   unixtodos(n,&d,&t);
+ /* Credit MOD */   sprintf(s,"%02d/%02d/%02d",d.da_mon,d.da_day,(d.da_year-1900));
+ /* Credit MOD */   return(s);
+ /* Credit MOD */ }



diff -H -b -p ./vardec.h Credit/vardec.h
*** ./vardec.h  Thu Dec 17 17:49:10 1992
--- credit/vardec.h     Fri Oct 22 18:48:36 1993
*************** typedef struct {
*** 109,116 ****
--- 109,122 ----
        wwiv_regnum,    /* user's WWIV reg number */
        filepoints;     /* points to spend for files */
  
+     /* Credit MOD
      char
        res_long[56];   /* reserved for long values */
+     Credit MOD */
+     /* Credit MOD */  char res_long[44]; /* reserved for long values */
+     /* Credit MOD */  long exempt_daten, /* exemption expiration date */
+     /* Credit MOD */       ek,           /* number of k download earnings */
+     /* Credit MOD */       xk;           /* number of k download exempts */
  
      float
        timeontoday,    /* time on today */
*************** typedef struct {
*** 459,464 ****
--- 465,471 ----
          short           dir;
          float           time;
          long            len;
+       long            /* Credit MOD */ charge;
  } batchrec;
  
  typedef enum {
*************** typedef enum {
*** 472,478 ****
--- 479,488 ----
  /* userrec.exempt */
  #define exempt_ratio 0x01
  #define exempt_time 0x02
+ /* Credit MOD
  #define exempt_all 0x04
+ Credit MOD */
+ /* Credit MOD */ #define exempt_charge 0x04
  #define exempt_post 0x08
  
  /* userrec.restrict */
*************** typedef struct {
*** 632,637 ****
--- 642,650 ----
                          com_speed;              /* speed com port runs at */
  } resultrec;
  
+ /* Credit MOD */ typedef struct {
+ /* Credit MOD */   float  dl_earnings_multiplier;
+ /* Credit MOD */ } configextendedrec;
  
  #define max_buf 1024
  #define MSG_COLOR 0



diff -H -b -p ./vars.h Credit/vars.h
*** ./vars.h    Wed Dec 16 15:36:48 1992
--- credit/vars.h       Fri Oct 22 18:48:36 1993
*************** __EXTRN__ char ansistr[81], cdir[81], ch
*** 74,79 ****
--- 74,80 ----
                 search_pattern[81], *sp, str_no[20], str_pause[80],
                 str_quit[20], str_yes[20], tc[81], ver_no1[51],
                 ver_no2[51],wwiv_net_no[20], xdate[9], *xenviron[50];
+ /* Credit MOD */ __EXTRN__ char tempfilename[13];
  
  __EXTRN__ unsigned char actsl, andwith, checksum;
  
*************** __EXTRN__ int abortext, already_on, ansi
*** 98,103 ****
--- 99,105 ----
              sysop_alert, tempio, topdata, topline, two_color,
              userfile, usernum, useron, use_workspace, using_modem,
              wfc, x_only;
+ /* Credit MOD */ __EXTRN__ int tempownersys, tempownerusr, tempfreefile;
  
  __EXTRN__ unsigned short com_speed, *csn_index, crc, *gat, modem_flag,
                         modem_mode, modem_speed, net_sysnum;
*************** __EXTRN__ unsigned short com_speed, *csn
*** 105,110 ****
--- 107,113 ----
  
  __EXTRN__ long *dir_dates, hanguptime1, last_time_c, nscandate, *sub_dates,
               this_date, timelastchar1, quotes_nrm_l, quotes_ind_l;
+ /* Credit MOD */ __EXTRN__ long batchcharge, batchlen;
  
  __EXTRN__ unsigned long *qsc, *qsc_n, *qsc_q, *qsc_p;
  
*************** __EXTRN__ float batchtime;
*** 114,119 ****
--- 117,123 ----
  __EXTRN__ double extratimecall, last_time, timeon, time_event, xtime;
  
  
+ /* Credit MOD */ __EXTRN__ configextendedrec extcfg;
  __EXTRN__ userrec thisuser;
  __EXTRN__ configrec syscfg;
  __EXTRN__ statusrec status;



diff -H -b -p ./xfer.c Credit/xfer.c
*** ./xfer.c    Sun Jan 10 14:11:50 1993
--- credit/xfer.c       Fri Oct 22 20:34:38 1993
*************** int ratio_ok(void)
*** 266,275 ****
--- 266,282 ----
    int ok=1;
    char s[101];
  
+   /* Credit MOD
    if (!(thisuser.exempt & exempt_ratio))
+   Credit MOD */
+   /* Credit MOD */ if (! (thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten)))
+   /* Credit MOD
      if ((syscfg.req_ratio>0.0001) && (ratio()<syscfg.req_ratio)) {
+   Credit MOD */
+     /* Credit MOD */ if ((double) balance() < 0.0) {  /* you cannot overdraw */
        ok=0;
        nl();
+       /* Credit MOD
        nl();
        sprintf(s,"%s %-5.3f.  %s %-5.3f %s.",
              get_string(730), ratio(),
*************** int ratio_ok(void)
*** 276,281 ****
--- 283,291 ----
              get_string(731), syscfg.req_ratio,
              get_string(732));
        pl(s);
+       Credit MOD */
+       /* Credit MOD */ npr("You have a credit balance of: %ldk\r\n",balance());
+       /* Credit MOD */ npr("You cannot download until you gain more credit.\r\n");
        nl();
      }
  
*************** int printfileinfo(uploadsrec *u, int dn)
*** 971,981 ****
--- 981,1000 ----
      d=0.0;
    outstr(get_string(746)); pl(stripfn(u->filename));
    outstr(get_string(747)); pl(u->description);
+   /* Credit MOD
    outstr(get_string(748)); npr("%dk\r\n", ((u->numbytes)+1023)/1024);
+   Credit MOD */
+   /* Credit MOD */ outstr(get_string(748));
+   /* Credit MOD */ if (u->filetype=='F')
+   /* Credit MOD */   npr("%dk - free download\r\n", ((u->numbytes)+1023)/1024);
+   /* Credit MOD */ else
+   /* Credit MOD */   npr("%dk\r\n", ((u->numbytes)+1023)/1024);
    outstr(get_string(749)); pl(ctim(d));
    outstr(get_string(750)); pl(u->date);
    outstr(get_string(751)); pl(u->upby);
    outstr(get_string(752)); pln(u->numdloads);
+   /* Credit MOD */ if (syscfg.req_ratio>0.0001)
+   /* Credit MOD */   npr("Crd. earned: %ldk\r\n",(long) ((((u->numbytes/syscfg.req_ratio)+1023)/1024)+(u->numdloads*(((u->numbytes*extcfg.dl_earnings_multiplier)+1023)/1024))));
    nl();
    abort=0;
    if (u->mask & mask_extended) {
*************** int printfileinfo(uploadsrec *u, int dn)
*** 991,997 ****
--- 1010,1019 ----
      return(-1);
    }
  
+   /* Credit MOD
    if (nsl()>=d)
+   Credit MOD */
+   /* Credit MOD */ if (nsl()>=d || (thisuser.exempt & exempt_time && before_end_of_day(thisuser.exempt_daten)))
      return(1);
    else
      return(0);
*************** void upload(int dn)
*** 1260,1267 ****
--- 1282,1292 ----
            nl();
            pl(get_string(781));
            nl();
+           /* Credit MOD
            outstr(get_string(782));
            npr("%-6.3f\r\n", ratio());
+           Credit MOD */
+           /* Credit MOD */ npr("You now have a credit balance of: %ldk\r\n",balance());
            nl();
              nl();
              if (useron)
*************** int try_to_download(char *s, int dn,int 
*** 1311,1316 ****
--- 1336,1343 ----
    uploadsrec u;
    char s1[81];
    userrec ur;
+   /* Credit MOD */ char s2[81];
+   /* Credit MOD */ userrec uu;
  
    dliscan1(dn);
    i=recno(s);
*************** int try_to_download(char *s, int dn,int 
*** 1344,1355 ****
--- 1371,1396 ----
        sent=0;
        abort=0;
        if (i1==-1)
+       /* Credit MOD
        send_file(s1,&sent,&abort,u.filetype,u.filename,dn, -2L);
+       Credit MOD */
+       /* Credit MOD */ send_file(s1,&sent,&abort,u.filetype,u.filename,dn, -2L, -2L);
        else
+       /* Credit MOD
        send_file(s1,&sent,&abort,u.filetype,u.filename,dn, u.numbytes);
+       Credit MOD */
+       /* Credit MOD */ send_file(s1,&sent,&abort,u.filetype,u.filename,dn, u.numbytes, ((u.filetype=='F') ? 0 : (u.numbytes+1023)/1024));
        if (sent) {
+         /* Credit MOD */ if (u.filetype!='F') {
        ++thisuser.downloaded;
+       /* Credit MOD
        thisuser.dk += (int) ((u.numbytes+1023)/1024);
+       Credit MOD */
+       /* Credit MOD */   thisuser.dk += (unsigned long) (u.numbytes+1023)/1024;
+       /* Credit MOD */   if (thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten))
+       /* Credit MOD */     thisuser.xk += (unsigned long) (u.numbytes+1023)/1024;
+       /* Credit MOD */ }
+       /* Credit MOD */ if (usernum!=u.ownerusr && !(thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten)))
        ++u.numdloads;
        SETREC(i);
        write(dlf,(void *)&u,sizeof(uploadsrec));
*************** int try_to_download(char *s, int dn,int 
*** 1357,1362 ****
--- 1398,1404 ----
        sysoplog(s1);
        nl();
        nl();
+       /* Credit MOD
        outstr(get_string(782)); npr("%-6.3f\r\n", ratio());
        if (syscfg.sysconfig & sysconfig_log_dl) {
          read_user(u.ownerusr, &ur);
*************** int try_to_download(char *s, int dn,int 
*** 1368,1373 ****
--- 1410,1435 ----
            }
          }
        }
+       Credit MOD */
+       /* Credit MOD */ if ((usernum!=u.ownerusr) && !(thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten))) {
+       /* Credit MOD */   if ((u.ownersys==0) && (u.ownerusr!=0)) {
+       /* Credit MOD */     read_user(u.ownerusr,&uu);
+       /* Credit MOD */     if ((uu.inact & inact_deleted)==0) {
+       /* Credit MOD */      uu.ek += (1023L+u.numbytes)/1024L;
+       /* Credit MOD */      write_user(u.ownerusr,&uu);
+       /* Credit MOD */     }
+       /* Credit MOD */     if ((syscfg.sysconfig & sysconfig_log_dl) &&
+       /* Credit MOD */         (uu.dsl>=directories[dn].dsl) &&
+       /* Credit MOD */         (uu.age>=directories[dn].age) &&
+       /* Credit MOD */         (!directories[dn].dar ||
+       /* Credit MOD */          (directories[dn].dar & uu.dar)!=0)) {
+       /* Credit MOD */      ltoa((long)(((long)(u.numbytes*extcfg.dl_earnings_multiplier)+1023L)/1024L),s2,10);
+       /* Credit MOD */      sprintf(s1,"%s downloaded '%s' on %s, %sk credit earned.",nam(&thisuser,usernum),stripfn(u.filename),date(),s2);
+       /* Credit MOD */      ssm(u.ownerusr,0,s1);
+       /* Credit MOD */     }
+       /* Credit MOD */   }
+       /* Credit MOD */ }
+       /* Credit MOD */ npr("You %s have a credit balance of: %ldk\r\n",(((u.filetype=='F') || (thisuser.exempt & exempt_charge && before_end_of_day(thisuser.exempt_daten))) ? "still" : "now"),balance());
        if (useron)
          topscreen();
        }
*************** void yourinfodl(void)
*** 1565,1570 ****
--- 1627,1634 ----
    nl();
    outstr(get_string(796));
    npr("%ldk",thisuser.uk);
+   /* Credit MOD */ if (syscfg.req_ratio>0.0001)
+   /* Credit MOD */ npr(" * %.3lf",1.0/syscfg.req_ratio);
    outstr(get_string(797));
    npr("%d",thisuser.uploaded);
    pl(get_string(798));
*************** void yourinfodl(void)
*** 1572,1580 ****
--- 1636,1654 ----
    npr("%ldk",thisuser.dk);
    outstr(get_string(797));
    npr("%d",thisuser.downloaded);
+   /* Credit MOD */ if (thisuser.xk)
+   /* Credit MOD */   npr(" files (%luk exempted)\r\n",thisuser.xk);
+   /* Credit MOD */ else
    pl(get_string(798));
+   /* Credit MOD */ npr("Earnings : %luk * %.3lf\r\n",thisuser.ek,extcfg.dl_earnings_multiplier);
+   /* Credit MOD */ npr("Balance  : %ldk\r\n",balance());
    outstr(get_string(800)); npr("%-6.3f\r\n",ratio());
+   /* Credit MOD
    outstr(get_string(801)); pln(thisuser.dsl);
+   Credit MOD */
+   /* Credit MOD */ npr("Your DSL : %d\r\n",thisuser.dsl);
+   /* Credit MOD */ if ((thisuser.exempt & (exempt_ratio | exempt_charge)) && before_end_of_day(thisuser.exempt_daten))
+   /* Credit MOD */   npr("Exempt   : %s through %s\r\n",((thisuser.exempt & exempt_ratio) ? "from balance" : "from download charges"),ntos(thisuser.exempt_daten));
    nl();
  }
  
*************** void removefile(void)
*** 1702,1707 ****
--- 1776,1782 ----
    char ch,s[81],s1[81];
    uploadsrec u;
    userrec uu;
+   /* Credit MOD */ char s2[81];
  
    dliscan();
    nl();
*************** void removefile(void)
*** 1751,1758 ****
--- 1826,1843 ----
              if ((uu.inact & inact_deleted)==0) {
                if (date_to_daten(uu.firston) < u.daten) {
                  --uu.uploaded;
+                 /* Credit MOD
                  uu.uk -= ((u.numbytes+1023)/1024);
+                 Credit MOD */
+                 /* Credit MOD */ uu.uk -= (1023L+u.numbytes)/1024L;
+                 /* Credit MOD */ uu.ek -= u.numdloads * (1023L+u.numbytes)/1024L;
                  write_user(u.ownerusr,&uu);
+                 /* Credit MOD */ if (syscfg.req_ratio>0.0001 && syscfg.sysconfig & sysconfig_log_dl)
+                 /* Credit MOD */   if (usernum!=u.ownerusr) {
+                 /* Credit MOD */     ltoa((long) ((((u.numbytes/syscfg.req_ratio)+1023)/1024)+(u.numdloads*(((u.numbytes*extcfg.dl_earnings_multiplier)+1023)/1024))),s2,10);
+                 /* Credit MOD */     sprintf(s1,"%s was removed and deleted on %s, %sk credit removed.",stripfn(u.filename),date(),s2);
+                 /* Credit MOD */     ssm(u.ownerusr,0,s1);
+                 /* Credit MOD */   }
                }
              }
              close_user();
*************** void removefile(void)
*** 1785,1787 ****
--- 1870,1876 ----
  }
  
  
+ /* Credit MOD */ long balance(void)
+ /* Credit MOD */ {
+ /* Credit MOD */   return((long)(thisuser.uk/(syscfg.req_ratio>0.0001 ? syscfg.req_ratio : 1.0) + thisuser.ek*extcfg.dl_earnings_multiplier + thisuser.xk - thisuser.dk));
+ /* Credit MOD */ }



diff -H -b -p ./xferovl.c Credit/xferovl.c
*** ./xferovl.c Thu Dec 31 11:00:54 1992
--- credit/xferovl.c    Sat Oct 23 00:33:28 1993
*************** int upload_file(char *fn, int dn, char *
*** 428,434 ****
--- 428,437 ----
      strcpy(u.date,date());
      if (d.mask & mask_PD)
        d.mask=mask_PD;
+     /* Credit MOD
      npr("%s: %4ldk :",u.filename,((u.numbytes)+1023)/1024);
+     Credit MOD */
+     /* Credit MOD */ npr("%s: %5ldk :",u.filename,((u.numbytes)+1023)/1024);
      if ((desc) && (*desc)) {
        strncpy(u.description,desc,58);
        u.description[58]=0;
*************** int uploadall(int dn)
*** 576,579 ****
--- 581,644 ----
    return(i1);
  }
  
+ /* Credit MOD */ void freefile(void)
+ /* Credit MOD */ {                                               /* conflicts with apple */
+ /* Credit MOD */   char s[81],ch;                                /* filetype file record */
+ /* Credit MOD */   int i;
+ /* Credit MOD */   uploadsrec u;
+ /* Credit MOD */
+ /* Credit MOD */   nl();
+ /* Credit MOD */   nl();
+ /* Credit MOD */   prt(2,"File to make free or not free to download: ");
+ /* Credit MOD */   mpl(12);
+ /* Credit MOD */   input(s,12);
+ /* Credit MOD */   if (s[0]==0)
+ /* Credit MOD */     return;
+ /* Credit MOD */   if (strchr(s,'.')==NULL)
+ /* Credit MOD */     strcat(s,"*.*");
+ /* Credit MOD */   align(s);
+ /* Credit MOD */   dliscan();
+ /* Credit MOD */   nl();
+ /* Credit MOD */   i=recno(s);
+ /* Credit MOD */   while (i>0) {
+ /* Credit MOD */     SETREC(i);
+ /* Credit MOD */     read(dlf,(void *)&u,sizeof(uploadsrec));
+ /* Credit MOD */     nl();
+ /* Credit MOD */     printfileinfo(&u,udir[curdir].subnum);
+ /* Credit MOD */     nl();
+ /* Credit MOD */     prt(5,"Should this file be free to download (Y/N/Q)? ");
+ /* Credit MOD */     ch=onek("QNY");
+ /* Credit MOD */     if (ch=='Q')
+ /* Credit MOD */       break;
+ /* Credit MOD */     else {
+ /* Credit MOD */       if ((ch=='Y') && (u.filetype==0))
+ /* Credit MOD */         u.filetype='F';
+ /* Credit MOD */       else
+ /* Credit MOD */         if ((ch=='N') && (u.filetype=='F'))
+ /* Credit MOD */           u.filetype=0;
+ /* Credit MOD */       SETREC(i);
+ /* Credit MOD */       write(dlf,(void *)&u,sizeof(uploadsrec));
+ /* Credit MOD */       i=nrecno(s,i);
+ /* Credit MOD */     }
+ /* Credit MOD */   }
+ /* Credit MOD */   closedl();
+ /* Credit MOD */ }
+ /* Credit MOD */ void disassociate_uploads(unsigned int un)
+ /* Credit MOD */ {
+ /* Credit MOD */   int i,i1;
+ /* Credit MOD */   uploadsrec u;
+ /* Credit MOD */
+ /* Credit MOD */   for (i=0; (i<64) && (udir[i].subnum!=-1); i++) {
+ /* Credit MOD */     dliscan();
+ /* Credit MOD */     for (i1=1; (i1<=numf); i1++) {
+ /* Credit MOD */       SETREC(i1);
+ /* Credit MOD */       read(dlf,(void *)&u,sizeof(uploadsrec));
+ /* Credit MOD */       if (u.ownerusr==un && u.ownersys==0) {
+ /* Credit MOD */         u.ownersys=-1;
+ /* Credit MOD */         write(dlf,(void *)&u,sizeof(uploadsrec));
+ /* Credit MOD */       }
+ /* Credit MOD */     }
+ /* Credit MOD */     closedl();
+ /* Credit MOD */   }
+ /* Credit MOD */ }
  


diff -H -b -p ./xfertmp.c Credit/xfertmp.c
*** ./xfertmp.c Thu Dec 03 19:55:16 1992
--- credit/xfertmp.c    Fri Oct 22 23:05:04 1993
*************** void download_temp_arc(char *fn, int xfe
*** 404,409 ****
--- 404,411 ----
    long numbytes;
    double d;
    int i,f,sent,abort;
+   /* Credit MOD */ char s2[81];
+   /* Credit MOD */ userrec uu;
  
    outstr(get_string(847));
    npr("%s.%s:\r\n\r\n", fn, syscfg.arcs[ARC_NUMBER].extension);
*************** void download_temp_arc(char *fn, int xfe
*** 433,449 ****
--- 435,479 ----
      pl(ctim(d));
      sent=0;
      abort=0;
+     /* Credit MOD
      sprintf(s,"%s.%s",fn,syscfg.arcs[ARC_NUMBER].extension);
      send_file(s1,&sent,&abort,0,s,-1,numbytes);
+     Credit MOD */
+     /* Credit MOD */ send_file(s1,&sent,&abort,0,s,-1,numbytes,(tempfreefile ? 0 : numbytes));
      if (sent) {
        if (xfer) {
+       /* Credit MOD */ if (!tempfreefile) {
        ++thisuser.downloaded;
        thisuser.dk += ((numbytes+1023)/1024);
+       /* Credit MOD
        nl();
        nl();
        outstr(get_string(782)); npr("%-6.3f\r\n",ratio());
+       Credit MOD */
+       /* Credit MOD */   if (thisuser.exempt & exempt_charge && before_end_of_day(thisuser.exempt_daten))
+       /* Credit MOD */     thisuser.xk += (unsigned long) (numbytes+1023)/1024;
+       /* Credit MOD */ }
+       /* Credit MOD */ if ((usernum!=tempownerusr) && !(thisuser.exempt & (exempt_ratio | exempt_charge) && before_end_of_day(thisuser.exempt_daten))) {
+       /* Credit MOD */   if ((tempownersys==0) && (tempownerusr!=0)) {
+       /* Credit MOD */     read_user(tempownerusr,&uu);
+       /* Credit MOD */     if ((uu.inact & inact_deleted)==0) {
+       /* Credit MOD */       uu.ek += (1023L+numbytes)/1024L;
+       /* Credit MOD */       write_user(tempownerusr,&uu);
+       /* Credit MOD */     }
+       /* Credit MOD */     if ((syscfg.sysconfig & sysconfig_log_dl) &&
+       /* Credit MOD */         (!thisuser.dar ||
+       /* Credit MOD */          (thisuser.dar & uu.dar)!=0)) {
+       /* Credit MOD */       ltoa((long)(((long)(numbytes*extcfg.dl_earnings_multiplier)+1023L)/1024L),s2,10);
+       /* Credit MOD */       sprintf(s1,"%s downloaded '%s' on %s, %sk credit earned.",nam(&thisuser,usernum),stripfn(s),date(),s2);
+       /* Credit MOD */       ssm(tempownerusr,0,s1);
+       /* Credit MOD */       sprintf(s1,"  %s was extracted from %s.",stripfn(s),tempfilename);
+       /* Credit MOD */       ssm(tempownerusr,0,s1);
+       /* Credit MOD */     }
+       /* Credit MOD */   }
+       /* Credit MOD */ }
        }
        sprintf(s1,get_stringx(1,45),(numbytes+1023)/1024, s);
+       /* Credit MOD */ sprintf(s1,"Downloaded %s, extracted from %s, and was charged %ldk.",stripfn(s),tempfilename,(tempfreefile ? 0 : (numbytes+1023)/1024));
        sysoplog(s1);
        if (useron)
          topscreen();
*************** void temp_extract(void)
*** 619,624 ****
--- 649,660 ----
            if (!okfn(s1))
              s3[0]=0;
            if (s3[0]) {
+             /* Credit MOD */ if ((tempownerusr!=u.ownerusr) || (tempfreefile != (u.filetype=='F')))
+             /* Credit MOD */   remove_from_temp("*.*",syscfg.tempdir,0);
+             /* Credit MOD */ strcpy(tempfilename,stripfn(u.filename));
+             /* Credit MOD */ tempownersys=u.ownersys;
+             /* Credit MOD */ tempownerusr=u.ownerusr;
+             /* Credit MOD */ tempfreefile=(u.filetype=='F');
              do_external(s3,0);
              sprintf(s2,get_stringx(1,47),s1,u.filename);
            } else



diff -H -b -p ./xinit.c Credit/xinit.c
*** ./xinit.c   Wed Dec 30 17:08:00 1992
--- credit/xinit.c      Fri Oct 22 18:48:34 1993
*************** void init(void)
*** 503,506 ****
--- 503,507 ----
    unlink("WWIV_NET.DAT");
  
    detect_multitask();
+   /* Credit MOD */ extcfg.dl_earnings_multiplier=0.50;
  }



Other modifications by Arc Angel

Filename      Ver     Date     Description

1usenup.mod   1.0   09/06/93   Uses nup's from a list (deleted after 1 use)
422ml.mod     1.2   06/03/93   Adds multiline capability to WWIV v4.22
Guest.mod     1.1   10/10/93   Adds a (G)uest restriction to WWIV
Merge.mod     1.1   10/09/93   Allows full control over WWIV network gating

