43/100: ST006: 95 colors
Name: Starship Trooper #1 @2750 God
Date: Wed Feb 03 15:10:54 1993
From: Valhalla (Illinois) [217-352-3682]
 
/*
 *Name       : 95 Colors
 *Filename   : ST006.MOD                (alternate: 95color.mod)
 *Description: More colors than you could ever use!
 *Difficulty : Not.
 *Version    : 4.22 (probably compatible with most others)
 *Files      : VARS.H (sorry) XINIT.C COM.C BBSUTL.C WWIVEDIT\CONFIG\*.DEF
 *Author     : Starship Trooper 1@2750 Net  1@12754 Link
 *Date       : Feb 1993
 */
 
This mod will give you 95 colors.  All of them use the "heart code" convention.
That is, they exist after a ^C character in the files, and the color
character is typed after a ^P in the editors, just like the standard 10
colors.  0-9 are the defaults, and I have added A-Z, a-z, and all punctuation
marks between ! (33) and  (127).
 
1. File VARS.H, add one line with the other __EXTRN__ declarations:
 
__EXTRN__ char colours[96];
 
Note the spelling of "colours".
 
2. File XINIT.C.  Near the bottom, just before detecting a multitasker, add
   the code to initialize the colours[] array.
 
  strcpy(colours,         /* 33-47 (!-/)  grey backgrounds */
    "\x70\x71\x72\x73\x74\x75\x76\x78\x79\x7A\x7B\x7C\x7D\x7E\x7F");
  strcat(colours,         /* 48-57 (0-9)duplicate the defaults */
    "\x07\x0B\x0E\x05\x1F\x02\x8C\x09\x01\x03");
  strcat(colours,         /* 58-64 (:-@) grey foregrounds */
    "\x17\x47\x57\x67\x28\x38\x68");
  strcat(colours,         /* 65-90 (A-Z) black backgrounds, yellows, whites,
                             black foregrounds, */
    "\x04\x06\x08\x0A\x0C\x0D\x0F\x1E\x2E\x3E\x4E\x5e\x6e\x2f\x3f\x4f\x5f\x6f\x
10\x20\x30\x40\x50\x60\x1C\x2C");
  strcat(colours,         /* 91-96 ([\]^_`  flashing */
    "\x8B\x8E\x85\x9F\x82\x8C";
  strcat(colours,        /* 97-122 a-z onblu, oncyan, ongrn, onred, undef */
    "\x3C\x12\x13\x14\x15\x16\x18\x1A\x1B\x31\x34\x35\x39\x3A\x3B\x21\x24\x41\x
43\x49\x4A\x4B\x0F\x0F\x0F\x0F");
  colours[123-33]=0x89; colours[124-33]=0x81; colours[125-33]=0x83;
  colours[126-33]=0xF0; colours[127-33]=0xFF;
 
Note that some of those long strings (over 80 columns) were truncated by the
network, so splice them together.
 
3. File COM.C. Replace void ansic() with:
 
void ansic(int n)
{
  char c;
  if (n<10) {
     c = ((thisuser.sysstatus & sysstatus_color) ? thisuser.colors[n] :
          thisuser.bwcolors[n]);
  } else {
     c= colours[n-33];
  }
  if (c == curatr)
    return;
  setc(c);
  makeansi((thisuser.sysstatus & sysstatus_color) ? thisuser.colors[0] :
        thisuser.bwcolors[0],endofline, 0);
}
 
4. Still in COM.C, find void outchr() and replace the beginning with:
 
  int i, i1;
  if (change_color) {
    change_color = 0;
    if ((c >= '0') && (c <= '9')) {
      ansic(c - '0');
    } else {
      ansic(c);
    }
    return;
  }
  if (c == 3) {    /* existing */
 
Now you can decode all 95 colors, with the above steps, using your standard
text editor to embed heart codes.  The following steps will let you use
^Pwhatever from within the BBS's editors:
 
5. File BBSUTL.C, void inli(), replace case 16 with:
 
          case 16: /* Ctrl-P */
            if (cp<maxlen-1) {
              ch=getkey();
              s[cp++]=3;
              s[cp++]=ch;
              if ( (ch>='0') && (ch<=9)) {
                   ansic(ch-'0');
              } else ansic(ch);
            }
            break;
 
6: File WWIVEDIT\CONFIG\*.DEF
 
COLORS: [#33-#127] Legal Color Range (See CONFIG.DOC for format)
 
(To display the colors available, use ^O (help) in WWIVEDIT, then select the
COLORS screen).
 
That's all!  Just do a MAKE, and then use any ASCII non-control character
after a ^C to make a color.  If you don't like the colors I've chosen,
you can change them in XINIT.C.  I tried to pick ones that looked reasonably
good, and had high contrast, and arrange them in a somewhat logical order.
Remember that the codes are case-sensitive - 'a' and 'A' are different colors.
The ones you'll use most frequently are probably A-G.  Punctuation marks
either involve grey (low ASCII values) or are flashing (high ASCII).  Most
capital letters have black backgrounds or white/yellow/black foregrounds,
while lower-case letters generally have less-attractive, lower-contrast
combinations. "wxyz" are reserved for your personal use - I've assigned white
on black to all of those.
 
 TrooperWare/WWIV:
[ST001- Random sysop-unavailable      ][ST002- One-key user validation     ]
[ST003- Lock xfers during prime time  ][ST004- numlock light when user on  ]
[ST005- UNIX-like //FINGER            ][ST006- 95 colors                   ]
[ST007- Language switching (currently under construction)                  ]
 
[STRCOM - WWIV 4.22 String Compiler                                        ]
 
               Starship Trooper 1@2750/12754
 
 
 
