Tolkien #1 @3456
Thu Aug 30 00:52:43 1990
/*************************************************************************
 *                                                                       *
 *          Module ANSI.C. Additional commands for WWIV 4.07+            *
 *                                                                       *
 *      These functions brought to you courtesy of The Fellowship        *
 *         [314] 644-5777  WWIVNet @3456  1200/2400 baud           *
 *                                                                       *
 *************************************************************************/

#include <sys\stat.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <alloc.h>
#include "vardec.h"
#include "fcns.h"


extern int hangup;
extern userrec thisuser;
extern int echo;

/*
 * You should add the following section to your FCNS.H file if you use
 * these functions:
 *
 *  File: ansi.c 
 *
 * int okfancy();                           
 * int primetime();                         
 * void yesorno();                                     
 * void backprint(char *s, int d1, int d2, int d3);    
 * void shimmer(char *s, int i);                       
 * void slowtype(int color, char *s);                  
 * void spin(char *s, int d1);                         
 * void noise(int startfreq, int endfreq, int step, int paws, int repeats);
 * void padleftwrite(int color, char *s, int endpos);  
 * void goxy(int i, int j);                            
 * void left(int i);                                   
 * void right(int i);                                  
 * void up(int i);                                     
 * void down(int i);                                   
 * void ansiclearline();                               
 *
 * I added this before the BBS.C section, simply because it's alphabetical.
 * It doesn't really matter where you put it, however.
 *
 * You will also need to either add this to your BBS.PRJ file (if you use
 * the Integrated Environment) or add it to your MAKEFILE.MAK file if
 * you use the MAKE utility (which I recommend). Neither of these options
 * are difficult and you should be able to figure it out. Note that because
 * of the commenting, this file is usable as is.
 *
 */

#define USERCOLORS 10
/* 
 * This is how many colors in your userrec struct. Our is 10, though
 * we actually have 100+ color combinations available.
 *
 */

/**/

int okfancy()
/*
 * If an exempt_time (2) is set for the user then okfancy() is true, else
 * it is false. There are other ways to do this but since exempt_time
 * was not used anywhere else in our code, why not?
 *
 */
{
  if (thisuser.exempt & exempt_time)
    return(1);
  else
    return(0);
}
/*
 * Usage: 
 *
 * if (okfancy()) {
 *
 */

/**/

int primetime()
/*
 * This function checks to see if the current time is between the declared
 * prime time, for uploading, downloading, bimodeming, etc. If it is then
 * this function is returned as true (1), else it is false (0);
 *
 */
{
  if ((timer()>17*3600.0) && (timer()<23*3600.0))
    return(1);
  else
    return(0);
}
/*
 * Usage:
 *
 * if (!primetime()) {
 *
 */

/**/

void yesorno()
/*
 * This function prints out "Yes or No" in yellow, pauses, and backspaces.
 * ANSI is not required.
 */
{
  backprint("Yes or No",2,5,400);
}
/*
 * Usage:
 *
 * yesorno();
 *
 */

/**/

void backprint(char *s, int d1, int d2, int d3)
/*
 * This function prints out a string, with a user-specifiable delay between
 * each character, and a user-definable pause after the entire string has
 * been printed, then it backspaces the string. The color is also definable.
 * The parameters are as follows:
 *   
 * char *s : the string to print
 * int d1  : the color of the string
 * int d2  : delay between each character, in milliseconds
 * int d3  : delay between completion of string and backspacing
 *
 * ANSI is not required.
 *
 */
{
  int i1, i2, i3;

  i3 = 0;
  i1 = echo;
  echo = 1;
  i2=strlen(s);
  ansic(d1);
  delay(d2);

  while ((s[i3]) && (!hangup)) {
    outchr(s[i3]);
    delay(d2);
    i3++;
  }

  delay(d3);

  for (i3=0; i3 < i2; i3++) {
    backspace();
    delay(5);
  }

  echo = i1;
}
/*
 * Usage:
 *
 * prt(1,"Your Command: ");
 * backprint("(Y)es, (N)o, or (Q)uit",2,5,400);
 *
 */

/**/

void shimmer(char *s, int i)
/*
 * If the user has "fancy ANSI" on (exempt of 2 is what we used for this)
 * then the string to be printed will shimmer through the number of
 * colors defined in the userrec struct in VARDEC.H. ANSI is checked, and
 * if the user does not have ANSI and does not have "fancy ANSI" enabled
 * then the string is simply printed normally. A <CR> is not done.
 *
 */
{
  int x,y;

  x=strlen(s);
  y=0;

  if ((okansi()) && (okfancy())) {
    do {
      if (y!=i) {
        prt(y,s);
        left(x);
      }
      y++;
    } while(y<USERCOLORS);
  }
  prt(i,s);
  ansic(0);
}
/*
 * Usage:
 *
 * shimmer("This is the sysop!",1);
 * nl();
 *
 */

/**/

void slowtype(int color, char *s)
/*
 * This function will type out a string at random speed, as if there were
 * someone actually typing it. The color is the first parameter, just as
 * in the prt() function. A <CR> is not done.
 *
 * ANSI not required.
 *
 */
{
  int x;

  x=0;
  randomize();
  ansic(color);
  checkhangup();
  while ((s[x]) && (!hangup)) {
    outchr(s[x]);
    delay(random(80)+80);
    x++;
  }
}
/*
 * Usage:
 *
 * nl();
 * slowtype(1,"Downloading again, I see.");
 * nl();
 * slowtype(1,"Well, go ahead then...");
 * nl();
 *
 */

/**/

void spin(char *s, int d1)
/*
 * This function will print out a string, making each character "spin"
 * using the / - \ | sequence. The color is definable and is the
 * second parameter, not the first. If the user does not have ANSI
 * then the string is simply printed normally.
 *
 */
{
  int i1, i3, dly;

  dly  = 30;
  i3   = 0;
  i1   = echo;
  echo = 1;

  if ((okansi()) && (okfancy())) {
    ansic(d1);
    while ((s[i3]) && (!hangup)) {
      delay(dly);
      outstr("/\x1b[1D");
      delay(dly);
      outstr("-\x1b[1D");
      delay(dly);
      outstr("\\\x1b[1D");
      delay(dly);
      outstr("|\x1b[1D");
      delay(dly);
      outchr(s[i3]);
      i3++;
    }
  } else {
    outstr(s);
  }
  echo = i1;
}
/*
 * Usage:
 *
 * spin("This is the sysop, may I help you?",1);
 *
 */

/**/

void noise(int startfreq, int endfreq, int step, int paws, int repeats)
/* 
 * This function takes several parameters. Depending on these parameters,
 * a noise will be made locally. We use this for such things as newuser
 * logon, file access, chain access, logoff, chat, etc.
 *
 * The parameters are as follows:
 *
 * startfreq : The start frequency in hertz.
 * endfreq   : The end frequency in hertz.
 * step      : The number of hertz to step between startfreq and endfreq.
 *             This number should be negative if endfreq is less than
							 startfreq.
 * paws      : The paws in milliseconds between repetitions.
 * repeats   : The number of times to repeat the entire sequence.
 *
 * ANSI not required.
 *
 */
{
  int i,x,z;

  x=0;
  if (startfreq<endfreq) {
    do {
      z=startfreq;
      do {
        sound(z);
        delay(paws);
        z+=step;
      } while ((z <= endfreq) && (!hangup));
      x++;
    } while((x < repeats) && (!hangup));
  } else {
    do {
      z=startfreq;
      do {
        sound(z);
        delay(paws);
        z+=step;
      } while ((z >= endfreq) && (!hangup));
      x++;
    } while((x < repeats) && (!hangup));
  }
  nosound();
}
/*
 * Usage:
 *
 * noise(100,1200,20,5,3);
 * newuser();
 *
 */

/**/

void padleftwrite(int color, char *s, int endpos)
/*
 * This function prints a string and pads it with enough spaces on the
 * right of the string to make the next string print starting right after
 * endpos.  Useful for lining things up in columns, etc. The color is
 * definable and is the first parameter.
 *
 * ANSI not required.
 *
 */
{
  int i;

  prt(color,s);
  for (i=wherex();i<endpos;i++) {
    outstr(" ");
  }
}
/*
 * Usage:
 *
 * padleftwrite(1,"Message #1",41);
 * prt(1,"Message #2");
 * nl();
 *
 */

/**/

void goxy(int i, int j)
/*
 * This function will position the cursor at x:i, y:j coordinates on the
 * screen. If the user has no ANSI then nothing happens.
 *
 */
{
  char s[12];

  if (okansi()) {
    sprintf(s,"\x1b[%d;%dH",j,i);
    outstr(s);
  }
}
/*
 * Usage:
 *
 * goxy(41,13);
 *
 */

/**/

void left(int i)
/*
 * This function will reposition the cursor i spaces to the left, or if the
 * cursor is on the left side of the screen already then it will not move.
 * If the user has no ANSI then nothing happens.
 *
 */
{
  char s[10];

  if (okansi()) {
    sprintf(s,"\x1b[%dD",i);
    outstr(s);
  }
}
/*
 * Usage:
 *
 * left(5);
 *
 */

/**/

void right(int i)
/*
 * This function repositions the cursor i spaces to the right, not moving it 
 * at all if it is already on the righthand side of the screen. If the
 * user hasn't got ANSI then nothing happens.
 *
 */
{
  char s[10];

  if (okansi()) {
    sprintf(s,"\x1b[%dC",i);
    outstr(s);
  }
}
/*
 * Usage:
 *
 * right(4);
 *
 */

/**/

void up(int i)
/*
 * This function repositions the cursor i spaces upwards, not moving it at
 * all if it is already on the upper line of the screen. If the user has no
 * ANSI then nothing happens.
 *
 */
{
  char s[10];

  if (okansi()) {
    sprintf(s,"\x1b[%dA",i);
    outstr(s);
  }
}
/*
 * Usage: 
 *
 * up(12);
 *
 */

/**/

void down(int i)
/*
 * This function repositions the cursor i spaces to the bottom, not moving it
 * at all if it is already on the bottom line of the screen. If the user has
 * no ANSI then nothing happens.
 *
 */
{
  char s[10];

  if (okansi()) {
    sprintf(s,"\x1b[%dB",i);
    outstr(s);
  }
}
/*
 * Usage:
 *
 * down(7);
 *
 */

/**/

void ansiclearline()
/*
 * This function clears the current line, if the user has ANSI, otherwise
 * nothing happens.
 *
 */
{
  if (okansi()) {
    outstr("\x1b[K");
  }
}
/*
 * Usage:
 *
 * for(i=0;i<15;i++) {
 *   up(1);
 *   left(80);
 *   ansiclearline();
 * }
 *
 */

/**/
