``Midnight Tree Bandit`` WWIVlink #1 AT 18411
Fri Dec 10 21:10:59 1993
0R: net33: @4076 (via @4061) [23:46 12/11/93]
0R: net33: @4050 (via @4064) [23:31 12/11/93]
0R: net33: @4064 (via @1040) [16:50 12/11/93]
0R: net33: @1040 (via @2050) [14:36 12/11/93]
0R: net34: @2050 [11:43 12/11/93]
0R: net34: @2050 (via @1040) [04:35 12/11/93]
0R: net33: @1040 (via @1023) [03:06 12/11/93]
0R: net33: @1023 (via @1023) [00:21 12/11/93]
0R: net33: @3454 [23:54 12/10/93]
0R: net33: @13468 (via @314) [23:20 12/10/93]
0R: net33: @314 (via @18407) [22:16 12/10/93]
0R: net33: @18407 (via @18411) [21:42 12/10/93]
0R: net33: @18411 [21:35 12/10/93]
    |
    |   Extract Direct to GFiles Directories mod      (MTBEXTR3.MOD)
    |       Yet another WWIV 4.23 mod from
    |          Vaporware Enterprises mod update
    |          by Midnight Tree Bandit #1@18411.WWIVLink
    |          (Original author disremembered)
----+--------------------------------------------------------------
    |   12/8/93 (not hard but be careful)
    
One of the most useful mods I had in the old 4.11++ Vaporcode was the one for 
extracting messages to different GFiles directories.  What the mod does is 
list the GFiles directories found in GFILES.DAT (as defined in //GFILEEDIT) 
and asks you which one you want to extract the message to.  I'd forgotten it 
was there (shows how much I take it for granted) until Wild Thing asked for it 
on the Mods sub.  I went looking for it in the ModNet collections (I KNEW I'd 
originally gotten it there), but for some odd reason I could not find it 
(maybe it was in Various3, which I lost to a bad floppy).  ANYway, I pulled 
the mod from my old code, looked it over, and found it not hard to put into 
4.21a's 'void extract_out(..)', which did have a few new things in it.  
Anyway, since I could not find the original, and no one else has reposted it 
yet, here is a slight update.  One thing added that was not in the original is 
checking to make sure the directory number added is valid (I have a tendency 
to get ahead of myself when extracting mods, making some end up in the 0 
directory).

12/8/93, version 3 -- 
Things are a little trickier... there are now two different 'extract_out' 
functions.  The original is the same, but there is now a new #define toggle 
(OPT_NEW_EXTRACT) that enables a fancier extraction method.  It's pretty 
nifty, but not quite enough, since it still doesn't allow easy extraction to 
a GFiles dir.  So the mod has two parts: one for those using the old style 
extract, and one for those using the new one.

Here is a sample of how it will work when you run it:

2>> Available G-File Directories <<0

[0]  MTB Stuff
[1]  Mod files

2Save to which gfiles directory?
2<ENTER> to abort: 0

2Save under what filename? 4FOO.BAR    0
Message written to: GFILES\STUFF\FOO.BAR

2Mail {?}: 0


I would like to thank: Wild Thing @12900, for reminding me I needed to put 
this in my own code, Goose for showing me the REALLY stupid error that 
was keeping it from working when I first tried it, and Deanna for beating me 
over the head until I posted about the problem so Goose could tell me what was 
wrong.


Step 0:  BACK UP YOUR SOURCE!  I never remember to back up my hard drive, but 
    I ALWAYS back the source up to floppy before doing any major work.

The usual legend:
    + is add
    - is remove
    ! is change
    [nothing] is unchanged

Two ways to do it.  One with "#define OPT_NEW_EXTRACT" enabled (uncommented) 
and one without.


I.  IF YOU *DO NOT* HAVE OPT_NEW_EXTRACT ENABLED (i.e. it IS commented out)

One step, a few parts.  First, from the top of BBSOVL1.C, search for 'void 
extract_out'.  That's the wrong one.  That's the new one.  So search again, 
and the next one is the we want.

    A.  At the top, we want to do add variables and a lot of code:

  void extract_out(char *b, long len, char *title)
  {
!   char s1[81],s2[81]0,s3[81],ch=26,ch1;  /* added s3[81] */
!   int i,n;                               /* added n */    
+   gfiledirrec r;

    do {
+     prt(2,">> Available G-File Directories <<");nl();nl();
+     for (i=0; i<num_sec; i++) {
+       r=gfilesec[i];
+       sprintf(s1,"[%d] - %s",i,r.name);
+       pl(s1);
+     }
+     nl();
+     prt(2,"Save to which Gfile Directory?" );nl();
+     prt(2,"<Enter> to Abort: ");
+     input(s3,2);
+     if ((s3[0]) && (strcmp(s3,"0")!=0)) {
+       n=atoi(s3);
+       if ((n<=0) || (n>=i)) {
+         npr("^C1%s^C3 is not a valid GFiles directory number.",s3);
+         s3[0]=0;
+       }
+     }
+     if (s3[0]) {
+       n=atoi(s3);
+       r=gfilesec[n];
+       sprintf(s3,"%s",r.filename);nl();
        prt(2,get_string(674));
+       mpl(12);                /* that's not a typo... I want the blue 12 */
        input(s1,50);           /* but leave enough room for a path        */
        if (s1[0]) {
          if (strchr(s1,':') || strchr(s1,'\\'))
            strcpy(s2,s1);
          else
!           sprintf(s2,"%s%s\\%s",syscfg.gfilesdir,s3,s1);  /* added in s3 */
          if (exist(s2)) {

    B.  A few lines down, in the 'switch' statement:

            ch1=onek("QOAN");
            switch(ch1) {
              case 'Q':
+               s3[0]=0;
                s2[0]=0;
                s1[0]=0;

    C.  About 15 lines down, after the 'switch' statement:

        } else
          s2[0]=0;
+     } else
+       s3[0]=0;
!   } while ((!hangup) && (s2[0]!=0) && (s1[0]==0) && (s3[0]!=0));
!   if ((s1[0]) && (s3[0]) && (!hangup)) {      /* ^^^^^^^^^^^^^ added */
      i=sh_open(s2,O_RDWR | O_BINARY | O_CREAT , S_IREAD | S_IWRITE);
      if (i<=0) {
        pl(get_string(933));

    D.  Then another 15 or so down:

        outstr(get_string(677));
        pl(s2);
      }
+   } else {
+     nl();
+     prt(6,"Aborted!");
+     nl();
    }
    farfree(b);
  }

#endif


That's it for this method!  Compile and you should be set.  Make sure the 
#define OPT_NEW_EXTRACT in VARS.H is commented out, else this will not work.  
Note that, like the original, space is made to allow for entry of a full path 
name if you don't want to throw the file into a GFile directory.  I thought it 
reasonable to retain that, though I left the blue entry field ('mpl(12)') the 
length of a file name since that's what it will be the majority of the time.

- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

II.  IF YOU HAVE OPT_NEW_EXTRACT ENABLED (i.e. it IS NOT commented out)

This is the trickier one, because there is already a menu of sorts here.  I 
had to figure out where to put the GFiles directory menu.  I got it.  I will 
assume you skipped the above directions (makes for easier modding if you don't 
have to refer back and forth).  I also decided only one option should allow 
free-form path entry.

Load up BBSOVL1.C and search for 'void extract_out'.  There are two, but stop 
at the first find because the second one is the old-style extract function.

    A.  First, add a couple of variables, change the prompt, and add a little 
        bit to the GFiles option of the menu:
    
  void extract_out(char *b, long len, char *title)
  {
    char s1[81],s2[81],s3[81],ch=26,ch1,ch2;
!   int i,n,done;
+   gfiledirrec r;

    do {
      s1[0]=0; s2[0]=0; s3[0]=0;
      done=1;
      prt(5,get_string(1197));
!     ch1=onek("Q12345?");              /* add "5" */
      switch(ch1) {
        case '1':
           extract_mod(b,len);
           break;
         case '2':
+          prt(2,">> Available G-File Directories <<");nl();nl();
+          for (i=0; i<num_sec; i++) {
+            r=gfilesec[i];
+            sprintf(s1,"[%d] - %s",i,r.name);
+            pl(s1);
+          }
+          nl();
+          prt(2,"Save to which Gfile Directory?" );nl();
+          prt(2,"<Enter> for GFILES\\: ");
+          input(s2,2);
+          if ((s2[0]) && (strcmp(s2,"0")!=0)) {
+            n=atoi(s2);
+            if ((n<=0) || (n>=i)) {
+              npr("^C1%s^C3 is not a valid GFiles directory number.",s2);
+              s2[0]=0;
+              done=0;
+            }
+          }
+          if (s2[0]) {
+            n=atoi(s2);
+            r=gfilesec[n];
+            sprintf(s2,"%s%s\\",syscfg.gfilesdir,r.filename);nl();
+          } else
!            strcpy(s2,syscfg.gfilesdir);
           break;
         case '3':

    B.  Now add the case for extracting to any path:
    
          break;
+       case '5':
+         strcpy(s2,"\\");
+         break;
        case '?':
          printmenu(18);


    C.  Then make these changes, which help determine what sort of path is 
        entered:
        
    if (s2[0]) {
      do {
        prt(2,get_string(674));
+       if (ch1=='5') {
          mpl(50);
          input(s1,50);
+       } else {
+         mpl(12);
+         input(s1,12);
+       }
        if (s1[0]) {
!         if (strchr(s1,':') || strchr(s1,'\\') && (ch1=='5'))
            strcpy(s3,s1);                   /* added ^^^^ */
          else
            sprintf(s3,"%s%s",s2,s1);


And that should be it!  Compile and have fun!  Make sure the 
#define OPT_NEW_EXTRACT has been UNcommented in VARS.C or it won't work.  

Also make a change to your menu 18 in MENUS.MSG adding option 5:

`18=================Extract menu=============================================
1 Available directories0

1 13>2 Extract to Transfer Directory0
1 23>2 Extract to a GFILES Directory0
1 33>2 Extract to DATA Directory0
1 43>2 Extract to TEMP Directory0
1 53>2 Extract to a any path0

1 Q3>2uit Extract0

Note that the default path if only a file name is specified for option 5 is 
the root directory.

= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
NOTES:
In the case of both forms of the mod, keep in mind that the GFiles listed are 
those found in GFILES.DAT, so you must add any Gfiles directory to which you 
want to extract in the //GFILEEDIT.  Otherwise you won't see it here.

Both of these methods have been well-tested here on the MTB, so I will 
guarantee that as long as you follow directions, this will work.

I do not clainm this mod is all-original.  A substantial part is from that 
forgotten old extract mod.  The only claim I can make is that there is some of 
my own code here and that I figured out where to put it.

The All New Vaporware CYA Disclaimer:
    This mod is copyright 1992, 1993 by Wayne Heyward, aka Midnight Tree 
    Bandit, and is distributed as freeware.  Permission is granted to 
    distribute and post this mod on BBS systems and online services, provided 
    no alterations are made (removal of message headers/taglines allowed).  
    May contain some parts of WWIV source code, which is copyright 1988-1993 
    by Wayne Bell and licensed only to registered users of WWIV.  Use of WWIV 
    source without registration constitutes a license violation and could lead 
    to legal prosecution and certain doom.

    Shareware distributors and CD-ROM publishers may not distribute without 
    express written permission of the Author or WWIV Software Services.

[I highly recommend you add this to all your mods.  It keeps us safe, and it 
makes sure others will not profit from our work.]

Need help?  You can find me here:
    WWIVLink: #1 @18411 (The Many Titled Board)
    IceNET:   #1 @8411  ( "   "     "      "  )
    WWIVnet:  #2 @8408  (The Vaporboard)
    GEnie:    TREE.BANDIT (from time to time)
    Internet: tree.bandit@genie.geis.com)
