File name      : M&M001.MOD
Written by     : Snorkel 1@3459 WWIVnet
Written for    : WWIV v4.22
Date written   : 2-14-93
Files affected : BBS.C
                 BBSUTL1.C
                 FCNS.H
Mod function   : Restricts users from doing file transfers during specified 
                 hours of the day.


With this mod, you can restrict the times someone can do file transfers.  It
is currently set to not allow file transfers (uploads, downloads and file
extractions) between the hours of 6pm to 10pm.  If you want to change those
hours, simply change the "1800" and "2200" in the "if" line of the function.
The times are expressed in "military time" and can be changed very easily
(ie - 1934 = 7:34pm).  It also allows someone with FULL cosysop status to be
exempt from the restriction (that can be changed to sysop by changing "cs()"
to "so()").

Rather than use this function to entirely lock users out of the transfer area,
I suggest that you use it to "disable" certain functions WITHIN the transfer
area.  This way, users can still look through the files, without having to
call back.  Step 2 shows how I suggest locking users out of file transfer
functions INDIVIDUALLY.


=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 1


In BBSUTL1.C, add the following function anywhere you want:


int no_transfer()                 /* Begin block copy */
{
/* Insert Step 4 here if you want to allow file transfers       */
/* during these times on SPECIFIC days (WWIV 4.22 or later ONLY */
  if ((timer()>1800*36.0) && (timer()<2200*36.0) && (!(cs()))) {
    nl();
    pl("File transfers not allowed during \"prime time\".");
    nl();
    sysoplog("<***> Tried to transfer files during prime time <***>");
    return(1);
  } else
    return(0);
}                                  /* End block copy */

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 2

In BBS.C, add the following code where indicated to "void dlmainmenu()"


      case 'D':                      /* existing code */
        if(!no_transfer()) {         /* add */
          helpl=20;
          download();
        }                            /* add */
        break;


      case 'E':                      /* existing code */
        if(!no_transfer()) {         /* add */
          helpl=29;
          temp_extract();
        }                            /* add */
        break;


      case 'U':                      /* existing code */
        if(!no_transfer()) {         /* add */
          helpl=17;
          if ((thisuser.restrict & (restrict_validate | restrict_upload)) || (syscfg.sysconfig & sysconfig_all_sysop)) {
            if (syscfg.newuploads<num_dirs)
              upload((int) syscfg.newuploads);
            else
              upload(0);
          } else
            upload(udir[curdir].subnum);
        }                            /* add */
        break;


      case 'Z':                      /* existing code */
        if(!no_transfer()) {         /* add */
          nl();
          helpl=17;
          upload(0);
        }                            /* add */
        break;


=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 3

In FCNS.H, add the following code where indicated:


/* File: bbsutl1.c */                 /* existing line */

int no_transfer();                    /* add */
int ok_local();
int finduser1(char *sx);


=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 4 (WWIV v4.22 or later)

Add this code where indicated in the new function if you want to allow file 
transfers during "prime time" on certain days.  The day(s) of the week you 
choose are represented by the numbers 0-6 (0 being Sunday, and 6 being 
Saturday).  In this example, the days are Saturday and Sunday, but you can 
change the numbers, or add or subtract any day you wish.


  unsigned char thisday;                       /* ADDED */
                                               /* ADDED */
  thisday=dow();                               /* ADDED */
  if((thisday==0) || (thisday==6))             /* ADDED */
    return(0);                                 /* ADDED */

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 5

You must now recompile the entire BBS since you made an addition to FCNS.H.

If you have any questions about this mod, feel free to write me at 1@3459 
WWIVnet.
