Ŀ
 Mod Name      : JAFO12.MOD               Mod Author: JAFO 1@1     TerraNET 
 Difficulty    : ۱                                1@8857  IceNET   
 WWIV Version  : 4.22                                      1@8861  WWIVnet  
 Mod Date      : 02/19/93                                  1@18868 WWIVLink 
 Files Affected: BBS.C, MISCCMD.C                                           
 Description   : WWIV Time Bank                                             


[ Description ]

This WWIV Time Bank modification will give your users a convenient way of
saving their time online for use at a later date.  It does not have any fancy
gambling.  It simply lets users withdraw and deposit time.  The sysop can set
limits on how much time can be deposited into the Time Bank as well as how
much total time a user can have online.

[ Legend ]

  =  Existing line - Do not change
  +  Add this line

[ Step 1 ]

Please back up your source code.  Even the best programmers make mistakes.

[ Step 2 ]

In BBS.C, add the following "case" statement in "void mainmenu".

=      case '.':
=        helpl=26;
=        do_chains();
=        break;
+      case '$':
+        timebank();
+        break;
=      case 'A':
=        helpl=19;
=        write_automessage();
=        break;

[ Step 3 ]

Add the following block of code to the end of MISCCMD.C.  You may change the
values shown on the first two lines to whatever you like.  If you would rather
not set limits, I suggest setting each to 999.

#define MAX_CALL 120    /* Max time online is set to 2 hours */
#define MAX_BANK 60     /* Max bank time is set to 1 hour */

void timebank(void)
{
  char s[80];
  double tle;
  int i,tli;
  char ch=0;

  tle=nsl();
  while ((ch!='Q') && (!hangup)) {
    outchr(12);
    sprintf(s,"%s Time Bank",syscfg.systemname);
    if (strlen(s)<43) {
      for (i=0; i<21-strlen(s)/2; i++)
        outchr(32);
    }
    prt(1,s);
    nln(2);
    sprintf(s,"Greetings, %s",thisuser.name);
    for (i=0; i<21-strlen(s)/2; i++)
      outchr(32);
    prt(5,s);
    nln(2);
    tli=(int)(tle/60);
    npr("You have %3d min(s) this call.     Max: %3d\r\n",tli,MAX_CALL);
    npr("You have %3d min(s) in the bank.   Max: %3d\r\n",thisuser.banktime,
        MAX_BANK);
    nl();
    prt(2,"1. Deposit Time"); nl();
    prt(2,"2. Withdraw Time"); nl();
    prt(2,"Q. Quit to BBS");
    nln(2);
    prt(4,"Enter Your Selection?");
    ansic(0);
    outchr(32);
    ansic(6);
    ch=onek("Q12");
    switch (ch) {
      case '1':
        if (thisuser.banktime<MAX_BANK) {
          i=(MAX_BANK-thisuser.banktime>tli) ? tli :
             MAX_BANK-thisuser.banktime;
          ansic(2);
          npr("You can deposit up to %d more minute(s).\r\n",i);
          prt(1,"How many minutes do you wish to deposit? ");
          input(s,3);
          if (s[0]) {
            i=atoi(s);
            if ((i<=0) || (i>tli)) {
              prt(2,"Can't deposit that amount.");
              nln(2);
              pausescr();
            } else {
              if (i+thisuser.banktime>MAX_BANK) {
                ansic(5);
                npr("You can have a max of %d minutes in the bank.",
                    MAX_BANK);
                nln(2);
                pausescr();
              } else {
                thisuser.extratime-=i*60;
                thisuser.banktime+=i;
                sprintf(s,"%d minutes deposited into the Time Bank.",i);
                sysoplog(s);
                nl();
                pausescr();
              }
            }
          } else {
            prt(2,"Can't deposit that amount.");
            nln(2);
            pausescr();
          }
        } else {
          prt(2,"Can't deposit, your account is already full!");
          nln(2);
          pausescr();
        }
        break;
      case '2':
        if (thisuser.banktime) {
          if (!(tli>=MAX_CALL)) {
            sprintf(s,"You have %d minute(s) in your account.",
                    thisuser.banktime);
            prt(2,s);
            nl();
            i=(thisuser.banktime+tli>MAX_CALL) ? MAX_CALL-tli :
               thisuser.banktime;
            ansic(5);
            npr("You can withdraw up to %d minute(s).\r\n",i);
            prt(1,"How many minutes do you wish to withdraw? ");
            input(s,3);
            if (s[0]) {
              i=atoi(s);
              tli=(int)(tle/60);
              if ((i<=0) || (i>thisuser.banktime) || (i+tli>MAX_CALL)) {
                prt(2,"Can't withdraw that amount.");
                nln(2);
                pausescr();
              } else {
                thisuser.extratime+=i*60;
                thisuser.banktime-=i;
                sprintf(s,"%d minutes withdrew from the Time Bank.",i);
                sysoplog(s);
                nl();
                pausescr();
              }
            } else {
              prt(2,"Can't withdraw that amount.");
              nln(2);
              pausescr();
            }
          } else {
            prt(2,"Too much online time, can't withdraw!");
            nln(2);
            pausescr();
          }
        } else {
          prt(2,"Can't withdraw, no time in account.");
          nln(2);
          pausescr();
        }
        break;
      case 'Q':
        break;
    }
    tle=nsl();
  }
}

[ Step 4 ]

Compile your source.

[ Disclaimer ]

Don't complain to me if your board gets fried, your hard disk goes nuts, or
something terrible happens.  The code in this mod should be harmless, but I
can't guarantee it will work for you.  It works on my board.

JAFO 1@1     TerraNET
     1@8857  IceNET
     1@8861  WWIVnet
     1@18868 WWIVLink

