Ŀ
 Mod Name  : IGGY001.MOD                 Mod Author:                    
 Difficulty:                   Date: Dec 12, 1992                 
 Files     : RUMOUR.C, VARDEC.H, BBS.C, FCNS.H, DEFAULTS.C                  
 WWIV Version: 4.22                                                         
 Description: Makes a random quote from a user at main and transfers        
 menu.  Configurable to see or not if users don't wish to have them.        



[Step 1]
Make a file called RUMOUR.C and include this in it:    
/*Start Block Here */
#include "vardec.h"
#include "fcns.h"
#include <io.h>
#include <sys\stat.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <stdio.h>
#include "vars.h"



#define MAXRUMOURS 3000
#define FORCEIT 1
#define OKDEL 0
#define restrict_no_rumour 0x0800

int rumour_file;

void fileerror(char *message)
{
  prt(2,"An error has occurred. Please report this to the sysop!");
  nl();
  sysoplog(message);
}

int read_rumour(unsigned int rumnum, rumourrec *rumour)
{
  long pos;
  int i=0;

  pos=((long)sizeof(rumourrec))*((long)rumnum);
  if (filelength(rumour_file)<=pos) {
     rumour->user=0;
     return(-1);
     }
  lseek(rumour_file,pos,SEEK_SET);
  i=read(rumour_file,(void *)rumour,sizeof(rumourrec));
  if (i==-1) fileerror("@ read_rumour: Can't read RUMOURS.DAT");
  return(i);
}

int write_rumour(unsigned int rumnum, rumourrec *rumour)
{
  long pos;
  int i=0;
  pos=((long)sizeof(rumourrec)*(long)rumnum);
  lseek(rumour_file,pos,SEEK_SET);
  i=write(rumour_file,(void *)rumour,sizeof(rumourrec));
  if (i==-1) fileerror("@ write_rumour: Can't write RUMOURS.DAT");
  return(i);
}

void del_rumour(unsigned int rumnum,int forceit)
{
  rumourrec delrumour;
  unsigned int j,i;
  int e,done;

  done=0;
  j=filelength(rumour_file)/sizeof(rumourrec);
  if ((rumnum-1)>j) {
     pl("Bad rumour number error");
     return;
  }

  if (forceit)
     do {
        e=read_rumour((rumnum-1),&delrumour);
         if (e==-1) {
           fileerror("@ Delrumour: Error deleting rumour #1");
           return;
        }
        if (delrumour.perm) {
           rumnum++;
           if (rumnum>j) {
              rumnum=done=1;
              break;
           }
        } else done=1;
     } while((!done) && (!hangup));
  else {
    e=read_rumour((rumnum-1),&delrumour);
    if (e==-1) {
       fileerror("@ Delrumour: Error deleting rumour #2");
       return;
    }
    if ((!cs()) && (delrumour.perm)) {
       pl("Permanent rumour. Sysop must delete!");
       return;
    }
    pl("Rumour deleted.");
  }
   if (rumnum<j) for (i=(rumnum-1);i<(j-1);i++) {
     e=read_rumour(i+1,&delrumour);
     if (e==-1) {
       fileerror("@ Delrumour: Error deleting rumour #3");
        return;
     }
     write_rumour(i,&delrumour);
  }
  chsize(rumour_file,((filelength(rumour_file))-(sizeof(rumourrec))));
}

void rumdel(int un)
{
    rumourrec r;
    long pos;
    char s[81];
    int i1,i,j;

    sprintf(s,"%sRUMOURS.DAT",syscfg.datadir);
    rumour_file=open(s,O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
    if (rumour_file==-1) {
       pl("Error #1");
       getkey();
       close(rumour_file);
       return;
    }
    j=filelength(rumour_file)/sizeof(rumourrec);
    for (i=(j-1); i>=0; i--) {
        i1=read_rumour(i,&r);
        if (i1==-1) {
           pl("Error #2");
           getkey();
           break;
        }
        if (un==r.user) {
           del_rumour(i,FORCEIT);
        }
    }
    close(rumour_file);
}

void addrumour(void)
{
  rumourrec rumours,findrumour;
  unsigned int rumnum, test;
  unsigned short un;
  int i;
  long pos,len;
  char s[160],ro[81];

  do {
     test=1;
     prt(1,"Who is this rumour about?");
     nl();
    npr(":");
    inputl(s,30);
    rumours.userabout=0;
    if (s[0]==0) {
       pl("Therefore, no aliases are allowed in this rumour!!");
       break;
    }
    rumours.userabout=finduser1(s);
    if (rumours.userabout==0) {
       pl("Unknown user.");
       test=0;
    }
  } while ((!test) && (!hangup));
  prt(1,"Enter rumour (MAX 79 Characters):");
  nl();
  npr(":");
  ro[0]=0;
  inli(rumours.rumour,ro,79,1);
  if ((rumours.rumour[0]==0) || (rumours.rumour[0]==32) || (rumours.rumour[0]=='.')) {
    pl("Aborted.");
    return;
  }
  rumours.user=usernum;
  rumours.perm=0;
  if (cs()) {
     prt(1,"Permanent rumour? [Y/N] ");
     if (yn()) rumours.perm=1;
  }
  prt(7,"Saving rumour...");
  sprintf(s,"%sRUMOURS.DAT",syscfg.datadir);
  rumour_file=open(s,O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
  if (rumour_file==-1) {
     fileerror("@ Addrumour: Can't open RUMOURS.DAT");
     close(rumour_file);
     return;
     }
  len=filelength(rumour_file);
  if ((len/sizeof(rumourrec))>=MAXRUMOURS) {
     rumnum=MAXRUMOURS-1;
     del_rumour(1,FORCEIT);
  }
  else
     rumnum=(len/sizeof(rumourrec));
  write_rumour(rumnum,&rumours);
  close(rumour_file);
  prt(3,"Done.");
  nl();
  sprintf(s,"Rumour: %s",rumours.rumour);
  sysoplog(s);
}


void listrumours(void)
{
  userrec u;
  rumourrec rumours;
  unsigned int rumnum,num_rumours;
  int i,author=0,numbers=0,abort,next;
  char s[90];

  sprintf(s,"%sRUMOURS.DAT",syscfg.datadir);
  rumour_file=open(s,O_RDWR | O_BINARY);
  if (rumour_file==-1) {
    fileerror("@ Listrumour:Can't open RUMOURS.DAT");
     return;
     }
  num_rumours=filelength(rumour_file)/sizeof(rumourrec);
  if (num_rumours==0) {
     prt(6,"No rumours on file. ADD ONE!");
     nl();
     close(rumour_file);
     return;
     }
  prt(1,"Display with numbers: ");
  numbers=yn();
  if ((cs()) && (numbers)) {
     prt(1,"Display authors: ");
     author=yn();
     nl();
     }
  outchr(12);
  sprintf(s,"Number of rumours: %d",num_rumours);
  pl(s);
  for (i=0;i<num_rumours;i++) {
      read_rumour(i,&rumours);
      if (numbers)
        if (author) {
            read_user(rumours.user,&u);
            sprintf(s,"%d) %s ",(i+1),nam(&u,rumours.user));
            strncat(s,rumours.rumour,45);
            abort=next=0;
        ansic(1);
            osan(s,&abort,&next);
            nl();
            if (abort) {
               close(rumour_file);
               return;
            }
            if (next) break;
         } else {
           sprintf(s,"%d) %s",(i+1),rumours.rumour);
           if (strlen(s)>76) s[76]=0;
       ansic(1);
           abort=next=0;
           osan(s,&abort,&next);
           nl();
           if (abort) {
              close(rumour_file);
              return;
           }
           if (next) break;
         }
       else {
           abort=next=0;
       ansic(1);
           osan(rumours.rumour,&abort,&next);
           nl();
           if (abort) {
              close(rumour_file);
              return;
           }
           if (next) break;
      }
  }
  close(rumour_file);
}


void rumour(void)
{
  int done,e;
  unsigned int i;
  char ch,s[80];
  rumourrec r;
  unsigned short un;

  done=0;
  do {
    topscreen();
    if ((sysstatus_expert & thisuser.sysstatus)==0) printmenu(20);
    nl();
    prt(1,"[Rumours]: ");
    ch=onek("QLASD?R");
    nl();
    sprintf(s,"%c\0",ch);
    sysopchar(s);
    switch (ch) {
      case 'L':listrumours();
               break;

      case 'A':if (thisuser.restrict & restrict_no_rumour) {
         pl("You can't add rumours.");
                 break;
      }
               addrumour();
      break;
      case 'D':if (thisuser.restrict & restrict_no_rumour) {
                  pl("You can't delete rumours.");
                  break;
               }
               prt(2,"Delete which?: ");
               input(s,2);
               i=atoi(s);
               if ((i<1) || (i>MAXRUMOURS)) {
                  pl("No such rumour!");
                  break;
               }
               sprintf(s,"%sRUMOURS.DAT",syscfg.datadir);
               rumour_file=open(s,O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
               if (rumour_file==-1) {
                  fileerror("@ Delete rumour:Can't open RUMOURS.DAT");
                  break;
               }
               e=read_rumour((i-1),&r);
               if (e==-1) {
                  close(rumour_file);
                  break;
               }
               if ((usernum!=r.user) && (usernum!=r.userabout) && (!cs())) {
      pl("You can only delete rumours you added or that are about you!");
                     close(rumour_file);
                     break;
               }
               del_rumour(i,OKDEL);
               close(rumour_file);
               break;
      case 'R':if (!cs()) break;
               nl();
               prt(3,"Enter user's alias or number.");
               nl();
               outstr(":");
               input(s,30);
               un=0;
               un=finduser1(s);
               if (un==0) {
                  pl("Unknown user.");
                  break;
               }
               rumdel(un);
               break;
            case '?':printmenu(20);
               break;
      case 'Q':done=1;
    }
  } while ((!done) && (!hangup));
  topscreen();
}

/*  End Block Copy Here */





[Step 2]

Now in VARDEC.H add this structure right after the structure "typedef enum {"
and before "/* userrec.inact */"

 typedef struct {
         unsigned short user;
         unsigned short userabout;
         char perm;
         char  rumour[80];
 } rumourrec;

Ok Now search for this line

#define restrict_string "LCMA*PEVKNUR    "

/* userrec.sysstatus */
#define sysstatus_ansi 0x0001
#define sysstatus_color 0x0002
#define sysstatus_music 0x0004
#define sysstatus_pause_on_page 0x0008
#define sysstatus_expert 0x0010
#define sysstatus_smw 0x0020
#define sysstatus_full_screen 0x0040
#define sysstatus_nscan_file_system 0x0080
#define sysstatus_funky_colors 0x0100
#define sysstatus_clr_scrn 0x0200
#define sysstatus_rumour 0x0400             /* ADD */

Save VARDEC.H

[Step 3]

Ok add this void right before void mainmenu in BBS.C


void random_rumour(void)
{
  char s[80];
  unsigned int num_rumours,i;
  rumourrec rumours;
  int rumour_file;

  sprintf(s,"%sRUMOURS.DAT",syscfg.datadir);
  rumour_file=open(s,O_RDWR | O_BINARY);
  if (rumour_file==-1) {
     prt(6,"No rumours on file. ADD ONE!");
     nl();
     return;
     }
  num_rumours=filelength(rumour_file)/sizeof(rumourrec);
  if (num_rumours==0) {
     prt(6,"No rumours on file. ADD ONE!");
     nl();
     close(rumour_file);
     return;
  }
  srand(random(timer()/3));
  i=random(num_rumours);
  lseek(rumour_file,(long)(sizeof(rumourrec)*i),SEEK_SET);
  i=read(rumour_file,&rumours,sizeof(rumourrec));
  close(rumour_file);
  if (i>0) prt(5,rumours.rumour);
  nl();
}

Ok now go to void mainmenu(void)


  nl();
  if (thisuser.sysstatus & sysstatus_rumour) {       /* ADD */
  random_rumour();                                   /* ADD */
 }                                                   /* ADD */
  nl();
  tleft(1);
  npr("T - %s\r\n",ctim(nsl()));
  s1[0]=0;
  if (usub[cursub].subnum==-1) {
    cursub=0;
    if (usub[cursub].subnum==-1) {
      strcpy(s1,"[] No Subs Available :");
    }
  }

now add the following case function at the end of the rest:

case '@':
rumour();
break;

Ok now the same in void dlmainmenu(void);


  nl();
  if (thisuser.sysstatus & sysstatus_rumour) {     /* ADD */
  random_rumour();                                 /* ADD */
 }                                                 /* ADD */
  nl();
  tleft(1);
  npr("T - %s\r\n",ctim(nsl()));
  s1[0]=0;
  if (udir[curdir].subnum==-1) {
    curdir=0;
    if (udir[curdir].subnum=-1) {
      strcpy(s1,"() No Dirs Available :");
      curdloads=0;
      return;
    }
  }

Save BBS.C

[Step 3]
Load up DEFAULTS.C

  }
  outstr(get_string(400)); npr("%d\r\n",thisuser.optional_val);
  npr("C. Show Rumour's     : %s\r\n",                        /* ADD */
     (thisuser.sysstatus & sysstatus_rumour)?"Yes":"No");     /* ADD */
  outstr(get_string(401));
  if (thisuser.wwiv_regnum)
    npr("%ld\r\n",thisuser.wwiv_regnum);
  else                                    
    pl(get_string(402));    
  pl(get_string(403));
  nl();
  nl();
}
Now go down to void defaults

    if (okansi()) {
      prt(2,"Defaults: (1-9,A-C,?,Q) : ");  /* Change A-B to A-C*/
      ch=onek("Q?1234567089CABW");         /* Add C  /*
    } else {
      prt(2,"Defaults: (1-7,B,C,?,Q) : "); /* Change from B,? to B,C,? /*
      ch=onek("Q?1234567BCW");              /* Add C */
    }
    switch(ch) {
      case 'C':                                         /* ADD */
        if (thisuser.sysstatus & sysstatus_rumour)      /* ADD */
          thisuser.sysstatus ^= sysstatus_rumour;       /* ADD */
        nl();                                           /* ADD */
        prt(1,"Show Rumours On Prompt: ");              /* ADD */
        if (yn())                                       /* ADD */
          thisuser.sysstatus |= sysstatus_rumour;       /* ADD */
        break;                                          /* ADD */
      case 'Q':
Ok Save DEFAULTS.C



[Step 4]
Ok now load up FCNS.H

Add this block to the end as shown.

* File: rumour.c */

void fileerror(char *message);
int read_rumour(unsigned int rumnum, rumourrec *rumour);
int write_rumour(unsigned int rumnum, rumourrec *rumour);
void del_rumour(unsigned int rumnum,int forceit);
void rumdel(int un);
void addrumour(void);
void listrumours(void);
void rumour(void);



#endif


[Step 5]
Ok now add the following block according to which makefile you are using..

MAKEFILE.BCC


BBS_O_OVL = \
        $(OBJ)\batch.obj $(OBJ)\chnedit.obj $(OBJ)\defaults.obj\
        $(OBJ)\diredit.obj $(OBJ)\gfiles.obj $(OBJ)\gfledit.obj\
        $(OBJ)\lilo.obj $(OBJ)\misccmd.obj $(OBJ)\multmail.obj\
        $(OBJ)\newuser.obj $(OBJ)\srrcv.obj $(OBJ)\srsend.obj\
        $(OBJ)\subedit.obj $(OBJ)\subreq.obj $(OBJ)\sysopf.obj\
        $(OBJ)\tedit.obj $(OBJ)\uedit.obj $(OBJ)\voteedit.obj\
        $(OBJ)\xferovl.obj $(OBJ)\xfertmp.obj $(OBJ)\xinit.obj\ # add '\'
        $(OBJ)\rumour.obj                                       # add


#Ok now down more

xferovl.obj : xferovl.c
  $(TCC_OVL)
xfertmp.obj : xfertmp.c
  $(TCC_OVL)
xinit.obj   : xinit.c
  $(TCC_OVL)
rumour.obj  : rumour.c # add me
  $(TCC_OVL)           # add me

OK Now For MAKEFILE.TCC

        $(OBJ)defaults.obj $(OBJ)misccmd.obj $(OBJ)xinit.obj\
        $(OBJ)xfertmp.obj $(OBJ)batch.obj $(OBJ)srrcv.obj\
        $(OBJ)srsend.obj $(OBJ)lilo.obj $(OBJ)subreq.obj\  # add '\'
        $(OBJ)rumour.obj

Ok now Down a little


  $(TCC_OVL)
$(OBJ)srsend.obj  : srsend.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)lilo.obj    : lilo.c     vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)rumour.obj  : rumour.c   vars.h vardec.h net.h  # add me
  $(TCC_OVL)                                          # add me


[Step 6]
Block this inot a file called menu20.ans and menu20.msg or add it into the
menu files

-= Rumour Commands =-

'A' Add Rumour
'L' List Rumours
'D' Delete Rumour
'Q' Quit to Main Menu


[Step 7]

Recompile and send me all of your hate mail if it doesn't work.

Ok, that's all, give credit for this mod to, Dream Child, who's on WWIVnet 
somewhere, I'm sure. And also to Miracle Man, who originally took the bugs 
out of the original SATAN13.MOD, but never edited the textfile, so I did, 
but he was the one to tell me all the fixes for it, except a small bug in the
DEFAULTS.C modification, which I fixed for 4.22. Kay, that should be all, any
more bugs found is probably a type-o, so email me, at #3 @4110 on AlterNETive,
or #3 @4114 on TeenNet. You're all welcome for this fix!!


                                                  

