Tue Feb 09 03:04:55 1993

Filename       : GIFINFO.MOD
Re-written for : WWIV 4.22
Re-written by  : Snorkel 1@3459 WWIVnet (original author unknown)
Date re-written: 2-9-93
Files affected : BATCH.C
                 XFER.C
                 XFEROVL.C
                 FCNS.H
Function       : Places the size of the .GIF file at the beginning of the file
                 description.  Works either with the command \\UPLOAD or when
                 a remote user uploads a file with a .GIF extension.  Also
                 tells the sysop if the file is not a .GIF (in the sysop log).

I have changed the code in this mod to make it more efficient, and also to
look for both the old .GIF format (GIF87a) and the new format (GIF89a).
Additionally, I have added a bit of code to the mod (at the end) so that the
file description is not longer than the comment field when the .GIF dimensions
are added to the file description.  I would like to give the original author
credit for this mod, since he did the hard part of actually writing the
routines which read the size of the .GIF and append the description onto it.
However, in the process of converting this mod over several times, I have lost
the original author's name.

This is a simple mod that automatically adds, to the file description, the
dimensions of any .GIF file that is uploaded to your board, remotely or
locally.  The dimensions will be in the format of WWWxHHHxCCC, where WWW is
the width, HHH is the height, and CCC is the number of colors used.  The
output should look like this:


WORF    .GIF:   21k :320x200x16  ... Lt. Worf of the USS Enterprise.
ALYSA1  .GIF:   59k :320x200x256 ... Lovely brunette with VERY brown eyes.
BRNCORAL.GIF:  173k :640x480x256 ... Brain coral, St. Thomas, U.S.V.I.
SCHIFF05.GIF:   83k :800x600x256 ... Claudia Schiffer in a white swim suit.
EHZS0034.GIF:  659k :1024x768x256 .. Great scan of colorful autumn leaves.


There is 58 characters total for the description.  With the .GIF size added to
the beginning, the amount of room left for the input of a description changes
to 42 characters.

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 1

FCNS.H

Add the following code where indicated.

/* File: sr.c */                               /* search for */

int getbytes(FILE *dev);                         /* add */
void check_gif(char *fn, char *descript);        /* add */
char *stripfn(char *fn);
void stripfn1(char *fn);
void calc_CRC(unsigned char b);

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 2

BATCH.C 

In function "void uploaded(char *fn, long cps)" add the following code:

                if (d1>=0) {                       /* search for */
                  u.numbytes = filelength(d1);
                  close(d1);
                                                    /* add */
                  if (strstr(u.filename,".GIF"))    /* add */
                    check_gif(s2,u.description);    /* add */

                  ++thisuser.uploaded;

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 3

XFER.C

In function "void upload(int dn)" add or change as noted below:

  directoryrec d;                          /* search for */
  uploadsrec u,u1;
  int i,i1,i2,i3,i4,ok,xfer,f,w;            /* add "w" */


Now search for the following line, and add or change the code as indicated
below:

      pl(get_string(779));                      /* search for */
      if(strstr(u.filename,".GIF"))                 /* add */
        w=42;                                       /* add */
      else                                          /* add */
        w=58;                                       /* add */
      outstr(": ");                       /* existing code */
      inputl(u.description,w);      /* CHANGED the "58" to "w"*/
      nl();


       if (ok) {
         if (ok==1) {
         l=filelength(f);                  /* search for */
         u.numbytes=l;
         close(f);                        /* existing code */
         if (strstr(u.filename,".GIF"))        /* add */
           check_gif(s1,u.description);        /* add */
         ++thisuser.uploaded;             /* existing code */
         thisuser.uk += ((l+1023)/1024);

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 4

XFEROVL.C

In function "int upload_file(char *fn, int dn, char *desc)" add the following:

  directoryrec d;                      /* search for */
  uploadsrec u,u1;
  int i,i1,i2,ok,f,w;                 /* "w" added M&M */

Further down in the code, change as follows:

     u.description[58]=0;                /* search for */
     pl(u.description);                 /* existing code */
   } else {                      /* CHANGED line */
     if(strstr(u.filename,".GIF"))         /* add */
       w=42;                               /* add */
     else                                  /* add */
       w=58;                               /* add */
     inputl(u.description,w);              /* add */
   }                                       /* add */
   if (u.description[0]==0)             /* existing code */
     return(0);                         /* existing code */
   ++thisuser.uploaded;                 /* existing code */
   if (strstr(u.filename,".GIF"))          /* add */
     check_gif(ff,u.description);          /* add */
   thisuser.uk += ((l+1023)/1024);      /* existing code */

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 5

SR.C

Block copy the following two functions to the end of SR.C


int getbytes(FILE *dev)
{
    int byte1;
    int byte2;
    int result;

    /* read bytes and shift over */

    byte1 = getc(dev);
    byte2 = getc(dev);

    result = (byte2 << 8) | byte1;

    return result;

}

void check_gif(char *fn, char *descript)
{
  int byte1, bits_per_pix,colors,i;
  unsigned int width;
  unsigned int height;
  FILE *in;
  char s[81];

  in = fopen (fn, "rb");
  for (i = 0; (i < 6); i++) s[i] = getc(in);
  s[6] = '\0';
  width = getbytes(in);
  height = getbytes(in);
  byte1 = getc(in);
  fclose(in);
  if((strcmp(s,"GIF87a")) && (strcmp(s,"GIF89a"))) {
    sprintf(s,"%s -- NOT a GIF file.",fn);
    sysoplog(s);
    return;
  }
  bits_per_pix = byte1 & 0x07;
  bits_per_pix++;
  colors = 1 << bits_per_pix;
  if((width<1000) && (height<1000))
    sprintf(s,"%dx%dx%-3d ... %s",width,height,colors,descript);
  else {
    if((width>999) && (height>999))
      sprintf(s,"%dx%dx%-3d . %s",width,height,colors,descript);
    if(((width>999) && (height<1000)) || ((width<1000) && (height>999)))
      sprintf(s,"%dx%dx%-3d .. %s",width,height,colors,descript);
  }
  strcpy(descript,s);
}

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

And that's all! Just recompile your BBS and you are finished.

Note: You can put the two new functions anywhere, but because you put the two
      new functions in FCNS.H, you must recompile the entire BBS.


