Mon Jul 05 18:14:08 1993
Ŀ
 Mod Name: FILGRE01  (Filo05 meets Greeny02)      Authors: Filo and Greeny 
 Difficulty: Easy - Medium (mostly block read)    Date: June 21, 1993      
 WWIV Version: Updated for use with WWIV 4.22!                             
 Description:  Allows you to organize your chains by groups and have       
 neater looking menus. Also adds a timelock to your doors, and a bar       
 graph showing comparative usage for each on-liner.                        


   I liked the combination of these two mods togeather so much, that I decided
to put them togeather in one mod for those novice modders out there like me. I
did nothing special, and all credit goes to Filo and Greeny for writing such
great mods, and for allowing me to combine the two togeather.

NOTES FROM THE AUTHORS:

FROM FILO ABOUT FILO05:

Nasti Habitz deserves credit for thinking of this mod and for writing much of
the code which is used here.  He developed the mod, uploaded it to my board
and some 6 months later I tried installing it in 4.20.  Disaster!  Not only
does much of the mod go in new places, but also the mod did not work as
written.  UT Prof and I spent a whole afternoon trying to change parameters
and get it to work, but to no avail.  After much trial and error effort,
the mod now works and is in use at The Dragon's Den.

FROM GREENY ABOUT GREENY02:

This mod evolved out of a mutant crossbreeding between somebody's onliner
timelock mod, and the mod that puts a purple box around transfers.  Now it's
a boxed, color-coded timelock mod with bar graphs of comparative usage for
each onliner.  Tacky, eh?  What else are onliners for?

You set a timelock for each onliner.  I.E. this onliner can only be played
from 11:00 pm to 3:00 am.  This is done in //chainedit, and yes I know
entering it in minutes from midnight is annoying.  Sheer lazines on my part.
I made this entire mod under protest and only decided to release it because
it had been so much work.  Anyway, all onliners that are currently
accessible will show up as green to everyone with ansi.  If it's timelocked,
it'll be dark red.  If someone tries to play a timelocked onliner, a message
will appear informing them from when to when the onliner is accessible.  If
they select a green one, it'll just load it up and go.  If you leave the on
and off times at midnight (the default), that onliner will always be green.
If start time is after end time, the available time will continue through
midnight and into the next day.

For those users who don't have ansi, the box will be made out of stuff like
plusses and minuses.  Plus, they can tell timelocked onliners by the
asterisk that appears in the appropriate row all the way to the right.

The bar graphs should be self explanatory.  To zero out the count, remove
and re-install the onliner.  Why you'd want to is beyond me, but it can be
done.

Oh, by the way: exemption 16 exempts people from the timelock.  If you're
already using this for something else, change the #define...

A program called subcnvt is included to convert your chains.dat file to the
new format.  Yes, it is yet another use for black dragon's convert
program.  Somebody give him a medal or something.  To use the
program, block read it out, compile it, go to your data directory,
rename chains.dat chains.old, and subcnvt chains.old chains.dat.  Then if
you're feeling industrious, delete chains.old.

NOTE FROM MARK:

I did not use the subcnvt program, and don't know if it will work with both
of these mods combined.  All I did was copy down all my chain configurations,
deleted them, did the mod, and inserted the chains again in chainedit.

UPDATE FOR 4.22 NOTE:

Some changes needed to be made for 4.22.  I did not remove all of the strings
in this mod, I will leave that to the SysOp's installing it.  String #119 must
be modified though, to reflect the changes in Chainedit.

DISCLAIMER:  The authors (or myself) are not responsible for what the
installation of this mod may do to your software, hardware, data
files, etc.  I "personally" use this combination on a fairly well
modified 4.22 version of WWIV, and have experienced no problems.

KEY }  == Existing code   ++ Add this line   += Change this line

Files to be modified:

VARDEC.H  --> chainfilerec
BBSUTL1.C --> void do_chains / void show_chains / void run_chains
CHNEDIT.C --> void modify_chain / void insert_chain

************  B A C K   U P   Y O U R   S O U R C E  ************

STEP 1:

Load up VARDEC.H and change/add the following:

== /* DATA FOR OTHER PROGRAMS AVAILABLE */
== typedef struct {
==         char            filename[81],           /* filename for .chn file */
==                         description[81];        /* description of it */
==         unsigned char   sl,                     /* seclev restriction */
==                         ansir;                  /* if ANSI required */
+=         unsigned short  ar,                     /* AR restriction */
++                         lowtime,
++                         hightime,
++                         usage,
++                         grp;
== } chainfilerec;

Farther down find:

== #define exempt_post 0x08
++ #define exempt_timelock 0x10

Save VARDEC.H

STEP 2:

Load up BBSUTL1.C and either comment out or delete void do_chains and
replace it with this one:

void do_chains()
{
  int map[99],mapp,i,i1,ok,done,AR_L;
  char s[81],s1[81],ch,*ss;
  chainfilerec c;
  unsigned short groupid;                 /*  <-- New variable */
  printfile("GROUP");
  prt(2,"Which Area (A-P, Q=Quit) ? ");
  ch=onek("ABCDEFGHIJKLMNOPQ");
  if(ch=='Q')
    return;
  groupid=1 << (ch-'A');
  mapp=0;
  for (i=0; i<10; i++)
    odc[i]=0;
  for (i=0; i<numchain; i++) {
    ok=1;
    c=chains[i];
    if ((c.ansir & ansir_ansi) && (!okansi()))
      ok=0;
    if ((c.ansir & ansir_no_300) && (modem_speed==300))
      ok=0;
    if (c.sl>thisuser.sl)
      ok=0;
    if ((c.ar) && incom)
      ok=1;
    if (((c.ar & thisuser.ar)==0) && (c.ar))
      ok=0;
    if ((c.grp & groupid)==0)               /*  <-- Check for a group */
      ok=0;                                 /*  <-- match here.       */
  
    if (ok) {
      map[mapp++]=i;
      if ((mapp % 10) ==0)
        odc[mapp/10 -1]='0'+(mapp/10);
    }
  }
  if (mapp==0) {
    nl();
    nl();
    pl("Sorry, no external programs available.");
    nl();
    return;
  }
  if (mapp==1) {
    run_chain(map[0]);
   return;
}
  show_chains(&mapp,map);
  done=0;
  
  do {
    prt(2,"Which (Q=Quit, ?=List, N=New Group) : ");  /*  <-- Add N option */
    ss=mmkey(2);
    i=atoi(ss);
    if ((i>0) && (i<=mapp)) {
      done=0;
      run_chain(map[i-1]);
    } else
      if (strcmp(ss,"Q")==0)
        done=1;
      else
        if (strcmp(ss,"?")==0)
          show_chains(&mapp,map);
      else
        if (strcmp(ss,"N")==0) {
          do_chains();
          return;
	}
  } while ((!hangup) && (!done));
}

Next, delete the entire functions void show_chains and void run_chains
and replace them with the following (one HUGE block read):


void show_chains(int *mapp, int *map)
{
  int abort,next,i,i1,j,k,macks=0,padington;
  char s[81],tempomatic[10];

  abort=0;
  for(i=0;i<*mapp;i++)
    if(chains[map[i]].usage>macks) macks=chains[map[i]].usage;
  nl();
  osan("\0031    Title",&abort,&next);
  for(i=0;i<37;i++) osan(" ",&abort,&next);
  pla(" Popularity    Times run",&abort);
  osan(okansi() ? "\0033" : "+--+",&abort,&next);
  for(i=0;i<42;i++) osan(okansi() ? "" : "-",&abort,&next);
  osan(okansi() ? "" : "+",&abort,&next);
  for(i=0;i<10;i++) osan(okansi() ? "" : "-",&abort,&next);
  pla(okansi() ? "Ŀ" : "+-+" ,&abort);
  for (i=0; (i<*mapp) && (!abort) && (!hangup); i++) {
    strcpy(s,okansi() ? "\0033\0032" : "|");
    if(i<9) strcat(s," ");
    itoa(i+1,tempomatic,10);
    strcat(s,tempomatic);
    osan(s,&abort,&next);
    osan(okansi() ? "\0033 " : "| ",&abort,&next);
    k=1;

  if((chains[map[i]].lowtime!=chains[map[i]].hightime) &&
	!(thisuser.exempt & exempt_timelock))
    if(chains[map[i]].hightime>chains[map[i]].lowtime) {
      if((timer()<=(chains[map[i]].lowtime*60.0)) ||
	(timer()>=(chains[map[i]].hightime*60.0))) k=0;
    } else {
      k=0;
      if((timer()>(chains[map[i]].lowtime*60.0)) ||
	(timer()<(chains[map[i]].hightime*60))) k=1;
    }
    if(!abort && okansi()) {
      if(k) setc(10);
      else setc(4);
    }
    osan(chains[map[i]].description,&abort,&next);
    for(padington=0,j=0;j<strlen(chains[map[i]].description); j++)
      if(chains[map[i]].description[j]==3) padington+=2;
    for(j=strlen(chains[map[i]].description); j<=40+padington;j++)
      osan(" ",&abort,&next);
    osan(okansi() ? "\0033\0037" : "|",&abort,&next);
    j=0;
    if(chains[map[i]].usage)
      if((macks/chains[map[i]].usage)*10)
	for(j=1;j<=((float) chains[map[i]].usage/macks)*10; j++)
	  osan(okansi() ? "" : "#",&abort,&next);
    if(j==0) j++;
    while(++j<=11) osan(okansi() ? " " : ":",&abort,&next);
    osan(okansi() ? "\0033" : "|",&abort,&next);
    if(okansi()) setc(4);
    osan(k ? " " : "*",&abort,&next);
    osan(okansi() ? "\0033 \0031" : "| ",&abort,&next);
    sprintf(s,"%05d",chains[map[i]].usage);
    pla(s,&abort);
  }
  osan(okansi() ? "\0033" : "+--+",&abort,&next);
  for(i=0;i<42;i++) osan(okansi() ? "" : "-",&abort,&next);
  osan(okansi() ? "" : "+",&abort,&next);
  for(i=0;i<10;i++) osan(okansi() ? "" : "-",&abort,&next);
  pla(okansi() ? "" : "+-+",&abort);
  nl();
}


void run_chain(int cn)
{
  char s[255],s1[81],s2[81],s3[81];
  int oc,f,blat;
  unsigned int toph,topm,topf,both,botm,botf;
  long l;

  blat=0;
  if((chains[cn].lowtime!=chains[cn].hightime) &&
    !(thisuser.exempt & exempt_timelock))
    if(chains[cn].hightime>chains[cn].lowtime) {
      if((timer()<=(chains[cn].lowtime*60.0)) ||
	     (timer()>=(chains[cn].hightime*60.0))) blat=1;
    } else {
    blat=1;
    if((timer()>(chains[cn].lowtime*60.0)) ||
      (timer()<(chains[cn].hightime*60.00))) blat=0;
  }
  if(blat) {
    topf=botf=0;
    toph=chains[cn].hightime/60;
    topm=chains[cn].hightime-(60*toph);
    if(!toph) toph=12;
    if(chains[cn].hightime>=720) {
      toph-=12;
      topf=1;
    }
    both=chains[cn].lowtime/60;
    botm=chains[cn].lowtime-(60*both);
    if(!both) both=12;
    if(chains[cn].lowtime>=720) {
      both-=12;
      botf=1;
    }
    ansic(1);
    npr("\0031%s is only available from %d:%02d%cm to %d:%02d%cm\r\n",
    chains[cn].description,both,botm,botf?'p':'a',toph,topm,topf?'p':'a');
    sprintf(s2,"!Timelock on '%s'",chains[cn].description);
    sysoplog(s2);
    return;
  }
  chains[cn].usage++;
  sprintf(s,"%sCHAINS.DAT",syscfg.datadir);
  f=open(s,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  write(f,(void *)chains, numchain * sizeof(chainfilerec));
  close(f);
  itoa(com_speed, s1, 10);
  itoa(syscfg.primaryport,s2,10);
  itoa(modem_speed, s3, 10);
  stuff_in(s,chains[cn].filename,create_chain_file("CHAIN.TXT"),s1,s2,s3,"");
  sprintf(s2,"!Ran '%s'",chains[cn].description);
  sysoplog(s2);
  oc=chatcall;
  chatcall=0;
  l=thisuser.sysstatus;
  if (chains[cn].ansir & ansir_no_pause)
    thisuser.sysstatus &= ~sysstatus_pause_on_page;
  if (chains[cn].ansir & ansir_no_DOS) {
    set_protect(0);
    if (chains[cn].ansir & ansir_shrink)
      shrink_out(s,1,0,1,1);
    else
      run_external(s);
    topscreen();
  } else
    if (chains[cn].ansir & ansir_shrink)
      shrink_out(s,1,1,1,1);
    else
      full_external(s,0,1);
  thisuser.sysstatus = l;
  chatcall=oc;
}

Save BBSUTL1.C

STEP 3:

Load up CHNEDIT.C and make the following changes to void modify_chain:


==    outstr(get_string(118));
==    pl((c.ansir & ansir_local_only)?str_yes:srt_no);
++    npr("K. Switch on at : %d:%02d\r\n",c.lowtime/60,
++                c.lowtime-((c.lowtime/60)*60));
++    npr("L. Switch off at: %d:%02d\r\n",c.hightime/60,
++                c.hightime-((c.hightime/60)*60));
++    if (c.grp!=0) {
++ for (i=0; i<16; i++)
++    if ((1 << i) & c.grp)
++      s[0]='A'+i;
++      s[1]=0;
++   }
++   npr("M. Group        : %s\r\n",s);
==    nl();
+=    prt(2,get_string(119));  /* Modify string 119 to read: Which (A-M,Q) ? */
+=    ch=onek("QABCDEFGHIJKLM");
==    switch(ch) {
==      case 'Q':done=1; break;

In the switch(ch) cases, (see next to last line above) insert the
following after Case J :


==          c.ansir &= ~ansir_local_only;
==        break;
++        case 'K':
++        nl();
++        prt(5,"Chain Low Time (Mins from midnight)? ");
++        input(s,4);
++        i=atoi(s);
++        if(i>=0 && i<24*60) c.lowtime=i;
++        break;
++      case 'L':
++        nl();
++        prt(5,"Chain High Time (Mins from midnight)? ");
++        input(s,4);
++        i=atoi(s);
++        if(i>=0 && i<24*60) c.hightime=i;
++        break;
++    case 'M':
++        nl();
++        prt(2,"New group (A-P) ? ");
++        ch2=onek("ABCDEFGHIJKLMNOP");
++        c.grp=1 << (ch2-'A');
++        break;
==    }
==  } while ((!done) && (!hangup));

The next function to modify in is void insert_chain(int n).  Add the
following three lines...

==  c.ansir=0;
++  c.lowtime=0;
++  c.hightime=0;
++  c.usage=0;
==  chains[n]=c;

Save CHNEDIT.C   Compile your source, and while waiting, write Filo
and Greeny a little thank you note for these great mods!

STEP 4:

Block read out and compile the subcnvt program which follows.  You need to
use it on your chains.dat file in the data directory.
Usage: subcnvt oldfile newfile. (READ NOTE FROM MARK ABOVE)



/* Begin subcnvt.c */

/*  CONVERT USERLIST PROGRAM */
/*  Written by The Black Dragon, 1989 */
/*  Mangled by Greeny to do something totally different. */

#include <stdio.h>
#include <string.h>
#include <mem.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
struct {char f[81],d[81],s,an;
	unsigned ar,l,h,u;} new;
struct {char f[81],d[81],s,an;
	unsigned ar;} old;
void main(int argc, char *argv[])
{
  int f,g,i;
  unsigned int loop,num=0;
  unsigned long len;

  if (argc<3) {
    printf("\nRequires 2 parameters.\n");
    printf("Usage: SUBCNVT oldfile newfile \n");
    exit(0);
  }
  if ((f=open(argv[1],O_RDWR|O_BINARY,S_IREAD|S_IWRITE))<=0) {
    printf("\nCould not open chain list %s\n",argv[1]);
    abort();
  }
  if ((g=open(argv[2],O_RDWR|O_BINARY|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE))<=0) {
    printf("\nCould not open output file %s\n",argv[2]);
    abort();
  }
  printf("\n\nSize of old record %d",sizeof(old));
  printf("\nSize of new record %d\n\n",sizeof(new));

  len=filelength(f);
  num=(len/sizeof(old))+!(len%sizeof(old));
  for (loop=0;loop<num;loop++) {
    if (sizeof(old)==read(f,&old,sizeof(old))) {
    printf("\015Processing user #%u of %u",loop,num-1);

    memset(&new,0,sizeof(new));     /* Nice to clear out garbage */
    strcpy(new.f,old.f);          /* Now copy all data over    */
    strcpy(new.d,old.d);
    new.s=old.s;
    new.an=old.an;
    new.ar=old.ar;
    new.l=new.h=new.u=0;
    write(g,&new,sizeof(new));      /* record converted here */
    }
  }
  close(f);
  close(g);
}

/* End subcnvt.c */

STEP 5:

If you used subcnvt and it worked, all you need to do is go into
chainedit and add the GROUP id's to your chains.  If your like me and
just deleted them (your chains) go into chainedit and reinstall them.
You will also need a GROUP.ANS and a GROUP.MSG in G-Files indicating the
menu you want the users to see.  Filo's is included here (from The
Draw) as a sample.


Group.MSG

                *******                           *******
                  |||     THE DRAGON'S DEN          |||
                  |||     Chain Group Menu          |||
                  |||                               |||                  
                  |||     Mod:  Filo05.mod          |||
                  |||                               |||
       Ŀ
           A.  Access to Other Networks                      
                 FidoNet, Vnet                               
           B.  Utility Modes                                 
                 FindBoss, Bimodem, FreeDL                   
           C.  Adventure Games                               
                 Numerous Games Here                         
           D.  Word Games                                    
                 HangMan, Firing Squad, Word Scramble        
           E.  Other Games                                   
                                                             
       


Group.ANS
                                    
                    The Dragon's Den   
                     Chain Group Menu  
                                       
                     Mod: Habitz01     
                                       
     Ŀ
           A.  Access to Other Networks                      
                 FidoNet, Vnet                               
           B.  Utility Modes                                 
                 FindBoss, Bimodem, FreeDL                   
           C.  Adventure Games                               
                 Numerous games here                         
           D.  Word Games                                    
                 Firing Squad, HangMan, Word Scramble, etc   
           E.  Other Games                                   
                 FoodFite, Milliways, and many others        
     

THAT'S IT!  Make your menus any way you want them.  When the user hits
".", they will get the menu like above.  When they select the letter
for the area they want, they will see a sub menu.  Here is an example
of what the sub menu could look like:


    Title                                      Popularity    Times run
Ŀ
 1 BBS Checkers                                        00002
 2 Global Wars                                  00010
 3 Triple Yahtzee                                  00007
 4 HiRoll Dice                                 00011
 5 Greedy Dice                              ߳  00012
 6 BBS Chess                                         00004


