Dave Wallace #1 @5806
Sun Apr 19 07:44:37 1992
+--------------------------------------------------------------------+
|   Name:              CHATTONE                                      |
|   Version:           2.0       (modified to support WWIV 4.21)     |
|   Author:            Dave Wallace (1@5806) et. al.                 |
|   Description:       Change the Chat Tone to a Tune                |
|   Difficulty:        simple, though long                           |
+--------------------------------------------------------------------+

                                Page Request Mod

This mod is based on the CHATCALL mod by Gord the Rogue, as modified by 
Goose (1@7312) and further modified by Dave Wallace (1@5806).

The following is the basic idea of the original mod:

  - The "screeching" sounds that were made by the chat call are replaced
    by a series of tones (these can be customized by changing the tune
    array initialization in the code of the play_tune() function).
  - The user must wait while the sysop is being paged, which lasts for 30
    seconds max.  This is to keep a user from turning on the Chat Call then
    forgetting that it is turned on.
  - If a user attempts to chat more than five times, he is automatically
    logged off after receiving a message explaining why.


The following changes were made by Goose to the original:

  - The user can abort the chat request by pressing SPACE
  - The sysop can silence the chat bell (without the user knowing it) by
    pressing F4.
  - The bell will automatically be turned off if the sysop enters chat mode
    by pressing F10 or Ctrl F10.
  - The chat request reason will be properly displayed in the topscreen
    information until the sysop turns off the chat call, the sysop accepts
    the chat or the user logs off.  It will not be turned off if the user
    aborts the chat request or if the chat request ends normally; this is to
    give the sysop a chance to see the chat reason even if the chat call has
    ended (I can't always make it to my PC in 30 seconds).
  - The chat count for logging off the user is reset whenever the sysop
    accepts the chat (since the user probably has a valid reason for chatting
    if the sysop accepts it).

Additional changes by Dave Wallace (1@5806):

  - The chat tone is 30 seconds of music (this version is Minuet in G by
    Johann Sebastian Bach (attr.) from the Anna Magdelena Notebook).
  - Fixed up a logic bug which occured when the SYSOP respoded to the chat
    request before the 30-second time limit had expired.
  - Updated mod for WWIV version 4.21



Now for the mod itself.

Key:      /* =CHATTONE */     find this line
          // -CHATTONE        delete this line
          /* +CHATTONE */     add this line.

Installation:

1.      First load up VARS.H and locate the FIRST occurance of the line

        wfc, x_only;

        Change it as follows:

// -CHATTONE       wfc, x_only;
/* +CHATTONE */    wfc, x_only, page_reqs;

2.      Now find the NEXT occurance of the line and make the SAME CHANGE.

// -CHATTONE       wfc, x_only;
/* +CHATTONE */    wfc, x_only, page_reqs;

3.      Save VARS.H and load up BBSUTL.C.  Find the line

/* =CHATTONE */ #pragma hdrstop

and add

/* +CHATTONE */ #define NEW_CHAT_TONE

Note: this version of the CHATTONE mod gives you the ability to revert to the
      original chat function by just removing the above line and recompiling.


4.      Find void reqchat().  Make the following change before this function:

/* +CHATTONE */ #ifndef NEW_CHAT_TONE
/* =CHATTONE */ void reqchat()


5.      And then, at the end of the function, add:

/* =CHATTONE */ }
/* +CHATTONE */
/* +CHATTONE */ #else
/* +CHATTONE */ void reqchat()
/* +CHATTONE */ {
/* +CHATTONE */   int ok,abtchat;
/* +CHATTONE */   char s[81];
/* +CHATTONE */
/* +CHATTONE */   nl();
/* +CHATTONE */   nl();
/* +CHATTONE */   ok=sysop2();
/* +CHATTONE */   if (restrict_chat & thisuser.restrict)
/* +CHATTONE */     ok=0;
/* +CHATTONE */   if (ok) {
/* +CHATTONE */     prt(2,"Reason: ");
/* +CHATTONE */     inputl(s,70);
/* +CHATTONE */     if (s[0]) {
/* +CHATTONE */       sprintf(chatreason,"Chat: %s",s);
/* +CHATTONE */       chatcall=1;
/* +CHATTONE */       nl();
/* +CHATTONE */       sysoplog(chatreason);
/* +CHATTONE */       for (ok=strlen(chatreason); ok<80; ok++)
/* +CHATTONE */         chatreason[ok]=32;
/* +CHATTONE */       chatreason[80]=0;
/* +CHATTONE */       topscreen();
/* +CHATTONE */       nl();
/* +CHATTONE */       page_reqs++;
/* +CHATTONE */       prt(1,"Paging Sysop.");
/* +CHATTONE */       nl();
/* +CHATTONE */       prt(2,"Sysop page will end in 30 seconds.  "
/* +CHATTONE */             "Press [SPACE] to abort."); 
/* +CHATTONE */       nl(); nl();
/* +CHATTONE */       abtchat = play_tune();
/* +CHATTONE */       nosound();
/* +CHATTONE */       nl();
/* +CHATTONE */       if (abtchat)
/* +CHATTONE */           prt(1,"Sysop Page cancelled.");
/* +CHATTONE */       else if (page_reqs)
/* +CHATTONE */           prt(1,"Sysop Page deactivated.");
/* +CHATTONE */     }
/* +CHATTONE */   }
/* +CHATTONE */   else
/* +CHATTONE */   {
/* +CHATTONE */       nl();
/* +CHATTONE */       prt(2,"The sysop is not available - "
/* +CHATTONE */             "please use feedback i nstead."); 
/* +CHATTONE */       nl(); 
/* +CHATTONE */       strcpy(irt,"Tried Paging.");
/* +CHATTONE */       imail(1,0);
/* +CHATTONE */   }
/* +CHATTONE */       if (page_reqs > 5)
/* +CHATTONE */   {
/* +CHATTONE */       nl();
/* +CHATTONE */       prt(3,"Page attempts limit exceeded...logging you off.");
/* +CHATTONE */       hangup=1;
/* +CHATTONE */       thisuser.ass_pts++;
/* +CHATTONE */       strcpy(s,"### PAGING VIOLATION for ");
/* +CHATTONE */       strcat(s,nam(&thisuser,usernum));
/* +CHATTONE */       sl1(0,s);
/* +CHATTONE */   }
/* +CHATTONE */ }
/* +CHATTONE */
/* +CHATTONE */ int play_tune()
/* +CHATTONE */ {
/* +CHATTONE */   int i;
/* +CHATTONE */   int tempo;    /* number of milliseconds per 64-th note */
/* +CHATTONE */   int p;        /* delay between notes (p >= 1)          */
/* +CHATTONE */   char ch;
/* +CHATTONE */   struct NOTE {
/* +CHATTONE */     int f;
/* +CHATTONE */     int d;
/* +CHATTONE */   } tune[128] =
/* +CHATTONE */   {
/* +CHATTONE */     287, 16, 191, 8,  215, 8,  241, 8,
/* +CHATTONE */     256, 8,  287, 16, 191, 16, 191, 16,
/* +CHATTONE */     322, 16, 256, 8,  287, 8,  322, 8,
/* +CHATTONE */     362, 8,  383, 16, 191, 16, 191, 16,
/* +CHATTONE */     256, 16, 287, 8,  256, 8,  241, 8,
/* +CHATTONE */     215, 8,  241, 16, 256, 8,  241, 8,
/* +CHATTONE */     215, 8,  191, 8,  181, 16, 191, 8,
/* +CHATTONE */     215, 8,  241, 8,  191, 8,  241, 16,
/* +CHATTONE */     215, 32, 287, 16, 191, 8,  215, 8,
/* +CHATTONE */     241, 8,  256, 8,  287, 16, 191, 16,
/* +CHATTONE */     191, 16, 322, 16, 256, 8,  287, 8,
/* +CHATTONE */     322, 8,  362, 8,  383, 16, 191, 16,
/* +CHATTONE */     191, 16, 256, 16, 287, 8,  256, 8,
/* +CHATTONE */     241, 8,  215, 8,  241, 16, 256, 8,
/* +CHATTONE */     241, 8,  215, 8,  191, 8,  215, 16,
/* +CHATTONE */     241, 8,  215, 8,  191, 8,  181, 8,
/* +CHATTONE */     191, 48, 483, 16, 383, 8,  430, 8,
/* +CHATTONE */     483, 8,  383, 8,  430, 16, 287, 8,
/* +CHATTONE */     322, 8,  362, 8,  287, 8,  383, 16,
/* +CHATTONE */     322, 8,  362, 8,  383, 8,  287, 8,
/* +CHATTONE */     271, 16, 241, 8,  271, 8,  215, 16,
/* +CHATTONE */     241, 8,  271, 8,  287, 8,  322, 8,
/* +CHATTONE */     362, 8,  383, 16, 362, 16, 322, 16,
/* +CHATTONE */     362, 16, 215, 16, 271, 16, 287, 48,
/* +CHATTONE */     287, 16, 191, 8,  181, 8,  191, 16,
/* +CHATTONE */     322, 16, 191, 8,  181, 8,  191, 16,
/* +CHATTONE */     287, 16, 256, 16, 241, 16, 215, 8,
/* +CHATTONE */     191, 8,  181, 8,  191, 8,  215, 8,
/* +CHATTONE */     241, 8,  256, 16, 241, 16, 215, 16,
/* +CHATTONE */     241, 16, 143, 16, 181, 16, 191, 48,
/* +CHATTONE */     0,   0,  0,   0,  0,   0,  0,   0,
/* +CHATTONE */     0,   0,  0,   0,  0,   0,  0,   0 
/* +CHATTONE */   };
/* +CHATTONE */
/* +CHATTONE */   p = 8;
/* +CHATTONE */   tempo = 19; /* had to "push" the tempo a little; s.b. 25. */
/* +CHATTONE */   nosound();delay(p);
/* +CHATTONE */   for (i = 0; ((tune[i].f + tune[i].d) != 0); ++i)
/* +CHATTONE */   {
/* +CHATTONE */     if ((chatcall) && (tune[i].f))
/* +CHATTONE */     {
/* +CHATTONE */       sound(tune[i].f);
/* +CHATTONE */       delay(tune[i].d*tempo);
/* +CHATTONE */       nosound();delay(p);
/* +CHATTONE */     }
/* +CHATTONE */     if (!chatcall) break;
/* +CHATTONE */     ch=inkey();
/* +CHATTONE */     switch (ch)
/* +CHATTONE */     {
/* +CHATTONE */       case 3:     /* ^C */
/* +CHATTONE */       case 24:    /* ^X */
/* +CHATTONE */       case ' ':
/* +CHATTONE */         return 1;
/* +CHATTONE */         break;
/* +CHATTONE */     }
/* +CHATTONE */   }
/* +CHATTONE */   return 0;
/* +CHATTONE */ }
/* +CHATTONE */ #endif

Note: You could block-copy all but the first line of the above and insert it at
      the appropriate point in the code.


6.      Now, save BBSUTL.C and load CONIO.C.  Locate void skey(char ch).
        Make the following changes:

/* =CHATTONE */         case 62: /* F4 */
/* =CHATTONE */           chatcall=0;
/* +CHATTONE */           nosound();
/* =CHATTONE */           topscreen(0);

/* =CHATTONE */         case 68: /* F10 */
/* =CHATTONE */           if (chatting==0) {
/* +CHATTONE */             page_reqs=0;
/* +CHATTONE */             nosound();
/* =CHATTONE */             if (syscfg.sysconfig & sysconfig_2_way)

/* =CHATTONE */         case 103: /* Ctrl-F10 */
// -CHATTONE              if (chatting==0)
/* +CHATTONE */           if (chatting==0) {
/* +CHATTONE */             page_reqs=0;
/* +CHATTONE */             nosound();
/* =CHATTONE */             chat1("",0);
/* +CHATTONE */          }
/* =CHATTONE */          else
/* =CHATTONE */            chatting=0;

7.      Save CONIO.C and re-compile the BBS.

8.      Finally, in the INIT program, turn the BEEP FOR CHAT option to NO (or
        you'll still get those horrible beeps).  It's a lot easier to turn it
        off here than turn search through the code and make the mods.

I won't waste your bandwith with silly disclaimers -- if this mod doesn't work,
please e-mail me and I'll try to be helpful.
