/* Function prototypes */

#ifndef _NETSFUNC_H_
#define _NETSFUNC_H_


/* This function returns the info to process the next sub by reading the */
/* FIDO.NET file */
int NextEnt();


/* places the next line in FIDO.NET into memory for NextEnt to process */
int ReadLine();


/* Process the message, stripping control info */
/* for messages coming into WWIVnet from FIDONET */
int ProcMess();


int ParseName();


/* This procedure imports messages from FIDO to WWIV */
void Import();


/* This procedure exports messages from WWIV to FIDO */
void Export();


/* Process messages coming from WWIVnet to Fidonet */
int Fidoize();


/** Function: Alloc()
 **
 ** Purpose: Allocate all the dynamic variables
 **
 ** Inputs: NONE.
 **
 ** Variables effected:
 **
 **   MBuf:    The message buffer
 **   Buffer:  A buffer for general use.
 **   Path:    The string used to point to various directories
 **   Maildir:
 **   Search:
 **   wwivpath:
 **   tname:
 **
 ** Return Value: None.
 **/
void Alloc();


/* routine to free the memory allocated */
void Free();


/* load NETSEX log into memory, and if the proper amount of time */
/* has passed, update a flag so Save_Log can send it out to the  */
/* NETSEX coordinator.                                           */
void Load_Log();


/** Function: Save_Log()
 **
 ** Purpose:  To save the NetSEX log information to disk and, if
 **           the proper time interval has passed, to mail a copy
 **           of the log to the NetSEX COORDINATOR.
 **
 ** Inputs: path - a string containing the path to the WWIV data
 **                directory.
 **
 ** Also Uses:
 **
 **   Log_Update
 **   CNode
 **   MyNode
 **   Ltime
 **   LocalNode
 **   FidoNode
 **   FidoNet
 **   FidoZone
 **   Version
 **   Log_Count
 **   Net
 **   Ltime
 **   Ldata
 **
 **
 ** Return Value:
 **
 **   NONE.
 **
 **/
void Save_Log();


/** Function: Faddress()
 **
 **
 ** Purpose:  Parse a string containing fidonet address information
 **           in the form:   ZONE:NET/NODE.POINT
 **
 ** Inputs:   Buffer - A the string to parse.
 **
 **
 ** External variables effected:
 **
 **   Zone:  Set to the value of the ZONE field in the address string,
 **          Otherwise it is set to the value in the variable FidoZone.
 **
 **   FNet:  Set to the value of the Fido NET field in the address string,
 **          otherwise it is set to the value in the variable FidoNet.
 **
 **   FNode: Set to the value of the Fido NODE field in the address string,
 **          otherwise it is set to the value in the variable FidoNode.
 **
 **   Point: Set to the value of the Fido POINT field in the address string,
 **          otherwise it is set to 0.
 **
 **
 ** Return Value:
 **
 **   NONE.
 **/
void Faddress();


void CloseTextLog();


void TextLogEntry();


void ReadBBSIndex();


void GetSystemInfo();


/** Function ZapAddr(Buffer)
 **
 ** This function was added because Faddress was inadequate to scan the
 ** origin line.  I inspired myself of the latter to build this one.
 **
 ** It basically scans Buffer backwards, and tries to find a proper fidonet
 ** address.  The "standard" origin line has the address listed at the end
 ** of the line, enclosed in parenthesis.
 **
 ** Ex:  * Origin:  The Sonic Orgasmatron - WWIVnet @5459 (1:167/119.0)
 **
 **/
void ZapAddr();

#endif
