#ifndef _NET_H_
#define _NET_H_


typedef struct {
	unsigned short	tosys,		/* destination system */
			touser,		/* destination user */
			fromsys,	/* originating system */
			fromuser;	/* originating user */
	unsigned short	main_type,	/* main message type */
			minor_type;	/* minor message type */
	unsigned short	list_len;	/* # of entries in system list */
	unsigned long	daten;		/* date/time sent */
	unsigned long	length;		/* # of bytes of msg after header */
	unsigned short	method;		/* method of compression */
} net_header_rec;

/* All network nodes except the destination will only look at:
 *   tosys - the destination system.  Is 0 if more than one system
 *   list_len - if (tosys==0) then list_len is the number of destination
 *     systems in a list immediately after the header.  NOTE this list will
 *     be 2*list_len bytes long, since each system entry is 2 bytes.
 *   length - is the overall length of the message, not including the header
 *     or the system ist length.  Thus the overall length of a message in
 *     the net will be (sizeof(net_header_rec) + 2*list_len + length)
 */



/*
 * Please note that not all of these are used yet, some will probably never
 * be used, but sounded like a good idea at the time.
 */

#define main_type_net_info 0x0001
  /* Here, minor_type will tell what type of net info this contains, such as
   * a new list of nodes, mail to the sysop, or whatever
   */
#define main_type_email 0x0002
  /* Here, minor_type will be zero
   */
#define main_type_post 0x0003
  /* Here, minor_type will contain the sub type of the post.  It will tell
   * the BBS what subboard to post the message on
   */
#define main_type_file 0x0004
  /* I don't know if this will be used, but if it is, minor_type will contain
   * the dir type of the dir the file will go on
   */
#define main_type_pre_post 0x0005
  /* this is like a post, but for this type, the post needs to be sent out to
   * a few other systems when the destination system receives it.
   */
#define main_type_external 0x0006
  /* This is reserved for use by programs external to WWIV
   */
#define main_type_email_name 0x0007
  /* used in sending email to a user's name on another system
   */
#define main_type_net_edit 0x0008
  /* used by the net editor program
   */
#define main_type_sub_list 0x0009
  /* used for sending updates of the sub list
   */
#define main_type_extra_data 0x000a
  /* used for sending net info not necessarily from @1
   */
#define main_type_group_bbslist 0x000b
  /* used for sending out bbslist.net entries for a group - goes to
   * bbslist.[group number].  Minor type is group number.
   */
#define main_type_group_connect 0x000c
  /* used for sending out connect.net entries for a group - goes to
   * connect.[group number].  Minor type is group number.
   */
#define main_type_group_info 0x000e
  /* used for sending out group info, such as mail-to-all-sysops in
   * a group
   */

typedef struct {
	unsigned short	systemnumber,	/* System number of the contact */
			numcontacts,	/* number of contacts with system */
			numfails;	/* number of consec failed calls out */
	unsigned long	firstcontact,	/* time of first contact with system */
			lastcontact,	/* time of most recent contact */
			lastcontactsent,/* time of last contact with data sent */
			lasttry,	/* time of last try to connect */
			bytes_received,	/* bytes received from system */
			bytes_sent,	/* bytes sent to system */
			bytes_waiting;	/* bytes waiting to be sent */
} net_contact_rec;

/* Each system will hold a file of these records.  Each record will hold the
 * data pertaining to all contacts with other systems.
 *
 * systemnumber tells what other system this data is for.
 * numcontacts tells how many times a connection has been made with
 *   that system.
 * numfails tells how many times this system has tried to call this other
 *   system but failed.  This is consecutive times, and is zeroed out
 *   when a successful connection is made by calling out.
 * firstcontact is time in unix format of the last time that system has been
 *   contacted on the net.
 * lastcontact is the time the last contact with that system was made.
 * lastcontactsent is the last time data was SENT to that system.
 * lasttry is the last time we tried to call out to that system.
 * bytes_received is number of bytes received from that system.
 * bytes_sent is number of bytes sent to that system.
 * bytes_waiting is the number of bytes waiting to be sent out to that
 *   system.
 *
 * This data is maintained so that the BBS can decide which other system to
 * attempt connection with next.
 */


typedef struct {
	unsigned int	sysnum;		/* system number of the system */
	char		phone[13],	/* phone number of system */
                        name[40];       /* name of system */
        unsigned char   group;          /* group of the system */
	unsigned int	speed,		/* max baud rate of system */
			other,		/* other info about sys (bit-mapped)*/
			forsys;		/* how to get there */
	int		numhops;	/* how long to get there */
	float		cost;		/* how much it costs to get there */
} net_system_list_rec;

/* This data is all read in from a text file which holds info about all of
 * the systems in the network.  This text file doesn't hold connection info
 * between the systems.  The purpose of all records should be obvious.
 */

#define other_fido 0x0001           /* unused */

/* modem type designators */
#define other_Telebit_19200 0x0002  /* | */
#define other_USR_9600 0x0004       /* < */
#define other_Hayes_9600 0x0008     /* > */
#define other_V32 0x0020            /* ! */
#define other_V42 0x0040            /* $ */

/* system type designators */
#define other_coordinator 0x0010    /* ^ */
#define other_group_coord 0x0100    /* % */
#define other_net_coord   0x0200    /* & */


typedef struct {
	unsigned int	sysnum,		/* outward calling system */
			numsys;		/* num systems it can call */
	unsigned int    *connect;	/* list of numsys systems */
	float		*cost;		/* list of numsys costs */
} net_interconnect_rec;

/* This data is also read in from a text file.  It tells how much it costs for
 * sysnum to call out to other systems.
 *
 * numsys - is the number of systems that sysnum can call out to
 * connect[] - points to an array of numsys integers that tell which
 *   other systems sysnum can connect to
 * cost[] - points to an array of numsys floating point numbers telling
 *   how much it costs to connect to that system, per minute.  ie, it would
 *   cost (cost[1]) dollars per minute for sysnum to call out to system
 *   number (connect[1]).
 */


typedef struct {
	unsigned int	sysnum;		/* system to contact */
	unsigned char	macnum;		/* macro/script to use */
	unsigned int	options;	/* bit mapped */
	unsigned char	call_anyway;	/* num days between calls */
        char            min_hr,
                        max_hr;         /* calling hours */
	char		password[20];	/* password for that system */
        unsigned char   times_per_day;  /* num times should call per day */
} net_call_out_rec;

/* This record holds info about other systems that the sysop has determined
 * that we can call out to.
 *
 * sysnum - system number that we can call
 * macnum - macro/script number to use to call that system.  This is set
 *   to zero if we just dial it directly.
 * options - bit mapped.  See #define's below.
 * call_anyway - if non-zero, then the minimum number of days between calls
 *   to that system, even if there is nothing waiting to be sent there.  This
 *   should only be non-zero if options_sendback is also set for this system.
 * password - is the password used for connection to this system.
 */


#define options_sendback 0x0001
  /* Set if, when we call that system, they can send data back to us.
   */
#define options_ATT_night 0x0002
  /* Set if we can only call that system at AT&T nighttime hours, which
   * includes weekends.
   */
#define options_PCP_night 0x0004
  /* Set if we can only call that system during PC Pursuit hours.
   */
#define options_no_call 0x0008
  /* Set if we don't call out to that system, but that system will call us
   * with sendback allowed.  Thus, we can direct stuff to that system, even
   * though we won't ever directly call it.
   */
#define options_receive_only 0x0010
  /* Set if we will receive things but won't xmit them */
#define options_once_per_day 0x0020
  /* Set if we have to wait 20 hours between calls */

typedef struct {
	unsigned int	sysnum;		/* system number we can call */
	int		nument;		/* number of entries in list */
	unsigned int	*list;		/* list of systems */
} sys_for_rec;


#endif
