/*
 ****************************************************************************
 * Version: ALIASES.C v1.00                                                 *
 *                                                                          *
 * Purpose: This program reads your WWIV user list and outputs, in a style  *
 *          that NetSEX can understand, a list of aliases.  This program    *
 *          automates the creation and update of your aliases index.        *
 *          NetSEX v1.00 uses a linked list to store the IN_ALIAS and       *
 *          OUT_ALIAS declarations, so your only limitation is free heap.   *
 *          There is a #define that supposedly limits the number (MAX_ALIAS *
 *          I think) in my copy of the source, but I have surpassed this    *
 *          limit by far.                                                   *
 *                                                                          *
 * Notes:   The credit for this program goes wholly and entirely to         *
 *          Darkster 1@3114.  I saw this on his board and he gave it to me. *
 *          I didn't like its output, so I reworked it.  It functionally    *
 *          does the same thing, though.                                    *
 *                                                                          *
 * Files:   CONFIG.DAT (Binary Input)                                       *
 *          USER.LST (Binary Input)                                         *
 *          ALIASES.TXT (Text Output)                                       *
 ****************************************************************************
 * TCC Command line:                                                        *
 *                                                                          *
 *       tcc -G -O -d -r -mt -N- -Z -a -lt -2 aliases                       *
 ****************************************************************************
 */

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <sys\stat.h>
#include "vardec.h"

/* comment out to leave names as they are in the user file */
#define NAMES_UPPERCASE

/* holds WWIV static system configuration */
configrec syscfg;

/* this is the user file variable; set to -1 to represent a closed file */
int userfile = -1;

void init()
/*
 * Read WWIV's CONFIG.DAT to get WWIVnet node number and data directory.
 * Program is aborted with a DOS errorlevel of 1 if CONFIG.DAT does not
 * exist.
 *
 * Parameters: None
 *
 * Returns: Nothing
 */
{
  int configfile;
  char s[81];

  strcpy(s,"CONFIG.DAT");
  configfile=open(s,O_RDWR | O_BINARY);
  if (configfile<0) {
    printf("%s NOT FOUND.\n",s);
    exit(1);
  }
  read(configfile,(void *) (&syscfg), sizeof(configrec));
  close(configfile);
}

void read_user(unsigned int un, userrec *u)
/*
 * Modified version of Wayne's read_user routine to get a user
 * at a specified offset in the user file; no functionality gone,
 * just stupid useless code Wayne added
 *
 * Parameters: u  = the user number (record offset)
 *             *u = points to the user record to place the record requested
 *
 * Returns: Nothing
 */
{
  long pos;
  char s[80];
  int i;

  if (userfile == -1) {
    sprintf(s, "%sUSER.LST", syscfg.datadir);
    userfile = open(s, O_RDWR | O_BINARY);
    if (userfile < 0) {
      u->inact = inact_deleted;
      return;
    }
  }
  pos = (long) (sizeof(userrec) * (long) un);
  if (filelength(userfile) <= pos) {
    u->inact = inact_deleted;
    return;
  }
  lseek(userfile, pos, SEEK_SET);
  read(userfile, (void *)u, sizeof(userrec));
  if (u->realname[0] == 0) {
    u->inact = inact_deleted;
    return;
  }
  if (!strchr(u->realname, ' ')) {
    u->inact = inact_deleted;
    return;
  }
  if (strchr(u->realname, '=')) {
    u->inact = inact_deleted;
    return;
  }
}

void close_user()
/*
 * Closes user file if it is not already closed.
 *
 * Parameters: None
 *
 * Returns: Nothing
 */
{
  if (userfile!=-1) {
    close(userfile);
    userfile=-1;
  }
}

char *returnstr(char *st)
/*
 * This routine formats the string in the desired way and returns the
 * modified string.  The purpose of this as a separate routine would be
 * for someone to modify it to allow it to, say, convert all letters to
 * lower case except for the first letters in each word.
 *
 * Parameters: *st = string to be formatting
 *
 * Returns: formatted string
 */
{
#ifdef NAMES_UPPERCASE
  return(strupr(st));
#else
  return(st);
#endif
}

void run()
/*
 * This is the meat routine.  It reads in each user record, and if
 * that user has a valid real name, and it is not a deleted record,
 * then write the IN_ALIAS and OUT_ALIAS entries to ALIASES.TXT in the
 * WWIV DATA directory.
 *
 * Parameters: None
 *
 * Returns: Nothing
 */
{
  int f, i, count;
  char s[255];
  userrec u;

  read_user(1, &u);
  if (userfile < 0) {
    printf("Could not open user file properly.\r\n");
    exit(1);
  }
  count = (int)(filelength(userfile) / sizeof(userrec));
  --count;
  sprintf(s, "%sALIASES.TXT", syscfg.datadir);
  f = open(s, O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
  if (f > 0) {
    for (i = 1; i <= count; i++) {
      read_user(i, &u);
      printf("Processing user #%d/%d\r", i, count);
      if (u.inact != inact_deleted) {
        sprintf(s, "IN_ALIAS: %s=n%d u%d\r\n", returnstr(u.realname),
                                               syscfg.systemnumber, i);
        write(f,(void *)s,strlen(s));
        sprintf(s, "OUT_ALIAS: n%d u%d=%s\r\n", syscfg.systemnumber, i,
                                                returnstr(u.realname));
        write(f,(void *)s,strlen(s));
      } else {
        printf("User %d skipped: Deleted/Invalid Real Name\r\n", i);
      }
    }
    close_user();
    close(f);
  } else {
    printf("Could not open %sALIASES.TXT\r\n", syscfg.datadir);
    exit(1);
  }
}

void done()
/*
 * Does nothing.  Something would be present if there was a need for
 * global shutdown code.
 *
 * Parameters: None
 *
 * Returns: Nothing
 */
{
}

void main()
/*
 * Main program.  Simply a shell that calls the initialization routine and
 * the meat routine.  A blank shutdown routine is defined.
 *
 * Parameters: None
 *
 * Returns: Nothing
 */
{
  init();
  run();
  done();
}
