/* General structure definitions and #defines */

#ifndef _NETS_H_
#define _NETS_H_

/* Version - used in log files and in the startup message */
/* NetSEX prints.  It must be FOUR characters long        */

#define Version "2.00"


/* De-Comment the line below if you want NetSEX to print */
/* Ooodles of debug information,  I mean oodles!         */

/* #define DEBUG */


/* Definitions of structures used in fidonet messages */

struct MessageHdr {
        char fromUserName[36];
        char toUserName[36];
        char subject[72];
        char dateTime[20];
        short timesRead,
              destNode,
              origNode,
              cost,
              origNet,
              destNet;
        char fill[8];
        short replyTo,
              Attribute,
              nextReply;
};


/* Structure used to dynamically store the aliases */
struct Alias {
        char in[37],
             out[37];
};


/* Structure used to store the log information */
typedef struct {
        char name[40];
        unsigned short sub_type;
        unsigned short host;
        unsigned long in_messages, out_messages;
        unsigned long in_bytes, out_bytes;
} log_entry;


/* Structure used to store BBS info for the "From System" Line */
/* On outbound fidonet mail from wwivnet                       */

typedef struct {
                unsigned int    sysnum;
                char            phone[13],
                                name[41];
} Stats;


#endif
