/*******************************************************************/
/* This software was written by Matt Logan over nearly a year for  */
/* the WWIVnet/Fidonet community.  This software may be freely     */
/* modified and re-compiled.  Modified source must accompanied by  */
/* the original source if it is made availiable on any public BBS. */
/* Modified versions on the binaries may not be posted on any      */
/* public BBS.  All documenation, source, and executables must be  */
/* included in any distribution of this software.  All Copyright   */
/* notices must be left intact in the source and included          */
/* documentation files.                                            */
/*                                                                 */
/* The intent here is to provide the WWIV/FIDONET community with   */
/* reliable access to the lastest versions of this software.  I    */
/* would ask that any modifications that prove to be very useful   */
/* be made availiable to me so that I may include them in future   */
/* releases of this software.  This software may not be sold for   */
/* profit for any reason.  I intend to keep NetSEX a Public Domain */
/* utility FOREVER.                                                */
/*                                                                 */
/*                                                                 */
/* Addresses:                                                      */
/*              USENET:  matt@eecs.cs.pdx.edu                      */
/*             WWIVNET:  1@5317                                    */
/*                                                                 */
/*             US MAIL:  Matt Logan                                */
/*                       11790 S.W. Denney Rd.                     */
/*                       Beaverton Oregon 97005                    */
/*                                                                 */
/*                                                                 */
/* Contributions are welcome and will most likely be applied to my */
/* tuition payments for my last year in college as a Physics/Music */
/* major at Portland State University.                             */
/*                                                       06/14/90  */
/*******************************************************************/



/* NETS.c                                                           */
/*                                                                  */
/*    Converts FIDO packets into WWIV packets and vice versa.       */
/*                                                                  */
/*                                                                  */
/* REVISION HISTORY:                                                */
/*                                                                  */
/*    Matt Logan - 09/25/89 Initial version.                        */
/*                                                                  */
/*    Matt Logan - 11/10/89 Added Aliases, Local and Sub Commands.  */
/*                                                                  */
/*    Matt Logan - 11/17/89 Processed fido messages get bit 10 in   */
/*                          the Attribute field set instead of      */
/*                          being deleted.                          */
/*                                                                  */
/*    Matt Logan - 01/05/90 A whole Lotta stuff fixed, optimized    */
/*                          added. Points, OUT_ALIAS.               */
/*                                                                  */
/*    Matt Logan - 02/11/90 Version 0.89 a ^AWWIVGATE: line is now  */
/*                          used to mark messages as processed.  A  */
/*                          few more bugs have been fixed.          */
/*                          P<N>.NET Files are now created instead  */
/*                          of being appended (Dangerous) and the   */
/*                          limit on the number of BBS's has been   */
/*                          removed.                                */
/*    J. Garzik, - 09/06/91 Version 2.00.  First "legal" gateway    */
/*    J. Rybacek,           version.  Many code changes.  See       */
/*    P. Tremblay           README.200 for all the changes.         */


#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <sys/stat.h>
#include <dos.h>
#include <dir.h>
#include <time.h>
#include <fcntl.h>
#include <string.h>
#include "NET.H"
#include "NETS.H"
#include "NETSFUNC.H"


int TextLog;                                     /* v2.00 */
unsigned int *system_index;                      /* v2.00 */
unsigned int syscount;                           /* v2.00 */
struct date datep;
struct time timep;
short sub_list[50];
unsigned int sub_type, host_system;
long list_len, Log_Count, Ltime;
log_entry *Ldata;
char Log_Update;
FILE *Net, *Sub, *Log;
char Path[81];                                   /* v2.00 */
char MailDir[81];                                /* v2.00 */
char Search[81];                                 /* v2.00 */
char Number[10];
unsigned short MyNode, LocalNode;
int FidoNet, FidoNode, FidoZone;
char Buffer[300];                                /* v2.00 */
char Banner[81];                                 /* v2.00 */
char wwivpath[81];                               /* v2.00 */
char *MBuf;
long MLength;
net_header_rec header;
struct Alias *Alias;
int NumAlias;
int LineCount;
char area[40], bd_flag, export_flag;
int destNet, destNode;
char tname[81];                                  /* v2.00 */
int Point, ToPoint, Zone, FNet, FNode;
unsigned short CNode, WWIVgate;
char NetString[11];
char s[160];                                     /* v2.00 */
char logdir[81];                                 /* v2.00 */
unsigned char kill_after_process, debug;         /* v2.00 */

void main(argc, argv)
  int argc;
  char **argv;
{
  long clock1, clock2;

  time(&clock1);
  printf("NetSEX! Version %s Copyright Matt Logan 1989, 1990\n", Version);
  printf("%s\n", ctime(&clock1));
  NetString[0] = 0;
  TextLog = -1;                                  /* v2.00 */
  CNode = 0;
  kill_after_process = 0;
  debug = 0;
  Alloc();
  if (argc == 2 || (argc == 3 && strcmpi(argv[2], "/WF") == 0)) {
    printf("Running Import then Export\n");
    Load_Log(argv[1]);
    Import(argv);
    Export(argv);
  } else if (argc == 3 && strcmpi(argv[2], "/FW") == 0) {
    printf("Running Export then Import\n");
    Load_Log(argv[1]);
    Export(argv);
    Import(argv);
  } else if (argc == 3 && strcmpi(argv[2], "/W") == 0) {
    printf("Running Import only\n");
    Load_Log(argv[1]);
    Import(argv);
  } else if (argc == 3 && strcmpi(argv[2], "/F") == 0) {
    printf("Running Export only\n");
    Load_Log(argv[1]);
    Export(argv);
  } else {
    printf("Usage: %s <DATAPATH> [/FW]\n", argv[0]);
    Free();
    exit(0);
  }
  Save_Log(argv[1]);
  Free();
  time(&clock2);
  sprintf(s, "Total time: %ld Seconds",          /* v2.00 */
          clock2 - clock1);                      /* v2.00 */
  if (TextLog != -1) {                           /* v2.00 */
    TextLogEntry("");                            /* v2.00 */
    TextLogEntry(s);                             /* v2.00 */
    TextLogEntry("");                            /* v2.00 */
  }                                              /* v2.00 */
  puts("");
  puts(s);                                       /* v2.00 */
}

void Alloc()                                     /* v2.00 */
{
  MBuf = (char *) malloc(33000);
  if (MBuf == NULL) {
    printf("Can't allocate Memory");
    exit(-1);
  }
}

void Free()                                      /* v2.00 */
{
  free(MBuf);
  free(Alias);
}

void Import(argv)
  char **argv;
{

  long msg_cnt, byte_cnt;
  FILE *fd1, *fd2;
  int x, y, z, no_end;
  long Position;
  unsigned char c;
  unsigned short syst;
  char Subject[80];
  char ToUser[37];
  char Name[80];
  char AName[80];
  char Date[80];
  struct ffblk ffblk;
  int done;
  int MailFlag;
  unsigned char print_flag;
  char *B2;

  printf("\n\nImporting...\n");
  strcpy(wwivpath, argv[1]);
  if (wwivpath[strlen(wwivpath) - 1] == '\\')    /* v2.00 */
    wwivpath[strlen(wwivpath) - 1] = 0;          /* v2.00 */
  if (wwivpath[strlen(wwivpath) - 1] == '/')     /* v2.00 */
    wwivpath[strlen(wwivpath) - 1] = 0;          /* v2.00 */
  fd2 = NULL;                                    /* v2.00 */
  export_flag = 0;
  MailDir[0] = 0;
  LocalNode = 0;
  NumAlias = 0;
  LineCount = 0;
  Banner[0] = 0;
  sprintf(Buffer, "%s/FIDO.NET", wwivpath);
  Net = fopen(Buffer, "rt");
  if (Net == NULL) {
    printf("Can't Find %s\n", Buffer);
    exit(-1);
  }
  x = 0;
  do {
    if (fd2 != NULL)                                       /* v2.00 */
      fclose(fd2);                                         /* v2.00 */
    x++;
    sprintf(Buffer, "%s/P%d.NET", wwivpath, x);
    fd2 = fopen(Buffer, "rb");
  } while ((fd2 != NULL) && (x < 32767));                  /* v2.00 */
  if (fd2 != NULL) {                                       /* v2.00 */
    printf("Error,  couldn't open a P*.NET FILE\n");       /* v2.00 */
    fclose(fd2);                                           /* v2.00 */
    exit(1);                                               /* v2.00 */
  }                                                        /* v2.00 */
  while (NextEnt() == 0) {
    sprintf(Search, "%s/*.MSG", Path);
    msg_cnt = 0;
    byte_cnt = 0;
    print_flag = 0;
    done = findfirst(Search, &ffblk, 0);
    while (!done) {
      sprintf(Search, "%s/%s", Path, ffblk.ff_name);
      fd1 = fopen(Search, "r+b");
      if (fd1 == NULL) {
        printf("Error opening file %s\n", Search);
        exit(-1);
      }
      /* Find out if this message has already been processed */
      fseek(fd1, 0, 0);
      fread(AName, 36, 1, fd1);
      fread(tname, 36, 1, fd1);
      fseek(fd1, 166, 0);
      fread(&destNode, 2, 1, fd1);
      fseek(fd1, 174, 0);
      fread(&destNet, 2, 1, fd1);

      /* If it hasn't been processed,  process it! */
      if (strncmp(AName, "QMail", 5) != 0 && (ffblk.ff_fsize < 28000)) {
        msg_cnt++;
        gettime(&timep);
        getdate(&datep);
        header.tosys = host_system;
        header.touser = 0;
        header.fromsys = MyNode;
        header.fromuser = 0;
        header.main_type = main_type_pre_post;
        header.minor_type = sub_type;
        header.list_len = list_len;
        header.daten = dostounix(&datep, &timep);
        header.method = 0;
        header.length = 0;

        /* This loop reads the header and gets some info from it */

        /* This is only used if running mail */
        fseek(fd1, 36, 0);
        fread(ToUser, 36, 1, fd1);

        fread(Subject, 72, 1, fd1);
        fread(Date, 20, 1, fd1);

        /* Put the proper Fido Net/Node number in the name */
        fseek(fd1, 168, 0);
        fread(&FNode, 2, 1, fd1);
        fseek(fd1, 172, 0);
        fread(&FNet, 2, 1, fd1);
        fseek(fd1, 190, 0);

        Zone = FidoZone;
        Point = 0;
        ToPoint = 0;
        WWIVgate = 0;
        header.length = MLength = ProcMess(fd1);
/*        if (debug) {
          printf("fidonet %d\n", (int)FidoNet);
          printf("Fidonode %d\n", (int)FidoNode);
          printf("destnet %d\n", (int)destNet);
          printf("destnode %d\n", (int)destNode);
          printf("FNode %d\n", (int)FNode);
          printf("FNet %d\n", (int)FNet);
          printf(" What? %d\n", (int)~(22 == 2 && 1 == 1));
        }                                                   */
        if (((destNet == FidoNet && destNode == FidoNode
              && ToPoint == 0) || sub_type != 0)
            && WWIVgate != LocalNode) {
          fseek(fd1, 0, 2L);
          x = ftell(fd1) - sizeof(struct MessageHdr);
          B2 = malloc(x);
          if (B2 == NULL) {                                /* v2.00 */
            printf("Error, not enough memory\n");
            exit(-1);
          }
          fseek(fd1, sizeof(struct MessageHdr), 0L);
          fread(B2, x, 1, fd1);
          fseek(fd1, sizeof(struct MessageHdr), 0L);
          fprintf(fd1, "%cWWIVGATE: %d%c%c",
                  1, LocalNode, 13, 10);
          fwrite(B2, x, 1, fd1);
          free(B2);
          if (Point == 0 && Zone == FidoZone) {            /* v2.00 */
            sprintf(Name, "%s OF %d/%d", AName,            /* v2.00 */
                          FNet, FNode);                    /* v2.00 */
          } else if (Point != 0 && Zone == FidoZone) {     /* v2.00 */
            sprintf(Name, "%s OF %d/%d.%d", AName, FNet,   /* v2.00 */
                          FNode, Point);                   /* v2.00 */
          } else if (Point == 0 && Zone != FidoZone) {     /* v2.00 */
            sprintf(Name, "%s OF %d:%d/%d", AName, Zone,   /* v2.00 */
                          FNet, FNode);                    /* v2.00 */
          } else {                                         /* v2.00 */
            sprintf(Name, "%s OF %d:%d/%d.%d", AName,      /* v2.00 */
                          Zone, FNet, FNode, Point);       /* v2.00 */
          }                                                /* v2.00 */
          byte_cnt += header.length;
          if (print_flag == 0) {
            if (sub_type == 0) {
              sprintf(s, "Mail:");               /* v2.00 */
              TextLogEntry(s);                   /* v2.00 */
              puts(s);                           /* v2.00 */
            } else {
              sprintf(s, "Sub %ld:",             /* v2.00 */
                      (long) sub_type);          /* v2.00 */
              TextLogEntry(s);                   /* v2.00 */
              puts(s);                           /* v2.00 */
            }
                                                 /* v2.00 */
            sprintf(s, "Date       Time     %-5s %-13.13s %s", "Size", "To", "From");
            TextLogEntry(s);                     /* v2.00 */
            puts(s);                             /* v2.00 */
                                                 /* v2.00 */
            sprintf(s, "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            TextLogEntry(s);                     /* v2.00 */
            puts(s);                             /* v2.00 */
            print_flag = 1;
          }
          sprintf(s, "%19.19s %5ld %-13.13s %s", /* v2.00 */
                    Date,                        /* v2.00 */
                    (long) header.length, ToUser,/* v2.00 */
                     Name);                      /* v2.00 */
          TextLogEntry(s);                       /* v2.00 */
          puts(s);                               /* v2.00 */
          header.length += (strlen(Subject) + 1) + (strlen(Name) + 2) +
                           (strlen(Date) + 2);
          if (sub_type == 0)
            MailFlag = ParseName(ToUser);
          if (Banner[0] != 0)
            header.length += (strlen(Banner));
          /* Write Header */
          if (fd2 == NULL)
            fd2 = fopen(Buffer, "w+b");
          fwrite(&header, sizeof(header), 1, fd2);
          if (sub_type == 0 && MailFlag == 1) {
            fwrite(ToUser, strlen(ToUser), 1, fd2);
            c = 0;
            fwrite(&c, 1, 1, fd2);
          }
          /* Write Title, Name and Date */
          fwrite(Subject, strlen(Subject), 1, fd2);
          c = 0;
          fwrite(&c, 1, 1, fd2);
          fwrite(Name, strlen(Name), 1, fd2);
          c = 13;
          fwrite(&c, 1, 1, fd2);
          c = 10;
          fwrite(&c, 1, 1, fd2);
          fwrite(Date, strlen(Date), 1, fd2);
          c = 13;
          fwrite(&c, 1, 1, fd2);
          c = 10;
          fwrite(&c, 1, 1, fd2);
          /* Write Body of text */
          fwrite(MBuf, MLength, 1, fd2);
          /* Write Banner if there is one */
          if (Banner[0] != 0) {
            fwrite(Banner, strlen(Banner), 1, fd2);
          }
        }
      }
      fclose(fd1);
      if (kill_after_process)                              /* v2.00 */
        unlink(Search);                                    /* v2.00 */
      done = findnext(&ffblk);
    }
    if (print_flag != 0) {
                                                 /* v2.00 */
      sprintf(s, "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      TextLogEntry(s);                           /* v2.00 */
      puts(s);                                   /* v2.00 */
                                                 /* v2.00 */
      sprintf(s, "%ld Messages, %ld Bytes\r\n", msg_cnt, byte_cnt);
      TextLogEntry(s);                           /* v2.00 */
      puts(s);                                   /* v2.00 */
      for (x = 0; x != Log_Count; x++) {
        if (strcmp(area, Ldata[x].name) == 0)
          break;
      }
      if (x == Log_Count) {
        Log_Count++;
        if (Ldata == NULL) {
          Ldata = (log_entry *) malloc(sizeof(log_entry));
        } else {
          Ldata = (log_entry *) realloc(Ldata, Log_Count * sizeof(log_entry));
        }
        if (Ldata != NULL) {                               /* v2.00 */
          for (y = 0; y != 40; y++)
            Ldata[x].name[y] = 0;
          strcpy(Ldata[x].name, area);
          Ldata[x].sub_type = sub_type;
          Ldata[x].host = host_system;
          Ldata[x].in_messages = 0;
          Ldata[x].out_messages = 0;
          Ldata[x].in_bytes = 0;
          Ldata[x].out_bytes = 0;
        }                                                  /* v2.00 */
      }
      if (Ldata != NULL) {                                 /* v2.00 */
        Ldata[x].in_messages += msg_cnt;
        Ldata[x].in_bytes += byte_cnt;
      }                                                    /* v2.00 */
    }
  }
  fclose(fd2);
  fclose(Net);
}

void GetSystemInfo(sysnum, sysdata)              /* v2.00 */
  unsigned int sysnum;
  Stats *sysdata;
{
  int x, y;
  FILE *tempfile;
  net_system_list_rec nslr;
  char s1[81];
  Stats sysdat;

  sysdat = *sysdata;
  sysdat.sysnum = 0;
  sysdat.phone[0] = 0;
  sysdat.name[0] = 0;
  for (x = 0; x < syscount; x++)
    if (system_index[x] == sysnum)
      break;
  if (x < syscount) {
    sprintf(s1, "%s/BBSDATA.NET", wwivpath);
    tempfile = fopen(s1, "rb");
    if (tempfile == NULL) {
      printf("Can't find %s\n", s1);
      exit(-1);
    }
    fseek(tempfile, (long)(x) * sizeof(net_system_list_rec), SEEK_SET);
    fread((void *)(&nslr), sizeof(net_system_list_rec), 1, tempfile);
    fclose(tempfile);
    sysdat.sysnum = sysnum;
    strcpy(sysdat.phone, nslr.phone);
    strcpy(sysdat.name, nslr.name);
  }
  *sysdata = sysdat;
}

void ReadBBSIndex()                              /* v2.00 */
{
  char s1[161];
  int f;
  long l;

  syscount = 0;
  sprintf(s1, "%s\\BBSDATA.IND", wwivpath);
  f = open(s1, O_RDWR | O_BINARY);
  if (f < 0) {
    printf("could not find file.\n");
    exit(1);
  }
  l = filelength(f);
  syscount = (int)(l/2);
  system_index = (unsigned int *) malloc(syscount * 2);
  if (system_index == NULL)
    exit(1);
  read(f, (void *)system_index, l);
  close(f);
}

void Export(argv)
  char **argv;
{
  long msg_cnt, byte_cnt;
  FILE *fd1, *fd2;
  int x, y, z, no_end;
  long Position;
  unsigned char c;
  unsigned short syst;
  char Subject[80];
  char ToUser[37];
  char Name[80];
  char Date[80];
  struct ffblk ffblk;
  int done;
  int MailFlag;
  unsigned short Attribute;
  int max_msg;
  long fpos1, fpos2;
  unsigned short didit = 65535;
  struct MessageHdr Fmessage;
  unsigned char print_flag;
  Stats static_stat;                             /* v2.00 */
  unsigned int last_system_checked;              /* v2.00 */

  last_system_checked = 0;                       /* v2.00 */
  export_flag = 1;
  sprintf(&Fmessage.fill[0], "NETSEX");
  printf("Exporting...\n");
  strcpy(wwivpath, argv[1]);
  if (wwivpath[strlen(wwivpath) - 1] == '\\')    /* v2.00 */
    wwivpath[strlen(wwivpath) - 1] = 0;          /* v2.00 */
  if (wwivpath[strlen(wwivpath) - 1] == '/')     /* v2.00 */
    wwivpath[strlen(wwivpath) - 1] = 0;          /* v2.00 */
  printf("Loading bbsdata index...");
  ReadBBSIndex();
  printf("Done.  %d Systems.\n", syscount);
  MailDir[0] = 0;
  LocalNode = 0;
  NumAlias = 0;
  LineCount = 0;
  /* Set Banner to null for now */
  Banner[0] = 0;
  if (debug)
    printf("Initialized variables\n");
  sprintf(Buffer, "%s/FIDO.NET", wwivpath);
  Net = fopen(Buffer, "rt");
  if (Net == NULL) {
    printf("Can't Find %s\n", Buffer);
    exit(-1);
  }
  while (NextEnt() == 0) {
    /* This Section of code finds the WWIV messages and converts them       */
    /* into FIDO messages                                              */

    print_flag = 0;
    if (bd_flag == 1) {
      sprintf(Search, "%s/*.MSG", Path);
      max_msg = 0;
      done = findfirst(Search, &ffblk, 0);
      while (!done) {
        if (atol(ffblk.ff_name) > max_msg)
          max_msg = atol(ffblk.ff_name);
        done = findnext(&ffblk);
      }
      if (max_msg == 0)
        max_msg = 1;
      if (debug)
        printf("Highest message number = %d\n", max_msg);
      msg_cnt = 0;
      byte_cnt = 0;
      sprintf(Buffer, "%s/s%d.NET", wwivpath, MyNode);
      fd1 = fopen(Buffer, "r+b");
      if (fd1 != NULL) {
        /* read Header */
        while (fread(&header, sizeof(header), 1, fd1) == 1) {
          fpos1 = ftell(fd1) - 16;
          /* Check to see if the message needs to be processed */
          if (
          /* This part checks for posts to the sub currently being processed */
              (header.main_type == main_type_post && header.minor_type == sub_type)
          /* This part checks for Email */
              || (header.main_type == main_type_email_name)
            ) {
            fpos2 = ftell(fd1);
            fseek(fd1, fpos1, 0);
            /* Mark this message as processed */
            fwrite(&didit, sizeof(didit), 1, fd1);
            fseek(fd1, fpos2, 0);
            if (print_flag == 0) {
              if (sub_type == 0) {
                sprintf(s, "Mail:");             /* v2.00 */
                TextLogEntry(s);                 /* v2.00 */
                puts(s);                         /* v2.00 */
              } else {
                                                 /* v2.00 */
                sprintf(s, "Sub %ld:", (long) sub_type);
                TextLogEntry(s);                 /* v2.00 */
                puts(s);                         /* v2.00 */
              }
                                                 /* v2.00 */
              sprintf(s, "Date       Time     %-5s %-13.13s %s", "Size", "From", "To");
              TextLogEntry(s);                   /* v2.00 */
              puts(s);                           /* v2.00 */
                                                 /* v2.00 */
              sprintf(s, "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
              TextLogEntry(s);                   /* v2.00 */
              puts(s);                           /* v2.00 */
              print_flag = 1;
            }
            Zone = FidoZone;
            x = Fidoize(fd1, &Fmessage);
            if (Zone != FidoZone) {
              Fmessage.destNet = FidoZone;
              Fmessage.destNode = Zone;
            }
            max_msg++;
            msg_cnt++;
            byte_cnt += x;
            sprintf(Buffer, "%s\\%d.MSG", Path, max_msg);
            fd2 = fopen(Buffer, "wb");
            if (fd2 == NULL) {
              printf("Can't write to %s\n", Buffer);
              exit(-1);
            }
            /* Write out the message */
            fwrite(&Fmessage, sizeof(Fmessage), 1, fd2);
            if (Point != 0)
              fprintf(fd2, "%cTOPT %d%c%c", 1, Point, 13, 10);
            if (Zone != FidoZone)
              fprintf(fd2, "%cINTL %d:%d/%d %d:%d/%d%c%c", 1,
                      Zone, FNet, FNode, FidoZone, FidoNet, FidoNode, 13, 10);
            fprintf(fd2, "%cWWIVGATE: %d %s N%d U%d%c%c", 1, LocalNode,
                    NetString, (int) header.fromsys, (int) header.fromuser, 13, 10);
            fwrite(MBuf, x, 1, fd2);
            c = 13;
            fwrite(&c, 1, 1, fd2);
            c = 10;
            fwrite(&c, 1, 1, fd2);
            if (strncmp(Fmessage.toUserName, "UUCP", 4) != 0) {
              if (last_system_checked != header.fromsys) { /* v2.00 */
                GetSystemInfo(header.fromsys, &static_stat);/* v2.00 */
                last_system_checked = static_stat.sysnum;  /* v2.00 */
              }                                            /* v2.00 */
              if (static_stat.sysnum == 0)                 /* v2.00 */
                z = -1;                                    /* v2.00 */
              fprintf( fd2,"--- NetSEX v%s%c%c",Version,   /* v2.00 */
                           13,10);                         /* v2.00 */
              if (z != -1)                                 /* v2.00 */
                fprintf(fd2, " # Origin: %s @%d - %s[%s]%c%c", /* v2.00 */
                              NetString,                   /* v2.00 */
                              (int)header.fromsys,         /* v2.00 */
                              static_stat.name,            /* v2.00 */
                              static_stat.phone, 13, 10);  /* v2.00 */
              fprintf(fd2," * Origin: %s/FIDOnet Gateway (%d:%d/%d)%c%c",
                              NetString,                   /* v2.00 */
                              FidoZone, FidoNet,           /* v2.00 */
                              FidoNode, 13, 10);           /* v2.00 */
              c = 13;                                      /* v2.00 */
              fwrite(&c, 1, 1, fd2);                       /* v2.00 */
              c = 10;                                      /* v2.00 */
              fwrite(&c, 1, 1, fd2);                       /* v2.00 */
            }
            c = 0;
            fwrite(&c, 1, 1, fd2);
            fclose(fd2);
          } else {
            fseek(fd1, header.length, 1);
          }
        }
        fclose(fd1);
      }
    }
    if (print_flag != 0) {
                                                 /* v2.00 */
      sprintf(s, "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
      TextLogEntry(s);                           /* v2.00 */
      puts(s);                                   /* v2.00 */
                                                 /* v2.00 */
      sprintf(s, "%ld Messages, %ld Bytes\r\n", msg_cnt, byte_cnt);
      TextLogEntry(s);                           /* v2.00 */
      puts(s);                                   /* v2.00 */
      for (x = 0; x != Log_Count; x++)
        if (strcmp(area, Ldata[x].name) == 0)
          break;
      if (x == Log_Count) {
        Log_Count++;
        if (Ldata == NULL) {
          Ldata = (log_entry *) malloc(sizeof(log_entry));
        } else {
          Ldata = (log_entry *) realloc(Ldata, Log_Count * sizeof(log_entry));
        }
        if (Ldata != NULL) {                               /* v2.00 */
          for (y = 0; y != 40; y++)
            Ldata[x].name[y] = 0;
          strcpy(Ldata[x].name, area);
          Ldata[x].sub_type = sub_type;
          Ldata[x].host = host_system;
          Ldata[x].in_messages = 0;
          Ldata[x].out_messages = 0;
          Ldata[x].in_bytes = 0;
          Ldata[x].out_bytes = 0;
        }                                                  /* v2.00 */
      }
      if (Ldata != NULL) {                                 /* v2.00 */
        Ldata[x].out_messages += msg_cnt;
        Ldata[x].out_bytes += byte_cnt;
      }                                                    /* v2.00 */
    }
  }
  sprintf(Buffer, "%s/s%d.NET", wwivpath, (int) MyNode);
  unlink(Buffer);
  return;
}

int NextEnt()
{
  char Line[160], Line2[160], s4[160];                     /* v2.00 */
  int x, y, z, done = 0;
  int tot;
  int Res;

  if (debug)
    printf("Entering NextEnt()\n");
  while (done == 0) {
    LineCount++;
    if (fgets(Line, 160, Net) == NULL)
      /* Bail out if no more to process */
      return (-1);
    /* Copy in case we need the EXACT line */
    strcpy(Line2, Line);
    strupr(Line);
    if (strncmp("SUB: ", Line, 5) == 0) {
      if (debug)
        printf("%s", Line);
      strcpy(s4, Line);                                    /* v2.00 */
      strtok(s4, " ");                                     /* v2.00 */
      sub_type = atol(strtok(NULL, " "));                  /* v2.00 */
      if (sub_type < 1)                                    /* v2.00 */
        return(-1);                                        /* v2.00 */
      if (debug)                                           /* v2.00 */
        printf("Sub type %d\n", sub_type);                 /* v2.00 */
      host_system = atol(strtok(NULL, " "));               /* v2.00 */
      if (host_system < 1)                                 /* v2.00 */
        return(-1);                                        /* v2.00 */
      if (debug)                                           /* v2.00 */
        printf("Host system %d\n", host_system);           /* v2.00 */
      strcpy(Path, strtok(NULL, " "));                     /* v2.00 */
      if (Path[0] == 0)                                    /* v2.00 */
        return(-1);                                        /* v2.00 */
      if (debug)                                           /* v2.00 */
        printf("Search path: *%s*\n", Path);               /* v2.00 */
      strcpy(area, strtok(NULL, " "));                     /* v2.00 */
      if (area[0] == 0)                                    /* v2.00 */
        return(-1);                                        /* v2.00 */
      if (debug)                                           /* v2.00 */
        printf("Fidonet area: %s\n", area);                /* v2.00 */
      strcpy(s, strtok(NULL, " "));                        /* v2.00 */
      if (s[0] == 'Y')                                     /* v2.00 */
        bd_flag = 1;                                       /* v2.00 */
      else                                                 /* v2.00 */
        bd_flag = 0;                                       /* v2.00 */
      if ((bd_flag == 1) && (debug))
        printf("Sub is bi-directional\n");
      if ((export_flag == 0) || (bd_flag == 1))
        done = 1;
      Line[0] = ';';
                                                           /* v2.00 */
    } else if (strncmp("KILL_AFTER_PROCESS", Line, 18) == 0) {
      kill_after_process = 1;                              /* v2.00 */
    } else if (strncmp("DEBUG", Line, 5) == 0) {           /* v2.00 */
      debug = 1;                                           /* v2.00 */
    } else if (((strncmp("IN_ALIAS: ", Line, 10) == 0) && (export_flag == 0)) ||
               ((strncmp("OUT_ALIAS: ", Line, 11) == 0) && (export_flag == 1))) {
      x = 9 + export_flag;
      while (Line[x] != '=' && x < strlen(Line))
        x++;
      if (x >= strlen(Line)) {
        printf("Error in ALIAS Command, Line %d\n%s\n", LineCount, Line);
        exit(0);
      }
      Line[x] = 0;
      Line2[strlen(Line2) - 1] = 0;
      y = 0;
      while ((strcmpi(Alias[y].in, &Line[10 + export_flag]) != 0)
             && (y < NumAlias))
        y++;
      if (y == NumAlias) {
        if (debug)
          printf("New Alias\n");
        if (y == 0) {
          Alias = (struct Alias *) malloc(sizeof(struct Alias));
        } else {
          Alias = (struct Alias *) realloc(Alias, (NumAlias + 1) * sizeof(struct Alias));
        }
        if (Alias == NULL) {                               /* v2.00 */
          sprintf(s, "WARNING: Not enough memory.  Stopped at alias #%d", NumAlias);
          TextLogEntry(s);                                 /* v2.00 */
          puts(s);                                         /* v2.00 */
          NumAlias = 0;                                    /* v2.00 */
        }                                                  /* v2.00 */
        strcpy(Alias[NumAlias].in, &Line[10 + export_flag]);
        strcpy(Alias[NumAlias].out, &Line2[x + 1]);
        if (debug)
          printf("Aliasing %s to %s\n", Alias[NumAlias].in, Alias[NumAlias].out);
        NumAlias++;
      } else if (strlen(&Line2[x + 1]) == 0) {
        if (debug)
          printf("De-Aliasing %s\n", Alias[y].in);
        for (z = y; z != NumAlias - 1; z++) {
          strcpy(Alias[z].in, Alias[z + 1].in);
          strcpy(Alias[z].out, Alias[z + 1].out);
        }
        NumAlias--;
        Alias = (struct Alias *) realloc(Alias, NumAlias * sizeof(struct Alias));
      } else {
        if (debug)
          printf("Changing Alias of %s to %s\n", Alias[y].in, &Line2[x + 1]);
        strcpy(Alias[y].out, &Line2[x + 1]);
      }

      Line[0] = ';';
    } else if (strncmp("IN_ALIAS: ", Line, 10) == 0 ||
               strncmp("OUT_ALIAS: ", Line, 11) == 0) {
      Line[0] = ';';
    } else if (strncmp("BANNER: ", Line, 8) == 0) {
      /* Limit Length to 80 chars */
      tot = 0;
      for (x = 8; x < strlen(Line2); x++) {
        /* Check for ^C */
        if (Line2[x] == 3) {
          x++;
          x++;                                             /* v2.00 */
        } else {
          tot++;
        }
        if (tot == 80) {
          Line2[x + 1] = 0;
          break;
        }
      }
      strcpy(Banner, &Line2[8]);
      Line[0] = ';';
      if (debug)
        printf("BANNER: %s\n", Banner);
    } else if (strncmp("NODE: ", Line, 6)==0) {
      MyNode = atol(&Line[6]);
      Line[0] = ';';
    } else if (strncmp("FNODE: ", Line,7)==0) {
      FidoNode = (unsigned short) atol(&Line[7]);
      Line[0] = ';';
    } else if (strncmp("FNET: ", Line, 6)==0) {
      FidoNet = (unsigned short) atol(&Line[6]);
      Line[0] = ';';
    } else if (strncmp("FZONE: ", Line,7)==0) {
      FidoZone = (unsigned short) atol(&Line[7]);
      Line[0] = ';';
    } else if (strncmp("LOCAL: ", Line,7)==0) {
      LocalNode = atol(&Line[7]);
      Line[0] = ';';
    } else if (strncmp("MAIL: ", Line, 6)==0) {
      strcpy(MailDir, &Line[6]);
      MailDir[strlen(MailDir) - 1] = 0;
      /* Process the mail */
      strcpy(area, "Mail");
      strcpy(Path, MailDir);
      MailDir[0] = 0;
      sub_type = 0;
      bd_flag = 1;
      if (debug)
        printf("Processing Mail\n");
      done = 1;
      Line[0] = ';';
    } else if (strncmp("COORDINATOR: ", Line, 13) == 0) {
      CNode = atol(&Line[13]);
      Line[0] = ';';
    } else if (strncmp("NETWORK: ", Line, 9) == 0) {
      strcpy(NetString, &Line2[9]);
      NetString[strlen(NetString) - 1] = 0;
      Line[0] = ';';
    } else if (strncmp("LOGS: ", Line, 6)==0) {  /* v2.00 */
      strcpy(logdir, &Line[6]);                  /* v2.00 */
      logdir[strlen(logdir) - 1] = 0;            /* v2.00 */
      logdir[strlen(logdir)] = 0;                /* v2.00 */
      logdir[strlen(logdir) + 1] = 0;            /* v2.00 */
      if (logdir[strlen(logdir) - 1] != 92)      /* v2.00 */
        logdir[strlen(logdir)] = 92;             /* v2.00 */
      Line[0] = ';';                             /* v2.00 */
    } else if (Line[0] != ';' && Line[0] != 10) {
      puts("Unrecognized command in FIDO.NET:");
      puts(Line2);
    }
  }
  return (0);
}

int ReadLine(Buffer, fd)
  unsigned char *Buffer;
  FILE *fd;
{
  int x = 0;
  while (fread(&Buffer[x], 1, 1, fd) == 1) {
    if (Buffer[x] == 10 || Buffer[x] == 141) {
      ;
    } else if (Buffer[x] == 13) {
      Buffer[x + 1] = 0;
      return (0);
    } else {
      x++;
      if (x > 718) {
        Buffer[x] = 0;
        return (x);
      }
    }

  }
  Buffer[x] = 0;
  return (-1);
}

int ProcMess(fd)
  FILE *fd;
{
  int x, y, z, flagaddr;
  char Buffer[720];

  y = 0;
  flagaddr = 0;

  /* Add the To: line from the fido message to the message text */
  if (sub_type != 0) {
    sprintf(MBuf, "To: %s\r\n\r\n", tname);
    y = strlen(MBuf);
  }
  do {
    x = ReadLine(Buffer, fd);
  if (Buffer[0] == 1 && strncmp("FMPT ", &Buffer[1],5)==0) /* v2.00 */
    Point = atoi(&Buffer[6]);                              /* v2.00 */
    if ((Buffer[0] == 1) &&                                /* v2.00 */
      (strncmp("MSGID:", &Buffer[1], 6) == 0)) {           /* v2.00 */
      z = 9;                                               /* v2.00 */
      while ((Buffer[z] != ' ') && (Buffer[z] != 0))       /* v2.00 */
        z++;                                               /* v2.00 */
      Buffer[z]=0;                                         /* v2.00 */
      Faddress(&Buffer[8]);                                /* v2.00 */
      flagaddr = 1;                                        /* v2.00 */
      if (debug)
        printf("Origin Address found in ^AMSGID: Flag: %i:%i/%i\n"
               ,Zone,FNet,FNode);
    }
    /* Ignore ^A Lines and AREA: and SEEN-BY: and EID: */
    if (Buffer[0] != 1
        && strncmp("AREA:", Buffer, 5) != 0
        && strncmp("SEEN-BY:", Buffer, 8) != 0
        && strncmp("EID:", Buffer, 4) != 0
        && strncmp("TOPT ", Buffer, 4) != 0
        && strncmp("FMPT:", Buffer, 4) != 0
        && !(Buffer[0] == 13 && y == 0)) {

      for (z = 0; z != strlen(Buffer); z++) {
        if (Buffer[z] == 13) {
          MBuf[y] = 13;
          y++;
          MBuf[y] = 10;
          y++;
        } else {
          MBuf[y] = Buffer[z];
          y++;
        }
      }
    } else if (Buffer[0] == 1 && strncmp("FMPT ", &Buffer[1], 5) == 0) {
      Point = atoi(&Buffer[6]);
    } else if (Buffer[0] == 1 && strncmp("TOPT ", &Buffer[1], 5) == 0) {
      ToPoint = atoi(&Buffer[6]);
    } else if (Buffer[0] == 1 && strncmp("INTL ", &Buffer[1], 5) == 0) {
      z = 6;
      while (Buffer[z] != ' ') {
        z++;
      }
      Buffer[z] = 0;
      Faddress(&Buffer[5]);
      destNode = FNode;
      destNet = FNet;
      Faddress(&Buffer[z + 1]);
      flagaddr = 1;
    } else if (Buffer[0] == 1 && strncmp("WWIVGATE: ", &Buffer[1], 10) == 0) {
      WWIVgate = atoi(&Buffer[11]);
      if (WWIVgate == LocalNode) {
        if (debug)
          printf("Message Already Processed.\r\n");
        return (0);
      }
    }
    if ((!flagaddr && Buffer[0] != 1) &&                           /* v2.00 */
        (strncmp("* Origin:", &Buffer[1], 9) == 0)) {              /* v2.00 */
      if (debug)                                                   /* v2.00 */
        printf("Origin Line Processing: %s\n\n\r",&Buffer[10]);    /* v2.00 */
      ZapAddr(&Buffer[10]);                                        /* v2.00 */
      if (debug)                                                   /* v2.00 */
        printf("Origin Address found in Origin Line: %i:%i/%i\n\n" /* v2.00 */
               ,Zone,FNet,FNode);                                  /* v2.00 */
    }                                                              /* v2.00 */
  } while (x >= 0);
  return (y);

}

int ParseName(Name)
  char *Name;
{
  int Number, Node, x, y;
  char temp[40];

  for (x = 0; x != NumAlias; x++) {
    if (strcmpi(Name, Alias[x].in) == 0) {
      if (debug)
        printf("%s Aliased to %s.", Name, Alias[x].out);
      strcpy(Name, Alias[x].out);
      break;
    }
  }

  if (Name[0] == 'N') {
    Node = atol(&Name[1]);
  } else {
    Node = 0;
  }

  if (debug)
    printf(" To: %s\n Node = %d.", Name, Node);
  y = strlen(Name);
  x = 0;
  while ((x < y) && (Name[x] != ' ')) {
    x++;
  }

  /* No Node Number ? */
  /* Must be local mail */
  if (x >= y || Node <= 0) {
    if (debug)
      printf(" Mail to %s\n", Name);
    header.length += strlen(Name) + 1;
    header.main_type = main_type_email_name;
    header.list_len = 0;
    header.tosys = LocalNode;
    return (1);
  }
  if (Name[x + 1] == 'U') {
    Number = atol(&Name[x + 2]);
  } else {
    Number = 0;
  }

  if (debug)
    printf("Number = %d\n", Number);
  /* Mail sent to User Number at Node Number */
  if (Number != 0) {
    if (debug)
      printf(" Mail to user # %d @ %d.\n", Number, Node);
    header.main_type = main_type_email;
    header.list_len = 0;
    header.tosys = Node;
    header.touser = Number;
    return (2);
  }
  /* Name E-Mail Bound for another system */
  if ((Number == 0) && (Node != 0)) {
    strcpy(temp, &Name[x + 1]);
    strcpy(Name, temp);
    if (debug)
      printf(" Mail to %s@%d.\n", Name, Node);
    header.length += strlen(Name) + 1;
    header.main_type = main_type_email_name;
    header.list_len = 0;
    header.tosys = 5317;
    return (1);
  }
  return (-1);
}

int Fidoize(file, Fheader)
  FILE *file;
  struct MessageHdr *Fheader;
{
  int length, x, mlength, y, z, x1;
  struct tm *tm;
  unsigned char c;
  char ch[81];
  int Line, LineMkr;
  char *Mon[12] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
                   "Oct", "Nov", "Dec"};

  length = 0;
  mlength = 0;
  if (sub_type == 0) {
    /* Read in the TO field */
    x = 0;
    do {
      if (fread(&Fheader -> toUserName[x], 1, 1, file) != 1) {
        printf("Error in s%ld file\n", MyNode);
        exit(-1);
      }
      x++;
      length++;
    } while (Fheader -> toUserName[x - 1] != 0);
    strupr(Fheader -> toUserName);
    for (; x != 36; x++)
      Fheader -> toUserName[x] = 0;
  } else {
    strcpy(Fheader -> toUserName, "All");
    for (x = 3; x != 36; x++) {
      Fheader -> toUserName[x] = 0;
    }
  }
  /* Read in the subject field */
  x = 0;
  do {
    if (fread(&Fheader -> subject[x], 1, 1, file) != 1) {
      printf("Error in s%ld file\n", MyNode);
      exit(-1);
    }
    x++;
    length++;
  } while ((Fheader -> subject[x - 1] != 0) && (x < 70));
  for (x = x; x != 72; x++)
    Fheader -> subject[x] = 0;
  /* Read in the FROM field */
  x = 0;
  do {
    if (fread(&tname[x], 1, 1, file) != 1) {
      printf("Error in s%ld file\n", MyNode);
      exit(-1);
    }
    x++;
    length++;
  } while (tname[x - 1] != 13);
  tname[x - 1] = 0;
  fread(&c, 1, 1, file);
  length++;
  while (tname[x] != '#')
    x--;
  tname[x] = 0;
  while (tname[strlen(tname) - 1] == ' ')                  /* v2.00 */
    tname[strlen(tname) - 1] = 0;                          /* v2.00 */
  sprintf(Fheader -> fromUserName, "N%d U%d (%s)",         /* v2.00 */
                                   (int)header.fromsys,    /* v2.00 */
                                   (int)header.fromuser,   /* v2.00 */
                                   tname);                 /* v2.00 */
  for (x = 0; x != NumAlias; x++) {
    if (strcmpi(Fheader -> fromUserName, Alias[x].in) == 0) {
      strcpy(Fheader -> fromUserName, Alias[x].out);
      break;
    }
  }
  for (x = strlen(Fheader -> fromUserName); x != 36; x++)
    Fheader -> fromUserName[x] = 0;
  /* Read in the DATE field */
  x = 0;
  do {
    if (fread(&Fheader -> dateTime[0], 1, 1, file) != 1) {
      printf("Error in s%ld file\n", MyNode);
      exit(-1);
    }
    x++;
    length++;
  } while (Fheader -> dateTime[0] != 13);
  Fheader -> dateTime[x - 1] = 0;
  fread(&c, 1, 1, file);
  length++;
  tm = localtime(&(long) header.daten);
  sprintf(Fheader -> dateTime, "%02d %s %02d  %02d:%02d:%02d", tm -> tm_mday, Mon[tm -> tm_mon],
          tm -> tm_year, tm -> tm_hour, tm -> tm_min, tm -> tm_sec);
  /* Read in the text */
  x = 0;
  /* If Not going to uucp,  put in another from field */
  if (debug)
    printf("to: %s\n", Fheader -> toUserName);
  LineMkr = x;
  do {
    if (fread(&c, 1, 1, file) != 1) {
      printf("Error in file\n");
      exit(0);
    }
    if (c == 13 || (c < 128 && c > 31)) {
      MBuf[x] = c;
      length++;
      x++;
    } else if (c > 127) {
      /* French Accents -> unaccentuated equivalent */     /* v2.00 */
      switch(c) {                                          /* v2.00 */
        case 130:                                          /* v2.00 */
        case 136:                                          /* v2.00 */
        case 137:                                          /* v2.00 */
        case 138:                                          /* v2.00 */
          MBuf[x]=101;                                     /* v2.00 */
          break;         /* e */                           /* v2.00 */
        case 131:                                          /* v2.00 */
        case 132:                                          /* v2.00 */
        case 133:                                          /* v2.00 */
          MBuf[x]=97;                                      /* v2.00 */
          break;         /* a */                           /* v2.00 */
        case 139:                                          /* v2.00 */
        case 140:                                          /* v2.00 */
          MBuf[x]=105;                                     /* v2.00 */
          break;         /* i */                           /* v2.00 */
        case 147:                                          /* v2.00 */
        case 148:                                          /* v2.00 */
          MBuf[x]=111;                                     /* v2.00 */
          break;         /* o */                           /* v2.00 */
        case 150:                                          /* v2.00 */
        case 151:                                          /* v2.00 */
        case 129:                                          /* v2.00 */
          MBuf[x]=117;                                     /* v2.00 */
          break;         /* u */                           /* v2.00 */
        case 135:                                          /* v2.00 */
          MBuf[x]=99;                                      /* v2.00 */
          break;         /* c */                           /* v2.00 */
        default:                                           /* v2.00 */
          MBuf[x]=' ';                                     /* v2.00 */
      }                                                    /* v2.00 */
      length++;
      x++;
      /* WWIV Color Code */
    } else if (c == 3) {
      fread(&c, 1, 1, file);
      length += 2;
      /* Word Wrap */
    } else if (c == 1) {
      fread(&c, 1, 1, file);
      fread(&c, 1, 1, file);
      length += 3;
      MBuf[x] = 10;
      x++;
    } else {
      length++;
    }
  } while (length < header.length);
  MBuf[x] = 0;
  if (debug)
    printf("----- Text Follows -----\n%s\n", MBuf);
  mlength += x;
  Fheader -> timesRead = 0;
  Fheader -> destNode = 0;
  Fheader -> origNode = FidoNode;
  Fheader -> cost = 0;          /* This used to mark the message as processed */
  Fheader -> origNet = FidoNet;
  Fheader -> destNet = 0;
  Fheader -> replyTo = 0;
  Fheader -> Attribute = (unsigned short) 0;
  if (sub_type == 0) {
    Fheader->Attribute = (unsigned short)257 ;             /* v2.00 */
    x = strlen(Fheader -> toUserName);
    while (Fheader -> toUserName[x] != 'O') {
      x--;
    }
    x--;
                                                 /* v2.00 */
    if (strncmpi(" OF ", &Fheader -> toUserName[x], 4) == 0) {
      Fheader -> toUserName[x] = 0;
      Faddress(&Fheader -> toUserName[x + 4]);
      Fheader -> destNode = FNode;
      Fheader -> destNet = FNet;
      if (debug)
        printf("Headed for %d/%d\n", Fheader -> destNet, Fheader -> destNode);
    }
  }
  /* Check to see if the message has a RE: */
  if (strncmp("RE:", &MBuf[LineMkr], 3) == 0) {
    if (debug)
      printf("Found a RE:\n");
    /* Find where the "RE:" line ends and block move... */
    x = LineMkr;
    while (MBuf[x] != 13) {
      x++;
    }
    /* Make RE: the new subject line */          /* v2.00 */
    strncpy(Fheader -> subject, &MBuf[LineMkr], x - LineMkr);
      if (debug)
        printf("Added RE: to the subject Line\n");
    /* I am assuming that the standard RE: line ends in two <CR> */
    x += 2;
    for (length = x; length != mlength; length++)
      MBuf[length - (x - LineMkr)] = MBuf[length];
    mlength -= (x - LineMkr);
  }
  x = LineMkr;
  /* Check to see if the message has a To: */
                                                 /* v2.00 */
  if ((sub_type != 0) && ((strncmp("BY:", &MBuf[LineMkr], 3) == 0) ||
      (strncmpi("To:", &MBuf[LineMkr], 3) == 0))) {
    if (debug)
      printf("Found a To/BY:\n");                  /* v2.00 */
    /* Find where the "To:" line ends and block move... */
    x = LineMkr;
    while (MBuf[x] != 13) {
      x++;
    }
    /* Add the To: into the to line */
    if ((3 + x - LineMkr) < 35) {
      strncpy(Fheader -> toUserName, &MBuf[LineMkr + 4], x - LineMkr - 4);
      if (debug)
        printf("Change ToUser Field\n");
    }
    /* I am assuming that the standard To: line ends in two <CR> */
    x += 1;
    for (length = x; length != mlength; length++) {
      MBuf[length - (x - LineMkr)] = MBuf[length];
    }
    mlength -= (x - LineMkr);
  }
  /* Going to FIDONET - alternate adressing mode */
                                                 /* v2.00 */
  if ((sub_type != 0) && (strncmp("FIDONET", Fheader -> toUserName, 7) == 0) &&
      ((strncmpi("BY:", &MBuf[LineMkr], 3) == 0) ||
       (strncmpi("To:", &MBuf[LineMkr], 3) == 0))) {

    if (debug)
      printf("Found a FIDONET To/BY:\n");          /* v2.00 */
    /* Find where the "To:" line ends and block move... */
    x = LineMkr;
    while (MBuf[x] != 13) {
      x++;
    }
    /* Add the To: into the to line */
    if ((3 + x - LineMkr) < 35) {
      strncpy(Fheader -> toUserName, &MBuf[LineMkr + 4], x - LineMkr - 4);
      if (debug)
        printf("Added To: to the subject Line\n");
    }
    /* I am assuming that the standard To: line ends in two <CR> */
    x += 1;
    for (length = x; length != mlength; length++) {
      MBuf[length - (x - LineMkr)] = MBuf[length];
    }
    mlength -= (x - LineMkr);
    x1 = strlen(Fheader -> toUserName) - 1;
    while (x1 > 0 &&
           ((Fheader -> toUserName[x1] != 'O') ||
            (Fheader -> toUserName[x1] != 'o')))           /* v2.00 */
      x1--;
    x1--;
    strcpy(ch,&Fheader->toUserName[x+4]);                  /* v2.00 */
    if (strncmpi(" OF ", strupr(ch) , 4) == 0) {           /* v2.00 */
      Fheader->toUserName[x] = 0;                          /* v2.00 */
      Faddress(&Fheader->toUserName[x+4]);                 /* v2.00 */
      Fheader->destNode = FNode;                           /* v2.00 */
      Fheader->destNet = FNet;                             /* v2.00 */
      if (debug)
        printf("Headed for %d/%d\n", Fheader -> destNet, Fheader -> destNode);
    } else {                                               /* v2.00 */
      Fheader->toUserName[x] = 0;                          /* v2.00 */
      Fheader->destNode = FidoNode;                        /* v2.00 */
      Fheader->destNet  = FidoNet;                         /* v2.00 */
    }                                                      /* v2.00 */
  }
  if (debug) {
    printf("To: %s ", Fheader -> toUserName);
    printf("From: %s ", Fheader -> fromUserName);
    printf("Subject: %s ", Fheader -> subject);
    printf("Date: %s\n", Fheader -> dateTime);
  }
  if (sub_type == 0) {
                                                 /* v2.00 */
    sprintf(s, "%s %5ld %-13.13s %s of %ld/%ld", Fheader->dateTime,
            (long) mlength, Fheader->fromUserName, Fheader->toUserName,
            (long) Fheader->destNet, (long) Fheader->destNode);
  } else {
                                                 /* v2.00 */
    sprintf(s, "%s %5ld %-13.13s %s", Fheader->dateTime,
            (long) mlength, Fheader->fromUserName, Fheader->toUserName);
  }
  TextLogEntry(s);                               /* v2.00 */
  puts(s);                                       /* v2.00 */
  return(mlength);
}

void Load_Log(path)
  char *path;
{
  char bb[80];
  long Ptime;
  struct stat buff;
  struct tm *tm2;
  int x;
  sprintf(bb, "%s/NETSEX.DAT", path);
  Log_Update = 0;
  time(&Ptime);

  if (stat(bb, &buff) == 0) {
    Log = fopen(bb, "rb");
    fread(&Ltime, sizeof(Ltime), 1, Log);
    Ldata = (log_entry *) malloc(buff.st_size - sizeof(Ltime));
    if ((Ldata == NULL) && ((buff.st_size - sizeof(Ltime)) > 0)) {  /* v2.00 */
      printf("Not enough memory to load log.\n");          /* v2.00 */
      exit(1);                                             /* v2.00 */
    }                                                      /* v2.00 */
    fread(Ldata, buff.st_size - sizeof(Ltime), 1, Log);
    fclose(Log);
    Log_Count = (buff.st_size - sizeof(Ltime)) / sizeof(log_entry);

    tm2 = localtime(&Ptime);
    /* Send out Log update if it is Sunday, or it has been more */
    /* Than a week since the last update */
    if ((Ptime - Ltime >= 604800) ||
        ((tm2 -> tm_wday == 0) && (Ptime - Ltime) > 86400)) {
      Log_Update = 1;
    }
  } else {
    Log_Count = 0;
    Ltime = Ptime;
    Ldata = NULL;
  }
}

void Save_Log(path)
  char *path;
{
  struct stat buff;
  char c, bb[80];
  int x, y, z;

  /* Send Log file off to the Coordinator... */
  if (Log_Update == 1 && CNode != 0) {
    printf("Sending out Log file\n");
    sprintf(bb, "%s/P1.NET", path);
    Net = fopen(bb, "a+b");
    gettime(&timep);
    getdate(&datep);
    header.tosys = CNode;
    header.touser = 0;
    header.fromsys = MyNode;
    header.fromuser = 0;
    header.main_type = main_type_external;
    header.minor_type = 6969;
    header.list_len = 0;
    header.daten = dostounix(&datep, &timep);
    header.method = 0;
    header.length = sizeof(long) + sizeof(LocalNode) + sizeof(FidoNode) +
                    sizeof(FidoNet) + sizeof(FidoZone) + 4 +
                    (sizeof(log_entry) * Log_Count);
    fwrite(&header, sizeof(header), 1, Net);
    fwrite(&Ltime, sizeof(long), 1, Net);
    fwrite(&LocalNode, sizeof(LocalNode), 1, Net);
    fwrite(&FidoNode, sizeof(FidoNode), 1, Net);
    fwrite(&FidoNet, sizeof(FidoNet), 1, Net);
    fwrite(&FidoZone, sizeof(FidoZone), 1, Net);
    fwrite(Version, 4, 1, Net);
    fwrite(Ldata, Log_Count * sizeof(log_entry), 1, Net);
    fclose(Net);
    sprintf(bb, "%s/NETSEX.DAT", path);
    time(&Ltime);
    Net = fopen(bb, "w+b");
    fwrite(&Ltime, sizeof(long), 1, Net);
    fclose(Net);
  } else {
    sprintf(bb, "%s/NETSEX.DAT", path);
    Log = fopen(bb, "w+b");
    fwrite(&Ltime, sizeof(Ltime), 1, Log);
    fwrite(Ldata, Log_Count * sizeof(log_entry), 1, Log);
    fclose(Log);
  }
  free(Ldata);
}

void Faddress(Buffer)
  char *Buffer;
{
  int x;
  int y;
  int g;

  char Pflag = 0;
  x = 0;
  y = x;
  g = strlen(Buffer);
  Zone = FidoZone;
  FNet = FidoNet;
  FNode = FidoNode;
  Point = 0;
  do {
    switch (Buffer[x]) {
    case ':':
      Buffer[x] = 0;
      Zone = atoi(&Buffer[y]);
      x++;
      y = x;
      break;
    case '/':
      Buffer[x] = 0;
      FNet = atoi(&Buffer[y]);
      x++;
      y = x;
      break;
    case '.':
      Pflag = 1;
      Buffer[x] = 0;
      FNode = atoi(&Buffer[y]);
      x++;
      y = x;
      break;
    case 0:
      if (Pflag == 0) {
        FNode = atoi(&Buffer[y]);
      } else {
        Point = atoi(&Buffer[y]);
      }
      x++;
      y = x;
      break;
    default:
      x++;
      break;
    }
  } while (g > x - 1);
}

void TextLogEntry(entrystring)                   /* v2.00 */
  char *entrystring;
{
  char s2[160];
  int x, y;

  if (TextLog == -1) {
    sprintf(s2, "%sNETSEX.LOG", logdir);
    TextLog = open(s2, O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    if (TextLog > 0) {
      gettime(&timep);
      getdate(&datep);
      lseek(TextLog, 0L, SEEK_END);
      sprintf(s2, "NETSEX Log Entry for %02d/%02d/%02d at %02d:%02d:%02d.\r\n",
              datep.da_mon, datep.da_day, datep.da_year,
              timep.ti_hour, timep.ti_min, timep.ti_sec);
      write(TextLog, (void *) (&s2), strlen(s2));
      y = strlen(s2);
      for (x = 0; x < (y-2); x++)
        s2[x] = '=';
      write(TextLog, (void *) (&s2), strlen(s2));
    }
  }
  sprintf(s2, "%s\r\n", entrystring);
  write(TextLog, (void *) (&s2), strlen(s2));
}

void CloseTextLog()                              /* v2.00 */
{
  char s1[3];

  if (TextLog != -1) {
    s1[0] = 13;
    s1[1] = 10;
    s1[2] = 0;
    write(TextLog, (void *) (&s1), strlen(s1));
    close(TextLog);
  }
  TextLog = -1;
}

void ZapAddr(Buffer)                                       /* v2.00 */
char *Buffer;
{
  int x;
  int start;

  x = strlen(Buffer);
  start = 0;
  Zone = FidoZone;
  FNet = FidoNet;
  FNode = FidoNode;
  Point = 0;
  do {
    switch (Buffer[x]) {
      case ')':
      case '@':
        start=1;
        Buffer[x] = 0;
        x--;
        break;
      case '.':
        if (start) {
          Point = atoi(&Buffer[x+1]);
          Buffer[x] = 0;
        }
        x--;
        break;
      case '/':
        if (start) {
          FNode = atoi(&Buffer[x+1]);
          Buffer[x] = 0;
        }
        x--;
        break;
      case ':':
        if (start) {
          FNet = atoi(&Buffer[x+1]);
          Buffer[x] = 0;
        }
        x--;
        break;
      case '(':
        if (start) {
          Zone = atoi(&Buffer[x+1]);
          Buffer[x] = 0;
          x=0;
        }
        x--;
        break;
      default:
        x--;
        break;
    }
  } while ( x > 0 );
}
