MTBAV23 -- Autoval updated for 4.23!
``Midnight Tree Bandit`` WWIVlink #1 AT 18411
Tue Dec 07 18:44:14 1993
0R: net33: @4056 (via @4061) [08:41 12/10/93]
0R: net33: @4050 (via @4064) [05:33 12/10/93]
0R: net33: @4064 (via @1040) [05:10 12/10/93]
0R: net33: @1040 (via @2050) [17:22 12/08/93]
0R: net34: @2050 [10:49 12/08/93]
0R: net34: @2050 (via @1040) [05:35 12/08/93]
0R: net33: @1040 (via @1023) [06:38 12/08/93]
0R: net33: @1023 (via @1023) [23:27 12/07/93]
0R: net33: @3454 [23:16 12/07/93]
0R: net33: @13468 (via @314) [22:49 12/07/93]
0R: net33: @314 (via @18407) [22:10 12/07/93]
0R: net33: @18407 [21:18 12/07/93]
0R: net33: @18407 (via @18411) [19:45 12/07/93]
0R: net33: @18411 [19:36 12/07/93]
    | 
    |   MTB's Enhanced Sysop Autovalidation Information, v2.3   (MTBAV23.MOD)
    |       A WWIV 4.23(+) modification 
    |          from Vaporware Enterprises Software Labs
    |          by Midnight Tree Bandit
----+-----------------------------------------------------------------------
    |   12/7/93  (not for amateurs)
     
Long long time ago, I installed Mr Bill's Sysop Autovalidation mod.  It was 
neat, it was useful, it was worth every penny I didn't pay for it.

When I was putting together the ModNet (and ModLink) collections and started 
getting lotsa visiting sysops, I became curious as to how many of these 
systems were non-net, how many Link, how many Net, and how many from other 
systems (they DO exist out there, folks).  So I decided to come up with a way 
to keep track of such things, without re-doing the entire user list, to boot.

Of course that was back in 4.11.  Now, with the new userrec format, adding 
new stuff is easy.  Since I first put this out several new ASV's have come 
along, most of which seem to be derived from this one or Etheral Cereal's 
(which was also derived from this), and now 4.23 has sysop autoval built into 
it.  However, the OPT_AUTOVAL is more than I like, and the OPT_SIMPLE_ASV is 
not quite enough.  Besides, I like mine just fine.

So with this third version, I've adapted my version to Wayne's use of 
OPT_SIMPLE_ASV.  Basically, this mod finds out the BBS type/network 
affiliation of the visiting sysop, gets the BBS name and so forth (for the 
note), and validates according to BBStype and network.  Previously the SL and 
AR's and such were hardcoded in, but now I'm using the set_autoval() function, 
which should make it easier to set up autoval conditions.

There are a lot of strings embedded in this code.  I'll leave it up to you to 
put them into the BBS.STR, since it's likely that no two boards has the same 
strings in the same place in the file.

Note that this does not qualify your board for the "official" ASV status that 
some networks seem to support (whatever that gets you besides "[ASV]" in 
BBSLIST).  I'm enough of an iconoclast that I don't particularly care whether 
I have those silly little letters after my BBS name in BBSLIST.

------------------------------------------------------------------------------
Legend:
     - is delete line
     + is add line
     ! is changed line
  [blank] is leave alone

Step 0: BACK UP YOUR SOURCE!!!  This time, I really mean it.  This one makes 
little changes all over everywhere.


I.   VARDEC.H --  Add the 'bbstype' variable to userrec, taking a piece out of 
     the 'res_char[]' string:

      sex;            /* user's sex */

    unsigned char
!      res_char[67],   /* bytes for more strings */
+      
+      bbstype[11];    /* visiting sysop BBS type */

    unsigned char
      age,            /* user's age */

Note that the 'bbstype' taken from the END of 'res_char'.  This is in case a 
later version of WWIV adds variables that would use part of the reserved 
bytes.  


II.  VARS.H -- Enable the OPT_SIMPLE_ASV by uncommenting the #define:

/* Enables simple sysop autovalidation
 * Enabling gives values set in INIT AutoVal F-10 to person who answers
 * 'yes' to the question, "Are you a WWIV Sysop?" */
#define OPT_SIMPLE_ASV


III.  NEWUSER.C -- Let the sysops tell you about themselves

    A.  Add 'void check_sysop(void)' just before 'void newuser(void)':
          
#ifdef OPT_SIMPLE_ASV
void check_sysop(void)          /* MTBAV23 -- check for sysophood */
{
  int i=0;
  long l;
  char s[11];
  
  nl();
  prt(5,get_string(1250));
  if (yn()) {
    i=1;
    nl();
    prt(5,get_string(1251));nl();
    mpl(60);
    inputl(thisuser.note,60);
    thisuser.exempt=31;          /* gives sysop all known exemptions */
    nl();
    pl("5Which type of BBS is this (VBBS systems");0
    pl("5in WWIV networks may select 2-6):");0
    pl("5  1. Plain WWIV (no net)");0
    pl("5  2. WWIVNet");0
    pl("5  3. WWIVLink");0
    pl("5  4. IceNet");0
    pl("5  5. Other WWIV Network (specify)");0
    pl("5  6. WWIV Multi-net)");0
    pl("5  7. Other BBS software (specify)");0
    pl("5  N. Never mind");0
    prt(2,"Pick 1-7,N: ");
    switch(onek("N1234567")) {
       case '1':
         strcpy(thisuser.bbstype,"WWIV NoNet");
       case '2':
         if (!thisuser.bbstype[0])
           strcpy(thisuser.bbstype,"WWIVNet");
       case '4':
         if (!thisuser.bbstype[0])
           strcpy(thisuser.bbstype,"IceNet");
       case '5':
         if (!thisuser.bbstype[0]) {
           nl();
           prt(2,"Which WWIV network? ");
           mpl(10);
           inputl(thisuser.bbstype,10);
         }
       case '6':
         nl();
         if (!thisuser.bbstype[0])
           strcpy(thisuser.bbstype,"Multi-net");
         set_autoval(8);            /* set all cases above to ALT-F9 */
       case '3':
         if (!thisuser.bbstype[0]) {
            strcpy(thisuser.bbstype,"WWIVLink");
            set_autoval(9);         /* WWIVLink is slightly different, */
          }                         /* so set to ALT-F10 */

         /* Settings for all the above cases */
         prt(5,"WWIV registration number (0 or <cr> for none): ");
         mpl(5);
         input(s,5);
         if (s[0]) {
           l=atol(s);
           if ((s[0]) && (l>=0))
             thisuser.wwiv_regnum = l;
         } else thisuser.wwiv_regnum=0L;
         thisuser.sysstatus ^= sysstatus_expert;  /* turn off menu */
         existprint("asv1");        /* ASV1.MSG/ANS msg for WWIV sysops */
         pausescr();
         break;
       case '7':  /*  non-WWIV sysop */
         nl();
         prt(2,"What is your BBS software? ");
         mpl(10);
         inputl(thisuser.bbstype,10);
         set_autoval(7);             /* set to ALT-F8 */
         existprint("asv2");         /* ASV2.MSG/ANS for non-WWIV sysops */
         pausescr();
         break;
       case 'N':
         i=0;nl();break;
    }
  } 
  if (!i) {
    thisuser.sl=syscfg.newusersl;       /* resets to default user setup */
    thisuser.dsl=syscfg.newuserdsl;
    thisuser.restrict=syscfg.newuser_restrict;
    thisuser.note[0]=0;
    thisuser.bbstype[0]=0;
    thisuser.ar=0;
    thisuser.dar=0;
    thisuser.wwiv_regnum=0L;
    topscreen();
  }
}
#endif

Note on this routine:
    This is the framework.  It does what the MTB's does: gets the BBS name, 
    the BBS type or network, and sets the 'bbstype', SL/DSL, and suchlike 
    according to the software/network.  If the user is a non-WWIV sysop, it 
    gets the name of the software and sends a note.  Note that control falls 
    through the first six cases (i.e. no 'break' statements).  That's because 
    all WWIV sysops get the same treatment (except for the Link sysops getting 
    and AR and DAR, hence the different ALT-Fkey).  You could probably figure 
    out from here what else to do to further make it suit your needs.  I won't 
    go into detail on what the MTB does here.  Suffice to say that this 
    framework should allow you to do anything, including adding/subtracting 
    choices and assigning a different ALT-Fkey to each one.  It's up to you.
    
    Note also that you need two .MSG files in your GFILES directory 
    (ASV1.MSG/ANS and ASV2.MSG), though the new 'existprint' removes the "File 
    not found" message we used to get with 'printfile'.  Anyway, you may, of 
    course, change this as well.
    
    Hmm, it strikes me this could work for those supporting software...

     
    B.  In 'void newuser', change the stuff within the #ifdef OPT_SIMPLE_ASV 
        directive to look like this:
     
#ifndef OPT_AUTOVAL
#ifdef OPT_SIMPLE_ASV
    if ((syscfg.autoval[9].sl>syscfg.newusersl) &&
        (syscfg.autoval[9].sl<100)) 
      check_sysop();
#endif
#endif

    Radical change, eh?

    
    C.  Now to show the user's sysop status (if any) in the list of options 
         to change.  A little farther down in 'void newuser(void)', make these 
         changes (this gets really messy):

       outstr(get_string(580)); npr("%d X %d\r\n",
         thisuser.screenchars, thisuser.screenlines);
       outstr(get_string(581)); pl(thisuser.pw);
+#ifdef OPT_SIMPLE_ASV
+      outstr("A. Sysop?        :");
+      if (thisuser.bbstype[0]!=0)
+         npr(" Y (%s, Reg #%ld)\r\n",thisuser.bbstype,thisuser.wwiv_regnum);
+        else
+         pl(" N");
+#endif
       if (syscfg.sysconfig & sysconfig_extended_info) {
         outstr(get_string(582)); pl(thisuser.street);
         outstr(get_string(583)); pl(thisuser.city);
         
    NOTE: Since this goes in as new option 'A', you MUST go into your strings 
    editor (ESM is great, miniesm will be fine) and change the option letters 
    for strings 582-587, changing "A" to "B", "B" to "C", and so forth.  Note 
    also the use of OPT_SIMPLE_ASV.  I use it as much as possible here, in case
 
    you decide to "turn off" the ASV temporarily because of abuse of the 
    feature.  Just re-comment the #define OPT_SIMPLE_ASV in VARS.H.

    
    D.  Now to fix the prompts:
    
       if (syscfg.sysconfig & sysconfig_extended_info) {
         prt(2,get_string(589));
 #ifdef OPT_CALLBACK
!        ch=onek("Q123456789ABCDEF");       /* Add "F" */
 #else
!        ch=onek("Q123456789ABCDEFG");      /* add "G" */
 #endif
       } else {
         prt(2,get_string(590));
!        ch=onek("Q123456789A");             /* add "A" */
       }

    NOTE (again): Strings 589 and 590 are the prompt strings, and should also 
    be changed to reflect the shift in the option letters.  The main reason 
    for all this shifting is that I did not want to have the options skip from 
    "9" to "G" when printed out.  No OPT_SIMPLE_ASV here because code 
    elsewhere makes sure nothing happens anyway when they hit "A" and the 
    option is off.


    E.  Now, if they want to change it (and to fix the rest):

         case '8': input_screensize(); break;
         case '9': input_pw(); break;
+#ifdef OPT_SIMPLE_ASV
+        case 'A': check_sysop(); break;
+#else
+        case 'A': break;
+#endif
!        case 'B': input_street(); break;
!        case 'C': input_city(); break;
!        case 'D': input_state(); break;
!        case 'E': input_country(); break;
!        case 'F': input_zipcode(); break;
 #ifndef OPT_CALLBACK
!        case 'G': input_dataphone(); break;
 #endif
       }
     } while ((!ok) && (!hangup));
     

    F.  Now, send a note to the sysop and put it in the sysop log:

     write_user(usernum,&thisuser);
     write_qscn(usernum, qsc, 0);
     isr(usernum,thisuser.name);
+    if (thisuser.bbstype[0]==0)
+      sprintf(s, "**} %s registered on %s.",nam(&thisuser,usernum),date());
+     else
+      sprintf(s,">>> %s registered as %s sysop on %s",nam(&thisuser,usernum),t
hisuser.bbstype,date());
+    sl1(0,s);
+    ssm(1,0,s);
     ok=0;
     topscreen();
     

III.  UEDIT.C --  Now to edit the bbstype and BBS name in //UEDIT (not using 
OPT_SIMPLE_ASV because sysop may want to edit this even when disabled).

    A.  In 'void print_data(void)', show the BBS type:
     
     outstr(get_string(252)); pln(u->lastrate);
   }
+  if (u->bbstype[0])
+    outstr("BBS : "); pl(u->bbstype);
   if (u->note[0]) {
     outstr(get_string(253)); pl(u->note);
   }


    B.  In 'void uedit(void)', add the choice for selecting BBStype:
     
       print_data(un,&u, ((full) || (temp_full)), cls);
       nl();
       prt(2,get_string(266));
+      if ((thisuser.sl==255) || (wfc))
+        ch=onek("ABCDEGILMNOPQRSTUXYZ0123456789[]{}/,.?~%:");   /* add "B" */
+      else
+        ch=onek("ABCDEGILMNOPQRSTUYZ0123456789[]{}/,.?%");      /* Add "B" */
       switch(ch) {
         case 'A':


    C.  Now add the case for it in 'void uedit(void)' (after "case ':':", at 
         the end, would be fine):

        case 'B':
          nl();
          pl("1) WWIV (no nets); 2) WWIVLink; 3) WWIVNet; 4) IceNet;");
          pl("5) Other WWIV Network (specify); 6) WWIV Multinet;");
          pl("7) Other software; N)one; or L)eave it.");
          nl();outstr("Which (1-7,N,L)? ");
          switch(onek("LN1234567")) {
            case '1':
               strcpy(u.bbstype,"WWIV NoNet"); break;
            case '2':
               strcpy(u.bbstype,"WWIVLink"); break;
            case '3':
               strcpy(u.bbstype,"WWIVNet"); break;
            case '4':
               strcpy(u.bbstype,"ICENet"); break;
            case '5':
              nl();
              prt(2,"Which WWIV Network (10 char max)?");
              mpl(10);
              inputl(u.bbstype,10);
              break;
            case '6':
               strcpy(u.bbstype,"Multi-net"); break;
            case '7':
              nl();
              prt(2,"What is the BBS software (10 char max)?");
              mpl(10);
              inputl(u.bbstype,10);
              break;
            case 'N':
              u.bbstype[0]=0; break;
            case 'L':
              break;
          }
          prt(2,"Don't forget to update the SL, DSL, Note, ");nl();
          prt(2,"and other info accordingly."); nl();
          pausescr();
          write_user(un,&u);
          break;



IV.  SYSOPF.C -- Editing the bbstype and BBS name when validating users

    This is for the "V" option from the e-mail and sub scanning prompts.

    A.  In 'void valuser(int un)', near the top, add this:
     
     npr("PH  : %s\r\n",(u.phone));
     npr("Age : %d %c\r\n", u.age, u.sex);
     npr("Comp: %s\r\n",&(ctypes[u.comp_type][0]));
+    if (u.bbstype[0])
+      npr("BBS : %s\r\n",u.bbstype);
     if (u.note[0])
       npr("Note: %s\r\n",u.note);
     nl();


    B.  A bit farther down, add the following
     
         printmenu(10);
       }
     } while ((!hangup) && (ch1==0));
+    if (u.sl>=50) {    /* this assumes your lowest visiting sysop SL is 50 */
+      nl();
+      if (u.bbstype[0])
+        npr("BBS : %s\r\n",u.bbstype);
+      pl("1) WWIV (no nets); 2) WWIVLink; 3) WWIVNet; 4) IceNet;");
+      pl("5) Other WWIV Network (specify); 6) WWIV Multinet;");
+      pl("7) Other software; N)one; or L)eave it alone:");
+      nl();outstr("Which (1-7,N,L)? ");
+      switch(onek("LN1234567")) {
+        case '1':
+           strcpy(u.bbstype,"WWIV NoNet"); break;
+        case '2':
+           strcpy(u.bbstype,"WWIVLink"); break;
+        case '3':
+           strcpy(u.bbstype,"WWIVNet"); break;
+        case '4':
+           strcpy(u.bbstype,"ICENet"); break;
+        case '5':
+          nl();
+          prt(2,"Which WWIV Network (10 char max)?");
+          mpl(10);
+          inputl(u.bbstype,10);
+          break;
+        case '6':
+           strcpy(u.bbstype,"Multi-net"); break;
+        case '7':
+          nl();
+          prt(2,"What is the BBS software (10 char max)?");
+          mpl(10);
+          inputl(u.bbstype,10);
+          break;
+        case 'N':
+          u.bbstype[0]=0; 
+          break;
+        case 'L':
+          break;
+      }
+      nl();
+      if (u.note[0]) {
+        npr("BBS Name/Node/Number: %s\r\n",u.note);
+        nl();
+      }
+      nl();
+      outstr("Enter BBS Name/Phone (<cr> to leave): ");
+      inputl(s,39);
+      if (s[0])
+        strcpy(u.note,s);
+    }
     write_user(un,&u);
     nl();
   } else {



V.  CONIO.C -- Showing it in the top-screen data

    A.  This will show the first 7 characters of thisuser.bbstype, if there 
        is one.  Otherwise it will show the WWIV registration number or call
        sign, as already set up.  Go to 'void topscreen(void)'and make these 
        changes under "case 2:" of the "switch (topdata)" block:
     
      movecsr(0,1);
+     if (thisuser.bbstype[0])
+       strcpy(calls,thisuser.bbstype);
+      else  
        if (thisuser.wwiv_regnum)
          sprintf(calls,"%lu",thisuser.wwiv_regnum);
         else
          strcpy(calls,thisuser.callsign);
!     sprintf(ol,"%-20s %12s %-7.7s DL=%4d/%6ld DL=%3d TO=%5.0ld ES=%4d",
          thisuser.realname,thisuser.phone,calls,
          thisuser.downloaded,thisuser.dk,thisuser.dsl,
          ((long) ((thisuser.timeon+timer()-timeon)/60.0)),
          thisuser.emailsent+thisuser.emailnet);
      outs(ol);

Note: in the 'sprintf(...)' you're changing the "%-6s" to "%-7.7s".  This 
guarantees that the BBS type will be truncated, since it if weren't, it could 
throw the whole line off.
------------------------------------------------------------------------------

And that's it!  That's all you need to have a means of keeping track of your 
visiting sysops.  

The All New Vaporware CYA Disclaimer:
    This mod is copyright 1992, 1993 by Wayne Heyward, aka Midnight Tree 
    Bandit, and is distributed as freeware.  Permission is granted to 
    distribute and post this mod on BBS systems and online services, provided 
    no alterations are made (removal of message headers/taglines allowed).  
    May contain some parts of WWIV source code, which is copyright 1988-1993 
    by Wayne Bell and licensed only to registered users of WWIV.  Use of WWIV 
    source without registration constitutes a license violation and could lead 
    to legal prosecution and certain doom.

    Shareware distributors and CD-ROM publishers may not distribute without 
    express written permission of the Author or WWIV Software Services.

[I highly recommend you add this to all your mods.  It keeps us safe, and it 
makes sure others will not profit from our work.]

Need help?  You can find me here:
    WWIVLink: #1 @18411 (The Many Titled Board)
    IceNET:   #1 @8411  ( "   "     "      "  )
    WWIVnet:  #2 @8408  (The Vaporboard)
    GEnie:    TREE.BANDIT (from time to time)
    Internet: tree.bandit@genie.geis.com
