JAFO17C.MOD - Enhanced Configure Q-Scan and N-Scan Mod
JAFO #1 @8861
Tue Dec 07 17:03:57 1993
0R: net33: @4056 (via @4061) [08:41 12/10/93]
0R: net33: @4050 (via @4064) [05:33 12/10/93]
0R: net33: @4064 (via @1040) [05:10 12/10/93]
0R: net33: @1040 (via @2050) [17:22 12/08/93]
0R: net34: @2050 [10:49 12/08/93]
0R: net34: @2050 (via @1040) [05:03 12/08/93]
0R: net33: @1040 (via @1) [06:01 12/08/93]
0R: net34: @1 (via @8856) [01:59 12/08/93]
0R: net33: @8856 (via @8861) [18:01 12/07/93]
0R: net33: @8861 [17:06 12/07/93]
Ŀ
 Mod Name      : JAFO17C.MOD              Mod Author: JAFO 1@1     TerraNET 
 Difficulty    : ۱                                1@8861  WWIVnet  
 WWIV Version  : 4.23                                      1@8857  IceNET   
 Mod Date      : 12/07/93                                  1@8857  SOLARnet 
 Files Affected: DEFAULTS.C, XFEROVL.C, FCNS.H             1@18857 WWIVLink 
 Description   : Enhanced Configure Q-Scan and N-Scan Mod                   


[ Description ]

This mod will greatly enhance your q-scan and n-scan configuration routines.
Instead of having those routines scroll down your screen, which is very
annoying, this mod keeps everything on the same screen.  If you have more
than 64 subs or dirs, you can easily page to the next or previous 64 subs
or dirs.  It will work with up to 999 subs or dirs.

Note:  This mod was originally done by Untouchable #1 @9804 WWIVnet.  The mod
       name was ANSICFG.MOD.  It was written prior to WWIV v4.22, and did not
       contain the configure n-scan or paging code.  The current 1@9804 is not
       the original author.

       This mod was re-done by Frank Reid #1 @870 WWIVnet for WWIV v4.22, but
       it was basically a straight conversion of the original mod.  Mine is a
       complete configure q-scan and n-scan mod that will work with up to 999
       subs and dirs.

Revision A Note:  Added ability to change the display from 3 columns to 2 for
                  both the q-scan and n-scan configurations.

Revision B Note:  Added ability to add/remove all subs/dirs on the current
                  page.

Revision C Note:  Added WWIV v4.23 compatibility.  Works with conferencing.

[ Legend ]

  =  Existing line - Do not change
  +  Add this line
  -  Remove this line

[ Step 1 ]

Please back up your source code.  Even the best programmers make mistakes.

[ Step 2 ]

If you would like to have a two column listing for the q-scan configuration
screen, do this step.  Otherwise skip to Step 3 and the default three columns
will be used.

In DEFAULTS.C, add the following lines near the top:

= #include "vars.h"
=
= #pragma hdrstop
=
+ #define TWO_COLUMN_QSCAN
+
=
= void select_editor(void)

[ Step 3 ]

In DEFAULTS.C, delete the following two functions:

void l_config_qscan()
void config_qscan()

[ Step 4 ]

Now block copy the following functions and insert them into DEFAULTS.C before
"void list_macro":

void clear(int x)
{
  int i;

  ansic(2);
  for (i=0; i<x; i++)
    outchr(32);
  for (i=0; i<x; i++)
    outstr("\b");
}


void indicator_only(int base)
{
  int i,xc,yc,col;
  char s[5];

  xc=0;
  yc=3;
  col=0;
  goxy(0,0);
#ifdef TWO_COLUMN_QSCAN
  for (i=base; (i<base+42) && (i<num_subs) && (usub[i].subnum!=-1); i++) {
#else
  for (i=base; (i<base+63) && (i<num_subs) && (usub[i].subnum!=-1); i++) {
#endif
    sprintf(s,"5%c",
      (qsc_q[usub[i].subnum/32]&(1L<<(usub[i].subnum%32)))?'':' ');
    goxy(xc,yc);
    outstr(s);
    if (yc!=23)
      yc++;
    else {
      yc=3;
      col++;
    }
#ifdef TWO_COLUMN_QSCAN
    if (col==1)
      xc=40;
#else
    if (col==1)
      xc=27;
    if (col==2)
      xc=53;
#endif
  }
  goxy(3,0);
  clear(3);
}


int l_config_qscan(int base)
{
  int i,count,xc,yc,col,pause,abort;
  char s[81];

  if (okansi()) {
    if (thisuser.sysstatus & sysstatus_pause_on_page) {
      thisuser.sysstatus &= ~sysstatus_pause_on_page;
      pause=1;
    } else
      pause=0;
    count=0;
    outchr(12);
    outstr("1?           1Sub Config  1A9ll, 1C9lear, 1N9ext Page, "
           "1P9revious Page, 1Q9uit, 1?9=Redraw");
    xc=0;
    yc=3;
    col=0;
#ifdef TWO_COLUMN_QSCAN
    for (i=base; (i<base+42) && (i<num_subs) && (usub[i].subnum!=-1); i++) {
      if (i<100)
        sprintf(s,"5%c1%2s: 9%.33s",
          (qsc_q[usub[i].subnum/32]&(1L<<(usub[i].subnum%32)))?'':' ',
          usub[i].keys,
          subboards[usub[i].subnum].name);
      else
        sprintf(s,"5%c1%s: 9%.32s",
          (qsc_q[usub[i].subnum/32]&(1L<<(usub[i].subnum%32)))?'':' ',
          usub[i].keys,
          subboards[usub[i].subnum].name);
#else
    for (i=base; (i<base+63) && (i<num_subs) && (usub[i].subnum!=-1); i++) {
      if (i<100)
        sprintf(s,"5%c1%2s: 9%.20s",
          (qsc_q[usub[i].subnum/32]&(1L<<(usub[i].subnum%32)))?'':' ',
          usub[i].keys,
          subboards[usub[i].subnum].name);
      else
        sprintf(s,"5%c1%s: 9%.19s",
          (qsc_q[usub[i].subnum/32]&(1L<<(usub[i].subnum%32)))?'':' ',
          usub[i].keys,
          subboards[usub[i].subnum].name);
#endif
      goxy(xc,yc);
      outstr(s);
      count++;
      if (yc!=23)
        yc++;
      else {
        yc=3;
        col++;
      }
#ifdef TWO_COLUMN_QSCAN
      if (col==1)
        xc=40;
#else
      if (col==1)
        xc=27;
      if (col==2)
        xc=53;
#endif
    }
    goxy(3,0);
    clear(3);
    if (pause)
      thisuser.sysstatus |= sysstatus_pause_on_page;
    return(count);
  } else {
    abort=0;
    nl();
    pl(get_string(441));
    nl();
    for (i=0; (i<num_subs) && (usub[i].subnum!=-1) && (!abort); i++) {
      sprintf(s,"%c [%s] %s",
        (qsc_q[usub[i].subnum/32]&(1L<<(usub[i].subnum%32)))?'*':' ',
        usub[i].keys,
        subboards[usub[i].subnum].name);
      pla(s,&abort);
    }
    return(0);
  }
}


void config_qscan(void)
{
  char *s, s1[MAX_CONFERENCES+2], s2[120], ch;
  int i,i1,done,done1,oc,os,abort=0,user_subs,ok,base;

  done=done1=0;
  oc=curconfsub;
  os=usub[cursub].subnum;

  do {
    if ((okconf(&thisuser)) && (uconfsub[1].confnum!=-1)) {
      abort=0;
      strcpy(s1," ");
      if (okansi()) {
        outchr(12);
        ansic(2);
      } else
      ansic(2);
      pl(get_string(1150));
      nl();
      i=0;
      while ((i<subconfnum) && (uconfsub[i].confnum!=-1) && (!abort)) {
        sprintf(s2,"1%c7) 9%s",subconfs[uconfsub[i].confnum].designator,
          stripcolors(subconfs[uconfsub[i].confnum].name));
        pla(s2,&abort);
        s1[i+1]=subconfs[uconfsub[i].confnum].designator;
        s1[i+2]=0;
        i++;
      }
      nl();
      if (okansi())
        ansic(2);
      outstr(get_string(1082));
      outstr(&s1[1]);
      outstr(get_string(1083));
      ch=onek(s1);
    } else
      ch='-';
    switch (ch) {
      case ' ':
        done1=1;
        break;
      default:
        if ((okconf(&thisuser)) && (uconfsub[1].confnum!=-1)) {
          i=0;
          while ((ch!=subconfs[uconfsub[i].confnum].designator) &&
                 (i<subconfnum))
            i++;

          if (i>=subconfnum)
            break;

          setuconf(CONF_SUBS, i, -1);
        }
        if (okansi()) {
          base=0;
          i1=l_config_qscan(base);
          user_subs=0;
          for (i=0; (i<num_subs) && (usub[i].subnum!=-1); i++)
            user_subs++;
        } else
          l_config_qscan(0);
        done=0;
        do {
          if (okansi())
            ansic(2);
          else {
            nl();
            outstr(get_string(1151));
          }
          s=mmkey(0);
          if (okansi()) {
            ok=0;
            if ((s[0]) && (atoi(s)>base) &&
#ifdef TWO_COLUMN_QSCAN
              (atoi(s)<=((base+42)>=user_subs?user_subs:base+42))) {
              for (i=base; (i<base+42) && (i<num_subs) &&
                   (usub[i].subnum!=-1); i++) {
#else
              (atoi(s)<=((base+63)>=user_subs?user_subs:base+63))) {
              for (i=base; (i<base+63) && (i<num_subs) &&
                   (usub[i].subnum!=-1); i++) {
#endif
                if (strcmp(usub[i].keys,s)==0) {
                  qsc_q[usub[i].subnum/32] ^= (1L<<(usub[i].subnum%32));
                  indicator_only(base);
                  ok=1;
                }
              }
            }
            if (strcmp(s,"Q")==0) {
              if ((!okconf(&thisuser)) || (uconfsub[1].confnum==-1))
                goxy(0,i1>=21?24:i1+3);
              done=1;
              ok=1;
            }
            if (strcmp(s,"N")==0) {
#ifdef TWO_COLUMN_QSCAN
              if (base+42<=user_subs) {
                base+=42;
#else
              if (base+63<=user_subs) {
                base+=63;
#endif
                i1=l_config_qscan(base);
                ok=1;
              }
            }
            if (strcmp(s,"P")==0) {
#ifdef TWO_COLUMN_QSCAN
              if (base-42>=0) {
                base-=42;
#else
              if (base-63>=0) {
                base-=63;
#endif
                i1=l_config_qscan(base);
                ok=1;
              }
            }
            if (strcmp(s,"A")==0) {
#ifdef TWO_COLUMN_QSCAN
              for (i=base; i<base+42 && i<num_subs && usub[i].subnum!=-1; i++)
#else
              for (i=base; i<base+63 && i<num_subs && usub[i].subnum!=-1; i++)
#endif
                qsc_q[usub[i].subnum/32] |= (1L<<(usub[i].subnum%32));
              indicator_only(base);
              ok=1;
            }
            if (strcmp(s,"C")==0) {
#ifdef TWO_COLUMN_QSCAN
              for (i=base; i<base+42 && i<num_subs && usub[i].subnum!=-1; i++)
#else
              for (i=base; i<base+63 && i<num_subs && usub[i].subnum!=-1; i++)
#endif
                qsc_q[usub[i].subnum/32] &= ~(1L<<(usub[i].subnum%32));
              indicator_only(base);
              ok=1;
            }
            if (strcmp(s,"?")==0) {
              i1=l_config_qscan(base);
              ok=1;
            }
            if (!ok) {
              goxy(3,0);
              clear(3);
            }
          } else {
            if (s[0]) {
              for (i=0; (i<num_subs) && (usub[i].subnum!=-1); i++) {
                if (strcmp(usub[i].keys,s)==0) {
                  qsc_q[usub[i].subnum/32] ^= (1L<<(usub[i].subnum%32));
                }
                if (strcmp(s,"S")==0) {
                  qsc_q[usub[i].subnum/32] |= (1L<<(usub[i].subnum%32));
                }
                if (strcmp(s,"C")==0) {
                  qsc_q[usub[i].subnum/32] &= ~(1L<<(usub[i].subnum%32));
                }
              }
              if (strcmp(s,"Q")==0)
                done=1;
              if (strcmp(s,"?")==0)
                l_config_qscan(0);
            }
          }
        } while ((!done) && (!hangup));
        break;
    }
    if ((!okconf(&thisuser)) || (uconfsub[1].confnum==-1))
      done1=1;

  } while ((!done1) && (!hangup));

  if (okconf(&thisuser))
    setuconf(CONF_SUBS, oc, os);
}

[ Step 5 ]

If you would like to have a two column listing for the n-scan configuration
screen, do this step.  Otherwise skip to Step 6 and the default three columns
will be used.

In XFEROVL.C, add the following line near the top:

= #include "vars.h"
=
= #pragma hdrstop
=
= #include <dir.h>
=
+ #define TWO_COLUMN_NSCAN
=

[ Step 6 ]

In XFEROVL.C, delete the following two functions:

void l_config_nscan(void)
void config_nscan(void)

[ Step 7 ]

Now block copy the following functions and insert them into XFEROVL.C before
"void xfer_defaults":

void nscan_indicator_only(int base)
{
  int i,xc,yc,col;
  char s[5];

  xc=0;
  yc=3;
  col=0;
  goxy(0,0);
#ifdef TWO_COLUMN_NSCAN
  for (i=base; (i<base+42) && (i<num_dirs) && (udir[i].subnum!=-1); i++) {
#else
  for (i=base; (i<base+63) && (i<num_dirs) && (udir[i].subnum!=-1); i++) {
#endif
    sprintf(s,"5%c",
      (qsc_n[udir[i].subnum/32]&(1L<<(udir[i].subnum%32)))?'':' ');
    goxy(xc,yc);
    outstr(s);
    if (yc!=23)
      yc++;
    else {
      yc=3;
      col++;
    }
#ifdef TWO_COLUMN_NSCAN
    if (col==1)
      xc=40;
#else
    if (col==1)
      xc=27;
    if (col==2)
      xc=53;
#endif
  }
  goxy(3,0);
  clear(3);
}


void l_config_nscan(int base)
{
  int i,xc,yc,col,pause,abort;
  char s[81];

  if (okansi()) {
    if (thisuser.sysstatus & sysstatus_pause_on_page) {
      thisuser.sysstatus &= ~sysstatus_pause_on_page;
      pause=1;
    } else
      pause=0;
    outchr(12);
    outstr("1?           1Dir Config  1A9ll, 1C9lear, 1N9ext Page, "
           "1P9revious Page, 1Q9uit, 1?9=Redraw");
    xc=0;
    yc=3;
    col=0;
#ifdef TWO_COLUMN_NSCAN
    for (i=base; (i<base+42) && (i<num_dirs) && (udir[i].subnum!=-1); i++) {
      if (i<100)
        sprintf(s,"5%c1%2s: 9%.33s",
          (qsc_n[udir[i].subnum/32]&(1L<<(udir[i].subnum%32)))?'':' ',
          udir[i].keys,
          directories[udir[i].subnum].name);
      else
        sprintf(s,"5%c1%s: 9%.32s",
          (qsc_n[udir[i].subnum/32]&(1L<<(udir[i].subnum%32)))?'':' ',
          udir[i].keys,
          directories[udir[i].subnum].name);
#else
    for (i=base; (i<base+63) && (i<num_dirs) && (udir[i].subnum!=-1); i++) {
      if (i<100)
        sprintf(s,"5%c1%2s: 9%.20s",
          (qsc_n[udir[i].subnum/32]&(1L<<(udir[i].subnum%32)))?'':' ',
          udir[i].keys,
          directories[udir[i].subnum].name);
      else
        sprintf(s,"5%c1%s: 9%.19s",
          (qsc_n[udir[i].subnum/32]&(1L<<(udir[i].subnum%32)))?'':' ',
          udir[i].keys,
          directories[udir[i].subnum].name);
#endif
      goxy(xc,yc);
      outstr(s);
      if (yc!=23)
        yc++;
      else {
        yc=3;
        col++;
      }
#ifdef TWO_COLUMN_NSCAN
      if (col==1)
        xc=40;
#else
      if (col==1)
        xc=27;
      if (col==2)
        xc=53;
#endif
    }
    goxy(3,0);
    clear(3);
    if (pause)
      thisuser.sysstatus |= sysstatus_pause_on_page;
  } else {
    abort=0;
    nl();
    pl(get_string(802));
    nl();
    for (i=0; (i<num_dirs) && (udir[i].subnum!=-1) && (!abort); i++) {
      sprintf(s,"%c [%s] %s",
        (qsc_n[udir[i].subnum/32]&(1L<<(udir[i].subnum%32)))?'*':' ',
        udir[i].keys,
        directories[udir[i].subnum].name);
      pla(s,&abort);
    }
  }
}


void config_nscan(void)
{
  char *s,s1[MAX_CONFERENCES+2],s2[120],ch;
  int i,i1,i2,done,done1,oc,os,abort=0,user_dirs,ok,base;

  done=done1=0;
  oc=curconfdir;
  os=udir[curdir].subnum;

  do {
    if ((okconf(&thisuser)) && (uconfdir[1].confnum!=-1)) {
      abort=0;
      strcpy(s1," ");
      if (okansi()) {
        outchr(12);
        ansic(2);
      } else
        nl();
      pl(get_string(1358));
      nl();
      i=0;
      while ((i<dirconfnum) && (uconfdir[i].confnum!=-1) && (!abort)) {
        sprintf(s2,"1%c7) 9%s",dirconfs[uconfdir[i].confnum].designator,
          stripcolors(dirconfs[uconfdir[i].confnum].name));
        pla(s2,&abort);
        s1[i+1]=dirconfs[uconfdir[i].confnum].designator;
        s1[i+2]=0;
        i++;
      }
      nl();
      if (okansi())
        ansic(2);
      outstr(get_string(1082));
      outstr(&s1[1]);
      outstr(get_string(1083));
      ch=onek(s1);
    } else
      ch='-';
    switch (ch) {
      case ' ':
        done1=1;
        break;
      default:
        if ((okconf(&thisuser)) && (dirconfnum>1)) {
          i=0;
          while ((ch!=dirconfs[uconfdir[i].confnum].designator) &&
                 (i<dirconfnum))
            i++;
          if (i>=dirconfnum)
            break;

          setuconf(CONF_DIRS, i, -1);
        }
        if (okansi()) {
          base=0;
          l_config_nscan(base);
          user_dirs=0;
          for (i=0; (i<num_dirs) && (udir[i].subnum!=-1); i++)
            user_dirs++;
        } else
          l_config_nscan(0);
        done=0;
        do {
          if (okansi())
            ansic(2);
          else {
            nl();
            outstr(get_string(1359));
          }
          if (okansi())
            ok=0;
          s=mmkey(1);
          if (okansi()) {
            if ((s[0]) && (atoi(s)>=base) &&
#ifdef TWO_COLUMN_NSCAN
              (atoi(s)<((base+42)>=user_dirs?user_dirs:base+42))) {
              for (i=base; i<base+42 && i<num_dirs &&
                   udir[i].subnum!=-1; i++) {
#else
              (atoi(s)<((base+63)>=user_dirs?user_dirs:base+63))) {
              for (i=base; i<base+63 && i<num_dirs &&
                   udir[i].subnum!=-1; i++) {
#endif
                if (strcmp(udir[i].keys,s)==0) {
                  qsc_n[udir[i].subnum/32] ^= (1L<<(udir[i].subnum%32));
                  nscan_indicator_only(base);
                  ok=1;
                }
              }
            }
            if (strcmp(s,"Q")==0) {
              done=1;
              ok=1;
            }
            if (strcmp(s,"N")==0) {
#ifdef TWO_COLUMN_NSCAN
              if (base+42<=user_dirs) {
                base+=42;
#else
              if (base+63<=user_dirs) {
                base+=63;
#endif
                l_config_nscan(base);
                ok=1;
              }
            }
            if (strcmp(s,"P")==0) {
#ifdef TWO_COLUMN_NSCAN
              if (base-42>=0) {
                 base-=42;
#else
              if (base-63>=0) {
                base-=63;
#endif
                l_config_nscan(base);
                ok=1;
              }
            }
            if (strcmp(s,"A")==0) {
#ifdef TWO_COLUMN_NSCAN
              for (i=base; i<base+42 && i<num_dirs && udir[i].subnum!=-1; i++)
#else
              for (i=base; i<base+63 && i<num_dirs && udir[i].subnum!=-1; i++)
#endif
                qsc_n[udir[i].subnum/32] |= (1L<<(udir[i].subnum%32));
              nscan_indicator_only(base);
              ok=1;
            }
            if (strcmp(s,"C")==0) {
#ifdef TWO_COLUMN_NSCAN
              for (i=base; i<base+42 && i<num_dirs && udir[i].subnum!=-1; i++)
#else
              for (i=base; i<base+63 && i<num_dirs && udir[i].subnum!=-1; i++)
#endif
                qsc_n[udir[i].subnum/32] &= ~(1L<<(udir[i].subnum%32));
              nscan_indicator_only(base);
              ok=1;
            }
            if (strcmp(s,"?")==0) {
              l_config_nscan(base);
              ok=1;
            }
            if (!ok) {
              goxy(3,0);
              clear(3);
            }
          } else {
            if (s[0]) {
              for (i=0; i<num_dirs; i++) {
                i1=udir[i].subnum;
                if (strcmp(udir[i].keys,s)==0) {
                  qsc_n[i1/32] ^= 1L<<(i1%32);
                }
                if (strcmp(s,"S")==0) {
                  qsc_n[i1/32] |= 1L<<(i1%32);
                }
                if (strcmp(s,"C")==0) {
                  qsc_n[i1/32] = 0L;
                }
              }
              if (strcmp(s,"Q")==0)
                done=1;
              if (strcmp(s,"?")==0)
                l_config_nscan(0);
            }
          }
        } while ((!done) && (!hangup));
        break;
    }
    if ((!okconf(&thisuser)) || (uconfdir[1].confnum==-1))
      done1=1;
  } while ((!done1) && (!hangup));

  if (okconf(&thisuser))
    setuconf(CONF_DIRS, oc, os);
}

[ Step 8 ]

In FCNS.H, make the changes shown below:

= /* File: defaults.c */
=
= void select_editor(void);
= void print_cur_stat(void);
= char *cn(char c);
= char *describe(char col);
= void color_list(void);
= void change_colors(void);
+ void clear(int x);
+ void indicator_only(int base);
- void l_config_qscan(void);
+ int l_config_qscan(int base);
= void config_qscan(void);
= void list_macro(unsigned char *s);
= void make_macros(void);

[ Step 9 ]

Still in FCNS.H, make the changes below:

= void arc_l(void);
= void yourinfodl(void);
+ void nscan_indicator_only(int base);
- void l_config_nscan(void);
+ void l_config_nscan(int base);
= void config_nscan(void);
= void xfer_defaults(void);

[ Step 10 ]

Compile your source.

[ Disclaimer ]

Don't complain to me if your board gets fried, your hard disk goes nuts, or
something terrible happens.  The code in this mod should be harmless, but I
can't guarantee it will work for you.  It works on my board.

JAFO 1@1     TerraNET
     1@8861  WWIVnet
     1@8857  IceNET
     1@8857  SOLARnet
     1@18857 WWIVLink
