Snorkel #1 @2100
Wed Jun 07 10:43:22 1995
0R 34 06/09 07:13 WWIVNET 4051->8421
0R 34 06/08 18:18 WWIVNet 4001->4051
0R 34 06/08 14:07 WWIVnet 4000->4001
0R 34 06/08 05:34 WWIVnet ->4000
0R 34 06/08 00:26 WWIVnet 4001->4000
0R 34 06/08 08:22 WWIVnet 2001->4001
0R 34 06/07 11:03 WWIVnet 2100->2001
0R 34 06/07 10:58 WWIVnet ->2100
Ŀ
 Mod Name      : M&M009.MOD        Mod Author: Snorkel     1@2100 WWIVnet   
 Difficulty    : ۰        The M&M Factory [GSA]   1@3459 WWIVlink  
 WWIV Version  : 4.24                                                       
 Mod Date      : 6-3-95                                                     
 Files Affected: BATCH.C, FCNS.H, SR.C, XFER.C, XFEROVL.C                   
                                                                            
 Description   : Places the size of the .GIF file at the beginning of the   
                 file description.  Works either with the command \\UPLOAD  
                 or when a remote user uploads a file with a .GIF extension.
                 Also tells the sysop if the file is not a .GIF (in the     
                 sysop log).                                                
                                                                            
                 (Re-write of GIFINFO.MOD for 4.24)                         

ͻ
   This WWIV Source Code  modification  is  copyright  1995  by  Snorkel,   
   System Operator of The M&M Factory BBS and is distributed as freeware.   
   Permission is granted to distribute and post this modified code on BBS   
   systems and online services, provided no alterations are made (removal   
   of  message headers/taglines allowed).  This modified code may contain   
   some parts of WWIV source code,  which is copyright 1988-1995 by Wayne   
   Bell  and  licensed  only  to  registered  users of WWIV.  Use of WWIV   
   source without registration constitutes a license violation and  could   
   lead to legal prosecution.                                               
                                                                            
   Shareware  distributors  and CD-ROM publishers may not distribute this   
   modified code without express written permission of the Author or WWIV   
   Software Services.                                                       
ͼ

I have changed the code in this mod to make it more efficient, and also to
look for both the old .GIF format (GIF87a) and the new format (GIF89a).
Additionally, I have added a bit of code to the mod (at the end) so that the
file description is not longer than the comment field when the .GIF dimensions
are added to the file description.  I would like to give the original author
credit for this mod, since he did the hard part of actually writing the
routines which read the size of the .GIF and append the description onto it.
However, in the process of converting this mod over several times, I have lost
the original author's name.

This is a simple mod that automatically adds, to the file description, the
dimensions of any .GIF file that is uploaded to your board, remotely or
locally.  The dimensions will be in the format of WWWxHHHxCCC, where WWW is
the width, HHH is the height, and CCC is the number of colors used.  The
output should look like this:


WORF    .GIF:   21k :320x200x16  ... Lt. Worf of the USS Enterprise.
ALYSA1  .GIF:   59k :320x200x256 ... Lovely brunette with VERY brown eyes.
BRNCORAL.GIF:  173k :640x480x256 ... Brain coral, St. Thomas, U.S.V.I.
SCHIFF05.GIF:   83k :800x600x256 ... Claudia Schiffer in a white swim suit.
EHZS0034.GIF:  659k :1024x768x256 .. Great scan of colorful autumn leaves.


There is 58 characters total for the description.  With the .GIF size added to
the beginning, the amount of room left for the input of a description changes
to 42 characters.

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 1

FCNS.H

Add the following code where indicated.

/* File: sr.c */                               /* search for */

int getbytes(FILE *dev);                             /* ADD */
void check_gif(char *fn, char *descript);            /* ADD */
void calc_CRC(unsigned char b);


Save FCNS.H
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 2

BATCH.C 

In function "void uploaded(char *fn, long cps)" add the following code:

            if (f1>=0) {                      /* search for */
              u.numbytes = filelength(f1);
              sh_close(f1);
              if (strstr(u.filename,".GIF"))        /* ADD */
                check_gif(s2,u.description);        /* ADD */
              get_file_idz(&u,batch[i1].dir);
              ++thisuser.uploaded;


Save BATCH.C
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 3

XFEROVL.C

In function "int upload_file(char *fn, int dn, char *desc)" add the following:

int upload_file(char *fn, int dn, char *desc)    /* search for */
{
  directoryrec d;
  uploadsrec u,u1;
  int i,f;                     /*   EXISTING LINE - DELETE   */
  int i,f,w;                                      /* ADD */
  char s[81],ff[81];
  long l;



Further down in the code, change as follows:

      u.description[58]=0;                /* search for */
      pl(u.description);
    } else                     /*   EXISTING LINE - DELETE   */
    } else {                                    /* ADD */
      if(strstr(u.filename,".GIF"))             /* ADD */
        w=42;                                   /* ADD */
      else                                      /* ADD */
        w=58;                                   /* ADD */
      inputl(u.description,w);                  /* ADD */
    }                                           /* ADD */
      inputl(u.description,58);/*   EXISTING LINE - DELETE   */
    if (u.description[0]==0)
      return(0);
    get_file_idz(&u,dn);
    if (strstr(u.filename,".GIF"))              /* ADD */
      check_gif(ff,u.description);              /* ADD */
    ++thisuser.uploaded;
    if (!(d.mask & mask_cdrom))
      modify_database(u.filename,1);


Save XFEROVL.C
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 4

XFEROVL2.C

In function "void upload(int dn)" add or change as noted below:

  directoryrec d;                          /* search for */
  uploadsrec u,u1;
  int i,i1,i2,i3,i4,ok,xfer,f; /*   EXISTING LINE - DELETE   */
  int i,i1,i2,i3,i4,ok,xfer,f,w;            /* ADD */
  char s[255],s1[81],*ss;
  long l;
  double ti;


Now search for the following line, and add or change the code as indicated
below:

      pl(get_string(779));                      /* search for */
      if(strstr(u.filename,".GIF"))                     /* ADD */
        w=42;                                           /* ADD */
      else                                              /* ADD */
        w=58;                                           /* ADD */
      outstr(": ");
      inputl(u.description,58);/*   EXISTING LINE - DELETE   */
      inputl(u.description,w);                          /* ADD */
      nl();


A little further down in the function, add the following code:


              f=sh_open1(s1,O_RDONLY | O_BINARY);  /* search for */
            }
          }
        }
        if (ok) {
          if (ok==1) {
            l=filelength(f);
            u.numbytes=l;
            sh_close(f);
            if (strstr(u.filename,".GIF"))                /* ADD */
              check_gif(s1,u.description);                /* ADD */
            ++thisuser.uploaded;
            modify_database(u.filename,1);


Save XFEROVL2.C
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Step 5

SR.C

Block copy the following two functions to the end of SR.C


int getbytes(FILE *dev)                        /* begin block copy */
{
    int byte1;
    int byte2;
    int result;

    /* read bytes and shift over */

    byte1 = getc(dev);
    byte2 = getc(dev);

    result = (byte2 << 8) | byte1;

    return result;

}

void check_gif(char *fn, char *descript)
{
  int byte1, bits_per_pix,colors,i;
  unsigned int width;
  unsigned int height;
  FILE *in;
  char s[81];

  in = fsh_open (fn, "rb");
  for (i = 0; (i < 6); i++) s[i] = getc(in);
  s[6] = '\0';
  width = getbytes(in);
  height = getbytes(in);
  byte1 = getc(in);
  fsh_close(in);
  if((strcmp(s,"GIF87a")) && (strcmp(s,"GIF89a"))) {
    sprintf(s,"%s -- NOT a GIF file.",fn);
    sysoplog(s);
    return;
  }
  bits_per_pix = byte1 & 0x07;
  bits_per_pix++;
  colors = 1 << bits_per_pix;
  if((width<1000) && (height<1000))
    sprintf(s,"%dx%dx%-3d ... %s",width,height,colors,descript);
  else {
    if((width>999) && (height>999))
      sprintf(s,"%dx%dx%-3d . %s",width,height,colors,descript);
    if(((width>999) && (height<1000)) || ((width<1000) && (height>999)))
      sprintf(s,"%dx%dx%-3d .. %s",width,height,colors,descript);
  }
  strcpy(descript,s);
}                                            /* end block copy */


Save SR.C
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

And that's all! You should now recompile your entire BBS (do a "build all") 
since you have added 2 new functions to FCNS.H.

If you have any questions about this mod, please feel free to write me at 
1@2100.WWIVnet or 1@3459.WWIVlink.
1
2       6>> 1The M&M Factory   7Host of2 The Scuba Forum   4Subtype SCUBA_F6 <<
3                   6US Robotics Dual Standard  300-28,800 bps0
4                  6V.34/V.FC/V.terbo/V.32/V.32bis/V.42/V.42bis0
5              4Over 2,800 files On-line and available for download0
6
