#include "qwkvars.h"

char         *QWKFrom="QWK Origin: ";   /* Just to let people know where it came from in case it doesn't fit in the from field */

char *high_ascii_convert =
        {
          "CUeaaaaceeeiiiAAE?AOoouuyoUcLy"
          "PfaiounNao?++??!<>   |++++++|+"
          "++++++++-++++++++-++++++++++++"
          "+#####aB??Eoutoo??0EN=?><fj/=0"
          "..jn2# "
        };

char *subtypes[] = { "Unknown 0",
                     "Normal Network Updates",
                     "E-Mail by User Number",
                     "Post",
                     "Unknown 4",
                     "Pre-Post",
                     "External message",
                     "E-Mail by Name",
                     "Network editor packet",
                     "Subs.lst update",
                     "Unknown 10",
                     "Network update from GC 1",
                     "Network update from GC 2",
                     "Unknown 13",
                     "Misc update from GC",
                     "SSM",
                     "Add to subboard request",
                     "Remove from subboard request",
                     "Status to add request",
                     "Status to drop request",
                     "Info for subs.lst file",
                     "N/A 21",
                     "N/A 22",
                     "N/A 23",
                     "N/A 24"
                     "N/A 25",
                     "Post by subname",
                     "Auto-processing external messages"};


extern long qwk_ready_max_size;
void print_message(char *fmt, ...);

void convert_packet_to_qwk(char *pname, char *qname)
{
  net_header_rec net_header;
  qwk_record qwk_rec;
  time_t time_now;
  unsigned diff_time;
  int pfile, qfile, sub_num;
  char *text, fname[201], tname[201], title[101];
  char temp[301];
  long packet_size;

  _setcursortype(_NOCURSOR);

  qwk_ready_text=(char *)malloca(qwk_ready_max_size);

  if(!qwk_ready_text)
  {
    print_message("Couldn't allocate memory to make qwk ready\r\n");
    return;
  }

#ifdef REG
  setvect(3, new_int_3);
#endif


  pfile=open(pname, O_RDONLY | O_BINARY);
  if(pfile < 1)
  {
    print_message("Couldn't open %s (WWIV packet) for reading\r\n", pname);
    free(qwk_ready_text);
    return;
  }

  /* Show packet size in info window */
  packet_size = filelength(pfile);
  textattr(YELLOW+(BLUE<<4));
  window(1, 1, 80, 25);
  gotoxy(71,2);
  cprintf("%ldK", packet_size > 1024 ? packet_size / 1024 : 1L);
  /* End of showing packet size */


  qfile=open(qname, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  if(qfile < 1)
  {
    print_message("Couldn't open %s (QWK file) for writting\r\n", qname);
    free(qwk_ready_text);
    close(pfile);
    return;
  }
  memset((void *)&qwk_rec, ' ', sizeof(qwk_record));

  if(qwk_style == QWK)
    strncpy((char *)&qwk_rec, "Produced by Asylum QWK Mail... Copyright 1994 by Michael Deweese", 64);
  else
    strncpy((char *)&qwk_rec, remote_id, strlen(remote_id));
  append_block(qfile, (void *)&qwk_rec, sizeof(qwk_record));
  block_number=2;

  print_message("\r\n");
  aborted = 0;
  while(!aborted)
  {
    text = readmessage(pfile, fname, tname, &sub_num, title, &net_header);

    if(sub_num >= 0)
      subs_used[sub_num]=1;


    if(!text)
      continue;


    make_qwk_ready(text, fname);

    put_in_qwk(qfile, fname, tname, sub_num, title, &net_header, text);

/* Update the processed+ignored and current pos window */
    ++processed;
    window(1, 1, 80, 25);
    textattr(YELLOW+(CYAN<<4));
    gotoxy(68, 10);
    cprintf("%ld", processed);
    gotoxy(68, 11);
    cprintf("%ld", ignored);

    textattr(YELLOW+(BLUE<<4));
    gotoxy(71, 3);
    cprintf("%ldK", current_pos > 1024 ? current_pos / 1024 : 1L);
    time_now=time(NULL);
    diff_time=time_now-second_time;
    gotoxy(71, 4);

    if(diff_time)
      cprintf("%5ld", (long)current_pos / diff_time);

/* End update of processed+ignored and current pos window */

    free(text);

    if(registered != REGISTERED && registered != LIMITED_REGISTER)
    {
      if(processed >= MAX_UNREGISTERED_MSGS)
      {
        print_message("Sorry, Unregistered version has reached its max messages!!\r\n");
        aborted = 1;
        delay(2000);
      }
    }

  }
  after_second=time(NULL);
  print_message("Total messages Processed %ld, total ignored %ld\r\n", processed, ignored);


  build_control_dat();


  close(qfile);
  close(pfile);
  free(qwk_ready_text);
}
void put_in_qwk(int qfile, char *fname, char *tname, int sub_num,
                         char *title, net_header_rec *net_header, char *text)
{
  qwk_record qwk_rec;
  struct tm *time_now;

  int cur_block=2, amount_blocks;
  int msgnum = ++sub_counters[sub_num];
  static long total_msgs=0;
  char date[10];
  unsigned len = strlen(text);
  long tblocks;

  ++total_msgs;

  memset(&qwk_rec, ' ', sizeof(qwk_record));


  if(tname && *tname)
    strncpy(qwk_rec.to, strupr(tname), strlen(tname) > 25 ? 25 : strlen(tname));
  else
    strncpy(qwk_rec.to, "ALL", 3);

  strncpy(qwk_rec.from, strupr(fname), strlen(fname) > 25 ? 25 : strlen(fname));

  time_now=localtime((time_t *)&net_header->daten);
  strftime(date, 10, "%m-%d-%y", time_now);
  strncpy(qwk_rec.date, date, 8);



  if(len)
  {
    amount_blocks=((long)len/sizeof(qwk_record))+1;

    if((long)len%sizeof(qwk_record))    /* if there is a remainder */
      ++amount_blocks;
  }
  else
    amount_blocks=2;       /* qwk minimum */


  // Save Qwk Record
  sprintf(qwk_rec.amount_blocks, "%u", amount_blocks);
  sprintf(qwk_rec.msgnum, "%u", msgnum);

  strip_heart_colors(title);
  strncpy(qwk_rec.subject, title, 25);

  qwk_remove_null((char *) &qwk_rec, 128);

  qwk_rec.conf_num=sub_num;
  qwk_rec.logical_num=total_msgs;


  if(build_index)
  {
    qwk_index qwk_ndx;
    int i;
    char iname[130];

    _fieeetomsbin(&block_number, &qwk_ndx.pos);
    sprintf(iname, "%s%03d.NDX", temp_dir, sub_num);
    i=open(iname, O_RDWR | O_APPEND | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);

    if(i > 0)
    {
      write(i, (void *)&qwk_ndx, sizeof(qwk_index));
      close(i);
    }
    else
      print_message("Warning: Couldn't open %s (index file) for writting\r\n", iname);
  }
  tblocks = block_number + amount_blocks;
  block_number = tblocks;


  if(append_block(qfile, (void *)&qwk_rec, sizeof(qwk_record)) != sizeof(qwk_record))
  {
    aborted=1;  // Must be out of disk space
    print_message("Write error\r\n");
    return;
  }

  while(cur_block<=amount_blocks)
  {
    int this_pos;
    memset(&qwk_rec, ' ', sizeof(qwk_rec));

    this_pos=((cur_block-2)*sizeof(qwk_rec));

    if(this_pos < len)
    {
      memmove(&qwk_rec, text+this_pos, this_pos + sizeof(qwk_rec) >
                  (int)len ? (int)len-this_pos-1 : sizeof(qwk_record));
      append_block(qfile, (void *)&qwk_rec, sizeof(qwk_rec));
    }
    else
      break;

    this_pos+=sizeof(qwk_rec);
    ++cur_block;
  }

}


void make_qwk_ready(char *text, char *address)
{
  unsigned pos=0, new_pos=0;
  int x, tag_line=0;
  long len = strlen(text);


  while(pos<len && new_pos < qwk_ready_max_size)
  {
    x=(unsigned char)text[pos];

    if(x==0)
      break;

    if(x==13)
    {
      qwk_ready_text[new_pos]=227;
      ++pos;
      ++new_pos;
    }
    // Strip out Newlines, NULLS, 1's and 2's
    else if(x==10 || x < 3)
      ++pos;
    else if(x==3)
      pos+=2;
    else if(x==4 && text[pos+1]=='0')   /* Remove routing info */
    {
      if(text[pos+1]==0)  /* If we are at the end of file, this is just a safety measure, refering to NULL, not '0' */
        ++pos;
      else
      {
        while((unsigned char)text[pos]!=(unsigned char)227 && text[pos]!= '\r' && pos<len && text[pos] != 0)
          ++pos;
      }
      ++pos;
      if(text[pos]=='\n')
        ++pos;
    }
    else if(x==4 && text[pos+1]!='0')
    {
      if(!tag_line)  /* Convert Taglines to Fido Style Tag lines */
      {
        qwk_ready_text[new_pos]='-'; ++new_pos;
        qwk_ready_text[new_pos]='-'; ++new_pos;
        qwk_ready_text[new_pos]='-'; ++new_pos;
        qwk_ready_text[new_pos]=''; ++new_pos;
      }
      ++tag_line;     /* Contains how many lines of taglines there are */

      if(text[pos+1]==0)  /* Make sure we don't jump past the end of text area */
        ++pos;
      else
        pos+=2;
    }
    else if(x>127 && convert_high)
    {
      x=high_ascii_convert[x-128];
      qwk_ready_text[new_pos]=x;
      ++pos;
      ++new_pos;
    }
    else
    {
      qwk_ready_text[new_pos]=x;
      ++pos;
      ++new_pos;
    }
  }

  qwk_ready_text[new_pos]=0;
  text[0]=0;

  if(address && *address && strlen(address) > 25)
  {
    /* Only add address if it doesn't fit in the regular QWK from field */
    if(!strstr(qwk_ready_text, QWKFrom))
    {
      strcat(text, QWKFrom);
      strcat(text, address);
      strcat(text, "");
    }
  }


  strcat(text, qwk_ready_text);

}

char *readmessage(int pfile, char *fname, char *tname, int *sub_num, char *title, net_header_rec *net_header)
{
  char *text, *tmp, *tmp1, temp[201];
  char sub_type[21], date[51];
  long pos, y, zsize1, zsize2;
  unsigned x;
  int done2=0;

  tname[0]=0;

  aborted=0;
  while(!done2)
  {
    x = read(pfile, (void *)net_header, sizeof(net_header_rec));

    if(x < sizeof(net_header_rec))
    {
      if(x)   /* if x = 0, we are at end of file, don't show error */
        print_message("Wanted to read %d bytes (A), but only read %ld bytes\r\n", sizeof(net_header_rec), x);
      aborted = 1;
      return NULL;
    }

    /* Add the bytes we just read to our current position */
    current_pos += sizeof(net_header_rec);


    x = net_header->main_type;

    switch(x)
    {
      case main_type_email:
      case main_type_post:
      case main_type_pre_post:
      case main_type_email_name:
      case main_type_new_post:
        done2 = 1;
        break;
      default:
        sprintf(temp, "Ignored type %d -> %s\r\n", x, subtypes[x]);
        print_message(temp);
        ++ignored;

        /* Set my disk pointers to the next record */
        if(net_header->list_len)
        {
          lseek(pfile, net_header->list_len * 2, SEEK_CUR);

          /* we are moving in the file, so add it to our current position */
          current_pos += (net_header->list_len * 2);
        }


        lseek(pfile, net_header->length, SEEK_CUR);

        /* We are moving in the file, so add it to our position */
        current_pos += net_header->length;

        break;
    }
  }

  if(net_header->list_len)
  {
    lseek(pfile, net_header->list_len * 2, SEEK_CUR);

    /* we are moving in the file, so add it to our current position */
    current_pos += (net_header->list_len * 2);
  }

  text=malloca(net_header->length + 2048);
  if(!text)
  {
    print_message("Couldn't allocate %ld bytes memory, skipping\r\n", net_header->length + 2048);
    ++ignored;
    return NULL;
  }

  y = read(pfile, (void *)text, net_header->length);
  if(y != net_header->length)
  {
    print_message("Wanted to read %d bytes (B), but only read %ld bytes\r\n", net_header->length, y);
    aborted=1;
    free(text);
    return NULL;
  }

  /* Add the stuff we just read in to our length */
  current_pos += net_header->length;

  text[y] = 0;
  pos=0;

  if(x == main_type_post || x == main_type_pre_post)
  {
    sprintf(sub_type, "%u", net_header->minor_type);
    *sub_num = find_sub_num(sub_type);

    if(*sub_num < 0)
    {
      free(text);
      print_message("Warning: Unknown subtype %s\r\n", sub_type);
      ++ignored;
      return NULL;
    }
    else
    {
      window(1, 1, 80, 25);
      textattr(YELLOW+(CYAN<<4));
      gotoxy(68, 8);
      cprintf("%u", *sub_num);
      gotoxy(68, 9);
      cprintf("%-8.8s", sub_type);
    }
  }
  else if(x == main_type_new_post)
  {
    strcpy(sub_type, text);             /* subtype is null terminated, so do a strcpy */
    zsize1=strlen(sub_type)+1;
    memmove(text, text+zsize1, net_header->length);   /* remove subtype from text */

    *sub_num = find_sub_num(sub_type);

    if(*sub_num < 0)
    {
      free(text);
      print_message("Warning: Unknown subtype %s\r\n", sub_type);
      ++ignored;
      return NULL;
    }
    else
    {
      window(1, 1, 80, 25);
      textattr(YELLOW+(CYAN<<4));
      gotoxy(68, 8);
      cprintf("%u", *sub_num);
      gotoxy(68, 9);
      cprintf("%s", sub_type);
    }
  }
  else if(x == main_type_email_name)
  {
    get_line(tname, 200, &pos, text);
    *sub_num = email_sub;
  }
  else if(x == main_type_email)
    *sub_num = email_sub;


  strcpy(title, text);                 /* Title is null terminated, so strcpy it */
  zsize1 = strlen(title)+1;
  zsize2 = strlen(text+zsize1)+1;
  memmove(text, text+zsize1, zsize2); /* then remove it from our text */

  get_line(fname, 200, &pos, text);
  get_line(date, 50, &pos, text);


  /* Work on from name */
  strip_heart_colors(fname);
  if(net_header->fromsys && strchr(fname, '@') == NULL)
  {
    sprintf(temp, " @%u", net_header->fromsys);
    strcat(fname, temp);
  }

  /* now to name */
  if(x == main_type_email)
    sprintf(tname, "%u@%u", net_header->fromuser, net_header->touser);

  zsize1=strlen(text+pos)+1;
  memmove(text, text+pos, zsize1);  /* Remove name and date etc.. from text */

    strcat(text, tag_string);    /* End of QWKCNVT tagline */

  net_header->length = strlen(text);
  return(text);
}


char * get_line(char *buff, int max_len, long *pos, char *source)
{
  int c, buff_pos=0;
  char *temp;

  if(!source[*pos])     // If at end of buffer, return NULL
    return NULL;

  while(1)
  {
    c = source[*pos];

    if(c == 0 || c == '\r\n')
    {
      buff[buff_pos] = 0;
      if(c)    // Only increment if we are on a newline
        ++*pos;

      temp=(char *)strchr(buff, ';');
      if(temp)
        temp[0]=0;      // Null out all after ; (comment)

      temp=(char *)strchr(buff, '\r');
      if(temp)
        temp[0]=0;      // Get rid of any carriage returns

      return(buff);
    }

    buff[buff_pos] = c;

    ++buff_pos;
    ++*pos;

    if(buff_pos >= max_len)
    {
      buff[buff_pos] = 0;

      temp=(char *)strchr(buff, ';');
      if(temp)
        temp[0]=0;      // Null out all after ; (comment)

      temp=(char *) strchr(buff, '\r');
      if(temp)
        temp[0]=0;      // Get rid of any carriage returns

      return(buff);
    }
  }
}


