
#define _DEFINE_GLOBALS_
#include "qwkvars.h"
#include "qwkmenus.h"





#ifdef REG
  void interrupt (*old_handler)();

  void interrupt new_int_3(void)
  {}

  #ifndef SERIAL_NUMBER
    #error Define SERIAL_NUMBER
  #endif
#endif




void main(int argc, char **argv)
{
  int x;


  /* ----------------------------------------- */
  /* Check to see if we are trying to register */
  /* the software                              */
  /* ----------------------------------------- */
  if(argc>1)
  {
    if(strncmpi(argv[1], "reg", 3)==0)
    {
      do_register();
      exit(MISC_FATAL);
    }
  }



  /* ------------------------------------------- */
  /* A little hack proofing, steal the int 3     */
  /* and then execute one                        */
  /* ------------------------------------------- */

#ifdef REG
  old_handler = getvect(3);
  setvect(3, new_int_3);
  asm int 3
#endif



  /* ----------------------------------------- */
  /* Initialize the message windows cordinates */
  /* ----------------------------------------- */

  mi.xpos = 2;
  mi.ypos = 16;



  /* ----------------------------------------- */
  /* Save the time that we first loaded up the */
  /* program (or real close at least           */
  /* ----------------------------------------- */

  first_time=time(NULL);



  /* ------------------- */
  /* Check registration  */
  /* ------------------- */
  read_reg_ini();
  if(registered != REGISTERED && registered != LIMITED_REGISTER)
  {
    puttext(1, 1, 80, 25, BEGSCREEN);
    delay(6000);
  }
  puttext(1, 1, 80, 25, MAINMENU);
  print_register();             /* Displays reg info in middle left corner */


  /* --------------------------------------- */
  /* If we don't have at least two command   */
  /* line arguments, display error and exit  */
  /* --------------------------------------- */
  if(argc > 2)
  {
    read_ini_file(argv[2]);
    atexit(close_up_show);
  }
  else
  {
    print_message("Error, wrong number of arguments\r\n\r\n");
    help();
    gotoxy(1, 25);
    exit(WRONG_NUMBER);
  }


  /* -------------------------------- */
  /* Capitalize our argument for easy */
  /* comparisions                     */
  /* -------------------------------- */
  strupr(argv[1]);




  /* ----------------------------------------------------- */
  /* If the user is not registered (either full or limited */
  /* Then check to see if the software has expired.  As    */
  /* setup now, it expires 12/31/94                        */
  /* ----------------------------------------------------- */
  if(registered != REGISTERED && registered != LIMITED_REGISTER)
  {
    if(first_time > 788850000)                     /* 12/31/94 expires */
      out_of_date();
  }


  /* ------------------------------------------------------------- */
  /* If our first letter isn't a Q (Q2W) R (R2W) or W (W2Q or W2R) */
  /* Then the wrong paremater must have been entered, exit with    */
  /* error message                                                 */
  /* ------------------------------------------------------------- */
  x=argv[1][0];
  if(x != 'Q' && x != 'R' && x != 'W')
  {
    print_message("Error, first paremater must be either Q2W or W2Q\r\n\r\n");
    help();
    gotoxy(1, 25);
    exit(WRONG_FIRST);
  }


  /* ------------------------------------ */
  /* If we are doing a WWIV to QWK or REP */
  /* then the below executes              */
  /* ------------------------------------ */
  if(argv[1][0] == 'W')
  {
    char temp[128], temp1[151], temp2[151], program[151];


    /* -------------------------------- */
    /* Clear out our temorary directory */
    /* -------------------------------- */
    remove_files("*.*", temp_dir);


    /* ------------------------------------------------------------- */
    /* If we are converting to a QWK, then our destination file name */
    /* is MESSAGES.DAT, if it is a REP packet, then our destination  */
    /* filename is based on the remote system, it is it's system_id  */
    /* with the extension of .MSG                                    */
    /* ------------------------------------------------------------- */
    if(argv[1][2] == 'Q')
    {
      sprintf(temp, "%sMESSAGES.DAT", temp_dir);
      qwk_style = QWK;
    }
    else
    {
      sprintf(temp, "%s%s.MSG", temp_dir, remote_id);
      qwk_style = REP;
    }



    /* --------------------------------------------------------------- */
    /* second_time holds the time we start our actual converion, so we */
    /* get a true value of our bytes processed per second              */
    /* --------------------------------------------------------------- */
    second_time=time(NULL);


    /* --------------------------------------------------------------- */
    /* Call out high level function to convert the wwiv packet to a    */
    /* QWK packet                                                      */
    /* --------------------------------------------------------------- */
    convert_packet_to_qwk(source_wwiv_file, temp);


    /* --------------------------------------------------------------- */
    /* Now archive our converted packet with the packet we choose in   */
    /* the ini file                                                    */
    /* --------------------------------------------------------------- */
    switch(arc_to_use)
    {
      case COMPRESSION_ZIP:
      default:
        strcpy(temp1, "PKZIP %1 %2");
        get_ini_value("QWKCNVT.INI", "ZIP", "ADD", temp1, 150);
        break;

      case COMPRESSION_ARJ:
        strcpy(temp1, "ARJ a %1 %2");
        get_ini_value("QWKCNVT.INI", "ARJ", "ADD", temp1, 150);
        break;

      case COMPRESSION_PAK:
        strcpy(temp1, "PAK a %1 %2");
        get_ini_value("QWKCNVT.INI", "PAK", "ADD", temp1, 150);
        break;

      case COMPRESSION_ZOO:
        strcpy(temp1, "ZOO a %1 %2");
        get_ini_value("QWKCNVT.INI", "ZOO", "ADD", temp1, 150);
        break;

      case COMPRESSION_LHA:
        strcpy(temp1, "LHA a %1 %2");
        get_ini_value("QWKCNVT.INI", "LHA", "ADD", temp1, 150);
        break;
    }


    /* ---------------------------------------------------- */
    /* We will be arhiving everything in the temp directory */
    /* ---------------------------------------------------- */
    sprintf(temp2, "%s*.*", temp_dir);



    /* ---------------------------------------------------- */
    /* Figure out the resulting filename, it will either be */
    /* our system name.qwk for a qwk packet, or if it is a  */
    /* REP packet, it will be the remote_id.REP             */
    /* ---------------------------------------------------- */
    if(argv[1][2] == 'Q')
      sprintf(temp, "%s%s.QWK", dest_qwk_dir, system_id);
    else
      sprintf(temp, "%s%s.REP", dest_qwk_dir, remote_id);



    /* ------------------------------------------------------ */
    /* Save our current screen and clear it, then print out a */
    /* message stating that the archiver is compressing the   */
    /* files                                                  */
    /* ------------------------------------------------------ */
    gettext(1, 1, 80, 25, save_screen);
    textattr(WHITE);
    clrscr();
    cprintf("Compressing...\r\n");



    /* ------------------------------------------------------------- */
    /* stuff_in builds a proper program name out of the generic      */
    /* archive command, ie pkzip %1 %2, whenever it sees the         */
    /* % stuff (%1), it uses the paremater specified in the          */
    /* 3rd-8th parematers of stuff_in.                               */
    /* After this is down, the archiver is executed in spawn program */
    /* ------------------------------------------------------------- */
    stuff_in(program, temp1, temp, temp2, "", "", "");
    spawn_program(program);


    /* ----------------------------------------------------------- */
    /* Restore our wiped out screen (we saved it above in gettext)  */
    /* ------------------------------------------------------------ */
    puttext(1, 1, 80, 25, save_screen);


    /* --------------------------------------- */
    /* And finally, remove our done with files */
    /* --------------------------------------- */
    remove_files("*.*", temp_dir);
  }
  else if(argv[1][0] == 'Q' || argv[1][0] == 'R')
  {
    char temp[151], temp1[151], program[151];
    int arc_type;

    remove_files("*.*", temp_dir);

    if(argv[1][0] == 'Q')
    {
      qwk_style = QWK;

      sprintf(temp, "%s%s.QWK", source_qwk_dir, remote_id);
      arc_type = check_arc(temp);

      switch(arc_type)
      {
        case COMPRESSION_ZIP:
        default:
          strcpy(temp1, "PKUNZIP %1 %2");
          get_ini_value("QWKCNVT.INI", "ZIP", "EXTRACT", temp1, 150);
          break;

        case COMPRESSION_ARJ:
          strcpy(temp1, "ARJ e %1 %2");
          get_ini_value("QWKCNVT.INI", "ARJ", "EXTRACT", temp1, 150);
          break;

        case COMPRESSION_PAK:
          strcpy(temp1, "PAK e %1 %2");
          get_ini_value("QWKCNVT.INI", "PAK", "EXTRACT", temp1, 150);
          break;

        case COMPRESSION_ZOO:
          strcpy(temp1, "ZOO e %1 %2");
          get_ini_value("QWKCNVT.INI", "ZOO", "EXTRACT", temp1, 150);
          break;

        case COMPRESSION_LHA:
          strcpy(temp1, "LHA e %1 %2");
          get_ini_value("QWKCNVT.INI", "LHA", "EXTRACT", temp1, 150);
          break;
      }

      gettext(1, 1, 80, 25, save_screen);
      textattr(WHITE);
      clrscr();
      cprintf("Un-compressing...\r\n");


      stuff_in(program, temp1, temp, temp_dir, "", "", "");
      spawn_program(program);

      puttext(1, 1, 80, 25, save_screen);

      sprintf(temp, "%sMESSAGES.DAT", temp_dir);
    }
    else
    {
      qwk_style = REP;

      sprintf(temp, "%s%s.REP", source_qwk_dir, system_id);
      arc_type = check_arc(temp);

      switch(arc_type)
      {
        case COMPRESSION_ZIP:
        default:
          strcpy(temp1, "PKUNZIP %1 %2");
          get_ini_value("QWKCNVT.INI", "General", "ZIP", temp1, 150);
          break;

        case COMPRESSION_ARJ:
          strcpy(temp1, "ARJ e %1 %2");
          get_ini_value("QWKCNVT.INI", "General", "ARJ", temp1, 150);
          break;

        case COMPRESSION_PAK:
          strcpy(temp1, "PAK e %1 %2");
          get_ini_value("QWKCNVT.INI", "General", "PAK", temp1, 150);
          break;

        case COMPRESSION_ZOO:
          strcpy(temp1, "ZOO e %1 %2");
          get_ini_value("QWKCNVT.INI", "General", "ZOO", temp1, 150);
          break;

        case COMPRESSION_LHA:
          strcpy(temp1, "LHA e %1 %2");
          get_ini_value("QWKCNVT.INI", "General", "LHA", temp1, 150);
          break;
      }

      stuff_in(program, temp1, temp, temp_dir, "", "", "");
      spawn_program(temp1);

      sprintf(temp, "%s%s.MSG", temp_dir, system_id);
    }

    second_time=time(NULL);
    convert_qwk_to_wwiv(temp, dest_wwiv_file);

    remove_files("*.*", temp_dir);
  }

  third_time=time(NULL);
  exit(SUCCESS);
}



void close_up_show(void)
{

  unsigned diff_time;

  if(ini_info.changes_made)
    write_ini_file(&ini_info);
  free_ini_info(&ini_info);

#ifdef REG
  /* also restore interupt 3 */
  setvect(3, old_handler);
#endif


  print_message("Seconds run : %ld\r\n", (long)(third_time - first_time));
  diff_time=after_second-second_time;
  if(diff_time)
    print_message("Average bytes per second : %ld", (long) current_pos / diff_time);



  if(registered != REGISTERED && registered != LIMITED_REGISTER)
  {
    print_message("\r\nPlease register this evaluation copy of QWK<->WWIV!\r\n");
    print_message("\r\n\r\nTo register, the cost is $25, send it to:\r\n\r\n");
    print_message("      Michael Deweese\r\n");
    print_message("      4246 Wilson Moutain Road\r\n");
    print_message("      Roanoke, VA 24014\r\n");
    print_message("      BBS #: 703-427-1214\r\n\r\n");

    delay(4000);
  }

  _setcursortype(_NORMALCURSOR);
  window(1, 1, 80, 25);
  gotoxy(1, 25);
  fcloseall();
}



long find_sub_num(char *sub_type)
{
  return(read_ini_number(&ini_info, "Sub Type to Sub Num", sub_type, -1));
}

void help(void)
{
  print_message(
           "Syntax:\r\n"
           "  QWKCNVT which inifile.ini\r\n"
           "\r\n"
           "  which        = Q2W for QWK style to WWIV style\r\n"
           "                 W2Q for WWIV style to QWK style\r\n"
           "  inifile.ini  = INI file used to determin conversion\r\n"
        );

}

int exist(char *s)
{
  int i;
  struct ffblk ff;

#ifdef REG
  setvect(3, new_int_3);
#endif

  i=findfirst(s,&ff,FA_HIDDEN);
  if (i)
    return(0);
  else
    return(1);
}




void strip_heart_colors(char *text)
{
  int pos=0;
  int len=strlen(text);

  while(pos<len && text[pos] != 26)
  {
    if(text[pos]==3)
    {
      memmove(text+pos, text+pos+2, len-pos);
      --len;
      --len;
    }
    else
      ++pos;
  }
}

long filesize(FILE *stream)
{
  long curpos, length;
  
  curpos=ftell(stream);
  
  fseek(stream, 0L, SEEK_END);
  length=ftell(stream);
  
  fseek(stream, curpos, SEEK_SET);
  
  return length;
}

char * strip_string(char *string)
{
  int x=0, y;
  while(isspace(string[x]) && string[x])
    ++x;
    
  y=strlen(string);
  memmove(string, string+x, y-x+1);
  string[y-x+1]=0;
  
  y=strlen(string);
  --y;
  
  while(isspace(string[y]) && y >= 0)
    --y;
    
  string[y+1]=0;
  
  
  return(string);
}

char *strstr_nocase(char *s1, char *s2)
{
  int len=strlen(s2), pos=0;

  while(s1[pos])
  {
    if(strncmpi(s1+pos, s2, len)==0)
      return(s1+pos);

    ++pos;
  }
  return NULL;
}





void far *malloca(unsigned long nbytes)
{
  void *buf;
  char s[160];

#ifdef DEBUG
  check_heap2(3);
#endif
  buf=(void *)malloc(nbytes+1);
  if (buf==NULL)
  {
    print_message("Couldn't allocate %ld bytes of memory!\r\n", nbytes);
    getch();
  }
  return(buf);
}




int check_arc(char *filename)
{
  char header[10];
  char *ext;
  int file;


  file=open(filename, O_RDONLY);

  if(file<0)
    return(COMPRESSION_UNKNOWN);

  lseek(file, 0, SEEK_SET);
  read(file, (void *)&header, 10);

  close(file);

  switch(header[0])
  {
    case 0x60:
      if((unsigned char)header[2]==(unsigned char)0xEA)
        return(COMPRESSION_ARJ);

      break;

    case 0x1a:
      return(COMPRESSION_PAK);

    case 'P':
      if(header[1]=='K')
        return(COMPRESSION_ZIP);

      break;

    case 'Z':
      if(header[1]== 'O' && header[2] == 'O')
        return(COMPRESSION_ZOO);

      break;

    default:

      if(strstr(header, "-lh"))
        return(COMPRESSION_LHA);

      // Guess on type, using extension to guess
      ext=strstr(filename, ".");

      if(ext)
      {
        ++ext;

        if(stricmp(ext, "ZIP")==0)
          return(COMPRESSION_ZIP);

        if(stricmp(ext, "LHA")==0)
          return(COMPRESSION_LHA);

        if(stricmp(ext, "LZH")==0)
          return(COMPRESSION_LHA);

        if(stricmp(ext, "ZOO")==0)
          return(COMPRESSION_ZOO);

        if(stricmp(ext, "ARC")==0)
          return(COMPRESSION_PAK);

        if(stricmp(ext, "PAK")==0)
          return(COMPRESSION_PAK);

        if(stricmp(ext, "ARJ")==0)
          return(COMPRESSION_ARJ);

        return(COMPRESSION_UNKNOWN);
      }
  }
  return(COMPRESSION_UNKNOWN);
}

void stuff_in(char *s, char *s1, char *f1, char *f2, char *f3, char *f4, char *f5)
{
  int r=0,w=0;
  char temp[21];

  while (s1[r]!=0)
  {
    if (s1[r]=='%')
    {
      ++r;
      s[w]=0;
      switch(s1[r])
      {
        case '1': strcat(s,f1); break;
        case '2': strcat(s,f2); break;
        case '3': strcat(s,f3); break;
        case '4': strcat(s,f4); break;
        case '5': strcat(s,f5); break;

      }
      w=strlen(s);
      r++;
    } else
      s[w++]=s1[r++];
  }
  s[w]=0;
}
void remove_files(char *fn, char *dir)
{
  int f1,ok;
  char s[81],s1[81];
  struct ffblk ff;

  sprintf(s1, "%s%s", dir, fn);
  f1=findfirst(s1, &ff, 0);
  ok=1;
  while ((f1==0) && (ok))
  {
    sprintf(s,"%s%s", dir, ff.ff_name);
    _chmod(s, 1, 0);
    unlink(s);
    f1=findnext(&ff);
  }
}

int spawn_program(char *cl)
{
  int i,i1,l;
  char s[160];
  char *ss[30];

  strcpy(s,cl);
  ss[0]=s;
  i=1;
  l=strlen(s);
  for (i1=1; i1<l; i1++)
  {
    if (s[i1]==32)
    {
      s[i1]=0;
      ss[i++]=&(s[i1+1]);
    }
  }
  ss[i]=NULL;
  i=spawnvp(P_WAIT, ss[0], ss);
  return(i);
}


void convert_string(char *src, char *dst)
{
  while(*src)
  {
    *dst=*src+1;

    ++src;
    ++dst;
  }

  *dst=0;
}


void print_message(char *fmt, ...)
{
  va_list ap;
  static char s[1024];
  int x, y;

  va_start(ap, fmt);
  vsprintf(s, fmt, ap);
  va_end(ap);


  if(logfile)
    fprintf(logfile, s);

  x=wherex();
  y=wherey();

  textattr(YELLOW+(BLUE << 4));
  window(3, 16, 77, 23);
  gotoxy(mi.xpos, mi.ypos);
  cprintf(s);
  mi.xpos=wherex();
  mi.ypos=wherey();

  window(1, 1, 80, 25);
  gotoxy(x, y);
}

void print_register(void)
{
  window(1, 1, 80, 25);
  textattr(BLUE+(CYAN<<4));
  if(registered == REGISTERED || registered == LIMITED_REGISTER)
  {
    gotoxy(21, 9);
    cprintf("%ld", reg_number);
    gotoxy(21, 10);
    cprintf("%-18.18s", sysop_registered);
    gotoxy(21, 11);

    if(registered == REGISTERED)
      cprintf("You are the Best!");
    else
      cprintf("For your use only!");
  }
  else
  {
    gotoxy(21, 9);
    cprintf("Unregistered");
    gotoxy(21, 10);
    cprintf("Evaluation");
    gotoxy(4, 11);
    cprintf("------Registration is only $25------");
  }
}




long date_to_daten(char *datet)
{
  struct time t;
  struct date d;

  if (strlen(datet)!=8)
    return(0);

  memset(&d, 0, sizeof(struct date));
  memset(&t, 0, sizeof(struct time));

  d.da_mon=atoi(datet);
  d.da_day=atoi(datet+3);
  d.da_year=1900+atoi(datet+6);

  return(dostounix(&d, &t));
}
