#include "vars.h"
#pragma hdrstop

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <fcntl.h>
#include <conio.h>
#include <sys/stat.h>



int outchr_color(int c)
{
  int x;

  g_flags |= g_flag_pipe_colors;
  x = outchr(c);
  g_flags &= ~g_flag_pipe_colors;
  return(x);
}

char **alloc_2d(int row, int col, unsigned size)
{
   int i;
   char **prow, *pdata;

   pdata = (char *) farcalloc(row * col, size);
   if (pdata == (char *) NULL) {
      sysoplog("2Dalloc Err");
      pl("Mem Error!");
      hangup=1;
      return(NULL);
   }
   prow  = (char **) malloca(row * sizeof (char *));
   if (prow == (char **) NULL) {
      sysoplog("2Dalloc Err\n");
      pl("Mem Error!");
      hangup=1;
      bbsfree(pdata);
      return(NULL);
   }

   for (i = 0; i < row; i++) {
     prow[i] = pdata;             /* store pointers to rows */
     pdata += size * col;         /* move to next row */
   }
   return prow;                   /* pointer to 2D array */
}

void free_2d(char **pa)
{
  if(pa)
  {
    bbsfree(*pa);                    /* free the data */
    bbsfree(pa);                     /* free pointer to row pointers */
  }
}


unsigned side_menu(int *menu_pos, int redraw, char *menu_items[], int xpos, int ypos, struct side_menu_colors *smc)
{
  static int positions[20], amount=1;
  int x;
  unsigned event;

  tleft(1);
  
  if(redraw)
  {
    amount=1;
    positions[0]=xpos;
    while(menu_items[amount] && menu_items[amount][0] && !hangup )
    {
      positions[amount]=positions[amount-1]+strlen(menu_items[amount-1])+2;
      ++amount;
    }
    
    x=0;
    setc(smc->normal_menu_item);

    while(menu_items[x] && menu_items[x][0] && !hangup)
    {
      GOTO_XY(positions[x], ypos);
      
      if(*menu_pos==x)
      {
        setc(smc->current_highlight);
        outchr(menu_items[x][0]);
        setc(smc->current_menu_item);
        outstr(menu_items[x]+1);
      }
      else
      {
        setc(smc->normal_highlight);
        outchr(menu_items[x][0]);
        setc(smc->normal_menu_item);
        outstr(menu_items[x]+1);
      }
      ++x;
    }
  }
  
  
  
  setc(smc->normal_menu_item);

  while(!hangup)
  {
    event=get_kb_event();

      
    if(event<128)
    {
      int x=0;
      while(menu_items[x] && menu_items[x][0] && !hangup)
      {
        if(event==toupper(menu_items[x][0]) || event==tolower(menu_items[x][0]))
        {
          GOTO_XY(positions[*menu_pos], ypos);
          setc(smc->normal_highlight);
          outchr(menu_items[*menu_pos][0]);
          setc(smc->normal_menu_item);
          outstr(menu_items[*menu_pos]+1);

          *menu_pos=x;
          
          setc(smc->current_highlight);
          GOTO_XY(positions[*menu_pos], ypos);
          outchr(menu_items[*menu_pos][0]);
          setc(smc->current_menu_item);
          outstr(menu_items[*menu_pos]+1);
          
          if(modem_speed>2400 || !using_modem)
            GOTO_XY(positions[*menu_pos], ypos);
          
          return(EXECUTE);
        }
        ++x;
      }
      return(event);     /* added to return a value that isn't a hot key */
    }
    else
    {
      switch(event)
      {
        case COMMAND_LEFT:
          GOTO_XY(positions[*menu_pos], ypos);
          setc(smc->normal_highlight);
          outchr(menu_items[*menu_pos][0]);
          setc(smc->normal_menu_item);
          outstr(menu_items[*menu_pos]+1);

          if(!*menu_pos)
            *menu_pos=amount-1;
          else
            --*menu_pos;
            
            setc(smc->current_highlight);
            GOTO_XY(positions[*menu_pos], ypos);
            outchr(menu_items[*menu_pos][0]);
            setc(smc->current_menu_item);
            outstr(menu_items[*menu_pos]+1);

          if(modem_speed>2400 || !using_modem)
            GOTO_XY(positions[*menu_pos], ypos);
          
          break;
          
        case COMMAND_RIGHT:
          GOTO_XY(positions[*menu_pos], ypos);
            setc(smc->normal_highlight);
            outchr(menu_items[*menu_pos][0]);
            setc(smc->normal_menu_item);
            outstr(menu_items[*menu_pos]+1);
          if(*menu_pos==amount-1)
            *menu_pos=0;
          else
            ++*menu_pos;
            
            setc(smc->current_highlight);
            GOTO_XY(positions[*menu_pos], ypos);
            outchr(menu_items[*menu_pos][0]);
            setc(smc->current_menu_item);
            outstr(menu_items[*menu_pos]+1);
            
          if(modem_speed>2400 || !using_modem)
            GOTO_XY(positions[*menu_pos], ypos);

          
          break;
          
        default:
          return(event);
          
      }
    }
  } // While !hangup   
  return(0);      
}          




void show_common_mods(void)
{
  existprint("COMMON.LST");
}



#ifdef TEST_VM
void test_vm(void)
{
  inputeditrec input1, input2;
  showtextrec text1, text2;

  varimenurec *menu=NULL, newmenu;
  varimenuinfo info={YELLOW+(BLUE<<4), RED+(BLUE<<4), BLACK+(CYAN<<4), RED+(CYAN<<4), DARKGRAY+(BLUE<<4),
                     COMMON_FULL, 0, 0, 0, 0, 0};
  int done=0;

  enum TEST_STUFF
  {
    LOGON,
    CHAT,
    EMAIL,
    GOODBYE
  };


  build_showtextrec(&text1, 5, 5, 17, "Logon", JUSTIFY_CENTER, '');
  fillvarimenurec(&newmenu, &text1, SHOW_TEXT_TYPE, 0, LOGON, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_showtextrec(&text2, 5, 7, 17, "GoodBye", JUSTIFY_CENTER, '');
  fillvarimenurec(&newmenu, &text2, SHOW_TEXT_TYPE, 0, GOODBYE, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_inputrec(&input1, 30, 5, 9, 17, 1, IE_MIXED);
  fillvarimenurec(&newmenu, &input1, INPUT_EDIT_TYPE, 0, CHAT, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);


  build_inputrec(&input2, 30, 5, 11, 17, 1, IE_PROPPER);
  fillvarimenurec(&newmenu, &input2, INPUT_EDIT_TYPE, 0, EMAIL, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);


  // Print out ansi or prep screen in other way
  CLS();

  while(!done && !hangup)
  {
    varimenu(menu, &info);

    switch(info.event)
    {
      case EXECUTE:
        switch(info.returnvalue)
        {
          case GOODBYE:
          case GET_OUT:
            done=1;
            break;
          default:
            info.redraw=COMMON_NONE;
            break;
        }
        break;

      case GET_OUT:
        done=1;
        break;

      default:
        info.redraw=COMMON_NONE;
        break;
    }

  }

  killvarimenu(menu);
  CLS();
}
#endif   // end ifdef test_var




// Waits for 'seconds' seconds, does not exit on comhit
void wait_sec(double seconds)
{
  time_t time1;
  time_t time2;

  time(&time1);
  time(&time2);

  if( seconds == 1 )
    ++seconds;

  while(difftime(time2,time1) < seconds && !hangup)
    time(&time2);
}


long filesize(FILE *stream)
{
  long curpos, length;
  
  curpos=ftell(stream);
  
  fseek(stream, 0L, SEEK_END);
  length=ftell(stream);
  
  fseek(stream, curpos, SEEK_SET);
  
  return length;
}



int fset_rec(FILE *stream, unsigned rec, unsigned rec_size)
{
  int error;
  
  error = fseek(stream, (long) ((rec)*((long)rec_size)), SEEK_SET);

#if 0
  if(error)
    ; // Could not set rec
#endif

  return(!error);
}

int set_rec(int filenum, unsigned rec, unsigned rec_size)
{
  int error;
  
  error = sh_lseek(filenum, (long) ((rec)*((long)rec_size)), SEEK_SET);

#if 0
  if(error)
    ; // Could not set rec
#endif

  return(!error);
}





/*
  ASYLUM INI function - COMMON
*/



/* ----------------------------------------------------------------------

  What was changed?



The flags explained:
  IF_NONE - Open up the ini file in read/write mode

  IF_STC  - When doing a write, it will look for the identifier hidden
            behind a comment, and replace that commented out line with
            the value you are specifing

  IF_STCR - When doing a read, it will remove the first comment to see if
            the identifier exists behind a comment.  Not meant to be used
            all the time, since the person might actually want the item
            commented out.

  IF_OREAD - Opens ini file in read only mode.  No changes will be saved

  IF_WINR - When doing a read, if the identifier doesn't exist, it will
            do a write with the contents of what you have in the buffer,
            it is up to you to put a good value here.




------------------------------------------------------------------------- */





char bool_strings[AMOUNT_BOOLS][2][8] = {{ "YES",  "NO" },
                                         { "TRUE", "FALSE"},
                                         { "ON",   "OFF"},
                                         { "1",    "0"}};
static int which_bool;





ini_record * open_ini(char *fname, unsigned long flags)
{
  ini_record *ini;


  ini=(ini_record *)MALLOC(sizeof(ini_record));
  if(!ini)
    return NULL;

  memset((void *) ini, 0, sizeof(ini_record));


  fix_ini_name(fname);

  strcpy(ini->fname, fname);
  ini->fp = FOPEN(fname, "rt");       /* if it doesn't exist, no error      */

  ini->flags = flags;
  return ini;
}

void close_ini(ini_record *ini)
{
  /* if there is no ini allocated, then there is nothing */
  /* to free up and close                                */
  if(!ini)
    return;

  release_ini_section(ini);     /* free the data rows       */

  if(ini->patt_idents)
    FREE(ini->patt_idents);

  if(ini->fp)
    FCLOSE(ini->fp);

  FREE(ini);                    /* free the whole structure */
}

char *ini_read_string(ini_record *ini, char *area, char *ident, char *buff)
{
  char line[MAX_LINE_WIDTH];
  char *data, *comment;
  int x;

  strip_string(area);
  strip_string(ident);

  read_ini_area(ini, area);    /* read area in, if needed */


  x = does_ident_exist(ini, area, ident);  /* x points to the line in the   */
  if(x)                                    /* ini rows that the line exists */
  {                                        /* or 0 for not exist, but is 1  */
    --x;                                   /* relative, so make 0 relative  */
    strcpy(line, ini->ini_rows[x]);

    if(ini->flags & INI_FLAGS_SEE_THROUGH_ON_READ)
    {
      strip_string(line);       /* if first char is a comment */
      if(line[0] == ';')        /* then turn it into a space  */
        line[0]=' ';
    }

    comment=strchr(line, ';');
    if(comment)
      comment[0] = 0;

    data=strchr(line, '=');
    if(data)
    {
      data[0] = 0;
      ++data;
    }

    strip_string(line);

    if(!data)
      buff[0] = 0;
    else
      strcpy(buff, strip_string(data));

    return buff;
  }
  else    /* see if the option to add it if it doesn't exist is on */
  {
    if(ini->flags & INI_FLAGS_WRITE_IF_NO_READ)
    {
      if(ini_write_string(ini, area, ident, buff))
        return buff;
      else
      {
        buff[0]=0;
        return NULL;
      }
    }
  }


  buff[0] = 0;
  return NULL;
}

long ini_read_number(ini_record *ini, char *area, char *ident)
{
  char line[MAX_LINE_WIDTH];

  line[0]=0;    /* just in case we have write on fail, don't write junk */
  if(ini_read_string(ini, area, ident, line))
    return(atol(line));

  return 0;
}

int ini_read_boolean(ini_record *ini, char *area, char *ident)
{
  char line[MAX_LINE_WIDTH];
  ini_read_string(ini, area, ident, line);

  line[0] = toupper(line[0]);

  switch(line[0])
  {
    case 'Y':        /* yes  */
    case 'T':        /* true */
    case '1':        /* 1    */
      return 1;

    case 'O':        /* maybe on */
      if(strcmpi(line, "ON") == 0)
        return 1;

    default:         /* if it isn't on, it must be off */
      return 0;
  }
}

int ini_write_boolean(ini_record *ini, char *area, char *ident, int value)
{
  char temp[21];

  sprintf(temp, "%ld", value);
  return(ini_write_string(ini, area, ident, bool_strings[which_bool][value ? 1 : 0]));
}


void set_boolean_value(int value)
{
  which_bool = value;
}

int get_boolean_value(void)
{
  return which_bool;
}




int ini_write_string(ini_record *ini, char *area, char *ident, char *value)
{
  char line[MAX_LINE_WIDTH], new_line[MAX_LINE_WIDTH];
  char *comment, *data;
  int x = 0, junk;

  strip_string(area);
  strip_string(ident);

  read_ini_area(ini, area);     /* if needed, read in ini area */

  /* first see if identifier already exists, and mod it if so */
  x = 0;
  while(x < ini->amount_rows)
  {
    strcpy(line, ini->ini_rows[x]);
    strip_string(line);

    if(ini->flags & INI_FLAGS_SEE_THROUGH_COMMENTS)
    {
      if(line[0] == ';')
        line[0] = ' ';
    }


    comment=strchr(line, ';');
    if(comment)
      { comment[0] = 0; ++comment; }


    data=strchr(line, '=');
    if(data)
    {
      data[0] = 0;
      ++data;
    }

    strip_string(line);
    if(strcmpi(line, ident) == 0)
    {
      sprintf(new_line, "%" INI_COL_WIDTH "s = %s", ident, value);

      /*
         -----------------------------------------
         If there was a comment, then pad our line
         out to the size we have specified in the
         #define INI_COMMENT_POS, then append the
         comment to the end of our line
         -----------------------------------------
      */

      if(comment && comment[0])         // first see if there was a comment
      {
        junk = strlen(new_line);        // now find out how long our string is
        while(junk < INI_COMMENT_POS-1) // if we are less than the size we
        {                               // have defined, then pad it with
          new_line[junk] = ' ';         // spaces to the size we have defined
          ++junk;
        }
        new_line[junk]=0;               // append a null
        strcat(new_line, "; ");         // and concatenate our comment letter
        strip_string(comment);
        strcat(new_line, comment);      // and finally the comment
      }


      strip_string(new_line);           // remove any random spaces
      return(replace_in_ini_lines(ini, new_line, x));

    }
    ++x;
  }
  sprintf(new_line, "%" INI_COL_WIDTH "s = %s", ident, value);
  return(addto_ini_lines(ini, new_line, 1));
}

int ini_write_number(ini_record *ini, char *area, char *ident, long value)
{
  char temp[21];

  sprintf(temp, "%ld", value);
  return(ini_write_string(ini, area, ident, temp));
}


int ini_remove_ident(ini_record *ini, char *area, char *ident)
{
  int x;

  strip_string(area);
  strip_string(ident);


  read_ini_area(ini, area);    /* if needed, read in ini area */

  x = does_ident_exist(ini, area, ident);

  if(x)
  {
    --x;                      /* make x zero relative */
    return(remove_from_ini_lines(ini, x));
  }
  return 0;                   /* nothing removed      */
}

void ini_remove_area(ini_record *ini, char *area)
{
  strip_string(area);

  release_ini_section(ini);    /* write and release any current changes */
  strcpy(ini->area, area);     /* next time the disk is flushed, this   */
  ini->modified = 1;           /* area of nothing will be written to    */
                               /* disk, effectivly removing the old     */
                               /* section                               */
}




/* sees if an identifer exists in a given section, if it does, it will   */
/* return a pointer to it + 1, ie, if it returns 1, then it is the first */
/* identifer in the ini->ini_rows position (ini_rows[0])                 */
int does_ident_exist(ini_record *ini, char *area, char *ident)
{
  char line[MAX_LINE_WIDTH];
  char *data;
  int x = 0;

  strip_string(area);
  strip_string(ident);

  read_ini_area(ini, area);        /* if needed, read in ini area  */

  x = 0;
  while(x < ini->amount_rows)
  {
    strcpy(line, ini->ini_rows[x]);


    if(ini->flags & INI_FLAGS_SEE_THROUGH_ON_READ)
    {
      strip_string(line);    /* if the first char is a comment */
      if(line[0] == ';')     /* then turn comment into a space */
        line[0]=' ';
    }


    data=strchr(line, '=');
    if(data)
      data[0] = 0;

    strip_string(line);


    if(strcmpi(line, ident) == 0)
      return x+1;                  /* return 1 relative position to ident */

    ++x;
  }
  return 0;           /* identifer doesn't exist */
}

int does_ini_area_exist(ini_record *ini, char *area)
{
  char line[MAX_LINE_WIDTH], fix_area[101];
  int x;

  strip_string(area);

  if(strcmpi(area, ini->area)==0) /* if we have it in memory... */
    return 1;                     /* then it does exist         */

  if(!ini->fp)       /* if the file doesn't yet exist, it doesn't exist */
    return 0;

  strip_string(area);
  if(area[0]=='[')
    strcpy(fix_area, area);
  else
    sprintf(fix_area, "[%s]", area);

  x = strlen(fix_area);

  fseek(ini->fp, 0, SEEK_SET);
  while(1)
  {
    if(!fgets(line, MAX_LINE_WIDTH, ini->fp))
      return 0;                        /* section doesn't exist */

    strip_string(line);

    if(strncmpi(fix_area, line, x) == 0)
      return 1;
  }
}

int get_ident_positions(ini_record *ini, char *area, char *ipattern)
{
  int amount;

  read_ini_area(ini, area);

  if(ini->patt_idents)
  {
    FREE(ini->patt_idents);
    ini->patt_idents = NULL;
  }

  amount = get_ident_patterns(ini, area, ipattern, 0);

  ini->patt_idents = (int *) MALLOC(amount * (sizeof(int)));
  if(!ini->patt_idents)
    { ini->amount_patt_idents = 0; return 0; }


  get_ident_patterns(ini, area, ipattern, 1);

  return(amount);
}

int get_ident_patterns(ini_record *ini, char *area, char *ipattern, int getem)
{
  char line[MAX_LINE_WIDTH];
  int amount=0, pos = 0, len = strlen(ipattern);

  read_ini_area(ini, area);

  while(pos < ini->amount_rows)
  {
    strcpy(line, ini->ini_rows[pos]);

    strip_string(line);
    if(strncmpi(line, ipattern, len) == 0)
    {
      if(getem)                          /* memory has to be allocated */
        ini->patt_idents[amount] = pos;  /* before this can be done    */
      ++amount;
    }

    ++pos;
  }
  ini->amount_patt_idents = amount;
  return amount;
}



char *fix_ini_name(char *fname)
{
  char *tmp;

  strupr(fname);
  strip_string(fname);

  tmp = strchr(fname, '.');
  if(tmp)                          /* if extension exists      */
    return fname;                  /* then no change is needed */

  fname[8]=0;
  strcat(fname, ".INI");
  return(fname);
}


int ini_write_changes(ini_record *ini)
{
  FILE *new_file;
  char tmp_fname[13], line[MAX_LINE_WIDTH], fixed_area[MAX_LINE_WIDTH];
  char new_name[130], *s;
  int area_width, i=0;
  
  if (!ini->modified)                  /* it it wasn't modified, then */
    return 2;                          /* there is no need to write   */
  
  if (ini->flags & INI_FLAGS_READ_ONLY)/* if in read only mode then */
    return 3;                          /* we obviously can't write  */
  
  
  tmpnam(tmp_fname);
  new_file=FOPEN(tmp_fname, "wt");
  if (!new_file)                       /* couldn't open file for writting */
    return 0;
  
  
  /*
      ------------------------------------------------------------
    if the file didn't exist, then we can't read from it, flush it,
    seek in it, or anything else, so jump right to the write part
      ------------------------------------------------------------
  */
  if (!ini->fp)
    goto WRITE_AREA;
  

  fflush(ini->fp);
  
  strip_string(ini->area);
  if(ini->area[0] == '[')
    strcpy(fixed_area, ini->area);
  else
    sprintf(fixed_area, "[%s]", ini->area);
  area_width=strlen(fixed_area);
  
  fseek(ini->fp, 0, SEEK_SET);         /* jump to start of file */
  while (ini->fp)
  {
    if (fgets(line, MAX_LINE_WIDTH, ini->fp)==NULL)
      break;
    
    strip_string(line);
    
    if (ini->modified && strncmpi(fixed_area, line, area_width)==0)
    {
      int x;
      x=0;
      
      while (1)
      /* bypass this area so we can write updated memory */
      {
        if (fgets(line, MAX_LINE_WIDTH, ini->fp)==NULL)
          break;
        strip_string(line);
        if (line[0]=='[') {             /* start of a new area */
          i=1;       // so it will write the line after the area,
          break;     // and not skipping it.
        }
      }
      
WRITE_AREA:
      fprintf(new_file, "%s\n", fixed_area);
      x=0;
      while (x<ini->amount_rows)
      {
        if (ini->ini_rows[x])  /* if it hasn't been free'd, the write it */
          fprintf(new_file, "%s\n", ini->ini_rows[x]);
        x++;
      }
      ini->modified=0;  /* once written, then it isn't modified anymore */

      if (i==1)
      {
        i=0; /* Write the extra line forgot by the previous routine */
        /* (the one that was just read, but was a new area)         */
        fprintf(new_file, "\n%s\n", line);
      }
    }
    else
      fprintf(new_file, "%s\n", line);
  }
  if (ini->modified)
    goto WRITE_AREA;
  
  /* no need to check new_file against NULL here, it is checked above */
  FCLOSE(new_file);
  
  if (ini->fp)
  {
    FCLOSE(ini->fp);
    ini->fp=NULL;
  }
  
  
  strcpy(new_name, ini->fname);        /* rename our ini file to a .BAK */
  s=strchr(new_name, '.');             /* so that we will have a name   */
  if (s)                               /* for our tmpfile               */
    strcpy(s, ".BAK");
  else
    strcat(new_name, ".BAK");
  
  unlink(new_name);                    /* make room for out backup      */
  rename(ini->fname, new_name);
  
  copyfile(tmp_fname, ini->fname, 0);
  unlink(tmp_fname);
  
  
  ini->fp=FOPEN(ini->fname, "rt");
  
  return 1;
}


void release_ini_section(ini_record *ini)
{
  int x = 0;

  ini_write_changes(ini);

  x = 0;
  while(x < ini->amount_rows)
  {
    if(ini->ini_rows[x])
      FREE(ini->ini_rows[x]);

    ini->ini_rows[x] = NULL;

    ++x;
  }

  if(ini->ini_rows)
    FREE(ini->ini_rows);

  ini->area[0] = 0;
  ini->ini_rows = NULL;
  ini->amount_rows = 0;
  ini->rows_allocated = 0;
}







int read_ini_area(ini_record *ini, char *area)
{
  char line[MAX_LINE_WIDTH];

  strip_string(area);


  if(strcmpi(area, ini->area) == 0)   /* already read in */
    return 2;

  release_ini_section(ini);

  if(!ini->fp)                     /* if the file doesn't exist then */
  {                                /* consider it read               */
    strcpy(ini->area, area);       /* add it as area read            */
    return 1;
  }

  /* if area does exist, the function leaves the disk pointer at the */
  /* part of that area, so just start reading in the area from the   */
  /* current disk pointer                                            */
  if(does_ini_area_exist(ini, area))
  {
    strcpy(ini->area, area);       /* add it as area read            */
    while(1)
    {
      if(!fgets(line, MAX_LINE_WIDTH, ini->fp))
      {
        ini_pack_lines(ini);       /* remove trailing blank lines    */
        return 1;
      }

      strip_string(line);
      if(line[0] == '[')
      {
        ini_pack_lines(ini);       /* remove trailing blank lines    */
        return 1;                  /* done, starting a new section   */
      }

      addto_ini_lines(ini, line, 0);
    }
  }
  else   /* don't actually need this else statement, but... */
  {
    strcpy(ini->area, area);    /* add the area if it doesn't exist */
    ini->modified=1;            /* and set the modified flag        */
  }

  return 0;                     /* nothing there to read */
}




int addto_ini_lines(ini_record *ini, char *line, int modify)
{
  char **tmp;

  if(ini->amount_rows == 0xffff)    /* max rows is 0xffff (65535) */
    return 0;                       /* line not added             */

  if(ini->amount_rows >= ini->rows_allocated)
  {
    tmp = (char **)REALLOC(ini->ini_rows, (ini->rows_allocated+100) * sizeof(char *));

    if(!tmp)
      return 0;                /* couldn't allocate 100 more rows     */

    ini->ini_rows = tmp;       /* point our pointer to our new memory */
    ini->rows_allocated += 100; /* added 100 rows of allocation space  */
  }

  ini->ini_rows[ini->amount_rows] = (char *)MALLOC(strlen(line)+1);
  if(!ini->ini_rows[ini->amount_rows])
    return 0;


  strcpy(ini->ini_rows[ini->amount_rows++], line);
  if(modify)
    ini->modified = 1;
  return 1;
}

void ini_pack_lines(ini_record *ini)
{
  int x = ini->amount_rows-1;

  while(x > -1)
  {
    if(ini->ini_rows[x])
    {
      strip_string(ini->ini_rows[x]);

      if(ini->ini_rows[x][0] != 0)
        break;

      FREE(ini->ini_rows[x]);
      ini->ini_rows[x]=NULL;
    }

    --x;
  }

  if(ini->ini_rows[x][0] || x == -1)
    ++x;

  ini->amount_rows = x;
}



int replace_in_ini_lines(ini_record *ini, char *line, int x)
{
  char *tmp;

  tmp = (char *)REALLOC(ini->ini_rows[x], strlen(line)+1);
  if(!tmp)
    return 0;

  ini->ini_rows[x] = tmp;    /* point our realloced memory to the ini rows */
  strcpy(ini->ini_rows[x], line);
  ini->modified = 1;
  return 1;
}

int remove_from_ini_lines(ini_record *ini, int x)
{
  if(x >= ini->amount_rows)
    return 0;                /* out of range, nothing removed       */

  if(ini->ini_rows[x])
    FREE(ini->ini_rows[x]);  /* just free it and set it to          */
  ini->ini_rows[x] = NULL;   /* NULL, don't worry about removing it */

  ini->modified = 1;
  return 1;                  /* identifer properly removed          */
}



int amount_areas_names(ini_record *ini)
{
  int found = 0;
  char line[MAX_LINE_WIDTH];

  release_ini_section(ini);

  if(!ini->fp)
    return NULL;


  fseek(ini->fp, 0, SEEK_SET);
  while(1)
  {
    if(!fgets(line, MAX_LINE_WIDTH, ini->fp))
      return found;

    strip_string(line);

    if(line[0] == '[')
      ++found;
  }
}

/*
  Reads all areas names into buffer which must be allocated as such:

  char *buffer[MAX_LINE_WIDTH];
  amount = amount_ini_areas(ini);
  buffer = (buffer *[]) MALLOC(amount * MAX_LINE_WIDTH);
  read_ini_areas(ini, buffer, amount);
  ...
  FREE(buffer);


  It reads a max of 'max' areas and returns the actual amount of areas
  that were read
*/

int get_area_names(ini_record *ini, char (*buffer)[MAX_LINE_WIDTH], int max)
{
  int found = 0;
  char line[MAX_LINE_WIDTH];

  release_ini_section(ini);

  if(!ini->fp)
    return NULL;


  fseek(ini->fp, 0, SEEK_SET);
  while(1)
  {
    if(!fgets(line, MAX_LINE_WIDTH, ini->fp))
      return found;

    strip_string(line);

    if(line[0] == '[')
    {
      if(found < max)
        strcpy(buffer[found], line);
      else
        return 0;  /* more areas than we specified the max was */

      ++found;
    }
  }
}



