#include "qwkvars.h"

long qwk_ready_max_size = 60000L;

void read_ini_file(char *inifile)
{
  char fname[201];
  char temp[31];
  int x, fatal=0;

  strcpy(fname, inifile);
  if(!strchr(fname, '.'))
    strcat(fname, ".INI");

  if(!open_ini_file(fname, &ini_info))
  {
    print_message("Couldn't open %s (ini file)", fname);
    exit(NO_INI);
  }



#ifdef REG
  asm int 3
#endif


  logfilename[0]=0;
  read_ini_string(&ini_info, "General", "Log File", logfilename, 127);

  if(logfilename[0]!=0)
  {
    logfile=fopen(logfilename, "w+b");
    if(!logfile)
      print_message("Warning: Couldn't open logfile\r\n");
  }


  /* ----------------------------------------------------------------- */
  /* which_node = LOCAL for local node, REMOTE for remote node         */
  /* to use in the fromsys part of the packet generation               */
  /* ----------------------------------------------------------------- */
  strcpy(temp, "Remote");
  read_ini_string(&ini_info, "General", "Which Node", temp, 10);
  strupr(temp);

  if(temp[0]==0)
    print_message("Warning: No 'Which Node' setup, setting to LOCAL");

  if(strcmp(temp, "REMOTE")==0)
    which_node = NODE_REMOTE;
  else if(strcmp(temp, "LOCAL")==0)
    which_node = NODE_LOCAL;
  else
  {
    print_message("Error: 'Which Node' must either be 'LOCAL' or 'REMOTE'");
    ++fatal;
  }



  /* ----------------------------------------------------------------- */
  /* Read in the temporary directory to use for extracting QWK packets */
  /* If it doesn't exist in the INI file, then display error           */
  /* ----------------------------------------------------------------- */
  temp_dir[0]=0;
  read_ini_string(&ini_info, "General", "Temp", temp_dir, 127);
  if(temp_dir[0]==0)
  {
    ++fatal;
    print_message("Error  : No temp dir is setup\r\n");
  }
  x=strlen(temp_dir)-1;
  if(temp_dir[x] != '\\')
    strcat(temp_dir, "\\");

   /* ---------------------------------------------------------------- */
  /* Read in the source wwiv packet                                    */
  /* This is the complete pathname, ie D:\WWIV\WWIVNET\S4053.NET       */
  /* of the packet your are converting to QWK style                    */
  /* ----------------------------------------------------------------- */
  source_wwiv_file[0]=0;
  read_ini_string(&ini_info, "Packets", "Source WWIV Packet", source_wwiv_file, 127);
  if(source_wwiv_file[0]==0)
  {
    ++fatal;
    print_message("Error  : No source WWIV Packet is setup\r\n");
  }

#ifdef REG
  setvect(3, new_int_3);
  asm int 3
#endif


  /* ------------------------------------------------------------------- */
  /* Read in the destination WWIV file, this again is the full path name */
  /* ie, D:\WWIV\WWIVNET\P9.NET of the packet you are turning from a QWK */
  /* to a wwiv file                                                      */
  /* ------------------------------------------------------------------- */

  dest_wwiv_file[0]=0;
  read_ini_string(&ini_info, "Packets", "Dest WWIV Packet", dest_wwiv_file, 127);

  if(dest_wwiv_file[0]==0)
  {
    ++fatal;
    print_message("Error  : No dest WWIV Packet is setup\r\n");
  }


  /* ------------------------------------------------------------------- */
  /* The source dir of where the QWK being converted into a WWIV packet  */
  /* is located.  This is only the directory, not the full packet name   */
  /* ie   D:\COMM\DOWNLOAD                                               */
  /* ------------------------------------------------------------------- */
  source_qwk_dir[0]=0;
  read_ini_string(&ini_info, "Packets", "Source QWK dir", source_qwk_dir, 127);

  if(source_qwk_dir[0]==0)
    strcpy(source_qwk_dir, ".\\");

  x=strlen(source_qwk_dir)-1;
  if(source_qwk_dir[x] != '\\')
    strcat(source_qwk_dir, "\\");


  /* --------------------------------------------------------------------  */
  /* The destination directory is the directory the converted wwiv packet  */
  /* turned into a QWK packet will end up.  This is only the dir name, not */
  /* the full path and packet name.  ie,  D:\COMM\UPLOAD                   */
  /* --------------------------------------------------------------------- */

  dest_qwk_dir[0]=0;
  read_ini_string(&ini_info, "Packets", "Dest QWK dir", dest_qwk_dir, 127);

  if(dest_qwk_dir[0]==0)
  {
    strcpy(dest_qwk_dir, ".\\");
    print_message("Warning: No Dest QWK dir setup\r\n");
  }
  x=strlen(dest_qwk_dir)-1;
  if(dest_qwk_dir[x] != '\\')
    strcat(dest_qwk_dir, "\\");


  /* ----------------------------------------------------------------- */
  /* this_system holds YOUR node number.  As this program is not wwiv  */
  /* specific, it does NOT open up your wwiv data files, you must put  */
  /* your node number here so that the program knows what to do with   */
  /* your messages                                                     */
  /* ----------------------------------------------------------------- */

  this_system=read_ini_number(&ini_info, "System", "Node", 0);
  if(this_system == 0)
  {
    print_message("Fatal: Enter your NODE # in the INI file under section [General]\r\n");
    ++fatal;
  }

  /* ----------------------------------------------------------------- */
  /* The following four items, bbs_name, bbs_address, bbs_phone and    */
  /* bbs_sysop are just information bits that go in the QWK side of    */
  /* a packet in a file called CONTROL.DAT                             */
  /* ----------------------------------------------------------------- */

  bbs_name[0]=0;
  read_ini_string(&ini_info, "System", "BBS Name", bbs_name, 50);
  if(bbs_name[0] == 0)
    print_message("Warning: Put your BBS NAME in the INI file under section [General]\r\n");


  bbs_address[0]=0;
  read_ini_string(&ini_info, "System", "BBS Address", bbs_address, 50);
  if(bbs_address[0] == 0)
    print_message("Warning: Put your BBS ADDRESS in the INI file under section [General]\r\n");

  bbs_phone[0]=0;
  read_ini_string(&ini_info, "System", "BBS Phone", bbs_phone, 20);
  if(bbs_phone[0] == 0)
    print_message("Warning: Put your BBS PHONE in the INI file under section [General]\r\n");

  bbs_sysop[0]=0;
  read_ini_string(&ini_info, "System", "BBS Sysop", bbs_sysop, 50);
  if(bbs_sysop[0] == 0)
    print_message("Warning: Put your BBS SYSOP name in the INI file under section [General]\r\n");


#ifdef REG
  setvect(3, new_int_3);
  asm int 3
#endif


  /* -------------------------------------------------------------------- */
  /* system_id is the 8 character 'QWK' name for your board that is used  */
  /* to generate both the QWK packet names and the REP packet names...    */
  /* If your board is generating a QWK, the file name will be the         */
  /* "system_id.QWK" someone uploaded a REP to your board, it should be   */
  /* called "system_id.rep"...                                            */
  /* -------------------------------------------------------------------- */
  system_id[0]=0;
  read_ini_string(&ini_info, "System", "System ID", system_id, 20);
  system_id[8]=0;
  if(system_id[0] == 0)
  {
    print_message("Error  : You must setup the 'system_id' field in the INI file\r\n");
    ++fatal;
  }

  /* -------------------------------------------------------------------- */
  /* remote_user is the QWK sysop on the other end that you are connected */
  /* to, this is put in the CONTROL.DAT file                              */
  /* -------------------------------------------------------------------- */
  remote_user[0]=0;
  read_ini_string(&ini_info, "Remote System", "Remote Sysop", remote_user, 50);
  if(remote_user[0]==0)
    print_message("Warning: Go setup the REMOTE SYSOP in the INI file under section [General]\r\n");


  /* -------------------------------------------------------------------- */
  /* remote_id is just like system_id described above, but it is for the  */
  /* other side (your QWK connects system_id).  This is needed so that    */
  /* can build a proper REP file to his (his system_id is used as the REP */
  /* file name).  His system_id will also be the name of the QWK you      */
  /* receive from him, so the name is needed to know the filenames        */
  /* -------------------------------------------------------------------- */
  remote_id[0]=0;
  read_ini_string(&ini_info, "Remote System", "Remote ID", remote_id, 20);
  remote_id[8]=0;
  if(remote_id[0] == 0)
  {
    print_message("Error  : You must setup the 'remote_id' field in the INI file\r\n");
    ++fatal;
  }


  remote_system=read_ini_number(&ini_info, "Remote System", "Remote Node", 0);
  if(remote_system == 0)
    print_message("Warning: No remote node # in the INI file under section [General]\r\n");






  /* -------------------------------------------------------------------- */
  /* arc_to_use is the archive that will be used to archive the generated */
  /* QWK or REP packet once done.  This information is not used for       */
  /* decompression of the QWK and REP packets as the packet is looked and */
  /* and it determins what type of archiver to extract it with.           */
  /* valid arcs_to_use are ZIP, ZOO, LHA, ARJ and PAK (ARJ goes under PAK */
  /* -------------------------------------------------------------------- */
  temp[0]=0;
  read_ini_string(&ini_info, "General", "Archiver", temp, 5);
  strupr(temp);
  if(strcmp(temp, "ZIP")==0)
    arc_to_use = COMPRESSION_ZIP;
  else if(strcmp(temp, "ARJ") == 0)
    arc_to_use = COMPRESSION_ARJ;
  else if(strcmp(temp, "LHA") == 0)
    arc_to_use = COMPRESSION_LHA;
  else if(strcmp(temp, "PAK") == 0)
    arc_to_use = COMPRESSION_PAK;
  else if(strcmp(temp, "ZOO") == 0)
    arc_to_use = COMPRESSION_ZOO;
  else
  {
    print_message("Warning: Undefined ARCHIVER command (must be ZIP, ARJ, LHA, PAK, or ZOO)\r\n");
    print_message("         Defaulting to ZIP\r\n");
    arc_to_use = COMPRESSION_ZIP;
  }


  /* ----------------------------------------------------------------- */
  /* email_sub is the QWK sub number that email will be put into       */
  /* ----------------------------------------------------------------- */
  email_sub=read_ini_number(&ini_info, "Sub Type to Sub Num", "PRIVATE E-MAIL", 0);


  /* ------------------------------------------------------------------ */
  /* build_index is a true or false flag, should .NDX files be built    */
  /* or not (it is not known at this time if they are needed            */
  /* ------------------------------------------------------------------ */
  build_index = read_ini_boolean(&ini_info, "General", "Build Index Files", "NO");


  /* ------------------------------------------------------------------ */
  /* convert_high is a true or false, should char value > 127 be turned */
  /* into a value less than 128?                                        */
  /* ------------------------------------------------------------------ */
  convert_high = read_ini_boolean(&ini_info, "General", "Convert High Ascii to Low", "YES");


  /* ------------------------------------------------------------------ */
  /* pre_post is a true of flase field, should generated posts be       */
  /* pre_post, or should they be posts from the host?  This is only     */
  /* for numerical subtypes, as the new_posts (post by alpha numeric    */
  /* subtype) doesn't not have a 'pre-post and post by host' types      */
  /* ------------------------------------------------------------------ */
  pre_post = read_ini_boolean(&ini_info, "General", "Build Pre-Posts", "YES");



  /* ------------------------------------------------------------------- */
  /* Unknown user and sys are where unknown mail should be sent to       */
  /* this includes all messages that are marked private (from qwk)       */
  /* ------------------------------------------------------------------- */

  unknown_user=read_ini_number(&ini_info, "General", "Unknown User", 0);
  unknown_sys=read_ini_number(&ini_info, "General", "Unknown Sys", 0);



  if(fatal)
  {
    print_message("\r\n%d fatal errors\r\n", fatal);
    close_up_show();
    exit(FATAL_INI);
  }

#ifdef REG
  setvect(3, new_int_3);
#endif


}

time_t months_since_1990(unsigned long months)
{
  struct time t;
  struct date d;

  unsigned years;

  years=months/12;
  months=months-(years*12);

  memset(&t, 0, sizeof(struct time));

  d.da_mon=months;
  d.da_day=1;
  d.da_year=1990+years;

  return(dostounix(&d, &t));
}


void do_register(void)
{
  char name[201], r[201], k1[201], k2[201];

  gets(name);
  gets(r);
  gets(k1);
  gets(k2);


  put_ini_value("QWKCNVT.INI", "Registration", "Registered to", name);
  put_ini_value("QWKCNVT.INI", "Registration", "Registration number", r);
  put_ini_value("QWKCNVT.INI", "Registration", "Key code 1", k1);
  put_ini_value("QWKCNVT.INI", "Registration", "Key code 2", k2);

  printf("\nQWKCNVT.INI file updated!\n");
}


/* ------------------------------------------------------------------------ */
/* Evaluations registration will be noted by the fact that the registration */
/* number will be less than 1000 (0-999)                                    */
/*                                                                          */
/* Limited registration will have the letters 'LR' appended to the end of   */
/* the registered sysops name                                               */
/* ------------------------------------------------------------------------ */

void check_registration(void)
{
  registered = REGISTERED;
  tag_string[0] = 0;
}

// void check_registration(void)
// {
//   char first[101], second[101];
//   char temp[101];
//   unsigned long r1, r2;
//   int istemp=0;         /* is temp flags if this is a temporary reg# or not */
//
//
//   if(reg_number > 0 && reg_number<1000)
//   {
//     istemp=1;
//     if(first_time > months_since_1990(reg_number))
//     {
//       expired_key();
//       exit(MISC_FATAL);
//     }
//   }
//
//   strcpy(temp, sysop_registered);
//
//   sprintf(first, "%s%010ld", temp, reg_number);
//   convert_string(first, second);
//
//   r1=atol(reg_code1);
//   r2=atol(reg_code2);
//
//   if(bp(first, 53000)==r1)
//     ++registered;
//
//   if(bp(second, 5682)==r2)
//     ++registered;
//
//   if(registered == REGISTERED || registered == LIMITED_REGISTER)
//   {
//     int x;
//     x=strlen(sysop_registered);
//
//     if(sysop_registered[x-2] == 'L' && sysop_registered[x-1] == 'R')
//       registered=LIMITED_REGISTER;
//
//     if(istemp)
//       registered=EVAL_REGISTER;
//   }
//
//   if(registered != REGISTERED && registered != LIMITED_REGISTER)
//   {
//     registered = 0;
//     sprintf(tag_string, "\r\n--- Unregistered QWK<->WWIV v.%s - FOR PERSONAL USE ONLY!!\r\n", VER);
//   }
//   else
//     sprintf(tag_string, "\r\n--- QWK<->WWIV v.%s - Reg#%ld\r\n", VER, reg_number);
//
// }


void out_of_date(void)
{
  window(1, 1, 80, 25);
  clrscr();

  printf("Sorry, this copy of QWK<->WWIV message converter has expired\n\n"
         "Don't dispare.... if you have not had your full 30 day evaluation period, you\n"
         "can get a temporary key by calling my BBS at the following number:\n"
         "     Asylum HQ            or alternatly    Sam's BBS\n"
         "     (703) 427-1214                        (409) 729-1319\n\n"
         "or write:\n"
         "     Michael Deweese\n"
         "     4246 Wilson Moutain Road\n"
         "     Roanoke, VA 24014\n");

  exit(MISC_FATAL);
}

void expired_key(void)
{
  window(1, 1, 80, 25);
  clrscr();

  printf("Sorry, the key you are using with this copy of QWK<->WWIV message convert has\n"
         "now expired.  If there are any questions about this, or the key expired\n"
         "prematurely, contact me at the below address.  If all has been well, and you\n"
         "have used up your time, it would now be time to register.\n"
         "\n"
         "Registration is a painless $25, though a less painless amount could be worked\n"
         "out under certain cercumstances.\n"
         "\n"
         "Send registration to:\n"
         "\n"
         "      Michael Deweese\n"
         "      4246 Wilson Mountain Road\n"
         "      Roanoke, VA 24014\n"
         "      BBS: (703) 427-1214\n");

  exit(MISC_FATAL);
}

