Zack Ives #3 @11729
Sat Jul 01 09:24:13 1995
Response To: ALL                      

͸
 Mod Name: Zack02A.424                           Difficulty:  
 Release Date: 06/25/95                           WWIV Version: 4.24 
 Files Modified: BBS.C, BBSOVL1.C        Author: Zack Ives #3 @11729 
                                                                     
 Description:  Allows every locally hosted sub to have its own       
 moderator, who gets Limited Co-Sysop access in that sub and is      
 listed in the sub list.  Also calls the external MODEDIT.EXE        
 program, which is the moderator editor itself.                      
 Now updated for WWIV 4.24                                           
Ĵ
 Disclaimer:  The author will not be held responsible for any bad    
              consequences arising from using or installing this mod.
  You use it at your own risk.  So back up your source code!         
;

Long Description:  One of the nice features which is lacking in WWIV is
the ability to have moderators for your subs.  This mod rectifies that
problem quite nicely.  It adds a new //ME or //MODEDIT command for the
sysop to edit moderators while online; during WFC, the O key calls up
the same MODEDIT.EXE program.

Revision A:  barely any change to the mod itself, except to remove a 
line of code for interfacing it with my RIPspeed mod.  The main 
difference is that I have fixed the bugs in MODEDIT.EXE, the external
moderator editor program.

Revision for WWIV 4.24:  added support for WWIV 4.24's new spawn 
functions and files.  Added RIP code back in.

    Ŀ
     Notation:  - Remove line 
                = Match line  
                + Add line    
                | Change line 
    

Step 1:  Back up the source files and open MMENU.C for editing.  The
         first section to modify is in void mainmenu(void):

 = if (strcmp(s,"RESETF")==0) {
 =   write_inst(INST_LOC_RESETF,0,INST_FLAGS_ONLINE);
 =   reset_files();
 = }
 + 	if (strcmp(s,"ME")==0 || strcmp(s,"MODEDIT") == 0) {
 + 	  cleared = NEEDCLEAR;
 + #ifdef RIPDRIVE               
 +       if (rd_on())
 +         localrip_deactivate();
 + #endif
 +    	  extern_prog("MODEDIT.EXE", EFLAG_SHRINK|EFLAG_COMIO|
 +          EFLAG_ABORT);
 + #ifdef RIPDRIVE
 +       if (rd_on())
 +    		localrip_activate(sysinfo.ripdir, sysinfo.ripdir);
 + #endif
 +	}
 = if (strcmp(s, "RESETQSCAN")==0) {

Step 2:  Open BBS.C and find void getcaller(void):

 = case 'N':
 =   if (ok_local())
 =     print_local_file("NET.LOG","NETDAT*.LOG");
 =   break;
 +		case 'O':
 + 		  if (ok_local())
 + 			extern_prog("MODEDIT.EXE", EFLAG_SHRINK|
 +            EFLAG_COMIO);
 + 		  break;
 = case 'P':

Step 3:  Open up BBSOVL1.C and find void sublist():

 = char s[80],s1[80],*ss,ch;
 + char s2[80];
 + int moder, nhost;
 + userrec auser;
 + xtrasubsnetrec *xnp;
 =
 = oc = curconfsub; os = usub[cursub].subnum;

Down a ways:

 = while ((i1<num_subs) && (usub[i1].subnum!=-1) && (!abort)) {
 |   sprintf(s,"5%3.3s2",usub[i1].keys);
 =   if (qsc_q[usub[i1].subnum/32]&(1L<<(usub[i1].subnum%32)))
 =     strcat(s,get_string(3));
 =   else
 =     strcat(s,get_string(4));
 +   nhost = 0;
 +   for (moder = 0, xnp = xsubs[usub[i1].subnum].nets; moder <
 +    xsubs[usub[i1].subnum].num_nets; moder++, xnp++)
 +     if (xnp->host != 0)
 +       nhost = -1;
 =   if (net_sysnum || (net_num_max>1)) {
 =     if (xsubs[usub[i1].subnum].num_nets) {

Shortly thereafter:

 =         if (subboards[usub[i1].subnum].anony & anony_val_net)
 =           sprintf(s1,"4[%-8.8s]9 ",ss);
 =         else
 +           if (nhost == 0)
 +             sprintf(s1,"2<%-8.8s>9 ",ss);
 +           else
 =             sprintf(s1,"4<%-8.8s>9 ",ss);
 =         strcat(s,s1);
 =       } else
 =         strcat(s,charstr(11,' '));
 =     strcat(s,"9");
 =   }
 +   sprintf(s2,"%-40.40s",
 +     stripcolors(subboards[usub[i1].subnum].name));
 +   strcat(s,s2);
 +   if (nhost == 0) {
 +     moder = moderator(usub[i1].subnum);
 +   
 +     if (moder == 0)
 +       moder = 1;
 +
 +     read_user(moder,&auser);
 +     sprintf(s2,"3%20.20s9", nam(&auser,moder));
 +     strcat(s,s2);
 +   }
 -   strcat(s,stripcolors(subboards[usub[i1].subnum].name));
 = #ifndef OPT_EXTRA_COLOR

Step 4:  Block copy the following new function to the end of BBSOVL1.C:

int moderator(int subnum)  
{
  int modnum;
  FILE *f;
  char s[80];

  sprintf(s,"%s%s", syscfg.datadir, "moderate.dat");
  f = fopen(s, "r+b");

  if (fseek(f, (long) subnum*2, SEEK_SET))
    return 0;

  if (fread(&modnum, 2, 1, f) != NULL) {
    fclose(f);
    return(modnum);
  } else {
    fclose(f);
    return 0;
  }
}

Step 5:  Run MAKE FCNS to update your FCNS.H file.  Or, if you think
         it's easier, just open FCNS.H and add the following line just
         before the #endif at the end of the file:

int moderator(int subnum);

Step 6:  UUDECODE MODEDIT.EXE (which, due to size, follows in the next
         2 posts) and put it into your WWIV main directory.

Step 7:  Well, that's it...  You should be done, though you may want to
         add the //ME and O commands into your menu files.  The MODEDIT
         program is pretty simple to use, so you shouldn't have any 
         trouble picking up how to use it.

If you have any problems or suggestions, feel free to e-mail me at 
#3 @11729 WWIVnet or #3 @7701 ICEnet.  You can also subscribe to my 
tech support sub for help and my latest mods:  sub-type ZAKSOFT, host 
11729, auto-requestable.
                                                                
