#include "vars.h"
#pragma hdrstop

#include <ctype.h>

typedef struct {
    int  usernumber;
    char addressee[31],
         netaddress[51],
         boardname[75];
} addressrec;

static int OpenAddressBook(void);
static void ViewAddresses(void);
static void SearchAddresses(void);
static void AddAddresses(void);
static void CreateBook(void);
static int AddressFile;
static unsigned int NumberEntries;
static void cline(char *String, int Color, int Center);
static void backline(unsigned char NumLines);
static void TransferAddresses(void);

void AddressBook(void)
{
  addressrec Address;
  char stemp[81],stemp1[81],ch,Done=0;
  unsigned char topsave;

// " NOTE #1 "
  if ((thisuser.sl<=syscfg.newusersl) ||
     (thisuser.restrict & restrict_net) ||    // Any one of these restriction
     (thisuser.restrict & restrict_anony) ||  // can be commented out just by
     (thisuser.restrict & restrict_upload) || // placing a double slash in
     (thisuser.restrict & restrict_logon) ||  // front of the one(s) you
     (restrict_chat & thisuser.restrict) ||   // don't want to use.
     (restrict_email & thisuser.restrict) ||
//     (restrict_vote & thisuser.restrict) ||
     (thisuser.restrict & restrict_automessage) ||
     (restrict_post & thisuser.restrict)) {
     outchr(12);
     pl("6You don't have access to the Address Book. Ask your Sysop why!0");
     nl();
     return;
  }
  irt_name[0]=irt[0]=0;
  if (wfc)
    usernum=1;
  sprintf(stemp,"%sADDRESS\\%d.ADR",syscfg.gfilesdir,usernum);
  if (exist(stemp)) {
    npr("5Old address book found, download now? 0");
    if (ny()) {
      sprintf(stemp1,"%sADDRESS",syscfgovr.tempdir);
      add_arc(stemp1,stemp,1);
      download_temp_arc(stemp1,0);
      unlink(stemp);
    }
  }
  do {
    sprintf(stemp,"%sADDRESS.DAT",syscfg.datadir);
    if (!exist(stemp))
      CreateBook();
    topsave=topdata;
    topdata=0;
    topscreen();
    outchr(12);
    sprintf(stemp,"-= %s's Personal Address Book =-",thisuser.name);
    properize(stemp);
    cline(stemp,1,1);
    printmenu(22);
    npr("5    Your Selection?2: 0");
    ch=onek("QE?VSDAT");
    checkhangup();
    switch(ch) {
      case 'Q':
        outchr(12);
        Done=1;
        break;
      case 'T':
        TransferAddresses();
        break;
      case '?':
        outchr(12);
        sprintf(stemp,"-= Welcome to %s's Personal Address Book Help =-",
                      syscfg.systemname);
        cline(stemp,1,1);
        printfile("ADDRESS.MSG");
        pausescr();
        break;
      case 'S':
        SearchAddresses();
        break;
      case 'V':
        ViewAddresses();
        break;
      case 'D':
        DeleteAddresses(0);
        break;
      case 'A':
        AddAddresses();
        break;
      case 'E':
        nl();
        npr("5Search through address book for addressee first? 0");
        if (ny())
          SendEmail();
        else
          send_email();
        pausescr();
        break;
    }
  } while ((!hangup) && (!Done));
    topdata=topsave;
    topscreen();
}

int OpenAddressBook(void)
{
  char stemp[81],stemp1[81];

  sprintf(stemp,"%sADDRESS.DAT",syscfg.datadir);
  if ((AddressFile=
       sh_open(stemp,O_BINARY|O_RDWR|O_CREAT,S_IWRITE|S_IREAD))<0) {
    nl();
    strcpy(stemp1,"6\007\007Error opening address file!0");
    pl(stemp1);
    if (so()) {
      npr(" 6Try deleting 2%s 6and starting fresh!0",stemp);
      nl();
    } else {
      ssm(1,0,stemp1);
      pl(" 2Notifying SysOp! Do not use the address book!0");
    }
    nl();
    pausescr();
    return(0);
  }
  NumberEntries=(unsigned int)
                ((filelength(AddressFile)/sizeof(addressrec))-1);
  return(1);
}

void ViewAddresses(void)
{
  char stemp[81],stemp1[81];
  unsigned int i;
  unsigned char abt,all=0;
  addressrec Address;
  userrec User;

  if (!OpenAddressBook())
    return;
  if (so()) {
    nl();
    npr("4SysOp Option:5 View all entires? 0");
    if (yn())
      all=1;
  }
  AddressHeader("VIEWING");
  for (i=1;(i<=NumberEntries) && (!abt) && (!hangup);i++) {
    sh_lseek(AddressFile,((long)i)*((long)sizeof(addressrec)),SEEK_SET);
    sh_read(AddressFile,(void *)&Address,sizeof(addressrec));
    if ((usernum==Address.usernumber) ||
        ((all) && (Address.usernumber!=-1))) {
      npr("5%-30.30s %s0",Address.addressee,Address.netaddress);  nl();
      npr("9Note1: 5%s0",Address.boardname);
      if (all) {
        nl();
        read_user(Address.usernumber,&User);
        npr(" 4Entered by:3 %s0",nam(&User,Address.usernumber));
        nl();
      }
    }
    if (Address.usernumber>0)
      nln(2);
    abt=toupper(inkey());
    if (abt=='P') {
      getkey();
      abt=0;
    }
  }
  sh_close(AddressFile);
  nl();
  pl("2Listing complete!0");
  nl();
  pausescr();
}


void SearchAddresses(void)
{
  char stemp[81],SearchSpec[76],handle[31],address[51],bbs[75];
  unsigned int i,i1;
  unsigned char abt=0,ch,all=0,ch1,chng,Done;
  addressrec Address;
  unsigned short sy,un;
  userrec User;

  nl();
  pl("5Enter a {partial} search string.  Searchs ALL address fields2:0");
  npr("6:0");
  mpl(62);
  input(SearchSpec,62);
  if (!SearchSpec[0])
    return;
  if (so()) {
    nl();
    npr("4SysOp Option:5 Search ALL records? 0");
    if (yn())
      all=1;
  }
  if (!OpenAddressBook())
    return;
  AddressHeader("SEARCHING");
  for (i=1;(i<=NumberEntries) && (!abt) && (!hangup);i++) {
    sh_lseek(AddressFile,((long)i)*((long)sizeof(addressrec)),SEEK_SET);
    sh_read(AddressFile,(void *)&Address,sizeof(addressrec));
    strcpy(handle,Address.addressee);
    strcpy(address,Address.netaddress);
    strcpy(bbs,Address.boardname);
    if ((usernum==Address.usernumber) ||
        ((all) && (Address.usernumber!=-1))) {
      if ((strstr(strupr(address),SearchSpec)) ||
         (strstr(strupr(bbs),SearchSpec)) ||
         (strstr(strupr(handle),SearchSpec))) {
        npr("5%-30.30s %s0",Address.addressee,Address.netaddress);  nl();
        npr("9Note1: 5%s0",Address.boardname);
        if (all) {
          nl();
          read_user(Address.usernumber,&User);
          npr(" 4Entered by:3 %s0",nam(&User,Address.usernumber));
          nl();
        }
        if (Address.usernumber>0)
          nln(2);
        npr("5Match Found2: 4C3ontinue, 4D3elete, 0");
        npr("4E3mail, 4M3odify, 4Q3uit?0 ");
        ch=onek("QC\rDEM");
        backline(1);
        switch (ch) {
          case 'M':
            chng=0;
            do {
              Done=0;
              AddressHeader("SEARCH/MODIFYING");
              npr("5%-30.30s %s0",Address.addressee,Address.netaddress);
              nl();
              npr("9Note1: 5%s0",Address.boardname);
              nln(2);
              npr("5Edit2: 4H3andle, 4A3ddress, 0");
              npr("4B3BS name/note, 4Q3uit?0 ");
              ch1=onek("Q\rHAB");
              backline(1);
              switch (ch1) {
                case 13:
                case 'Q':
                  if (chng) {
                    AddressHeader("SEARCH/MODIFY/CONFIRMING");
                    npr("5%-30.30s %s0",Address.addressee,
                         Address.netaddress);
                    nl();
                    npr("9Note1: 5%s0",Address.boardname);
                    nln(2);
                    npr("5Is this correct? 0");
                    if (yn()) {
                      sh_lseek(AddressFile,
                           ((long)i)*((long)sizeof(addressrec)),SEEK_SET);
                      sh_write(AddressFile,
                           (void *)&Address,sizeof(addressrec));
                      AddressHeader("SEARCH/MODIFY/CONFIRMING");
                    }
                  }
                  Done=1;
                  AddressHeader("SEARCHING");
                  break;
                case 'H':
                  npr("5New handle2: 0");
                  mpl(30);
                  inputl(stemp,30);
                  if (stemp[0]) {
                    strcpy(Address.addressee,stemp);
                    chng=1;
                  }
                  backline(1);
                  break;
                case 'A':
                  do {
                    i1=0;
                    npr("5New address (6recommended format2: 0");
                    pl("1usernumber@systemnumber.networkname5)0");
                    npr("3(5IE: 21@11579.wwivnet3) 6: 0");
                    mpl(50);
                    inputl(stemp,50);
                    if (stemp[0]) {
                      strcpy(Address.netaddress,stemp);
                      i1=chng=1;
                    } else {
                      stemp[0]=0;
                      backline(2);
                      npr("6Enter a network or local address! 0");
                      pl("2Press any key.0");
                      getkey();
                      backline(1);
                    }
                  } while ((!hangup) && (!i1));
                  backline(2);
                  break;
                case 'B':
                  pl("5New BBS name/note2: 0");
                  npr("6:0");
                  mpl(74);
                  inputl(stemp,74);
                  if (stemp[0]) {
                    strcpy(Address.boardname,stemp);
                    chng=1;
                  }
                  backline(2);
                  break;
              }
            } while ((!Done) && (!hangup));
            break;
          case 'D':
            Address.usernumber=-1;
            sh_lseek(AddressFile,
                     ((long)i)*((long)sizeof(addressrec)),SEEK_SET);
            sh_write(AddressFile,(void *)&Address,sizeof(addressrec));
            if (all)
              backline(4);
            else
              backline(2);
            npr("%-79s","9Note1: 6DELETED!0");  nl();
            nln(2);
            break;
          case 'Q':
            abt=1;
            break;
          case 'C':
          case 13:
            break;
          case 'E':
            parse_email_info(Address.netaddress,&un,&sy);
            if (!un && !sy) {
              nl();
              pl("6ERROR! 2Invalid address!0");
              nl();
              pausescr();
            } else
              email(un,sy,0,0);
            break;
        }
      }
    }
  }
  sh_close(AddressFile);
  nl();
  pl("6Search Complete!0");
  nl();
  pausescr();
}

void DeleteAddresses(int UserNumber)
{
  addressrec Address;
  unsigned int i;
  int UserNum;
  char stemp[81];
  userrec User;

  if (!UserNumber) {
    nl();
    if (so()) {
      nl();
      pl("3Remove entries for what user number (1ENTER for YOURS3)?0");
      npr("3Type in 4ALL3 to remove entire address book data file2: 0");
      mpl(4);
      input(stemp,4);
      if (strcmp(stemp,"ALL")==0) {
        sprintf(stemp,"%sADDRESS.DAT",syscfg.datadir);
        unlink(stemp);
        nl();
        npr("6%s has been removed -- now reinitializing...0",stemp);
        nln(2);
        pausescr();
        return;
      }
      nl();
      if (!stemp[0]) {
        npr("6Are you certain you want to remove your entries? 0");
        if (yn())
          UserNum=usernum;
        else
          return;
      } else {
        read_user(atoi(stemp),&User);
        npr("6Are you certain you want to remove %s's entries? 0",
             nam(&User,atoi(stemp)));
        if (yn())
          UserNum=atoi(stemp);
        else
          return;
      }
    } else {
      npr("6Are you CERTAIN you want to delete your address entries? 0");
      if (yn())
        UserNum=usernum;
      else
        return;
    }
  } else
    UserNum=UserNumber;
  if (!OpenAddressBook())
    return;
  for (i=1;(i<=NumberEntries) && (!hangup);i++) {
    sh_lseek(AddressFile,((long)i)*((long)sizeof(addressrec)),SEEK_SET);
    sh_read(AddressFile,(void *)&Address,sizeof(addressrec));
    if (UserNum==Address.usernumber)
      Address.usernumber=-1;
    sh_lseek(AddressFile,((long)i)*((long)sizeof(addressrec)),SEEK_SET);
    sh_write(AddressFile,(void *)&Address,sizeof(addressrec));
  }
  sh_close(AddressFile);
  if (!UserNumber) {
    nl();
    npr("6All addresses for 2%u6 have been removed!0",atoi(stemp));
    nln(2);
    pausescr();
  }
}

void AddAddresses(void)
{
  char address[51],board[75],name[31],stemp[81];
  unsigned char Done,add=1;

  address[0]=board[0]=name[0]=0;
  outchr(12);
  cline("Entering new data.  Pressing ENTER on a blank field exits.",1,1);
  nl();
  pl("5Enter the user's name or handle.0");
  npr("6:0");
  mpl(24);
  inputl(name,24);
  if (!name[0])
    return;
  do {
    Done=0;
    nl();
    pl("5Enter the user's network address (1IE: 1@11579.wwivnet5).0");
    npr("6:0");
    mpl(50);
    inputl(address,50);
    if (!address[0])
      return;
    else {
      if ((strchr(address,'.')==NULL) || (strchr(address,'@')==NULL)) {
        address[0]=0;
        nl();
        pl("6ERROR! 2Invalid network address, try again!0");
        nl();
        pausescr();
      } else
        Done=1;
    }
  } while ((!hangup) && (!Done));
  nl();
  pl("5Enter user's BBS name (or some other note).0");
  npr("6:0");
  mpl(74);
  inputl(board,74);
  if (CheckForDupe(name,address)) {
    nl();
    npr("2Possible address/handle matches, 0");
    npr("2go ahead and add to book? 0");
    if (yn())
      add=1;
    else
      add=0;
  }
  if (add) {
    AddressHeader("ADD ADDRESS/CONFIRMING");
    npr("5%-30.30s %s0",name,address);  nl();
    npr("9Note1: 5%s0",board);
    nln(2);
    npr("5Is this correct? 0");
    if (yn())
      WriteAddress(name,address,board);
  }
}

void WriteAddress(char *Name,char *NetAddress, char *Board)
{
  addressrec Address;
  unsigned int i,Pos=0;
  char stemp[31];

  if (!OpenAddressBook())
    return;
  for (i=1;(i<=NumberEntries) && (!hangup) && (!Pos);i++) {
    sh_lseek(AddressFile,((long)i)*((long)sizeof(addressrec)),SEEK_SET);
    sh_read(AddressFile,(void *)&Address,sizeof(addressrec));
    if ((Address.usernumber==-1) || (Address.usernumber>status.users))
      Pos=i;
  }
  memset(&Address,0,sizeof(addressrec));
  Address.usernumber=usernum;
  strcpy(Address.addressee,Name);
  strcpy(Address.netaddress,NetAddress);
  strcpy(Address.boardname,Board);
  if (Pos)
    sh_lseek(AddressFile,((long)Pos)*((long)sizeof(addressrec)),SEEK_SET);
  else
    sh_lseek(AddressFile,0L,SEEK_END);
  sh_write(AddressFile,(void *)&Address,sizeof(addressrec));
  sh_close(AddressFile);
  nl();
  pl("5Address added to file!0");
  nl();
  pausescr();
}

void CreateBook(void)
{
  addressrec Address;

  memset(&Address,0,sizeof(addressrec));
  if (!OpenAddressBook())
    return;
  Address.usernumber=1;
  strcpy(Address.addressee,"-=*>Pp ሃr<*=-");
  strcpy(Address.netaddress,"1@11579.wwivnet");
  strcpy(Address.boardname,"StarPort Valhalla");
  sh_lseek(AddressFile,0L,SEEK_SET);
  sh_write(AddressFile,(void *)&Address,sizeof(addressrec));
  sh_close(AddressFile);
}

void cline(char *String, int Color, int Center)
{
// Color  0 = black         1 = blue          2 = green       3 = cyan
//        4 = red           5 = magenta       6 = brown       7 = grey
//        8 = lt. blue      9 = lt. green    10 = lt. cyan   11 = lt.red
//       12 = lt. magenta  13 = yellow       14 = white

  char color[15][62]=
       {"[0;30;47m","[0;34;47m","[0;32;47m","[0;36;47m","[0;31;47m",
        "[0;35;47m","[0;33;47m","[1;30;47m","[1;34;47m","[1;32;47m",
        "[1;36;47m","[1;31;47m","[1;35;47m","[1;33;47m","[1;37;47m"};
  char stemp[81],stemp1[81];
  int len,i=0;

  if (Center) {
    strcpy(stemp,"");
    i=40-((strlen(stripcolors(String)))/2);
    for (len=0;len<i;len++)
      strcat(stemp," ");
    sprintf(stemp1,"%s%s",stemp,String);
  } else
    strcpy(stemp1,String);
  for (len=0;len<((79-strlen(String))-i);len++)
    strcat(stemp1," ");
  if (okansi()) {
    npr("[0;1m%s[0m\r\n",charstr(79,''));
    npr("%s%s\r\n",color[Color],stemp1);
    npr("[0;1;30m%s[0m\r\n",charstr(79,''));
  } else {
    pl(stemp1);
    pl(charstr(80,205));
  }
}

void AddressHeader(char *Area)
{
  char stemp[81];

  outchr(12);
  sprintf(stemp,
          "Users Handle or Name           Network Address    [%s]",Area);
  cline(stemp,1,0);
}

void backline(unsigned char NumLines)
{
  int i,j;

  for (j=0;j<NumLines;j++) {
    for (i=0;i<80;i++)
       backspace();
  }
}

unsigned char CheckForDupe(char *Handle, char *NetAddress)
{
  addressrec Address;
  unsigned int i;
  unsigned char abt=0;

  if (!OpenAddressBook())
    return(0);
  AddressHeader("CHECKING FOR DUPES");
  pl("6Searching for possible duplicate address book entries:0");
  for (i=1;(i<=NumberEntries) && (!hangup);i++) {
    sh_lseek(AddressFile,((long)i)*((long)sizeof(addressrec)),SEEK_SET);
    sh_read(AddressFile,(void *)&Address,sizeof(addressrec));
    if (Address.usernumber==usernum) {
      if ((stricmp(Address.addressee,Handle)==0) ||
          (stricmp(Address.netaddress,NetAddress)==0)) {
        abt=1;
        npr("5%-30.30s %s0",Address.addressee,Address.netaddress);  nl();
        npr("9Note1: 5%s0",Address.boardname);
        nln(2);
      }
    }
  }
  sh_close(AddressFile);
  nl();
  if (abt)
    return(1);
  else
    return(0);
}

void TransferAddresses(void)
{
  addressrec Address;
  unsigned int i;
  FILE *OutFile;
  char stemp[81],stemp1[81];

  if (!OpenAddressBook())
    return;
  sprintf(stemp,"%s%u.ADD",syscfgovr.tempdir,usernum);
  if ((OutFile=fopen(stemp,"wt"))==NULL) {
    sh_close(AddressFile);
    return;
  }
  fprintf(OutFile,"%s's Address Book from %s\n\n",thisuser.name,
          syscfg.systemname);
  for (i=1;(i<=NumberEntries) && (!hangup);i++) {
    sh_lseek(AddressFile,((long)i)*((long)sizeof(addressrec)),SEEK_SET);
    sh_read(AddressFile,(void *)&Address,sizeof(addressrec));
    if (Address.usernumber==usernum) {
      fprintf(OutFile,"Name: %s\n",Address.addressee);
      fprintf(OutFile,"Addr: %s\n",Address.netaddress);
      fprintf(OutFile,"Note: %s\n\n",Address.boardname);
    }
  }
  fclose(OutFile);
  sh_close(AddressFile);
  sprintf(stemp1,"%sADDRESS",syscfgovr.tempdir);
  add_arc(stemp1,stemp,1);
  download_temp_arc(stemp1,0);
}

void SendEmail(void)
{
  addressrec Address;
  unsigned char i,abt=0;
  char Name[31],stemp[81],stemp1[81],stemp2[81];
  unsigned short sy,un;

  irt_name[0]=irt[0]=0;
  if (!OpenAddressBook())
    return;
  nl();
  npr("5{Partial} name, BBS name, or address to mail? 0");
  mpl(30);
  input(Name,30);
  if (!Name[0])
    return;
  AddressHeader("E-MAILING");
  pl("6Searching for matching address(es).0");
  for (i=1;(i<=NumberEntries) && (!abt) && (!hangup);i++) {
    sh_lseek(AddressFile,((long)i)*((long)sizeof(addressrec)),SEEK_SET);
    sh_read(AddressFile,(void *)&Address,sizeof(addressrec));
    strcpy(stemp,Address.addressee);
    strcpy(stemp1,Address.boardname);
    strcpy(stemp2,Address.netaddress);
    if (Address.usernumber==usernum) {
      if ((strstr(strupr(stemp),Name)) ||
          (strstr(strupr(stemp1),Name)) ||
          (strstr(strupr(stemp2),Name))) {
        npr("5%-30.30s %s0",Address.addressee,Address.netaddress);  nl();
        npr("9Note1: 5%s0",Address.boardname);
        nln(2);
        npr("5Do you want to E-Mail this account?0 ");
        if (ny()) {
          backline(1);
          abt=1;
        } else
          backline(1);
      }
    }
  }
  sh_close(AddressFile);
  if (abt) {
    parse_email_info(Address.netaddress,&un,&sy);
    if (!un && !sy) {
      nl();
      pl("6ERROR! 2Invalid address!0");
      nl();
      pausescr();
    } else
      email(un,sy,0,0);
  } else {
    nl();
    pl("5No match found -- using stock E-Mail.0");
    send_email();
  }
}
---
1No, I don't have any taglines to give you.  Go Away.
