Ŀ
 ModTitle: Super Config -> Asylum Q/Nscan config 1.5a       August 14, 1994  
 What Is?: Common 1.1+ Mod. Menu driven QScan/NScan config                   
                                                                             
 Difficulty: Easy, 5 or so places changed in source, and then block read the 
             rest                                                            
 Files affected: DEFAULTS.C XFEROVL.C BBS.C                                  
                                                                             
 BY: Asylum Group                                                            
 Credits: No one                                                             


If you are upgrading, all you need to do is step 4 (re-block read) and that is
it!

1.5 Notes:
  A few bug fixes, one of the mods that actually didn't need any to speek of
  Made is so there are two columns instead of one.
  You can now read new or list files in there (hey, I was bored)


Other Mods by the Asylum Group: (All require COMMON mod to install)

  WWIV User Pulldown Menus
    Featuring script menus, once they are in, you don't need to mod the BBS to
    change your menus around, includes ability to use ALL colors except for
    the blinking ones in your menus, definable security for each menu item, and
    instructions on how to expand the resource language.
       
  List Files Plus
    In the people who have installed this mod words, simply the best
    file list/search/tag/view/etc... mod for wwiv.  Allows you to go back and
    forth in the files, selecting the files with the up and down arrow, and at
    the bottom you have a menu you use the left and right arrow keys.  The
    menus commands consist of such commands as show next files, show previous
    files, put file in batch queue (or can be done with a space bar), view
    file, download file, enter batch menu, go back and forward a directory.
    And now, it shows the files description, in true vision/2 style, when you
    list the files.  Now also does sysop commands and has configurable file
    listing...

  Asylum QWK
    Only the Asylum Group can bring you such a quality mod.  Most QWK features
    are available, upload REP, download QWK, set max msgs per QWK and per sub
    plus more.



The Modification:
  
  Please take steps to insure your BBS can be recovered in case of a problem.
  I take no responsibility in you doing this, if you can't put in this mod
  without losing your userrec or whatever else may happen, then don't install
  it.
  
  Now... this modification seems to work real well, special care is taken to
  avoid memory allocation/overrun/leaks problems (probley 99% of real problems)
  but I am not prefect.


+ Add
- Subtract
* Change
= Existing
@# See number


Step 1a)
  This is a Common mod, which means you need to have COMMON installed.

Step 1b)
  Put the supplied files so you can work with them, move SCONFIG.HLP to your 
  GFILES directory so the users can get help.
  

Step 2) XFEROVL.C
  Add the following so that the config scan plus will be activated

= void config_nscan(void)
= {
=   char *s,s1[MAX_CONFERENCES+2],s2[120],ch;
=   int i,i1,done,done1,oc,os,abort=0;
= 
+   if(okansi())
+   {
+     config_scan_plus(NSCAN);
+     return;
+   }
  

Step 3) DEFAULTS.C
  Add the following so that the config scan plus will be activated.
  
= void config_qscan(void)
= {
=   char *s, s1[MAX_CONFERENCES+2], s2[120], ch;
=   int i,done,done1,oc,os,abort=0;

+   if(okansi())
+   {
+     config_scan_plus(QSCAN);
+     return;
+   }
  

Step 4) DEFAULTS.C
  Block read in the following at the end of DEFAULTS.C
  
/* ************************************************************************** */
#include <conio.h>

// This defines how far from the bottom your list will stop
#define STOP_LIST 0

// This is for, plain and simply, total lamers, people who do not know how to
// set there system up right, users that say they have 25 screenlines, when in
// fact, qmodem is taking up 2 of them, leaving them with only 23 (or 24)
// This define overrides the STOP_LIST define if nessisary.
// Undefine this to let the program show as many items as it can as defined by
// the thisuser.screenlines variable, thus 50 line users will show about 46 or
// so files, while 24, 25 etcc... will also show just the right amount to fill
// up the screen
// Leave it defined and it will never show more than the defined amount.
// Undefine it to not have a max
#define MAX_SCREEN_LINES_TO_SHOW 24


// Side menu colors
#define NORMAL_HIGHLIGHT   (YELLOW+(BLACK<<4))
#define NORMAL_MENU_ITEM   (CYAN+(BLACK<<4))
#define CURRENT_HIGHLIGHT  (RED+(LIGHTGRAY<<4))
#define CURRENT_MENU_ITEM  (BLACK+(LIGHTGRAY<<4))




void list_config_scan_plus(int first, int *amount, int type)
{
  int this_sub, this_dir, alias_dir;
  int useconf, max_lines;
  char s[101];
  
  useconf=((subconfnum>1) && okconf(&thisuser));

  CLS();
  lines_listed=0;

  if(useconf)
  {
    strncpy(s, type == 0 ? stripcolors(subconfs[uconfsub[curconfsub].confnum].name) : stripcolors(dirconfs[uconfdir[curconfdir].confnum].name), 27);
    s[27]=0;
    npr("1Configure 7%cSCAN 9-- 2%-27s 9-- 3Press <5SPACE3> to toggle a sub\n\r", type==0 ? 'Q' : 'N', s);
  }
  else
    npr("1Configure 7%cSCAN                                   3Press <5SPACE3> to toggle a sub\n\r", type==0 ? 'Q' : 'N');


  // outstr("5\n\r");
  // Replace the above with the below
  ansic(5);
  repeat_char('', 79);
  nl();
  
#ifdef MAX_SCREEN_LINES_TO_SHOW
  max_lines = (
								thisuser.screenlines-(4+STOP_LIST) >
								MAX_SCREEN_LINES_TO_SHOW-(4+STOP_LIST)
                ?
                MAX_SCREEN_LINES_TO_SHOW-(4+STOP_LIST)
                :
                thisuser.screenlines-(4+STOP_LIST)
              );
#else
  max_lines = thisuser.screenlines-(4+STOP_LIST);
#endif

  
  if(type==0)
  {
    for (this_sub=first; (this_sub<num_subs) && (usub[this_sub].subnum!=-1) &&
          *amount < max_lines * 2; this_sub++)
    {
      lines_listed=0;

      sprintf(s,"7[1%c7] 2%s",
          (qsc_q[usub[this_sub].subnum/32]&(1L<<(usub[this_sub].subnum%32)))?'':' ',
          subboards[usub[this_sub].subnum].name);

      s[44]=0; /* this is greater than 40 cuz we have 8 heart bytes to accout for */

      if(*amount >= max_lines)
      {
        GOTO_XY(40, 3 + *amount - max_lines);
        outstr(s);
      }
      else
        pl(s);

      ++*amount;
    }
  }
  else
  {
    for (this_dir=first; (this_dir<num_dirs) && (udir[this_dir].subnum!=-1) &&
          *amount < max_lines * 2; this_dir++)
    {
      lines_listed=0;
      alias_dir=udir[this_dir].subnum;
      sprintf(s,"7[1%c7] 2%s",
                qsc_n[alias_dir/32]&(1L<<(alias_dir%32)) ? '' : ' ',
                directories[alias_dir].name);

       s[44]=0; /* this is greater than 40 cuz we have 8 heart bytes to accout for */


      if(*amount >= max_lines)
      {
        GOTO_XY(40, 3 + *amount - max_lines);
        outstr(s);
      }
      else
        pl(s);

      ++*amount;
    }
  }
  nl();
  lines_listed=0;
}

void config_scan_plus(int type)
{
  char **menu_items;
  int done, redraw=0;
  int pos=0, side_pos=0;
  int top=0, command;
  int amount=0;
  int useconf;


  struct side_menu_colors smc={NORMAL_HIGHLIGHT,
                              NORMAL_MENU_ITEM,
                              CURRENT_HIGHLIGHT,
                              CURRENT_MENU_ITEM};

  useconf=((subconfnum>1) && okconf(&thisuser));
    
  helpl=32000;
  
  // Turn off topscreen info for this mod
  topdata=0;
  topscreen();
  
  menu_items=(char **)alloc_2d(10, 10, sizeof(char));

  strcpy(menu_items[0], "Next");
  strcpy(menu_items[1], "Prev");
  strcpy(menu_items[2], "Toggle");
  strcpy(menu_items[3], "Clear ALL");
  strcpy(menu_items[4], "Set ALL");

  if(type==0)
    strcpy(menu_items[5], "Read New");
  else
    strcpy(menu_items[5], "List");

  if(useconf)
  {
    strcpy(menu_items[6], "{ Conf");
    strcpy(menu_items[7], "} Conf");
    strcpy(menu_items[8], "Quit");
    strcpy(menu_items[9], "?");
    menu_items[9][0]=0;      // Changed this line from null
  }
  else
  {
    strcpy(menu_items[6], "Quit");
    strcpy(menu_items[7], "?");
    menu_items[7][0]=0;      // Changed this line from null
  }




  
  done=0;
  
  while(!done && !hangup)
  { 
    int menu_done=0;
    
    amount=0;
    list_config_scan_plus(top, &amount, type);
    
    if(!amount)
    {  
      top=0;          
      list_config_scan_plus(top, &amount, type);
      if(!amount)
        done=1;
    }
    
    if(!done)  
      drawscan(pos, type ? is_inscan(top+pos) :
              qsc_q[usub[top+pos].subnum/32]&(1L<<(usub[top+pos].subnum%32)));
              
    
              
    redraw=1;
    
    while(!menu_done && !hangup && !done)
    {
      command = side_menu(&side_pos, redraw, menu_items, 1,
#ifdef MAX_SCREEN_LINES_TO_SHOW
      thisuser.screenlines-STOP_LIST > MAX_SCREEN_LINES_TO_SHOW-STOP_LIST ? MAX_SCREEN_LINES_TO_SHOW-STOP_LIST : thisuser.screenlines-STOP_LIST, &smc);
#else
      thisuser.screenlines-STOP_LIST, &smc);
#endif             

      lines_listed=0;


      redraw=1;
      ansic(0);
    
      if(do_sysop_command(command))
      {
        menu_done=1;
        amount=0;
      }
      
      switch(command)
      {
        case '?':
        case CO:
          CLS();
          printfile("SCONFIG.HLP");
          pausescr();
          
          menu_done=1;
          amount=0;
          break;
      
        case COMMAND_DOWN:
          undrawscan(pos, type ? is_inscan(top+pos) :
             qsc_q[usub[top+pos].subnum/32]&(1L<<(usub[top+pos].subnum%32)));
          ++pos;
          if(pos>=amount)
            pos=0;
          drawscan(pos, type ? is_inscan(top+pos) :
              qsc_q[usub[top+pos].subnum/32]&(1L<<(usub[top+pos].subnum%32)));
          redraw=0;
          break;
        
        case COMMAND_UP:
          undrawscan(pos, type ? is_inscan(top+pos) :
              qsc_q[usub[top+pos].subnum/32]&(1L<<(usub[top+pos].subnum%32)));
          if(!pos)
            pos=amount-1;
          else
            --pos;
          drawscan(pos, type ? is_inscan(top+pos) :
              qsc_q[usub[top+pos].subnum/32]&(1L<<(usub[top+pos].subnum%32)));
          redraw=0;
          break;
        
        case SPACE: // Toggle
          if(type==0)
            qsc_q[usub[top+pos].subnum/32] ^= (1L<<(usub[top+pos].subnum%32));
          else
          {
            int this_dir, sysdir=0;
            int ad;
            
            // Keep the program from flipping out if there is a dir 0 present
            if(strcmp(udir[0].keys,"0")==0)
              sysdir=1;
            
            for (this_dir=0; (this_dir<num_dirs); this_dir++) 
            {
              char s[50];
              
              sprintf(s, "%d", sysdir ? top+pos : top+pos+1);
              if(!strcmp(s, udir[this_dir].keys))
              {
                ad=udir[this_dir].subnum;
                qsc_n[ad/32] ^= (1L<<(ad%32));
              }
            }
          }
          drawscan(pos, type ? is_inscan(top+pos) :
              qsc_q[usub[top+pos].subnum/32]&(1L<<(usub[top+pos].subnum%32)));
          redraw=0;
          break;
          
        case EXECUTE:
          if(!useconf && side_pos > 5)
            side_pos+=2;


          switch(side_pos)
          {
            case 0: // Next
              top+=amount;
              
              if(type==0)
              {
                if(top>=num_subs)
                  top=0;
              }
              else
              {
                if(top>=num_dirs)
                  top=0;
              }
              
              pos=0;
              menu_done=1;
              amount=0;
              break;  
            
            case 1: // Prev
              
              if(top > thisuser.screenlines-4)
                top-=thisuser.screenlines-4;
              else
                top=0;
                  
              pos=0;
              menu_done=1;
              amount=0;
              break;
              
            case 2: // Toggle Sub
              if(type==0)
                qsc_q[usub[top+pos].subnum/32] ^= (1L<<(usub[top+pos].subnum%32));
              else
              {
                int this_dir, sysdir=0;
                int ad;
                
                // Keep the program from flipping out if there is a dir 0 present
                if(strcmp(udir[0].keys,"0")==0)
                  sysdir=1;
                
                for (this_dir=0; (this_dir<num_dirs); this_dir++) 
                {
                  char s[50];
                  
                  sprintf(s, "%d", sysdir ? top+pos : top+pos+1);
                  if(!strcmp(s, udir[this_dir].keys))
                  {
                    ad=udir[this_dir].subnum;
                    qsc_n[ad/32] ^= (1L<<(ad%32));
                  }
                }
              }
              drawscan(pos, type ? is_inscan(top+pos) :
                   qsc_q[usub[top+pos].subnum/32]&(1L<<(usub[top+pos].subnum%32)));
              redraw=0;
              break;
              
            case 3: // Clear all
              if(type==0)
              {
                int this_sub;
                for(this_sub=0; this_sub<num_subs; this_sub++) 
                {
                  if(qsc_q[usub[this_sub].subnum/32]&(1L<<(usub[this_sub].subnum%32)))
                    qsc_q[usub[this_sub].subnum/32]^=(1L<<(usub[this_sub].subnum%32));
                }
              }
              else
              {
                int this_dir;
                for(this_dir=0; this_dir<num_dirs; this_dir++) 
                {
                  if(qsc_n[udir[this_dir].subnum/32]&(1L<<(udir[this_dir].subnum%32)))
                    qsc_n[udir[this_dir].subnum/32] ^= 1L<<(udir[this_dir].subnum%32);
                }
              }
              pos=0;
              menu_done=1;
              amount=0;
              break;
              
            case 4: // Set all on
              if(type==0)
              {
                int this_sub;
                for(this_sub=0; this_sub<num_subs; this_sub++) 
                {
                  if(!(qsc_q[usub[this_sub].subnum/32]&(1L<<(usub[this_sub].subnum%32))))
                    qsc_q[usub[this_sub].subnum/32]^=(1L<<(usub[this_sub].subnum%32));
                }
              }
              else
              {
                int this_dir;
                for(this_dir=0; this_dir<num_dirs; this_dir++) 
                {
                  if(!(qsc_n[udir[this_dir].subnum/32]&(1L<<(udir[this_dir].subnum%32))))
                    qsc_n[udir[this_dir].subnum/32] ^= 1L<<(udir[this_dir].subnum%32);
                }
              }
              pos=0;
              menu_done=1;
              amount=0;
              break;
              
            case 5:  // Read dir, or list files
              if(type==0)
              {
                int i=0;
                express=0;
                expressabort=0;
                qscan(top+pos, &i);
              }
              else
              {
                int i=curdir;
                curdir=top+pos;
                tagging=1;
                listfiles();
                tagging=0;
                curdir=i;
              }
              menu_done=1;
              amount=0;

              break;

            case 6: // { conf
              if (okconf(&thisuser)) 
              {
                if(type==0)
                {
                  if(curconfsub>0)
                    --curconfsub;
                  else
                  { 
                    while ((uconfsub[curconfsub+1].confnum>=0) && (curconfsub<subconfnum-1))
                      ++curconfsub;
                  }
                  setuconf(CONF_SUBS, curconfsub, -1);
                }
                else
                {
                  if(curconfdir>0)
                    --curconfdir;
                  else 
                  {
                    while ((uconfdir[curconfdir+1].confnum>=0) && (curconfdir<dirconfnum-1))
                      ++curconfdir;
                  }
                  setuconf(CONF_DIRS, curconfdir, -1);
                }
                
                pos=0;
                menu_done=1;
                amount=0;
              }

              
              break;
              
            case 7: // } conf
              if (okconf(&thisuser)) 
              {
                if(type==0)
                {
                  if ((curconfsub<subconfnum-1) && (uconfsub[curconfsub+1].confnum>=0))
                    ++curconfsub;
                  else
                    curconfsub=0;
                  setuconf(CONF_SUBS, curconfsub, -1);
                }
                else
                {
                  if ((curconfdir<dirconfnum-1) && (uconfdir[curconfdir+1].confnum>=0))
                    ++curconfdir;
                  else
                    curconfdir=0;
                  setuconf(CONF_DIRS, curconfdir, -1);
                }
                pos=0;
                menu_done=1;
                amount=0;
              }

              break;
              
              
            case 8: // Quit
              menu_done=1;
              done=1;
              break;
              
            case 9: // ? Help
              CLS();
              printfile("SCONFIG.HLP");
              pausescr();
              
              menu_done=1;
              amount=0;

              if(!useconf)
                side_pos-=2;
              break;
          }
          
          break;
        
        case GET_OUT:
          menu_done=1;
          done=1;
          break;
        
      }
    }
  }
  
  lines_listed=0;
  nl();
  
  free_2d(menu_items);
}



void drawscan(int filepos, long tagged)
{
  int max_lines;

#ifdef MAX_SCREEN_LINES_TO_SHOW
  max_lines = (
                thisuser.screenlines-(4+STOP_LIST)
                >
                MAX_SCREEN_LINES_TO_SHOW-(4+STOP_LIST)
                ?
                MAX_SCREEN_LINES_TO_SHOW-(4+STOP_LIST)
                :
                thisuser.screenlines-(4+STOP_LIST)
              );
#else
  max_lines = thisuser.screenlines-(4+STOP_LIST);
#endif

  if(filepos >= max_lines)
    goxy(40, 3 + filepos - max_lines);
  else
    goxy(1, filepos+3);

  setc(BLACK+(CYAN<<4));
  npr("[%c]", tagged ? '' : ' ');
  setc(YELLOW+(BLACK<<4));
  
  if(filepos >= max_lines)
    goxy(41, 3 + filepos - max_lines);
  else
    goxy(2, filepos+3);


  
}

void undrawscan(int filepos, long tagged)
{
  int max_lines;

#ifdef MAX_SCREEN_LINES_TO_SHOW
  max_lines =
              (
                thisuser.screenlines-(4+STOP_LIST)
                >
                MAX_SCREEN_LINES_TO_SHOW-(4+STOP_LIST)
                ?
                MAX_SCREEN_LINES_TO_SHOW-(4+STOP_LIST)
                :
                thisuser.screenlines-(4+STOP_LIST)
              );
#else
  max_lines = thisuser.screenlines-(4+STOP_LIST);
#endif


  if(filepos >= max_lines)
    goxy(40, 3 + filepos - max_lines);
  else
    goxy(1, filepos+3);


  npr("7[1%c7]", tagged ? '' : ' ');
}

long is_inscan(int dir)
{
  int this_dir, ad;
  int sysdir=0;
  
  // Keep the program from flipping out if there is a dir 0 present
  if(strcmp(udir[0].keys,"0")==0)
    sysdir=1;
  
  for (this_dir=0; (this_dir<num_dirs); this_dir++) 
  {
    char s[50];
    
    sprintf(s, "%d", sysdir ? dir : dir+1);
    if(!strcmp(s, udir[this_dir].keys))
    {
      ad=udir[this_dir].subnum;
      return(qsc_n[ad/32]&(1L<<ad%32));
    }
  }
  
  return(0);
}



Step 5) FCNS.H
  Either type MAKE FCNS to rebuild or manually add the following function
  definitions to fcns.h at the end of the section for /* file: defaults.c */.

void list_config_scan_plus(int first, int *amount, int type);
void config_scan_plus(int type);
void drawscan(int filepos, long tagged);
void undrawscan(int filepos, long tagged);
long is_inscan(int dir);
  
  
6) Recompile
  Please report all bugs you may find.
  
  
7) Help advertise a half way decent mod, tell everyone on modnet to get Insane.



     
     

' Void this
' Real idiots think that real programmers only use one tool


Look for more good mods from the Asylum group...



