Snorkel #1 @2100
Wed Jun 28 14:50:50 1995
Ŀ
 Mod Name      : M&M007D.MOD       Mod Author: Snorkel     1@2100 WWIVnet   
 Difficulty    : ۰        The M&M Factory [GSA]   1@3459 WWIVlink  
 WWIV Version  : 4.24                                                       
 Mod Date      : 6-28-95                                                    
 Files Affected: BATCH.C, DIREDIT.C, XFER.C, XFEROVL.C, XFEROVL2.C,         
                 VARDEC.H, BBS.STR                                          
                                                                            
 Description   : Make specific files AND/OR directories "FREE".             
                 (Based on the "FREEFILE.MOD" by Simple Simon)              

ͻ
   This WWIV Source Code  modification  is  copyright  1995  by  Snorkel,   
   System Operator of The M&M Factory BBS and is distributed as freeware.   
   Permission is granted to distribute and post this modified code on BBS   
   systems and online services, provided no alterations are made (removal   
   of  message headers/taglines allowed).  This modified code may contain   
   some parts of WWIV source code,  which is copyright 1988-1995 by Wayne   
   Bell  and  licensed  only  to  registered  users of WWIV.  Use of WWIV   
   source without registration constitutes a license violation and  could   
   lead to legal prosecution.                                               
                                                                            
   Shareware  distributors  and CD-ROM publishers may not distribute this   
   modified code without express written permission of the Author or WWIV   
   Software Services.                                                       
ͼ

I wish to thank Simple Simon for originally writing this mod way back when
WWIV 4.20 was released.  I have constantly upgraded this mod because I have
found it so useful.

I have now gone beyond the original purpose of this mod and have actually
added new code which not only allows you to specify certain files as "FREE",
but you can now specify entire directories as "FREE".

This mod bypasses the ratio check, but still makes sure that the user has
enough time to d/l the file.  The mod of course doesn't add anything to the
user's D/L K or number of files downloaded.  So, even if you do not use ratios
on your system, this mod will prevent your users from ever being "credited"
with the download of a FREE file.

FREE Files
==========
Files are marked as FREE by using the //REN command.  When you see a file you
want to mark as FREE, do a //REN, enter the name or wildcards, and then press
"F".  You are then asked if you wish to make the file FREE. If you say yes,
and the file is already FREE, nothing changes.  If you say no and the file is
not already FREE, nothing changes.  The only time the file status changes is
when you actually change it from costing the user download credit to FREE, or
vice versa.  If you make a file FREE, the directory list displays "FREE"
instead of the file size when you list the files as well as when you download
it.

FREE Directories
================
To specify an entire directory as "FREE", you must enter //DIREDIT and make it
"FREE".  If, at a later time, you wish to change the directory back to
charging for the files, that can be done by simply re-entering //DIREDIT and
turning off the "FREE" feature.

* Note - Toggling a directory between FREE and normal does not affect any
         files within that directory which have been designated as FREE.  Any
         files already designated as FREE will remain so, regardless of the
         status of the directory itself.

As with any mod, I suggest you back up your source code before you attempt to
add this code.


Revision A
""""""""""
This revision streamlined some code, added additional code to properly support
batch downloading and corrected code which did not work properly.  Text string
usage reduced to lower code size and D-group.

Revision B
""""""""""
One line of existing code in XFEROVL.C was moved outside a "close brace".  
This is not a bug fix, but a correction in the way the //REN function works.

Revision C
""""""""""
Re-written for WWIV v4.24.

Revision D
""""""""""
Corrected a bug which was preventing the BBS from exiting the rename function
if you pressed "F" and then answered "NO" to the question about making the
file free.

==============================================================================
Ŀ
 VARDEC.H 


Step 1
------

Add the following line:


/* directoryrec.mask */                           /* search for */
#define mask_PD            0x0001
#define mask_no_uploads    0x0004
#define mask_archive       0x0008
#define mask_pending_batch 0x0010
#define mask_no_ratio      0x0020
#define mask_cdrom         0x0040
#define mask_offline       0x0080
#define mask_free_dir      0x0200                    /* ADD */
#define mask_free_file     0x2000                    /* ADD */
#define mask_guest         0x4000
#define mask_extended      0x8000


Save VARDEC.H
==============================================================================
Ŀ
 XFEROVL.C 


Step 2a
-------

Find "void relist(void)" and add the following lines:


void relist(void)                                      /* search for */
{
  char s[85],s1[40],s2[81];
  int i,i1,next,abort=0,fc;
  int tcd=-1;
  directoryrec r;                                         /* ADD */

  if (!filelist)
    return;



Step 2b
-------

A little further down in the same function, add the following lines:



        tcd=filelist[i].directory;                       /* search for */
        r=directories[udir[tcd].subnum];                           /* ADD */
        if (fc)
          ansic(2);
        npr("%s - #%s.\r\n",directories[tcd].name,udir[tcd].keys);/* DELETE */
        npr("%s - #%s.",directories[tcd].name,udir[tcd].keys);     /* ADD */
        if (r.mask & mask_free_dir)                                /* ADD */
          pl("  4FREE File Directory0");                         /* ADD */
        else                                                       /* ADD */
          nl();                                                    /* ADD */
        ansic(fc ? FRAME : 0);
        if (okansi())



Step 2b
-------

A little further down in the same function, add the following lines:


    strncpy(s,&((filelist[i].u.filename)[8]),4);       /* search for */
    s[4]=0;
    if (fc)
      ansic(1);
    osan(s,&abort,&next);
    ansic(fc ? FRAME : 0);
    osan((okansi() ? "" : ":"),&abort,&next);

    if ((filelist[i].u.mask & mask_free_file) ||             /* ADD */
        (r.mask & mask_free_dir))                            /* ADD */
      strcpy(s1,"FREE");                                     /* ADD */
    else {                                                   /* ADD */
      ltoa(bytes_to_k(filelist[i].u.numbytes),s1,10);
      strcat(s1,"k");
    }                                                        /* ADD */
    if (!(sysinfo.flags & OP_FLAGS_FAST_TAG_RELIST)) {
      if (!(directories[tcd].mask & mask_cdrom)) {
        strcpy(s2,directories[tcd].path);
        strcat(s2,filelist[i].u.filename);
        if (!exist(s2))
          strcpy(s1,get_string(741));
      }
    }
    for (i1=0; i1<5-(int)strlen(s1); i1++)
      s[i1]=32;
    s[i1]=0;
    strcat(s,s1);
    if ((filelist[i].u.mask & mask_free_file) ||     /* ADD */
          (r.mask & mask_free_dir))                  /* ADD */
      ansic(9);                                      /* ADD */
    else                                             /* ADD */
      if (fc)
        ansic(2);
    osan(s,&abort,&next);



Step 2c
-------

Find "void rename_file(void)" and change or add the following lines:


void rename_file(void)                  /* search for */
{
  char s[81],s1[81],s2[81],*ss,s3[81],ch;
  int i,cp,f;
  uploadsrec u;
  unsigned short om;                       /* ADD */

  nl();


Step 2d
-------

A little further down in the same function, add the following lines:


/* see >NOTE< about string 830 at the end of this mod */

    prt(5,get_string(830));                       /* search for */
    ch=ynq();                   /* DELETE THIS LINE */
    ch=onek("QNYF");                               /* ADD */
    if (ch=='Q')
      break;
    else
      if (ch=='N') {
        i=nrecno(s3,cp);
        continue;
      }
    if (ch=='F') {                                 /* ADD */
      om=u.mask;                                   /* ADD */
      u.mask &= ~mask_free_file;                   /* ADD */
      nl();                                        /* ADD */
      outstr("5Make the file FREE? <CR>=N ");     /* ADD */0
      if (yn())                                    /* ADD */
        u.mask|=mask_free_file;                    /* ADD */
      if (om!=u.mask) {                            /* ADD */
        f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);//ADD
        SETREC(f,i);                               /* ADD */
        sh_write(f,(void *)&u,sizeof(uploadsrec)); /* ADD */
        f=sh_close(f);                             /* ADD */
        i=nrecno(s3,cp);                           /* ADD */
        continue;                                  /* ADD */
      }                                            /* ADD */
    }                                              /* ADD */
    nl();
    prt(2,get_string(72));


Save XFEROVL.C
==============================================================================
Ŀ
 XFER.C 


Step 3a
-------

Find "void printtitle(int *abort)" and add the following lines:


void printtitle(int *abort)                     /* search for */
{
  char s[81], *ss;                      /* DELETE THIS LINE */
  char s[121], *ss;                                /* ADD */
  directoryrec r;                                  /* ADD */

  r=directories[udir[curdir].subnum];              /* ADD */
  if (x_only) {
    nl();
    ss="";


Step 3b
-------

A little further down in the same function, add the following lines:


    if (tagging==0)                             /* search for */
      return;
  }
  sprintf(s,"%s%s - #%s, %d %s.",ss,directories[udir[curdir].subnum].name,
                              udir[curdir].keys,numf, get_string(742));
  if (r.mask & mask_free_dir)                                   /* ADD */
    strcat(s,"  4FREE File Directory0");                      /* ADD */
  ansic(thisuser.sysstatus & sysstatus_extra_color ? FRAME : 0);



Step 3c
-------

Find "void printinfo(uploadsrec *u, int *abort)" and add the following lines:


void printinfo(uploadsrec *u, int *abort)               /* search for */
{
  char s[85],s1[40],s2[81];
  int i,next,fc;
  directoryrec r;                                       /* ADD */

  r=directories[udir[curdir].subnum];                   /* ADD */
  fc=thisuser.sysstatus & sysstatus_extra_color;
  if (titled!=0)
    printtitle(abort);



Step 3d
-------

A little further down in the same function, add the following lines:


  osan((okansi() ? "" : "|"),abort,&next);            /* search for */

  if ((u->mask & mask_free_file) || (r.mask & mask_free_dir))  /* ADD */
    strcpy(s1,"FREE");                                         /* ADD */
  else {                                                       /* ADD */
    ltoa(bytes_to_k(u->numbytes),s1,10);
    strcat(s1,"k");
  }                                                            /* ADD */

  if (!(directories[udir[curdir].subnum].mask & mask_cdrom)) {
    strcpy(s2,directories[udir[curdir].subnum].path);
    strcat(s2,u->filename);
    if (!exist(s2))
      strcpy(s1,get_string(741));
  }

  for (i=0; i<5-(int)strlen(s1); i++)
    s[i]=32;
  s[i]=0;
  strcat(s,s1);
  if ((u->mask & mask_free_file) ||                /* ADD */
        (r.mask & mask_free_dir))                  /* ADD */
    ansic(9);                                      /* ADD */
  else                                             /* ADD */
    if (fc)
      ansic(2);
  osan(s,abort,&next);


Step 3e
-------

Find "int printfileinfo(uploadsrec *u, int dn)" and add the following lines:


int printfileinfo(uploadsrec *u, int dn)      /* search for */
{
  char s[81];
  double d;
  int abort;
  directoryrec r;                             /* ADD */

  dliscan1(dn);                               /* ADD */
  r=directories[dn];                          /* ADD */
  if (modem_speed)
    d=((double) (((u->numbytes)+127)/128)) *
      (1620.0) /
      ((double) (modem_speed));


Step 3f
-------

A little further down in the same function, add the following lines:


  outstr(get_string(746)); pl(stripfn(u->filename));    /* search for */
  outstr(get_string(747));
  outstr(get_string(748)); npr("%dk\r\n", bytes_to_k(u->numbytes));
  outstr(get_string(749)); pl(ctim(d));
  outstr(get_string(750)); pl(u->date);
  outstr(get_string(751)); pl(u->upby);
  outstr(get_string(752)); pln(u->numdloads);
  if ((u->mask & mask_free_file) || (r.mask & mask_free_dir)) {  /* ADD */
    outstr("Status     : ");                                     /* ADD */
    pl("FREE File");                                             /* ADD */
  }                                                              /* ADD */
  nl();
  abort=0;


Save XFER.C
==============================================================================
Ŀ
 XFEROVL2.C 


Step 4a
-------

Find "int try_to_download(char *s, int dn,int title)" and add the following 
lines: 


int try_to_download(char *s, int dn,int title)   /* search for */
{
  int i,ok,sent,abort=0,next=0,i1,f;
  uploadsrec u;
  char s1[81],s2[81];
  userrec ur;
  directoryrec r;                                /* ADD */

  dliscan1(dn);
  r=directories[dn];                             /* ADD */
  i=recno(s);



Step 4b
-------

A little further down in the same function, add the following lines:


  while ((i>0) && (ok) && (!hangup)) {         /* search for */
    tleft(1);
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    nl();
    if (title) {
      outstr(get_string(784));
      pl(directories[dn].name);             /* DELETE THIS LINE */
      outstr(directories[dn].name);                /* ADD */
      if (r.mask & mask_free_dir)                  /* ADD */
        pl("  4FREE File Directory0");           /* ADD */
      else                                         /* ADD */
        nl();                                      /* ADD */
    }
    if (menu_on()) {
      i1 = rip_printfileinfo(&u,dn);
    } else
      i1=printfileinfo(&u,dn);
    if ((strncmp(u.filename,"WWIV4",5)==0) &&
        (!(sysinfo.flags & OP_FLAGS_NO_EASY_DL)))
      i1=1;
    else {
      if ((!(u.mask & mask_free_file)) ||          /* ADD */
         (!(r.mask & mask_free_dir)))              /* ADD */
        if (!ratio_ok()) {
          rip_restoreall();
          return(-1);
        }
    }
    if (i1) {



Step 4c
-------

Still a little further down in the function, add the following lines:


      sent=0;
      abort=0;
      if (i1==-1)
        send_file(s1,&sent,&abort,u.filetype,u.filename,dn, -2L);
      else
        send_file(s1,&sent,&abort,u.filetype,u.filename,dn, u.numbytes);
      if (sent) {
        if ((!(u.mask & mask_free_file)) ||                /* ADD */
            (!(r.mask & mask_free_dir))) {                 /* ADD */
          ++thisuser.downloaded;
          thisuser.dk += (int) (bytes_to_k(u.numbytes));
        }                                                  /* ADD */
        ++u.numdloads;


Step 4d
-------

Find "void tag_it(void)" and add the following lines: 


void tag_it(void)                                   /* search for */
{
  int i,i1,i2,i3,i4,bad,fp;
  char s[161],s1[161],s2[81],s3[81];
  double t;
  long fs;
  directoryrec r;                                        /* ADD */

  if (numbatch>=sysinfo.max_batch) {
    prt(6,get_string(1325));



Step 4e
-------

A little further down in the same function, add the following lines:


      if (numbatch>=sysinfo.max_batch) {            /* search for */
        ansic(6);
        outstr(get_string(1330));
        npr("%d",sysinfo.max_batch);
        pl(get_string(1331));
        bad=1;
      }
      r=directories[udir[curdir].subnum];                 /* ADD */
      if ((!(filelist[i].u.mask & mask_free_file)) ||     /* ADD */
          (!(r.mask & mask_free_dir)))                    /* ADD */
        if ((syscfg.req_ratio>0.0001)
          && (ratio()<syscfg.req_ratio)
          && (!thisuser.exempt & exempt_ratio)
          && (bad==0)) {
          ansic(2);
          outstr(get_string(730));
          sprintf(s," %-5.3f.  ",ratio());
          outstr(s);
          outstr(get_string(731));
          sprintf(s," %-5.3f ",syscfg.req_ratio);
          outstr(s);
          outstr(get_string(732));
          nl();
          bad=1;
        }
      if (bad==0) {
        sprintf(s,"%s%s",directories[filelist[i].directory].path,
          stripfn(filelist[i].u.filename));



Step 4f
-------

Find "void tag_files(void)" and add the following lines: 


void tag_files(void)                                /* search for */
{
  int i, i1, done=0, abort, had, oh, fc, ohl;
  char s[161],s1[161],s2[81],ch;
  double d;
  directoryrec r;                                         /* ADD */

  fc=thisuser.sysstatus & sysstatus_extra_color;
  if ((lines_listed==0) || (tagging==0) || (num_listed==0))
    return;



Step 4g
-------

A little further down in the same function, add the following lines:


      case 'E':
        lines_listed=0;
        i1=tagging;
        tagging=0;
        prt(2,get_string(1342));
        npr("2%d)? ",tagptr);0
        mpl(2);
        input(s,2);
        i=atoi(s)-1;
        r=directories[udir[filelist[i].directory].subnum];       /* ADD */
        if ((s[0]) && (i>=0) && (i<tagptr)) {
          if (modem_speed)
            d=((double) (((filelist[i].u.numbytes)+127)/128)) *



Step 4h
-------

A little further down in the same function, add the following lines:


            pl(filelist[i].u.upby);                      /* search for */
            ansic(1);
            outstr(get_string(752));
            ansic(2);
            pln(filelist[i].u.numdloads);
            if ((filelist[i].u.mask & mask_free_file) ||      /* ADD */
                (r.mask & mask_free_dir)) {                   /* ADD */
              ansic(1);                                       /* ADD */
              outstr("Status     : ");                        /* ADD */
              ansic(2);                                       /* ADD */
              pl("FREE File");                                /* ADD */
            }                                                 /* ADD */
            if (directories[filelist[i].directory].mask & mask_cdrom) {
              nl();


Save XFEROVL2.C
==============================================================================
Ŀ
 BATCH.C 


Step 5a
-------

Find "void downloaded(char *fn, long cps)" and add the following lines:


void downloaded(char *fn, long cps)                   /* search for */
{
  int i,i1,f;
  uploadsrec u;
  char s[161];
  userrec ur;
  directoryrec r;                                           /* ADD */

  for (i1=0; i1<numbatch; i1++) {
    if ((strcmp(fn,batch[i1].filename)==0) && (batch[i1].sending)) {
      dliscan1(batch[i1].dir);
      r=directories[batch[i1].dir];                         /* ADD */
      i=recno((batch[i1].filename));
      if (i>0) {
        f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
        SETREC(f,i);
        sh_read(f,(void *)&u,sizeof(uploadsrec));
        if ((!(u.mask & mask_free_file)) ||                 /* ADD */
            (!(r.mask & mask_free_dir))) {                  /* ADD */
            ++thisuser.downloaded;
            thisuser.dk += (int) (bytes_to_k(u.numbytes));
        }                                                   /* ADD */
        ++u.numdloads;
        SETREC(f,i);



Step 5b
-------

Find "void batchdl(int mode)" and add the following lines:


void batchdl(int mode)                            /* search for */
{
  int i,done,had,otag;                    /* DELETE THIS LINE */
  int i,i1,i2,f,done,had,otag;                              /* ADD */
  char s[81],ch;
  uploadsrec u;                                             /* ADD */
  directoryrec r;                                           /* ADD */

  done=0;
  if (numbatch==0) {
    nl();



Step 5c
-------

A little further down in the same function, add the following lines:


      case 'D':                                   /* search for */
        if (numbatchdl==0) {
          nl();
          pl(get_string(882));
          nl();
          done=1;
          break;
        }

        nl();
        for (i1=0; i1<numbatch; i1++) {                     /* ADD */
          dliscan1(batch[i1].dir);                          /* ADD */
          r=directories[batch[i1].dir];                     /* ADD */
          i2=recno((batch[i1].filename));                   /* ADD */
          f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);//ADD
          SETREC(f,i2);                                     /* ADD */
          sh_read(f,(void *)&u,sizeof(uploadsrec));         /* ADD */
          f=sh_close(f);                                    /* ADD */
          if ((!(u.mask & mask_free_file)) ||               /* ADD */
              (!(r.mask & mask_free_dir)))                  /* ADD */
            if (!ratio_ok()) {
              nl();
              pl(get_string(883));
              nl();
              done=1;
              break;
            }
        }                                                   /* ADD */
        nl();
        prt(5,get_string(877));



Save BATCH.C
==============================================================================
Ŀ
 DIREDIT.C 


Step 6a
-------

Find "void modify_dir(int n)" and add the following lines:


    outstr(get_string(139)); pl(s);
    outstr(get_string(140)); pl((r.mask&mask_PD)?str_yes:str_no);
    outstr(get_string(141)); pln(r.type);
    outstr(get_string(142));
    pl((r.mask & mask_no_uploads) ? get_string(143) : get_string(115));
    outstr(get_string(144));
    pl((r.mask & mask_archive) ? str_yes : str_no);
    outstr(get_string(1153));
    if (r.mask & mask_cdrom)
      pl(get_string(1154));
    else
      pl(get_string(1155));
    if (r.mask & mask_cdrom) {
      outstr("M. Available  : ");
      if (r.mask & mask_offline)
        pl(str_no);
      else
        pl(str_yes);
    }
    outstr("N. FREE Dir.  : ");                             /* ADD */
    pl((r.mask & mask_free_dir) ? str_yes : str_no);        /* ADD */
    nl();
    prt(2,"Which (A-M,[,],Q) ? ");      /* DELETE THIS LINE */
    ch=onek("QABCDEFGHIJKLM[]");        /* DELETE THIS LINE */
    prt(2,"Which (A-N,[,],Q) ? ");                          /* ADD */
    ch=onek("QABCDEFGHIJKLMN[]");                           /* ADD */
    switch(ch) {
      case 'Q':done=1; break;



Step 6b
-------

A little further down in the same function, add the following lines:


      case 'M':                           /* search for */
        if (r.mask & mask_cdrom) {
          r.mask ^= mask_offline;
        }
      break;
      case 'N':                                   /* ADD */
        r.mask ^= mask_free_dir;                  /* ADD */
      break;                                      /* ADD */
    }
  } while ((!done) && (!hangup));
  directories[n]=r;
}


Save DIREDIT.C
==============================================================================
Ŀ
 BBS.STR 


Step 7
------

>NOTE<


Change string 830 in BBS.STR to read as follows (without the quotes):


"Change info for this file (Y/N/F/Q)? "



Save BBS.STR
==============================================================================

Step 8
------

You must now recompile the ENTIRE BBS because you have added to VARDEC.H.  Any
strings you see in this mod, may be removed and placed in the BBS.STR file,
with the appropritate "get_string(nnn)" added where the string was in the
code.

==============================================================================


If you have any questions about this mod, please feel free to write me at
1@2100 WWIVnet or 1@3459 WWIVlink.
