typedef struct
{
  char *ini;            // Pointer to ini info
  long fsize;           // Current real size of ini
  long allocated;       // Amount of memory currently allocated
  char fname[151];      // Keep our filename saved
  int changes_made;     // 1 if read_ini_????? had to make changes
  int open;
} ini_inforec;

#define EXTRA_INI_SPACE 1500


/* prototypes */

int get_ini_value(char *fname, char *area, char *indent, char *value, int max_value);
int put_ini_value(char *fname, char *area, char *indent, char *value);
int get_ini_number(char *fname, char *area, char *indent, int default_value);
int put_ini_number(char *fname, char *area, char *indent, long value);
int get_ini_boolean(char *fname, char *area, char *indent, char *value);
int read_ini_boolean(ini_inforec *ini_info, char *area, char *indent, char *value);
int read_ini_string(ini_inforec *ini_info, char *area, char *indent, char *value, int max_value);
int look_ini_string(ini_inforec *ini_info, char *area, char *indent, char *value, int max_value);
int look_ini_string_dup(ini_inforec *ini_info, char *area, char *indent, char *value, int max_value, int which);
long read_ini_number(ini_inforec *ini_info, char *area, char *indent, long value);
long look_ini_number(ini_inforec *ini_info, char *area, char *indent, long value);
long look_ini_number_dup(ini_inforec *ini_info, char *area, char *indent, long value, int which);
void set_ini_number(ini_inforec *ini_info, char *area, char *indent, long value);
void set_ini_string(ini_inforec *ini_info, char *area, char *indent, char *value);
void free_ini_info(ini_inforec *ini_info);
int write_ini_file(ini_inforec *ini_info);
char *open_ini_file(char *fname, ini_inforec *ini_info);
char * increase_ini_allocation(ini_inforec *ini_info);
char * get_ini_line(char *buff, int max_len, long *pos, char *ini);
void break_up_ini(char *buff, char *w1, char *w2);
long find_ini_area(char *ini, char *area);
long count_ini_areas(ini_inforec *ini, char *area);
char ** read_ini_areas(ini_inforec *ini, char *area);
long area_exist(ini_inforec *ini, char *area);
int count_ini_indents(ini_inforec *ini_info, char *area, char *indent);
char ** read_ini_indents(ini_inforec *ini, char *area, char *indent);
long ll_read_ini_number(ini_inforec *ini_info, char *area, char *indent, long value, int should_update, int which);
int ll_read_ini_string(ini_inforec *ini_info, char *area, char *indent, char *value, int max_value, int should_update, int which);
void set_ini_string_dup(ini_inforec *ini_info, char *area, char *indent, char *value, int which);
void set_ini_number_dup(ini_inforec *ini_info, char *area, char *indent, long value, int which);


char **alloc_2d(int row, int col, unsigned size);
void free_2d(char **pa);
long filesize(FILE *stream);
char * strip_string(char *string);
